<%inherit file="dialog.tpl"/>

<%block name="blkDialogId">diaDeleteConfirm</%block>

<%block name="blkDialogHeader">
  Move to Trash?
</%block>

<%block name="blkDialogContent">
  <div class="dialog-icon dialog-icon-delete"></div>
  <div class="dialog-right-content-short">
    <div class="dialog-text dialog-text-delete">
    Are you sure you want to move<br><a href="${manageURL}" class="colored-link">${title}</a> to Trash?</div>
    <div class="two-buttons">
      <div><button class="button delete-button" id="deleteYes">Yes</button></div>
      <div><button class="button" id="deleteNo">No</button></div>
    </div>
  </div>
</%block>

<%block name="blkDialogScript">
  diaDeleteConfirmClose.addEventListener('click', function() {
      destroyDialog('diaDeleteConfirm');
  });

  deleteYes.addEventListener('click', function() {
      makeRequest('/delete/?app=${app | u}', null, function(response) {

          navigator.serviceWorker.getRegistrations().then(registrations => {
              for (let reg of registrations) {
                  const swScope = new URL(reg.scope);

                  const APP_MANAGER_PORTS = [8668, 8669, 8670];

                  if (swScope.hostname == 'localhost' && APP_MANAGER_PORTS.indexOf(Number(swScope.port)) > -1 &&
                          swScope.pathname.startsWith('/applications/${app | u}')) {
                      console.log(`Unregistering worker for ${app | u} app`);
                      reg.unregister();
                  }
              }
          });

          const dia = appendDialog(response);
          openDialog(dia);
      });

      destroyDialog('diaDeleteConfirm');
  });

  deleteNo.addEventListener('click', function() {
      destroyDialog('diaDeleteConfirm');
  });

  focusElem('deleteNo');

</%block>
