# Copyright (c) 2017-2025 Soft8Soft, LLC. All rights reserved.
#
# Use of this software is subject to the terms of the Verge3D license
# agreement provided at the time of installation or download, or which
# otherwise accompanies this software in either electronic or hard copy form.
import maya.cmds as cmds
import maya.mel as mel

import clippingPlane
import mayaUtils
import tplUtils

aoBtn = None
aoLayout = None

def maya_useNewAPI():
    pass

def selectAffectedObjects(nodeNameDot, aoBtn):
    sel = cmds.ls(selection=True, sets=True)
    if sel:
        cmds.connectAttr(sel[0] + '.message', nodeNameDot+'affectedObjects', force=True)
        cmds.button(aoBtn, edit=True, label=mayaUtils.getName(sel))

def clippingPlaneButtonNew(nodeNameDot):

    global aoBtn, aoLayout

    if aoBtn and cmds.control(aoBtn, exists=True):
        cmds.deleteUI(aoBtn, control=True)

    aoLayout = cmds.rowLayout(numberOfColumns=2)

    cmds.text(label='Affected Objects')

    def commandCb(*args):
        selectAffectedObjects(nodeNameDot, aoBtn)

    aoSet = clippingPlane.getAffectedObjectsSet(nodeNameDot.strip('.'))
    if cmds.objExists(aoSet):
        aoBtn = cmds.button(label=aoSet, command=commandCb)
    else:
        aoBtn = cmds.button(label='Select Set', command=commandCb)

def clippingPlaneButtonReplace(nodeNameDot):

    global aoBtn, aoLayout

    if aoBtn and cmds.control(aoBtn, exists=True):
        cmds.deleteUI(aoBtn, control=True)

    cmds.setParent(aoLayout)

    def commandCb(*args):
        selectAffectedObjects(nodeNameDot, aoBtn)

    aoSet = clippingPlane.getAffectedObjectsSet(nodeNameDot.strip('.'))
    if cmds.objExists(aoSet):
        aoBtn = cmds.button(label=aoSet, command=commandCb)
    else:
        aoBtn = cmds.button(label='Select Set', command=commandCb)

    cmds.setParent('..')

def onUseCrossSectionChanged(nodeName):
    if cmds.getAttr(nodeName + '.crossSection'):
        cmds.editorTemplate(dimControl=[nodeName, 'crossSectionColor', False])
        cmds.editorTemplate(dimControl=[nodeName, 'crossSectionRenderSide', False])
        cmds.editorTemplate(dimControl=[nodeName, 'crossSectionSize', False])
    else:
        cmds.editorTemplate(dimControl=[nodeName, 'crossSectionColor', True])
        cmds.editorTemplate(dimControl=[nodeName, 'crossSectionRenderSide', True])
        cmds.editorTemplate(dimControl=[nodeName, 'crossSectionSize', True])

def template(nodeName):
    tplUtils.suppressDefaultShapeAttributes()

    cmds.editorTemplate(beginLayout='General Settings', collapse=False)

    cmds.editorTemplate('', callCustom=[clippingPlaneButtonNew, clippingPlaneButtonReplace])

    cmds.editorTemplate('negated', addControl=True)
    cmds.editorTemplate('clipShadows', addControl=True)
    cmds.editorTemplate('unionPlanes', addControl=True)
    cmds.editorTemplate(endLayout=True)

    cmds.editorTemplate(beginLayout='Cross-Section Settings', collapse=False)

    tplUtils.addControlOnChange('crossSection', [__name__, 'onUseCrossSectionChanged'])
    cmds.editorTemplate('crossSectionColor', label='Color', addControl=True)
    cmds.editorTemplate('crossSectionRenderSide', label='Render Side', addControl=True)
    cmds.editorTemplate('crossSectionSize', label='Size', addControl=True)

    cmds.editorTemplate(endLayout=True)

    cmds.editorTemplate(suppress='affectedObjects')

def register(nodeType):
    mel.eval("""
    global proc AE%sTemplate(string $nodeName) {
        python("import %s as tpl");
        python("tpl.template(\\"" + $nodeName + "\\")");
    };""" % (nodeType, __name__))
