import { Clock } from '../core/Clock.js';
import { Color } from '../math/Color.js';

// COMPAT: <4.8, using function instead of class for compatibility with older player.js code
// which used prototype-based inheritanace (i.e. v3d.Preloader.call(this))
function Preloader() {}

Object.assign(Preloader.prototype, {

    onUpdate: function(percentage) {},

    onFinish: function() {}

});


/**
 * parameters = {
 *  container: <HTMLElement|string>
 * }
 */
class SimplePreloader extends Preloader {
    constructor(parameters) {
        super();

        for (let key in parameters) {
            const value = parameters[key];
            switch (key) {
            case 'container':
                if (value === undefined)
                    this.container = document.body;
                else if (value instanceof HTMLElement)
                    this.container = value;
                else
                    this.container = document.getElementById(value);
                break;
            }
        }

        this.bar = document.createElement('div');
        this.bar.setAttribute('class', 'v3d-simple-preloader-bar');

        this.logo = document.createElement('div');
        this.logo.setAttribute('class', 'v3d-simple-preloader-logo');

        this.logoCont = document.createElement('div');
        this.logoCont.setAttribute('id', 'v3d_preloader_container');
        this.logoCont.setAttribute('class', 'v3d-simple-preloader-container');

        this.background = document.createElement('div');
        this.background.setAttribute('class', 'v3d-simple-preloader-background');

        this.background.appendChild(this.logoCont);

        this.logoCont.appendChild(this.logo);
        this.logoCont.appendChild(this.bar);

        this.container.appendChild(this.background);

        this.clock = new Clock();
    }

    onUpdate(percentage) {
        super.onUpdate(percentage);
        percentage = Math.round(percentage);
        this.bar.style.width = percentage + '%';
    }

    onFinish() {
        super.onFinish();
        this.container.removeChild(this.background);
    }

}

export { Preloader, SimplePreloader };
