<div class="toolbar-app">
  % if app['puzzles']:
    <a id="puzzlesButton" href="${app['puzzles']['urls'][0]}" target="_blank" class="toolbar-app-icon toolbar-app-icon-puzzles-edit" title="Edit Puzzles"></a>
  % endif

  <a href="javascript:void(0);" onclick=openFile("${app['url']}") class="toolbar-app-icon toolbar-app-icon-open-folder" title="Open app folder"></a>

  <a href="javascript:void(0);" onclick=appSettings("${app['name'] | u}") class="toolbar-app-icon toolbar-app-icon-settings" title="Open app settings"></a>

  <div class="toolbar-separator"></div>

  <a href="javascript:void(0);" onclick=publishApp("${app['name'] | u}",false) class="toolbar-app-icon toolbar-app-icon-publish-dir" title="Publish on the Web using Verge3D Network"></a>

  <a href="javascript:void(0);" onclick=createZip("${app['name'] | u}") class="toolbar-app-icon toolbar-app-icon-publish-zip" title="Export application to ZIP"></a>

  <a href="javascript:void(0);" onclick=createNativeApp("${app['name'] | u}") class="toolbar-app-icon toolbar-app-icon-create-native-app" title="Create desktop/mobile application template"></a>

  <a href="javascript:void(0);" onclick=createScorm("${app['name'] | u}") class="toolbar-app-icon toolbar-app-icon-create-scorm" title="Create SCORM course"></a>

  <div class="toolbar-separator"></div>

  <a href="javascript:void(0);" onclick=deleteApp("${app['name'] | u}") class="toolbar-app-icon toolbar-app-icon-delete" title="Delete the app"></a>

  % if app['needsUpdate']:
    <a href="javascript:void(0);" onclick=updateApp("${app['name'] | u}",this) class="toolbar-app-icon toolbar-app-icon-update" title="This app requires an update. Click here to do it now!"></a>
  % endif
</div>

% if app['puzzles'] and len(app['puzzles']['urls']) > 1:
<div id="puzzles-launchers-menu" class="hide">
  <ul>
    % for url in app['puzzles']['urls']:
      <li>
        <a href="${url}" target="_blank">puzzles for [${app['puzzles']['urls'].index(url) + 1}]</a>
      </li>
    % endfor
  </ul>
</div>

<script>
const puzzlesButton = document.getElementById('puzzlesButton');
const puzzlesLaunchersMenu = document.getElementById('puzzles-launchers-menu');

puzzlesButton.addEventListener('contextmenu', (event) => {
    event.preventDefault();

    puzzlesLaunchersMenu.style.right = (window.innerWidth - event.clientX) + 'px';
    puzzlesLaunchersMenu.style.top = event.clientY + 'px';

    puzzlesLaunchersMenu.classList.add('show');
});

puzzlesButton.addEventListener('click', (event) => {
});

document.addEventListener('click', (event) => {
    puzzlesLaunchersMenu.classList.remove('show');
});

</script>
% endif

<%include file="dialog_create_zip.tpl"/>
