# Copyright (c) 2017-2026 Soft8Soft, LLC. All rights reserved.
#
# Use of this software is subject to the terms of the Verge3D license
# agreement provided at the time of installation or download, or which
# otherwise accompanies this software in either electronic or hard copy form.
import importlib

import maya.api.OpenMaya as om
import maya.cmds as cmds
import maya.mel as mel

import mayaUtils

def suppressDefaultShapeAttributes():
    """
    Suppress all default node attributes. New Maya versions can get new default
    attributes and can rename/remove the old ones. The corresponding python code
    for a particular Maya version can be generated in Maya's Script Editor with
    the following Python snippet while some shape in the scene is selected (not
    a parent node, but its shape child is the one that should be explicitly
    selected):

import maya.cmds as cmds
attrs = cmds.listAttr()
lines = ["cmds.editorTemplate(suppress='%s')" % attr for attr in attrs]
print('\n'.join(lines))

    """
    version = cmds.about(apiVersion=True) // 10000

    if version >= 2027:
        suppressDefaultShapeAttributes2027()
    elif version == 2026:
        suppressDefaultShapeAttributes2026()
    elif version == 2025:
        suppressDefaultShapeAttributes2025()
    else:
        suppressDefaultShapeAttributes2024()

def suppressDefaultShapeAttributes2027():
    cmds.editorTemplate(suppress='message')
    cmds.editorTemplate(suppress='caching')
    cmds.editorTemplate(suppress='frozen')
    cmds.editorTemplate(suppress='isHistoricallyInteresting')
    cmds.editorTemplate(suppress='nodeState')
    cmds.editorTemplate(suppress='binMembership')
    cmds.editorTemplate(suppress='hyperLayout')
    cmds.editorTemplate(suppress='isCollapsed')
    cmds.editorTemplate(suppress='blackBox')
    cmds.editorTemplate(suppress='borderConnections')
    cmds.editorTemplate(suppress='isHierarchicalConnection')
    cmds.editorTemplate(suppress='publishedNodeInfo')
    cmds.editorTemplate(suppress='publishedNodeInfo.publishedNode')
    cmds.editorTemplate(suppress='publishedNodeInfo.isHierarchicalNode')
    cmds.editorTemplate(suppress='publishedNodeInfo.publishedNodeType')
    cmds.editorTemplate(suppress='rmbCommand')
    cmds.editorTemplate(suppress='templateName')
    cmds.editorTemplate(suppress='templatePath')
    cmds.editorTemplate(suppress='viewName')
    cmds.editorTemplate(suppress='iconName')
    cmds.editorTemplate(suppress='viewMode')
    cmds.editorTemplate(suppress='templateVersion')
    cmds.editorTemplate(suppress='uiTreatment')
    cmds.editorTemplate(suppress='customTreatment')
    cmds.editorTemplate(suppress='creator')
    cmds.editorTemplate(suppress='creationDate')
    cmds.editorTemplate(suppress='containerType')
    cmds.editorTemplate(suppress='boundingBox')
    cmds.editorTemplate(suppress='boundingBoxMin')
    cmds.editorTemplate(suppress='boundingBoxMinX')
    cmds.editorTemplate(suppress='boundingBoxMinY')
    cmds.editorTemplate(suppress='boundingBoxMinZ')
    cmds.editorTemplate(suppress='boundingBoxMax')
    cmds.editorTemplate(suppress='boundingBoxMaxX')
    cmds.editorTemplate(suppress='boundingBoxMaxY')
    cmds.editorTemplate(suppress='boundingBoxMaxZ')
    cmds.editorTemplate(suppress='boundingBoxSize')
    cmds.editorTemplate(suppress='boundingBoxSizeX')
    cmds.editorTemplate(suppress='boundingBoxSizeY')
    cmds.editorTemplate(suppress='boundingBoxSizeZ')
    cmds.editorTemplate(suppress='center')
    cmds.editorTemplate(suppress='boundingBoxCenterX')
    cmds.editorTemplate(suppress='boundingBoxCenterY')
    cmds.editorTemplate(suppress='boundingBoxCenterZ')
    cmds.editorTemplate(suppress='matrix')
    cmds.editorTemplate(suppress='inverseMatrix')
    cmds.editorTemplate(suppress='worldMatrix')
    cmds.editorTemplate(suppress='worldInverseMatrix')
    cmds.editorTemplate(suppress='parentMatrix')
    cmds.editorTemplate(suppress='parentInverseMatrix')
    cmds.editorTemplate(suppress='visibility')
    cmds.editorTemplate(suppress='intermediateObject')
    cmds.editorTemplate(suppress='template')
    cmds.editorTemplate(suppress='instObjGroups')
    cmds.editorTemplate(suppress='instObjGroups.objectGroups')
    cmds.editorTemplate(suppress='instObjGroups.objectGroups.objectGrpCompList')
    cmds.editorTemplate(suppress='instObjGroups.objectGroups.objectGroupId')
    cmds.editorTemplate(suppress='instObjGroups.objectGroups.objectGrpColor')
    cmds.editorTemplate(suppress='objectColorRGB')
    cmds.editorTemplate(suppress='objectColorR')
    cmds.editorTemplate(suppress='objectColorG')
    cmds.editorTemplate(suppress='objectColorB')
    cmds.editorTemplate(suppress='wireColorRGB')
    cmds.editorTemplate(suppress='wireColorR')
    cmds.editorTemplate(suppress='wireColorG')
    cmds.editorTemplate(suppress='wireColorB')
    cmds.editorTemplate(suppress='useObjectColor')
    cmds.editorTemplate(suppress='objectColor')
    cmds.editorTemplate(suppress='drawOverride')
    cmds.editorTemplate(suppress='overrideDisplayType')
    cmds.editorTemplate(suppress='overrideLevelOfDetail')
    cmds.editorTemplate(suppress='overrideShading')
    cmds.editorTemplate(suppress='overrideTexturing')
    cmds.editorTemplate(suppress='overridePlayback')
    cmds.editorTemplate(suppress='overrideEnabled')
    cmds.editorTemplate(suppress='overrideVisibility')
    cmds.editorTemplate(suppress='hideOnPlayback')
    cmds.editorTemplate(suppress='overrideRGBColors')
    cmds.editorTemplate(suppress='overrideColor')
    cmds.editorTemplate(suppress='overrideColorRGB')
    cmds.editorTemplate(suppress='overrideColorR')
    cmds.editorTemplate(suppress='overrideColorG')
    cmds.editorTemplate(suppress='overrideColorB')
    cmds.editorTemplate(suppress='overrideColorA')
    cmds.editorTemplate(suppress='lodVisibility')
    cmds.editorTemplate(suppress='selectionChildHighlighting')
    cmds.editorTemplate(suppress='renderInfo')
    cmds.editorTemplate(suppress='identification')
    cmds.editorTemplate(suppress='layerRenderable')
    cmds.editorTemplate(suppress='layerOverrideColor')
    cmds.editorTemplate(suppress='renderLayerInfo')
    cmds.editorTemplate(suppress='renderLayerInfo.renderLayerId')
    cmds.editorTemplate(suppress='renderLayerInfo.renderLayerRenderable')
    cmds.editorTemplate(suppress='renderLayerInfo.renderLayerColor')
    cmds.editorTemplate(suppress='ghosting')
    cmds.editorTemplate(suppress='ghostingMode')
    cmds.editorTemplate(suppress='ghostCustomSteps')
    cmds.editorTemplate(suppress='ghostPreFrames')
    cmds.editorTemplate(suppress='ghostPostFrames')
    cmds.editorTemplate(suppress='ghostsStep')
    cmds.editorTemplate(suppress='ghostFrames')
    cmds.editorTemplate(suppress='ghostOpacityRange')
    cmds.editorTemplate(suppress='ghostFarOpacity')
    cmds.editorTemplate(suppress='ghostNearOpacity')
    cmds.editorTemplate(suppress='ghostColorPre')
    cmds.editorTemplate(suppress='ghostColorPreR')
    cmds.editorTemplate(suppress='ghostColorPreG')
    cmds.editorTemplate(suppress='ghostColorPreB')
    cmds.editorTemplate(suppress='ghostColorPost')
    cmds.editorTemplate(suppress='ghostColorPostR')
    cmds.editorTemplate(suppress='ghostColorPostG')
    cmds.editorTemplate(suppress='ghostColorPostB')
    cmds.editorTemplate(suppress='ghostDriver')
    cmds.editorTemplate(suppress='ghostUseDriver')
    cmds.editorTemplate(suppress='hiddenInOutliner')
    cmds.editorTemplate(suppress='useOutlinerColor')
    cmds.editorTemplate(suppress='outlinerColor')
    cmds.editorTemplate(suppress='outlinerColorR')
    cmds.editorTemplate(suppress='outlinerColorG')
    cmds.editorTemplate(suppress='outlinerColorB')
    cmds.editorTemplate(suppress='renderType')
    cmds.editorTemplate(suppress='renderVolume')
    cmds.editorTemplate(suppress='visibleFraction')
    cmds.editorTemplate(suppress='hardwareFogMultiplier')
    cmds.editorTemplate(suppress='motionBlur')
    cmds.editorTemplate(suppress='visibleInReflections')
    cmds.editorTemplate(suppress='visibleInRefractions')
    cmds.editorTemplate(suppress='castsShadows')
    cmds.editorTemplate(suppress='receiveShadows')
    cmds.editorTemplate(suppress='asBackground')
    cmds.editorTemplate(suppress='maxVisibilitySamplesOverride')
    cmds.editorTemplate(suppress='maxVisibilitySamples')
    cmds.editorTemplate(suppress='geometryAntialiasingOverride')
    cmds.editorTemplate(suppress='antialiasingLevel')
    cmds.editorTemplate(suppress='shadingSamplesOverride')
    cmds.editorTemplate(suppress='shadingSamples')
    cmds.editorTemplate(suppress='maxShadingSamples')
    cmds.editorTemplate(suppress='volumeSamplesOverride')
    cmds.editorTemplate(suppress='volumeSamples')
    cmds.editorTemplate(suppress='depthJitter')
    cmds.editorTemplate(suppress='ignoreSelfShadowing')
    cmds.editorTemplate(suppress='primaryVisibility')
    cmds.editorTemplate(suppress='referenceObject')
    cmds.editorTemplate(suppress='compInstObjGroups')
    cmds.editorTemplate(suppress='compInstObjGroups.compObjectGroups')
    cmds.editorTemplate(suppress='compInstObjGroups.compObjectGroups.compObjectGrpCompList')
    cmds.editorTemplate(suppress='compInstObjGroups.compObjectGroups.compObjectGroupId')
    cmds.editorTemplate(suppress='componentTags')
    cmds.editorTemplate(suppress='componentTags.componentTagName')
    cmds.editorTemplate(suppress='componentTags.componentTagContents')
    cmds.editorTemplate(suppress='instMaterialAssign')
    cmds.editorTemplate(suppress='pickTexture')
    cmds.editorTemplate(suppress='tweak')
    cmds.editorTemplate(suppress='relativeTweak')
    cmds.editorTemplate(suppress='controlPoints')
    cmds.editorTemplate(suppress='controlPoints.xValue')
    cmds.editorTemplate(suppress='controlPoints.yValue')
    cmds.editorTemplate(suppress='controlPoints.zValue')
    cmds.editorTemplate(suppress='weights')
    cmds.editorTemplate(suppress='tweakLocation')
    cmds.editorTemplate(suppress='blindDataNodes')
    cmds.editorTemplate(suppress='uvPivot')
    cmds.editorTemplate(suppress='uvPivotX')
    cmds.editorTemplate(suppress='uvPivotY')
    cmds.editorTemplate(suppress='uvSet')
    cmds.editorTemplate(suppress='uvSet.uvSetName')
    cmds.editorTemplate(suppress='uvSet.uvSetPoints')
    cmds.editorTemplate(suppress='uvSet.uvSetPoints.uvSetPointsU')
    cmds.editorTemplate(suppress='uvSet.uvSetPoints.uvSetPointsV')
    cmds.editorTemplate(suppress='uvSet.uvSetTweakLocation')
    cmds.editorTemplate(suppress='currentUVSet')
    cmds.editorTemplate(suppress='displayImmediate')
    cmds.editorTemplate(suppress='displayColors')
    cmds.editorTemplate(suppress='displayColorChannel')
    cmds.editorTemplate(suppress='currentColorSet')
    cmds.editorTemplate(suppress='colorSet')
    cmds.editorTemplate(suppress='colorSet.colorName')
    cmds.editorTemplate(suppress='colorSet.clamped')
    cmds.editorTemplate(suppress='colorSet.representation')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints.colorSetPointsR')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints.colorSetPointsG')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints.colorSetPointsB')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints.colorSetPointsA')
    cmds.editorTemplate(suppress='ignoreHwShader')
    cmds.editorTemplate(suppress='doubleSided')
    cmds.editorTemplate(suppress='opposite')
    cmds.editorTemplate(suppress='holdOut')
    cmds.editorTemplate(suppress='smoothShading')
    cmds.editorTemplate(suppress='boundingBoxScale')
    cmds.editorTemplate(suppress='boundingBoxScaleX')
    cmds.editorTemplate(suppress='boundingBoxScaleY')
    cmds.editorTemplate(suppress='boundingBoxScaleZ')
    cmds.editorTemplate(suppress='featureDisplacement')
    cmds.editorTemplate(suppress='initialSampleRate')
    cmds.editorTemplate(suppress='extraSampleRate')
    cmds.editorTemplate(suppress='textureThreshold')
    cmds.editorTemplate(suppress='normalThreshold')
    cmds.editorTemplate(suppress='displayHWEnvironment')
    cmds.editorTemplate(suppress='collisionOffsetVelocityIncrement')
    cmds.editorTemplate(suppress='collisionOffsetVelocityIncrement.collisionOffsetVelocityIncrement_Position')
    cmds.editorTemplate(suppress='collisionOffsetVelocityIncrement.collisionOffsetVelocityIncrement_FloatValue')
    cmds.editorTemplate(suppress='collisionOffsetVelocityIncrement.collisionOffsetVelocityIncrement_Interp')
    cmds.editorTemplate(suppress='collisionDepthVelocityIncrement')
    cmds.editorTemplate(suppress='collisionDepthVelocityIncrement.collisionDepthVelocityIncrement_Position')
    cmds.editorTemplate(suppress='collisionDepthVelocityIncrement.collisionDepthVelocityIncrement_FloatValue')
    cmds.editorTemplate(suppress='collisionDepthVelocityIncrement.collisionDepthVelocityIncrement_Interp')
    cmds.editorTemplate(suppress='collisionOffsetVelocityMultiplier')
    cmds.editorTemplate(suppress='collisionOffsetVelocityMultiplier.collisionOffsetVelocityMultiplier_Position')
    cmds.editorTemplate(suppress='collisionOffsetVelocityMultiplier.collisionOffsetVelocityMultiplier_FloatValue')
    cmds.editorTemplate(suppress='collisionOffsetVelocityMultiplier.collisionOffsetVelocityMultiplier_Interp')
    cmds.editorTemplate(suppress='collisionDepthVelocityMultiplier')
    cmds.editorTemplate(suppress='collisionDepthVelocityMultiplier.collisionDepthVelocityMultiplier_Position')
    cmds.editorTemplate(suppress='collisionDepthVelocityMultiplier.collisionDepthVelocityMultiplier_FloatValue')
    cmds.editorTemplate(suppress='collisionDepthVelocityMultiplier.collisionDepthVelocityMultiplier_Interp')
    cmds.editorTemplate(suppress='inMesh')
    cmds.editorTemplate(suppress='outMesh')
    cmds.editorTemplate(suppress='outGeometryClean')
    cmds.editorTemplate(suppress='cachedInMesh')
    cmds.editorTemplate(suppress='worldMesh')
    cmds.editorTemplate(suppress='outSmoothMesh')
    cmds.editorTemplate(suppress='cachedSmoothMesh')
    cmds.editorTemplate(suppress='smoothWarn')
    cmds.editorTemplate(suppress='smoothLevel')
    cmds.editorTemplate(suppress='smoothDrawType')
    cmds.editorTemplate(suppress='useGlobalSmoothDrawType')
    cmds.editorTemplate(suppress='outSmoothMeshSubdError')
    cmds.editorTemplate(suppress='showDisplacements')
    cmds.editorTemplate(suppress='displacementType')
    cmds.editorTemplate(suppress='loadTiledTextures')
    cmds.editorTemplate(suppress='enableOpenCL')
    cmds.editorTemplate(suppress='smoothTessLevel')
    cmds.editorTemplate(suppress='smoothOsdColorizePatches')
    cmds.editorTemplate(suppress='useOsdBoundaryMethods')
    cmds.editorTemplate(suppress='osdVertBoundary')
    cmds.editorTemplate(suppress='osdFvarBoundary')
    cmds.editorTemplate(suppress='osdFvarPropagateCorners')
    cmds.editorTemplate(suppress='osdSmoothTriangles')
    cmds.editorTemplate(suppress='osdCreaseMethod')
    cmds.editorTemplate(suppress='osdIndependentUVChannels')
    cmds.editorTemplate(suppress='continuity')
    cmds.editorTemplate(suppress='smoothUVs')
    cmds.editorTemplate(suppress='keepBorder')
    cmds.editorTemplate(suppress='boundaryRule')
    cmds.editorTemplate(suppress='keepHardEdge')
    cmds.editorTemplate(suppress='propagateEdgeHardness')
    cmds.editorTemplate(suppress='keepMapBorders')
    cmds.editorTemplate(suppress='smoothOffset')
    cmds.editorTemplate(suppress='sofx')
    cmds.editorTemplate(suppress='sofy')
    cmds.editorTemplate(suppress='sofz')
    cmds.editorTemplate(suppress='displaySubdComps')
    cmds.editorTemplate(suppress='useSmoothPreviewForRender')
    cmds.editorTemplate(suppress='renderSmoothLevel')
    cmds.editorTemplate(suppress='useMaxEdgeLength')
    cmds.editorTemplate(suppress='useMinEdgeLength')
    cmds.editorTemplate(suppress='useMaxSubdivisions')
    cmds.editorTemplate(suppress='useMaxUV')
    cmds.editorTemplate(suppress='useMinScreen')
    cmds.editorTemplate(suppress='useNumTriangles')
    cmds.editorTemplate(suppress='numTriangles')
    cmds.editorTemplate(suppress='maxEdgeLength')
    cmds.editorTemplate(suppress='minEdgeLength')
    cmds.editorTemplate(suppress='maxSubd')
    cmds.editorTemplate(suppress='maxUv')
    cmds.editorTemplate(suppress='minScreen')
    cmds.editorTemplate(suppress='maxTriangles')
    cmds.editorTemplate(suppress='pnts')
    cmds.editorTemplate(suppress='pnts.pntx')
    cmds.editorTemplate(suppress='pnts.pnty')
    cmds.editorTemplate(suppress='pnts.pntz')
    cmds.editorTemplate(suppress='vrts')
    cmds.editorTemplate(suppress='vrts.vrtx')
    cmds.editorTemplate(suppress='vrts.vrty')
    cmds.editorTemplate(suppress='vrts.vrtz')
    cmds.editorTemplate(suppress='edge')
    cmds.editorTemplate(suppress='edge.edg1')
    cmds.editorTemplate(suppress='edge.edg2')
    cmds.editorTemplate(suppress='edge.edgh')
    cmds.editorTemplate(suppress='uvpt')
    cmds.editorTemplate(suppress='uvpt.uvpx')
    cmds.editorTemplate(suppress='uvpt.uvpy')
    cmds.editorTemplate(suppress='colors')
    cmds.editorTemplate(suppress='colors.colorR')
    cmds.editorTemplate(suppress='colors.colorG')
    cmds.editorTemplate(suppress='colors.colorB')
    cmds.editorTemplate(suppress='colors.colorA')
    cmds.editorTemplate(suppress='normals')
    cmds.editorTemplate(suppress='normals.normalx')
    cmds.editorTemplate(suppress='normals.normaly')
    cmds.editorTemplate(suppress='normals.normalz')
    cmds.editorTemplate(suppress='face')
    cmds.editorTemplate(suppress='faceColorIndices')
    cmds.editorTemplate(suppress='creaseData')
    cmds.editorTemplate(suppress='creaseVertexData')
    cmds.editorTemplate(suppress='pinData')
    cmds.editorTemplate(suppress='holeFaceData')
    cmds.editorTemplate(suppress='colorPerVertex')
    cmds.editorTemplate(suppress='vertexColor')
    cmds.editorTemplate(suppress='vertexColor.vertexColorRGB')
    cmds.editorTemplate(suppress='vertexColor.vertexColorR')
    cmds.editorTemplate(suppress='vertexColor.vertexColorG')
    cmds.editorTemplate(suppress='vertexColor.vertexColorB')
    cmds.editorTemplate(suppress='vertexColor.vertexAlpha')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceColorRGB')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceColorR')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceColorG')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceColorB')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceAlpha')
    cmds.editorTemplate(suppress='normalPerVertex')
    cmds.editorTemplate(suppress='vertexNormal')
    cmds.editorTemplate(suppress='vertexNormal.vertexNormalXYZ')
    cmds.editorTemplate(suppress='vertexNormal.vertexNormalX')
    cmds.editorTemplate(suppress='vertexNormal.vertexNormalY')
    cmds.editorTemplate(suppress='vertexNormal.vertexNormalZ')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal.vertexFaceNormalXYZ')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal.vertexFaceNormalX')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal.vertexFaceNormalY')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal.vertexFaceNormalZ')
    cmds.editorTemplate(suppress='displayVertices')
    cmds.editorTemplate(suppress='displayBorders')
    cmds.editorTemplate(suppress='displayMapBorders')
    cmds.editorTemplate(suppress='displayEdges')
    cmds.editorTemplate(suppress='displayFacesWithGroupId')
    cmds.editorTemplate(suppress='displayCenter')
    cmds.editorTemplate(suppress='displayTriangles')
    cmds.editorTemplate(suppress='displayUVs')
    cmds.editorTemplate(suppress='displayItemNumbers')
    cmds.editorTemplate(suppress='displayNonPlanar')
    cmds.editorTemplate(suppress='backfaceCulling')
    cmds.editorTemplate(suppress='vertexBackfaceCulling')
    cmds.editorTemplate(suppress='vertexSize')
    cmds.editorTemplate(suppress='uvSize')
    cmds.editorTemplate(suppress='borderWidth')
    cmds.editorTemplate(suppress='normalSize')
    cmds.editorTemplate(suppress='normalType')
    cmds.editorTemplate(suppress='displayNormal')
    cmds.editorTemplate(suppress='displayTangent')
    cmds.editorTemplate(suppress='tangentSpace')
    cmds.editorTemplate(suppress='tangentSmoothingAngle')
    cmds.editorTemplate(suppress='tangentNormalThreshold')
    cmds.editorTemplate(suppress='allowTopologyMod')
    cmds.editorTemplate(suppress='materialBlend')
    cmds.editorTemplate(suppress='uvTweakLocation')
    cmds.editorTemplate(suppress='userTrg')
    cmds.editorTemplate(suppress='dispResolution')
    cmds.editorTemplate(suppress='vertexIdMap')
    cmds.editorTemplate(suppress='edgeIdMap')
    cmds.editorTemplate(suppress='faceIdMap')
    cmds.editorTemplate(suppress='displaySmoothMesh')
    cmds.editorTemplate(suppress='smoothMeshSelectionMode')
    cmds.editorTemplate(suppress='inForceNodeUVUpdate')
    cmds.editorTemplate(suppress='outForceNodeUVUpdate')
    cmds.editorTemplate(suppress='alwaysDrawOnTop')
    cmds.editorTemplate(suppress='reuseTriangles')
    cmds.editorTemplate(suppress='quadSplit')
    cmds.editorTemplate(suppress='vertexNormalMethod')
    cmds.editorTemplate(suppress='perInstanceIndex')
    cmds.editorTemplate(suppress='perInstanceTag')
    cmds.editorTemplate(suppress='displayAlphaAsGreyScale')
    cmds.editorTemplate(suppress='displayColorAsGreyScale')
    cmds.editorTemplate(suppress='displayRedColorChannel')
    cmds.editorTemplate(suppress='displayGreenColorChannel')
    cmds.editorTemplate(suppress='displayBlueColorChannel')
    cmds.editorTemplate(suppress='displayInvisibleFaces')
    cmds.editorTemplate(suppress='useMeshSculptCache')
    cmds.editorTemplate(suppress='computeFromSculptCache')
    cmds.editorTemplate(suppress='useMeshTexSculptCache')
    cmds.editorTemplate(suppress='freeze')
    cmds.editorTemplate(suppress='motionVectorColorSet')
    cmds.editorTemplate(suppress='vertexColorSource')
    cmds.editorTemplate(suppress='mikktspaceTangentGen')
    cmds.editorTemplate(suppress='aiUserOptions')
    cmds.editorTemplate(suppress='aiSelfShadows')
    cmds.editorTemplate(suppress='aiOpaque')
    cmds.editorTemplate(suppress='aiMatte')
    cmds.editorTemplate(suppress='aiTraceSets')
    cmds.editorTemplate(suppress='aiSssSetname')
    cmds.editorTemplate(suppress='aiToonId')
    cmds.editorTemplate(suppress='aiVisibleInDiffuseReflection')
    cmds.editorTemplate(suppress='aiVisibleInSpecularReflection')
    cmds.editorTemplate(suppress='aiVisibleInDiffuseTransmission')
    cmds.editorTemplate(suppress='aiVisibleInSpecularTransmission')
    cmds.editorTemplate(suppress='aiVisibleInVolume')
    cmds.editorTemplate(suppress='aiSubdivType')
    cmds.editorTemplate(suppress='aiSubdivIterations')
    cmds.editorTemplate(suppress='aiSubdivAdaptiveMetric')
    cmds.editorTemplate(suppress='aiSubdivPixelError')
    cmds.editorTemplate(suppress='aiSubdivAdaptiveSpace')
    cmds.editorTemplate(suppress='aiSubdivUvSmoothing')
    cmds.editorTemplate(suppress='aiSubdivSmoothDerivs')
    cmds.editorTemplate(suppress='aiSubdivFrustumIgnore')
    cmds.editorTemplate(suppress='aiDispHeight')
    cmds.editorTemplate(suppress='aiDispPadding')
    cmds.editorTemplate(suppress='aiDispZeroValue')
    cmds.editorTemplate(suppress='aiDispAutobump')
    cmds.editorTemplate(suppress='aiAutobumpVisibility')
    cmds.editorTemplate(suppress='aiExportTangents')
    cmds.editorTemplate(suppress='aiExportColors')
    cmds.editorTemplate(suppress='aiExportRefPoints')
    cmds.editorTemplate(suppress='aiExportRefNormals')
    cmds.editorTemplate(suppress='aiExportRefTangents')
    cmds.editorTemplate(suppress='aiStepSize')
    cmds.editorTemplate(suppress='aiVolumePadding')
    cmds.editorTemplate(suppress='aiMotionVectorSource')
    cmds.editorTemplate(suppress='aiMotionVectorUnit')
    cmds.editorTemplate(suppress='aiMotionVectorScale')
    cmds.editorTemplate(suppress='dso')
    cmds.editorTemplate(suppress='data')
    cmds.editorTemplate(suppress='aiOverrideLightLinking')
    cmds.editorTemplate(suppress='aiOverrideShaders')
    cmds.editorTemplate(suppress='aiUseFrameExtension')
    cmds.editorTemplate(suppress='aiFrameNumber')
    cmds.editorTemplate(suppress='aiUseSubFrame')
    cmds.editorTemplate(suppress='aiFrameOffset')
    cmds.editorTemplate(suppress='aiOverrideNodes')
    cmds.editorTemplate(suppress='aiNamespace')
    cmds.editorTemplate(suppress='aiOverrideReceiveShadows')
    cmds.editorTemplate(suppress='aiOverrideDoubleSided')
    cmds.editorTemplate(suppress='aiOverrideSelfShadows')
    cmds.editorTemplate(suppress='aiOverrideOpaque')
    cmds.editorTemplate(suppress='aiOverrideMatte')
    cmds.editorTemplate(suppress='aiCastShadows')
    cmds.editorTemplate(suppress='aiShadowDensity')
    cmds.editorTemplate(suppress='aiExposure')
    cmds.editorTemplate(suppress='aiSamples')
    cmds.editorTemplate(suppress='aiNormalize')
    cmds.editorTemplate(suppress='aiFilters')
    cmds.editorTemplate(suppress='aiDiffuse')
    cmds.editorTemplate(suppress='aiSpecular')
    cmds.editorTemplate(suppress='aiSss')
    cmds.editorTemplate(suppress='aiIndirect')
    cmds.editorTemplate(suppress='aiVolume')
    cmds.editorTemplate(suppress='aiMaxBounces')
    cmds.editorTemplate(suppress='aiVolumeSamples')
    cmds.editorTemplate(suppress='aiSamplingMode')
    cmds.editorTemplate(suppress='aiAov')
    cmds.editorTemplate(suppress='aiUseColorTemperature')
    cmds.editorTemplate(suppress='aiColorTemperature')
    cmds.editorTemplate(suppress='aiShadowColor')
    cmds.editorTemplate(suppress='aiShadowColorR')
    cmds.editorTemplate(suppress='aiShadowColorG')
    cmds.editorTemplate(suppress='aiShadowColorB')
    cmds.editorTemplate(suppress='aiCastVolumetricShadows')
    cmds.editorTemplate(suppress='color')
    cmds.editorTemplate(suppress='colorRed')
    cmds.editorTemplate(suppress='colorGreen')
    cmds.editorTemplate(suppress='colorBlue')
    cmds.editorTemplate(suppress='intensity')
    cmds.editorTemplate(suppress='lightVisible')
    cmds.editorTemplate(suppress='aiTranslator')
    cmds.editorTemplate(suppress='v3d')
    cmds.editorTemplate(suppress='renderOrder')
    cmds.editorTemplate(suppress='frustumCulling')
    cmds.editorTemplate(suppress='enableLineRendering')
    cmds.editorTemplate(suppress='lineColor')
    cmds.editorTemplate(suppress='lineColorR')
    cmds.editorTemplate(suppress='lineColorG')
    cmds.editorTemplate(suppress='lineColorB')
    cmds.editorTemplate(suppress='lineWidth')
    cmds.editorTemplate(suppress='lineResolutionSteps')

def suppressDefaultShapeAttributes2026():
    cmds.editorTemplate(suppress='message')
    cmds.editorTemplate(suppress='caching')
    cmds.editorTemplate(suppress='frozen')
    cmds.editorTemplate(suppress='isHistoricallyInteresting')
    cmds.editorTemplate(suppress='nodeState')
    cmds.editorTemplate(suppress='binMembership')
    cmds.editorTemplate(suppress='hyperLayout')
    cmds.editorTemplate(suppress='isCollapsed')
    cmds.editorTemplate(suppress='blackBox')
    cmds.editorTemplate(suppress='borderConnections')
    cmds.editorTemplate(suppress='isHierarchicalConnection')
    cmds.editorTemplate(suppress='publishedNodeInfo')
    cmds.editorTemplate(suppress='publishedNodeInfo.publishedNode')
    cmds.editorTemplate(suppress='publishedNodeInfo.isHierarchicalNode')
    cmds.editorTemplate(suppress='publishedNodeInfo.publishedNodeType')
    cmds.editorTemplate(suppress='rmbCommand')
    cmds.editorTemplate(suppress='templateName')
    cmds.editorTemplate(suppress='templatePath')
    cmds.editorTemplate(suppress='viewName')
    cmds.editorTemplate(suppress='iconName')
    cmds.editorTemplate(suppress='viewMode')
    cmds.editorTemplate(suppress='templateVersion')
    cmds.editorTemplate(suppress='uiTreatment')
    cmds.editorTemplate(suppress='customTreatment')
    cmds.editorTemplate(suppress='creator')
    cmds.editorTemplate(suppress='creationDate')
    cmds.editorTemplate(suppress='containerType')
    cmds.editorTemplate(suppress='boundingBox')
    cmds.editorTemplate(suppress='boundingBoxMin')
    cmds.editorTemplate(suppress='boundingBoxMinX')
    cmds.editorTemplate(suppress='boundingBoxMinY')
    cmds.editorTemplate(suppress='boundingBoxMinZ')
    cmds.editorTemplate(suppress='boundingBoxMax')
    cmds.editorTemplate(suppress='boundingBoxMaxX')
    cmds.editorTemplate(suppress='boundingBoxMaxY')
    cmds.editorTemplate(suppress='boundingBoxMaxZ')
    cmds.editorTemplate(suppress='boundingBoxSize')
    cmds.editorTemplate(suppress='boundingBoxSizeX')
    cmds.editorTemplate(suppress='boundingBoxSizeY')
    cmds.editorTemplate(suppress='boundingBoxSizeZ')
    cmds.editorTemplate(suppress='center')
    cmds.editorTemplate(suppress='boundingBoxCenterX')
    cmds.editorTemplate(suppress='boundingBoxCenterY')
    cmds.editorTemplate(suppress='boundingBoxCenterZ')
    cmds.editorTemplate(suppress='matrix')
    cmds.editorTemplate(suppress='inverseMatrix')
    cmds.editorTemplate(suppress='worldMatrix')
    cmds.editorTemplate(suppress='worldInverseMatrix')
    cmds.editorTemplate(suppress='parentMatrix')
    cmds.editorTemplate(suppress='parentInverseMatrix')
    cmds.editorTemplate(suppress='visibility')
    cmds.editorTemplate(suppress='intermediateObject')
    cmds.editorTemplate(suppress='template')
    cmds.editorTemplate(suppress='instObjGroups')
    cmds.editorTemplate(suppress='instObjGroups.objectGroups')
    cmds.editorTemplate(suppress='instObjGroups.objectGroups.objectGrpCompList')
    cmds.editorTemplate(suppress='instObjGroups.objectGroups.objectGroupId')
    cmds.editorTemplate(suppress='instObjGroups.objectGroups.objectGrpColor')
    cmds.editorTemplate(suppress='objectColorRGB')
    cmds.editorTemplate(suppress='objectColorR')
    cmds.editorTemplate(suppress='objectColorG')
    cmds.editorTemplate(suppress='objectColorB')
    cmds.editorTemplate(suppress='wireColorRGB')
    cmds.editorTemplate(suppress='wireColorR')
    cmds.editorTemplate(suppress='wireColorG')
    cmds.editorTemplate(suppress='wireColorB')
    cmds.editorTemplate(suppress='useObjectColor')
    cmds.editorTemplate(suppress='objectColor')
    cmds.editorTemplate(suppress='drawOverride')
    cmds.editorTemplate(suppress='overrideDisplayType')
    cmds.editorTemplate(suppress='overrideLevelOfDetail')
    cmds.editorTemplate(suppress='overrideShading')
    cmds.editorTemplate(suppress='overrideTexturing')
    cmds.editorTemplate(suppress='overridePlayback')
    cmds.editorTemplate(suppress='overrideEnabled')
    cmds.editorTemplate(suppress='overrideVisibility')
    cmds.editorTemplate(suppress='hideOnPlayback')
    cmds.editorTemplate(suppress='overrideRGBColors')
    cmds.editorTemplate(suppress='overrideColor')
    cmds.editorTemplate(suppress='overrideColorRGB')
    cmds.editorTemplate(suppress='overrideColorR')
    cmds.editorTemplate(suppress='overrideColorG')
    cmds.editorTemplate(suppress='overrideColorB')
    cmds.editorTemplate(suppress='overrideColorA')
    cmds.editorTemplate(suppress='lodVisibility')
    cmds.editorTemplate(suppress='selectionChildHighlighting')
    cmds.editorTemplate(suppress='renderInfo')
    cmds.editorTemplate(suppress='identification')
    cmds.editorTemplate(suppress='layerRenderable')
    cmds.editorTemplate(suppress='layerOverrideColor')
    cmds.editorTemplate(suppress='renderLayerInfo')
    cmds.editorTemplate(suppress='renderLayerInfo.renderLayerId')
    cmds.editorTemplate(suppress='renderLayerInfo.renderLayerRenderable')
    cmds.editorTemplate(suppress='renderLayerInfo.renderLayerColor')
    cmds.editorTemplate(suppress='ghosting')
    cmds.editorTemplate(suppress='ghostingMode')
    cmds.editorTemplate(suppress='ghostCustomSteps')
    cmds.editorTemplate(suppress='ghostPreFrames')
    cmds.editorTemplate(suppress='ghostPostFrames')
    cmds.editorTemplate(suppress='ghostsStep')
    cmds.editorTemplate(suppress='ghostFrames')
    cmds.editorTemplate(suppress='ghostOpacityRange')
    cmds.editorTemplate(suppress='ghostFarOpacity')
    cmds.editorTemplate(suppress='ghostNearOpacity')
    cmds.editorTemplate(suppress='ghostColorPre')
    cmds.editorTemplate(suppress='ghostColorPreR')
    cmds.editorTemplate(suppress='ghostColorPreG')
    cmds.editorTemplate(suppress='ghostColorPreB')
    cmds.editorTemplate(suppress='ghostColorPost')
    cmds.editorTemplate(suppress='ghostColorPostR')
    cmds.editorTemplate(suppress='ghostColorPostG')
    cmds.editorTemplate(suppress='ghostColorPostB')
    cmds.editorTemplate(suppress='ghostDriver')
    cmds.editorTemplate(suppress='ghostUseDriver')
    cmds.editorTemplate(suppress='hiddenInOutliner')
    cmds.editorTemplate(suppress='useOutlinerColor')
    cmds.editorTemplate(suppress='outlinerColor')
    cmds.editorTemplate(suppress='outlinerColorR')
    cmds.editorTemplate(suppress='outlinerColorG')
    cmds.editorTemplate(suppress='outlinerColorB')
    cmds.editorTemplate(suppress='renderType')
    cmds.editorTemplate(suppress='renderVolume')
    cmds.editorTemplate(suppress='visibleFraction')
    cmds.editorTemplate(suppress='hardwareFogMultiplier')
    cmds.editorTemplate(suppress='motionBlur')
    cmds.editorTemplate(suppress='visibleInReflections')
    cmds.editorTemplate(suppress='visibleInRefractions')
    cmds.editorTemplate(suppress='castsShadows')
    cmds.editorTemplate(suppress='receiveShadows')
    cmds.editorTemplate(suppress='asBackground')
    cmds.editorTemplate(suppress='maxVisibilitySamplesOverride')
    cmds.editorTemplate(suppress='maxVisibilitySamples')
    cmds.editorTemplate(suppress='geometryAntialiasingOverride')
    cmds.editorTemplate(suppress='antialiasingLevel')
    cmds.editorTemplate(suppress='shadingSamplesOverride')
    cmds.editorTemplate(suppress='shadingSamples')
    cmds.editorTemplate(suppress='maxShadingSamples')
    cmds.editorTemplate(suppress='volumeSamplesOverride')
    cmds.editorTemplate(suppress='volumeSamples')
    cmds.editorTemplate(suppress='depthJitter')
    cmds.editorTemplate(suppress='ignoreSelfShadowing')
    cmds.editorTemplate(suppress='primaryVisibility')
    cmds.editorTemplate(suppress='referenceObject')
    cmds.editorTemplate(suppress='compInstObjGroups')
    cmds.editorTemplate(suppress='compInstObjGroups.compObjectGroups')
    cmds.editorTemplate(suppress='compInstObjGroups.compObjectGroups.compObjectGrpCompList')
    cmds.editorTemplate(suppress='compInstObjGroups.compObjectGroups.compObjectGroupId')
    cmds.editorTemplate(suppress='componentTags')
    cmds.editorTemplate(suppress='componentTags.componentTagName')
    cmds.editorTemplate(suppress='componentTags.componentTagContents')
    cmds.editorTemplate(suppress='instMaterialAssign')
    cmds.editorTemplate(suppress='pickTexture')
    cmds.editorTemplate(suppress='tweak')
    cmds.editorTemplate(suppress='relativeTweak')
    cmds.editorTemplate(suppress='controlPoints')
    cmds.editorTemplate(suppress='controlPoints.xValue')
    cmds.editorTemplate(suppress='controlPoints.yValue')
    cmds.editorTemplate(suppress='controlPoints.zValue')
    cmds.editorTemplate(suppress='weights')
    cmds.editorTemplate(suppress='tweakLocation')
    cmds.editorTemplate(suppress='blindDataNodes')
    cmds.editorTemplate(suppress='uvPivot')
    cmds.editorTemplate(suppress='uvPivotX')
    cmds.editorTemplate(suppress='uvPivotY')
    cmds.editorTemplate(suppress='uvSet')
    cmds.editorTemplate(suppress='uvSet.uvSetName')
    cmds.editorTemplate(suppress='uvSet.uvSetPoints')
    cmds.editorTemplate(suppress='uvSet.uvSetPoints.uvSetPointsU')
    cmds.editorTemplate(suppress='uvSet.uvSetPoints.uvSetPointsV')
    cmds.editorTemplate(suppress='uvSet.uvSetTweakLocation')
    cmds.editorTemplate(suppress='currentUVSet')
    cmds.editorTemplate(suppress='displayImmediate')
    cmds.editorTemplate(suppress='displayColors')
    cmds.editorTemplate(suppress='displayColorChannel')
    cmds.editorTemplate(suppress='currentColorSet')
    cmds.editorTemplate(suppress='colorSet')
    cmds.editorTemplate(suppress='colorSet.colorName')
    cmds.editorTemplate(suppress='colorSet.clamped')
    cmds.editorTemplate(suppress='colorSet.representation')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints.colorSetPointsR')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints.colorSetPointsG')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints.colorSetPointsB')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints.colorSetPointsA')
    cmds.editorTemplate(suppress='ignoreHwShader')
    cmds.editorTemplate(suppress='doubleSided')
    cmds.editorTemplate(suppress='opposite')
    cmds.editorTemplate(suppress='holdOut')
    cmds.editorTemplate(suppress='smoothShading')
    cmds.editorTemplate(suppress='boundingBoxScale')
    cmds.editorTemplate(suppress='boundingBoxScaleX')
    cmds.editorTemplate(suppress='boundingBoxScaleY')
    cmds.editorTemplate(suppress='boundingBoxScaleZ')
    cmds.editorTemplate(suppress='featureDisplacement')
    cmds.editorTemplate(suppress='initialSampleRate')
    cmds.editorTemplate(suppress='extraSampleRate')
    cmds.editorTemplate(suppress='textureThreshold')
    cmds.editorTemplate(suppress='normalThreshold')
    cmds.editorTemplate(suppress='displayHWEnvironment')
    cmds.editorTemplate(suppress='collisionOffsetVelocityIncrement')
    cmds.editorTemplate(suppress='collisionOffsetVelocityIncrement.collisionOffsetVelocityIncrement_Position')
    cmds.editorTemplate(suppress='collisionOffsetVelocityIncrement.collisionOffsetVelocityIncrement_FloatValue')
    cmds.editorTemplate(suppress='collisionOffsetVelocityIncrement.collisionOffsetVelocityIncrement_Interp')
    cmds.editorTemplate(suppress='collisionDepthVelocityIncrement')
    cmds.editorTemplate(suppress='collisionDepthVelocityIncrement.collisionDepthVelocityIncrement_Position')
    cmds.editorTemplate(suppress='collisionDepthVelocityIncrement.collisionDepthVelocityIncrement_FloatValue')
    cmds.editorTemplate(suppress='collisionDepthVelocityIncrement.collisionDepthVelocityIncrement_Interp')
    cmds.editorTemplate(suppress='collisionOffsetVelocityMultiplier')
    cmds.editorTemplate(suppress='collisionOffsetVelocityMultiplier.collisionOffsetVelocityMultiplier_Position')
    cmds.editorTemplate(suppress='collisionOffsetVelocityMultiplier.collisionOffsetVelocityMultiplier_FloatValue')
    cmds.editorTemplate(suppress='collisionOffsetVelocityMultiplier.collisionOffsetVelocityMultiplier_Interp')
    cmds.editorTemplate(suppress='collisionDepthVelocityMultiplier')
    cmds.editorTemplate(suppress='collisionDepthVelocityMultiplier.collisionDepthVelocityMultiplier_Position')
    cmds.editorTemplate(suppress='collisionDepthVelocityMultiplier.collisionDepthVelocityMultiplier_FloatValue')
    cmds.editorTemplate(suppress='collisionDepthVelocityMultiplier.collisionDepthVelocityMultiplier_Interp')
    cmds.editorTemplate(suppress='inMesh')
    cmds.editorTemplate(suppress='outMesh')
    cmds.editorTemplate(suppress='outGeometryClean')
    cmds.editorTemplate(suppress='cachedInMesh')
    cmds.editorTemplate(suppress='worldMesh')
    cmds.editorTemplate(suppress='outSmoothMesh')
    cmds.editorTemplate(suppress='cachedSmoothMesh')
    cmds.editorTemplate(suppress='smoothWarn')
    cmds.editorTemplate(suppress='smoothLevel')
    cmds.editorTemplate(suppress='smoothDrawType')
    cmds.editorTemplate(suppress='useGlobalSmoothDrawType')
    cmds.editorTemplate(suppress='outSmoothMeshSubdError')
    cmds.editorTemplate(suppress='showDisplacements')
    cmds.editorTemplate(suppress='displacementType')
    cmds.editorTemplate(suppress='loadTiledTextures')
    cmds.editorTemplate(suppress='enableOpenCL')
    cmds.editorTemplate(suppress='smoothTessLevel')
    cmds.editorTemplate(suppress='smoothOsdColorizePatches')
    cmds.editorTemplate(suppress='useOsdBoundaryMethods')
    cmds.editorTemplate(suppress='osdVertBoundary')
    cmds.editorTemplate(suppress='osdFvarBoundary')
    cmds.editorTemplate(suppress='osdFvarPropagateCorners')
    cmds.editorTemplate(suppress='osdSmoothTriangles')
    cmds.editorTemplate(suppress='osdCreaseMethod')
    cmds.editorTemplate(suppress='osdIndependentUVChannels')
    cmds.editorTemplate(suppress='continuity')
    cmds.editorTemplate(suppress='smoothUVs')
    cmds.editorTemplate(suppress='keepBorder')
    cmds.editorTemplate(suppress='boundaryRule')
    cmds.editorTemplate(suppress='keepHardEdge')
    cmds.editorTemplate(suppress='propagateEdgeHardness')
    cmds.editorTemplate(suppress='keepMapBorders')
    cmds.editorTemplate(suppress='smoothOffset')
    cmds.editorTemplate(suppress='sofx')
    cmds.editorTemplate(suppress='sofy')
    cmds.editorTemplate(suppress='sofz')
    cmds.editorTemplate(suppress='displaySubdComps')
    cmds.editorTemplate(suppress='useSmoothPreviewForRender')
    cmds.editorTemplate(suppress='renderSmoothLevel')
    cmds.editorTemplate(suppress='useMaxEdgeLength')
    cmds.editorTemplate(suppress='useMinEdgeLength')
    cmds.editorTemplate(suppress='useMaxSubdivisions')
    cmds.editorTemplate(suppress='useMaxUV')
    cmds.editorTemplate(suppress='useMinScreen')
    cmds.editorTemplate(suppress='useNumTriangles')
    cmds.editorTemplate(suppress='numTriangles')
    cmds.editorTemplate(suppress='maxEdgeLength')
    cmds.editorTemplate(suppress='minEdgeLength')
    cmds.editorTemplate(suppress='maxSubd')
    cmds.editorTemplate(suppress='maxUv')
    cmds.editorTemplate(suppress='minScreen')
    cmds.editorTemplate(suppress='maxTriangles')
    cmds.editorTemplate(suppress='pnts')
    cmds.editorTemplate(suppress='pnts.pntx')
    cmds.editorTemplate(suppress='pnts.pnty')
    cmds.editorTemplate(suppress='pnts.pntz')
    cmds.editorTemplate(suppress='vrts')
    cmds.editorTemplate(suppress='vrts.vrtx')
    cmds.editorTemplate(suppress='vrts.vrty')
    cmds.editorTemplate(suppress='vrts.vrtz')
    cmds.editorTemplate(suppress='edge')
    cmds.editorTemplate(suppress='edge.edg1')
    cmds.editorTemplate(suppress='edge.edg2')
    cmds.editorTemplate(suppress='edge.edgh')
    cmds.editorTemplate(suppress='uvpt')
    cmds.editorTemplate(suppress='uvpt.uvpx')
    cmds.editorTemplate(suppress='uvpt.uvpy')
    cmds.editorTemplate(suppress='colors')
    cmds.editorTemplate(suppress='colors.colorR')
    cmds.editorTemplate(suppress='colors.colorG')
    cmds.editorTemplate(suppress='colors.colorB')
    cmds.editorTemplate(suppress='colors.colorA')
    cmds.editorTemplate(suppress='normals')
    cmds.editorTemplate(suppress='normals.normalx')
    cmds.editorTemplate(suppress='normals.normaly')
    cmds.editorTemplate(suppress='normals.normalz')
    cmds.editorTemplate(suppress='face')
    cmds.editorTemplate(suppress='faceColorIndices')
    cmds.editorTemplate(suppress='creaseData')
    cmds.editorTemplate(suppress='creaseVertexData')
    cmds.editorTemplate(suppress='pinData')
    cmds.editorTemplate(suppress='holeFaceData')
    cmds.editorTemplate(suppress='colorPerVertex')
    cmds.editorTemplate(suppress='vertexColor')
    cmds.editorTemplate(suppress='vertexColor.vertexColorRGB')
    cmds.editorTemplate(suppress='vertexColor.vertexColorR')
    cmds.editorTemplate(suppress='vertexColor.vertexColorG')
    cmds.editorTemplate(suppress='vertexColor.vertexColorB')
    cmds.editorTemplate(suppress='vertexColor.vertexAlpha')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceColorRGB')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceColorR')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceColorG')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceColorB')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceAlpha')
    cmds.editorTemplate(suppress='normalPerVertex')
    cmds.editorTemplate(suppress='vertexNormal')
    cmds.editorTemplate(suppress='vertexNormal.vertexNormalXYZ')
    cmds.editorTemplate(suppress='vertexNormal.vertexNormalX')
    cmds.editorTemplate(suppress='vertexNormal.vertexNormalY')
    cmds.editorTemplate(suppress='vertexNormal.vertexNormalZ')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal.vertexFaceNormalXYZ')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal.vertexFaceNormalX')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal.vertexFaceNormalY')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal.vertexFaceNormalZ')
    cmds.editorTemplate(suppress='displayVertices')
    cmds.editorTemplate(suppress='displayBorders')
    cmds.editorTemplate(suppress='displayMapBorders')
    cmds.editorTemplate(suppress='displayEdges')
    cmds.editorTemplate(suppress='displayFacesWithGroupId')
    cmds.editorTemplate(suppress='displayCenter')
    cmds.editorTemplate(suppress='displayTriangles')
    cmds.editorTemplate(suppress='displayUVs')
    cmds.editorTemplate(suppress='displayItemNumbers')
    cmds.editorTemplate(suppress='displayNonPlanar')
    cmds.editorTemplate(suppress='backfaceCulling')
    cmds.editorTemplate(suppress='vertexBackfaceCulling')
    cmds.editorTemplate(suppress='vertexSize')
    cmds.editorTemplate(suppress='uvSize')
    cmds.editorTemplate(suppress='borderWidth')
    cmds.editorTemplate(suppress='normalSize')
    cmds.editorTemplate(suppress='normalType')
    cmds.editorTemplate(suppress='displayNormal')
    cmds.editorTemplate(suppress='displayTangent')
    cmds.editorTemplate(suppress='tangentSpace')
    cmds.editorTemplate(suppress='tangentSmoothingAngle')
    cmds.editorTemplate(suppress='tangentNormalThreshold')
    cmds.editorTemplate(suppress='allowTopologyMod')
    cmds.editorTemplate(suppress='materialBlend')
    cmds.editorTemplate(suppress='uvTweakLocation')
    cmds.editorTemplate(suppress='userTrg')
    cmds.editorTemplate(suppress='dispResolution')
    cmds.editorTemplate(suppress='vertexIdMap')
    cmds.editorTemplate(suppress='edgeIdMap')
    cmds.editorTemplate(suppress='faceIdMap')
    cmds.editorTemplate(suppress='displaySmoothMesh')
    cmds.editorTemplate(suppress='smoothMeshSelectionMode')
    cmds.editorTemplate(suppress='inForceNodeUVUpdate')
    cmds.editorTemplate(suppress='outForceNodeUVUpdate')
    cmds.editorTemplate(suppress='alwaysDrawOnTop')
    cmds.editorTemplate(suppress='reuseTriangles')
    cmds.editorTemplate(suppress='quadSplit')
    cmds.editorTemplate(suppress='vertexNormalMethod')
    cmds.editorTemplate(suppress='perInstanceIndex')
    cmds.editorTemplate(suppress='perInstanceTag')
    cmds.editorTemplate(suppress='displayAlphaAsGreyScale')
    cmds.editorTemplate(suppress='displayColorAsGreyScale')
    cmds.editorTemplate(suppress='displayRedColorChannel')
    cmds.editorTemplate(suppress='displayGreenColorChannel')
    cmds.editorTemplate(suppress='displayBlueColorChannel')
    cmds.editorTemplate(suppress='displayInvisibleFaces')
    cmds.editorTemplate(suppress='useMeshSculptCache')
    cmds.editorTemplate(suppress='computeFromSculptCache')
    cmds.editorTemplate(suppress='useMeshTexSculptCache')
    cmds.editorTemplate(suppress='freeze')
    cmds.editorTemplate(suppress='motionVectorColorSet')
    cmds.editorTemplate(suppress='vertexColorSource')
    cmds.editorTemplate(suppress='mikktspaceTangentGen')
    cmds.editorTemplate(suppress='v3d')
    cmds.editorTemplate(suppress='renderOrder')
    cmds.editorTemplate(suppress='frustumCulling')
    cmds.editorTemplate(suppress='enableLineRendering')
    cmds.editorTemplate(suppress='lineColor')
    cmds.editorTemplate(suppress='lineColorR')
    cmds.editorTemplate(suppress='lineColorG')
    cmds.editorTemplate(suppress='lineColorB')
    cmds.editorTemplate(suppress='lineWidth')
    cmds.editorTemplate(suppress='lineResolutionSteps')
    cmds.editorTemplate(suppress='aiUserOptions')
    cmds.editorTemplate(suppress='dso')
    cmds.editorTemplate(suppress='data')
    cmds.editorTemplate(suppress='aiOverrideLightLinking')
    cmds.editorTemplate(suppress='aiOverrideShaders')
    cmds.editorTemplate(suppress='aiUseFrameExtension')
    cmds.editorTemplate(suppress='aiFrameNumber')
    cmds.editorTemplate(suppress='aiUseSubFrame')
    cmds.editorTemplate(suppress='aiFrameOffset')
    cmds.editorTemplate(suppress='aiOverrideNodes')
    cmds.editorTemplate(suppress='aiNamespace')
    cmds.editorTemplate(suppress='aiOverrideReceiveShadows')
    cmds.editorTemplate(suppress='aiOverrideDoubleSided')
    cmds.editorTemplate(suppress='aiOverrideSelfShadows')
    cmds.editorTemplate(suppress='aiOverrideOpaque')
    cmds.editorTemplate(suppress='aiOverrideMatte')
    cmds.editorTemplate(suppress='aiCastShadows')
    cmds.editorTemplate(suppress='aiShadowDensity')
    cmds.editorTemplate(suppress='aiExposure')
    cmds.editorTemplate(suppress='aiSamples')
    cmds.editorTemplate(suppress='aiNormalize')
    cmds.editorTemplate(suppress='aiFilters')
    cmds.editorTemplate(suppress='aiDiffuse')
    cmds.editorTemplate(suppress='aiSpecular')
    cmds.editorTemplate(suppress='aiSss')
    cmds.editorTemplate(suppress='aiIndirect')
    cmds.editorTemplate(suppress='aiVolume')
    cmds.editorTemplate(suppress='aiMaxBounces')
    cmds.editorTemplate(suppress='aiVolumeSamples')
    cmds.editorTemplate(suppress='aiAov')
    cmds.editorTemplate(suppress='aiUseColorTemperature')
    cmds.editorTemplate(suppress='aiColorTemperature')
    cmds.editorTemplate(suppress='aiShadowColor')
    cmds.editorTemplate(suppress='aiShadowColorR')
    cmds.editorTemplate(suppress='aiShadowColorG')
    cmds.editorTemplate(suppress='aiShadowColorB')
    cmds.editorTemplate(suppress='aiCastVolumetricShadows')
    cmds.editorTemplate(suppress='color')
    cmds.editorTemplate(suppress='colorRed')
    cmds.editorTemplate(suppress='colorGreen')
    cmds.editorTemplate(suppress='colorBlue')
    cmds.editorTemplate(suppress='intensity')
    cmds.editorTemplate(suppress='lightVisible')
    cmds.editorTemplate(suppress='aiSelfShadows')
    cmds.editorTemplate(suppress='aiOpaque')
    cmds.editorTemplate(suppress='aiMatte')
    cmds.editorTemplate(suppress='aiTraceSets')
    cmds.editorTemplate(suppress='aiSssSetname')
    cmds.editorTemplate(suppress='aiToonId')
    cmds.editorTemplate(suppress='aiVisibleInDiffuseReflection')
    cmds.editorTemplate(suppress='aiVisibleInSpecularReflection')
    cmds.editorTemplate(suppress='aiVisibleInDiffuseTransmission')
    cmds.editorTemplate(suppress='aiVisibleInSpecularTransmission')
    cmds.editorTemplate(suppress='aiVisibleInVolume')
    cmds.editorTemplate(suppress='aiSubdivType')
    cmds.editorTemplate(suppress='aiSubdivIterations')
    cmds.editorTemplate(suppress='aiSubdivAdaptiveMetric')
    cmds.editorTemplate(suppress='aiSubdivPixelError')
    cmds.editorTemplate(suppress='aiSubdivAdaptiveSpace')
    cmds.editorTemplate(suppress='aiSubdivUvSmoothing')
    cmds.editorTemplate(suppress='aiSubdivSmoothDerivs')
    cmds.editorTemplate(suppress='aiSubdivFrustumIgnore')
    cmds.editorTemplate(suppress='aiDispHeight')
    cmds.editorTemplate(suppress='aiDispPadding')
    cmds.editorTemplate(suppress='aiDispZeroValue')
    cmds.editorTemplate(suppress='aiDispAutobump')
    cmds.editorTemplate(suppress='aiAutobumpVisibility')
    cmds.editorTemplate(suppress='aiExportTangents')
    cmds.editorTemplate(suppress='aiExportColors')
    cmds.editorTemplate(suppress='aiExportRefPoints')
    cmds.editorTemplate(suppress='aiExportRefNormals')
    cmds.editorTemplate(suppress='aiExportRefTangents')
    cmds.editorTemplate(suppress='aiStepSize')
    cmds.editorTemplate(suppress='aiVolumePadding')
    cmds.editorTemplate(suppress='aiMotionVectorSource')
    cmds.editorTemplate(suppress='aiMotionVectorUnit')
    cmds.editorTemplate(suppress='aiMotionVectorScale')
    cmds.editorTemplate(suppress='aiTranslator')

def suppressDefaultShapeAttributes2025():
    cmds.editorTemplate(suppress='message')
    cmds.editorTemplate(suppress='caching')
    cmds.editorTemplate(suppress='frozen')
    cmds.editorTemplate(suppress='isHistoricallyInteresting')
    cmds.editorTemplate(suppress='nodeState')
    cmds.editorTemplate(suppress='binMembership')
    cmds.editorTemplate(suppress='hyperLayout')
    cmds.editorTemplate(suppress='isCollapsed')
    cmds.editorTemplate(suppress='blackBox')
    cmds.editorTemplate(suppress='borderConnections')
    cmds.editorTemplate(suppress='isHierarchicalConnection')
    cmds.editorTemplate(suppress='publishedNodeInfo')
    cmds.editorTemplate(suppress='publishedNodeInfo.publishedNode')
    cmds.editorTemplate(suppress='publishedNodeInfo.isHierarchicalNode')
    cmds.editorTemplate(suppress='publishedNodeInfo.publishedNodeType')
    cmds.editorTemplate(suppress='rmbCommand')
    cmds.editorTemplate(suppress='templateName')
    cmds.editorTemplate(suppress='templatePath')
    cmds.editorTemplate(suppress='viewName')
    cmds.editorTemplate(suppress='iconName')
    cmds.editorTemplate(suppress='viewMode')
    cmds.editorTemplate(suppress='templateVersion')
    cmds.editorTemplate(suppress='uiTreatment')
    cmds.editorTemplate(suppress='customTreatment')
    cmds.editorTemplate(suppress='creator')
    cmds.editorTemplate(suppress='creationDate')
    cmds.editorTemplate(suppress='containerType')
    cmds.editorTemplate(suppress='boundingBox')
    cmds.editorTemplate(suppress='boundingBoxMin')
    cmds.editorTemplate(suppress='boundingBoxMinX')
    cmds.editorTemplate(suppress='boundingBoxMinY')
    cmds.editorTemplate(suppress='boundingBoxMinZ')
    cmds.editorTemplate(suppress='boundingBoxMax')
    cmds.editorTemplate(suppress='boundingBoxMaxX')
    cmds.editorTemplate(suppress='boundingBoxMaxY')
    cmds.editorTemplate(suppress='boundingBoxMaxZ')
    cmds.editorTemplate(suppress='boundingBoxSize')
    cmds.editorTemplate(suppress='boundingBoxSizeX')
    cmds.editorTemplate(suppress='boundingBoxSizeY')
    cmds.editorTemplate(suppress='boundingBoxSizeZ')
    cmds.editorTemplate(suppress='center')
    cmds.editorTemplate(suppress='boundingBoxCenterX')
    cmds.editorTemplate(suppress='boundingBoxCenterY')
    cmds.editorTemplate(suppress='boundingBoxCenterZ')
    cmds.editorTemplate(suppress='matrix')
    cmds.editorTemplate(suppress='inverseMatrix')
    cmds.editorTemplate(suppress='worldMatrix')
    cmds.editorTemplate(suppress='worldInverseMatrix')
    cmds.editorTemplate(suppress='parentMatrix')
    cmds.editorTemplate(suppress='parentInverseMatrix')
    cmds.editorTemplate(suppress='visibility')
    cmds.editorTemplate(suppress='intermediateObject')
    cmds.editorTemplate(suppress='template')
    cmds.editorTemplate(suppress='instObjGroups')
    cmds.editorTemplate(suppress='instObjGroups.objectGroups')
    cmds.editorTemplate(suppress='instObjGroups.objectGroups.objectGrpCompList')
    cmds.editorTemplate(suppress='instObjGroups.objectGroups.objectGroupId')
    cmds.editorTemplate(suppress='instObjGroups.objectGroups.objectGrpColor')
    cmds.editorTemplate(suppress='objectColorRGB')
    cmds.editorTemplate(suppress='objectColorR')
    cmds.editorTemplate(suppress='objectColorG')
    cmds.editorTemplate(suppress='objectColorB')
    cmds.editorTemplate(suppress='wireColorRGB')
    cmds.editorTemplate(suppress='wireColorR')
    cmds.editorTemplate(suppress='wireColorG')
    cmds.editorTemplate(suppress='wireColorB')
    cmds.editorTemplate(suppress='useObjectColor')
    cmds.editorTemplate(suppress='objectColor')
    cmds.editorTemplate(suppress='drawOverride')
    cmds.editorTemplate(suppress='overrideDisplayType')
    cmds.editorTemplate(suppress='overrideLevelOfDetail')
    cmds.editorTemplate(suppress='overrideShading')
    cmds.editorTemplate(suppress='overrideTexturing')
    cmds.editorTemplate(suppress='overridePlayback')
    cmds.editorTemplate(suppress='overrideEnabled')
    cmds.editorTemplate(suppress='overrideVisibility')
    cmds.editorTemplate(suppress='hideOnPlayback')
    cmds.editorTemplate(suppress='overrideRGBColors')
    cmds.editorTemplate(suppress='overrideColor')
    cmds.editorTemplate(suppress='overrideColorRGB')
    cmds.editorTemplate(suppress='overrideColorR')
    cmds.editorTemplate(suppress='overrideColorG')
    cmds.editorTemplate(suppress='overrideColorB')
    cmds.editorTemplate(suppress='overrideColorA')
    cmds.editorTemplate(suppress='lodVisibility')
    cmds.editorTemplate(suppress='selectionChildHighlighting')
    cmds.editorTemplate(suppress='renderInfo')
    cmds.editorTemplate(suppress='identification')
    cmds.editorTemplate(suppress='layerRenderable')
    cmds.editorTemplate(suppress='layerOverrideColor')
    cmds.editorTemplate(suppress='renderLayerInfo')
    cmds.editorTemplate(suppress='renderLayerInfo.renderLayerId')
    cmds.editorTemplate(suppress='renderLayerInfo.renderLayerRenderable')
    cmds.editorTemplate(suppress='renderLayerInfo.renderLayerColor')
    cmds.editorTemplate(suppress='ghosting')
    cmds.editorTemplate(suppress='ghostingMode')
    cmds.editorTemplate(suppress='ghostCustomSteps')
    cmds.editorTemplate(suppress='ghostPreFrames')
    cmds.editorTemplate(suppress='ghostPostFrames')
    cmds.editorTemplate(suppress='ghostsStep')
    cmds.editorTemplate(suppress='ghostFrames')
    cmds.editorTemplate(suppress='ghostOpacityRange')
    cmds.editorTemplate(suppress='ghostFarOpacity')
    cmds.editorTemplate(suppress='ghostNearOpacity')
    cmds.editorTemplate(suppress='ghostColorPre')
    cmds.editorTemplate(suppress='ghostColorPreR')
    cmds.editorTemplate(suppress='ghostColorPreG')
    cmds.editorTemplate(suppress='ghostColorPreB')
    cmds.editorTemplate(suppress='ghostColorPost')
    cmds.editorTemplate(suppress='ghostColorPostR')
    cmds.editorTemplate(suppress='ghostColorPostG')
    cmds.editorTemplate(suppress='ghostColorPostB')
    cmds.editorTemplate(suppress='ghostDriver')
    cmds.editorTemplate(suppress='ghostUseDriver')
    cmds.editorTemplate(suppress='hiddenInOutliner')
    cmds.editorTemplate(suppress='useOutlinerColor')
    cmds.editorTemplate(suppress='outlinerColor')
    cmds.editorTemplate(suppress='outlinerColorR')
    cmds.editorTemplate(suppress='outlinerColorG')
    cmds.editorTemplate(suppress='outlinerColorB')
    cmds.editorTemplate(suppress='renderType')
    cmds.editorTemplate(suppress='renderVolume')
    cmds.editorTemplate(suppress='visibleFraction')
    cmds.editorTemplate(suppress='hardwareFogMultiplier')
    cmds.editorTemplate(suppress='motionBlur')
    cmds.editorTemplate(suppress='visibleInReflections')
    cmds.editorTemplate(suppress='visibleInRefractions')
    cmds.editorTemplate(suppress='castsShadows')
    cmds.editorTemplate(suppress='receiveShadows')
    cmds.editorTemplate(suppress='asBackground')
    cmds.editorTemplate(suppress='maxVisibilitySamplesOverride')
    cmds.editorTemplate(suppress='maxVisibilitySamples')
    cmds.editorTemplate(suppress='geometryAntialiasingOverride')
    cmds.editorTemplate(suppress='antialiasingLevel')
    cmds.editorTemplate(suppress='shadingSamplesOverride')
    cmds.editorTemplate(suppress='shadingSamples')
    cmds.editorTemplate(suppress='maxShadingSamples')
    cmds.editorTemplate(suppress='volumeSamplesOverride')
    cmds.editorTemplate(suppress='volumeSamples')
    cmds.editorTemplate(suppress='depthJitter')
    cmds.editorTemplate(suppress='ignoreSelfShadowing')
    cmds.editorTemplate(suppress='primaryVisibility')
    cmds.editorTemplate(suppress='referenceObject')
    cmds.editorTemplate(suppress='compInstObjGroups')
    cmds.editorTemplate(suppress='compInstObjGroups.compObjectGroups')
    cmds.editorTemplate(suppress='compInstObjGroups.compObjectGroups.compObjectGrpCompList')
    cmds.editorTemplate(suppress='compInstObjGroups.compObjectGroups.compObjectGroupId')
    cmds.editorTemplate(suppress='componentTags')
    cmds.editorTemplate(suppress='componentTags.componentTagName')
    cmds.editorTemplate(suppress='componentTags.componentTagContents')
    cmds.editorTemplate(suppress='instMaterialAssign')
    cmds.editorTemplate(suppress='pickTexture')
    cmds.editorTemplate(suppress='tweak')
    cmds.editorTemplate(suppress='relativeTweak')
    cmds.editorTemplate(suppress='controlPoints')
    cmds.editorTemplate(suppress='controlPoints.xValue')
    cmds.editorTemplate(suppress='controlPoints.yValue')
    cmds.editorTemplate(suppress='controlPoints.zValue')
    cmds.editorTemplate(suppress='weights')
    cmds.editorTemplate(suppress='tweakLocation')
    cmds.editorTemplate(suppress='blindDataNodes')
    cmds.editorTemplate(suppress='uvPivot')
    cmds.editorTemplate(suppress='uvPivotX')
    cmds.editorTemplate(suppress='uvPivotY')
    cmds.editorTemplate(suppress='uvSet')
    cmds.editorTemplate(suppress='uvSet.uvSetName')
    cmds.editorTemplate(suppress='uvSet.uvSetPoints')
    cmds.editorTemplate(suppress='uvSet.uvSetPoints.uvSetPointsU')
    cmds.editorTemplate(suppress='uvSet.uvSetPoints.uvSetPointsV')
    cmds.editorTemplate(suppress='uvSet.uvSetTweakLocation')
    cmds.editorTemplate(suppress='currentUVSet')
    cmds.editorTemplate(suppress='displayImmediate')
    cmds.editorTemplate(suppress='displayColors')
    cmds.editorTemplate(suppress='displayColorChannel')
    cmds.editorTemplate(suppress='currentColorSet')
    cmds.editorTemplate(suppress='colorSet')
    cmds.editorTemplate(suppress='colorSet.colorName')
    cmds.editorTemplate(suppress='colorSet.clamped')
    cmds.editorTemplate(suppress='colorSet.representation')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints.colorSetPointsR')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints.colorSetPointsG')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints.colorSetPointsB')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints.colorSetPointsA')
    cmds.editorTemplate(suppress='ignoreHwShader')
    cmds.editorTemplate(suppress='doubleSided')
    cmds.editorTemplate(suppress='opposite')
    cmds.editorTemplate(suppress='holdOut')
    cmds.editorTemplate(suppress='smoothShading')
    cmds.editorTemplate(suppress='boundingBoxScale')
    cmds.editorTemplate(suppress='boundingBoxScaleX')
    cmds.editorTemplate(suppress='boundingBoxScaleY')
    cmds.editorTemplate(suppress='boundingBoxScaleZ')
    cmds.editorTemplate(suppress='featureDisplacement')
    cmds.editorTemplate(suppress='initialSampleRate')
    cmds.editorTemplate(suppress='extraSampleRate')
    cmds.editorTemplate(suppress='textureThreshold')
    cmds.editorTemplate(suppress='normalThreshold')
    cmds.editorTemplate(suppress='displayHWEnvironment')
    cmds.editorTemplate(suppress='collisionOffsetVelocityIncrement')
    cmds.editorTemplate(suppress='collisionOffsetVelocityIncrement.collisionOffsetVelocityIncrement_Position')
    cmds.editorTemplate(suppress='collisionOffsetVelocityIncrement.collisionOffsetVelocityIncrement_FloatValue')
    cmds.editorTemplate(suppress='collisionOffsetVelocityIncrement.collisionOffsetVelocityIncrement_Interp')
    cmds.editorTemplate(suppress='collisionDepthVelocityIncrement')
    cmds.editorTemplate(suppress='collisionDepthVelocityIncrement.collisionDepthVelocityIncrement_Position')
    cmds.editorTemplate(suppress='collisionDepthVelocityIncrement.collisionDepthVelocityIncrement_FloatValue')
    cmds.editorTemplate(suppress='collisionDepthVelocityIncrement.collisionDepthVelocityIncrement_Interp')
    cmds.editorTemplate(suppress='collisionOffsetVelocityMultiplier')
    cmds.editorTemplate(suppress='collisionOffsetVelocityMultiplier.collisionOffsetVelocityMultiplier_Position')
    cmds.editorTemplate(suppress='collisionOffsetVelocityMultiplier.collisionOffsetVelocityMultiplier_FloatValue')
    cmds.editorTemplate(suppress='collisionOffsetVelocityMultiplier.collisionOffsetVelocityMultiplier_Interp')
    cmds.editorTemplate(suppress='collisionDepthVelocityMultiplier')
    cmds.editorTemplate(suppress='collisionDepthVelocityMultiplier.collisionDepthVelocityMultiplier_Position')
    cmds.editorTemplate(suppress='collisionDepthVelocityMultiplier.collisionDepthVelocityMultiplier_FloatValue')
    cmds.editorTemplate(suppress='collisionDepthVelocityMultiplier.collisionDepthVelocityMultiplier_Interp')
    cmds.editorTemplate(suppress='inMesh')
    cmds.editorTemplate(suppress='outMesh')
    cmds.editorTemplate(suppress='outGeometryClean')
    cmds.editorTemplate(suppress='cachedInMesh')
    cmds.editorTemplate(suppress='worldMesh')
    cmds.editorTemplate(suppress='outSmoothMesh')
    cmds.editorTemplate(suppress='cachedSmoothMesh')
    cmds.editorTemplate(suppress='smoothWarn')
    cmds.editorTemplate(suppress='smoothLevel')
    cmds.editorTemplate(suppress='smoothDrawType')
    cmds.editorTemplate(suppress='useGlobalSmoothDrawType')
    cmds.editorTemplate(suppress='outSmoothMeshSubdError')
    cmds.editorTemplate(suppress='showDisplacements')
    cmds.editorTemplate(suppress='displacementType')
    cmds.editorTemplate(suppress='loadTiledTextures')
    cmds.editorTemplate(suppress='enableOpenCL')
    cmds.editorTemplate(suppress='smoothTessLevel')
    cmds.editorTemplate(suppress='smoothOsdColorizePatches')
    cmds.editorTemplate(suppress='useOsdBoundaryMethods')
    cmds.editorTemplate(suppress='osdVertBoundary')
    cmds.editorTemplate(suppress='osdFvarBoundary')
    cmds.editorTemplate(suppress='osdFvarPropagateCorners')
    cmds.editorTemplate(suppress='osdSmoothTriangles')
    cmds.editorTemplate(suppress='osdCreaseMethod')
    cmds.editorTemplate(suppress='osdIndependentUVChannels')
    cmds.editorTemplate(suppress='continuity')
    cmds.editorTemplate(suppress='smoothUVs')
    cmds.editorTemplate(suppress='keepBorder')
    cmds.editorTemplate(suppress='boundaryRule')
    cmds.editorTemplate(suppress='keepHardEdge')
    cmds.editorTemplate(suppress='propagateEdgeHardness')
    cmds.editorTemplate(suppress='keepMapBorders')
    cmds.editorTemplate(suppress='smoothOffset')
    cmds.editorTemplate(suppress='sofx')
    cmds.editorTemplate(suppress='sofy')
    cmds.editorTemplate(suppress='sofz')
    cmds.editorTemplate(suppress='displaySubdComps')
    cmds.editorTemplate(suppress='useSmoothPreviewForRender')
    cmds.editorTemplate(suppress='renderSmoothLevel')
    cmds.editorTemplate(suppress='useMaxEdgeLength')
    cmds.editorTemplate(suppress='useMinEdgeLength')
    cmds.editorTemplate(suppress='useMaxSubdivisions')
    cmds.editorTemplate(suppress='useMaxUV')
    cmds.editorTemplate(suppress='useMinScreen')
    cmds.editorTemplate(suppress='useNumTriangles')
    cmds.editorTemplate(suppress='numTriangles')
    cmds.editorTemplate(suppress='maxEdgeLength')
    cmds.editorTemplate(suppress='minEdgeLength')
    cmds.editorTemplate(suppress='maxSubd')
    cmds.editorTemplate(suppress='maxUv')
    cmds.editorTemplate(suppress='minScreen')
    cmds.editorTemplate(suppress='maxTriangles')
    cmds.editorTemplate(suppress='pnts')
    cmds.editorTemplate(suppress='pnts.pntx')
    cmds.editorTemplate(suppress='pnts.pnty')
    cmds.editorTemplate(suppress='pnts.pntz')
    cmds.editorTemplate(suppress='vrts')
    cmds.editorTemplate(suppress='vrts.vrtx')
    cmds.editorTemplate(suppress='vrts.vrty')
    cmds.editorTemplate(suppress='vrts.vrtz')
    cmds.editorTemplate(suppress='edge')
    cmds.editorTemplate(suppress='edge.edg1')
    cmds.editorTemplate(suppress='edge.edg2')
    cmds.editorTemplate(suppress='edge.edgh')
    cmds.editorTemplate(suppress='uvpt')
    cmds.editorTemplate(suppress='uvpt.uvpx')
    cmds.editorTemplate(suppress='uvpt.uvpy')
    cmds.editorTemplate(suppress='colors')
    cmds.editorTemplate(suppress='colors.colorR')
    cmds.editorTemplate(suppress='colors.colorG')
    cmds.editorTemplate(suppress='colors.colorB')
    cmds.editorTemplate(suppress='colors.colorA')
    cmds.editorTemplate(suppress='normals')
    cmds.editorTemplate(suppress='normals.normalx')
    cmds.editorTemplate(suppress='normals.normaly')
    cmds.editorTemplate(suppress='normals.normalz')
    cmds.editorTemplate(suppress='face')
    cmds.editorTemplate(suppress='faceColorIndices')
    cmds.editorTemplate(suppress='creaseData')
    cmds.editorTemplate(suppress='creaseVertexData')
    cmds.editorTemplate(suppress='pinData')
    cmds.editorTemplate(suppress='holeFaceData')
    cmds.editorTemplate(suppress='colorPerVertex')
    cmds.editorTemplate(suppress='vertexColor')
    cmds.editorTemplate(suppress='vertexColor.vertexColorRGB')
    cmds.editorTemplate(suppress='vertexColor.vertexColorR')
    cmds.editorTemplate(suppress='vertexColor.vertexColorG')
    cmds.editorTemplate(suppress='vertexColor.vertexColorB')
    cmds.editorTemplate(suppress='vertexColor.vertexAlpha')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceColorRGB')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceColorR')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceColorG')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceColorB')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceAlpha')
    cmds.editorTemplate(suppress='normalPerVertex')
    cmds.editorTemplate(suppress='vertexNormal')
    cmds.editorTemplate(suppress='vertexNormal.vertexNormalXYZ')
    cmds.editorTemplate(suppress='vertexNormal.vertexNormalX')
    cmds.editorTemplate(suppress='vertexNormal.vertexNormalY')
    cmds.editorTemplate(suppress='vertexNormal.vertexNormalZ')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal.vertexFaceNormalXYZ')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal.vertexFaceNormalX')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal.vertexFaceNormalY')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal.vertexFaceNormalZ')
    cmds.editorTemplate(suppress='displayVertices')
    cmds.editorTemplate(suppress='displayBorders')
    cmds.editorTemplate(suppress='displayMapBorders')
    cmds.editorTemplate(suppress='displayEdges')
    cmds.editorTemplate(suppress='displayFacesWithGroupId')
    cmds.editorTemplate(suppress='displayCenter')
    cmds.editorTemplate(suppress='displayTriangles')
    cmds.editorTemplate(suppress='displayUVs')
    cmds.editorTemplate(suppress='displayItemNumbers')
    cmds.editorTemplate(suppress='displayNonPlanar')
    cmds.editorTemplate(suppress='backfaceCulling')
    cmds.editorTemplate(suppress='vertexBackfaceCulling')
    cmds.editorTemplate(suppress='vertexSize')
    cmds.editorTemplate(suppress='uvSize')
    cmds.editorTemplate(suppress='borderWidth')
    cmds.editorTemplate(suppress='normalSize')
    cmds.editorTemplate(suppress='normalType')
    cmds.editorTemplate(suppress='displayNormal')
    cmds.editorTemplate(suppress='displayTangent')
    cmds.editorTemplate(suppress='tangentSpace')
    cmds.editorTemplate(suppress='tangentSmoothingAngle')
    cmds.editorTemplate(suppress='tangentNormalThreshold')
    cmds.editorTemplate(suppress='allowTopologyMod')
    cmds.editorTemplate(suppress='materialBlend')
    cmds.editorTemplate(suppress='uvTweakLocation')
    cmds.editorTemplate(suppress='userTrg')
    cmds.editorTemplate(suppress='dispResolution')
    cmds.editorTemplate(suppress='vertexIdMap')
    cmds.editorTemplate(suppress='edgeIdMap')
    cmds.editorTemplate(suppress='faceIdMap')
    cmds.editorTemplate(suppress='displaySmoothMesh')
    cmds.editorTemplate(suppress='smoothMeshSelectionMode')
    cmds.editorTemplate(suppress='inForceNodeUVUpdate')
    cmds.editorTemplate(suppress='outForceNodeUVUpdate')
    cmds.editorTemplate(suppress='alwaysDrawOnTop')
    cmds.editorTemplate(suppress='reuseTriangles')
    cmds.editorTemplate(suppress='quadSplit')
    cmds.editorTemplate(suppress='vertexNormalMethod')
    cmds.editorTemplate(suppress='perInstanceIndex')
    cmds.editorTemplate(suppress='perInstanceTag')
    cmds.editorTemplate(suppress='displayAlphaAsGreyScale')
    cmds.editorTemplate(suppress='displayColorAsGreyScale')
    cmds.editorTemplate(suppress='displayRedColorChannel')
    cmds.editorTemplate(suppress='displayGreenColorChannel')
    cmds.editorTemplate(suppress='displayBlueColorChannel')
    cmds.editorTemplate(suppress='displayInvisibleFaces')
    cmds.editorTemplate(suppress='useMeshSculptCache')
    cmds.editorTemplate(suppress='computeFromSculptCache')
    cmds.editorTemplate(suppress='useMeshTexSculptCache')
    cmds.editorTemplate(suppress='freeze')
    cmds.editorTemplate(suppress='motionVectorColorSet')
    cmds.editorTemplate(suppress='vertexColorSource')
    cmds.editorTemplate(suppress='mikktspaceTangentGen')
    cmds.editorTemplate(suppress='v3d')
    cmds.editorTemplate(suppress='renderOrder')
    cmds.editorTemplate(suppress='frustumCulling')
    cmds.editorTemplate(suppress='enableLineRendering')
    cmds.editorTemplate(suppress='lineColor')
    cmds.editorTemplate(suppress='lineColorR')
    cmds.editorTemplate(suppress='lineColorG')
    cmds.editorTemplate(suppress='lineColorB')
    cmds.editorTemplate(suppress='lineWidth')
    cmds.editorTemplate(suppress='lineResolutionSteps')
    cmds.editorTemplate(suppress='aiUserOptions')
    cmds.editorTemplate(suppress='aiSelfShadows')
    cmds.editorTemplate(suppress='aiOpaque')
    cmds.editorTemplate(suppress='aiMatte')
    cmds.editorTemplate(suppress='aiTraceSets')
    cmds.editorTemplate(suppress='aiSssSetname')
    cmds.editorTemplate(suppress='aiToonId')
    cmds.editorTemplate(suppress='aiVisibleInDiffuseReflection')
    cmds.editorTemplate(suppress='aiVisibleInSpecularReflection')
    cmds.editorTemplate(suppress='aiVisibleInDiffuseTransmission')
    cmds.editorTemplate(suppress='aiVisibleInSpecularTransmission')
    cmds.editorTemplate(suppress='aiVisibleInVolume')
    cmds.editorTemplate(suppress='aiSubdivType')
    cmds.editorTemplate(suppress='aiSubdivIterations')
    cmds.editorTemplate(suppress='aiSubdivAdaptiveMetric')
    cmds.editorTemplate(suppress='aiSubdivPixelError')
    cmds.editorTemplate(suppress='aiSubdivAdaptiveSpace')
    cmds.editorTemplate(suppress='aiSubdivUvSmoothing')
    cmds.editorTemplate(suppress='aiSubdivSmoothDerivs')
    cmds.editorTemplate(suppress='aiSubdivFrustumIgnore')
    cmds.editorTemplate(suppress='aiDispHeight')
    cmds.editorTemplate(suppress='aiDispPadding')
    cmds.editorTemplate(suppress='aiDispZeroValue')
    cmds.editorTemplate(suppress='aiDispAutobump')
    cmds.editorTemplate(suppress='aiAutobumpVisibility')
    cmds.editorTemplate(suppress='aiExportTangents')
    cmds.editorTemplate(suppress='aiExportColors')
    cmds.editorTemplate(suppress='aiExportRefPoints')
    cmds.editorTemplate(suppress='aiExportRefNormals')
    cmds.editorTemplate(suppress='aiExportRefTangents')
    cmds.editorTemplate(suppress='aiStepSize')
    cmds.editorTemplate(suppress='aiVolumePadding')
    cmds.editorTemplate(suppress='aiMotionVectorSource')
    cmds.editorTemplate(suppress='aiMotionVectorUnit')
    cmds.editorTemplate(suppress='aiMotionVectorScale')
    cmds.editorTemplate(suppress='dso')
    cmds.editorTemplate(suppress='data')
    cmds.editorTemplate(suppress='aiOverrideLightLinking')
    cmds.editorTemplate(suppress='aiOverrideShaders')
    cmds.editorTemplate(suppress='aiUseFrameExtension')
    cmds.editorTemplate(suppress='aiFrameNumber')
    cmds.editorTemplate(suppress='aiUseSubFrame')
    cmds.editorTemplate(suppress='aiFrameOffset')
    cmds.editorTemplate(suppress='aiOverrideNodes')
    cmds.editorTemplate(suppress='aiNamespace')
    cmds.editorTemplate(suppress='aiOverrideReceiveShadows')
    cmds.editorTemplate(suppress='aiOverrideDoubleSided')
    cmds.editorTemplate(suppress='aiOverrideSelfShadows')
    cmds.editorTemplate(suppress='aiOverrideOpaque')
    cmds.editorTemplate(suppress='aiOverrideMatte')
    cmds.editorTemplate(suppress='aiCastShadows')
    cmds.editorTemplate(suppress='aiShadowDensity')
    cmds.editorTemplate(suppress='aiExposure')
    cmds.editorTemplate(suppress='aiSamples')
    cmds.editorTemplate(suppress='aiNormalize')
    cmds.editorTemplate(suppress='aiFilters')
    cmds.editorTemplate(suppress='aiDiffuse')
    cmds.editorTemplate(suppress='aiSpecular')
    cmds.editorTemplate(suppress='aiSss')
    cmds.editorTemplate(suppress='aiIndirect')
    cmds.editorTemplate(suppress='aiVolume')
    cmds.editorTemplate(suppress='aiMaxBounces')
    cmds.editorTemplate(suppress='aiVolumeSamples')
    cmds.editorTemplate(suppress='aiAov')
    cmds.editorTemplate(suppress='aiUseColorTemperature')
    cmds.editorTemplate(suppress='aiColorTemperature')
    cmds.editorTemplate(suppress='aiShadowColor')
    cmds.editorTemplate(suppress='aiShadowColorR')
    cmds.editorTemplate(suppress='aiShadowColorG')
    cmds.editorTemplate(suppress='aiShadowColorB')
    cmds.editorTemplate(suppress='aiCastVolumetricShadows')
    cmds.editorTemplate(suppress='color')
    cmds.editorTemplate(suppress='colorRed')
    cmds.editorTemplate(suppress='colorGreen')
    cmds.editorTemplate(suppress='colorBlue')
    cmds.editorTemplate(suppress='intensity')
    cmds.editorTemplate(suppress='lightVisible')
    cmds.editorTemplate(suppress='aiTranslator')

def suppressDefaultShapeAttributes2024():
    cmds.editorTemplate(suppress='message')
    cmds.editorTemplate(suppress='caching')
    cmds.editorTemplate(suppress='frozen')
    cmds.editorTemplate(suppress='isHistoricallyInteresting')
    cmds.editorTemplate(suppress='nodeState')
    cmds.editorTemplate(suppress='binMembership')
    cmds.editorTemplate(suppress='hyperLayout')
    cmds.editorTemplate(suppress='isCollapsed')
    cmds.editorTemplate(suppress='blackBox')
    cmds.editorTemplate(suppress='borderConnections')
    cmds.editorTemplate(suppress='isHierarchicalConnection')
    cmds.editorTemplate(suppress='publishedNodeInfo')
    cmds.editorTemplate(suppress='publishedNodeInfo.publishedNode')
    cmds.editorTemplate(suppress='publishedNodeInfo.isHierarchicalNode')
    cmds.editorTemplate(suppress='publishedNodeInfo.publishedNodeType')
    cmds.editorTemplate(suppress='rmbCommand')
    cmds.editorTemplate(suppress='templateName')
    cmds.editorTemplate(suppress='templatePath')
    cmds.editorTemplate(suppress='viewName')
    cmds.editorTemplate(suppress='iconName')
    cmds.editorTemplate(suppress='viewMode')
    cmds.editorTemplate(suppress='templateVersion')
    cmds.editorTemplate(suppress='uiTreatment')
    cmds.editorTemplate(suppress='customTreatment')
    cmds.editorTemplate(suppress='creator')
    cmds.editorTemplate(suppress='creationDate')
    cmds.editorTemplate(suppress='containerType')
    cmds.editorTemplate(suppress='boundingBox')
    cmds.editorTemplate(suppress='boundingBoxMin')
    cmds.editorTemplate(suppress='boundingBoxMinX')
    cmds.editorTemplate(suppress='boundingBoxMinY')
    cmds.editorTemplate(suppress='boundingBoxMinZ')
    cmds.editorTemplate(suppress='boundingBoxMax')
    cmds.editorTemplate(suppress='boundingBoxMaxX')
    cmds.editorTemplate(suppress='boundingBoxMaxY')
    cmds.editorTemplate(suppress='boundingBoxMaxZ')
    cmds.editorTemplate(suppress='boundingBoxSize')
    cmds.editorTemplate(suppress='boundingBoxSizeX')
    cmds.editorTemplate(suppress='boundingBoxSizeY')
    cmds.editorTemplate(suppress='boundingBoxSizeZ')
    cmds.editorTemplate(suppress='center')
    cmds.editorTemplate(suppress='boundingBoxCenterX')
    cmds.editorTemplate(suppress='boundingBoxCenterY')
    cmds.editorTemplate(suppress='boundingBoxCenterZ')
    cmds.editorTemplate(suppress='matrix')
    cmds.editorTemplate(suppress='inverseMatrix')
    cmds.editorTemplate(suppress='worldMatrix')
    cmds.editorTemplate(suppress='worldInverseMatrix')
    cmds.editorTemplate(suppress='parentMatrix')
    cmds.editorTemplate(suppress='parentInverseMatrix')
    cmds.editorTemplate(suppress='visibility')
    cmds.editorTemplate(suppress='intermediateObject')
    cmds.editorTemplate(suppress='template')
    cmds.editorTemplate(suppress='instObjGroups')
    cmds.editorTemplate(suppress='instObjGroups.objectGroups')
    cmds.editorTemplate(suppress='instObjGroups.objectGroups.objectGrpCompList')
    cmds.editorTemplate(suppress='instObjGroups.objectGroups.objectGroupId')
    cmds.editorTemplate(suppress='instObjGroups.objectGroups.objectGrpColor')
    cmds.editorTemplate(suppress='objectColorRGB')
    cmds.editorTemplate(suppress='objectColorR')
    cmds.editorTemplate(suppress='objectColorG')
    cmds.editorTemplate(suppress='objectColorB')
    cmds.editorTemplate(suppress='wireColorRGB')
    cmds.editorTemplate(suppress='wireColorR')
    cmds.editorTemplate(suppress='wireColorG')
    cmds.editorTemplate(suppress='wireColorB')
    cmds.editorTemplate(suppress='useObjectColor')
    cmds.editorTemplate(suppress='objectColor')
    cmds.editorTemplate(suppress='drawOverride')
    cmds.editorTemplate(suppress='overrideDisplayType')
    cmds.editorTemplate(suppress='overrideLevelOfDetail')
    cmds.editorTemplate(suppress='overrideShading')
    cmds.editorTemplate(suppress='overrideTexturing')
    cmds.editorTemplate(suppress='overridePlayback')
    cmds.editorTemplate(suppress='overrideEnabled')
    cmds.editorTemplate(suppress='overrideVisibility')
    cmds.editorTemplate(suppress='hideOnPlayback')
    cmds.editorTemplate(suppress='overrideRGBColors')
    cmds.editorTemplate(suppress='overrideColor')
    cmds.editorTemplate(suppress='overrideColorRGB')
    cmds.editorTemplate(suppress='overrideColorR')
    cmds.editorTemplate(suppress='overrideColorG')
    cmds.editorTemplate(suppress='overrideColorB')
    cmds.editorTemplate(suppress='overrideColorA')
    cmds.editorTemplate(suppress='lodVisibility')
    cmds.editorTemplate(suppress='selectionChildHighlighting')
    cmds.editorTemplate(suppress='renderInfo')
    cmds.editorTemplate(suppress='identification')
    cmds.editorTemplate(suppress='layerRenderable')
    cmds.editorTemplate(suppress='layerOverrideColor')
    cmds.editorTemplate(suppress='renderLayerInfo')
    cmds.editorTemplate(suppress='renderLayerInfo.renderLayerId')
    cmds.editorTemplate(suppress='renderLayerInfo.renderLayerRenderable')
    cmds.editorTemplate(suppress='renderLayerInfo.renderLayerColor')
    cmds.editorTemplate(suppress='ghosting')
    cmds.editorTemplate(suppress='ghostingMode')
    cmds.editorTemplate(suppress='ghostCustomSteps')
    cmds.editorTemplate(suppress='ghostPreFrames')
    cmds.editorTemplate(suppress='ghostPostFrames')
    cmds.editorTemplate(suppress='ghostsStep')
    cmds.editorTemplate(suppress='ghostFrames')
    cmds.editorTemplate(suppress='ghostOpacityRange')
    cmds.editorTemplate(suppress='ghostFarOpacity')
    cmds.editorTemplate(suppress='ghostNearOpacity')
    cmds.editorTemplate(suppress='ghostColorPre')
    cmds.editorTemplate(suppress='ghostColorPreR')
    cmds.editorTemplate(suppress='ghostColorPreG')
    cmds.editorTemplate(suppress='ghostColorPreB')
    cmds.editorTemplate(suppress='ghostColorPost')
    cmds.editorTemplate(suppress='ghostColorPostR')
    cmds.editorTemplate(suppress='ghostColorPostG')
    cmds.editorTemplate(suppress='ghostColorPostB')
    cmds.editorTemplate(suppress='ghostDriver')
    cmds.editorTemplate(suppress='ghostUseDriver')
    cmds.editorTemplate(suppress='hiddenInOutliner')
    cmds.editorTemplate(suppress='useOutlinerColor')
    cmds.editorTemplate(suppress='outlinerColor')
    cmds.editorTemplate(suppress='outlinerColorR')
    cmds.editorTemplate(suppress='outlinerColorG')
    cmds.editorTemplate(suppress='outlinerColorB')
    cmds.editorTemplate(suppress='renderType')
    cmds.editorTemplate(suppress='renderVolume')
    cmds.editorTemplate(suppress='visibleFraction')
    cmds.editorTemplate(suppress='hardwareFogMultiplier')
    cmds.editorTemplate(suppress='motionBlur')
    cmds.editorTemplate(suppress='visibleInReflections')
    cmds.editorTemplate(suppress='visibleInRefractions')
    cmds.editorTemplate(suppress='castsShadows')
    cmds.editorTemplate(suppress='receiveShadows')
    cmds.editorTemplate(suppress='asBackground')
    cmds.editorTemplate(suppress='maxVisibilitySamplesOverride')
    cmds.editorTemplate(suppress='maxVisibilitySamples')
    cmds.editorTemplate(suppress='geometryAntialiasingOverride')
    cmds.editorTemplate(suppress='antialiasingLevel')
    cmds.editorTemplate(suppress='shadingSamplesOverride')
    cmds.editorTemplate(suppress='shadingSamples')
    cmds.editorTemplate(suppress='maxShadingSamples')
    cmds.editorTemplate(suppress='volumeSamplesOverride')
    cmds.editorTemplate(suppress='volumeSamples')
    cmds.editorTemplate(suppress='depthJitter')
    cmds.editorTemplate(suppress='ignoreSelfShadowing')
    cmds.editorTemplate(suppress='primaryVisibility')
    cmds.editorTemplate(suppress='referenceObject')
    cmds.editorTemplate(suppress='compInstObjGroups')
    cmds.editorTemplate(suppress='compInstObjGroups.compObjectGroups')
    cmds.editorTemplate(suppress='compInstObjGroups.compObjectGroups.compObjectGrpCompList')
    cmds.editorTemplate(suppress='compInstObjGroups.compObjectGroups.compObjectGroupId')
    cmds.editorTemplate(suppress='componentTags')
    cmds.editorTemplate(suppress='componentTags.componentTagName')
    cmds.editorTemplate(suppress='componentTags.componentTagContents')
    cmds.editorTemplate(suppress='instMaterialAssign')
    cmds.editorTemplate(suppress='pickTexture')
    cmds.editorTemplate(suppress='tweak')
    cmds.editorTemplate(suppress='relativeTweak')
    cmds.editorTemplate(suppress='controlPoints')
    cmds.editorTemplate(suppress='controlPoints.xValue')
    cmds.editorTemplate(suppress='controlPoints.yValue')
    cmds.editorTemplate(suppress='controlPoints.zValue')
    cmds.editorTemplate(suppress='weights')
    cmds.editorTemplate(suppress='tweakLocation')
    cmds.editorTemplate(suppress='blindDataNodes')
    cmds.editorTemplate(suppress='uvPivot')
    cmds.editorTemplate(suppress='uvPivotX')
    cmds.editorTemplate(suppress='uvPivotY')
    cmds.editorTemplate(suppress='uvSet')
    cmds.editorTemplate(suppress='uvSet.uvSetName')
    cmds.editorTemplate(suppress='uvSet.uvSetPoints')
    cmds.editorTemplate(suppress='uvSet.uvSetPoints.uvSetPointsU')
    cmds.editorTemplate(suppress='uvSet.uvSetPoints.uvSetPointsV')
    cmds.editorTemplate(suppress='uvSet.uvSetTweakLocation')
    cmds.editorTemplate(suppress='currentUVSet')
    cmds.editorTemplate(suppress='displayImmediate')
    cmds.editorTemplate(suppress='displayColors')
    cmds.editorTemplate(suppress='displayColorChannel')
    cmds.editorTemplate(suppress='currentColorSet')
    cmds.editorTemplate(suppress='colorSet')
    cmds.editorTemplate(suppress='colorSet.colorName')
    cmds.editorTemplate(suppress='colorSet.clamped')
    cmds.editorTemplate(suppress='colorSet.representation')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints.colorSetPointsR')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints.colorSetPointsG')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints.colorSetPointsB')
    cmds.editorTemplate(suppress='colorSet.colorSetPoints.colorSetPointsA')
    cmds.editorTemplate(suppress='ignoreHwShader')
    cmds.editorTemplate(suppress='doubleSided')
    cmds.editorTemplate(suppress='opposite')
    cmds.editorTemplate(suppress='holdOut')
    cmds.editorTemplate(suppress='smoothShading')
    cmds.editorTemplate(suppress='boundingBoxScale')
    cmds.editorTemplate(suppress='boundingBoxScaleX')
    cmds.editorTemplate(suppress='boundingBoxScaleY')
    cmds.editorTemplate(suppress='boundingBoxScaleZ')
    cmds.editorTemplate(suppress='featureDisplacement')
    cmds.editorTemplate(suppress='initialSampleRate')
    cmds.editorTemplate(suppress='extraSampleRate')
    cmds.editorTemplate(suppress='textureThreshold')
    cmds.editorTemplate(suppress='normalThreshold')
    cmds.editorTemplate(suppress='displayHWEnvironment')
    cmds.editorTemplate(suppress='collisionOffsetVelocityIncrement')
    cmds.editorTemplate(suppress='collisionOffsetVelocityIncrement.collisionOffsetVelocityIncrement_Position')
    cmds.editorTemplate(suppress='collisionOffsetVelocityIncrement.collisionOffsetVelocityIncrement_FloatValue')
    cmds.editorTemplate(suppress='collisionOffsetVelocityIncrement.collisionOffsetVelocityIncrement_Interp')
    cmds.editorTemplate(suppress='collisionDepthVelocityIncrement')
    cmds.editorTemplate(suppress='collisionDepthVelocityIncrement.collisionDepthVelocityIncrement_Position')
    cmds.editorTemplate(suppress='collisionDepthVelocityIncrement.collisionDepthVelocityIncrement_FloatValue')
    cmds.editorTemplate(suppress='collisionDepthVelocityIncrement.collisionDepthVelocityIncrement_Interp')
    cmds.editorTemplate(suppress='collisionOffsetVelocityMultiplier')
    cmds.editorTemplate(suppress='collisionOffsetVelocityMultiplier.collisionOffsetVelocityMultiplier_Position')
    cmds.editorTemplate(suppress='collisionOffsetVelocityMultiplier.collisionOffsetVelocityMultiplier_FloatValue')
    cmds.editorTemplate(suppress='collisionOffsetVelocityMultiplier.collisionOffsetVelocityMultiplier_Interp')
    cmds.editorTemplate(suppress='collisionDepthVelocityMultiplier')
    cmds.editorTemplate(suppress='collisionDepthVelocityMultiplier.collisionDepthVelocityMultiplier_Position')
    cmds.editorTemplate(suppress='collisionDepthVelocityMultiplier.collisionDepthVelocityMultiplier_FloatValue')
    cmds.editorTemplate(suppress='collisionDepthVelocityMultiplier.collisionDepthVelocityMultiplier_Interp')
    cmds.editorTemplate(suppress='inMesh')
    cmds.editorTemplate(suppress='outMesh')
    cmds.editorTemplate(suppress='outGeometryClean')
    cmds.editorTemplate(suppress='cachedInMesh')
    cmds.editorTemplate(suppress='worldMesh')
    cmds.editorTemplate(suppress='outSmoothMesh')
    cmds.editorTemplate(suppress='cachedSmoothMesh')
    cmds.editorTemplate(suppress='smoothWarn')
    cmds.editorTemplate(suppress='smoothLevel')
    cmds.editorTemplate(suppress='smoothDrawType')
    cmds.editorTemplate(suppress='useGlobalSmoothDrawType')
    cmds.editorTemplate(suppress='outSmoothMeshSubdError')
    cmds.editorTemplate(suppress='showDisplacements')
    cmds.editorTemplate(suppress='displacementType')
    cmds.editorTemplate(suppress='loadTiledTextures')
    cmds.editorTemplate(suppress='enableOpenCL')
    cmds.editorTemplate(suppress='smoothTessLevel')
    cmds.editorTemplate(suppress='smoothOsdColorizePatches')
    cmds.editorTemplate(suppress='useOsdBoundaryMethods')
    cmds.editorTemplate(suppress='osdVertBoundary')
    cmds.editorTemplate(suppress='osdFvarBoundary')
    cmds.editorTemplate(suppress='osdFvarPropagateCorners')
    cmds.editorTemplate(suppress='osdSmoothTriangles')
    cmds.editorTemplate(suppress='osdCreaseMethod')
    cmds.editorTemplate(suppress='osdIndependentUVChannels')
    cmds.editorTemplate(suppress='continuity')
    cmds.editorTemplate(suppress='smoothUVs')
    cmds.editorTemplate(suppress='keepBorder')
    cmds.editorTemplate(suppress='boundaryRule')
    cmds.editorTemplate(suppress='keepHardEdge')
    cmds.editorTemplate(suppress='propagateEdgeHardness')
    cmds.editorTemplate(suppress='keepMapBorders')
    cmds.editorTemplate(suppress='smoothOffset')
    cmds.editorTemplate(suppress='sofx')
    cmds.editorTemplate(suppress='sofy')
    cmds.editorTemplate(suppress='sofz')
    cmds.editorTemplate(suppress='displaySubdComps')
    cmds.editorTemplate(suppress='useSmoothPreviewForRender')
    cmds.editorTemplate(suppress='renderSmoothLevel')
    cmds.editorTemplate(suppress='useMaxEdgeLength')
    cmds.editorTemplate(suppress='useMinEdgeLength')
    cmds.editorTemplate(suppress='useMaxSubdivisions')
    cmds.editorTemplate(suppress='useMaxUV')
    cmds.editorTemplate(suppress='useMinScreen')
    cmds.editorTemplate(suppress='useNumTriangles')
    cmds.editorTemplate(suppress='numTriangles')
    cmds.editorTemplate(suppress='maxEdgeLength')
    cmds.editorTemplate(suppress='minEdgeLength')
    cmds.editorTemplate(suppress='maxSubd')
    cmds.editorTemplate(suppress='maxUv')
    cmds.editorTemplate(suppress='minScreen')
    cmds.editorTemplate(suppress='maxTriangles')
    cmds.editorTemplate(suppress='pnts')
    cmds.editorTemplate(suppress='pnts.pntx')
    cmds.editorTemplate(suppress='pnts.pnty')
    cmds.editorTemplate(suppress='pnts.pntz')
    cmds.editorTemplate(suppress='vrts')
    cmds.editorTemplate(suppress='vrts.vrtx')
    cmds.editorTemplate(suppress='vrts.vrty')
    cmds.editorTemplate(suppress='vrts.vrtz')
    cmds.editorTemplate(suppress='edge')
    cmds.editorTemplate(suppress='edge.edg1')
    cmds.editorTemplate(suppress='edge.edg2')
    cmds.editorTemplate(suppress='edge.edgh')
    cmds.editorTemplate(suppress='uvpt')
    cmds.editorTemplate(suppress='uvpt.uvpx')
    cmds.editorTemplate(suppress='uvpt.uvpy')
    cmds.editorTemplate(suppress='colors')
    cmds.editorTemplate(suppress='colors.colorR')
    cmds.editorTemplate(suppress='colors.colorG')
    cmds.editorTemplate(suppress='colors.colorB')
    cmds.editorTemplate(suppress='colors.colorA')
    cmds.editorTemplate(suppress='normals')
    cmds.editorTemplate(suppress='normals.normalx')
    cmds.editorTemplate(suppress='normals.normaly')
    cmds.editorTemplate(suppress='normals.normalz')
    cmds.editorTemplate(suppress='face')
    cmds.editorTemplate(suppress='faceColorIndices')
    cmds.editorTemplate(suppress='creaseData')
    cmds.editorTemplate(suppress='creaseVertexData')
    cmds.editorTemplate(suppress='pinData')
    cmds.editorTemplate(suppress='holeFaceData')
    cmds.editorTemplate(suppress='colorPerVertex')
    cmds.editorTemplate(suppress='vertexColor')
    cmds.editorTemplate(suppress='vertexColor.vertexColorRGB')
    cmds.editorTemplate(suppress='vertexColor.vertexColorR')
    cmds.editorTemplate(suppress='vertexColor.vertexColorG')
    cmds.editorTemplate(suppress='vertexColor.vertexColorB')
    cmds.editorTemplate(suppress='vertexColor.vertexAlpha')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceColorRGB')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceColorR')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceColorG')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceColorB')
    cmds.editorTemplate(suppress='vertexColor.vertexFaceColor.vertexFaceAlpha')
    cmds.editorTemplate(suppress='normalPerVertex')
    cmds.editorTemplate(suppress='vertexNormal')
    cmds.editorTemplate(suppress='vertexNormal.vertexNormalXYZ')
    cmds.editorTemplate(suppress='vertexNormal.vertexNormalX')
    cmds.editorTemplate(suppress='vertexNormal.vertexNormalY')
    cmds.editorTemplate(suppress='vertexNormal.vertexNormalZ')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal.vertexFaceNormalXYZ')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal.vertexFaceNormalX')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal.vertexFaceNormalY')
    cmds.editorTemplate(suppress='vertexNormal.vertexFaceNormal.vertexFaceNormalZ')
    cmds.editorTemplate(suppress='displayVertices')
    cmds.editorTemplate(suppress='displayBorders')
    cmds.editorTemplate(suppress='displayMapBorders')
    cmds.editorTemplate(suppress='displayEdges')
    cmds.editorTemplate(suppress='displayFacesWithGroupId')
    cmds.editorTemplate(suppress='displayCenter')
    cmds.editorTemplate(suppress='displayTriangles')
    cmds.editorTemplate(suppress='displayUVs')
    cmds.editorTemplate(suppress='displayItemNumbers')
    cmds.editorTemplate(suppress='displayNonPlanar')
    cmds.editorTemplate(suppress='backfaceCulling')
    cmds.editorTemplate(suppress='vertexBackfaceCulling')
    cmds.editorTemplate(suppress='vertexSize')
    cmds.editorTemplate(suppress='uvSize')
    cmds.editorTemplate(suppress='borderWidth')
    cmds.editorTemplate(suppress='normalSize')
    cmds.editorTemplate(suppress='normalType')
    cmds.editorTemplate(suppress='displayNormal')
    cmds.editorTemplate(suppress='displayTangent')
    cmds.editorTemplate(suppress='tangentSpace')
    cmds.editorTemplate(suppress='tangentSmoothingAngle')
    cmds.editorTemplate(suppress='tangentNormalThreshold')
    cmds.editorTemplate(suppress='allowTopologyMod')
    cmds.editorTemplate(suppress='materialBlend')
    cmds.editorTemplate(suppress='uvTweakLocation')
    cmds.editorTemplate(suppress='userTrg')
    cmds.editorTemplate(suppress='dispResolution')
    cmds.editorTemplate(suppress='vertexIdMap')
    cmds.editorTemplate(suppress='edgeIdMap')
    cmds.editorTemplate(suppress='faceIdMap')
    cmds.editorTemplate(suppress='displaySmoothMesh')
    cmds.editorTemplate(suppress='smoothMeshSelectionMode')
    cmds.editorTemplate(suppress='inForceNodeUVUpdate')
    cmds.editorTemplate(suppress='outForceNodeUVUpdate')
    cmds.editorTemplate(suppress='alwaysDrawOnTop')
    cmds.editorTemplate(suppress='reuseTriangles')
    cmds.editorTemplate(suppress='quadSplit')
    cmds.editorTemplate(suppress='vertexNormalMethod')
    cmds.editorTemplate(suppress='perInstanceIndex')
    cmds.editorTemplate(suppress='perInstanceTag')
    cmds.editorTemplate(suppress='displayAlphaAsGreyScale')
    cmds.editorTemplate(suppress='displayColorAsGreyScale')
    cmds.editorTemplate(suppress='displayRedColorChannel')
    cmds.editorTemplate(suppress='displayGreenColorChannel')
    cmds.editorTemplate(suppress='displayBlueColorChannel')
    cmds.editorTemplate(suppress='displayInvisibleFaces')
    cmds.editorTemplate(suppress='useMeshSculptCache')
    cmds.editorTemplate(suppress='computeFromSculptCache')
    cmds.editorTemplate(suppress='useMeshTexSculptCache')
    cmds.editorTemplate(suppress='freeze')
    cmds.editorTemplate(suppress='motionVectorColorSet')
    cmds.editorTemplate(suppress='vertexColorSource')
    cmds.editorTemplate(suppress='mikktspaceTangentGen')
    cmds.editorTemplate(suppress='aiUserOptions')
    cmds.editorTemplate(suppress='dso')
    cmds.editorTemplate(suppress='data')
    cmds.editorTemplate(suppress='aiOverrideLightLinking')
    cmds.editorTemplate(suppress='aiOverrideShaders')
    cmds.editorTemplate(suppress='aiUseFrameExtension')
    cmds.editorTemplate(suppress='aiFrameNumber')
    cmds.editorTemplate(suppress='aiUseSubFrame')
    cmds.editorTemplate(suppress='aiFrameOffset')
    cmds.editorTemplate(suppress='aiOverrideNodes')
    cmds.editorTemplate(suppress='aiNamespace')
    cmds.editorTemplate(suppress='aiOverrideReceiveShadows')
    cmds.editorTemplate(suppress='aiOverrideDoubleSided')
    cmds.editorTemplate(suppress='aiOverrideSelfShadows')
    cmds.editorTemplate(suppress='aiOverrideOpaque')
    cmds.editorTemplate(suppress='aiOverrideMatte')
    cmds.editorTemplate(suppress='aiCastShadows')
    cmds.editorTemplate(suppress='aiShadowDensity')
    cmds.editorTemplate(suppress='aiExposure')
    cmds.editorTemplate(suppress='aiSamples')
    cmds.editorTemplate(suppress='aiNormalize')
    cmds.editorTemplate(suppress='aiFilters')
    cmds.editorTemplate(suppress='aiDiffuse')
    cmds.editorTemplate(suppress='aiSpecular')
    cmds.editorTemplate(suppress='aiSss')
    cmds.editorTemplate(suppress='aiIndirect')
    cmds.editorTemplate(suppress='aiVolume')
    cmds.editorTemplate(suppress='aiMaxBounces')
    cmds.editorTemplate(suppress='aiVolumeSamples')
    cmds.editorTemplate(suppress='aiAov')
    cmds.editorTemplate(suppress='aiUseColorTemperature')
    cmds.editorTemplate(suppress='aiColorTemperature')
    cmds.editorTemplate(suppress='aiShadowColor')
    cmds.editorTemplate(suppress='aiShadowColorR')
    cmds.editorTemplate(suppress='aiShadowColorG')
    cmds.editorTemplate(suppress='aiShadowColorB')
    cmds.editorTemplate(suppress='aiCastVolumetricShadows')
    cmds.editorTemplate(suppress='color')
    cmds.editorTemplate(suppress='colorR')
    cmds.editorTemplate(suppress='colorG')
    cmds.editorTemplate(suppress='colorB')
    cmds.editorTemplate(suppress='intensity')
    cmds.editorTemplate(suppress='lightVisible')
    cmds.editorTemplate(suppress='aiSelfShadows')
    cmds.editorTemplate(suppress='aiOpaque')
    cmds.editorTemplate(suppress='aiMatte')
    cmds.editorTemplate(suppress='aiTraceSets')
    cmds.editorTemplate(suppress='aiSssSetname')
    cmds.editorTemplate(suppress='aiToonId')
    cmds.editorTemplate(suppress='aiVisibleInDiffuseReflection')
    cmds.editorTemplate(suppress='aiVisibleInSpecularReflection')
    cmds.editorTemplate(suppress='aiVisibleInDiffuseTransmission')
    cmds.editorTemplate(suppress='aiVisibleInSpecularTransmission')
    cmds.editorTemplate(suppress='aiVisibleInVolume')
    cmds.editorTemplate(suppress='aiSubdivType')
    cmds.editorTemplate(suppress='aiSubdivIterations')
    cmds.editorTemplate(suppress='aiSubdivAdaptiveMetric')
    cmds.editorTemplate(suppress='aiSubdivPixelError')
    cmds.editorTemplate(suppress='aiSubdivAdaptiveSpace')
    cmds.editorTemplate(suppress='aiSubdivUvSmoothing')
    cmds.editorTemplate(suppress='aiSubdivSmoothDerivs')
    cmds.editorTemplate(suppress='aiSubdivFrustumIgnore')
    cmds.editorTemplate(suppress='aiDispHeight')
    cmds.editorTemplate(suppress='aiDispPadding')
    cmds.editorTemplate(suppress='aiDispZeroValue')
    cmds.editorTemplate(suppress='aiDispAutobump')
    cmds.editorTemplate(suppress='aiAutobumpVisibility')
    cmds.editorTemplate(suppress='aiExportTangents')
    cmds.editorTemplate(suppress='aiExportColors')
    cmds.editorTemplate(suppress='aiExportRefPoints')
    cmds.editorTemplate(suppress='aiExportRefNormals')
    cmds.editorTemplate(suppress='aiExportRefTangents')
    cmds.editorTemplate(suppress='aiStepSize')
    cmds.editorTemplate(suppress='aiVolumePadding')
    cmds.editorTemplate(suppress='aiMotionVectorSource')
    cmds.editorTemplate(suppress='aiMotionVectorUnit')
    cmds.editorTemplate(suppress='aiMotionVectorScale')
    cmds.editorTemplate(suppress='aiTranslator')

def addControlOnChange(attrName, onChangeData=[], *args, **kwargs):
    """
    onChangeData: [moduleName, methodName] - specifies which python method and
    from which module should be used in the MEL callback for the given control
    """

    moduleName, methodName = onChangeData
    melCbName = 'v3d_%s_%s' % (moduleName, methodName)

    if mel.eval('exists %s' % melCbName) == 0:
        mel.eval("""
        global proc %s(string $nodeName) {
            python("import %s as someModule");
            python("someModule.%s(\\"" + $nodeName + "\\")");
        }""" % (melCbName, moduleName, methodName))

    cmds.editorTemplate(attrName, melCbName, *args, **dict(kwargs, addControl=True))

def addControlCallCustom(onNewData=[], onReplaceData=[], *args, **kwargs):
    moduleNameNew, methodNameNew = onNewData
    moduleNameReplace, methodNameReplace = onReplaceData

    moduleNew = importlib.import_module(moduleNameNew)
    methodNew = getattr(moduleNew, methodNameNew)
    moduleReplace = importlib.import_module(moduleNameReplace)
    methodReplace = getattr(moduleReplace, methodNameReplace)
    cmds.editorTemplate('', *args, **dict(kwargs,
            callCustom=[methodNew, methodReplace]))

class SetMenu():

    def __init__(self, linkedAttrName):
        """
        An empty label means that no selection set is chosen. An empty name is
        not allowed in Maya, so using it doesn't lead to name collisions with
        scene objects.
        """
        self._EMPTY_LABEL = ''
        self._EMPTY_NAME = ''

        self.optMenu = None
        self.optMenuText = None

        """
        The name of the currently selected node is available/obtained in the
        standard callbackNew, callbackReplace and changeCommand callbacks. When
        used everywhere else it must be checked via
        cmds.objExists(self._currNodeName) since the node may be deleted (e.g.
        during "File->New Scene").
        """
        self._currNodeName = ''

        self.linkedAttrName = linkedAttrName

    def _prepareCallCustom(func):
        """
        A decorator for methods used as callbacks in cmds.editorTemplate with
        the callCustom flag. Tracks the current active node and removes the dot
        at the end of the current node's name.
        """
        def wrapper(self, nodeNameDot):
            self._currNodeName = nodeNameDot[:-1]
            func(self)
        return wrapper

    def _menuItemInfo(self, setName=None, itemLabel=None):
        """
        Get full information about the absolute set node name and the menu item
        label from a set name or an item label. setName has higher priority than
        itemLabel. Suitable for both existed and not yet created menu items.
        """
        absName = None
        label = None

        if setName is not None:
            if setName == self._EMPTY_NAME:
                absName = self._EMPTY_NAME
                label = self._EMPTY_LABEL
            else:
                absName = mayaUtils.objectSetGetAbsoluteName(setName)
                label = absName[1:]

        elif itemLabel is not None:
            if itemLabel == self._EMPTY_LABEL:
                absName = self._EMPTY_NAME
                label = self._EMPTY_LABEL
            else:
                absName = ':' + itemLabel
                label = itemLabel

        return {
            'absName': absName,
            'label': label
        }

    def _getCurrAttrName(self):
        return self._currNodeName + '.' + self.linkedAttrName

    def _getCurrConnectedSet(self):
        conn = cmds.listConnections(self._getCurrAttrName(), type='objectSet')
        return conn[0] if conn is not None else self._EMPTY_NAME

    def _getItemIds(self):
        return cmds.optionMenu(self.optMenu, query=True, itemListShort=True) or []

    def _getItemLabels(self):
        return [cmds.menuItem(itemId, query=True, label=True)
                for itemId in self._getItemIds()]

    def _getItemIdByLabel(self, itemLabel):
        for itemId in self._getItemIds():
            if cmds.menuItem(itemId, query=True, label=True) == itemLabel:
                return itemId
        return ''

    def createOptionMenu(self, label='Set'):
        """
        Method for creating the option menu's UI. Override to change the default
        UI.
        """

        cmds.rowLayout(numberOfColumns=2)
        self.optMenuText = cmds.text(label=label)
        self.optMenu = cmds.optionMenu(changeCommand=self.onItemSelect)
        cmds.setParent('..')

    def clearMenu(self):
        for itemId in self._getItemIds():
            cmds.deleteUI(itemId, menuItem=True)

    def populateMenu(self):
        setNames = [self._EMPTY_NAME] + sorted([s for s in cmds.ls(sets=True)
                if mayaUtils.setFilterScript(s, True)])

        for name in setNames:
            itemInfo = self._menuItemInfo(setName=name)
            cmds.menuItem(parent=self.optMenu, label=itemInfo['label'])

    def selectItem(self, itemLabel):
        menuLabels = self._getItemLabels()
        idxToSelect = (menuLabels.index(itemLabel) if itemLabel in menuLabels else 0)
        cmds.optionMenu(self.optMenu, edit=True, select=idxToSelect+1) # 1-based

    def removeItem(self, itemLabel):
        itemId = self._getItemIdByLabel(itemLabel)
        if itemId != '':
            cmds.deleteUI(itemId, menuItem=True)

    def dimControl(self, dimFlag):
        cmds.text(self.optMenuText, edit=True, enable=not dimFlag)
        cmds.optionMenu(self.optMenu, edit=True, enable=not dimFlag)

    def updateSelectionFromCurrentNode(self):
        if cmds.objExists(self._currNodeName):
            currConnSet = self._getCurrConnectedSet()
            itemInfo = self._menuItemInfo(setName=currConnSet)

            self.selectItem(itemInfo['label'])

    @_prepareCallCustom
    def callbackNew(self):
        self.createOptionMenu()
        self.populateMenu()
        self.updateSelectionFromCurrentNode()

    @_prepareCallCustom
    def callbackReplace(self):
        self.updateSelectionFromCurrentNode()

    def onItemSelect(self, itemLabel):
        if itemLabel == self._EMPTY_LABEL:
            currConnSet = self._getCurrConnectedSet()
            itemInfo = self._menuItemInfo(setName=currConnSet)
            if itemInfo['absName'] != self._EMPTY_NAME:
                cmds.disconnectAttr(itemInfo['absName'] + '.message', self._getCurrAttrName())
        else:
            itemInfo = self._menuItemInfo(itemLabel=itemLabel)
            cmds.connectAttr(itemInfo['absName'] + '.message', self._getCurrAttrName(), force=True)

    def objectSetAddedCb(self, objectSet):
        """
        Method to be used as a callback for when a new set is added. Should be
        called explicitly in an appropriate handler/callback. Example:

            import maya.api.OpenMaya as om

            def cb(objectSet, clientData):
                mySetMenu.objectSetAddedCb(objectSet)

            om.MDGMessage.addNodeAddedCallback(cb, 'objectSet')
        """
        if self.optMenu is not None:
            self.clearMenu()
            self.populateMenu()
            self.updateSelectionFromCurrentNode()

    def objectSetRemovedCb(self, objectSet):
        """
        Method to be used as a callback for when a set is deleted. Should be
        called explicitly in an appropriate handler/callback. Example:

            import maya.api.OpenMaya as om

            def cb(objectSet, clientData):
                mySetMenu.objectSetRemovedCb(objectSet)

            om.MDGMessage.addNodeRemovedCallback(cb, 'objectSet')
        """
        if self.optMenu is not None:
            self.clearMenu()
            self.populateMenu()
            """
            NOTE: The "nodeRemoved" dependency graph message callback is called
            just before the node is deleted, so the node still accessible
            through API. In that case it's still gathered in the populateMenu()
            method. Need to remove it manually.
            """
            self.removeItem(om.MFnSet(objectSet).name())
            self.updateSelectionFromCurrentNode()

    def objectSetNameChangedCb(self, objectSet, prevName):
        """
        Method to be used as a callback for when a set's name is changed. Should
        be called explicitly in an appropriate handler/callback. Example:

            import maya.api.OpenMaya as om

            def cb(node, prevName, clientData):
                if prevName == '' or node.apiType() != om.MFn.kSet:
                    return
                mySetMenu.objectSetNameChangedCb(node, prevName)

            om.MNodeMessage.addNameChangedCallback(om.MObject(), cb)
        """
        if self.optMenu is not None:
            self.clearMenu()
            self.populateMenu()
            self.updateSelectionFromCurrentNode()

    def afterSceneReadCb(self):
        """
        Method to be used as a callback for when a scene is imported. Should be
        called explicitly in an appropriate handler/callback. Fixes menus having
        temporary set names (starting with ":") used during the import process
        and not being relevant after that. Example:

            import maya.api.OpenMaya as om

            def cb(clientData):
                mySetMenu.afterSceneReadCb()

            om.MSceneMessage.addCallback(om.MSceneMessage.kAfterSceneReadAndRecordEdits, cb)
        """
        if self.optMenu is not None:
            self.clearMenu()
            self.populateMenu()
            self.updateSelectionFromCurrentNode()
