/**
* Copyright (c) 2024 Soft8Soft
*/

#include "verge3d.h"

#define V3DExportMenuGLTF_CLASS_ID Class_ID(0x36064a83, 0x24e00bfc)

class V3DExportMenuGLTF : public SceneExport
{
public:
    V3DExportMenuGLTF();
    virtual ~V3DExportMenuGLTF();

    int ExtCount(); // Number of extensions supported
    const TCHAR* Ext(int n); // Extension #n (i.e. "3DS")
    const TCHAR* LongDesc(); // Long ASCII description (i.e. "Autodesk 3D Studio File")
    const TCHAR* ShortDesc(); // Short ASCII description (i.e. "3D Studio")
    const TCHAR* AuthorName(); // ASCII Author name
    const TCHAR* CopyrightMessage(); // ASCII Copyright message
    const TCHAR* OtherMessage1(); // Other message #1
    const TCHAR* OtherMessage2(); // Other message #2
    unsigned int Version(); // Version number * 100 (i.e. v3.01 = 301)
    void ShowAbout(HWND hWnd); // Show DLL's "About..." box

    BOOL SupportsOptions(int ext, DWORD options);
    int DoExport(const TCHAR* name, ExpInterface* ei, Interface* i, BOOL suppressPrompts = FALSE, DWORD options = 0);
};

class V3DExportMenuGLTFClassDesc : public ClassDesc2 
{
public:
    int           IsPublic() override                               { return TRUE; }
    void*         Create(BOOL /*loading = FALSE*/) override         { return new V3DExportMenuGLTF(); }
    const TCHAR*  ClassName() override                              { return _T("V3DExportMenuGLTF"); }
    const TCHAR*  NonLocalizedClassName() override                  { return _T("V3DExportMenuGLTF"); }
    SClass_ID     SuperClassID() override                           { return SCENE_EXPORT_CLASS_ID; }
    Class_ID      ClassID() override                                { return V3DExportMenuGLTF_CLASS_ID; }
    const TCHAR*  Category() override                               { return _T("Exporters"); }

    const TCHAR*  InternalName() override                           { return _T("V3DExportMenuGLTF"); } // Returns fixed parsable name (scripter-visible name)
    HINSTANCE     HInstance() override                              { return hInstance; } // Returns owning module handle
};

ClassDesc2* GetV3DExportMenuGLTFDesc()
{
    static V3DExportMenuGLTFClassDesc V3DExportMenuGLTFDesc;
    return &V3DExportMenuGLTFDesc; 
}

V3DExportMenuGLTF::V3DExportMenuGLTF()
{

}

V3DExportMenuGLTF::~V3DExportMenuGLTF()
{

}

int V3DExportMenuGLTF::ExtCount()
{
    return 2;
}

const TCHAR* V3DExportMenuGLTF::Ext(int i)
{
    if (i == 0)
        return _T("gltf");
    else
        return _T("glb");
}

const TCHAR* V3DExportMenuGLTF::LongDesc()
{
    return _T("Verge3D glTF 2.0 format");
}

const TCHAR* V3DExportMenuGLTF::ShortDesc()
{
    return _T("Verge3D glTF");
}

const TCHAR* V3DExportMenuGLTF::AuthorName()
{
    return _T("Soft8Soft");
}

const TCHAR* V3DExportMenuGLTF::CopyrightMessage()
{
    return _T("© Soft8Soft");
}

const TCHAR* V3DExportMenuGLTF::OtherMessage1()
{
    return _T("");
}

const TCHAR* V3DExportMenuGLTF::OtherMessage2()
{
    return _T("");
}

unsigned int V3DExportMenuGLTF::Version()
{
    return 100;
}

void V3DExportMenuGLTF::ShowAbout(HWND /*hWnd*/)
{
    // Optional
}

BOOL V3DExportMenuGLTF::SupportsOptions(int /*ext*/, DWORD /*options*/)
{
    return TRUE;
}

int V3DExportMenuGLTF::DoExport(const TCHAR* name, ExpInterface* /*ei*/, Interface* /*ip*/, BOOL suppressPrompts, DWORD /*options*/)
{
    TCHAR line[65535];
    _tcscpy_s(line, sizeof(line), _T("::v3dManager.exportGLTFPath(\""));
    _tcscat_s(line, sizeof(line), name);
    _tcscat_s(line, sizeof(line), _T("\")"));
    ExecuteMAXScriptScript(line, MAXScript::ScriptSource::NonEmbedded, FALSE, NULL);
    return TRUE;
}
