/**
* Copyright (c) 2024 Soft8Soft
*/

#include "verge3d.h"

#define V3DExportMenuHTML_CLASS_ID Class_ID(0x771f0485, 0x56335439)

class V3DExportMenuHTML : public SceneExport
{
public:
    V3DExportMenuHTML();
    virtual ~V3DExportMenuHTML();

    int ExtCount(); // Number of extensions supported
    const TCHAR* Ext(int n); // Extension #n (i.e. "3DS")
    const TCHAR* LongDesc(); // Long ASCII description (i.e. "Autodesk 3D Studio File")
    const TCHAR* ShortDesc(); // Short ASCII description (i.e. "3D Studio")
    const TCHAR* AuthorName(); // ASCII Author name
    const TCHAR* CopyrightMessage(); // ASCII Copyright message
    const TCHAR* OtherMessage1(); // Other message #1
    const TCHAR* OtherMessage2(); // Other message #2
    unsigned int Version(); // Version number * 100 (i.e. v3.01 = 301)
    void ShowAbout(HWND hWnd); // Show DLL's "About..." box

    BOOL SupportsOptions(int ext, DWORD options);
    int DoExport(const TCHAR* name, ExpInterface* ei, Interface* i, BOOL suppressPrompts = FALSE, DWORD options = 0);
};

class V3DExportMenuHTMLClassDesc : public ClassDesc2 
{
public:
    int           IsPublic() override                               { return TRUE; }
    void*         Create(BOOL /*loading = FALSE*/) override         { return new V3DExportMenuHTML(); }
    const TCHAR*  ClassName() override                              { return _T("V3DExportMenuHTML"); }
    const TCHAR*  NonLocalizedClassName() override                  { return _T("V3DExportMenuHTML"); }
    SClass_ID     SuperClassID() override                           { return SCENE_EXPORT_CLASS_ID; }
    Class_ID      ClassID() override                                { return V3DExportMenuHTML_CLASS_ID; }
    const TCHAR*  Category() override                               { return _T("Exporters"); }

    const TCHAR*  InternalName() override                           { return _T("V3DExportMenuHTML"); } // Returns fixed parsable name (scripter-visible name)
    HINSTANCE     HInstance() override                              { return hInstance; } // Returns owning module handle
};

ClassDesc2* GetV3DExportMenuHTMLDesc()
{
    static V3DExportMenuHTMLClassDesc V3DExportMenuHTMLDesc;
    return &V3DExportMenuHTMLDesc; 
}

V3DExportMenuHTML::V3DExportMenuHTML()
{

}

V3DExportMenuHTML::~V3DExportMenuHTML()
{

}

int V3DExportMenuHTML::ExtCount()
{
    return 1;
}

const TCHAR* V3DExportMenuHTML::Ext(int i)
{
    return _T("html");
}

const TCHAR* V3DExportMenuHTML::LongDesc()
{
    return _T("HTML page");
}

const TCHAR* V3DExportMenuHTML::ShortDesc()
{
    return _T("HTML");
}

const TCHAR* V3DExportMenuHTML::AuthorName()
{
    return _T("Soft8Soft");
}

const TCHAR* V3DExportMenuHTML::CopyrightMessage()
{
    return _T("© Soft8Soft");
}

const TCHAR* V3DExportMenuHTML::OtherMessage1()
{
    return _T("");
}

const TCHAR* V3DExportMenuHTML::OtherMessage2()
{
    return _T("");
}

unsigned int V3DExportMenuHTML::Version()
{
    return 100;
}

void V3DExportMenuHTML::ShowAbout(HWND /*hWnd*/)
{
    // Optional
}

BOOL V3DExportMenuHTML::SupportsOptions(int /*ext*/, DWORD /*options*/)
{
    return TRUE;
}

int V3DExportMenuHTML::DoExport(const TCHAR* name, ExpInterface* /*ei*/, Interface* /*ip*/, BOOL suppressPrompts, DWORD /*options*/)
{
    TCHAR line[65535];
    _tcscpy_s(line, sizeof(line), _T("::v3dManager.exportGLTFPath(\""));
    _tcscat_s(line, sizeof(line), name);
    _tcscat_s(line, sizeof(line), _T("\")"));
    ExecuteMAXScriptScript(line, MAXScript::ScriptSource::NonEmbedded, FALSE, NULL);
    return TRUE;
}
