# Copyright (c) 2017-2025 Soft8Soft, LLC. All rights reserved.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
#
#
#
#
#
VERGE3D_ID = 'bl_ext.soft8soft.verge3d'

def register():
    import bpy, os

    repos = bpy.context.preferences.extensions.repos

    if 'Soft8Soft' in repos:
        repo = repos['Soft8Soft']
        enable = False
    else:
        print('V3D-ST-INFO: Creating Soft8Soft repository')

        repo = repos.new(
            name='Soft8Soft',
            module='soft8soft'
        )

        enable = True

    def timer():
        if enable:
            import addon_utils
            is_enabled, is_loaded = addon_utils.check(VERGE3D_ID)
            if not is_enabled:
                print('V3D-ST-INFO: Enabling Verge3D extension')
                bpy.ops.preferences.addon_enable(module=VERGE3D_ID)

    if os.path.isdir(repo.directory) and os.path.isdir(os.path.join(repo.directory, 'verge3d')):
        bpy.app.timers.register(timer, first_interval=1, persistent=True)

def unregister():
    pass

if __name__ == "__main__":
    register()
