<%
    PACKAGES = ['blender', 'max', 'maya', 'blender', 'max']

    package1 = package.lower()
    package1Title = package1.title().replace('Max', '3ds Max')
    package2 = PACKAGES[PACKAGES.index(package1)+1]
    package2Title = package2.title().replace('Max', '3ds Max')
    package3 = PACKAGES[PACKAGES.index(package2)+1]
    package3Title = package3.title().replace('Max', '3ds Max')
%>

<div class="package-indicator-cont">
% if "Ultimate" in productName:
  <div class="package-indicator-menu ${package1}" title="Choose the modeling suite">...</div>

  <div class="package-indicator ${package1}" title="App Manager working with ${package1Title}"><a href="">${package1Title}</a></div>
  <div class="package-indicator ${package2}" title="Switch to ${package2Title}"><a href="">${package2Title}</a></div>
  <div class="package-indicator ${package3}" title="Switch to ${package3Title}"><a href="">${package3Title}</a></div>

  <script>
    const piCont = document.body.querySelector("div.package-indicator-cont");
    const piMenu = document.body.querySelector("div.package-indicator-menu");
    piMenu.addEventListener('click', () => {
        if (piCont.classList.contains('menu-opened'))
            piCont.classList.remove('menu-opened');
        else
            piCont.classList.add('menu-opened');
    });

    const PORTS = {
        'blender': 8668,
        'max': 8669,
        'maya': 8670
    }

    const piItems = document.body.querySelectorAll("div.package-indicator a");
    piItems.forEach(item => {
        const url = new URL(location.href);
        url.port = PORTS[item.parentElement.classList[1]];
        item.href = url.href;
    });
  </script>
% else:
  <div class="package-indicator simple ${package1}" title="App Manager working with ${package1Title}">${package1Title}</div>
% endif
</div>


