import os

import maya.cmds as cmds
import maya.mel as mel

import reflectionCubemap as rc
import clippingPlane as cp
import reflectionPlane as rp

V3D_CUSTOM_SHELF_NAME = 'Verge3D'

import interface

def add_v3dReflectionCubemap():
    transformNode = cmds.createNode('transform', name=rc.NODE_TYPE)
    shelfNode = cmds.createNode(rc.NODE_TYPE, name=rc.NODE_SHELF_NAME,
            parent=transformNode)

def add_v3dReflectionPlane():
    transformNode = cmds.createNode('transform', name=rp.NODE_TYPE)
    shelfNode = cmds.createNode(rp.NODE_TYPE, name=rp.NODE_SHELF_NAME,
            parent=transformNode)
    cmds.connectAttr(transformNode + '.scaleY', shelfNode + '.planeScaleY')

def add_v3dClippingPlane():
    transformNode = cmds.createNode('transform', name=cp.NODE_TYPE)
    shelfNode = cmds.createNode(cp.NODE_TYPE, name=cp.NODE_SHELF_NAME,
            parent=transformNode)

def registerShelf(pluginPath):
    gShelfTopLevel = mel.eval('$_=$gShelfTopLevel')

    if cmds.shelfLayout(V3D_CUSTOM_SHELF_NAME, exists=True):
        cmds.deleteUI(V3D_CUSTOM_SHELF_NAME)
    cmds.shelfLayout(V3D_CUSTOM_SHELF_NAME, parent=gShelfTopLevel)

    img = os.path.normpath(os.path.join(pluginPath, 'images', 'shelf_sneak_peek.png'))
    cmds.shelfButton(style='iconOnly', parent=V3D_CUSTOM_SHELF_NAME,
            label='Sneak Peek: Export to temporary location and preview the scene in Verge3D', image=img,
            command=interface.SNEAK_PEEK_CMD, sourceType='mel')

    img = os.path.normpath(os.path.join(pluginPath, 'images', 'shelf_export_gltf.png'))
    cmds.shelfButton(style='iconOnly', parent=V3D_CUSTOM_SHELF_NAME,
            label='Export: Export the scene to glTF 2.0', image=img,
            command=interface.EXPORT_GLTF_CMD, sourceType='mel')

    img = os.path.normpath(os.path.join(pluginPath, 'images', 'shelf_app_manager.png'))
    cmds.shelfButton(style='iconOnly', parent=V3D_CUSTOM_SHELF_NAME,
            label='App Manager: Open Verge3D App Manager', image=img,
            command=interface.APP_MANAGER_CMD, sourceType='mel')

    cmds.separator(width=12, height = 35, style='shelf', hr=False)

    img = os.path.normpath(os.path.join(pluginPath, 'images',
            'shelf_v3dReflectionCubemap.png'))
    cmds.shelfButton(style="iconOnly", parent=V3D_CUSTOM_SHELF_NAME,
            label='Reflection Cubemap: Create a spherical/cubic reflection probe object', image=img,
            command=add_v3dReflectionCubemap)

    img = os.path.normpath(os.path.join(pluginPath, 'images',
            'shelf_v3dReflectionPlane.png'))
    cmds.shelfButton(style="iconOnly", parent=V3D_CUSTOM_SHELF_NAME,
            label='Reflection Plane: Create a planar reflection probe object', image=img,
            command=add_v3dReflectionPlane)

    img = os.path.normpath(os.path.join(pluginPath, 'images',
            'shelf_v3dClippingPlane.png'))
    cmds.shelfButton(style="iconOnly", parent=V3D_CUSTOM_SHELF_NAME,
            label='Clipping Plane: Create a clipping plane object', image=img,
            command=add_v3dClippingPlane)

    cmds.separator(width=12, height = 35, style='shelf', hr=False)

    img = os.path.normpath(os.path.join(pluginPath, 'images', 'shelf_export_settings.png'))
    cmds.shelfButton(style='iconOnly', parent=V3D_CUSTOM_SHELF_NAME,
            label='Export Settings: Open Verge3D Export Settings dialog', image=img,
            command=interface.EXPORT_SETTINGS_CMD, sourceType='mel')
