// Verge3D 4.12.0-pre1 © 2017-2026 Soft8Soft - v3d.net/eula
const REVISION="4.12.0 pre1",MOD_SUITE="ALL",REVISION_EXPORT_MIN={BLENDER:"4.11.0",MAX:"4.9.0",MAYA:"4.9.0"},V3DL="__V3DL__0000000000",MOUSE={LEFT:0,MIDDLE:1,RIGHT:2,ROTATE:0,DOLLY:1,PAN:2},TOUCH={ROTATE:0,PAN:1,DOLLY_PAN:2,DOLLY_ROTATE:3},CullFaceNone=0,CullFaceBack=1,CullFaceFront=2,CullFaceFrontBack=3,BasicShadowMap=0,BilinearShadowMap=1,PCFShadowMap=2,ESMShadowMap=3,FrontSide=0,BackSide=1,DoubleSide=2,TwoPassDoubleSide=3,NoBlending=0,NormalBlending=1,AdditiveBlending=2,SubtractiveBlending=3,MultiplyBlending=4,CustomBlending=5,AddEquation=100,SubtractEquation=101,ReverseSubtractEquation=102,MinEquation=103,MaxEquation=104,ZeroFactor=200,OneFactor=201,SrcColorFactor=202,OneMinusSrcColorFactor=203,SrcAlphaFactor=204,OneMinusSrcAlphaFactor=205,DstAlphaFactor=206,OneMinusDstAlphaFactor=207,DstColorFactor=208,OneMinusDstColorFactor=209,SrcAlphaSaturateFactor=210,NeverDepth=0,AlwaysDepth=1,LessDepth=2,LessEqualDepth=3,EqualDepth=4,GreaterEqualDepth=5,GreaterDepth=6,NotEqualDepth=7,MultiplyOperation=0,MixOperation=1,AddOperation=2,NoToneMapping=0,LinearToneMapping=1,ReinhardToneMapping=2,CineonToneMapping=3,ACESFilmicToneMapping=4,CustomToneMapping=5,LogarithmicMaxToneMapping=6,PhysicalMaxToneMapping=7,FilmicBlenderToneMapping=8,AgXBlenderToneMapping=9,PbrNeutralToneMapping=10,ToneMappingLookNone=0,ToneMappingLookAgXPunchy=1,UVMapping=300,CubeReflectionMapping=301,CubeRefractionMapping=302,EquirectangularReflectionMapping=303,EquirectangularRefractionMapping=304,CubeUVReflectionMapping=306,RepeatWrapping=1e3,ClampToEdgeWrapping=1001,MirroredRepeatWrapping=1002,NearestFilter=1003,NearestMipmapNearestFilter=1004,NearestMipMapNearestFilter=1004,NearestMipmapLinearFilter=1005,NearestMipMapLinearFilter=1005,LinearFilter=1006,LinearMipmapNearestFilter=1007,LinearMipMapNearestFilter=1007,LinearMipmapLinearFilter=1008,LinearMipMapLinearFilter=1008,UnsignedByteType=1009,ByteType=1010,ShortType=1011,UnsignedShortType=1012,IntType=1013,UnsignedIntType=1014,FloatType=1015,HalfFloatType=1016,UnsignedShort4444Type=1017,UnsignedShort5551Type=1018,UnsignedInt248Type=1020,AlphaFormat=1021,RGBAFormat=1023,LuminanceFormat=1024,LuminanceAlphaFormat=1025,DepthFormat=1026,DepthStencilFormat=1027,RedFormat=1028,RedIntegerFormat=1029,RGFormat=1030,RGIntegerFormat=1031,RGBAIntegerFormat=1033,RGB_S3TC_DXT1_Format=33776,RGBA_S3TC_DXT1_Format=33777,RGBA_S3TC_DXT3_Format=33778,RGBA_S3TC_DXT5_Format=33779,RGB_PVRTC_4BPPV1_Format=35840,RGB_PVRTC_2BPPV1_Format=35841,RGBA_PVRTC_4BPPV1_Format=35842,RGBA_PVRTC_2BPPV1_Format=35843,RGB_ETC1_Format=36196,RGB_ETC2_Format=37492,RGBA_ETC2_EAC_Format=37496,RGBA_ASTC_4x4_Format=37808,RGBA_ASTC_5x4_Format=37809,RGBA_ASTC_5x5_Format=37810,RGBA_ASTC_6x5_Format=37811,RGBA_ASTC_6x6_Format=37812,RGBA_ASTC_8x5_Format=37813,RGBA_ASTC_8x6_Format=37814,RGBA_ASTC_8x8_Format=37815,RGBA_ASTC_10x5_Format=37816,RGBA_ASTC_10x6_Format=37817,RGBA_ASTC_10x8_Format=37818,RGBA_ASTC_10x10_Format=37819,RGBA_ASTC_12x10_Format=37820,RGBA_ASTC_12x12_Format=37821,RGBA_BPTC_Format=36492,LoopOnce=2200,LoopRepeat=2201,LoopPingPong=2202,InterpolateDiscrete=2300,InterpolateLinear=2301,InterpolateSmooth=2302,ZeroCurvatureEnding=2400,ZeroSlopeEnding=2401,WrapAroundEnding=2402,NormalAnimationBlendMode=2500,AdditiveAnimationBlendMode=2501,TrianglesDrawMode=0,TriangleStripDrawMode=1,TriangleFanDrawMode=2,LinearEncoding=3e3,sRGBEncoding=3001,BasicDepthPacking=3200,RGBADepthPacking=3201,LinearDepthPacking=3202,RGBADistancePacking=3301,ESMDistancePacking=3302,TangentSpaceNormalMap=0,ObjectSpaceNormalMap=1,NoColorSpace="",SRGBColorSpace="srgb",LinearSRGBColorSpace="srgb-linear",ZeroStencilOp=0,KeepStencilOp=7680,ReplaceStencilOp=7681,IncrementStencilOp=7682,DecrementStencilOp=7683,IncrementWrapStencilOp=34055,DecrementWrapStencilOp=34056,InvertStencilOp=5386,NeverStencilFunc=512,LessStencilFunc=513,EqualStencilFunc=514,LessEqualStencilFunc=515,GreaterStencilFunc=516,NotEqualStencilFunc=517,GreaterEqualStencilFunc=518,AlwaysStencilFunc=519,StaticDrawUsage=35044,DynamicDrawUsage=35048,StreamDrawUsage=35040,StaticReadUsage=35045,DynamicReadUsage=35049,StreamReadUsage=35041,StaticCopyUsage=35046,DynamicCopyUsage=35050,StreamCopyUsage=35042,GLSL1="100",GLSL3="300 es",_SRGBAFormat=1035,ViewportFitNone=0,ViewportFitVertical=1,ViewportFitHorizontal=2,ViewportFitAuto=3,ViewportFitFill=4,ViewportFitOverscan=5,IBLEnvironmentPMREM=0,IBLEnvironmentProbe=1,IBLEnvironmentNone=2,TweenLinear=0,TweenSpherical=1,ReflectionProbeTypeInfinite=0,ReflectionProbeTypeSphere=1,ReflectionProbeTypeBox=2,NoOIT=0,OITWeighted=1,ConstraintSpaceWorld=0,ConstraintSpaceCustom=1,ConstraintSpaceLocal=2;class EventDispatcher{addEventListener(e,t){void 0===this._listeners&&(this._listeners={});const n=this._listeners;void 0===n[e]&&(n[e]=[]),-1===n[e].indexOf(t)&&n[e].push(t)}hasEventListener(e,t){if(void 0===this._listeners)return!1;const n=this._listeners;return void 0!==n[e]&&-1!==n[e].indexOf(t)}removeEventListener(e,t){if(void 0===this._listeners)return;const n=this._listeners[e];if(void 0!==n){const e=n.indexOf(t);-1!==e&&n.splice(e,1)}}dispatchEvent(e){if(void 0===this._listeners)return;const t=this._listeners[e.type];if(void 0!==t){e.target=this;const n=t.slice(0);for(let t=0,o=n.length;t<o;t++)n[t].call(this,e);e.target=null}}getListeners(){return this._listeners}}const UUID_PATTERN=new RegExp("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$"),DEG2RAD=Math.PI/180,RAD2DEG=180/Math.PI,_lut=["00","01","02","03","04","05","06","07","08","09","0a","0b","0c","0d","0e","0f","10","11","12","13","14","15","16","17","18","19","1a","1b","1c","1d","1e","1f","20","21","22","23","24","25","26","27","28","29","2a","2b","2c","2d","2e","2f","30","31","32","33","34","35","36","37","38","39","3a","3b","3c","3d","3e","3f","40","41","42","43","44","45","46","47","48","49","4a","4b","4c","4d","4e","4f","50","51","52","53","54","55","56","57","58","59","5a","5b","5c","5d","5e","5f","60","61","62","63","64","65","66","67","68","69","6a","6b","6c","6d","6e","6f","70","71","72","73","74","75","76","77","78","79","7a","7b","7c","7d","7e","7f","80","81","82","83","84","85","86","87","88","89","8a","8b","8c","8d","8e","8f","90","91","92","93","94","95","96","97","98","99","9a","9b","9c","9d","9e","9f","a0","a1","a2","a3","a4","a5","a6","a7","a8","a9","aa","ab","ac","ad","ae","af","b0","b1","b2","b3","b4","b5","b6","b7","b8","b9","ba","bb","bc","bd","be","bf","c0","c1","c2","c3","c4","c5","c6","c7","c8","c9","ca","cb","cc","cd","ce","cf","d0","d1","d2","d3","d4","d5","d6","d7","d8","d9","da","db","dc","dd","de","df","e0","e1","e2","e3","e4","e5","e6","e7","e8","e9","ea","eb","ec","ed","ee","ef","f0","f1","f2","f3","f4","f5","f6","f7","f8","f9","fa","fb","fc","fd","fe","ff"];let _seed=1234567;function generateUUID(){const e=4294967295*Math.random()|0,t=4294967295*Math.random()|0,n=4294967295*Math.random()|0,o=4294967295*Math.random()|0;return(_lut[255&e]+_lut[e>>8&255]+_lut[e>>16&255]+_lut[e>>24&255]+"-"+_lut[255&t]+_lut[t>>8&255]+"-"+_lut[t>>16&15|64]+_lut[t>>24&255]+"-"+_lut[63&n|128]+_lut[n>>8&255]+"-"+_lut[n>>16&255]+_lut[n>>24&255]+_lut[255&o]+_lut[o>>8&255]+_lut[o>>16&255]+_lut[o>>24&255]).toLowerCase()}function checkUUID(e){return UUID_PATTERN.test(e)}function clamp(e,t=0,n=1){return Math.max(t,Math.min(n,e))}function euclideanModulo(e,t){return(e%t+t)%t}function mapLinear(e,t,n,o,r){return o+(e-t)*(r-o)/(n-t)}function inverseLerp(e,t,n){return e!==t?(n-e)/(t-e):0}function lerp(e,t,n){return(1-n)*e+n*t}function damp(e,t,n,o){return lerp(e,t,1-Math.exp(-n*o))}function pingpong(e,t=1){return t-Math.abs(euclideanModulo(e,2*t)-t)}function smoothstep(e,t,n){return e<=t?0:e>=n?1:(e=(e-t)/(n-t))*e*(3-2*e)}function smootherstep(e,t,n){return e<=t?0:e>=n?1:(e=(e-t)/(n-t))*e*e*(e*(6*e-15)+10)}function randInt(e,t){return e+Math.floor(Math.random()*(t-e+1))}function randFloat(e,t){return e+Math.random()*(t-e)}function randFloatSpread(e){return e*(.5-Math.random())}function seededRandom(e){void 0!==e&&(_seed=e);let t=_seed+=1831565813;return t=Math.imul(t^t>>>15,1|t),t^=t+Math.imul(t^t>>>7,61|t),((t^t>>>14)>>>0)/4294967296}function degToRad(e){return e*DEG2RAD}function radToDeg(e){return e*RAD2DEG}function isPowerOfTwo(e){return!(e&e-1)&&0!==e}function ceilPowerOfTwo(e){return Math.pow(2,Math.ceil(Math.log(e)/Math.LN2))}function floorPowerOfTwo(e){return Math.pow(2,Math.floor(Math.log(e)/Math.LN2))}function setQuaternionFromProperEuler(e,t,n,o,r){const i=Math.cos,a=Math.sin,s=i(n/2),l=a(n/2),c=i((t+o)/2),u=a((t+o)/2),d=i((t-o)/2),h=a((t-o)/2),p=i((o-t)/2),f=a((o-t)/2);switch(r){case"XYX":e.set(s*u,l*d,l*h,s*c);break;case"YZY":e.set(l*h,s*u,l*d,s*c);break;case"ZXZ":e.set(l*d,l*h,s*u,s*c);break;case"XZX":e.set(s*u,l*f,l*p,s*c);break;case"YXY":e.set(l*p,s*u,l*f,s*c);break;case"ZYZ":e.set(l*f,l*p,s*u,s*c);break;default:console.warn("v3d.MathUtils: .setQuaternionFromProperEuler() encountered an unknown order: "+r)}}function denormalize(e,t){switch(t.constructor){case Float32Array:return e;case Uint16Array:return e/65535;case Uint8Array:return e/255;case Int16Array:return Math.max(e/32767,-1);case Int8Array:return Math.max(e/127,-1);default:throw new Error("Invalid component type.")}}function normalize(e,t){switch(t.constructor){case Float32Array:return e;case Uint16Array:return Math.round(65535*e);case Uint8Array:return Math.round(255*e);case Int16Array:return Math.round(32767*e);case Int8Array:return Math.round(127*e);default:throw new Error("Invalid component type.")}}function hashString(e){let t=5381,n=e.length;for(;n;)t=33*t^e.charCodeAt(--n);return t>>>0}function expAverage(e,t,n,o){let r=Math.exp(-n/o);return e*r+(1-r)*t}function expAverageClamp(e,t,n,o,r){let i=expAverage(e,t,n,o);return Math.abs(e-t)<r&&(i=t),i}function angleToRange_0_2Pi(e){return clamp(e-2*Math.PI*Math.floor(e/(2*Math.PI)),0,2*Math.PI)}function angleToRange_mPi_Pi(e){let t=e+Math.PI;return t%=2*Math.PI,t+=2*Math.PI,t%=2*Math.PI,t-=Math.PI,t}function clampAngle(e,t,n){let o=angleToRange_0_2Pi(e-t),r=angleToRange_0_2Pi(n-t);return o>r&&(o=o<r/2+Math.PI?r:0),o+t}var MathUtils=Object.freeze({__proto__:null,DEG2RAD:DEG2RAD,RAD2DEG:RAD2DEG,angleToRange_0_2Pi:angleToRange_0_2Pi,angleToRange_mPi_Pi:angleToRange_mPi_Pi,ceilPowerOfTwo:ceilPowerOfTwo,checkUUID:checkUUID,clamp:clamp,clampAngle:clampAngle,damp:damp,degToRad:degToRad,denormalize:denormalize,euclideanModulo:euclideanModulo,expAverage:expAverage,expAverageClamp:expAverageClamp,floorPowerOfTwo:floorPowerOfTwo,generateUUID:generateUUID,hashString:hashString,inverseLerp:inverseLerp,isPowerOfTwo:isPowerOfTwo,lerp:lerp,mapLinear:mapLinear,normalize:normalize,pingpong:pingpong,radToDeg:radToDeg,randFloat:randFloat,randFloatSpread:randFloatSpread,randInt:randInt,seededRandom:seededRandom,setQuaternionFromProperEuler:setQuaternionFromProperEuler,smootherstep:smootherstep,smoothstep:smoothstep});class Vector2{constructor(e=0,t=0){Vector2.prototype.isVector2=!0,this.x=e,this.y=t}get width(){return this.x}set width(e){this.x=e}get height(){return this.y}set height(e){this.y=e}set(e,t){return this.x=e,this.y=t,this}setScalar(e){return this.x=e,this.y=e,this}setX(e){return this.x=e,this}setY(e){return this.y=e,this}setComponent(e,t){switch(e){case 0:this.x=t;break;case 1:this.y=t;break;default:throw new Error("index is out of range: "+e)}return this}getComponent(e){switch(e){case 0:return this.x;case 1:return this.y;default:throw new Error("index is out of range: "+e)}}clone(){return new this.constructor(this.x,this.y)}copy(e){return this.x=e.x,this.y=e.y,this}add(e){return this.x+=e.x,this.y+=e.y,this}addScalar(e){return this.x+=e,this.y+=e,this}addVectors(e,t){return this.x=e.x+t.x,this.y=e.y+t.y,this}addScaledVector(e,t){return this.x+=e.x*t,this.y+=e.y*t,this}sub(e){return this.x-=e.x,this.y-=e.y,this}subScalar(e){return this.x-=e,this.y-=e,this}subVectors(e,t){return this.x=e.x-t.x,this.y=e.y-t.y,this}multiply(e){return this.x*=e.x,this.y*=e.y,this}multiplyScalar(e){return this.x*=e,this.y*=e,this}divide(e){return this.x/=e.x,this.y/=e.y,this}divideScalar(e){return this.multiplyScalar(1/e)}applyMatrix3(e){const t=this.x,n=this.y,o=e.elements;return this.x=o[0]*t+o[3]*n+o[6],this.y=o[1]*t+o[4]*n+o[7],this}min(e){return this.x=Math.min(this.x,e.x),this.y=Math.min(this.y,e.y),this}max(e){return this.x=Math.max(this.x,e.x),this.y=Math.max(this.y,e.y),this}clamp(e,t){return this.x=Math.max(e.x,Math.min(t.x,this.x)),this.y=Math.max(e.y,Math.min(t.y,this.y)),this}clampScalar(e,t){return this.x=Math.max(e,Math.min(t,this.x)),this.y=Math.max(e,Math.min(t,this.y)),this}clampLength(e,t){const n=this.length();return this.divideScalar(n||1).multiplyScalar(Math.max(e,Math.min(t,n)))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}roundToZero(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this}negate(){return this.x=-this.x,this.y=-this.y,this}dot(e){return this.x*e.x+this.y*e.y}cross(e){return this.x*e.y-this.y*e.x}lengthSq(){return this.x*this.x+this.y*this.y}length(){return Math.sqrt(this.x*this.x+this.y*this.y)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)}normalize(){return this.divideScalar(this.length()||1)}angle(){return Math.atan2(-this.y,-this.x)+Math.PI}distanceTo(e){return Math.sqrt(this.distanceToSquared(e))}distanceToSquared(e){const t=this.x-e.x,n=this.y-e.y;return t*t+n*n}manhattanDistanceTo(e){return Math.abs(this.x-e.x)+Math.abs(this.y-e.y)}setLength(e){return this.normalize().multiplyScalar(e)}lerp(e,t){return this.x+=(e.x-this.x)*t,this.y+=(e.y-this.y)*t,this}lerpVectors(e,t,n){return this.x=e.x+(t.x-e.x)*n,this.y=e.y+(t.y-e.y)*n,this}equals(e){return e.x===this.x&&e.y===this.y}fromArray(e,t=0){return this.x=e[t],this.y=e[t+1],this}toArray(e=[],t=0){return e[t]=this.x,e[t+1]=this.y,e}fromBufferAttribute(e,t){return this.x=e.getX(t),this.y=e.getY(t),this}rotateAround(e,t){const n=Math.cos(t),o=Math.sin(t),r=this.x-e.x,i=this.y-e.y;return this.x=r*n-i*o+e.x,this.y=r*o+i*n+e.y,this}random(){return this.x=Math.random(),this.y=Math.random(),this}*[Symbol.iterator](){yield this.x,yield this.y}}class Matrix3{constructor(){Matrix3.prototype.isMatrix3=!0,this.elements=[1,0,0,0,1,0,0,0,1]}set(e,t,n,o,r,i,a,s,l){const c=this.elements;return c[0]=e,c[1]=o,c[2]=a,c[3]=t,c[4]=r,c[5]=s,c[6]=n,c[7]=i,c[8]=l,this}identity(){return this.set(1,0,0,0,1,0,0,0,1),this}copy(e){const t=this.elements,n=e.elements;return t[0]=n[0],t[1]=n[1],t[2]=n[2],t[3]=n[3],t[4]=n[4],t[5]=n[5],t[6]=n[6],t[7]=n[7],t[8]=n[8],this}extractBasis(e,t,n){return e.setFromMatrix3Column(this,0),t.setFromMatrix3Column(this,1),n.setFromMatrix3Column(this,2),this}setFromMatrix4(e){const t=e.elements;return this.set(t[0],t[4],t[8],t[1],t[5],t[9],t[2],t[6],t[10]),this}multiply(e){return this.multiplyMatrices(this,e)}premultiply(e){return this.multiplyMatrices(e,this)}multiplyMatrices(e,t){const n=e.elements,o=t.elements,r=this.elements,i=n[0],a=n[3],s=n[6],l=n[1],c=n[4],u=n[7],d=n[2],h=n[5],p=n[8],f=o[0],m=o[3],g=o[6],_=o[1],A=o[4],v=o[7],x=o[2],y=o[5],b=o[8];return r[0]=i*f+a*_+s*x,r[3]=i*m+a*A+s*y,r[6]=i*g+a*v+s*b,r[1]=l*f+c*_+u*x,r[4]=l*m+c*A+u*y,r[7]=l*g+c*v+u*b,r[2]=d*f+h*_+p*x,r[5]=d*m+h*A+p*y,r[8]=d*g+h*v+p*b,this}multiplyScalar(e){const t=this.elements;return t[0]*=e,t[3]*=e,t[6]*=e,t[1]*=e,t[4]*=e,t[7]*=e,t[2]*=e,t[5]*=e,t[8]*=e,this}determinant(){const e=this.elements,t=e[0],n=e[1],o=e[2],r=e[3],i=e[4],a=e[5],s=e[6],l=e[7],c=e[8];return t*i*c-t*a*l-n*r*c+n*a*s+o*r*l-o*i*s}invert(){const e=this.elements,t=e[0],n=e[1],o=e[2],r=e[3],i=e[4],a=e[5],s=e[6],l=e[7],c=e[8],u=c*i-a*l,d=a*s-c*r,h=l*r-i*s,p=t*u+n*d+o*h;if(0===p)return this.set(0,0,0,0,0,0,0,0,0);const f=1/p;return e[0]=u*f,e[1]=(o*l-c*n)*f,e[2]=(a*n-o*i)*f,e[3]=d*f,e[4]=(c*t-o*s)*f,e[5]=(o*r-a*t)*f,e[6]=h*f,e[7]=(n*s-l*t)*f,e[8]=(i*t-n*r)*f,this}transpose(){let e;const t=this.elements;return e=t[1],t[1]=t[3],t[3]=e,e=t[2],t[2]=t[6],t[6]=e,e=t[5],t[5]=t[7],t[7]=e,this}getNormalMatrix(e){return this.setFromMatrix4(e).invert().transpose()}transposeIntoArray(e){const t=this.elements;return e[0]=t[0],e[1]=t[3],e[2]=t[6],e[3]=t[1],e[4]=t[4],e[5]=t[7],e[6]=t[2],e[7]=t[5],e[8]=t[8],this}setUvTransform(e,t,n,o,r,i,a){const s=Math.cos(r),l=Math.sin(r);return this.set(n*s,n*l,-n*(s*i+l*a)+i+e,-o*l,o*s,-o*(-l*i+s*a)+a+t,0,0,1),this}scale(e,t){return this.premultiply(_m3.makeScale(e,t)),this}rotate(e){return this.premultiply(_m3.makeRotation(-e)),this}translate(e,t){return this.premultiply(_m3.makeTranslation(e,t)),this}makeTranslation(e,t){return this.set(1,0,e,0,1,t,0,0,1),this}makeRotation(e){const t=Math.cos(e),n=Math.sin(e);return this.set(t,-n,0,n,t,0,0,0,1),this}makeScale(e,t){return this.set(e,0,0,0,t,0,0,0,1),this}equals(e){const t=this.elements,n=e.elements;for(let e=0;e<9;e++)if(t[e]!==n[e])return!1;return!0}fromArray(e,t=0){for(let n=0;n<9;n++)this.elements[n]=e[n+t];return this}toArray(e=[],t=0){const n=this.elements;return e[t]=n[0],e[t+1]=n[1],e[t+2]=n[2],e[t+3]=n[3],e[t+4]=n[4],e[t+5]=n[5],e[t+6]=n[6],e[t+7]=n[7],e[t+8]=n[8],e}clone(){return(new this.constructor).fromArray(this.elements)}}const _m3=new Matrix3;function arrayMin(e){if(0===e.length)return 1/0;let t=e[0];for(let n=1,o=e.length;n<o;++n)e[n]<t&&(t=e[n]);return t}function arrayMax(e){if(0===e.length)return-1/0;let t=e[0];for(let n=1,o=e.length;n<o;++n)e[n]>t&&(t=e[n]);return t}function arrayNeedsUint32(e){for(let t=e.length-1;t>=0;--t)if(e[t]>=65535)return!0;return!1}function createElementNS(e){return document.createElementNS("http://www.w3.org/1999/xhtml",e)}function probeAsync(e,t,n){return new Promise(function(o,r){setTimeout(function i(){switch(e.clientWaitSync(t,1,0)){case 37149:r();break;case 37147:setTimeout(i,n);break;default:o()}},n)})}function isDef(e){return void 0!==e}function clampArray(e,t,n){for(let o=0;o<e.length;o++)e[o]=clamp(e[o],t,n);return e}function strTitle(e){return e.charAt(0).toUpperCase()+e.slice(1).toLowerCase()}function strToCamel(e){return e.toLowerCase().replace(/_([a-zA-Z])/g,function(e){return e[1].toUpperCase()})}function getVerge3DVariantName(){return"Ultimate"}function parseEngineVersion(e){const t=e.match(/^[a-zA-Z38 ]*(\d+).(\d+).(\d+)(?: (.*))?$/)??[];let n=Number(t[1]),o=Number(t[2]),r=Number(t[3]);n=Number.isNaN(n)?0:n,o=Number.isNaN(o)?0:o,r=Number.isNaN(r)?0:r;return{major:n,minor:o,patch:r,pre:t[4]??""}}function engineVersionPreToNumber(e){if(""===e)return 1/0;const t=e.match(/^pre(\d+)$/)??[];let n=Number(t[1]);return n=Number.isNaN(n)?0:n,n}function engineVersionCmp(e,t,n=3){const o=parseEngineVersion(e),r=parseEngineVersion(t);let i=r.major-o.major;return 0===i&&n>1&&(i=r.minor-o.minor,0===i&&n>2&&(i=r.patch-o.patch,0===i&&n>3&&(i=engineVersionPreToNumber(r.pre)-engineVersionPreToNumber(o.pre),isNaN(i)&&(i=0)))),Math.sign(i)}function shaderFloatStr(e){return`${e%1?e:`${e}.0`}`}function getGlobalScope(){return"undefined"!=typeof window?window:"undefined"!=typeof self?self:global}const modulesInfo={};function findModulePath(e=""){const t=document.getElementsByTagName("script");let n=e;for(let o=t.length-1;o>=0;--o){const r=t[o].src,i=r.search(/\/v3d[\w.]+js/);i>-1&&(n=r.substr(0,i)+"/"+e)}return n}function loadModule(e,t=function(e){},n=function(e){}){modulesInfo[e]=modulesInfo[e]||{status:0,loadCallbacks:[],errorCallbacks:[]};const o=modulesInfo[e];if(4==o.status)return void t(e);if(o.loadCallbacks.push(t),o.errorCallbacks.push(n),o.status>0)return;let r=findModulePath(e);const i=document.createElement("script");i.type="text/javascript",i.src=r,function(e){i.onload=function(){modulesInfo[e].loadCallbacks.forEach(function(t){t(e)}),modulesInfo[e].status=4},i.onerror=function(){modulesInfo[e].errorCallbacks.forEach(function(t){t(e)}),modulesInfo[e].status=0}}(e),document.getElementsByTagName("head")[0].appendChild(i),o.status=3}function arrayForEachPromise(e,t,n=0){const o=function(e,o,r,i){const a=performance.now();return t(e,o,r),a-i>n?(i=a,new Promise(function(e){setTimeout(function(){e(i)},1)})):i};let r=Promise.resolve(performance.now());return e.forEach(function(e,t,n){r=r.then(o.bind(null,e,t,n))}),r}function checkDevTools(){return"undefined"!=typeof __V3D_DEVTOOLS__}function sendDevTools(e,t){checkDevTools()&&__V3D_DEVTOOLS__.dispatchEvent(new CustomEvent(e,{detail:t}))}function SRGBToLinear(e){return e<.04045?.0773993808*e:Math.pow(.9478672986*e+.0521327014,2.4)}function LinearToSRGB(e){return e<.0031308?12.92*e:1.055*Math.pow(e,.41666)-.055}const FN={[SRGBColorSpace]:{[LinearSRGBColorSpace]:SRGBToLinear},[LinearSRGBColorSpace]:{[SRGBColorSpace]:LinearToSRGB}},ColorManagement={legacyMode:!0,get workingColorSpace(){return"srgb-linear"},set workingColorSpace(e){console.warn("v3d.ColorManagement: .workingColorSpace is readonly.")},convert:function(e,t,n){if(this.legacyMode||t===n||!t||!n)return e;if(FN[t]&&void 0!==FN[t][n]){const o=FN[t][n];return e.r=o(e.r),e.g=o(e.g),e.b=o(e.b),e}throw new Error("Unsupported color space conversion.")},fromWorkingColorSpace:function(e,t){return this.convert(e,this.workingColorSpace,t)},toWorkingColorSpace:function(e,t){return this.convert(e,t,this.workingColorSpace)}},_colorKeywords={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074},_rgb$1={r:0,g:0,b:0},_hslA={h:0,s:0,l:0},_hslB={h:0,s:0,l:0};function hue2rgb(e,t,n){return n<0&&(n+=1),n>1&&(n-=1),n<1/6?e+6*(t-e)*n:n<.5?t:n<2/3?e+6*(t-e)*(2/3-n):e}function toComponents(e,t){return t.r=e.r,t.g=e.g,t.b=e.b,t}class Color{constructor(e,t,n){return this.isColor=!0,this.r=1,this.g=1,this.b=1,void 0===t&&void 0===n?this.set(e):this.setRGB(e,t,n)}set(e){return e&&e.isColor?this.copy(e):"number"==typeof e?this.setHex(e):"string"==typeof e&&this.setStyle(e),this}setScalar(e){return this.r=e,this.g=e,this.b=e,this}setHex(e,t="srgb"){return e=Math.floor(e),this.r=(e>>16&255)/255,this.g=(e>>8&255)/255,this.b=(255&e)/255,ColorManagement.toWorkingColorSpace(this,t),this}setRGB(e,t,n,o=ColorManagement.workingColorSpace){return this.r=e,this.g=t,this.b=n,ColorManagement.toWorkingColorSpace(this,o),this}setHSL(e,t,n,o=ColorManagement.workingColorSpace){if(e=euclideanModulo(e,1),t=clamp(t,0,1),n=clamp(n,0,1),0===t)this.r=this.g=this.b=n;else{const o=n<=.5?n*(1+t):n+t-n*t,r=2*n-o;this.r=hue2rgb(r,o,e+1/3),this.g=hue2rgb(r,o,e),this.b=hue2rgb(r,o,e-1/3)}return ColorManagement.toWorkingColorSpace(this,o),this}setStyle(e,t="srgb"){function n(t){void 0!==t&&parseFloat(t)<1&&console.warn("v3d.Color: Alpha component of "+e+" will be ignored.")}let o;if(o=/^((?:rgb|hsl)a?)\(([^\)]*)\)/.exec(e)){let e;const r=o[1],i=o[2];switch(r){case"rgb":case"rgba":if(e=/^\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(i))return this.r=Math.min(255,parseInt(e[1],10))/255,this.g=Math.min(255,parseInt(e[2],10))/255,this.b=Math.min(255,parseInt(e[3],10))/255,ColorManagement.toWorkingColorSpace(this,t),n(e[4]),this;if(e=/^\s*(\d+)\%\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(i))return this.r=Math.min(100,parseInt(e[1],10))/100,this.g=Math.min(100,parseInt(e[2],10))/100,this.b=Math.min(100,parseInt(e[3],10))/100,ColorManagement.toWorkingColorSpace(this,t),n(e[4]),this;break;case"hsl":case"hsla":if(e=/^\s*(\d*\.?\d+)\s*,\s*(\d*\.?\d+)\%\s*,\s*(\d*\.?\d+)\%\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(i)){const o=parseFloat(e[1])/360,r=parseFloat(e[2])/100,i=parseFloat(e[3])/100;return n(e[4]),this.setHSL(o,r,i,t)}}}else if(o=/^\#([A-Fa-f\d]+)$/.exec(e)){const e=o[1],n=e.length;if(3===n)return this.r=parseInt(e.charAt(0)+e.charAt(0),16)/255,this.g=parseInt(e.charAt(1)+e.charAt(1),16)/255,this.b=parseInt(e.charAt(2)+e.charAt(2),16)/255,ColorManagement.toWorkingColorSpace(this,t),this;if(6===n)return this.r=parseInt(e.charAt(0)+e.charAt(1),16)/255,this.g=parseInt(e.charAt(2)+e.charAt(3),16)/255,this.b=parseInt(e.charAt(4)+e.charAt(5),16)/255,ColorManagement.toWorkingColorSpace(this,t),this}return e&&e.length>0?this.setColorName(e,t):this}setColorName(e,t="srgb"){const n=_colorKeywords[e.toLowerCase()];return void 0!==n?this.setHex(n,t):console.warn("v3d.Color: Unknown color "+e),this}clone(){return new this.constructor(this.r,this.g,this.b)}copy(e){return this.r=e.r,this.g=e.g,this.b=e.b,this}copySRGBToLinear(e){return this.r=SRGBToLinear(e.r),this.g=SRGBToLinear(e.g),this.b=SRGBToLinear(e.b),this}copyLinearToSRGB(e){return this.r=LinearToSRGB(e.r),this.g=LinearToSRGB(e.g),this.b=LinearToSRGB(e.b),this}convertSRGBToLinear(){return this.copySRGBToLinear(this),this}convertLinearToSRGB(){return this.copyLinearToSRGB(this),this}getHex(e="srgb"){return ColorManagement.fromWorkingColorSpace(toComponents(this,_rgb$1),e),clamp(255*_rgb$1.r,0,255)<<16^clamp(255*_rgb$1.g,0,255)<<8^clamp(255*_rgb$1.b,0,255)}getHexString(e="srgb"){return("000000"+this.getHex(e).toString(16)).slice(-6)}getHSL(e,t=ColorManagement.workingColorSpace){ColorManagement.fromWorkingColorSpace(toComponents(this,_rgb$1),t);const n=_rgb$1.r,o=_rgb$1.g,r=_rgb$1.b,i=Math.max(n,o,r),a=Math.min(n,o,r);let s,l;const c=(a+i)/2;if(a===i)s=0,l=0;else{const e=i-a;switch(l=c<=.5?e/(i+a):e/(2-i-a),i){case n:s=(o-r)/e+(o<r?6:0);break;case o:s=(r-n)/e+2;break;case r:s=(n-o)/e+4}s/=6}return e.h=s,e.s=l,e.l=c,e}getRGB(e,t=ColorManagement.workingColorSpace){return ColorManagement.fromWorkingColorSpace(toComponents(this,_rgb$1),t),e.r=_rgb$1.r,e.g=_rgb$1.g,e.b=_rgb$1.b,e}getStyle(e="srgb"){return ColorManagement.fromWorkingColorSpace(toComponents(this,_rgb$1),e),"srgb"!==e?`color(${e} ${_rgb$1.r} ${_rgb$1.g} ${_rgb$1.b})`:`rgb(${255*_rgb$1.r|0},${255*_rgb$1.g|0},${255*_rgb$1.b|0})`}offsetHSL(e,t,n){return this.getHSL(_hslA),_hslA.h+=e,_hslA.s+=t,_hslA.l+=n,this.setHSL(_hslA.h,_hslA.s,_hslA.l),this}add(e){return this.r+=e.r,this.g+=e.g,this.b+=e.b,this}addColors(e,t){return this.r=e.r+t.r,this.g=e.g+t.g,this.b=e.b+t.b,this}addScalar(e){return this.r+=e,this.g+=e,this.b+=e,this}sub(e){return this.r=Math.max(0,this.r-e.r),this.g=Math.max(0,this.g-e.g),this.b=Math.max(0,this.b-e.b),this}multiply(e){return this.r*=e.r,this.g*=e.g,this.b*=e.b,this}multiplyScalar(e){return this.r*=e,this.g*=e,this.b*=e,this}lerp(e,t){return this.r+=(e.r-this.r)*t,this.g+=(e.g-this.g)*t,this.b+=(e.b-this.b)*t,this}lerpColors(e,t,n){return this.r=e.r+(t.r-e.r)*n,this.g=e.g+(t.g-e.g)*n,this.b=e.b+(t.b-e.b)*n,this}lerpHSL(e,t){this.getHSL(_hslA),e.getHSL(_hslB);const n=lerp(_hslA.h,_hslB.h,t),o=lerp(_hslA.s,_hslB.s,t),r=lerp(_hslA.l,_hslB.l,t);return this.setHSL(n,o,r),this}equals(e){return e.r===this.r&&e.g===this.g&&e.b===this.b}fromArray(e,t=0){return this.r=e[t],this.g=e[t+1],this.b=e[t+2],this}toArray(e=[],t=0){return e[t]=this.r,e[t+1]=this.g,e[t+2]=this.b,e}fromBufferAttribute(e,t){return this.r=e.getX(t),this.g=e.getY(t),this.b=e.getZ(t),this}*[Symbol.iterator](){yield this.r,yield this.g,yield this.b}}let _canvas;Color.NAMES=_colorKeywords;class ImageUtils{static getDataURL(e){if(/^data:/i.test(e.src))return e.src;if("undefined"==typeof HTMLCanvasElement)return e.src;let t;if(e instanceof HTMLCanvasElement)t=e;else{void 0===_canvas&&(_canvas=createElementNS("canvas")),_canvas.width=e.width,_canvas.height=e.height;const n=_canvas.getContext("2d");e instanceof ImageData?n.putImageData(e,0,0):n.drawImage(e,0,0,e.width,e.height),t=_canvas}return t.width>2048||t.height>2048?(console.warn("v3d.ImageUtils.getDataURL: Image converted to jpg for performance reasons",e),t.toDataURL("image/jpeg",.6)):t.toDataURL("image/png")}static sRGBToLinear(e){if("undefined"!=typeof HTMLImageElement&&e instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&e instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap){const t=createElementNS("canvas");t.width=e.width,t.height=e.height;const n=t.getContext("2d");n.drawImage(e,0,0,e.width,e.height);const o=n.getImageData(0,0,e.width,e.height),r=o.data;for(let e=0;e<r.length;e++)r[e]=255*SRGBToLinear(r[e]/255);return n.putImageData(o,0,0),t}if(e.data){const t=e.data.slice(0);for(let e=0;e<t.length;e++)t instanceof Uint8Array||t instanceof Uint8ClampedArray?t[e]=Math.floor(255*SRGBToLinear(t[e]/255)):t[e]=SRGBToLinear(t[e]);return{data:t,width:e.width,height:e.height}}return console.warn("v3d.ImageUtils.sRGBToLinear(): Unsupported image type. No color space conversion applied."),e}}let _sourceId=0;class Source{constructor(e=null){this.isSource=!0,Object.defineProperty(this,"id",{value:_sourceId++}),this.uuid=generateUUID(),this.data=e,this.version=0}set needsUpdate(e){!0===e&&this.version++}}let textureId=0;class Texture extends EventDispatcher{constructor(e=Texture.DEFAULT_IMAGE,t=Texture.DEFAULT_MAPPING,n=1001,o=1001,r=1006,i=1008,a=1023,s=1009,l=Texture.DEFAULT_ANISOTROPY,c=3e3){super(),this.isTexture=!0,Object.defineProperty(this,"id",{value:textureId++}),this.uuid=generateUUID(),this.name="",this.source=new Source(e),this.mipmaps=[],this.mapping=t,this.wrapS=n,this.wrapT=o,this.magFilter=r,this.minFilter=i,this.anisotropy=l,this.format=a,this.internalFormat=null,this.type=s,this.offset=new Vector2(0,0),this.repeat=new Vector2(1,1),this.center=new Vector2(0,0),this.rotation=0,this.matrixAutoUpdate=!0,this.matrix=new Matrix3,this.generateMipmaps=!0,this.premultiplyAlpha=!1,this.flipY=!0,this.unpackAlignment=4,this.encoding=c,this.userData={},this.version=0,this.onUpdate=null,this.isRenderTargetTexture=!1,this.needsPMREMUpdate=!1}get image(){return this.source.data}set image(e){this.source.data=e}updateMatrix(){this.matrix.setUvTransform(this.offset.x,this.offset.y,this.repeat.x,this.repeat.y,this.rotation,this.center.x,this.center.y)}clone(){return(new this.constructor).copy(this)}copy(e){return this.name=e.name,this.source=e.source,this.mipmaps=e.mipmaps.slice(0),this.mapping=e.mapping,this.wrapS=e.wrapS,this.wrapT=e.wrapT,this.magFilter=e.magFilter,this.minFilter=e.minFilter,this.anisotropy=e.anisotropy,this.format=e.format,this.internalFormat=e.internalFormat,this.type=e.type,this.offset.copy(e.offset),this.repeat.copy(e.repeat),this.center.copy(e.center),this.rotation=e.rotation,this.matrixAutoUpdate=e.matrixAutoUpdate,this.matrix.copy(e.matrix),this.generateMipmaps=e.generateMipmaps,this.premultiplyAlpha=e.premultiplyAlpha,this.flipY=e.flipY,this.unpackAlignment=e.unpackAlignment,this.encoding=e.encoding,this.userData=JSON.parse(JSON.stringify(e.userData)),this.needsUpdate=!0,this}dispose(){this.dispatchEvent({type:"dispose"})}transformUv(e){if(300!==this.mapping)return e;if(e.applyMatrix3(this.matrix),e.x<0||e.x>1)switch(this.wrapS){case 1e3:e.x=e.x-Math.floor(e.x);break;case 1001:e.x=e.x<0?0:1;break;case 1002:1===Math.abs(Math.floor(e.x)%2)?e.x=Math.ceil(e.x)-e.x:e.x=e.x-Math.floor(e.x)}if(e.y<0||e.y>1)switch(this.wrapT){case 1e3:e.y=e.y-Math.floor(e.y);break;case 1001:e.y=e.y<0?0:1;break;case 1002:1===Math.abs(Math.floor(e.y)%2)?e.y=Math.ceil(e.y)-e.y:e.y=e.y-Math.floor(e.y)}return this.flipY&&(e.y=1-e.y),e}set needsUpdate(e){!0===e&&(this.version++,this.source.needsUpdate=!0)}}Texture.DEFAULT_IMAGE=null,Texture.DEFAULT_MAPPING=300,Texture.DEFAULT_ANISOTROPY=1;class Vector4{constructor(e=0,t=0,n=0,o=1){Vector4.prototype.isVector4=!0,this.x=e,this.y=t,this.z=n,this.w=o}get width(){return this.z}set width(e){this.z=e}get height(){return this.w}set height(e){this.w=e}set(e,t,n,o){return this.x=e,this.y=t,this.z=n,this.w=o,this}setScalar(e){return this.x=e,this.y=e,this.z=e,this.w=e,this}setX(e){return this.x=e,this}setY(e){return this.y=e,this}setZ(e){return this.z=e,this}setW(e){return this.w=e,this}setComponent(e,t){switch(e){case 0:this.x=t;break;case 1:this.y=t;break;case 2:this.z=t;break;case 3:this.w=t;break;default:throw new Error("index is out of range: "+e)}return this}getComponent(e){switch(e){case 0:return this.x;case 1:return this.y;case 2:return this.z;case 3:return this.w;default:throw new Error("index is out of range: "+e)}}clone(){return new this.constructor(this.x,this.y,this.z,this.w)}copy(e){return this.x=e.x,this.y=e.y,this.z=e.z,this.w=void 0!==e.w?e.w:1,this}add(e){return this.x+=e.x,this.y+=e.y,this.z+=e.z,this.w+=e.w,this}addScalar(e){return this.x+=e,this.y+=e,this.z+=e,this.w+=e,this}addVectors(e,t){return this.x=e.x+t.x,this.y=e.y+t.y,this.z=e.z+t.z,this.w=e.w+t.w,this}addScaledVector(e,t){return this.x+=e.x*t,this.y+=e.y*t,this.z+=e.z*t,this.w+=e.w*t,this}sub(e){return this.x-=e.x,this.y-=e.y,this.z-=e.z,this.w-=e.w,this}subScalar(e){return this.x-=e,this.y-=e,this.z-=e,this.w-=e,this}subVectors(e,t){return this.x=e.x-t.x,this.y=e.y-t.y,this.z=e.z-t.z,this.w=e.w-t.w,this}multiply(e){return this.x*=e.x,this.y*=e.y,this.z*=e.z,this.w*=e.w,this}multiplyScalar(e){return this.x*=e,this.y*=e,this.z*=e,this.w*=e,this}applyMatrix4(e){const t=this.x,n=this.y,o=this.z,r=this.w,i=e.elements;return this.x=i[0]*t+i[4]*n+i[8]*o+i[12]*r,this.y=i[1]*t+i[5]*n+i[9]*o+i[13]*r,this.z=i[2]*t+i[6]*n+i[10]*o+i[14]*r,this.w=i[3]*t+i[7]*n+i[11]*o+i[15]*r,this}divideScalar(e){return this.multiplyScalar(1/e)}setAxisAngleFromQuaternion(e){this.w=2*Math.acos(e.w);const t=Math.sqrt(1-e.w*e.w);return t<1e-4?(this.x=1,this.y=0,this.z=0):(this.x=e.x/t,this.y=e.y/t,this.z=e.z/t),this}setAxisAngleFromRotationMatrix(e){let t,n,o,r;const i=.01,a=.1,s=e.elements,l=s[0],c=s[4],u=s[8],d=s[1],h=s[5],p=s[9],f=s[2],m=s[6],g=s[10];if(Math.abs(c-d)<i&&Math.abs(u-f)<i&&Math.abs(p-m)<i){if(Math.abs(c+d)<a&&Math.abs(u+f)<a&&Math.abs(p+m)<a&&Math.abs(l+h+g-3)<a)return this.set(1,0,0,0),this;t=Math.PI;const e=(l+1)/2,s=(h+1)/2,_=(g+1)/2,A=(c+d)/4,v=(u+f)/4,x=(p+m)/4;return e>s&&e>_?e<i?(n=0,o=.707106781,r=.707106781):(n=Math.sqrt(e),o=A/n,r=v/n):s>_?s<i?(n=.707106781,o=0,r=.707106781):(o=Math.sqrt(s),n=A/o,r=x/o):_<i?(n=.707106781,o=.707106781,r=0):(r=Math.sqrt(_),n=v/r,o=x/r),this.set(n,o,r,t),this}let _=Math.sqrt((m-p)*(m-p)+(u-f)*(u-f)+(d-c)*(d-c));return Math.abs(_)<.001&&(_=1),this.x=(m-p)/_,this.y=(u-f)/_,this.z=(d-c)/_,this.w=Math.acos((l+h+g-1)/2),this}min(e){return this.x=Math.min(this.x,e.x),this.y=Math.min(this.y,e.y),this.z=Math.min(this.z,e.z),this.w=Math.min(this.w,e.w),this}max(e){return this.x=Math.max(this.x,e.x),this.y=Math.max(this.y,e.y),this.z=Math.max(this.z,e.z),this.w=Math.max(this.w,e.w),this}clamp(e,t){return this.x=Math.max(e.x,Math.min(t.x,this.x)),this.y=Math.max(e.y,Math.min(t.y,this.y)),this.z=Math.max(e.z,Math.min(t.z,this.z)),this.w=Math.max(e.w,Math.min(t.w,this.w)),this}clampScalar(e,t){return this.x=Math.max(e,Math.min(t,this.x)),this.y=Math.max(e,Math.min(t,this.y)),this.z=Math.max(e,Math.min(t,this.z)),this.w=Math.max(e,Math.min(t,this.w)),this}clampLength(e,t){const n=this.length();return this.divideScalar(n||1).multiplyScalar(Math.max(e,Math.min(t,n)))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this.w=Math.floor(this.w),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this.w=Math.ceil(this.w),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this.w=Math.round(this.w),this}roundToZero(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z),this.w=this.w<0?Math.ceil(this.w):Math.floor(this.w),this}negate(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this.w=-this.w,this}dot(e){return this.x*e.x+this.y*e.y+this.z*e.z+this.w*e.w}lengthSq(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w}length(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)+Math.abs(this.w)}normalize(){return this.divideScalar(this.length()||1)}setLength(e){return this.normalize().multiplyScalar(e)}lerp(e,t){return this.x+=(e.x-this.x)*t,this.y+=(e.y-this.y)*t,this.z+=(e.z-this.z)*t,this.w+=(e.w-this.w)*t,this}lerpVectors(e,t,n){return this.x=e.x+(t.x-e.x)*n,this.y=e.y+(t.y-e.y)*n,this.z=e.z+(t.z-e.z)*n,this.w=e.w+(t.w-e.w)*n,this}equals(e){return e.x===this.x&&e.y===this.y&&e.z===this.z&&e.w===this.w}fromArray(e,t=0){return this.x=e[t],this.y=e[t+1],this.z=e[t+2],this.w=e[t+3],this}toArray(e=[],t=0){return e[t]=this.x,e[t+1]=this.y,e[t+2]=this.z,e[t+3]=this.w,e}fromBufferAttribute(e,t){return this.x=e.getX(t),this.y=e.getY(t),this.z=e.getZ(t),this.w=e.getW(t),this}random(){return this.x=Math.random(),this.y=Math.random(),this.z=Math.random(),this.w=Math.random(),this}*[Symbol.iterator](){yield this.x,yield this.y,yield this.z,yield this.w}}class WebGLRenderTarget extends EventDispatcher{constructor(e=1,t=1,n={}){super(),this.isWebGLRenderTarget=!0,this.width=e,this.height=t,this.depth=1,this.scissor=new Vector4(0,0,e,t),this.scissorTest=!1,this.viewport=new Vector4(0,0,e,t);const o={width:e,height:t,depth:1};this.texture=new Texture(o,n.mapping,n.wrapS,n.wrapT,n.magFilter,n.minFilter,n.format,n.type,n.anisotropy,n.encoding),this.texture.isRenderTargetTexture=!0,this.texture.flipY=!1,this.texture.generateMipmaps=void 0!==n.generateMipmaps&&n.generateMipmaps,this.texture.internalFormat=void 0!==n.internalFormat?n.internalFormat:null,this.texture.minFilter=void 0!==n.minFilter?n.minFilter:1006,this.depthBuffer=void 0===n.depthBuffer||n.depthBuffer,this.stencilBuffer=void 0!==n.stencilBuffer&&n.stencilBuffer,this.depthTexture=void 0!==n.depthTexture?n.depthTexture:null,this.samples=void 0!==n.samples?n.samples:0}setSize(e,t,n=1){this.width===e&&this.height===t&&this.depth===n||(this.width=e,this.height=t,this.depth=n,this.texture.image.width=e,this.texture.image.height=t,this.texture.image.depth=n,this.dispose()),this.viewport.set(0,0,e,t),this.scissor.set(0,0,e,t)}clone(){return(new this.constructor).copy(this)}copy(e){this.width=e.width,this.height=e.height,this.depth=e.depth,this.viewport.copy(e.viewport),this.texture=e.texture.clone(),this.texture.isRenderTargetTexture=!0;const t=Object.assign({},e.texture.image);return this.texture.source=new Source(t),this.depthBuffer=e.depthBuffer,this.stencilBuffer=e.stencilBuffer,null!==e.depthTexture&&(this.depthTexture=e.depthTexture.clone()),this.samples=e.samples,this}dispose(){this.dispatchEvent({type:"dispose"})}}class DataArrayTexture extends Texture{constructor(e=null,t=1,n=1,o=1){super(null),this.isDataArrayTexture=!0,this.image={data:e,width:t,height:n,depth:o},this.magFilter=1003,this.minFilter=1003,this.wrapR=1001,this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1}}class WebGLArrayRenderTarget extends WebGLRenderTarget{constructor(e=1,t=1,n=1){super(e,t),this.isWebGLArrayRenderTarget=!0,this.depth=n,this.texture=new DataArrayTexture(null,e,t,n),this.texture.isRenderTargetTexture=!0}}class Data3DTexture extends Texture{constructor(e=null,t=1,n=1,o=1){super(null),this.isData3DTexture=!0,this.image={data:e,width:t,height:n,depth:o},this.magFilter=1003,this.minFilter=1003,this.wrapR=1001,this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1}}class WebGL3DRenderTarget extends WebGLRenderTarget{constructor(e=1,t=1,n=1){super(e,t),this.isWebGL3DRenderTarget=!0,this.depth=n,this.texture=new Data3DTexture(null,e,t,n),this.texture.isRenderTargetTexture=!0}}class WebGLMultipleRenderTargets extends WebGLRenderTarget{constructor(e=1,t=1,n=1,o={}){super(e,t,o),this.isWebGLMultipleRenderTargets=!0;const r=this.texture;this.texture=[];for(let e=0;e<n;e++)this.texture[e]=r.clone(),this.texture[e].isRenderTargetTexture=!0}setSize(e,t,n=1){if(this.width!==e||this.height!==t||this.depth!==n){this.width=e,this.height=t,this.depth=n;for(let o=0,r=this.texture.length;o<r;o++)this.texture[o].image.width=e,this.texture[o].image.height=t,this.texture[o].image.depth=n;this.dispose()}return this.viewport.set(0,0,e,t),this.scissor.set(0,0,e,t),this}copy(e){this.dispose(),this.width=e.width,this.height=e.height,this.depth=e.depth,this.viewport.set(0,0,this.width,this.height),this.scissor.set(0,0,this.width,this.height),this.depthBuffer=e.depthBuffer,this.stencilBuffer=e.stencilBuffer,null!==e.depthTexture&&(this.depthTexture=e.depthTexture.clone()),this.texture.length=0;for(let t=0,n=e.texture.length;t<n;t++)this.texture[t]=e.texture[t].clone(),this.texture[t].isRenderTargetTexture=!0;return this}}class Quaternion{constructor(e=0,t=0,n=0,o=1){this.isQuaternion=!0,this._x=e,this._y=t,this._z=n,this._w=o}static slerpFlat(e,t,n,o,r,i,a){let s=n[o+0],l=n[o+1],c=n[o+2],u=n[o+3];const d=r[i+0],h=r[i+1],p=r[i+2],f=r[i+3];if(0===a)return e[t+0]=s,e[t+1]=l,e[t+2]=c,void(e[t+3]=u);if(1===a)return e[t+0]=d,e[t+1]=h,e[t+2]=p,void(e[t+3]=f);if(u!==f||s!==d||l!==h||c!==p){let e=1-a;const t=s*d+l*h+c*p+u*f,n=t>=0?1:-1,o=1-t*t;if(o>Number.EPSILON){const r=Math.sqrt(o),i=Math.atan2(r,t*n);e=Math.sin(e*i)/r,a=Math.sin(a*i)/r}const r=a*n;if(s=s*e+d*r,l=l*e+h*r,c=c*e+p*r,u=u*e+f*r,e===1-a){const e=1/Math.sqrt(s*s+l*l+c*c+u*u);s*=e,l*=e,c*=e,u*=e}}e[t]=s,e[t+1]=l,e[t+2]=c,e[t+3]=u}static multiplyQuaternionsFlat(e,t,n,o,r,i){const a=n[o],s=n[o+1],l=n[o+2],c=n[o+3],u=r[i],d=r[i+1],h=r[i+2],p=r[i+3];return e[t]=a*p+c*u+s*h-l*d,e[t+1]=s*p+c*d+l*u-a*h,e[t+2]=l*p+c*h+a*d-s*u,e[t+3]=c*p-a*u-s*d-l*h,e}get x(){return this._x}set x(e){this._x=e,this._onChangeCallback()}get y(){return this._y}set y(e){this._y=e,this._onChangeCallback()}get z(){return this._z}set z(e){this._z=e,this._onChangeCallback()}get w(){return this._w}set w(e){this._w=e,this._onChangeCallback()}set(e,t,n,o){return this._x=e,this._y=t,this._z=n,this._w=o,this._onChangeCallback(),this}clone(){return new this.constructor(this._x,this._y,this._z,this._w)}copy(e){return this._x=e.x,this._y=e.y,this._z=e.z,this._w=e.w,this._onChangeCallback(),this}setFromEuler(e,t){const n=e._x,o=e._y,r=e._z,i=e._order,a=Math.cos,s=Math.sin,l=a(n/2),c=a(o/2),u=a(r/2),d=s(n/2),h=s(o/2),p=s(r/2);switch(i){case"XYZ":this._x=d*c*u+l*h*p,this._y=l*h*u-d*c*p,this._z=l*c*p+d*h*u,this._w=l*c*u-d*h*p;break;case"YXZ":this._x=d*c*u+l*h*p,this._y=l*h*u-d*c*p,this._z=l*c*p-d*h*u,this._w=l*c*u+d*h*p;break;case"ZXY":this._x=d*c*u-l*h*p,this._y=l*h*u+d*c*p,this._z=l*c*p+d*h*u,this._w=l*c*u-d*h*p;break;case"ZYX":this._x=d*c*u-l*h*p,this._y=l*h*u+d*c*p,this._z=l*c*p-d*h*u,this._w=l*c*u+d*h*p;break;case"YZX":this._x=d*c*u+l*h*p,this._y=l*h*u+d*c*p,this._z=l*c*p-d*h*u,this._w=l*c*u-d*h*p;break;case"XZY":this._x=d*c*u-l*h*p,this._y=l*h*u-d*c*p,this._z=l*c*p+d*h*u,this._w=l*c*u+d*h*p;break;default:console.warn("v3d.Quaternion: .setFromEuler() encountered an unknown order: "+i)}return!1!==t&&this._onChangeCallback(),this}setFromAxisAngle(e,t){const n=t/2,o=Math.sin(n);return this._x=e.x*o,this._y=e.y*o,this._z=e.z*o,this._w=Math.cos(n),this._onChangeCallback(),this}setFromRotationMatrix(e){const t=e.elements,n=t[0],o=t[4],r=t[8],i=t[1],a=t[5],s=t[9],l=t[2],c=t[6],u=t[10],d=n+a+u;if(d>0){const e=.5/Math.sqrt(d+1);this._w=.25/e,this._x=(c-s)*e,this._y=(r-l)*e,this._z=(i-o)*e}else if(n>a&&n>u){const e=2*Math.sqrt(1+n-a-u);this._w=(c-s)/e,this._x=.25*e,this._y=(o+i)/e,this._z=(r+l)/e}else if(a>u){const e=2*Math.sqrt(1+a-n-u);this._w=(r-l)/e,this._x=(o+i)/e,this._y=.25*e,this._z=(s+c)/e}else{const e=2*Math.sqrt(1+u-n-a);this._w=(i-o)/e,this._x=(r+l)/e,this._y=(s+c)/e,this._z=.25*e}return this._onChangeCallback(),this}setFromUnitVectors(e,t){let n=e.dot(t)+1;return n<Number.EPSILON?(n=0,Math.abs(e.x)>Math.abs(e.z)?(this._x=-e.y,this._y=e.x,this._z=0,this._w=n):(this._x=0,this._y=-e.z,this._z=e.y,this._w=n)):(this._x=e.y*t.z-e.z*t.y,this._y=e.z*t.x-e.x*t.z,this._z=e.x*t.y-e.y*t.x,this._w=n),this.normalize()}angleTo(e){return 2*Math.acos(Math.abs(clamp(this.dot(e),-1,1)))}rotateTowards(e,t){const n=this.angleTo(e);if(0===n)return this;const o=Math.min(1,t/n);return this.slerp(e,o),this}identity(){return this.set(0,0,0,1)}invert(){return this.conjugate()}conjugate(){return this._x*=-1,this._y*=-1,this._z*=-1,this._onChangeCallback(),this}dot(e){return this._x*e._x+this._y*e._y+this._z*e._z+this._w*e._w}lengthSq(){return this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w}length(){return Math.sqrt(this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w)}normalize(){let e=this.length();return 0===e?(this._x=0,this._y=0,this._z=0,this._w=1):(e=1/e,this._x=this._x*e,this._y=this._y*e,this._z=this._z*e,this._w=this._w*e),this._onChangeCallback(),this}multiply(e){return this.multiplyQuaternions(this,e)}premultiply(e){return this.multiplyQuaternions(e,this)}multiplyQuaternions(e,t){const n=e._x,o=e._y,r=e._z,i=e._w,a=t._x,s=t._y,l=t._z,c=t._w;return this._x=n*c+i*a+o*l-r*s,this._y=o*c+i*s+r*a-n*l,this._z=r*c+i*l+n*s-o*a,this._w=i*c-n*a-o*s-r*l,this._onChangeCallback(),this}slerp(e,t){if(0===t)return this;if(1===t)return this.copy(e);const n=this._x,o=this._y,r=this._z,i=this._w;let a=i*e._w+n*e._x+o*e._y+r*e._z;if(a<0?(this._w=-e._w,this._x=-e._x,this._y=-e._y,this._z=-e._z,a=-a):this.copy(e),a>=1)return this._w=i,this._x=n,this._y=o,this._z=r,this;const s=1-a*a;if(s<=Number.EPSILON){const e=1-t;return this._w=e*i+t*this._w,this._x=e*n+t*this._x,this._y=e*o+t*this._y,this._z=e*r+t*this._z,this.normalize(),this._onChangeCallback(),this}const l=Math.sqrt(s),c=Math.atan2(l,a),u=Math.sin((1-t)*c)/l,d=Math.sin(t*c)/l;return this._w=i*u+this._w*d,this._x=n*u+this._x*d,this._y=o*u+this._y*d,this._z=r*u+this._z*d,this._onChangeCallback(),this}slerpQuaternions(e,t,n){return this.copy(e).slerp(t,n)}random(){const e=Math.random(),t=Math.sqrt(1-e),n=Math.sqrt(e),o=2*Math.PI*Math.random(),r=2*Math.PI*Math.random();return this.set(t*Math.cos(o),n*Math.sin(r),n*Math.cos(r),t*Math.sin(o))}equals(e){return e._x===this._x&&e._y===this._y&&e._z===this._z&&e._w===this._w}fromArray(e,t=0){return this._x=e[t],this._y=e[t+1],this._z=e[t+2],this._w=e[t+3],this._onChangeCallback(),this}toArray(e=[],t=0){return e[t]=this._x,e[t+1]=this._y,e[t+2]=this._z,e[t+3]=this._w,e}fromBufferAttribute(e,t){return this._x=e.getX(t),this._y=e.getY(t),this._z=e.getZ(t),this._w=e.getW(t),this}_onChange(e){return this._onChangeCallback=e,this}_onChangeCallback(){}*[Symbol.iterator](){yield this._x,yield this._y,yield this._z,yield this._w}}class Vector3{constructor(e=0,t=0,n=0){Vector3.prototype.isVector3=!0,this.x=e,this.y=t,this.z=n}set(e,t,n){return void 0===n&&(n=this.z),this.x=e,this.y=t,this.z=n,this}setScalar(e){return this.x=e,this.y=e,this.z=e,this}setX(e){return this.x=e,this}setY(e){return this.y=e,this}setZ(e){return this.z=e,this}setComponent(e,t){switch(e){case 0:this.x=t;break;case 1:this.y=t;break;case 2:this.z=t;break;default:throw new Error("index is out of range: "+e)}return this}getComponent(e){switch(e){case 0:return this.x;case 1:return this.y;case 2:return this.z;default:throw new Error("index is out of range: "+e)}}clone(){return new this.constructor(this.x,this.y,this.z)}copy(e){return this.x=e.x,this.y=e.y,this.z=e.z,this}add(e){return this.x+=e.x,this.y+=e.y,this.z+=e.z,this}addScalar(e){return this.x+=e,this.y+=e,this.z+=e,this}addVectors(e,t){return this.x=e.x+t.x,this.y=e.y+t.y,this.z=e.z+t.z,this}addScaledVector(e,t){return this.x+=e.x*t,this.y+=e.y*t,this.z+=e.z*t,this}sub(e){return this.x-=e.x,this.y-=e.y,this.z-=e.z,this}subScalar(e){return this.x-=e,this.y-=e,this.z-=e,this}subVectors(e,t){return this.x=e.x-t.x,this.y=e.y-t.y,this.z=e.z-t.z,this}multiply(e){return this.x*=e.x,this.y*=e.y,this.z*=e.z,this}multiplyScalar(e){return this.x*=e,this.y*=e,this.z*=e,this}multiplyVectors(e,t){return this.x=e.x*t.x,this.y=e.y*t.y,this.z=e.z*t.z,this}applyEuler(e){return this.applyQuaternion(_quaternion$5.setFromEuler(e))}applyAxisAngle(e,t){return this.applyQuaternion(_quaternion$5.setFromAxisAngle(e,t))}applyMatrix3(e){const t=this.x,n=this.y,o=this.z,r=e.elements;return this.x=r[0]*t+r[3]*n+r[6]*o,this.y=r[1]*t+r[4]*n+r[7]*o,this.z=r[2]*t+r[5]*n+r[8]*o,this}applyNormalMatrix(e){return this.applyMatrix3(e).normalize()}applyMatrix4(e){const t=this.x,n=this.y,o=this.z,r=e.elements,i=1/(r[3]*t+r[7]*n+r[11]*o+r[15]);return this.x=(r[0]*t+r[4]*n+r[8]*o+r[12])*i,this.y=(r[1]*t+r[5]*n+r[9]*o+r[13])*i,this.z=(r[2]*t+r[6]*n+r[10]*o+r[14])*i,this}applyQuaternion(e){const t=this.x,n=this.y,o=this.z,r=e.x,i=e.y,a=e.z,s=e.w,l=s*t+i*o-a*n,c=s*n+a*t-r*o,u=s*o+r*n-i*t,d=-r*t-i*n-a*o;return this.x=l*s+d*-r+c*-a-u*-i,this.y=c*s+d*-i+u*-r-l*-a,this.z=u*s+d*-a+l*-i-c*-r,this}project(e){return this.applyMatrix4(e.matrixWorldInverse).applyMatrix4(e.projectionMatrix)}unproject(e){return this.applyMatrix4(e.projectionMatrixInverse).applyMatrix4(e.matrixWorld)}transformDirection(e){const t=this.x,n=this.y,o=this.z,r=e.elements;return this.x=r[0]*t+r[4]*n+r[8]*o,this.y=r[1]*t+r[5]*n+r[9]*o,this.z=r[2]*t+r[6]*n+r[10]*o,this.normalize()}divide(e){return this.x/=e.x,this.y/=e.y,this.z/=e.z,this}divideScalar(e){return this.multiplyScalar(1/e)}min(e){return this.x=Math.min(this.x,e.x),this.y=Math.min(this.y,e.y),this.z=Math.min(this.z,e.z),this}max(e){return this.x=Math.max(this.x,e.x),this.y=Math.max(this.y,e.y),this.z=Math.max(this.z,e.z),this}clamp(e,t){return this.x=Math.max(e.x,Math.min(t.x,this.x)),this.y=Math.max(e.y,Math.min(t.y,this.y)),this.z=Math.max(e.z,Math.min(t.z,this.z)),this}clampScalar(e,t){return this.x=Math.max(e,Math.min(t,this.x)),this.y=Math.max(e,Math.min(t,this.y)),this.z=Math.max(e,Math.min(t,this.z)),this}clampLength(e,t){const n=this.length();return this.divideScalar(n||1).multiplyScalar(Math.max(e,Math.min(t,n)))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this}roundToZero(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z),this}negate(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this}dot(e){return this.x*e.x+this.y*e.y+this.z*e.z}lengthSq(){return this.x*this.x+this.y*this.y+this.z*this.z}length(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)}normalize(){return this.divideScalar(this.length()||1)}setLength(e){return this.normalize().multiplyScalar(e)}lerp(e,t){return this.x+=(e.x-this.x)*t,this.y+=(e.y-this.y)*t,this.z+=(e.z-this.z)*t,this}lerpVectors(e,t,n){return this.x=e.x+(t.x-e.x)*n,this.y=e.y+(t.y-e.y)*n,this.z=e.z+(t.z-e.z)*n,this}cross(e){return this.crossVectors(this,e)}crossVectors(e,t){const n=e.x,o=e.y,r=e.z,i=t.x,a=t.y,s=t.z;return this.x=o*s-r*a,this.y=r*i-n*s,this.z=n*a-o*i,this}projectOnVector(e){const t=e.lengthSq();if(0===t)return this.set(0,0,0);const n=e.dot(this)/t;return this.copy(e).multiplyScalar(n)}projectOnPlane(e){return _vector$a.copy(this).projectOnVector(e),this.sub(_vector$a)}reflect(e){return this.sub(_vector$a.copy(e).multiplyScalar(2*this.dot(e)))}angleTo(e){const t=Math.sqrt(this.lengthSq()*e.lengthSq());if(0===t)return Math.PI/2;const n=this.dot(e)/t;return Math.acos(clamp(n,-1,1))}distanceTo(e){return Math.sqrt(this.distanceToSquared(e))}distanceToSquared(e){const t=this.x-e.x,n=this.y-e.y,o=this.z-e.z;return t*t+n*n+o*o}manhattanDistanceTo(e){return Math.abs(this.x-e.x)+Math.abs(this.y-e.y)+Math.abs(this.z-e.z)}setFromSpherical(e){return this.setFromSphericalCoords(e.radius,e.phi,e.theta)}setFromSphericalCoords(e,t,n){const o=Math.sin(t)*e;return this.x=o*Math.sin(n),this.y=Math.cos(t)*e,this.z=o*Math.cos(n),this}setFromCylindrical(e){return this.setFromCylindricalCoords(e.radius,e.theta,e.y)}setFromCylindricalCoords(e,t,n){return this.x=e*Math.sin(t),this.y=n,this.z=e*Math.cos(t),this}setFromMatrixPosition(e){const t=e.elements;return this.x=t[12],this.y=t[13],this.z=t[14],this}setFromMatrixScale(e){const t=this.setFromMatrixColumn(e,0).length(),n=this.setFromMatrixColumn(e,1).length(),o=this.setFromMatrixColumn(e,2).length();return this.x=t,this.y=n,this.z=o,this}setFromMatrixColumn(e,t){return this.fromArray(e.elements,4*t)}setFromMatrix3Column(e,t){return this.fromArray(e.elements,3*t)}setFromEuler(e){return this.x=e._x,this.y=e._y,this.z=e._z,this}equals(e){return e.x===this.x&&e.y===this.y&&e.z===this.z}fromArray(e,t=0){return this.x=e[t],this.y=e[t+1],this.z=e[t+2],this}toArray(e=[],t=0){return e[t]=this.x,e[t+1]=this.y,e[t+2]=this.z,e}fromBufferAttribute(e,t){return this.x=e.getX(t),this.y=e.getY(t),this.z=e.getZ(t),this}random(){return this.x=Math.random(),this.y=Math.random(),this.z=Math.random(),this}randomDirection(){const e=2*(Math.random()-.5),t=Math.random()*Math.PI*2,n=Math.sqrt(1-e**2);return this.x=n*Math.cos(t),this.y=n*Math.sin(t),this.z=e,this}*[Symbol.iterator](){yield this.x,yield this.y,yield this.z}}const _vector$a=new Vector3,_quaternion$5=new Quaternion;class Box3{constructor(e=new Vector3(1/0,1/0,1/0),t=new Vector3(-1/0,-1/0,-1/0)){this.isBox3=!0,this.min=e,this.max=t}set(e,t){return this.min.copy(e),this.max.copy(t),this}setFromArray(e){let t=1/0,n=1/0,o=1/0,r=-1/0,i=-1/0,a=-1/0;for(let s=0,l=e.length;s<l;s+=3){const l=e[s],c=e[s+1],u=e[s+2];l<t&&(t=l),c<n&&(n=c),u<o&&(o=u),l>r&&(r=l),c>i&&(i=c),u>a&&(a=u)}return this.min.set(t,n,o),this.max.set(r,i,a),this}setFromBufferAttribute(e){let t=1/0,n=1/0,o=1/0,r=-1/0,i=-1/0,a=-1/0;for(let s=0,l=e.count;s<l;s++){const l=e.getX(s),c=e.getY(s),u=e.getZ(s);l<t&&(t=l),c<n&&(n=c),u<o&&(o=u),l>r&&(r=l),c>i&&(i=c),u>a&&(a=u)}return this.min.set(t,n,o),this.max.set(r,i,a),this}setFromPoints(e){this.makeEmpty();for(let t=0,n=e.length;t<n;t++)this.expandByPoint(e[t]);return this}setFromCenterAndSize(e,t){const n=_vector$9.copy(t).multiplyScalar(.5);return this.min.copy(e).sub(n),this.max.copy(e).add(n),this}setFromObject(e,t=!1){return this.makeEmpty(),this.expandByObject(e,t)}clone(){return(new this.constructor).copy(this)}copy(e){return this.min.copy(e.min),this.max.copy(e.max),this}makeEmpty(){return this.min.x=this.min.y=this.min.z=1/0,this.max.x=this.max.y=this.max.z=-1/0,this}isEmpty(){return this.max.x<this.min.x||this.max.y<this.min.y||this.max.z<this.min.z}getCenter(e){return this.isEmpty()?e.set(0,0,0):e.addVectors(this.min,this.max).multiplyScalar(.5)}getSize(e){return this.isEmpty()?e.set(0,0,0):e.subVectors(this.max,this.min)}expandByPoint(e){return this.min.min(e),this.max.max(e),this}expandByVector(e){return this.min.sub(e),this.max.add(e),this}expandByScalar(e){return this.min.addScalar(-e),this.max.addScalar(e),this}expandByObject(e,t=!1){e.updateWorldMatrix(!1,!1);const n=e.geometry;if(void 0!==n)if(t&&null!=n.attributes&&void 0!==n.attributes.position){const t=n.attributes.position;for(let n=0,o=t.count;n<o;n++)_vector$9.fromBufferAttribute(t,n).applyMatrix4(e.matrixWorld),this.expandByPoint(_vector$9)}else null===n.boundingBox&&n.computeBoundingBox(),_box$4.copy(n.boundingBox),_box$4.applyMatrix4(e.matrixWorld),this.union(_box$4);const o=e.children;for(let e=0,n=o.length;e<n;e++)this.expandByObject(o[e],t);return this}containsPoint(e){return!(e.x<this.min.x||e.x>this.max.x||e.y<this.min.y||e.y>this.max.y||e.z<this.min.z||e.z>this.max.z)}containsBox(e){return this.min.x<=e.min.x&&e.max.x<=this.max.x&&this.min.y<=e.min.y&&e.max.y<=this.max.y&&this.min.z<=e.min.z&&e.max.z<=this.max.z}getParameter(e,t){return t.set((e.x-this.min.x)/(this.max.x-this.min.x),(e.y-this.min.y)/(this.max.y-this.min.y),(e.z-this.min.z)/(this.max.z-this.min.z))}intersectsBox(e){return!(e.max.x<this.min.x||e.min.x>this.max.x||e.max.y<this.min.y||e.min.y>this.max.y||e.max.z<this.min.z||e.min.z>this.max.z)}intersectsSphere(e){return this.clampPoint(e.center,_vector$9),_vector$9.distanceToSquared(e.center)<=e.radius*e.radius}intersectsPlane(e){let t,n;return e.normal.x>0?(t=e.normal.x*this.min.x,n=e.normal.x*this.max.x):(t=e.normal.x*this.max.x,n=e.normal.x*this.min.x),e.normal.y>0?(t+=e.normal.y*this.min.y,n+=e.normal.y*this.max.y):(t+=e.normal.y*this.max.y,n+=e.normal.y*this.min.y),e.normal.z>0?(t+=e.normal.z*this.min.z,n+=e.normal.z*this.max.z):(t+=e.normal.z*this.max.z,n+=e.normal.z*this.min.z),t<=-e.constant&&n>=-e.constant}intersectsTriangle(e){if(this.isEmpty())return!1;this.getCenter(_center),_extents.subVectors(this.max,_center),_v0$2.subVectors(e.a,_center),_v1$8.subVectors(e.b,_center),_v2$5.subVectors(e.c,_center),_f0.subVectors(_v1$8,_v0$2),_f1.subVectors(_v2$5,_v1$8),_f2.subVectors(_v0$2,_v2$5);let t=[0,-_f0.z,_f0.y,0,-_f1.z,_f1.y,0,-_f2.z,_f2.y,_f0.z,0,-_f0.x,_f1.z,0,-_f1.x,_f2.z,0,-_f2.x,-_f0.y,_f0.x,0,-_f1.y,_f1.x,0,-_f2.y,_f2.x,0];return!!satForAxes(t,_v0$2,_v1$8,_v2$5,_extents)&&(t=[1,0,0,0,1,0,0,0,1],!!satForAxes(t,_v0$2,_v1$8,_v2$5,_extents)&&(_triangleNormal.crossVectors(_f0,_f1),t=[_triangleNormal.x,_triangleNormal.y,_triangleNormal.z],satForAxes(t,_v0$2,_v1$8,_v2$5,_extents)))}clampPoint(e,t){return t.copy(e).clamp(this.min,this.max)}distanceToPoint(e){return _vector$9.copy(e).clamp(this.min,this.max).sub(e).length()}getBoundingSphere(e){return this.getCenter(e.center),e.radius=.5*this.getSize(_vector$9).length(),e}intersect(e){return this.min.max(e.min),this.max.min(e.max),this.isEmpty()&&this.makeEmpty(),this}union(e){return this.min.min(e.min),this.max.max(e.max),this}applyMatrix4(e){return this.isEmpty()||(_points[0].set(this.min.x,this.min.y,this.min.z).applyMatrix4(e),_points[1].set(this.min.x,this.min.y,this.max.z).applyMatrix4(e),_points[2].set(this.min.x,this.max.y,this.min.z).applyMatrix4(e),_points[3].set(this.min.x,this.max.y,this.max.z).applyMatrix4(e),_points[4].set(this.max.x,this.min.y,this.min.z).applyMatrix4(e),_points[5].set(this.max.x,this.min.y,this.max.z).applyMatrix4(e),_points[6].set(this.max.x,this.max.y,this.min.z).applyMatrix4(e),_points[7].set(this.max.x,this.max.y,this.max.z).applyMatrix4(e),this.setFromPoints(_points)),this}translate(e){return this.min.add(e),this.max.add(e),this}equals(e){return e.min.equals(this.min)&&e.max.equals(this.max)}scale(e){return this.getCenter(_center),_extents.subVectors(this.max,_center),_extents.multiply(e),this.min.copy(_center).sub(_extents),this.max.copy(_center).add(_extents),this}}const _points=[new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3],_vector$9=new Vector3,_box$4=new Box3,_v0$2=new Vector3,_v1$8=new Vector3,_v2$5=new Vector3,_f0=new Vector3,_f1=new Vector3,_f2=new Vector3,_center=new Vector3,_extents=new Vector3,_triangleNormal=new Vector3,_testAxis=new Vector3;function satForAxes(e,t,n,o,r){for(let i=0,a=e.length-3;i<=a;i+=3){_testAxis.fromArray(e,i);const a=r.x*Math.abs(_testAxis.x)+r.y*Math.abs(_testAxis.y)+r.z*Math.abs(_testAxis.z),s=t.dot(_testAxis),l=n.dot(_testAxis),c=o.dot(_testAxis);if(Math.max(-Math.max(s,l,c),Math.min(s,l,c))>a)return!1}return!0}const _box$3=new Box3,_v1$7=new Vector3,_v2$4=new Vector3;class Sphere{constructor(e=new Vector3,t=-1){this.center=e,this.radius=t}set(e,t){return this.center.copy(e),this.radius=t,this}setFromPoints(e,t){const n=this.center;void 0!==t?n.copy(t):_box$3.setFromPoints(e).getCenter(n);let o=0;for(let t=0,r=e.length;t<r;t++)o=Math.max(o,n.distanceToSquared(e[t]));return this.radius=Math.sqrt(o),this}copy(e){return this.center.copy(e.center),this.radius=e.radius,this}isEmpty(){return this.radius<0}makeEmpty(){return this.center.set(0,0,0),this.radius=-1,this}containsPoint(e){return e.distanceToSquared(this.center)<=this.radius*this.radius}distanceToPoint(e){return e.distanceTo(this.center)-this.radius}intersectsSphere(e){const t=this.radius+e.radius;return e.center.distanceToSquared(this.center)<=t*t}intersectsBox(e){return e.intersectsSphere(this)}intersectsPlane(e){return Math.abs(e.distanceToPoint(this.center))<=this.radius}clampPoint(e,t){const n=this.center.distanceToSquared(e);return t.copy(e),n>this.radius*this.radius&&(t.sub(this.center).normalize(),t.multiplyScalar(this.radius).add(this.center)),t}getBoundingBox(e){return this.isEmpty()?(e.makeEmpty(),e):(e.set(this.center,this.center),e.expandByScalar(this.radius),e)}applyMatrix4(e){return this.center.applyMatrix4(e),this.radius=this.radius*e.getMaxScaleOnAxis(),this}translate(e){return this.center.add(e),this}expandByPoint(e){if(this.isEmpty())return this.center.copy(e),this.radius=0,this;_v1$7.subVectors(e,this.center);const t=_v1$7.lengthSq();if(t>this.radius*this.radius){const e=Math.sqrt(t),n=.5*(e-this.radius);this.center.addScaledVector(_v1$7,n/e),this.radius+=n}return this}union(e){return e.isEmpty()?this:this.isEmpty()?(this.copy(e),this):(!0===this.center.equals(e.center)?this.radius=Math.max(this.radius,e.radius):(_v2$4.subVectors(e.center,this.center).setLength(e.radius),this.expandByPoint(_v1$7.copy(e.center).add(_v2$4)),this.expandByPoint(_v1$7.copy(e.center).sub(_v2$4))),this)}equals(e){return e.center.equals(this.center)&&e.radius===this.radius}clone(){return(new this.constructor).copy(this)}}const _vector$8=new Vector3,_segCenter=new Vector3,_segDir=new Vector3,_diff=new Vector3,_edge1=new Vector3,_edge2=new Vector3,_normal$1=new Vector3;class Ray{constructor(e=new Vector3,t=new Vector3(0,0,-1)){this.origin=e,this.direction=t}set(e,t){return this.origin.copy(e),this.direction.copy(t),this}copy(e){return this.origin.copy(e.origin),this.direction.copy(e.direction),this}at(e,t){return t.copy(this.direction).multiplyScalar(e).add(this.origin)}lookAt(e){return this.direction.copy(e).sub(this.origin).normalize(),this}recast(e){return this.origin.copy(this.at(e,_vector$8)),this}closestPointToPoint(e,t){t.subVectors(e,this.origin);const n=t.dot(this.direction);return n<0?t.copy(this.origin):t.copy(this.direction).multiplyScalar(n).add(this.origin)}distanceToPoint(e){return Math.sqrt(this.distanceSqToPoint(e))}distanceSqToPoint(e){const t=_vector$8.subVectors(e,this.origin).dot(this.direction);return t<0?this.origin.distanceToSquared(e):(_vector$8.copy(this.direction).multiplyScalar(t).add(this.origin),_vector$8.distanceToSquared(e))}distanceSqToSegment(e,t,n,o){_segCenter.copy(e).add(t).multiplyScalar(.5),_segDir.copy(t).sub(e).normalize(),_diff.copy(this.origin).sub(_segCenter);const r=.5*e.distanceTo(t),i=-this.direction.dot(_segDir),a=_diff.dot(this.direction),s=-_diff.dot(_segDir),l=_diff.lengthSq(),c=Math.abs(1-i*i);let u,d,h,p;if(c>0)if(u=i*s-a,d=i*a-s,p=r*c,u>=0)if(d>=-p)if(d<=p){const e=1/c;u*=e,d*=e,h=u*(u+i*d+2*a)+d*(i*u+d+2*s)+l}else d=r,u=Math.max(0,-(i*d+a)),h=-u*u+d*(d+2*s)+l;else d=-r,u=Math.max(0,-(i*d+a)),h=-u*u+d*(d+2*s)+l;else d<=-p?(u=Math.max(0,-(-i*r+a)),d=u>0?-r:Math.min(Math.max(-r,-s),r),h=-u*u+d*(d+2*s)+l):d<=p?(u=0,d=Math.min(Math.max(-r,-s),r),h=d*(d+2*s)+l):(u=Math.max(0,-(i*r+a)),d=u>0?r:Math.min(Math.max(-r,-s),r),h=-u*u+d*(d+2*s)+l);else d=i>0?-r:r,u=Math.max(0,-(i*d+a)),h=-u*u+d*(d+2*s)+l;return n&&n.copy(this.direction).multiplyScalar(u).add(this.origin),o&&o.copy(_segDir).multiplyScalar(d).add(_segCenter),h}intersectSphere(e,t){_vector$8.subVectors(e.center,this.origin);const n=_vector$8.dot(this.direction),o=_vector$8.dot(_vector$8)-n*n,r=e.radius*e.radius;if(o>r)return null;const i=Math.sqrt(r-o),a=n-i,s=n+i;return a<0&&s<0?null:a<0?this.at(s,t):this.at(a,t)}intersectsSphere(e){return this.distanceSqToPoint(e.center)<=e.radius*e.radius}distanceToPlane(e){const t=e.normal.dot(this.direction);if(0===t)return 0===e.distanceToPoint(this.origin)?0:null;const n=-(this.origin.dot(e.normal)+e.constant)/t;return n>=0?n:null}intersectPlane(e,t){const n=this.distanceToPlane(e);return null===n?null:this.at(n,t)}intersectsPlane(e){const t=e.distanceToPoint(this.origin);if(0===t)return!0;return e.normal.dot(this.direction)*t<0}intersectBox(e,t){let n,o,r,i,a,s;const l=1/this.direction.x,c=1/this.direction.y,u=1/this.direction.z,d=this.origin;return l>=0?(n=(e.min.x-d.x)*l,o=(e.max.x-d.x)*l):(n=(e.max.x-d.x)*l,o=(e.min.x-d.x)*l),c>=0?(r=(e.min.y-d.y)*c,i=(e.max.y-d.y)*c):(r=(e.max.y-d.y)*c,i=(e.min.y-d.y)*c),n>i||r>o?null:((r>n||isNaN(n))&&(n=r),(i<o||isNaN(o))&&(o=i),u>=0?(a=(e.min.z-d.z)*u,s=(e.max.z-d.z)*u):(a=(e.max.z-d.z)*u,s=(e.min.z-d.z)*u),n>s||a>o?null:((a>n||n!=n)&&(n=a),(s<o||o!=o)&&(o=s),o<0?null:this.at(n>=0?n:o,t)))}intersectsBox(e){return null!==this.intersectBox(e,_vector$8)}intersectTriangle(e,t,n,o,r){_edge1.subVectors(t,e),_edge2.subVectors(n,e),_normal$1.crossVectors(_edge1,_edge2);let i,a=this.direction.dot(_normal$1);if(a>0){if(o)return null;i=1}else{if(!(a<0))return null;i=-1,a=-a}_diff.subVectors(this.origin,e);const s=i*this.direction.dot(_edge2.crossVectors(_diff,_edge2));if(s<0)return null;const l=i*this.direction.dot(_edge1.cross(_diff));if(l<0)return null;if(s+l>a)return null;const c=-i*_diff.dot(_normal$1);return c<0?null:this.at(c/a,r)}applyMatrix4(e){return this.origin.applyMatrix4(e),this.direction.transformDirection(e),this}equals(e){return e.origin.equals(this.origin)&&e.direction.equals(this.direction)}clone(){return(new this.constructor).copy(this)}}class Matrix4{constructor(){Matrix4.prototype.isMatrix4=!0,this.elements=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]}set(e,t,n,o,r,i,a,s,l,c,u,d,h,p,f,m){const g=this.elements;return g[0]=e,g[4]=t,g[8]=n,g[12]=o,g[1]=r,g[5]=i,g[9]=a,g[13]=s,g[2]=l,g[6]=c,g[10]=u,g[14]=d,g[3]=h,g[7]=p,g[11]=f,g[15]=m,this}identity(){return this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),this}clone(){return(new Matrix4).fromArray(this.elements)}copy(e){const t=this.elements,n=e.elements;return t[0]=n[0],t[1]=n[1],t[2]=n[2],t[3]=n[3],t[4]=n[4],t[5]=n[5],t[6]=n[6],t[7]=n[7],t[8]=n[8],t[9]=n[9],t[10]=n[10],t[11]=n[11],t[12]=n[12],t[13]=n[13],t[14]=n[14],t[15]=n[15],this}copyPosition(e){const t=this.elements,n=e.elements;return t[12]=n[12],t[13]=n[13],t[14]=n[14],this}setFromMatrix3(e){const t=e.elements;return this.set(t[0],t[3],t[6],0,t[1],t[4],t[7],0,t[2],t[5],t[8],0,0,0,0,1),this}extractBasis(e,t,n){return e.setFromMatrixColumn(this,0),t.setFromMatrixColumn(this,1),n.setFromMatrixColumn(this,2),this}makeBasis(e,t,n){return this.set(e.x,t.x,n.x,0,e.y,t.y,n.y,0,e.z,t.z,n.z,0,0,0,0,1),this}extractRotation(e){const t=this.elements,n=e.elements,o=1/_v1$6.setFromMatrixColumn(e,0).length(),r=1/_v1$6.setFromMatrixColumn(e,1).length(),i=1/_v1$6.setFromMatrixColumn(e,2).length();return t[0]=n[0]*o,t[1]=n[1]*o,t[2]=n[2]*o,t[3]=0,t[4]=n[4]*r,t[5]=n[5]*r,t[6]=n[6]*r,t[7]=0,t[8]=n[8]*i,t[9]=n[9]*i,t[10]=n[10]*i,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,this}makeRotationFromEuler(e){const t=this.elements,n=e.x,o=e.y,r=e.z,i=Math.cos(n),a=Math.sin(n),s=Math.cos(o),l=Math.sin(o),c=Math.cos(r),u=Math.sin(r);if("XYZ"===e.order){const e=i*c,n=i*u,o=a*c,r=a*u;t[0]=s*c,t[4]=-s*u,t[8]=l,t[1]=n+o*l,t[5]=e-r*l,t[9]=-a*s,t[2]=r-e*l,t[6]=o+n*l,t[10]=i*s}else if("YXZ"===e.order){const e=s*c,n=s*u,o=l*c,r=l*u;t[0]=e+r*a,t[4]=o*a-n,t[8]=i*l,t[1]=i*u,t[5]=i*c,t[9]=-a,t[2]=n*a-o,t[6]=r+e*a,t[10]=i*s}else if("ZXY"===e.order){const e=s*c,n=s*u,o=l*c,r=l*u;t[0]=e-r*a,t[4]=-i*u,t[8]=o+n*a,t[1]=n+o*a,t[5]=i*c,t[9]=r-e*a,t[2]=-i*l,t[6]=a,t[10]=i*s}else if("ZYX"===e.order){const e=i*c,n=i*u,o=a*c,r=a*u;t[0]=s*c,t[4]=o*l-n,t[8]=e*l+r,t[1]=s*u,t[5]=r*l+e,t[9]=n*l-o,t[2]=-l,t[6]=a*s,t[10]=i*s}else if("YZX"===e.order){const e=i*s,n=i*l,o=a*s,r=a*l;t[0]=s*c,t[4]=r-e*u,t[8]=o*u+n,t[1]=u,t[5]=i*c,t[9]=-a*c,t[2]=-l*c,t[6]=n*u+o,t[10]=e-r*u}else if("XZY"===e.order){const e=i*s,n=i*l,o=a*s,r=a*l;t[0]=s*c,t[4]=-u,t[8]=l*c,t[1]=e*u+r,t[5]=i*c,t[9]=n*u-o,t[2]=o*u-n,t[6]=a*c,t[10]=r*u+e}return t[3]=0,t[7]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,this}makeRotationFromQuaternion(e){return this.compose(_zero,e,_one)}lookAt(e,t,n){const o=this.elements;return _z.subVectors(e,t),0===_z.lengthSq()&&(_z.z=1),_z.normalize(),_x.crossVectors(n,_z),0===_x.lengthSq()&&(1===Math.abs(n.z)?_z.x+=1e-4:_z.z+=1e-4,_z.normalize(),_x.crossVectors(n,_z)),_x.normalize(),_y.crossVectors(_z,_x),o[0]=_x.x,o[4]=_y.x,o[8]=_z.x,o[1]=_x.y,o[5]=_y.y,o[9]=_z.y,o[2]=_x.z,o[6]=_y.z,o[10]=_z.z,this}multiply(e){return this.multiplyMatrices(this,e)}premultiply(e){return this.multiplyMatrices(e,this)}multiplyMatrices(e,t){const n=e.elements,o=t.elements,r=this.elements,i=n[0],a=n[4],s=n[8],l=n[12],c=n[1],u=n[5],d=n[9],h=n[13],p=n[2],f=n[6],m=n[10],g=n[14],_=n[3],A=n[7],v=n[11],x=n[15],y=o[0],b=o[4],C=o[8],S=o[12],E=o[1],M=o[5],T=o[9],w=o[13],I=o[2],R=o[6],L=o[10],B=o[14],P=o[3],N=o[7],D=o[11],O=o[15];return r[0]=i*y+a*E+s*I+l*P,r[4]=i*b+a*M+s*R+l*N,r[8]=i*C+a*T+s*L+l*D,r[12]=i*S+a*w+s*B+l*O,r[1]=c*y+u*E+d*I+h*P,r[5]=c*b+u*M+d*R+h*N,r[9]=c*C+u*T+d*L+h*D,r[13]=c*S+u*w+d*B+h*O,r[2]=p*y+f*E+m*I+g*P,r[6]=p*b+f*M+m*R+g*N,r[10]=p*C+f*T+m*L+g*D,r[14]=p*S+f*w+m*B+g*O,r[3]=_*y+A*E+v*I+x*P,r[7]=_*b+A*M+v*R+x*N,r[11]=_*C+A*T+v*L+x*D,r[15]=_*S+A*w+v*B+x*O,this}multiplyScalar(e){const t=this.elements;return t[0]*=e,t[4]*=e,t[8]*=e,t[12]*=e,t[1]*=e,t[5]*=e,t[9]*=e,t[13]*=e,t[2]*=e,t[6]*=e,t[10]*=e,t[14]*=e,t[3]*=e,t[7]*=e,t[11]*=e,t[15]*=e,this}determinant(){const e=this.elements,t=e[0],n=e[4],o=e[8],r=e[12],i=e[1],a=e[5],s=e[9],l=e[13],c=e[2],u=e[6],d=e[10],h=e[14];return e[3]*(+r*s*u-o*l*u-r*a*d+n*l*d+o*a*h-n*s*h)+e[7]*(+t*s*h-t*l*d+r*i*d-o*i*h+o*l*c-r*s*c)+e[11]*(+t*l*u-t*a*h-r*i*u+n*i*h+r*a*c-n*l*c)+e[15]*(-o*a*c-t*s*u+t*a*d+o*i*u-n*i*d+n*s*c)}transpose(){const e=this.elements;let t;return t=e[1],e[1]=e[4],e[4]=t,t=e[2],e[2]=e[8],e[8]=t,t=e[6],e[6]=e[9],e[9]=t,t=e[3],e[3]=e[12],e[12]=t,t=e[7],e[7]=e[13],e[13]=t,t=e[11],e[11]=e[14],e[14]=t,this}setPosition(e,t,n){const o=this.elements;return e.isVector3?(o[12]=e.x,o[13]=e.y,o[14]=e.z):(o[12]=e,o[13]=t,o[14]=n),this}invert(){const e=this.elements,t=e[0],n=e[1],o=e[2],r=e[3],i=e[4],a=e[5],s=e[6],l=e[7],c=e[8],u=e[9],d=e[10],h=e[11],p=e[12],f=e[13],m=e[14],g=e[15],_=u*m*l-f*d*l+f*s*h-a*m*h-u*s*g+a*d*g,A=p*d*l-c*m*l-p*s*h+i*m*h+c*s*g-i*d*g,v=c*f*l-p*u*l+p*a*h-i*f*h-c*a*g+i*u*g,x=p*u*s-c*f*s-p*a*d+i*f*d+c*a*m-i*u*m,y=t*_+n*A+o*v+r*x;if(0===y)return this.set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);const b=1/y;return e[0]=_*b,e[1]=(f*d*r-u*m*r-f*o*h+n*m*h+u*o*g-n*d*g)*b,e[2]=(a*m*r-f*s*r+f*o*l-n*m*l-a*o*g+n*s*g)*b,e[3]=(u*s*r-a*d*r-u*o*l+n*d*l+a*o*h-n*s*h)*b,e[4]=A*b,e[5]=(c*m*r-p*d*r+p*o*h-t*m*h-c*o*g+t*d*g)*b,e[6]=(p*s*r-i*m*r-p*o*l+t*m*l+i*o*g-t*s*g)*b,e[7]=(i*d*r-c*s*r+c*o*l-t*d*l-i*o*h+t*s*h)*b,e[8]=v*b,e[9]=(p*u*r-c*f*r-p*n*h+t*f*h+c*n*g-t*u*g)*b,e[10]=(i*f*r-p*a*r+p*n*l-t*f*l-i*n*g+t*a*g)*b,e[11]=(c*a*r-i*u*r-c*n*l+t*u*l+i*n*h-t*a*h)*b,e[12]=x*b,e[13]=(c*f*o-p*u*o+p*n*d-t*f*d-c*n*m+t*u*m)*b,e[14]=(p*a*o-i*f*o-p*n*s+t*f*s+i*n*m-t*a*m)*b,e[15]=(i*u*o-c*a*o+c*n*s-t*u*s-i*n*d+t*a*d)*b,this}scale(e){const t=this.elements,n=e.x,o=e.y,r=e.z;return t[0]*=n,t[4]*=o,t[8]*=r,t[1]*=n,t[5]*=o,t[9]*=r,t[2]*=n,t[6]*=o,t[10]*=r,t[3]*=n,t[7]*=o,t[11]*=r,this}getMaxScaleOnAxis(){const e=this.elements,t=e[0]*e[0]+e[1]*e[1]+e[2]*e[2],n=e[4]*e[4]+e[5]*e[5]+e[6]*e[6],o=e[8]*e[8]+e[9]*e[9]+e[10]*e[10];return Math.sqrt(Math.max(t,n,o))}makeTranslation(e,t,n){return this.set(1,0,0,e,0,1,0,t,0,0,1,n,0,0,0,1),this}makeRotationX(e){const t=Math.cos(e),n=Math.sin(e);return this.set(1,0,0,0,0,t,-n,0,0,n,t,0,0,0,0,1),this}makeRotationY(e){const t=Math.cos(e),n=Math.sin(e);return this.set(t,0,n,0,0,1,0,0,-n,0,t,0,0,0,0,1),this}makeRotationZ(e){const t=Math.cos(e),n=Math.sin(e);return this.set(t,-n,0,0,n,t,0,0,0,0,1,0,0,0,0,1),this}makeRotationAxis(e,t){const n=Math.cos(t),o=Math.sin(t),r=1-n,i=e.x,a=e.y,s=e.z,l=r*i,c=r*a;return this.set(l*i+n,l*a-o*s,l*s+o*a,0,l*a+o*s,c*a+n,c*s-o*i,0,l*s-o*a,c*s+o*i,r*s*s+n,0,0,0,0,1),this}makeScale(e,t,n){return this.set(e,0,0,0,0,t,0,0,0,0,n,0,0,0,0,1),this}makeShear(e,t,n,o,r,i){return this.set(1,n,r,0,e,1,i,0,t,o,1,0,0,0,0,1),this}compose(e,t,n){const o=this.elements,r=t._x,i=t._y,a=t._z,s=t._w,l=r+r,c=i+i,u=a+a,d=r*l,h=r*c,p=r*u,f=i*c,m=i*u,g=a*u,_=s*l,A=s*c,v=s*u,x=n.x,y=n.y,b=n.z;return o[0]=(1-(f+g))*x,o[1]=(h+v)*x,o[2]=(p-A)*x,o[3]=0,o[4]=(h-v)*y,o[5]=(1-(d+g))*y,o[6]=(m+_)*y,o[7]=0,o[8]=(p+A)*b,o[9]=(m-_)*b,o[10]=(1-(d+f))*b,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,this}decompose(e,t,n){const o=this.elements;let r=_v1$6.set(o[0],o[1],o[2]).length();const i=_v1$6.set(o[4],o[5],o[6]).length(),a=_v1$6.set(o[8],o[9],o[10]).length();this.determinant()<0&&(r=-r),e.x=o[12],e.y=o[13],e.z=o[14],_m1$2.copy(this);const s=1/r,l=1/i,c=1/a;return _m1$2.elements[0]*=s,_m1$2.elements[1]*=s,_m1$2.elements[2]*=s,_m1$2.elements[4]*=l,_m1$2.elements[5]*=l,_m1$2.elements[6]*=l,_m1$2.elements[8]*=c,_m1$2.elements[9]*=c,_m1$2.elements[10]*=c,t.setFromRotationMatrix(_m1$2),n.x=r,n.y=i,n.z=a,this}makePerspective(e,t,n,o,r,i){const a=this.elements,s=2*r/(t-e),l=2*r/(n-o),c=(t+e)/(t-e),u=(n+o)/(n-o),d=-(i+r)/(i-r),h=-2*i*r/(i-r);return a[0]=s,a[4]=0,a[8]=c,a[12]=0,a[1]=0,a[5]=l,a[9]=u,a[13]=0,a[2]=0,a[6]=0,a[10]=d,a[14]=h,a[3]=0,a[7]=0,a[11]=-1,a[15]=0,this}makeOrthographic(e,t,n,o,r,i){const a=this.elements,s=1/(t-e),l=1/(n-o),c=1/(i-r),u=(t+e)*s,d=(n+o)*l,h=(i+r)*c;return a[0]=2*s,a[4]=0,a[8]=0,a[12]=-u,a[1]=0,a[5]=2*l,a[9]=0,a[13]=-d,a[2]=0,a[6]=0,a[10]=-2*c,a[14]=-h,a[3]=0,a[7]=0,a[11]=0,a[15]=1,this}equals(e){const t=this.elements,n=e.elements;for(let e=0;e<16;e++)if(t[e]!==n[e])return!1;return!0}fromArray(e,t=0){for(let n=0;n<16;n++)this.elements[n]=e[n+t];return this}toArray(e=[],t=0){const n=this.elements;return e[t]=n[0],e[t+1]=n[1],e[t+2]=n[2],e[t+3]=n[3],e[t+4]=n[4],e[t+5]=n[5],e[t+6]=n[6],e[t+7]=n[7],e[t+8]=n[8],e[t+9]=n[9],e[t+10]=n[10],e[t+11]=n[11],e[t+12]=n[12],e[t+13]=n[13],e[t+14]=n[14],e[t+15]=n[15],e}composeE(e,t,n){const o=this.elements;this.makeRotationFromEuler(t);const r=n.x,i=n.y,a=n.z;return o[0]*=r,o[1]*=r,o[2]*=r,o[3]=0,o[4]*=i,o[5]*=i,o[6]*=i,o[7]=0,o[8]*=a,o[9]*=a,o[10]*=a,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,this}decomposeE(e,t,n,o=t.order){const r=this.elements;let i=_v1$6.set(r[0],r[1],r[2]).length();const a=_v1$6.set(r[4],r[5],r[6]).length(),s=_v1$6.set(r[8],r[9],r[10]).length();this.determinant()<0&&(i=-i),e.x=r[12],e.y=r[13],e.z=r[14],_m1$2.copy(this);const l=1/i,c=1/a,u=1/s;return _m1$2.elements[0]*=l,_m1$2.elements[1]*=l,_m1$2.elements[2]*=l,_m1$2.elements[4]*=c,_m1$2.elements[5]*=c,_m1$2.elements[6]*=c,_m1$2.elements[8]*=u,_m1$2.elements[9]*=u,_m1$2.elements[10]*=u,t.setFromRotationMatrix(_m1$2,o),n.x=i,n.y=a,n.z=s,this}}const _v1$6=new Vector3,_m1$2=new Matrix4,_zero=new Vector3(0,0,0),_one=new Vector3(1,1,1),_x=new Vector3,_y=new Vector3,_z=new Vector3,_matrix$3=new Matrix4,_quaternion$4=new Quaternion;class Euler{constructor(e=0,t=0,n=0,o=Euler.DefaultOrder){this.isEuler=!0,this._x=e,this._y=t,this._z=n,this._order=o}get x(){return this._x}set x(e){this._x=e,this._onChangeCallback()}get y(){return this._y}set y(e){this._y=e,this._onChangeCallback()}get z(){return this._z}set z(e){this._z=e,this._onChangeCallback()}get order(){return this._order}set order(e){this._order=e,this._onChangeCallback()}set(e,t,n,o=this._order){return this._x=e,this._y=t,this._z=n,this._order=o,this._onChangeCallback(),this}clone(){return new this.constructor(this._x,this._y,this._z,this._order)}copy(e){return this._x=e._x,this._y=e._y,this._z=e._z,this._order=e._order,this._onChangeCallback(),this}setFromRotationMatrix(e,t=this._order,n=!0){const o=e.elements,r=o[0],i=o[4],a=o[8],s=o[1],l=o[5],c=o[9],u=o[2],d=o[6],h=o[10];switch(t){case"XYZ":this._y=Math.asin(clamp(a,-1,1)),Math.abs(a)<.9999999?(this._x=Math.atan2(-c,h),this._z=Math.atan2(-i,r)):(this._x=Math.atan2(d,l),this._z=0);break;case"YXZ":this._x=Math.asin(-clamp(c,-1,1)),Math.abs(c)<.9999999?(this._y=Math.atan2(a,h),this._z=Math.atan2(s,l)):(this._y=Math.atan2(-u,r),this._z=0);break;case"ZXY":this._x=Math.asin(clamp(d,-1,1)),Math.abs(d)<.9999999?(this._y=Math.atan2(-u,h),this._z=Math.atan2(-i,l)):(this._y=0,this._z=Math.atan2(s,r));break;case"ZYX":this._y=Math.asin(-clamp(u,-1,1)),Math.abs(u)<.9999999?(this._x=Math.atan2(d,h),this._z=Math.atan2(s,r)):(this._x=0,this._z=Math.atan2(-i,l));break;case"YZX":this._z=Math.asin(clamp(s,-1,1)),Math.abs(s)<.9999999?(this._x=Math.atan2(-c,l),this._y=Math.atan2(-u,r)):(this._x=0,this._y=Math.atan2(a,h));break;case"XZY":this._z=Math.asin(-clamp(i,-1,1)),Math.abs(i)<.9999999?(this._x=Math.atan2(d,l),this._y=Math.atan2(a,r)):(this._x=Math.atan2(-c,h),this._y=0);break;default:console.warn("v3d.Euler: .setFromRotationMatrix() encountered an unknown order: "+t)}return this._order=t,!0===n&&this._onChangeCallback(),this}setFromQuaternion(e,t,n){return _matrix$3.makeRotationFromQuaternion(e),this.setFromRotationMatrix(_matrix$3,t,n)}setFromVector3(e,t=this._order){return this.set(e.x,e.y,e.z,t)}reorder(e){return _quaternion$4.setFromEuler(this),this.setFromQuaternion(_quaternion$4,e)}equals(e){return e._x===this._x&&e._y===this._y&&e._z===this._z&&e._order===this._order}fromArray(e){return this._x=e[0],this._y=e[1],this._z=e[2],void 0!==e[3]&&(this._order=e[3]),this._onChangeCallback(),this}toArray(e=[],t=0){return e[t]=this._x,e[t+1]=this._y,e[t+2]=this._z,e[t+3]=this._order,e}_onChange(e){return this._onChangeCallback=e,this}_onChangeCallback(){}*[Symbol.iterator](){yield this._x,yield this._y,yield this._z,yield this._order}toVector3(e){return console.warn("v3d.Euler: .toVector3() has been removed. Use Vector3.setFromEuler() instead"),e?e.set(this._x,this._y,this._z):new Vector3(this._x,this._y,this._z)}makeAlternative(){var e="X"===this._order[1]?-1:1,t="Y"===this._order[1]?-1:1,n="Z"===this._order[1]?-1:1;return this._x=angleToRange_mPi_Pi(e*(this._x+Math.PI)),this._y=angleToRange_mPi_Pi(t*(this._y+Math.PI)),this._z=angleToRange_mPi_Pi(n*(this._z+Math.PI)),this}equalsEps(e,t){return Math.abs(this._x-e._x)<t&&Math.abs(this._y-e._y)<t&&Math.abs(this._z-e._z)<t&&this._order===e._order}}Euler.DefaultOrder="XYZ",Euler.RotationOrders=["XYZ","YZX","ZXY","XZY","YXZ","ZYX"];class Layers{constructor(){this.mask=1}set(e){this.mask=1<<e>>>0}enable(e){this.mask|=1<<e}enableAll(){this.mask=-1}toggle(e){this.mask^=1<<e}disable(e){this.mask&=~(1<<e)}disableAll(){this.mask=0}test(e){return 0!==(this.mask&e.mask)}isEnabled(e){return!!(this.mask&1<<e)}}let _object3DId=0;const _v1$5=new Vector3,_q1=new Quaternion,_m1$1=new Matrix4,_target=new Vector3,_position$4=new Vector3,_scale$b=new Vector3,_quaternion$3=new Quaternion,_xAxis=new Vector3(1,0,0),_yAxis=new Vector3(0,1,0),_zAxis=new Vector3(0,0,1),_addedEvent={type:"added"},_removedEvent={type:"removed"};class Object3D extends EventDispatcher{constructor(){super(),this.isObject3D=!0,Object.defineProperty(this,"id",{value:_object3DId++}),this.uuid=generateUUID(),this.name="",this.type="Object3D",this.parent=null,this.children=[],this.up=Object3D.DefaultUp.clone();const e=new Vector3,t=new Euler,n=new Quaternion,o=new Vector3(1,1,1);t._onChange(function(){n.setFromEuler(t,!1)}),n._onChange(function(){t.setFromQuaternion(n,void 0,!1)}),Object.defineProperties(this,{position:{configurable:!0,enumerable:!0,value:e},rotation:{configurable:!0,enumerable:!0,value:t},quaternion:{configurable:!0,enumerable:!0,value:n},scale:{configurable:!0,enumerable:!0,value:o},modelViewMatrix:{value:new Matrix4},normalMatrix:{value:new Matrix3}}),this.matrix=new Matrix4,this.matrixWorld=new Matrix4,this.matrixAutoUpdate=Object3D.DefaultMatrixAutoUpdate,this.matrixWorldNeedsUpdate=!1,this.matrixWorldAutoUpdate=Object3D.DefaultMatrixWorldAutoUpdate,this.layers=new Layers,this.castShadow=!1,this.receiveShadow=!1,this.frustumCulled=!0,this.renderOrder=0,this.animations=[],this.userData={},this.internVisible=!0,this.externVisible=!0,this.constraints=[],this.disableChildRendering=!1,this.hidpiCompositing=!1,this.groupNames=[],this.objectIndex=0,this.objectColor=new Color,this.objectAlpha=1}set visible(e){this.externVisible=e}get visible(){return this.internVisible&&this.externVisible}onBeforeRender(){}onAfterRender(){}applyMatrix4(e){this.matrixAutoUpdate&&this.updateMatrix(),this.matrix.premultiply(e),this.matrix.decompose(this.position,this.quaternion,this.scale)}applyQuaternion(e){return this.quaternion.premultiply(e),this}setRotationFromAxisAngle(e,t){this.quaternion.setFromAxisAngle(e,t)}setRotationFromEuler(e){this.quaternion.setFromEuler(e,!0)}setRotationFromMatrix(e){this.quaternion.setFromRotationMatrix(e)}setRotationFromQuaternion(e){this.quaternion.copy(e)}rotateOnAxis(e,t){return _q1.setFromAxisAngle(e,t),this.quaternion.multiply(_q1),this}rotateOnWorldAxis(e,t){return _q1.setFromAxisAngle(e,t),this.quaternion.premultiply(_q1),this}rotateX(e){return this.rotateOnAxis(_xAxis,e)}rotateY(e){return this.rotateOnAxis(_yAxis,e)}rotateZ(e){return this.rotateOnAxis(_zAxis,e)}translateOnAxis(e,t){return _v1$5.copy(e).applyQuaternion(this.quaternion),this.position.add(_v1$5.multiplyScalar(t)),this}translateX(e){return this.translateOnAxis(_xAxis,e)}translateY(e){return this.translateOnAxis(_yAxis,e)}translateZ(e){return this.translateOnAxis(_zAxis,e)}localToWorld(e){return this.updateWorldMatrix(!0,!1),e.applyMatrix4(this.matrixWorld)}worldToLocal(e){return this.updateWorldMatrix(!0,!1),e.applyMatrix4(_m1$1.copy(this.matrixWorld).invert())}lookAt(e,t,n){e.isVector3?_target.copy(e):_target.set(e,t,n);const o=this.parent;this.updateWorldMatrix(!0,!1),_position$4.setFromMatrixPosition(this.matrixWorld),this.isCamera||this.isLight?_m1$1.lookAt(_position$4,_target,this.up):_m1$1.lookAt(_target,_position$4,this.up),this.quaternion.setFromRotationMatrix(_m1$1),o&&(_m1$1.extractRotation(o.matrixWorld),_q1.setFromRotationMatrix(_m1$1),this.quaternion.premultiply(_q1.invert()))}add(e){if(arguments.length>1){for(let e=0;e<arguments.length;e++)this.add(arguments[e]);return this}return e===this?(console.error("v3d.Object3D.add: object can't be added as a child of itself.",e),this):(e&&e.isObject3D?(null!==e.parent&&e.parent.remove(e),e.parent=this,this.children.push(e),e.dispatchEvent(_addedEvent)):console.error("v3d.Object3D.add: object not an instance of v3d.Object3D.",e),this)}remove(e){if(arguments.length>1){for(let e=0;e<arguments.length;e++)this.remove(arguments[e]);return this}const t=this.children.indexOf(e);return-1!==t&&(e.parent=null,this.children.splice(t,1),e.dispatchEvent(_removedEvent)),this}removeFromParent(){const e=this.parent;return null!==e&&e.remove(this),this}clear(){for(let e=0;e<this.children.length;e++){const t=this.children[e];t.parent=null,t.dispatchEvent(_removedEvent)}return this.children.length=0,this}attach(e){return this.updateWorldMatrix(!0,!1),_m1$1.copy(this.matrixWorld).invert(),null!==e.parent&&(e.parent.updateWorldMatrix(!0,!1),_m1$1.multiply(e.parent.matrixWorld)),e.applyMatrix4(_m1$1),this.add(e),e.updateWorldMatrix(!1,!0),this}getObjectById(e){return this.getObjectByProperty("id",e)}getObjectByName(e){return this.getObjectByProperty("name",e)}getObjectByProperty(e,t){if(this[e]===t)return this;for(let n=0,o=this.children.length;n<o;n++){const o=this.children[n].getObjectByProperty(e,t);if(void 0!==o)return o}}getObjectsByProperty(e,t){let n=[];this[e]===t&&n.push(this);for(let o=0,r=this.children.length;o<r;o++){const r=this.children[o].getObjectsByProperty(e,t);r.length>0&&(n=n.concat(r))}return n}getWorldPosition(e){return this.updateWorldMatrix(!0,!1),e.setFromMatrixPosition(this.matrixWorld)}getWorldQuaternion(e){return this.updateWorldMatrix(!0,!1),this.matrixWorld.decompose(_position$4,e,_scale$b),e}getWorldScale(e){return this.updateWorldMatrix(!0,!1),this.matrixWorld.decompose(_position$4,_quaternion$3,e),e}getWorldDirection(e){this.updateWorldMatrix(!0,!1);const t=this.matrixWorld.elements;return e.set(t[4],t[5],t[6]).normalize()}raycast(){}traverse(e){e(this);const t=this.children;for(let n=0,o=t.length;n<o;n++)t[n].traverse(e)}traverseVisible(e){if(!1===this.visible)return;e(this);const t=this.children;for(let n=0,o=t.length;n<o;n++)t[n].traverseVisible(e)}traverseAncestors(e){const t=this.parent;null!==t&&(e(t),t.traverseAncestors(e))}updateMatrix(){this.updateConstraints(),this.matrix.compose(this.position,this.quaternion,this.scale),this.matrixWorldNeedsUpdate=!0}updateMatrixWorld(e){this.matrixAutoUpdate&&this.updateMatrix(),(this.matrixWorldNeedsUpdate||e)&&(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix),this.matrixWorldNeedsUpdate=!1,e=!0);const t=this.children;for(let n=0,o=t.length;n<o;n++){const o=t[n];!0!==o.matrixWorldAutoUpdate&&!0!==e||o.updateMatrixWorld(e)}}updateWorldMatrix(e,t){const n=this.parent;if(!0===e&&null!==n&&n.updateWorldMatrix(!0,!1),this.matrixAutoUpdate&&this.updateMatrix(),null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix),!0===t){const e=this.children;for(let t=0,n=e.length;t<n;t++){e[t].updateWorldMatrix(!1,!0)}}}clone(e){return(new this.constructor).copy(this,e)}copy(e,t=!0){this.name=e.name,this.up.copy(e.up),this.position.copy(e.position),this.rotation.order=e.rotation.order,this.quaternion.copy(e.quaternion),this.scale.copy(e.scale),this.matrix.copy(e.matrix),this.matrixWorld.copy(e.matrixWorld),this.matrixAutoUpdate=e.matrixAutoUpdate,this.matrixWorldNeedsUpdate=e.matrixWorldNeedsUpdate,this.matrixWorldAutoUpdate=e.matrixWorldAutoUpdate,this.layers.mask=e.layers.mask,this.visible=e.visible,this.disableChildRendering=e.disableChildRendering,this.hidpiCompositing=e.hidpiCompositing,this.objectIndex=e.objectIndex,this.objectColor.copy(e.objectColor),this.objectAlpha=e.objectAlpha,this.constraints=[];for(let t=0;t<e.constraints.length;t++)this.constraints.push(e.constraints[t].clone());if(this.castShadow=e.castShadow,this.receiveShadow=e.receiveShadow,this.frustumCulled=e.frustumCulled,this.renderOrder=e.renderOrder,this.userData=JSON.parse(JSON.stringify(e.userData)),!0===t)for(let t=0;t<e.children.length;t++){const n=e.children[t];this.add(n.clone())}return this}copyTransform(e){this.matrix.copy(e.matrixWorld),this.parent&&this.matrix.multiplyMatrices(_m1$1.copy(this.parent.matrixWorld).invert(),this.matrix),this.matrix.decompose(this.position,this.quaternion,this.scale)}isVisible(){return this.visible}updateConstraints(){for(let e=0;e<this.constraints.length;e++)this.constraints[e].update(this)}getWorldPositionNU(e){return e.setFromMatrixPosition(this.matrixWorld)}getLocalDirection(e){const t=this.matrix.elements;return this.isCamera||this.isLight?e.set(-t[8],-t[9],-t[10]).normalize():e.set(t[8],t[9],t[10]).normalize()}lookAtLocal(e,t,n){e.isVector3?_target.copy(e):_target.set(e,t,n),_position$4.setFromMatrixPosition(this.matrix),this.isCamera||this.isLight?_m1$1.lookAt(_position$4,_target,this.up):_m1$1.lookAt(_target,_position$4,this.up),this.quaternion.setFromRotationMatrix(_m1$1)}findRoot(){let e=this;return this.traverseAncestors(function(t){e=t}),e}resolveMultiMaterial(){const e=[];for(let t=0;t<this.children.length;t++){const n=this.children[t];n.isMesh&&n.isMaterialGeneratedMesh&&e.push(n)}return e.length||e.push(this),e}getAuxClippingMeshes(){const e=[];for(let t=0;t<this.children.length;t++){const n=this.children[t];n.isMesh&&n.isAuxClippingMesh&&e.push(n)}return e}getWorldEuler(e,t=e._order){return this.updateWorldMatrix(!0,!1),this.matrixWorld.decomposeE(_position$4,e,_scale$b,t),e}}Object3D.DefaultUp=new Vector3(0,1,0),Object3D.DefaultMatrixAutoUpdate=!0,Object3D.DefaultMatrixWorldAutoUpdate=!0;const _v0$1=new Vector3,_v1$4=new Vector3,_v2$3=new Vector3,_v3$1=new Vector3,_vab=new Vector3,_vac=new Vector3,_vbc=new Vector3,_vap=new Vector3,_vbp=new Vector3,_vcp=new Vector3,_v40=new Vector4,_v41=new Vector4,_v42=new Vector4;class Triangle{constructor(e=new Vector3,t=new Vector3,n=new Vector3){this.a=e,this.b=t,this.c=n}static getNormal(e,t,n,o){o.subVectors(n,t),_v0$1.subVectors(e,t),o.cross(_v0$1);const r=o.lengthSq();return r>0?o.multiplyScalar(1/Math.sqrt(r)):o.set(0,0,0)}static getBarycoord(e,t,n,o,r){_v0$1.subVectors(o,t),_v1$4.subVectors(n,t),_v2$3.subVectors(e,t);const i=_v0$1.dot(_v0$1),a=_v0$1.dot(_v1$4),s=_v0$1.dot(_v2$3),l=_v1$4.dot(_v1$4),c=_v1$4.dot(_v2$3),u=i*l-a*a;if(0===u)return r.set(0,0,0),null;const d=1/u,h=(l*s-a*c)*d,p=(i*c-a*s)*d;return r.set(1-h-p,p,h)}static containsPoint(e,t,n,o){return null!==this.getBarycoord(e,t,n,o,_v3$1)&&(_v3$1.x>=0&&_v3$1.y>=0&&_v3$1.x+_v3$1.y<=1)}static getInterpolation(e,t,n,o,r,i,a,s){return null===this.getBarycoord(e,t,n,o,_v3$1)?(s.x=0,s.y=0,"z"in s&&(s.z=0),"w"in s&&(s.w=0),null):(s.setScalar(0),s.addScaledVector(r,_v3$1.x),s.addScaledVector(i,_v3$1.y),s.addScaledVector(a,_v3$1.z),s)}static getInterpolatedAttribute(e,t,n,o,r,i){return _v40.setScalar(0),_v41.setScalar(0),_v42.setScalar(0),_v40.fromBufferAttribute(e,t),_v41.fromBufferAttribute(e,n),_v42.fromBufferAttribute(e,o),i.setScalar(0),i.addScaledVector(_v40,r.x),i.addScaledVector(_v41,r.y),i.addScaledVector(_v42,r.z),i}static isFrontFacing(e,t,n,o){return _v0$1.subVectors(n,t),_v1$4.subVectors(e,t),_v0$1.cross(_v1$4).dot(o)<0}set(e,t,n){return this.a.copy(e),this.b.copy(t),this.c.copy(n),this}setFromPointsAndIndices(e,t,n,o){return this.a.copy(e[t]),this.b.copy(e[n]),this.c.copy(e[o]),this}setFromAttributeAndIndices(e,t,n,o){return this.a.fromBufferAttribute(e,t),this.b.fromBufferAttribute(e,n),this.c.fromBufferAttribute(e,o),this}clone(){return(new this.constructor).copy(this)}copy(e){return this.a.copy(e.a),this.b.copy(e.b),this.c.copy(e.c),this}getArea(){return _v0$1.subVectors(this.c,this.b),_v1$4.subVectors(this.a,this.b),.5*_v0$1.cross(_v1$4).length()}getMidpoint(e){return e.addVectors(this.a,this.b).add(this.c).multiplyScalar(1/3)}getNormal(e){return Triangle.getNormal(this.a,this.b,this.c,e)}getPlane(e){return e.setFromCoplanarPoints(this.a,this.b,this.c)}getBarycoord(e,t){return Triangle.getBarycoord(e,this.a,this.b,this.c,t)}getInterpolation(e,t,n,o,r){return Triangle.getInterpolation(e,this.a,this.b,this.c,t,n,o,r)}containsPoint(e){return Triangle.containsPoint(e,this.a,this.b,this.c)}isFrontFacing(e){return Triangle.isFrontFacing(this.a,this.b,this.c,e)}intersectsBox(e){return e.intersectsTriangle(this)}closestPointToPoint(e,t){const n=this.a,o=this.b,r=this.c;let i,a;_vab.subVectors(o,n),_vac.subVectors(r,n),_vap.subVectors(e,n);const s=_vab.dot(_vap),l=_vac.dot(_vap);if(s<=0&&l<=0)return t.copy(n);_vbp.subVectors(e,o);const c=_vab.dot(_vbp),u=_vac.dot(_vbp);if(c>=0&&u<=c)return t.copy(o);const d=s*u-c*l;if(d<=0&&s>=0&&c<=0)return i=s/(s-c),t.copy(n).addScaledVector(_vab,i);_vcp.subVectors(e,r);const h=_vab.dot(_vcp),p=_vac.dot(_vcp);if(p>=0&&h<=p)return t.copy(r);const f=h*l-s*p;if(f<=0&&l>=0&&p<=0)return a=l/(l-p),t.copy(n).addScaledVector(_vac,a);const m=c*p-h*u;if(m<=0&&u-c>=0&&h-p>=0)return _vbc.subVectors(r,o),a=(u-c)/(u-c+(h-p)),t.copy(o).addScaledVector(_vbc,a);const g=1/(m+f+d);return i=f*g,a=d*g,t.copy(n).addScaledVector(_vab,i).addScaledVector(_vac,a)}equals(e){return e.a.equals(this.a)&&e.b.equals(this.b)&&e.c.equals(this.c)}}let materialId=0;class Material extends EventDispatcher{constructor(){super(),this.isMaterial=!0,Object.defineProperty(this,"id",{value:materialId++}),this.uuid=generateUUID(),this.name="",this.type="Material",this.blending=1,this.side=0,this.vertexColors=!1,this.opacity=1,this.transparent=!1,this.blendSrc=204,this.blendDst=205,this.blendEquation=100,this.blendSrcAlpha=null,this.blendDstAlpha=null,this.blendEquationAlpha=null,this.depthFunc=3,this.depthTest=!0,this.depthWrite=!0,this.stencilWriteMask=255,this.stencilFunc=519,this.stencilRef=0,this.stencilFuncMask=255,this.stencilFail=7680,this.stencilZFail=7680,this.stencilZPass=7680,this.stencilWrite=!1,this.clippingPlanes=null,this.clipIntersection=!1,this.clipShadows=!1,this.shadowSide=0,this.colorWrite=!0,this.precision=null,this.polygonOffset=!1,this.polygonOffsetFactor=0,this.polygonOffsetUnits=0,this.dithering=!1,this.alphaToCoverage=!1,this.premultipliedAlpha=!1,this.visible=!0,this.toneMapped=!0,this.userData={},this.version=0,this._alphaTest=0,this.depthPrepass=!1,this.receiveShadow=!1,this.castShadow=!1,this.profile="",this.defines={},this.definesFragOnly=new Set,this.DefaultEnvMapAutoAssign=!0,this.envMapAutoAssign=this.DefaultEnvMapAutoAssign,this.gtaoVisible=!0}get alphaTest(){return this._alphaTest}set alphaTest(e){this._alphaTest>0!=e>0&&this.version++,this._alphaTest=e}onBuild(){}onBeforeRender(){}onBeforeCompile(){}customProgramCacheKey(){return this.onBeforeCompile.toString()}setValues(e){if(void 0!==e)for(const t in e){const n=e[t];if(void 0===n){console.warn("v3d.Material: '"+t+"' parameter is undefined.");continue}const o=this[t];void 0!==o?o&&o.isColor?o.set(n):o&&o.isVector3&&n&&n.isVector3?o.copy(n):this[t]=n:console.warn("v3d."+this.type+": '"+t+"' is not a property of this material.")}}clone(){return(new this.constructor).copy(this)}copy(e){this.name=e.name,this.blending=e.blending,this.side=e.side,this.vertexColors=e.vertexColors,this.opacity=e.opacity,this.transparent=e.transparent,this.blendSrc=e.blendSrc,this.blendDst=e.blendDst,this.blendEquation=e.blendEquation,this.blendSrcAlpha=e.blendSrcAlpha,this.blendDstAlpha=e.blendDstAlpha,this.blendEquationAlpha=e.blendEquationAlpha,this.depthFunc=e.depthFunc,this.depthTest=e.depthTest,this.depthWrite=e.depthWrite,this.stencilWriteMask=e.stencilWriteMask,this.stencilFunc=e.stencilFunc,this.stencilRef=e.stencilRef,this.stencilFuncMask=e.stencilFuncMask,this.stencilFail=e.stencilFail,this.stencilZFail=e.stencilZFail,this.stencilZPass=e.stencilZPass,this.stencilWrite=e.stencilWrite;const t=e.clippingPlanes;let n=null;if(null!==t){const e=t.length;n=new Array(e);for(let o=0;o!==e;++o)n[o]=t[o].clone()}return this.clippingPlanes=n,this.clipIntersection=e.clipIntersection,this.clipShadows=e.clipShadows,this.shadowSide=e.shadowSide,this.colorWrite=e.colorWrite,this.precision=e.precision,this.polygonOffset=e.polygonOffset,this.polygonOffsetFactor=e.polygonOffsetFactor,this.polygonOffsetUnits=e.polygonOffsetUnits,this.dithering=e.dithering,this.alphaTest=e.alphaTest,this.alphaToCoverage=e.alphaToCoverage,this.premultipliedAlpha=e.premultipliedAlpha,this.visible=e.visible,this.toneMapped=e.toneMapped,this.userData=JSON.parse(JSON.stringify(e.userData)),this.depthPrepass=e.depthPrepass,this.defines=Object.assign({},e.defines),this.definesFragOnly=new Set(e.definesFragOnly),this.receiveShadow=e.receiveShadow,this.castShadow=e.castShadow,this.profile=e.profile,this.envMapAutoAssign=e.envMapAutoAssign,this.gtaoVisible=e.gtaoVisible,this}dispose(){this.dispatchEvent({type:"dispose"})}set needsUpdate(e){!0===e&&this.version++}get needsUpdate(){return 0!=this.version}}class MeshBasicMaterial extends Material{constructor(e){super(),this.isMeshBasicMaterial=!0,this.type="MeshBasicMaterial",this.color=new Color(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.alphaMap=null,this.envMap=null,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!0,this.setValues(e)}copy(e){return super.copy(e),this.color.copy(e.color),this.map=e.map,this.lightMap=e.lightMap,this.lightMapIntensity=e.lightMapIntensity,this.aoMap=e.aoMap,this.aoMapIntensity=e.aoMapIntensity,this.alphaMap=e.alphaMap,this.envMap=e.envMap,this.combine=e.combine,this.reflectivity=e.reflectivity,this.refractionRatio=e.refractionRatio,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.fog=e.fog,this}}const _vector$7=new Vector3,_vector2$1=new Vector2;class BufferAttribute{constructor(e,t,n=!1){if(Array.isArray(e))throw new TypeError("v3d.BufferAttribute: array should be a Typed Array.");this.isBufferAttribute=!0,this.name="",this.array=e,this.itemSize=t,this.count=void 0!==e?e.length/t:0,this.normalized=n,this.usage=35044,this.updateRange={offset:0,count:-1},this.gpuType=1015,this.version=0}onUploadCallback(){}set needsUpdate(e){!0===e&&this.version++}setUsage(e){return this.usage=e,this}copy(e){return this.name=e.name,this.array=new e.array.constructor(e.array),this.itemSize=e.itemSize,this.count=e.count,this.normalized=e.normalized,this.usage=e.usage,this.gpuType=e.gpuType,this}copyAt(e,t,n){e*=this.itemSize,n*=t.itemSize;for(let o=0,r=this.itemSize;o<r;o++)this.array[e+o]=t.array[n+o];return this}copyArray(e){return this.array.set(e),this}applyMatrix3(e){if(2===this.itemSize)for(let t=0,n=this.count;t<n;t++)_vector2$1.fromBufferAttribute(this,t),_vector2$1.applyMatrix3(e),this.setXY(t,_vector2$1.x,_vector2$1.y);else if(3===this.itemSize)for(let t=0,n=this.count;t<n;t++)_vector$7.fromBufferAttribute(this,t),_vector$7.applyMatrix3(e),this.setXYZ(t,_vector$7.x,_vector$7.y,_vector$7.z);return this}applyMatrix4(e){for(let t=0,n=this.count;t<n;t++)_vector$7.fromBufferAttribute(this,t),_vector$7.applyMatrix4(e),this.setXYZ(t,_vector$7.x,_vector$7.y,_vector$7.z);return this}applyNormalMatrix(e){for(let t=0,n=this.count;t<n;t++)_vector$7.fromBufferAttribute(this,t),_vector$7.applyNormalMatrix(e),this.setXYZ(t,_vector$7.x,_vector$7.y,_vector$7.z);return this}transformDirection(e){for(let t=0,n=this.count;t<n;t++)_vector$7.fromBufferAttribute(this,t),_vector$7.transformDirection(e),this.setXYZ(t,_vector$7.x,_vector$7.y,_vector$7.z);return this}set(e,t=0){return this.array.set(e,t),this}getX(e){let t=this.array[e*this.itemSize];return this.normalized&&(t=denormalize(t,this.array)),t}setX(e,t){return this.normalized&&(t=normalize(t,this.array)),this.array[e*this.itemSize]=t,this}getY(e){let t=this.array[e*this.itemSize+1];return this.normalized&&(t=denormalize(t,this.array)),t}setY(e,t){return this.normalized&&(t=normalize(t,this.array)),this.array[e*this.itemSize+1]=t,this}getZ(e){let t=this.array[e*this.itemSize+2];return this.normalized&&(t=denormalize(t,this.array)),t}setZ(e,t){return this.normalized&&(t=normalize(t,this.array)),this.array[e*this.itemSize+2]=t,this}getW(e){let t=this.array[e*this.itemSize+3];return this.normalized&&(t=denormalize(t,this.array)),t}setW(e,t){return this.normalized&&(t=normalize(t,this.array)),this.array[e*this.itemSize+3]=t,this}setXY(e,t,n){return e*=this.itemSize,this.normalized&&(t=normalize(t,this.array),n=normalize(n,this.array)),this.array[e+0]=t,this.array[e+1]=n,this}setXYZ(e,t,n,o){return e*=this.itemSize,this.normalized&&(t=normalize(t,this.array),n=normalize(n,this.array),o=normalize(o,this.array)),this.array[e+0]=t,this.array[e+1]=n,this.array[e+2]=o,this}setXYZW(e,t,n,o,r){return e*=this.itemSize,this.normalized&&(t=normalize(t,this.array),n=normalize(n,this.array),o=normalize(o,this.array),r=normalize(r,this.array)),this.array[e+0]=t,this.array[e+1]=n,this.array[e+2]=o,this.array[e+3]=r,this}onUpload(e){return this.onUploadCallback=e,this}clone(){return new this.constructor(this.array,this.itemSize).copy(this)}}class Int8BufferAttribute extends BufferAttribute{constructor(e,t,n){super(new Int8Array(e),t,n)}}class Uint8BufferAttribute extends BufferAttribute{constructor(e,t,n){super(new Uint8Array(e),t,n)}}class Uint8ClampedBufferAttribute extends BufferAttribute{constructor(e,t,n){super(new Uint8ClampedArray(e),t,n)}}class Int16BufferAttribute extends BufferAttribute{constructor(e,t,n){super(new Int16Array(e),t,n)}}class Uint16BufferAttribute extends BufferAttribute{constructor(e,t,n){super(new Uint16Array(e),t,n)}}class Int32BufferAttribute extends BufferAttribute{constructor(e,t,n){super(new Int32Array(e),t,n)}}class Uint32BufferAttribute extends BufferAttribute{constructor(e,t,n){super(new Uint32Array(e),t,n)}}class Float16BufferAttribute extends BufferAttribute{constructor(e,t,n){super(new Uint16Array(e),t,n),this.isFloat16BufferAttribute=!0}}class Float32BufferAttribute extends BufferAttribute{constructor(e,t,n){super(new Float32Array(e),t,n)}}class Float64BufferAttribute extends BufferAttribute{constructor(e,t,n){super(new Float64Array(e),t,n)}}let _id=0;const _m1=new Matrix4,_obj=new Object3D,_offset=new Vector3,_box$2=new Box3,_boxMorphTargets=new Box3,_vector$6=new Vector3;class BufferGeometry extends EventDispatcher{constructor(){super(),this.isBufferGeometry=!0,Object.defineProperty(this,"id",{value:_id++}),this.uuid=generateUUID(),this.name="",this.type="BufferGeometry",this.index=null,this.attributes={},this.morphAttributes={},this.morphTargetsRelative=!1,this.groups=[],this.boundingBox=null,this.boundingSphere=null,this.boundsTree=null,this.drawRange={start:0,count:1/0},this.userData={}}getIndex(){return this.index}setIndex(e){return Array.isArray(e)?this.index=new BufferAttribute(new(arrayNeedsUint32(e)?Uint32Array:Uint16Array)(e),1):this.index=e,this}getAttribute(e){return this.attributes[e]}setAttribute(e,t){return this.attributes[e]=t,this}deleteAttribute(e){return delete this.attributes[e],this}hasAttribute(e){return void 0!==this.attributes[e]}addGroup(e,t,n=0){this.groups.push({start:e,count:t,materialIndex:n})}clearGroups(){this.groups=[]}setDrawRange(e,t){this.drawRange.start=e,this.drawRange.count=t}applyMatrix4(e){const t=this.attributes.position;void 0!==t&&(t.applyMatrix4(e),t.needsUpdate=!0);const n=this.attributes.normal;if(void 0!==n){const t=(new Matrix3).getNormalMatrix(e);n.applyNormalMatrix(t),n.needsUpdate=!0}const o=this.attributes.tangent;return void 0!==o&&(o.transformDirection(e),o.needsUpdate=!0),null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this}applyQuaternion(e){return _m1.makeRotationFromQuaternion(e),this.applyMatrix4(_m1),this}rotateX(e){return _m1.makeRotationX(e),this.applyMatrix4(_m1),this}rotateY(e){return _m1.makeRotationY(e),this.applyMatrix4(_m1),this}rotateZ(e){return _m1.makeRotationZ(e),this.applyMatrix4(_m1),this}translate(e,t,n){return _m1.makeTranslation(e,t,n),this.applyMatrix4(_m1),this}scale(e,t,n){return _m1.makeScale(e,t,n),this.applyMatrix4(_m1),this}lookAt(e){return _obj.lookAt(e),_obj.updateMatrix(),this.applyMatrix4(_obj.matrix),this}center(){return this.computeBoundingBox(),this.boundingBox.getCenter(_offset).negate(),this.translate(_offset.x,_offset.y,_offset.z),this}setFromPoints(e){const t=[];for(let n=0,o=e.length;n<o;n++){const o=e[n];t.push(o.x,o.y,o.z||0)}return this.setAttribute("position",new Float32BufferAttribute(t,3)),this}computeBoundingBox(){null===this.boundingBox&&(this.boundingBox=new Box3);const e=this.attributes.position,t=this.morphAttributes.position;if(e&&e.isGLBufferAttribute)return console.error('v3d.BufferGeometry.computeBoundingBox(): GLBufferAttribute requires a manual bounding box. Alternatively set "mesh.frustumCulled" to "false".',this),void this.boundingBox.set(new Vector3(-1/0,-1/0,-1/0),new Vector3(1/0,1/0,1/0));if(void 0!==e){if(this.boundingBox.setFromBufferAttribute(e),t)for(let e=0,n=t.length;e<n;e++){const n=t[e];_box$2.setFromBufferAttribute(n),this.morphTargetsRelative?(_vector$6.addVectors(this.boundingBox.min,_box$2.min),this.boundingBox.expandByPoint(_vector$6),_vector$6.addVectors(this.boundingBox.max,_box$2.max),this.boundingBox.expandByPoint(_vector$6)):(this.boundingBox.expandByPoint(_box$2.min),this.boundingBox.expandByPoint(_box$2.max))}}else this.boundingBox.makeEmpty();(isNaN(this.boundingBox.min.x)||isNaN(this.boundingBox.min.y)||isNaN(this.boundingBox.min.z))&&console.error('v3d.BufferGeometry.computeBoundingBox(): Computed min/max have NaN values. The "position" attribute is likely to have NaN values.',this)}computeBoundingSphere(){null===this.boundingSphere&&(this.boundingSphere=new Sphere);const e=this.attributes.position,t=this.morphAttributes.position;if(e&&e.isGLBufferAttribute)return console.error('v3d.BufferGeometry.computeBoundingSphere(): GLBufferAttribute requires a manual bounding sphere. Alternatively set "mesh.frustumCulled" to "false".',this),void this.boundingSphere.set(new Vector3,1/0);if(e){const n=this.boundingSphere.center;if(_box$2.setFromBufferAttribute(e),t)for(let e=0,n=t.length;e<n;e++){const n=t[e];_boxMorphTargets.setFromBufferAttribute(n),this.morphTargetsRelative?(_vector$6.addVectors(_box$2.min,_boxMorphTargets.min),_box$2.expandByPoint(_vector$6),_vector$6.addVectors(_box$2.max,_boxMorphTargets.max),_box$2.expandByPoint(_vector$6)):(_box$2.expandByPoint(_boxMorphTargets.min),_box$2.expandByPoint(_boxMorphTargets.max))}_box$2.getCenter(n);let o=0;for(let t=0,r=e.count;t<r;t++)_vector$6.fromBufferAttribute(e,t),o=Math.max(o,n.distanceToSquared(_vector$6));if(t)for(let r=0,i=t.length;r<i;r++){const i=t[r],a=this.morphTargetsRelative;for(let t=0,r=i.count;t<r;t++)_vector$6.fromBufferAttribute(i,t),a&&(_offset.fromBufferAttribute(e,t),_vector$6.add(_offset)),o=Math.max(o,n.distanceToSquared(_vector$6))}this.boundingSphere.radius=Math.sqrt(o),isNaN(this.boundingSphere.radius)&&console.error('v3d.BufferGeometry.computeBoundingSphere(): Computed radius is NaN. The "position" attribute is likely to have NaN values.',this)}}computeTangents(){const e=this.index,t=this.attributes;if(null===e||void 0===t.position||void 0===t.normal||void 0===t.uv)return void console.error("v3d.BufferGeometry: .computeTangents() failed. Missing required attributes (index, position, normal or uv)");const n=e.array,o=t.position.array,r=t.normal.array,i=t.uv.array,a=o.length/3;!1===this.hasAttribute("tangent")&&this.setAttribute("tangent",new BufferAttribute(new Float32Array(4*a),4));const s=this.getAttribute("tangent").array,l=[],c=[];for(let e=0;e<a;e++)l[e]=new Vector3,c[e]=new Vector3;const u=new Vector3,d=new Vector3,h=new Vector3,p=new Vector2,f=new Vector2,m=new Vector2,g=new Vector3,_=new Vector3;function A(e,t,n){u.fromArray(o,3*e),d.fromArray(o,3*t),h.fromArray(o,3*n),p.fromArray(i,2*e),f.fromArray(i,2*t),m.fromArray(i,2*n),d.sub(u),h.sub(u),f.sub(p),m.sub(p);const r=1/(f.x*m.y-m.x*f.y);isFinite(r)&&(g.copy(d).multiplyScalar(m.y).addScaledVector(h,-f.y).multiplyScalar(r),_.copy(h).multiplyScalar(f.x).addScaledVector(d,-m.x).multiplyScalar(r),l[e].add(g),l[t].add(g),l[n].add(g),c[e].add(_),c[t].add(_),c[n].add(_))}let v=this.groups;0===v.length&&(v=[{start:0,count:n.length}]);for(let e=0,t=v.length;e<t;++e){const t=v[e],o=t.start;for(let e=o,r=o+t.count;e<r;e+=3)A(n[e+0],n[e+1],n[e+2])}const x=new Vector3,y=new Vector3,b=new Vector3,C=new Vector3;function S(e){b.fromArray(r,3*e),C.copy(b);const t=l[e];x.copy(t),x.sub(b.multiplyScalar(b.dot(t))).normalize(),y.crossVectors(C,t);const n=y.dot(c[e])<0?-1:1;s[4*e]=x.x,s[4*e+1]=x.y,s[4*e+2]=x.z,s[4*e+3]=n}for(let e=0,t=v.length;e<t;++e){const t=v[e],o=t.start;for(let e=o,r=o+t.count;e<r;e+=3)S(n[e+0]),S(n[e+1]),S(n[e+2])}}computeVertexNormals(){const e=this.index,t=this.getAttribute("position");if(void 0!==t){let n=this.getAttribute("normal");if(void 0===n)n=new BufferAttribute(new Float32Array(3*t.count),3),this.setAttribute("normal",n);else for(let e=0,t=n.count;e<t;e++)n.setXYZ(e,0,0,0);const o=new Vector3,r=new Vector3,i=new Vector3,a=new Vector3,s=new Vector3,l=new Vector3,c=new Vector3,u=new Vector3;if(e)for(let d=0,h=e.count;d<h;d+=3){const h=e.getX(d+0),p=e.getX(d+1),f=e.getX(d+2);o.fromBufferAttribute(t,h),r.fromBufferAttribute(t,p),i.fromBufferAttribute(t,f),c.subVectors(i,r),u.subVectors(o,r),c.cross(u),a.fromBufferAttribute(n,h),s.fromBufferAttribute(n,p),l.fromBufferAttribute(n,f),a.add(c),s.add(c),l.add(c),n.setXYZ(h,a.x,a.y,a.z),n.setXYZ(p,s.x,s.y,s.z),n.setXYZ(f,l.x,l.y,l.z)}else for(let e=0,a=t.count;e<a;e+=3)o.fromBufferAttribute(t,e+0),r.fromBufferAttribute(t,e+1),i.fromBufferAttribute(t,e+2),c.subVectors(i,r),u.subVectors(o,r),c.cross(u),n.setXYZ(e+0,c.x,c.y,c.z),n.setXYZ(e+1,c.x,c.y,c.z),n.setXYZ(e+2,c.x,c.y,c.z);this.normalizeNormals(),n.needsUpdate=!0}}merge(){return console.error("v3d.BufferGeometry.merge() has been removed. Use v3d.BufferGeometryUtils.mergeBufferGeometries() instead."),this}normalizeNormals(){const e=this.attributes.normal;for(let t=0,n=e.count;t<n;t++)_vector$6.fromBufferAttribute(e,t),_vector$6.normalize(),e.setXYZ(t,_vector$6.x,_vector$6.y,_vector$6.z)}toNonIndexed(){function e(e,t){const n=e.array,o=e.itemSize,r=e.normalized,i=new n.constructor(t.length*o);let a=0,s=0;for(let e=0,r=t.length;e<r;e++){a=t[e]*o;for(let e=0;e<o;e++)i[s++]=n[a++]}return new BufferAttribute(i,o,r)}if(null===this.index)return console.warn("v3d.BufferGeometry.toNonIndexed(): BufferGeometry is already non-indexed."),this;const t=new BufferGeometry,n=this.index.array,o=this.attributes;for(const r in o){const i=e(o[r],n);t.setAttribute(r,i)}const r=this.morphAttributes;for(const o in r){const i=[],a=r[o];for(let t=0,o=a.length;t<o;t++){const o=e(a[t],n);i.push(o)}t.morphAttributes[o]=i}t.morphTargetsRelative=this.morphTargetsRelative;const i=this.groups;for(let e=0,n=i.length;e<n;e++){const n=i[e];t.addGroup(n.start,n.count,n.materialIndex)}return t}clone(){return(new this.constructor).copy(this)}copy(e){this.index=null,this.attributes={},this.morphAttributes={},this.groups=[],this.boundingBox=null,this.boundingSphere=null;const t={};this.name=e.name;const n=e.index;null!==n&&this.setIndex(n.clone(t));const o=e.attributes;for(const e in o){const n=o[e];this.setAttribute(e,n.clone(t))}const r=e.morphAttributes;for(const e in r){const n=[],o=r[e];for(let e=0,r=o.length;e<r;e++)n.push(o[e].clone(t));this.morphAttributes[e]=n}this.morphTargetsRelative=e.morphTargetsRelative;const i=e.groups;for(let e=0,t=i.length;e<t;e++){const t=i[e];this.addGroup(t.start,t.count,t.materialIndex)}const a=e.boundingBox;null!==a&&(this.boundingBox=a.clone());const s=e.boundingSphere;return null!==s&&(this.boundingSphere=s.clone()),this.drawRange.start=e.drawRange.start,this.drawRange.count=e.drawRange.count,this.userData=e.userData,void 0!==e.parameters&&(this.parameters=Object.assign({},e.parameters)),this}dispose(){this.dispatchEvent({type:"dispose"})}}const _inverseMatrix$2=new Matrix4,_ray$2=new Ray,_sphere$4=new Sphere,_vA$2=new Vector3,_vB$2=new Vector3,_vC$2=new Vector3,_tempA=new Vector3,_tempB=new Vector3,_tempC=new Vector3,_morphA=new Vector3,_morphB=new Vector3,_morphC=new Vector3,_uvA$2=new Vector2,_uvB$2=new Vector2,_uvC$2=new Vector2,_intersectionPoint$1=new Vector3,_intersectionPointWorld=new Vector3;class Mesh extends Object3D{constructor(e=new BufferGeometry,t=new MeshBasicMaterial){super(),this.isMesh=!0,this.type="Mesh",this.geometry=e,this.material=t,this.updateMorphTargets(),this.isMaterialGeneratedMesh=!1,this.isAuxClippingMesh=!1}copy(e,t){return super.copy(e,t),void 0!==e.morphTargetInfluences&&(this.morphTargetInfluences=e.morphTargetInfluences.slice()),void 0!==e.morphTargetDictionary&&(this.morphTargetDictionary=Object.assign({},e.morphTargetDictionary)),this.material=e.material,this.geometry=e.geometry,this.isMaterialGeneratedMesh=e.isMaterialGeneratedMesh,this}updateMorphTargets(){const e=this.geometry.morphAttributes,t=Object.keys(e);if(t.length>0){const n=e[t[0]];if(void 0!==n){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let e=0,t=n.length;e<t;e++){const t=n[e].name||String(e);this.morphTargetInfluences.push(0),this.morphTargetDictionary[t]=e}}}}getVertexPosition(e,t){const n=this.geometry,o=n.attributes.position,r=n.morphAttributes.position,i=n.morphTargetsRelative;t.fromBufferAttribute(o,e);const a=this.morphTargetInfluences;if(r&&a){_morphA.set(0,0,0);for(let n=0,o=r.length;n<o;n++){const o=a[n],s=r[n];0!==o&&(_tempA.fromBufferAttribute(s,e),i?_morphA.addScaledVector(_tempA,o):_morphA.addScaledVector(_tempA.sub(t),o))}t.add(_morphA)}return this.isSkinnedMesh&&this.boneTransform(e,t),t}raycast(e,t){if(this.isAuxClippingMesh)return;const n=this.geometry,o=this.material,r=this.matrixWorld;if(void 0===o)return;if(null===n.boundingSphere&&n.computeBoundingSphere(),_sphere$4.copy(n.boundingSphere),_sphere$4.applyMatrix4(r),!1===e.ray.intersectsSphere(_sphere$4))return;if(_inverseMatrix$2.copy(r).invert(),_ray$2.copy(e.ray).applyMatrix4(_inverseMatrix$2),null!==n.boundingBox&&!1===_ray$2.intersectsBox(n.boundingBox))return;let i;const a=n.index,s=n.attributes.position,l=n.morphAttributes.position,c=n.morphTargetsRelative,u=n.attributes.uv,d=n.attributes.uv2,h=n.groups,p=n.drawRange;if(null!==a)if(Array.isArray(o))for(let n=0,r=h.length;n<r;n++){const r=h[n],f=o[r.materialIndex];for(let n=Math.max(r.start,p.start),o=Math.min(a.count,Math.min(r.start+r.count,p.start+p.count));n<o;n+=3){const o=a.getX(n),h=a.getX(n+1),p=a.getX(n+2);i=checkBufferGeometryIntersection$1(this,f,e,_ray$2,s,l,c,u,d,o,h,p),i&&(i.faceIndex=Math.floor(n/3),i.face.materialIndex=r.materialIndex,t.push(i))}}else{for(let n=Math.max(0,p.start),r=Math.min(a.count,p.start+p.count);n<r;n+=3){const r=a.getX(n),h=a.getX(n+1),p=a.getX(n+2);i=checkBufferGeometryIntersection$1(this,o,e,_ray$2,s,l,c,u,d,r,h,p),i&&(i.faceIndex=Math.floor(n/3),t.push(i))}}else if(void 0!==s)if(Array.isArray(o))for(let n=0,r=h.length;n<r;n++){const r=h[n],a=o[r.materialIndex];for(let n=Math.max(r.start,p.start),o=Math.min(s.count,Math.min(r.start+r.count,p.start+p.count));n<o;n+=3){i=checkBufferGeometryIntersection$1(this,a,e,_ray$2,s,l,c,u,d,n,n+1,n+2),i&&(i.faceIndex=Math.floor(n/3),i.face.materialIndex=r.materialIndex,t.push(i))}}else{for(let n=Math.max(0,p.start),r=Math.min(s.count,p.start+p.count);n<r;n+=3){i=checkBufferGeometryIntersection$1(this,o,e,_ray$2,s,l,c,u,d,n,n+1,n+2),i&&(i.faceIndex=Math.floor(n/3),t.push(i))}}}clone(){return new this.constructor(this.geometry,this.material).copy(this)}getWorldDirection(e){this.updateWorldMatrix(!0,!1);const t=this.matrixWorld.elements;return e.set(t[8],t[9],t[10]).normalize()}isVisible(){return this.isMaterialGeneratedMesh&&this.parent?this.visible&&this.parent.visible:this.visible}}function checkIntersection$1(e,t,n,o,r,i,a,s){let l;if(l=1===t.side?o.intersectTriangle(a,i,r,!0,s):o.intersectTriangle(r,i,a,0===t.side,s),null===l)return null;_intersectionPointWorld.copy(s),_intersectionPointWorld.applyMatrix4(e.matrixWorld);const c=n.ray.origin.distanceTo(_intersectionPointWorld);return c<n.near||c>n.far?null:{distance:c,point:_intersectionPointWorld.clone(),object:e}}function checkBufferGeometryIntersection$1(e,t,n,o,r,i,a,s,l,c,u,d){_vA$2.fromBufferAttribute(r,c),_vB$2.fromBufferAttribute(r,u),_vC$2.fromBufferAttribute(r,d);const h=e.morphTargetInfluences;if(i&&h){_morphA.set(0,0,0),_morphB.set(0,0,0),_morphC.set(0,0,0);for(let e=0,t=i.length;e<t;e++){const t=h[e],n=i[e];0!==t&&(_tempA.fromBufferAttribute(n,c),_tempB.fromBufferAttribute(n,u),_tempC.fromBufferAttribute(n,d),a?(_morphA.addScaledVector(_tempA,t),_morphB.addScaledVector(_tempB,t),_morphC.addScaledVector(_tempC,t)):(_morphA.addScaledVector(_tempA.sub(_vA$2),t),_morphB.addScaledVector(_tempB.sub(_vB$2),t),_morphC.addScaledVector(_tempC.sub(_vC$2),t)))}_vA$2.add(_morphA),_vB$2.add(_morphB),_vC$2.add(_morphC)}e.isSkinnedMesh&&(e.boneTransform(c,_vA$2),e.boneTransform(u,_vB$2),e.boneTransform(d,_vC$2));const p=checkIntersection$1(e,t,n,o,_vA$2,_vB$2,_vC$2,_intersectionPoint$1);if(p){s&&(_uvA$2.fromBufferAttribute(s,c),_uvB$2.fromBufferAttribute(s,u),_uvC$2.fromBufferAttribute(s,d),p.uv=Triangle.getInterpolation(_intersectionPoint$1,_vA$2,_vB$2,_vC$2,_uvA$2,_uvB$2,_uvC$2,new Vector2)),l&&(_uvA$2.fromBufferAttribute(l,c),_uvB$2.fromBufferAttribute(l,u),_uvC$2.fromBufferAttribute(l,d),p.uv2=Triangle.getInterpolation(_intersectionPoint$1,_vA$2,_vB$2,_vC$2,_uvA$2,_uvB$2,_uvC$2,new Vector2));const e={a:c,b:u,c:d,normal:new Vector3,materialIndex:0};Triangle.getNormal(_vA$2,_vB$2,_vC$2,e.normal),p.face=e}return p}class BoxGeometry extends BufferGeometry{constructor(e=1,t=1,n=1,o=1,r=1,i=1){super(),this.type="BoxGeometry",this.parameters={width:e,height:t,depth:n,widthSegments:o,heightSegments:r,depthSegments:i};const a=this;o=Math.floor(o),r=Math.floor(r),i=Math.floor(i);const s=[],l=[],c=[],u=[];let d=0,h=0;function p(e,t,n,o,r,i,p,f,m,g,_){const A=i/m,v=p/g,x=i/2,y=p/2,b=f/2,C=m+1,S=g+1;let E=0,M=0;const T=new Vector3;for(let i=0;i<S;i++){const a=i*v-y;for(let s=0;s<C;s++){const d=s*A-x;T[e]=d*o,T[t]=a*r,T[n]=b,l.push(T.x,T.y,T.z),T[e]=0,T[t]=0,T[n]=f>0?1:-1,c.push(T.x,T.y,T.z),u.push(s/m),u.push(1-i/g),E+=1}}for(let e=0;e<g;e++)for(let t=0;t<m;t++){const n=d+t+C*e,o=d+t+C*(e+1),r=d+(t+1)+C*(e+1),i=d+(t+1)+C*e;s.push(n,o,i),s.push(o,r,i),M+=6}a.addGroup(h,M,_),h+=M,d+=E}p("z","y","x",-1,-1,n,t,e,i,r,0),p("z","y","x",1,-1,n,t,-e,i,r,1),p("x","z","y",1,1,e,n,t,o,i,2),p("x","z","y",1,-1,e,n,-t,o,i,3),p("x","y","z",1,-1,e,t,n,o,r,4),p("x","y","z",-1,-1,e,t,-n,o,r,5),this.setIndex(s),this.setAttribute("position",new BufferAttribute(new Float32Array(l),3)),this.setAttribute("normal",new BufferAttribute(new Float32Array(c),3)),this.setAttribute("uv",new BufferAttribute(new Float32Array(u),2))}}function cloneUniforms(e){const t={};for(const n in e){t[n]={};for(const o in e[n]){const r=e[n][o];r&&(r.isColor||r.isMatrix3||r.isMatrix4||r.isVector2||r.isVector3||r.isVector4||r.isTexture||r.isQuaternion)?t[n][o]=r.clone():Array.isArray(r)?t[n][o]=r.slice():t[n][o]=r}}return t}function mergeUniforms(e){const t={};for(let n=0;n<e.length;n++){const o=cloneUniforms(e[n]);for(const e in o)t[e]=o[e]}return t}function cloneUniformsGroups(e){const t=[];for(let n=0;n<e.length;n++)t.push(e[n].clone());return t}function getUnlitUniformColorSpace(e){return null===e.getRenderTarget()&&3001===e.outputEncoding?"srgb":"srgb-linear"}const UniformsUtils={clone:cloneUniforms,merge:mergeUniforms};var default_vertex="void main(){\ngl_Position=projectionMatrix*modelViewMatrix*vec4(position,1.0);\n}",default_fragment="void main(){\ngl_FragColor=vec4(1.0,0.0,0.0,1.0);\n}";class ShaderMaterial extends Material{constructor(e){super(),this.isShaderMaterial=!0,this.type="ShaderMaterial",this.defines={},this.uniforms={},this.uniformsGroups=[],this.customPrepTokens={},this.vertexShader=default_vertex,this.fragmentShader=default_fragment,this.linewidth=1,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.lights=!1,this.clipping=!1,this.extensions={derivatives:!1,fragDepth:!1},this.defaultAttributeValues={color:[1,1,1],uv:[0,0],uv2:[0,0]},this.index0AttributeName=void 0,this.uniformsNeedUpdate=!1,this.glslVersion=null,void 0!==e&&this.setValues(e)}copy(e){return super.copy(e),this.fragmentShader=e.fragmentShader,this.vertexShader=e.vertexShader,this.uniforms=cloneUniforms(e.uniforms),this.uniformsGroups=cloneUniformsGroups(e.uniformsGroups),this.defines=Object.assign({},e.defines),this.customPrepTokens=Object.assign({},e.customPrepTokens),this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.fog=e.fog,this.lights=e.lights,this.clipping=e.clipping,this.extensions=Object.assign({},e.extensions),this.glslVersion=e.glslVersion,this}}class Camera extends Object3D{constructor(){super(),this.isCamera=!0,this.type="Camera",this.matrixWorldInverse=new Matrix4,this.projectionMatrix=new Matrix4,this.projectionMatrixInverse=new Matrix4,this.controlSettings=null,this.viewportFit={type:0,initialAspect:1},this.ignoreShadowLayers=!1}get controls(){return console.warn("v3d.Camera.controls replaced by v3d.Camera.controlSettings"),this.controlSettings}set controls(e){console.warn("v3d.Camera.controls replaced by v3d.Camera.controlSettings"),this.controlSettings=e}copy(e,t){return super.copy(e,t),this.matrixWorldInverse.copy(e.matrixWorldInverse),this.projectionMatrix.copy(e.projectionMatrix),this.projectionMatrixInverse.copy(e.projectionMatrixInverse),e.controlSettings&&(this.controlSettings=e.controlSettings.clone()),this.viewportFit.type=e.viewportFit.type,this.viewportFit.initialAspect=e.viewportFit.initialAspect,this.ignoreShadowLayers=e.ignoreShadowLayers,this}getWorldDirection(e){this.updateWorldMatrix(!0,!1);const t=this.matrixWorld.elements;return e.set(-t[8],-t[9],-t[10]).normalize()}updateMatrixWorld(e){super.updateMatrixWorld(e),this.matrixWorldInverse.copy(this.matrixWorld).invert()}updateWorldMatrix(e,t){super.updateWorldMatrix(e,t),this.matrixWorldInverse.copy(this.matrixWorld).invert()}clone(e){return(new this.constructor).copy(this,e)}}class PerspectiveCamera extends Camera{constructor(e=50,t=1,n=.1,o=2e3){super(),this.isPerspectiveCamera=!0,this.type="PerspectiveCamera",this.fov=e,this.zoom=1,this.near=n,this.far=o,this.focus=10,this.aspect=t,this.view=null,this.filmGauge=35,this.filmOffset=0,this.updateProjectionMatrix()}copy(e,t){return super.copy(e,t),this.fov=e.fov,this.zoom=e.zoom,this.near=e.near,this.far=e.far,this.focus=e.focus,this.aspect=e.aspect,this.view=null===e.view?null:Object.assign({},e.view),this.filmGauge=e.filmGauge,this.filmOffset=e.filmOffset,this}setFocalLength(e){const t=.5*this.getFilmHeight()/e;this.fov=2*RAD2DEG*Math.atan(t),this.updateProjectionMatrix()}getFocalLength(){const e=Math.tan(.5*DEG2RAD*this.fov);return.5*this.getFilmHeight()/e}getEffectiveFOV(){return 2*RAD2DEG*Math.atan(Math.tan(.5*DEG2RAD*this.fov)/this.zoom)}getFilmWidth(){return this.filmGauge*Math.min(this.aspect,1)}getFilmHeight(){return this.filmGauge/Math.max(this.aspect,1)}setViewOffset(e,t,n,o,r,i){this.aspect=e/t,null===this.view&&(this.view={enabled:!0,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=!0,this.view.fullWidth=e,this.view.fullHeight=t,this.view.offsetX=n,this.view.offsetY=o,this.view.width=r,this.view.height=i,this.updateProjectionMatrix()}clearViewOffset(){null!==this.view&&(this.view.enabled=!1),this.updateProjectionMatrix()}updateProjectionMatrix(){const e=this.near;let t=e*Math.tan(.5*DEG2RAD*this.fov)/this.zoom,n=2*t,o=this.aspect*n,r=-.5*o;const i=this.view;if(null!==this.view&&this.view.enabled){const e=i.fullWidth,a=i.fullHeight;r+=i.offsetX*o/e,t-=i.offsetY*n/a,o*=i.width/e,n*=i.height/a}const a=this.filmOffset;0!==a&&(r+=e*a/this.getFilmWidth()),this.projectionMatrix.makePerspective(r,r+o,t,t-n,e,this.far),this.projectionMatrixInverse.copy(this.projectionMatrix).invert()}}const fov=-90,aspect=1;class CubeCamera extends Object3D{constructor(e,t,n){super(),this.type="CubeCamera",this.renderTarget=n;const o=new PerspectiveCamera(-90,1,e,t);o.layers=this.layers,o.up.set(0,1,0),o.lookAt(1,0,0),this.add(o);const r=new PerspectiveCamera(-90,1,e,t);r.layers=this.layers,r.up.set(0,1,0),r.lookAt(-1,0,0),this.add(r);const i=new PerspectiveCamera(-90,1,e,t);i.layers=this.layers,i.up.set(0,0,-1),i.lookAt(0,1,0),this.add(i);const a=new PerspectiveCamera(-90,1,e,t);a.layers=this.layers,a.up.set(0,0,1),a.lookAt(0,-1,0),this.add(a);const s=new PerspectiveCamera(-90,1,e,t);s.layers=this.layers,s.up.set(0,1,0),s.lookAt(0,0,1),this.add(s);const l=new PerspectiveCamera(-90,1,e,t);l.layers=this.layers,l.up.set(0,1,0),l.lookAt(0,0,-1),this.add(l)}update(e,t){null===this.parent&&this.updateMatrixWorld();const n=this.renderTarget,[o,r,i,a,s,l]=this.children,c=e.getRenderTarget(),u=e.toneMapping,d=e.xr.enabled;e.toneMapping=0,e.xr.enabled=!1;const h=n.texture.generateMipmaps;n.texture.generateMipmaps=!1,e.setRenderTarget(n,0),e.render(t,o),e.setRenderTarget(n,1),e.render(t,r),e.setRenderTarget(n,2),e.render(t,i),e.setRenderTarget(n,3),e.render(t,a),e.setRenderTarget(n,4),e.render(t,s),n.texture.generateMipmaps=h,e.setRenderTarget(n,5),e.render(t,l),e.setRenderTarget(c),e.toneMapping=u,e.xr.enabled=d,n.texture.needsPMREMUpdate=!0}}class CubeTexture extends Texture{constructor(e,t,n,o,r,i,a,s,l,c){super(e=void 0!==e?e:[],t=void 0!==t?t:301,n,o,r,i,a,s,l,c),this.isCubeTexture=!0,this.flipY=!1}get images(){return this.source.data}set images(e){this.source.data=e}}class WebGLCubeRenderTarget extends WebGLRenderTarget{constructor(e=1,t={}){super(e,e,t),this.isWebGLCubeRenderTarget=!0;const n={width:e,height:e,depth:1},o=[n,n,n,n,n,n];this.texture=new CubeTexture(o,t.mapping,t.wrapS,t.wrapT,t.magFilter,t.minFilter,t.format,t.type,t.anisotropy,t.encoding),this.texture.isRenderTargetTexture=!0,this.texture.generateMipmaps=void 0!==t.generateMipmaps&&t.generateMipmaps,this.texture.minFilter=void 0!==t.minFilter?t.minFilter:1006}fromEquirectangularTexture(e,t){this.texture.type=t.type,this.texture.encoding=t.encoding,this.texture.generateMipmaps=t.generateMipmaps,this.texture.minFilter=t.minFilter,this.texture.magFilter=t.magFilter;const n={uniforms:{tEquirect:{value:null}},vertexShader:"\n\n                varying vec3 vWorldDirection;\n\n                vec3 transformDirection(in vec3 dir, in mat4 matrix) {\n\n                    return normalize((matrix * vec4(dir, 0.0)).xyz);\n\n                }\n\n                void main() {\n\n                    vWorldDirection = transformDirection(position, modelMatrix);\n\n                    #include <begin_vertex>\n                    #include <project_vertex>\n\n                }\n            ",fragmentShader:"\n\n                uniform sampler2D tEquirect;\n\n                varying vec3 vWorldDirection;\n\n                #include <common>\n\n                void main() {\n\n                    vec3 direction = normalize(vWorldDirection);\n\n                    vec2 sampleUV = equirectUv(direction);\n\n                    gl_FragColor = texture2D(tEquirect, sampleUV);\n\n                }\n            "},o=new BoxGeometry(5,5,5),r=new ShaderMaterial({name:"CubemapFromEquirect",uniforms:cloneUniforms(n.uniforms),vertexShader:n.vertexShader,fragmentShader:n.fragmentShader,side:1,blending:0});r.uniforms.tEquirect.value=t;const i=new Mesh(o,r),a=t.minFilter;1008===t.minFilter&&(t.minFilter=1006);return new CubeCamera(1,10,this).update(e,i),t.minFilter=a,i.geometry.dispose(),i.material.dispose(),this}clear(e,t,n,o){const r=e.getRenderTarget();for(let r=0;r<6;r++)e.setRenderTarget(this,r),e.clear(t,n,o);e.setRenderTarget(r)}}const Detector={checkWebGL:function(){try{const e=document.createElement("canvas");return!(!window.WebGLRenderingContext||!e.getContext("webgl"))}catch(e){return!1}},checkWebGL2:function(){try{const e=document.createElement("canvas");return!(!window.WebGL2RenderingContext||!e.getContext("webgl2"))}catch(e){return!1}},checkWorkers:function(){return!!window.Worker},checkFileAPI:function(){return window.File&&window.FileReader&&window.FileList&&window.Blob},genWebGLErrorMessage:function(e){const t=document.createElement("div");t.setAttribute("class","v3d-webgl-error-container");const n=document.createElement("div");n.setAttribute("class","v3d-webgl-error-image"),t.appendChild(n);const o=document.createElement("div");return o.setAttribute("class","v3d-webgl-error"),o.innerHTML=e,t.appendChild(o),t},showWebGLErrorMessage:function(e,t){(e=e||document.body).appendChild(Detector.genWebGLErrorMessage(t));const n=document.getElementById("v3d_preloader_container");n&&(n.style.visibility="hidden")},checkIOS:function(){return(/iPad|iPhone|iPod/.test(navigator.platform)||"MacIntel"===navigator.platform&&navigator.maxTouchPoints>1)&&!window.MSStream},checkAndroid:function(){return!!navigator.userAgent.match(/Android/i)},checkSafari:function(){return/Safari/.test(navigator.userAgent)&&!/Chrome/.test(navigator.userAgent)},checkFloatTex:function(e,t){const n=e.getContext();return!(!e.capabilities.isWebGL2||!n.getExtension("EXT_color_buffer_float")||t&&!n.getExtension("OES_texture_float_linear"))||!(e.capabilities.isWebGL2||!n.getExtension("OES_texture_float")||t&&!n.getExtension("OES_texture_float_linear"))},checkHalfFloatTex:function(e,t){const n=e.getContext();return!(!e.capabilities.isWebGL2||!n.getExtension("EXT_color_buffer_float"))||!(e.capabilities.isWebGL2||!n.getExtension("OES_texture_half_float")||t&&!n.getExtension("OES_texture_half_float_linear"))},checkHalfFloatReadPixels:function(e){const t=e.getContext(),n=e.capabilities;return!/Firefox/.test(navigator.userAgent)&&!!(t.getExtension("EXT_color_buffer_half_float")||n.isWebGL2&&t.getExtension("EXT_color_buffer_float"))},checkFloatReadPixels:function(e){const t=e.getContext();return!!(e.capabilities.isWebGL2||t.getExtension("OES_texture_float")||t.getExtension("WEBGL_color_buffer_float"))},checkDepthTex:function(e){const t=e.getContext();return!(!e.capabilities.isWebGL2&&!t.getExtension("WEBGL_depth_texture"))},getGPUVendor:function(e){const t=e?e.getContext():document.createElement("canvas").getContext("webgl");if(/Firefox/.test(navigator.userAgent))return t.getParameter(7936);{const e=t.getExtension("WEBGL_debug_renderer_info");return null!=e?t.getParameter(e.UNMASKED_VENDOR_WEBGL):""}},getGPUModel:function(e){const t=e?e.getContext():document.createElement("canvas").getContext("webgl");if(/Firefox/.test(navigator.userAgent))return t.getParameter(7937);{const e=t.getExtension("WEBGL_debug_renderer_info");return null!=e?t.getParameter(e.UNMASKED_RENDERER_WEBGL):""}},checkWebXR:function(e,t,n){"xr"in navigator&&navigator.xr.isSessionSupported?navigator.xr.isSessionSupported(e).then(function(e){e?t():n()}).catch(n):n()},checkSwiftShader:function(e){return"Google SwiftShader"==this.getGPUModel(e)},checkWebAudio:function(){return void 0!==(window.AudioContext||window.webkitAudioContext)},isSafariWithMultisamplingBug:function(){const e=navigator.userAgent;return!(!this.checkSafari()&&!e.match("MicroMessenger"))&&(e.match("Version/15.4")||e.match(/CPU (OS|iPhone OS) (15_4|15_4_1|15_4_2|15_4_3) like Mac OS X/))},isSafariWithUint16Bug:function(){const e=navigator.userAgent;return!(!this.checkSafari()&&!e.match("MicroMessenger"))&&e.match(/CPU (OS|iPhone OS) (11_[0-9][0-9_]*|12_[0-9][0-9_]*) like Mac OS X/)},isTouchDevice:function(){return"ontouchstart"in window||navigator.maxTouchPoints>0||navigator.msMaxTouchPoints>0}},_vector1=new Vector3,_vector2=new Vector3,_normalMatrix=new Matrix3;class Plane{constructor(e=new Vector3(1,0,0),t=0){this.isPlane=!0,this.normal=e,this.constant=t}set(e,t){return this.normal.copy(e),this.constant=t,this}setComponents(e,t,n,o){return this.normal.set(e,t,n),this.constant=o,this}setFromNormalAndCoplanarPoint(e,t){return this.normal.copy(e),this.constant=-t.dot(this.normal),this}setFromCoplanarPoints(e,t,n){const o=_vector1.subVectors(n,t).cross(_vector2.subVectors(e,t)).normalize();return this.setFromNormalAndCoplanarPoint(o,e),this}copy(e){return this.normal.copy(e.normal),this.constant=e.constant,this}normalize(){const e=1/this.normal.length();return this.normal.multiplyScalar(e),this.constant*=e,this}negate(){return this.constant*=-1,this.normal.negate(),this}distanceToPoint(e){return this.normal.dot(e)+this.constant}distanceToSphere(e){return this.distanceToPoint(e.center)-e.radius}projectPoint(e,t){return t.copy(this.normal).multiplyScalar(-this.distanceToPoint(e)).add(e)}intersectLine(e,t){const n=e.delta(_vector1),o=this.normal.dot(n);if(0===o)return 0===this.distanceToPoint(e.start)?t.copy(e.start):null;const r=-(e.start.dot(this.normal)+this.constant)/o;return r<0||r>1?null:t.copy(n).multiplyScalar(r).add(e.start)}intersectsLine(e){const t=this.distanceToPoint(e.start),n=this.distanceToPoint(e.end);return t<0&&n>0||n<0&&t>0}intersectsBox(e){return e.intersectsPlane(this)}intersectsSphere(e){return e.intersectsPlane(this)}coplanarPoint(e){return e.copy(this.normal).multiplyScalar(-this.constant)}applyMatrix4(e,t){const n=t||_normalMatrix.getNormalMatrix(e),o=this.coplanarPoint(_vector1).applyMatrix4(e),r=this.normal.applyMatrix3(n).normalize();return this.constant=-o.dot(r),this}translate(e){return this.constant-=e.dot(this.normal),this}equals(e){return e.normal.equals(this.normal)&&e.constant===this.constant}clone(){return(new this.constructor).copy(this)}}const _sphere$3=new Sphere,_vector$5=new Vector3;class Frustum{constructor(e=new Plane,t=new Plane,n=new Plane,o=new Plane,r=new Plane,i=new Plane){this.planes=[e,t,n,o,r,i]}set(e,t,n,o,r,i){const a=this.planes;return a[0].copy(e),a[1].copy(t),a[2].copy(n),a[3].copy(o),a[4].copy(r),a[5].copy(i),this}copy(e){const t=this.planes;for(let n=0;n<6;n++)t[n].copy(e.planes[n]);return this}setFromProjectionMatrix(e){const t=this.planes,n=e.elements,o=n[0],r=n[1],i=n[2],a=n[3],s=n[4],l=n[5],c=n[6],u=n[7],d=n[8],h=n[9],p=n[10],f=n[11],m=n[12],g=n[13],_=n[14],A=n[15];return t[0].setComponents(a-o,u-s,f-d,A-m).normalize(),t[1].setComponents(a+o,u+s,f+d,A+m).normalize(),t[2].setComponents(a+r,u+l,f+h,A+g).normalize(),t[3].setComponents(a-r,u-l,f-h,A-g).normalize(),t[4].setComponents(a-i,u-c,f-p,A-_).normalize(),t[5].setComponents(a+i,u+c,f+p,A+_).normalize(),this}intersectsObject(e){const t=e.geometry;return null===t.boundingSphere&&t.computeBoundingSphere(),_sphere$3.copy(t.boundingSphere).applyMatrix4(e.matrixWorld),this.intersectsSphere(_sphere$3)}intersectsSprite(e){return _sphere$3.center.set(0,0,0),_sphere$3.radius=.7071067811865476,_sphere$3.applyMatrix4(e.matrixWorld),this.intersectsSphere(_sphere$3)}intersectsSphere(e){const t=this.planes,n=e.center,o=-e.radius;for(let e=0;e<6;e++){if(t[e].distanceToPoint(n)<o)return!1}return!0}intersectsBox(e){const t=this.planes;for(let n=0;n<6;n++){const o=t[n];if(_vector$5.x=o.normal.x>0?e.max.x:e.min.x,_vector$5.y=o.normal.y>0?e.max.y:e.min.y,_vector$5.z=o.normal.z>0?e.max.z:e.min.z,o.distanceToPoint(_vector$5)<0)return!1}return!0}containsPoint(e){const t=this.planes;for(let n=0;n<6;n++)if(t[n].distanceToPoint(e)<0)return!1;return!0}clone(){return(new this.constructor).copy(this)}}class Scene extends Object3D{constructor(){super(),this.isScene=!0,this.type="Scene",this.background=null,this.backgroundRT=null,this.backgroundToneMapped=!0,this.environment=null,this.fog=null,this.backgroundBlurriness=0,this.backgroundIntensity=1,this.overrideMaterial=null,this.postprocessing=[],this.worldMaterial=null,this.worldEnvMapProbe=null,sendDevTools("observe",this)}copy(e,t){return super.copy(e,t),null!==e.background&&(this.background=e.background.clone()),null!==e.backgroundRT&&(this.backgroundRT=e.backgroundRT.clone()),this.backgroundToneMapped=e.backgroundToneMapped,null!==e.environment&&(this.environment=e.environment.clone()),null!==e.fog&&(this.fog=e.fog.clone()),this.backgroundBlurriness=e.backgroundBlurriness,this.backgroundIntensity=e.backgroundIntensity,null!==e.overrideMaterial&&(this.overrideMaterial=e.overrideMaterial.clone()),this.matrixAutoUpdate=e.matrixAutoUpdate,this}dispose(){this.dispatchEvent({type:"dispose"})}}function WebGLAnimation(){let e=null,t=!1,n=null,o=null;function r(t,i){n(t,i),o=e.requestAnimationFrame(r)}return{start:function(){!0!==t&&null!==n&&(o=e.requestAnimationFrame(r),t=!0)},stop:function(){e.cancelAnimationFrame(o),t=!1},setAnimationLoop:function(e){n=e},setContext:function(t){e=t}}}function WebGLAttributes(e,t){const n=t.isWebGL2;let o=new WeakMap;return{get:function(e){return o.get(e)},remove:function(t){const n=o.get(t);n&&(e.deleteBuffer(n.buffer),o.delete(t))},update:function(t,r){if(t.isGLBufferAttribute){const e=o.get(t);return void((!e||e.version<t.version)&&o.set(t,{buffer:t.buffer,type:t.type,bytesPerElement:t.elementSize,version:t.version}))}const i=o.get(t);void 0===i?o.set(t,function(t,o){const r=t.array,i=t.usage,a=e.createBuffer();let s;if(e.bindBuffer(o,a),e.bufferData(o,r,i),t.onUploadCallback(),r instanceof Float32Array)s=5126;else if(r instanceof Uint16Array)if(t.isFloat16BufferAttribute){if(!n)throw new Error("v3d.WebGLAttributes: Usage of Float16BufferAttribute requires WebGL2.");s=5131}else s=5123;else if(r instanceof Int16Array)s=5122;else if(r instanceof Uint32Array)s=5125;else if(r instanceof Int32Array)s=5124;else if(r instanceof Int8Array)s=5120;else if(r instanceof Uint8Array)s=5121;else{if(!(r instanceof Uint8ClampedArray))throw new Error("v3d.WebGLAttributes: Unsupported buffer data format: "+r);s=5121}return{buffer:a,type:s,bytesPerElement:r.BYTES_PER_ELEMENT,version:t.version}}(t,r)):i.version<t.version&&(!function(t,o,r){const i=o.array,a=o.updateRange;e.bindBuffer(r,t),-1===a.count?e.bufferSubData(r,0,i):(n?e.bufferSubData(r,a.offset*i.BYTES_PER_ELEMENT,i,a.offset,a.count):e.bufferSubData(r,a.offset*i.BYTES_PER_ELEMENT,i.subarray(a.offset,a.offset+a.count)),a.count=-1),o.onUploadCallback()}(i.buffer,t,r),i.version=t.version)},dispose:function(){o=new WeakMap}}}class PlaneGeometry extends BufferGeometry{constructor(e=1,t=1,n=1,o=1){super(),this.type="PlaneGeometry",this.parameters={width:e,height:t,widthSegments:n,heightSegments:o};const r=e/2,i=t/2,a=Math.floor(n),s=Math.floor(o),l=a+1,c=s+1,u=e/a,d=t/s,h=[],p=[],f=[],m=[];for(let e=0;e<c;e++){const t=e*d-i;for(let n=0;n<l;n++){const o=n*u-r;p.push(o,-t,0),f.push(0,0,1),m.push(n/a),m.push(1-e/s)}}for(let e=0;e<s;e++)for(let t=0;t<a;t++){const n=t+l*e,o=t+l*(e+1),r=t+1+l*(e+1),i=t+1+l*e;h.push(n,o,i),h.push(o,r,i)}this.setIndex(h),this.setAttribute("position",new BufferAttribute(new Float32Array(p),3)),this.setAttribute("normal",new BufferAttribute(new Float32Array(f),3)),this.setAttribute("uv",new BufferAttribute(new Float32Array(m),2))}}var alphamap_fragment="#ifdef USE_ALPHAMAP\ndiffuseColor.a*=texture2D(alphaMap,vUv).g;\n#endif",alphamap_pars_fragment="#ifdef USE_ALPHAMAP\nuniform sampler2D alphaMap;\n#endif",alphatest_fragment="#ifdef USE_ALPHATEST\nif (diffuseColor.a<alphaTest)\ndiscard;\nelse\ndiffuseColor.a=1.0;\n#endif",alphatest_pars_fragment="#ifdef USE_ALPHATEST\nuniform float alphaTest;\n#endif",aomap_fragment="#ifdef USE_AOMAP\nfloat ambientOcclusion=(texture2D(aoMap,vUv2).r-1.0)*aoMapIntensity+1.0;\nreflectedLight.indirectDiffuse*=ambientOcclusion;\n#if defined(USE_ENVMAP)&&defined(STANDARD)\nfloat dotNV=saturate(dot(geometry.normal,geometry.viewDir));\nreflectedLight.indirectSpecular*=computeSpecularOcclusion(dotNV,ambientOcclusion,material.roughness);\n#endif\n#endif",aomap_pars_fragment="#ifdef USE_AOMAP\nuniform sampler2D aoMap;\nuniform float aoMapIntensity;\n#endif",begin_vertex="vec3 transformed=vec3(position);",beginnormal_vertex="vec3 objectNormal=vec3(normal);\n#ifdef USE_TANGENT\nvec3 objectTangent=vec3(tangent.xyz);\n#endif",bsdfs="vec3 BRDF_Lambert(const in vec3 diffuseColor){\nreturn RECIPROCAL_PI*diffuseColor;\n}\nvec3 F_Schlick(const in vec3 f0,const in float f90,const in float dotVH){\nfloat fresnel=exp2((-5.55473*dotVH-6.98316)*dotVH);\nreturn f0*(1.0-fresnel)+(f90*fresnel);\n}\nfloat V_GGX_SmithCorrelated(const in float alpha,const in float dotNL,const in float dotNV){\nfloat a2=pow2(alpha);\nfloat gv=dotNL*sqrt(a2+(1.0-a2)*pow2(dotNV));\nfloat gl=dotNV*sqrt(a2+(1.0-a2)*pow2(dotNL));\nreturn 0.5/max(gv+gl,EPSILON);\n}\nfloat D_GGX(const in float alpha,const in float dotNH){\nfloat a2=pow2(alpha);\nfloat denom=pow2(dotNH)*(a2-1.0)+1.0;\nreturn RECIPROCAL_PI*a2/pow2(denom);\n}\nvec3 BRDF_GGX(const in vec3 lightDir,const in vec3 viewDir,const in vec3 normal,const in vec3 f0,const in float f90,const in float roughness){\nfloat alpha=pow2(clamp(roughness,0.04,1.0));\nvec3 halfDir=normalize(lightDir+viewDir);\nfloat dotNL=saturate(dot(normal,lightDir));\nfloat dotNV=saturate(dot(normal,viewDir));\nfloat dotNH=saturate(dot(normal,halfDir));\nfloat dotVH=saturate(dot(viewDir,halfDir));\nvec3 F=F_Schlick(f0,f90,dotVH);\nfloat V=V_GGX_SmithCorrelated(alpha,dotNL,dotNV);\nfloat D=D_GGX(alpha,dotNH);\nreturn F*(V*D);\n}\nvec2 LTC_Uv(const in vec3 N,const in vec3 V,const in float roughness){\nconst float LUT_SIZE=64.0;\nconst float LUT_SCALE=(LUT_SIZE-1.0)/LUT_SIZE;\nconst float LUT_BIAS=0.5/LUT_SIZE;\nfloat dotNV=saturate(dot(N,V));\nvec2 uv=vec2(roughness,sqrt(1.0-dotNV));\nuv=uv*LUT_SCALE+LUT_BIAS;\nreturn uv;\n}\nfloat LTC_ClippedSphereFormFactor(const in vec3 f){\nfloat l=length(f);\nreturn max((l*l+f.z)/(l+1.0),0.0);\n}\nvec3 LTC_EdgeVectorFormFactor(const in vec3 v1,const in vec3 v2){\nfloat x=dot(v1,v2);\nfloat y=abs(x);\nfloat a=0.8543985+(0.4965155+0.0145206*y)*y;\nfloat b=3.4175940+(4.1616724+y)*y;\nfloat v=a/b;\nfloat theta_sintheta=(x>0.0)?v:0.5*inversesqrt(max(1.0-x*x,1e-7))-v;\nreturn cross(v1,v2)*theta_sintheta;\n}\nvec3 LTC_Evaluate(const in vec3 N,const in vec3 V,const in vec3 P,const in mat3 mInv,const in vec3 rectCoords[4]){\nvec3 v1=rectCoords[1]-rectCoords[0];\nvec3 v2=rectCoords[3]-rectCoords[0];\nvec3 lightNormal=cross(v1,v2);\nif(dot(lightNormal,P-rectCoords[0])<0.0)return vec3(0.0);\nvec3 T1,T2;\nT1=normalize(V-N*dot(V,N));\nT2=-cross(N,T1);\nmat3 mat=mInv*transposeMat3(mat3(T1,T2,N));\nvec3 coords[4];\ncoords[0]=mat*(rectCoords[0]-P);\ncoords[1]=mat*(rectCoords[1]-P);\ncoords[2]=mat*(rectCoords[2]-P);\ncoords[3]=mat*(rectCoords[3]-P);\ncoords[0]=normalize(coords[0]);\ncoords[1]=normalize(coords[1]);\ncoords[2]=normalize(coords[2]);\ncoords[3]=normalize(coords[3]);\nvec3 vectorFormFactor=vec3(0.0);\nvectorFormFactor+=LTC_EdgeVectorFormFactor(coords[0],coords[1]);\nvectorFormFactor+=LTC_EdgeVectorFormFactor(coords[1],coords[2]);\nvectorFormFactor+=LTC_EdgeVectorFormFactor(coords[2],coords[3]);\nvectorFormFactor+=LTC_EdgeVectorFormFactor(coords[3],coords[0]);\nfloat result=LTC_ClippedSphereFormFactor(vectorFormFactor);\nreturn vec3(result);\n}\nvec2 integrateSpecularBRDF(const in float dotNV,const in float roughness){\nconst vec4 c0=vec4(-1,-0.0275,-0.572,0.022);\nconst vec4 c1=vec4(1,0.0425,1.04,-0.04);\nvec4 r=roughness*c0+c1;\nfloat a004=min(r.x*r.x,exp2(-9.28*dotNV))*r.x+r.y;\nreturn vec2(-1.04,1.04)*a004+r.zw;\n}\nvec3 BRDF_Specular_GGX_Environment(const in vec3 viewDir,const in vec3 normal,const in vec3 specularColor,const in vec3 specularColor90,const in float roughness){\nfloat dotNV=saturate(dot(normal,viewDir));\nvec2 brdf=integrateSpecularBRDF(dotNV,roughness);\nreturn specularColor*brdf.x+specularColor90*brdf.y;\n}\n#if defined(USE_SHEEN)\nfloat D_Charlie(float roughness,float dotNH){\nfloat alpha=pow2(roughness);\nfloat invAlpha=1.0/alpha;\nfloat cos2h=dotNH*dotNH;\nfloat sin2h=max(1.0-cos2h,0.0078125);\nreturn (2.0+invAlpha)*pow(sin2h,invAlpha*0.5)/(2.0*PI);\n}\nfloat V_Neubelt(float dotNV,float dotNL){\nreturn saturate(1.0/(4.0*(dotNL+dotNV-dotNL*dotNV)));\n}\nvec3 BRDF_Sheen(const in vec3 lightDir,const in vec3 viewDir,const in vec3 normal,vec3 sheenColor,const in float sheenRoughness){\nvec3 halfDir=normalize(lightDir+viewDir);\nfloat dotNL=saturate(dot(normal,lightDir));\nfloat dotNV=saturate(dot(normal,viewDir));\nfloat dotNH=saturate(dot(normal,halfDir));\nfloat D=D_Charlie(sheenRoughness,dotNH);\nfloat V=V_Neubelt(dotNV,dotNL);\nreturn sheenColor*(D*V);\n}\n#endif",bumpmap_pars_fragment="#ifdef USE_BUMPMAP\nuniform sampler2D bumpMap;\nuniform float bumpScale;\nvec2 dHdxy_fwd(){\nvec2 dSTdx=dFdx(vUv);\nvec2 dSTdy=dFdy(vUv);\nfloat Hll=bumpScale*texture2D(bumpMap,vUv).x;\nfloat dBx=bumpScale*texture2D(bumpMap,vUv+dSTdx).x-Hll;\nfloat dBy=bumpScale*texture2D(bumpMap,vUv+dSTdy).x-Hll;\nreturn vec2(dBx,dBy);\n}\nvec3 perturbNormalArb(vec3 surf_pos,vec3 surf_norm,vec2 dHdxy,float faceDirection){\nvec3 vSigmaX=dFdx(surf_pos.xyz);\nvec3 vSigmaY=dFdy(surf_pos.xyz);\nvec3 vN=surf_norm;\nvec3 R1=cross(vSigmaY,vN);\nvec3 R2=cross(vN,vSigmaX);\nfloat fDet=dot(vSigmaX,R1)*faceDirection;\nvec3 vGrad=sign(fDet)*(dHdxy.x*R1+dHdxy.y*R2);\nreturn normalize(abs(fDet)*surf_norm-vGrad);\n}\n#endif",clipping_planes_fragment="#if NUM_CLIPPING_PLANES>0\nvec4 plane;\n#pragma unroll_loop\nfor (int i=0;i<UNION_CLIPPING_PLANES;i++){\nplane=clippingPlanes[i];\nif (dot(vClipPosition,plane.xyz)>plane.w)discard;\n}\n#if UNION_CLIPPING_PLANES<NUM_CLIPPING_PLANES\nbool clipped=true;\n#pragma unroll_loop\nfor (int i=UNION_CLIPPING_PLANES;i<NUM_CLIPPING_PLANES;i++){\nplane=clippingPlanes[i];\nclipped=(dot(vClipPosition,plane.xyz)>plane.w)&&clipped;\n}\nif (clipped)discard;\n#endif\n#endif",clipping_planes_pars_fragment="#if NUM_CLIPPING_PLANES>0\nvarying vec3 vClipPosition;\nuniform vec4 clippingPlanes[NUM_CLIPPING_PLANES];\n#endif",clipping_planes_pars_vertex="#if NUM_CLIPPING_PLANES>0\nvarying vec3 vClipPosition;\n#endif",clipping_planes_vertex="#if NUM_CLIPPING_PLANES>0\nvClipPosition=-mvPosition.xyz;\n#endif",color_fragment="#if defined(USE_COLOR_ALPHA)\ndiffuseColor*=vColor;\n#elif defined(USE_COLOR)\ndiffuseColor.rgb*=vColor;\n#endif",color_pars_fragment="#if defined(USE_COLOR_ALPHA)\nvarying vec4 vColor;\n#elif defined(USE_COLOR)\nvarying vec3 vColor;\n#endif",color_pars_vertex="#if defined(USE_COLOR_ALPHA)\nvarying vec4 vColor;\n#elif defined(USE_COLOR)||defined(USE_INSTANCING_COLOR)\nvarying vec3 vColor;\n#endif",color_vertex="#if defined(USE_COLOR_ALPHA)\nvColor=vec4(1.0);\n#elif defined(USE_COLOR)||defined(USE_INSTANCING_COLOR)\nvColor=vec3(1.0);\n#endif\n#ifdef USE_COLOR\nvColor*=color;\n#endif\n#ifdef USE_INSTANCING_COLOR\nvColor.xyz*=instanceColor.xyz;\n#endif",common="#define PI 3.141592653589793\n#define PI2 6.283185307179586\n#define PI_HALF 1.5707963267948966\n#define RECIPROCAL_PI 0.3183098861837907\n#define RECIPROCAL_PI2 0.15915494309189535\n#define EPSILON 1e-6\n#ifndef saturate\n#define saturate(a)clamp(a,0.0,1.0)\n#endif\nfloat pow2(const in float x){return x*x;}\nvec3 pow2(const in vec3 x){return x*x;}\nfloat pow3(const in float x){return x*x*x;}\nfloat pow4(const in float x){float x2=x*x;return x2*x2;}\nfloat max3(const in vec3 v){return max(max(v.x,v.y),v.z);}\nfloat average(const in vec3 v){return dot(v,vec3(0.3333333));}\nhighp float rand(const in vec2 uv){\nconst highp float a=12.9898,b=78.233,c=43758.5453;\nhighp float dt=dot(uv.xy,vec2(a,b)),sn=mod(dt,PI);\nreturn fract(sin(sn)*c);\n}\nstruct IncidentLight {\nvec3 color;\nvec3 direction;\nbool visible;\n};\nstruct ReflectedLight {\nvec3 directDiffuse;\nvec3 directSpecular;\nvec3 indirectDiffuse;\nvec3 indirectSpecular;\n};\nstruct GeometricContext {\nvec3 position;\nvec3 normal;\nvec3 viewDir;\nvec3 probeNormal;\n#ifdef USE_CLEARCOAT\nvec3 clearcoatNormal;\n#endif\n};\nvec3 transformDirection(in vec3 dir,in mat4 matrix){\nreturn normalize((matrix*vec4(dir,0.0)).xyz);\n}\nvec3 inverseTransformDirection(in vec3 dir,in mat4 matrix){\nreturn normalize((vec4(dir,0.0)*matrix).xyz);\n}\nmat3 transposeMat3(const in mat3 m){\nmat3 tmp;\ntmp[0]=vec3(m[0].x,m[1].x,m[2].x);\ntmp[1]=vec3(m[0].y,m[1].y,m[2].y);\ntmp[2]=vec3(m[0].z,m[1].z,m[2].z);\nreturn tmp;\n}\nfloat linearToRelativeLuminance(const in vec3 color){\nconst vec3 weights=vec3(0.2126729,0.7151522,0.0721750);\nreturn dot(weights,color.rgb);\n}\nbool isPerspectiveMatrix(mat4 m){\nreturn m[2][3]==-1.0;\n}\nvec2 equirectUv(in vec3 dir){\nfloat u=atan(dir.z,dir.x)*RECIPROCAL_PI2+0.5;\nfloat v=asin(clamp(dir.y,-1.0,1.0))*RECIPROCAL_PI+0.5;\nreturn vec2(u,v);\n}\nvec3 octUVToCubeVec(vec2 octUV,vec2 texelSize){\noctUV=(1.0+2.0*texelSize)*octUV-texelSize;\noctUV=octUV*2.0-1.0;\nfloat x=octUV.x;\nfloat z=-octUV.y;\nfloat absX=abs(x);\nfloat absZ=abs(z);\nvec3 cubeVec=vec3(x,1.0-absX-absZ,z);\nif (absX+absZ>1.0){\ncubeVec.xz=-(vec2(absZ,absX)-1.0)*sign(vec2(x,z));\n}\nreturn cubeVec;\n}\nvec2 cubeVecToOctUV(vec3 cubeVec,vec2 texelSize){\ncubeVec/=dot(vec3(1.0),abs(cubeVec));\nvec2 octUV=vec2(cubeVec.x,-cubeVec.z);\nif (cubeVec.y<0.0){\noctUV=sign(octUV)*(1.0-abs(octUV.ts));\n}\noctUV=(octUV+1.0)/2.0;\noctUV=(1.0-2.0*texelSize)*octUV+texelSize;\nreturn octUV;\n}\nvec3 vec3RotateAxisAngle(vec3 vector,vec3 axis,float angle){\nvec3 axisNorm=normalize(axis);\nfloat x=axisNorm.x,y=axisNorm.y,z=axisNorm.z;\nfloat s=sin(angle),c=cos(angle);\nreturn mat3(x*x*(1.0-c)+c,x*y*(1.0-c)+z*s,x*z*(1.0-c)-y*s,x*y*(1.0-c)-z*s,y*y*(1.0-c)+c,y*z*(1.0-c)+x*s,x*z*(1.0-c)+y*s,y*z*(1.0-c)-x*s,z*z*(1.0-c)+c\n)*vector;\n}",cube_uv_reflection_fragment="#ifdef ENVMAP_TYPE_CUBE_UV\nfloat getFace(vec3 direction){\nvec3 absDirection=abs(direction);\nfloat face=-1.0;\nif (absDirection.x>absDirection.z){\nif (absDirection.x>absDirection.y){\nface=direction.x>0.0?0.0:3.0;\n} else {\nface=direction.y>0.0?1.0:4.0;\n}\n} else {\nif (absDirection.z>absDirection.y){\nface=direction.z>0.0?2.0:5.0;\n} else {\nface=direction.y>0.0?1.0:4.0;\n}\n}\nreturn face;\n}\nvec2 getUV(vec3 direction,float face){\nvec2 uv;\nif (face==0.0){\nuv=vec2(-direction.z,direction.y)/abs(direction.x);\n} else if (face==1.0){\nuv=vec2(direction.x,-direction.z)/abs(direction.y);\n} else if (face==2.0){\nuv=direction.xy/abs(direction.z);\n} else if (face==3.0){\nuv=vec2(direction.z,direction.y)/abs(direction.x);\n} else if (face==4.0){\nuv=direction.xz/abs(direction.y);\n} else {\nuv=vec2(-direction.x,direction.y)/abs(direction.z);\n}\nreturn 0.5*(uv+1.0);\n}\n#ifndef cubeUV_maxTileSize\n#define cubeUV_maxTileSize 256.0\n#endif\n#define cubeUV_lodIdxMin 0.0\n#define cubeUV_lodIdxLastDownscaled 4.0\n#define cubeUV_lodIdxMax 10.0\n#define cubeUV_minTileSize (cubeUV_maxTileSize/exp2(cubeUV_lodIdxLastDownscaled))\nfloat getLodTileSize(float lodIdx){\nreturn cubeUV_maxTileSize/exp2(min(lodIdx,cubeUV_lodIdxLastDownscaled));\n}\nfloat getLodFilterLevel(float lodIdx){\nreturn max(lodIdx-cubeUV_lodIdxLastDownscaled,0.0);\n}\nvec2 fixCubeUVSeams(vec2 uv,float faceSize){\nfloat BORDER_WIDTH_PX=max(cubeUV_maxTileSize/256.0-1.0,0.0);\nfloat scale=(faceSize-BORDER_WIDTH_PX)/faceSize;\nfloat offset=0.5*BORDER_WIDTH_PX/faceSize;\nreturn uv*scale+offset;\n}\nvec2 getUVPixels(vec3 direction,float lodIdx){\nfloat face=getFace(direction);\nfloat faceSize=getLodTileSize(lodIdx);\nfloat filterLevel=getLodFilterLevel(lodIdx);\nvec2 uv=getUV(direction,face);\nuv=fixCubeUVSeams(uv,faceSize);\nuv*=(faceSize-1.0);\nif (face>2.0){\nuv.y+=faceSize;\nface-=3.0;\n}\nuv.x+=face*faceSize;\nif (lodIdx>0.0){\nuv.y+=2.0*cubeUV_maxTileSize;\n}\nuv.y+=filterLevel*2.0*cubeUV_minTileSize;\nuv.x+=3.0*max(0.0,cubeUV_maxTileSize-2.0*faceSize);\nreturn uv;\n}\nvec3 bilinearCubeUV(sampler2D envMap,vec3 direction,float lodIdx){\nfloat texelSize=1.0/(3.0*cubeUV_maxTileSize);\nvec2 uv=getUVPixels(direction,lodIdx);\nvec2 f=fract(uv);\nuv+=0.5-f;\nuv*=texelSize;\nvec3 tl=texture2D(envMap,uv).rgb;\nuv.x+=texelSize;\nvec3 tr=texture2D(envMap,uv).rgb;\nuv.y+=texelSize;\nvec3 br=texture2D(envMap,uv).rgb;\nuv.x-=texelSize;\nvec3 bl=texture2D(envMap,uv).rgb;\nvec3 tm=mix(tl,tr,f.x);\nvec3 bm=mix(bl,br,f.x);\nreturn mix(tm,bm,f.y);\n}\nvec3 sampleCubeUV(sampler2D envMap,vec3 direction,float lodIdx){\nfloat texelSize=1.0/(3.0*cubeUV_maxTileSize);\nvec2 uv=getUVPixels(direction,lodIdx);\nuv+=0.5;\nuv*=texelSize;\nreturn texture2D(envMap,uv).rgb;\n}\nfloat roughnessToMip(float roughness){\nfloat r=roughness;\nfloat r2=r*r;\nfloat r3=r2*r;\nroughness=-1.20278049*r3+1.86860137*r2+0.32478081*r+0.0098139;\nreturn roughness*(cubeUV_lodIdxMax-cubeUV_lodIdxMin);\n}\nvec4 textureCubeUV(sampler2D envMap,vec3 sampleDir,float roughness){\nfloat lodIdx=clamp(roughnessToMip(roughness),cubeUV_lodIdxMin,cubeUV_lodIdxMax);\nfloat lodIdxF=fract(lodIdx);\nfloat lodIdxI=floor(lodIdx);\nvec3 color0=sampleCubeUV(envMap,sampleDir,lodIdxI);\nif (lodIdxF==0.0){\nreturn vec4(color0,1.0);\n} else {\nvec3 color1=sampleCubeUV(envMap,sampleDir,lodIdxI+1.0);\nreturn vec4(mix(color0,color1,lodIdxF),1.0);\n}\n}\n#endif",defaultnormal_vertex="vec3 transformedNormal=objectNormal;\n#ifdef USE_INSTANCING\nmat3 m=mat3(instanceMatrix);\ntransformedNormal/=vec3(dot(m[0],m[0]),dot(m[1],m[1]),dot(m[2],m[2]));\ntransformedNormal=m*transformedNormal;\n#endif\ntransformedNormal=normalMatrix*transformedNormal;\n#ifdef FLIP_SIDED\ntransformedNormal=-transformedNormal;\n#endif\n#ifdef USE_TANGENT\nvec3 transformedTangent=(modelViewMatrix*vec4(objectTangent,0.0)).xyz;\n#ifdef FLIP_SIDED\ntransformedTangent=-transformedTangent;\n#endif\n#endif",displacementmap_pars_vertex="#ifdef USE_DISPLACEMENTMAP\nuniform sampler2D displacementMap;\nuniform float displacementScale;\nuniform float displacementBias;\n#endif",displacementmap_vertex="#ifdef USE_DISPLACEMENTMAP\ntransformed+=normalize(objectNormal)*(texture2D(displacementMap,vUv).x*displacementScale+displacementBias);\n#endif",emissivemap_fragment="#ifdef USE_EMISSIVEMAP\nvec4 emissiveColor=texture2D(emissiveMap,vUv);\ntotalEmissiveRadiance*=emissiveColor.rgb;\n#endif",emissivemap_pars_fragment="#ifdef USE_EMISSIVEMAP\nuniform sampler2D emissiveMap;\n#endif",encodings_fragment="gl_FragColor=linearToOutputTexel(gl_FragColor);",encodings_pars_fragment="vec4 LinearToLinear(in vec4 value){\nreturn value;\n}\nvec4 LinearTosRGB(in vec4 value){\nreturn vec4(mix(pow(value.rgb,vec3(0.41666))*1.055-vec3(0.055),value.rgb*12.92,vec3(lessThanEqual(value.rgb,vec3(0.0031308)))),value.a);\n}",envmap_fragment="#ifdef USE_ENVMAP\n#ifdef ENV_WORLDPOS\nvec3 cameraToFrag;\nif (isOrthographic){\ncameraToFrag=normalize(vec3(-viewMatrix[0][2],-viewMatrix[1][2],-viewMatrix[2][2]));\n} else {\ncameraToFrag=normalize(vWorldPosition-cameraPosition);\n}\nvec3 worldNormal=inverseTransformDirection(normal,viewMatrix);\n#ifdef ENVMAP_MODE_REFLECTION\nvec3 reflectVec=reflect(cameraToFrag,worldNormal);\n#else\nvec3 reflectVec=refract(cameraToFrag,worldNormal,refractionRatio);\n#endif\n#else\nvec3 reflectVec=vReflect;\n#endif\n#ifdef ENVMAP_TYPE_CUBE\nvec4 envColor=textureCube(envMap,vec3(flipEnvMap*reflectVec.x,reflectVec.yz));\n#else\nvec4 envColor=vec4(0.0);\n#endif\n#ifdef ENVMAP_BLENDING_MULTIPLY\noutgoingLight=mix(outgoingLight,outgoingLight*envColor.xyz,reflectivity);\n#elif defined(ENVMAP_BLENDING_MIX)\noutgoingLight=mix(outgoingLight,envColor.xyz,reflectivity);\n#elif defined(ENVMAP_BLENDING_ADD)\noutgoingLight+=envColor.xyz*reflectivity;\n#endif\n#endif",envmap_common_pars_fragment="#ifdef USE_ENVMAP\nuniform float envMapIntensity;\nuniform float flipEnvMap;\n#ifdef ENVMAP_TYPE_CUBE\nuniform samplerCube envMap;\n#else\nuniform sampler2D envMap;\n#endif\n#if defined(ENVMAP_TYPE_CUBE)&&defined(NODE)||defined(ENVMAP_TYPE_CUBE_UV)\nfloat calcGeometryRoughness(vec3 geometryNormal){\nvec3 dxy=max(abs(dFdx(geometryNormal)),abs(dFdy(geometryNormal)));\nreturn max(max(dxy.x,dxy.y),dxy.z);\n}\nfloat calcCubeUVAdjustedRoughness(float origRoughness,float geomRoughness){\nreturn min(max(origRoughness,0.0525)+geomRoughness,1.0);\n}\n#endif\n#endif",envmap_pars_fragment="#ifdef USE_ENVMAP\nuniform float reflectivity;\n#if defined(USE_BUMPMAP)||defined(USE_NORMALMAP)||defined(LAMBERT)\n#define ENV_WORLDPOS\n#endif\n#ifdef ENV_WORLDPOS\nvarying vec3 vWorldPosition;\nuniform float refractionRatio;\n#else\nvarying vec3 vReflect;\n#endif\n#endif",envmap_pars_vertex="#ifdef USE_ENVMAP\n#if defined(USE_BUMPMAP)||defined(USE_NORMALMAP)||defined(LAMBERT)\n#define ENV_WORLDPOS\n#endif\n#ifdef ENV_WORLDPOS\nvarying vec3 vWorldPosition;\n#else\nvarying vec3 vReflect;\nuniform float refractionRatio;\n#endif\n#endif",envmap_vertex="#ifdef USE_ENVMAP\n#ifdef ENV_WORLDPOS\nvWorldPosition=worldPosition.xyz;\n#else\nvec3 cameraToVertex;\nif (isOrthographic){\ncameraToVertex=normalize(vec3(-viewMatrix[0][2],-viewMatrix[1][2],-viewMatrix[2][2]));\n} else {\ncameraToVertex=normalize(worldPosition.xyz-cameraPosition);\n}\nvec3 worldNormal=inverseTransformDirection(transformedNormal,viewMatrix);\n#ifdef ENVMAP_MODE_REFLECTION\nvReflect=reflect(cameraToVertex,worldNormal);\n#else\nvReflect=refract(cameraToVertex,worldNormal,refractionRatio);\n#endif\n#endif\n#endif",fog_vertex="#ifdef USE_FOG\nvFogDepth=-mvPosition.z;\n#endif",fog_pars_vertex="#ifdef USE_FOG\nvarying float vFogDepth;\n#endif",fog_fragment="#ifdef USE_FOG\n#ifdef FOG_EXP2\nfloat fogFactor=1.0-exp(-fogDensity*fogDensity*vFogDepth*vFogDepth);\n#else\nfloat fogFactor=smoothstep(fogNear,fogFar,vFogDepth);\n#endif\ngl_FragColor.rgb=mix(gl_FragColor.rgb,fogColor,fogFactor);\n#endif",fog_pars_fragment="#ifdef USE_FOG\nuniform vec3 fogColor;\nvarying float vFogDepth;\n#ifdef FOG_EXP2\nuniform float fogDensity;\n#else\nuniform float fogNear;\nuniform float fogFar;\n#endif\n#endif",lightmap_fragment="#ifdef USE_LIGHTMAP\nvec4 lightMapTexel=texture2D(lightMap,vUv2);\nvec3 lightMapIrradiance=lightMapTexel.rgb*lightMapIntensity;\nreflectedLight.indirectDiffuse+=lightMapIrradiance;\n#endif",lightmap_pars_fragment="#ifdef USE_LIGHTMAP\nuniform sampler2D lightMap;\nuniform float lightMapIntensity;\n#endif",lights_lambert_fragment="LambertMaterial material;\nmaterial.diffuseColor=diffuseColor.rgb;",lights_lambert_pars_fragment="varying vec3 vViewPosition;\nstruct LambertMaterial {\nvec3 diffuseColor;\n};\nvoid RE_Direct_Lambert(const in IncidentLight directLight,const in GeometricContext geometry,const in LambertMaterial material,inout ReflectedLight reflectedLight){\nfloat dotNL=saturate(dot(geometry.normal,directLight.direction));\nvec3 irradiance=dotNL*directLight.color;\nreflectedLight.directDiffuse+=irradiance*BRDF_Lambert(material.diffuseColor);\n}\nvoid RE_IndirectDiffuse_Lambert(const in vec3 irradiance,const in GeometricContext geometry,const in LambertMaterial material,inout ReflectedLight reflectedLight){\nreflectedLight.indirectDiffuse+=irradiance*BRDF_Lambert(material.diffuseColor);\n}\n#define RE_Direct RE_Direct_Lambert\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Lambert",lights_pars_begin="uniform bool receiveShadow;\nuniform vec3 ambientLightColor;\nuniform vec3 lightProbe[9];\nvec3 shGetIrradianceAt(in vec3 normal,in vec3 shCoefficients[9]){\nfloat x=normal.x,y=normal.y,z=normal.z;\nvec3 result=shCoefficients[0]*0.886227;\nresult+=shCoefficients[1]*2.0*0.511664*y;\nresult+=shCoefficients[2]*2.0*0.511664*z;\nresult+=shCoefficients[3]*2.0*0.511664*x;\nresult+=shCoefficients[4]*2.0*0.429043*x*y;\nresult+=shCoefficients[5]*2.0*0.429043*y*z;\nresult+=shCoefficients[6]*(0.743125*z*z-0.247708);\nresult+=shCoefficients[7]*2.0*0.429043*x*z;\nresult+=shCoefficients[8]*0.429043*(x*x-y*y);\nreturn result;\n}\nvec3 getLightProbeIrradiance(const in vec3 lightProbe[9],const in vec3 normal){\nvec3 worldNormal=inverseTransformDirection(normal,viewMatrix);\nvec3 irradiance=shGetIrradianceAt(worldNormal,lightProbe);\nreturn irradiance;\n}\nvec3 getAmbientLightIrradiance(const in vec3 ambientLightColor){\nvec3 irradiance=ambientLightColor;\nreturn irradiance;\n}\nfloat getDistanceAttenuation(float lightDistance,const in float cutoffDistance,const in float decayExponent){\nlightDistance=UNITS_SCALE_FACTOR*lightDistance;\n#ifdef MT_MAYA\nfloat distanceFalloff=1.0/pow(lightDistance+1.0,decayExponent);\n#else\nfloat distanceFalloff=1.0/max(pow(lightDistance,decayExponent),0.01);\n#endif\nif (cutoffDistance>0.0){\ndistanceFalloff*=pow2(saturate(1.0-pow4(lightDistance/(UNITS_SCALE_FACTOR*cutoffDistance))));\n}\nreturn distanceFalloff;\n}\nfloat getSpotAttenuation(const in float coneCosine,const in float penumbraCosine,const in float angleCosine){\nreturn smoothstep(coneCosine,penumbraCosine,angleCosine);\n}\n#if NUM_DIR_LIGHTS>0\nstruct DirectionalLight {\nvec3 direction;\nvec3 color;\n};\nuniform DirectionalLight directionalLights[NUM_DIR_LIGHTS];\nvoid getDirectionalLightInfo(const in DirectionalLight directionalLight,const in GeometricContext geometry,out IncidentLight light){\nlight.color=directionalLight.color;\nlight.direction=directionalLight.direction;\nlight.visible=true;\n}\n#endif\n#if NUM_POINT_LIGHTS>0\nstruct PointLight {\nvec3 position;\nvec3 color;\nfloat distance;\nfloat decay;\n};\nuniform PointLight pointLights[NUM_POINT_LIGHTS];\nvoid getPointLightInfo(const in PointLight pointLight,const in GeometricContext geometry,out IncidentLight light){\nvec3 lVector=pointLight.position-geometry.position;\nlight.direction=normalize(lVector);\nfloat lightDistance=length(lVector);\nlight.color=pointLight.color;\nlight.color*=getDistanceAttenuation(lightDistance,pointLight.distance,pointLight.decay);\nlight.visible=(light.color != vec3(0.0));\n}\n#endif\n#if NUM_SPOT_LIGHTS>0\nstruct SpotLight {\nvec3 position;\nvec3 direction;\nvec3 color;\nfloat distance;\nfloat decay;\nfloat coneCos;\nfloat penumbraCos;\n};\nuniform SpotLight spotLights[NUM_SPOT_LIGHTS];\nvoid getSpotLightInfo(const in SpotLight spotLight,const in GeometricContext geometry,out IncidentLight light){\nvec3 lVector=spotLight.position-geometry.position;\nlight.direction=normalize(lVector);\nfloat angleCos=dot(light.direction,spotLight.direction);\n#if defined(MT_MAX)\nfloat coneCosDecayed=2.0*spotLight.coneCos-spotLight.penumbraCos;\nif (angleCos>coneCosDecayed){\nfloat spotAttenuation=pow(max(angleCos,0.0),log(0.5)/log(spotLight.penumbraCos)-1.0);\nif (angleCos<spotLight.coneCos){\nfloat decayFac=1.0+(spotLight.coneCos-angleCos)\n/ (spotLight.coneCos-spotLight.penumbraCos);\nspotAttenuation*=pow2(decayFac)*(3.0-2.0*decayFac);\n}\nfloat lightDistance=length(lVector);\nlight.color=spotLight.color*spotAttenuation;\nlight.color*=getDistanceAttenuation(lightDistance,spotLight.distance,spotLight.decay);\nlight.visible=true;\n} else {\nlight.color=vec3(0.0);\nlight.visible=false;\n}\n#else\nfloat spotAttenuation=getSpotAttenuation(spotLight.coneCos,spotLight.penumbraCos,angleCos);\nif (spotAttenuation>0.0){\nfloat lightDistance=length(lVector);\nlight.color=spotLight.color*spotAttenuation;\nlight.color*=getDistanceAttenuation(lightDistance,spotLight.distance,spotLight.decay);\nlight.visible=true;\n} else {\nlight.color=vec3(0.0);\nlight.visible=false;\n}\n#endif\n}\n#endif\n#if NUM_RECT_AREA_LIGHTS>0\nstruct RectAreaLight {\nvec3 color;\nvec3 position;\nvec3 halfWidth;\nvec3 halfHeight;\n};\nuniform sampler2D ltc_1;\nuniform sampler2D ltc_2;\nuniform RectAreaLight rectAreaLights[NUM_RECT_AREA_LIGHTS];\n#endif",envmap_physical_pars_fragment="#if defined(USE_ENVMAP)\n#define ENVMAP_PARALLAX_INFINITE 0\n#define ENVMAP_PARALLAX_SPHERE 1\n#define ENVMAP_PARALLAX_BOX 2\nuniform int envMapParallaxType;\nuniform mat4 envMapParallaxMatrix;\nuniform mat4 envMapParallaxMatrixInv;\nvec3 correctParallax(vec3 directionVecWorld,vec3 posWorld,int parallaxType){\nvec3 posProbe=(envMapParallaxMatrix*vec4(posWorld,1.0)).xyz;\nvec3 reflectVecProbe=transformDirection(directionVecWorld,envMapParallaxMatrix);\nif (parallaxType==ENVMAP_PARALLAX_SPHERE){\nfloat b=2.0*dot(reflectVecProbe,posProbe);\nfloat c=dot(posProbe,posProbe)-1.0;\nfloat D=b*b-4.0*c;\nif (D>=0.0){\nfloat x=(sqrt(D)-b)/2.0;\nreflectVecProbe=posProbe+x*reflectVecProbe;\n}\n} else if (parallaxType==ENVMAP_PARALLAX_BOX){\nvec3 scalePos=(vec3(1.0)-posProbe)/reflectVecProbe;\nvec3 scaleNeg=(vec3(-1.0)-posProbe)/reflectVecProbe;\nvec3 scalePosNeg=mix(scaleNeg,scalePos,step(vec3(0.0),reflectVecProbe));\nfloat x=min(scalePosNeg.x,min(scalePosNeg.y,scalePosNeg.z));\nreflectVecProbe=posProbe+x*reflectVecProbe;\n}\nvec3 directionVecWorldCorrected=transformDirection(reflectVecProbe,envMapParallaxMatrixInv);\nreturn directionVecWorldCorrected;\n}\nvec3 getIBLIrradiance(const in vec3 normal){\n#if defined(ENVMAP_TYPE_CUBE_UV)\nvec3 worldNormal=inverseTransformDirection(normal,viewMatrix);\nvec4 envMapColor=textureCubeUV(envMap,worldNormal,1.0);\nreturn PI*envMapColor.rgb*envMapIntensity;\n#else\nreturn vec3(0.0);\n#endif\n}\nvec3 getIBLRadiance(const in vec3 viewDir,const in vec3 normal,const in float roughness,vec3 position){\n#if defined(ENVMAP_TYPE_CUBE_UV)\nvec3 reflectVec=reflect(-viewDir,normal);\nreflectVec=inverseTransformDirection(reflectVec,viewMatrix);\nif (envMapParallaxType != ENVMAP_PARALLAX_INFINITE){\nvec3 posWorld=(invViewMatrix*vec4(position,1.0)).xyz;\nreflectVec=correctParallax(reflectVec,posWorld,envMapParallaxType);\n}\nvec4 envMapColor=textureCubeUV(envMap,reflectVec,roughness);\nreturn envMapColor.rgb*envMapIntensity;\n#else\nreturn vec3(0.0);\n#endif\n}\nvec3 getIBLRefraction(const in vec3 viewDir,const in vec3 normal,const in float roughness,const float refrRatio,vec3 position){\n#if defined(ENVMAP_TYPE_CUBE_UV)\nvec3 refractVec=refract(-viewDir,normal,refrRatio);\nrefractVec=inverseTransformDirection(refractVec,viewMatrix);\nif (envMapParallaxType != ENVMAP_PARALLAX_INFINITE){\nvec3 posWorld=(invViewMatrix*vec4(position,1.0)).xyz;\nrefractVec=correctParallax(refractVec,posWorld,envMapParallaxType);\n}\nvec4 envMapColor=textureCubeUV(envMap,refractVec,roughness);\nreturn envMapColor.rgb*envMapIntensity;\n#else\nreturn vec3(0.0);\n#endif\n}\n#endif",lights_physical_fragment="PhysicalMaterial material;\nmaterial.diffuseColor=diffuseColor.rgb*(1.0-metalnessFactor);\nvec3 dxy=max(abs(dFdx(geometryNormal)),abs(dFdy(geometryNormal)));\nfloat geometryRoughness=max(max(dxy.x,dxy.y),dxy.z);\nmaterial.roughness=max(roughnessFactor,0.0525);\nmaterial.roughness+=geometryRoughness;\nmaterial.roughness=min(material.roughness,1.0);\nmaterial.specularColor=mix(vec3(0.04),diffuseColor.rgb,metalnessFactor);\nmaterial.specularF90=1.0;",lights_physical_pars_fragment="struct PhysicalMaterial {\nvec3 diffuseColor;\nfloat roughness;\nvec3 specularColor;\nfloat specularF90;\n};\nvec2 DFGApprox(const in vec3 normal,const in vec3 viewDir,const in float roughness){\nfloat dotNV=saturate(dot(normal,viewDir));\nconst vec4 c0=vec4(- 1,-0.0275,-0.572,0.022);\nconst vec4 c1=vec4(1,0.0425,1.04,-0.04);\nvec4 r=roughness*c0+c1;\nfloat a004=min(r.x*r.x,exp2(- 9.28*dotNV))*r.x+r.y;\nvec2 fab=vec2(- 1.04,1.04)*a004+r.zw;\nreturn fab;\n}\nvec3 EnvironmentBRDF(const in vec3 normal,const in vec3 viewDir,const in vec3 specularColor,const in float specularF90,const in float roughness){\nvec2 fab=DFGApprox(normal,viewDir,roughness);\nreturn specularColor*fab.x+specularF90*fab.y;\n}\nvoid computeMultiscattering(const in vec3 normal,const in vec3 viewDir,const in vec3 specularColor,const in float specularF90,const in float roughness,inout vec3 singleScatter,inout vec3 multiScatter){\nvec2 fab=DFGApprox(normal,viewDir,roughness);\nvec3 Fr=specularColor;\nvec3 FssEss=Fr*fab.x+specularF90*fab.y;\nfloat Ess=fab.x+fab.y;\nfloat Ems=1.0-Ess;\nvec3 Favg=Fr+(1.0-Fr)*0.047619;\nvec3 Fms=FssEss*Favg/(1.0-Ems*Favg);\nsingleScatter+=FssEss;\nmultiScatter+=Fms*Ems;\n}\n#if NUM_RECT_AREA_LIGHTS>0\nvoid RE_Direct_RectArea_Physical(const in RectAreaLight rectAreaLight,const in GeometricContext geometry,const in PhysicalMaterial material,inout ReflectedLight reflectedLight){\nvec3 normal=geometry.normal;\nvec3 viewDir=geometry.viewDir;\nvec3 position=geometry.position;\nvec3 lightPos=rectAreaLight.position;\nvec3 halfWidth=rectAreaLight.halfWidth;\nvec3 halfHeight=rectAreaLight.halfHeight;\nvec3 lightColor=rectAreaLight.color;\nfloat roughness=material.roughness;\nvec3 rectCoords[4];\nrectCoords[0]=lightPos+halfWidth-halfHeight;\nrectCoords[1]=lightPos-halfWidth-halfHeight;\nrectCoords[2]=lightPos-halfWidth+halfHeight;\nrectCoords[3]=lightPos+halfWidth+halfHeight;\nvec2 uv=LTC_Uv(normal,viewDir,roughness);\nvec4 t1=texture2D(ltc_1,uv);\nvec4 t2=texture2D(ltc_2,uv);\nmat3 mInv=mat3(vec3(t1.x,0,t1.y),vec3( 0,1,0),vec3(t1.z,0,t1.w)\n);\nvec3 fresnel=(material.specularColor*t2.x+(vec3(1.0)-material.specularColor)*t2.y);\nreflectedLight.directSpecular+=lightColor*fresnel*LTC_Evaluate(normal,viewDir,position,mInv,rectCoords);\nreflectedLight.directDiffuse+=lightColor*material.diffuseColor*LTC_Evaluate(normal,viewDir,position,mat3(1.0),rectCoords);\n}\n#endif\nvoid RE_Direct_Physical(const in IncidentLight directLight,const in GeometricContext geometry,const in PhysicalMaterial material,inout ReflectedLight reflectedLight){\nfloat dotNL=saturate(dot(geometry.normal,directLight.direction));\nvec3 irradiance=dotNL*directLight.color;\nreflectedLight.directSpecular+=irradiance*BRDF_GGX(directLight.direction,geometry.viewDir,geometry.normal,material.specularColor,material.specularF90,material.roughness);\nreflectedLight.directDiffuse+=irradiance*BRDF_Lambert(material.diffuseColor);\n}\nvoid RE_IndirectDiffuse_Physical(const in vec3 irradiance,const in GeometricContext geometry,const in PhysicalMaterial material,inout ReflectedLight reflectedLight){\nreflectedLight.indirectDiffuse+=irradiance*BRDF_Lambert(material.diffuseColor);\n}\nvoid RE_IndirectSpecular_Physical(const in vec3 radiance,const in vec3 irradiance,const in vec3 clearcoatRadiance,const in GeometricContext geometry,const in PhysicalMaterial material,inout ReflectedLight reflectedLight){\nvec3 singleScattering=vec3(0.0);\nvec3 multiScattering=vec3(0.0);\nvec3 cosineWeightedIrradiance=irradiance*RECIPROCAL_PI;\ncomputeMultiscattering(geometry.normal,geometry.viewDir,material.specularColor,material.specularF90,material.roughness,singleScattering,multiScattering);\nvec3 totalScattering=singleScattering+multiScattering;\nvec3 diffuse=material.diffuseColor*(1.0-max(max(totalScattering.r,totalScattering.g),totalScattering.b));\nreflectedLight.indirectSpecular+=radiance*singleScattering;\nreflectedLight.indirectSpecular+=multiScattering*cosineWeightedIrradiance;\nreflectedLight.indirectDiffuse+=diffuse*cosineWeightedIrradiance;\n}\n#define RE_Direct RE_Direct_Physical\n#define RE_Direct_RectArea RE_Direct_RectArea_Physical\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Physical\n#define RE_IndirectSpecular RE_IndirectSpecular_Physical\nfloat computeSpecularOcclusion(const in float dotNV,const in float ambientOcclusion,const in float roughness){\nreturn saturate(pow(abs(dotNV+ambientOcclusion),exp2(- 16.0*roughness-1.0))-1.0+ambientOcclusion);\n}",lights_fragment_begin="\nGeometricContext geometry;\ngeometry.position=-vViewPosition;\ngeometry.normal=normal;\ngeometry.viewDir=(isOrthographic)?vec3(0,0,1):normalize(vViewPosition);\n#ifdef USE_CLEARCOAT\ngeometry.clearcoatNormal=clearcoatNormal;\n#endif\n#ifdef PROBE_NORMAL\ngeometry.probeNormal=PROBE_NORMAL;\n#else\ngeometry.probeNormal=normal;\n#endif\nIncidentLight directLight;\n#if (NUM_POINT_LIGHTS>0)&&defined(RE_Direct)\nPointLight pointLight;\n#if defined(USE_SHADOWMAP)&&NUM_POINT_LIGHT_SHADOWS>0\nPointLightShadow pointLightShadow;\n#endif\n#pragma unroll_loop\nfor (int i=0;i<NUM_POINT_LIGHTS;i++){\npointLight=pointLights[i];\ngetPointLightInfo(pointLight,geometry,directLight);\n#if defined(USE_SHADOWMAP)&&((i)<NUM_POINT_LIGHT_SHADOWS)\npointLightShadow=pointLightShadows[i];\ndirectLight.color*=(directLight.visible&&receiveShadow)?getPointShadow(pointLightShadow,pointShadowMap[i],vPointShadowCoord[i]):1.0;\n#endif\nRE_Direct(directLight,geometry,material,reflectedLight);\n}\n#endif\n#if (NUM_SPOT_LIGHTS>0)&&defined(RE_Direct)\nSpotLight spotLight;\n#if defined(USE_SHADOWMAP)&&NUM_SPOT_LIGHT_SHADOWS>0\nSpotLightShadow spotLightShadow;\n#endif\n#pragma unroll_loop\nfor (int i=0;i<NUM_SPOT_LIGHTS;i++){\nspotLight=spotLights[i];\ngetSpotLightInfo(spotLight,geometry,directLight);\n#if defined(USE_SHADOWMAP)&&((i)<NUM_SPOT_LIGHT_SHADOWS)\nspotLightShadow=spotLightShadows[i];\nif (directLight.visible&&receiveShadow){\nif (spotLightShadow.shadow==1){\nfloat distWorld=0.0;\n#if defined(SHADOWMAP_TYPE_ESM)\ndistWorld=length((invViewMatrix*vec4(spotLight.position\n- geometry.position,0.0)).xyz);\n#endif\ndirectLight.color*=getSpotShadow(spotLightShadow,spotShadowMap[i],vSpotShadowCoord[i],distWorld);\n} else if (spotLightShadow.shadow==2){\ndirectLight.color*=getSpotOmniShadow(spotLightShadow,spotShadowMap[i],vSpotShadowCoord[i]);\n}\n}\n#endif\nRE_Direct(directLight,geometry,material,reflectedLight);\n}\n#endif\n#if (NUM_DIR_LIGHTS>0)&&defined(RE_Direct)\nDirectionalLight directionalLight;\n#if defined(USE_SHADOWMAP)&&NUM_DIR_LIGHT_SHADOWS_CSM>0\nDirectionalLightShadowCSM directionalLightShadowCSM;\nDirectionalLightShadowCascade dirShadowCascade;\nvec2 cascade;\nfloat cascadeCenter;\nfloat closestEdge;\nfloat margin;\nfloat csmx,csmy;\nfloat linearDepth;\nint maxCascadeIdx;\n#pragma unroll_loop\nfor (int i=0;i<NUM_DIR_LIGHT_SHADOW_CASCADES_CSM;i++){\ndirShadowCascade=directionalLightShadowsCSMCascade[i];\n#if defined(LUT_DIR_LIGHT_SHADOWS_CSM)\ndirectionalLightShadowCSM=directionalLightShadowsCSM[LUT_DIR_LIGHT_SHADOWS_CSM[i]];\ndirectionalLight=directionalLights[LUT_DIR_LIGHT_SHADOWS_CSM[i]];\ngetDirectionalLightInfo(directionalLight,geometry,directLight);\n#else\nif (dirShadowCascade.csmIdx==0){\ndirectionalLightShadowCSM=directionalLightShadowsCSM[0];\ndirectionalLight=directionalLights[0];\ngetDirectionalLightInfo(directionalLight,geometry,directLight);\n}\n#if NUM_DIR_LIGHT_SHADOWS_CSM>=2\nelse if (dirShadowCascade.csmIdx==1){\ndirectionalLightShadowCSM=directionalLightShadowsCSM[1];\ndirectionalLight=directionalLights[1];\ngetDirectionalLightInfo(directionalLight,geometry,directLight);\n}\n#endif\n#if NUM_DIR_LIGHT_SHADOWS_CSM>=3\nelse if (dirShadowCascade.csmIdx==2){\ndirectionalLightShadowCSM=directionalLightShadowsCSM[2];\ndirectionalLight=directionalLights[2];\ngetDirectionalLightInfo(directionalLight,geometry,directLight);\n}\n#endif\n#if NUM_DIR_LIGHT_SHADOWS_CSM>=4\nelse if (dirShadowCascade.csmIdx==3){\ndirectionalLightShadowCSM=directionalLightShadowsCSM[3];\ndirectionalLight=directionalLights[3];\ngetDirectionalLightInfo(directionalLight,geometry,directLight);\n}\n#endif\n#if NUM_DIR_LIGHT_SHADOWS_CSM>=5\nelse if (dirShadowCascade.csmIdx==4){\ndirectionalLightShadowCSM=directionalLightShadowsCSM[4];\ndirectionalLight=directionalLights[4];\ngetDirectionalLightInfo(directionalLight,geometry,directLight);\n}\n#endif\n#endif\nmaxCascadeIdx=directionalLightShadowCSM.cascadeIdxEnd;\nlinearDepth=(vViewPosition.z)/(directionalLightShadowCSM.shadowFar-directionalLightShadowCSM.cameraNear);\ncascade=dirShadowCascade.cascade;\n#if (i)<NUM_DIR_LIGHT_SHADOWS_CSM_WITH_FADE\ncascadeCenter=(cascade.x+cascade.y)/2.0;\nclosestEdge=linearDepth<cascadeCenter?cascade.x:cascade.y;\nmargin=directionalLightShadowCSM.fade*pow(closestEdge,2.0);\ncsmx=cascade.x-margin/2.0;\ncsmy=cascade.y+margin/2.0;\nif (linearDepth>=csmx&&(linearDepth<csmy||(i)==maxCascadeIdx-1)){\nfloat dist=min(linearDepth-csmx,csmy-linearDepth);\nfloat ratio=clamp(dist/margin,0.0,1.0);\nvec3 prevColor=directLight.color;\nfloat distWorld=0.0;\n#if defined(SHADOWMAP_TYPE_ESM)\ndistWorld=length((invViewMatrix*vec4(dirShadowCascade.position\n- directionalLight.direction*dirShadowCascade.shadowCameraNear\n- geometry.position,0.0)).xyz);\n#endif\ndirectLight.color*=(directLight.visible&&receiveShadow)?\ngetDirShadowCSM(dirShadowCascade,directionalShadowCSMMap[i],vDirectionalShadowCSMCoord[i],distWorld)\n: 1.0;\nbool shouldFadeLastCascade=(i)==maxCascadeIdx-1&&linearDepth>cascadeCenter;\ndirectLight.color=mix(prevColor,directLight.color,shouldFadeLastCascade?ratio:1.0);\nReflectedLight prevLight=reflectedLight;\nRE_Direct(directLight,geometry,material,reflectedLight);\nbool shouldBlend=(i)!= maxCascadeIdx-1||((i)==maxCascadeIdx-1&&linearDepth<cascadeCenter);\nfloat blendRatio=shouldBlend?ratio:1.0;\nreflectedLight.directDiffuse=mix(prevLight.directDiffuse,reflectedLight.directDiffuse,blendRatio);\nreflectedLight.directSpecular=mix(prevLight.directSpecular,reflectedLight.directSpecular,blendRatio);\nreflectedLight.indirectDiffuse=mix(prevLight.indirectDiffuse,reflectedLight.indirectDiffuse,blendRatio);\nreflectedLight.indirectSpecular=mix(prevLight.indirectSpecular,reflectedLight.indirectSpecular,blendRatio);\n}\n#else\nif (linearDepth>=cascade.x&&(linearDepth<cascade.y||(i)==maxCascadeIdx-1)){\nif (directLight.visible&&receiveShadow){\nfloat distWorld=0.0;\n#if defined(SHADOWMAP_TYPE_ESM)\ndistWorld=length((invViewMatrix*vec4(dirShadowCascade.position\n- directionalLight.direction*dirShadowCascade.shadowCameraNear\n- geometry.position,0.0)).xyz);\n#endif\ndirectLight.color*=getDirShadowCSM(dirShadowCascade,directionalShadowCSMMap[i],vDirectionalShadowCSMCoord[i],distWorld);\n}\nRE_Direct(directLight,geometry,material,reflectedLight);\n}\n#endif\n}\n#endif\n#pragma unroll_loop\nfor (int i=NUM_DIR_LIGHT_SHADOWS_CSM;i<NUM_DIR_LIGHTS;i++){\ndirectionalLight=directionalLights[i];\ngetDirectionalLightInfo(directionalLight,geometry,directLight);\nRE_Direct(directLight,geometry,material,reflectedLight);\n}\n#endif\n#if (NUM_RECT_AREA_LIGHTS>0)&&defined(RE_Direct_RectArea)\nRectAreaLight rectAreaLight;\n#if defined(USE_SHADOWMAP)&&NUM_RECT_AREA_LIGHT_SHADOWS>0\nRectAreaLightShadow rectAreaLightShadow;\n#endif\n#pragma unroll_loop\nfor (int i=0;i<NUM_RECT_AREA_LIGHTS;i++){\nrectAreaLight=rectAreaLights[i];\n#if defined(USE_SHADOWMAP)&&((i)<NUM_RECT_AREA_LIGHT_SHADOWS)\nrectAreaLightShadow=rectAreaLightShadows[i];\nrectAreaLight.color*=receiveShadow ?\ngetRectAreaShadow(rectAreaLightShadow,rectAreaShadowMap[i],vRectAreaShadowCoord[i]):1.0;\n#endif\nRE_Direct_RectArea(rectAreaLight,geometry,material,reflectedLight);\n}\n#endif\n#if defined(RE_IndirectDiffuse)\nvec3 iblIrradiance=vec3(0.0);\nvec3 irradiance=getAmbientLightIrradiance(ambientLightColor);\nirradiance+=getLightProbeIrradiance(lightProbe,geometry.probeNormal);\n#endif\n#if defined(RE_IndirectSpecular)\nvec3 radiance=vec3(0.0);\nvec3 clearcoatRadiance=vec3(0.0);\n#endif\n#if defined(RE_Refraction)\nvec3 refraction=vec3(0.0);\n#endif",lights_fragment_maps="#if defined(RE_IndirectDiffuse)\n#ifdef USE_LIGHTMAP\nvec4 lightMapTexel=texture2D(lightMap,vUv2);\nvec3 lightMapIrradiance=lightMapTexel.rgb*lightMapIntensity;\nirradiance+=lightMapIrradiance;\n#endif\n#if defined(USE_ENVMAP)&&(defined(STANDARD)||defined(NODE))&&defined(ENVMAP_TYPE_CUBE_UV)\niblIrradiance+=getIBLIrradiance(geometry.probeNormal);\n#endif\n#endif\n#if defined(USE_ENVMAP)&&defined(RE_IndirectSpecular)\nradiance+=getIBLRadiance(geometry.viewDir,geometry.normal,material.roughness,geometry.position);\n#if defined(USE_SSR)&&!defined(USE_SSR_REFRACT)\nradiance=computeSSR(radiance,geometry.normal,0.0);\n#endif\n#if defined(USE_PLANE_REFLECTION)\nradiance=computePlaneReflection(radiance,material.roughness,geometry.position,geometry.normal,modelMatrix);\n#endif\n#ifdef USE_CLEARCOAT\nclearcoatRadiance+=getIBLRadiance(geometry.viewDir,geometry.clearcoatNormal,material.clearcoatRoughness,geometry.position);\n#endif\n#endif\n#if defined(USE_ENVMAP)&&defined(RE_Refraction)\nrefraction+=getIBLRefraction(geometry.viewDir,geometry.normal,material.refractionRoughness,1.0/material.refractionIOR,geometry.position);\n#ifdef USE_SSR_REFRACT\nrefraction=computeSSR(refraction,geometry.normal,material.refractionIOR);\n#endif\n#endif",lights_fragment_end="#if defined(RE_IndirectDiffuse)\n#ifdef NODE\nirradiance+=iblIrradiance;\n#endif\nRE_IndirectDiffuse(irradiance,geometry,material,reflectedLight);\n#endif\n#if defined(RE_IndirectSpecular)\nRE_IndirectSpecular(radiance,iblIrradiance,clearcoatRadiance,geometry,material,reflectedLight);\n#endif\n#if defined(RE_Refraction)\nRE_Refraction(refraction,material,refractedLight);\n#endif",logdepthbuf_fragment="#if defined(USE_LOGDEPTHBUF)&&defined(USE_LOGDEPTHBUF_EXT)\ngl_FragDepthEXT=vIsPerspective==0.0?gl_FragCoord.z:log2(vFragDepth)*logDepthBufFC*0.5;\n#endif",logdepthbuf_pars_fragment="#if defined(USE_LOGDEPTHBUF)&&defined(USE_LOGDEPTHBUF_EXT)\nuniform float logDepthBufFC;\nvarying float vFragDepth;\nvarying float vIsPerspective;\n#endif",logdepthbuf_pars_vertex="#ifdef USE_LOGDEPTHBUF\n#ifdef USE_LOGDEPTHBUF_EXT\nvarying float vFragDepth;\nvarying float vIsPerspective;\n#else\nuniform float logDepthBufFC;\n#endif\n#endif",logdepthbuf_vertex="#ifdef USE_LOGDEPTHBUF\n#ifdef USE_LOGDEPTHBUF_EXT\nvFragDepth=1.0+gl_Position.w;\nvIsPerspective=float(isPerspectiveMatrix(projectionMatrix));\n#else\nif (isPerspectiveMatrix(projectionMatrix)){\ngl_Position.z=log2(max(EPSILON,gl_Position.w+1.0))*logDepthBufFC-1.0;\ngl_Position.z*=gl_Position.w;\n}\n#endif\n#endif",map_fragment="#ifdef USE_MAP\nvec4 sampledDiffuseColor=texture2D(map,vUv);\n#ifdef DECODE_VIDEO_TEXTURE\nsampledDiffuseColor=vec4(mix(pow(sampledDiffuseColor.rgb*0.9478672986+vec3(0.0521327014),vec3(2.4)),sampledDiffuseColor.rgb*0.0773993808,vec3(lessThanEqual(sampledDiffuseColor.rgb,vec3(0.04045)))),sampledDiffuseColor.w);\n#endif\ndiffuseColor*=sampledDiffuseColor;\n#endif",map_pars_fragment="#ifdef USE_MAP\nuniform sampler2D map;\n#endif",map_particle_fragment="#if defined(USE_MAP)||defined(USE_ALPHAMAP)\nvec2 uv=(uvTransform*vec3(gl_PointCoord.x,1.0-gl_PointCoord.y,1)).xy;\n#endif\n#ifdef USE_MAP\ndiffuseColor*=texture2D(map,uv);\n#endif\n#ifdef USE_ALPHAMAP\ndiffuseColor.a*=texture2D(alphaMap,uv).g;\n#endif",map_particle_pars_fragment="#if defined(USE_MAP)||defined(USE_ALPHAMAP)\nuniform mat3 uvTransform;\n#endif\n#ifdef USE_MAP\nuniform sampler2D map;\n#endif\n#ifdef USE_ALPHAMAP\nuniform sampler2D alphaMap;\n#endif",metalnessmap_fragment="float metalnessFactor=metalness;\n#ifdef USE_METALNESSMAP\nvec4 texelMetalness=texture2D(metalnessMap,vUv);\nmetalnessFactor*=texelMetalness.b;\n#endif",metalnessmap_pars_fragment="#ifdef USE_METALNESSMAP\nuniform sampler2D metalnessMap;\n#endif",morphnormal_vertex="#ifdef USE_MORPHNORMALS\nobjectNormal*=morphTargetBaseInfluence;\n#ifdef MORPHTARGETS_TEXTURE\nfor (int i=0;i<MORPHTARGETS_COUNT;i++){\nif (morphTargetInfluences[i] != 0.0)objectNormal+=getMorph(gl_VertexID,i,1).xyz*morphTargetInfluences[i];\n}\n#else\n#if MORPHTARGETS_COUNT>0\nobjectNormal+=morphNormal0*morphTargetInfluences[0];\n#endif\n#if MORPHTARGETS_COUNT>1\nobjectNormal+=morphNormal1*morphTargetInfluences[1];\n#endif\n#if MORPHTARGETS_COUNT>2\nobjectNormal+=morphNormal2*morphTargetInfluences[2];\n#endif\n#if MORPHTARGETS_COUNT>3\nobjectNormal+=morphNormal3*morphTargetInfluences[3];\n#endif\n#if MORPHTARGETS_COUNT>4\nobjectNormal+=morphNormal4*morphTargetInfluences[4];\n#endif\n#if MORPHTARGETS_COUNT>5\nobjectNormal+=morphNormal5*morphTargetInfluences[5];\n#endif\n#endif\n#endif",morphtarget_pars_vertex="#ifdef USE_MORPHTARGETS\nuniform float morphTargetBaseInfluence;\n#ifdef MORPHTARGETS_TEXTURE\nuniform float morphTargetInfluences[MORPHTARGETS_COUNT];\nuniform sampler2DArray morphTargetsTexture;\nuniform ivec2 morphTargetsTextureSize;\nvec4 getMorph(const in int vertexIndex,const in int morphTargetIndex,const in int offset){\nint texelIndex=vertexIndex*MORPHTARGETS_TEXTURE_STRIDE+offset;\nint y=texelIndex/morphTargetsTextureSize.x;\nint x=texelIndex-y*morphTargetsTextureSize.x;\nivec3 morphUV=ivec3(x,y,morphTargetIndex);\nreturn texelFetch(morphTargetsTexture,morphUV,0);\n}\n#else\n#ifndef USE_MORPHNORMALS\nuniform float morphTargetInfluences[12];\n#else\nuniform float morphTargetInfluences[6];\n#endif\n#endif\n#endif",morphtarget_vertex="#ifdef USE_MORPHTARGETS\ntransformed*=morphTargetBaseInfluence;\n#ifdef MORPHTARGETS_TEXTURE\nfor (int i=0;i<MORPHTARGETS_COUNT;i++){\nif (morphTargetInfluences[i] != 0.0)transformed+=getMorph(gl_VertexID,i,0).xyz*morphTargetInfluences[i];\n}\n#else\n#if MORPHTARGETS_COUNT>0\ntransformed+=morphTarget0*morphTargetInfluences[0];\n#endif\n#if MORPHTARGETS_COUNT>1\ntransformed+=morphTarget1*morphTargetInfluences[1];\n#endif\n#if MORPHTARGETS_COUNT>2\ntransformed+=morphTarget2*morphTargetInfluences[2];\n#endif\n#if MORPHTARGETS_COUNT>3\ntransformed+=morphTarget3*morphTargetInfluences[3];\n#endif\n#if MORPHTARGETS_COUNT>4\ntransformed+=morphTarget4*morphTargetInfluences[4];\n#endif\n#if MORPHTARGETS_COUNT>5\ntransformed+=morphTarget5*morphTargetInfluences[5];\n#endif\n#ifndef USE_MORPHNORMALS\n#if MORPHTARGETS_COUNT>6\ntransformed+=morphTarget6*morphTargetInfluences[6];\n#endif\n#if MORPHTARGETS_COUNT>7\ntransformed+=morphTarget7*morphTargetInfluences[7];\n#endif\n#if MORPHTARGETS_COUNT>8\ntransformed+=morphTarget8*morphTargetInfluences[8];\n#endif\n#if MORPHTARGETS_COUNT>9\ntransformed+=morphTarget9*morphTargetInfluences[9];\n#endif\n#if MORPHTARGETS_COUNT>10\ntransformed+=morphTarget10*morphTargetInfluences[10];\n#endif\n#if MORPHTARGETS_COUNT>11\ntransformed+=morphTarget1*morphTargetInfluences[11];\n#endif\n#endif\n#endif\n#endif",normal_fragment_begin="float faceDirection=gl_FrontFacing?1.0:-1.0;\n#ifdef FLAT_SHADED\nvec3 fdx=dFdx(vViewPosition);\nvec3 fdy=dFdy(vViewPosition);\nvec3 normal=normalize(cross(fdx,fdy));\n#else\nvec3 normal=normalize(vNormal);\n#ifdef DOUBLE_SIDED\nnormal=normal*faceDirection;\n#endif\n#ifdef USE_TANGENT\nvec3 tangent=normalize(vTangent);\nvec3 bitangent=normalize(vBitangent);\n#ifdef DOUBLE_SIDED\ntangent=tangent*faceDirection;\nbitangent=bitangent*faceDirection;\n#endif\n#if defined(TANGENTSPACE_NORMALMAP)\nmat3 vTBN=mat3(tangent,bitangent,normal);\n#endif\n#endif\n#endif\nvec3 geometryNormal=normal;",normal_fragment_maps="#ifdef OBJECTSPACE_NORMALMAP\nnormal=texture2D(normalMap,vUv).xyz*2.0-1.0;\n#ifdef FLIP_SIDED\nnormal=-normal;\n#endif\n#ifdef DOUBLE_SIDED\nnormal=normal*faceDirection;\n#endif\nnormal=normalize(normalMatrix*normal);\n#elif defined(TANGENTSPACE_NORMALMAP)\nvec3 mapN=texture2D(normalMap,vUv).xyz*2.0-1.0;\nmapN.xy*=normalScale;\n#ifdef USE_TANGENT\nnormal=normalize(vTBN*mapN);\n#else\nnormal=perturbNormal2Arb(-vViewPosition,normal,mapN,faceDirection);\n#endif\n#elif defined(USE_BUMPMAP)\nnormal=perturbNormalArb(-vViewPosition,normal,dHdxy_fwd(),faceDirection);\n#endif",normal_pars_fragment="#ifndef FLAT_SHADED\nvarying vec3 vNormal;\n#ifdef USE_TANGENT\nvarying vec3 vTangent;\nvarying vec3 vBitangent;\n#endif\n#endif",normal_pars_vertex="#ifndef FLAT_SHADED\nvarying vec3 vNormal;\n#ifdef USE_TANGENT\nvarying vec3 vTangent;\nvarying vec3 vBitangent;\n#endif\n#endif",normal_vertex="#ifndef FLAT_SHADED\nvNormal=normalize(transformedNormal);\n#ifdef USE_TANGENT\nvTangent=normalize(transformedTangent);\nvBitangent=normalize(cross(vNormal,vTangent)*tangent.w);\n#endif\n#endif",normalmap_pars_fragment="#ifdef USE_NORMALMAP\nuniform sampler2D normalMap;\nuniform vec2 normalScale;\n#endif\n#ifdef OBJECTSPACE_NORMALMAP\nuniform mat3 normalMatrix;\n#endif\n#if !defined (USE_TANGENT)&&defined (TANGENTSPACE_NORMALMAP)\nvec3 perturbNormal2Arb(vec3 eye_pos,vec3 surf_norm,vec3 mapN,float faceDirection){\nvec3 q0=dFdx(eye_pos.xyz);\nvec3 q1=dFdy(eye_pos.xyz);\nvec2 st0=dFdx(vUv.st);\nvec2 st1=dFdy(vUv.st);\nvec3 N=surf_norm;\nvec3 q1perp=cross(q1,N);\nvec3 q0perp=cross(N,q0);\nvec3 T=q1perp*st0.x+q0perp*st1.x;\nvec3 B=q1perp*st0.y+q0perp*st1.y;\nfloat det=max(dot(T,T),dot(B,B));\nfloat scale=(det==0.0)?0.0:faceDirection*inversesqrt(det);\nreturn normalize(T*(mapN.x*scale)+B*(mapN.y*scale)+N*mapN.z);\n}\n#endif",output_fragment="#ifdef OPAQUE\ndiffuseColor.a=1.0;\n#endif\ngl_FragColor=vec4(outgoingLight,diffuseColor.a);",packing="vec3 packNormalToRGB(const in vec3 normal){\nreturn normalize(normal)*0.5+0.5;\n}\nvec3 unpackRGBToNormal(const in vec3 rgb){\nreturn 2.0*rgb.xyz-1.0;\n}\nconst float PackUpscale=256./255.;\nconst float UnpackDownscale=255./256.;\nconst vec3 PackFactors=vec3(256.*256.*256.,256.*256.,256.);\nconst vec4 UnpackFactors=UnpackDownscale/vec4(PackFactors,1.);\nconst float ShiftRight8=1./256.;\nvec4 packDepthToRGBA(const in float v){\nvec4 r=vec4(fract(v*PackFactors),v);\nr.yzw-=r.xyz*ShiftRight8;\nreturn r*PackUpscale;\n}\nfloat unpackRGBAToDepth(const in vec4 v){\nreturn dot(v,UnpackFactors);\n}\nvec2 packDepthToRG(in highp float v){\nreturn packDepthToRGBA(v).yx;\n}\nfloat unpackRGToDepth(const in highp vec2 v){\nreturn unpackRGBAToDepth(vec4(v.xy,0.0,0.0));\n}\nvec4 pack2HalfToRGBA(vec2 v){\nvec4 r=vec4(v.x,fract(v.x*255.0),v.y,fract(v.y*255.0));\nreturn vec4(r.x-r.y/255.0,r.y,r.z-r.w/255.0,r.w);\n}\nvec2 unpackRGBATo2Half(vec4 v){\nreturn vec2(v.x+(v.y/255.0),v.z+(v.w/255.0));\n}\nfloat viewZToOrthographicDepth(const in float viewZ,const in float near,const in float far){\nreturn (viewZ+near)/(near-far);\n}\nfloat orthographicDepthToViewZ(const in float linearClipZ,const in float near,const in float far){\nreturn linearClipZ*(near-far)-near;\n}\nfloat viewZToPerspectiveDepth(const in float viewZ,const in float near,const in float far){\nreturn ((near+viewZ)*far)/((far-near)*viewZ);\n}\nfloat perspectiveDepthToViewZ(const in float invClipZ,const in float near,const in float far){\nreturn (near*far)/((far-near)*invClipZ-far);\n}",premultiplied_alpha_fragment="#ifdef PREMULTIPLIED_ALPHA\ngl_FragColor.rgb*=gl_FragColor.a;\n#endif",project_vertex="vec4 mvPosition=vec4(transformed,1.0);\n#ifdef USE_INSTANCING\nmvPosition=instanceMatrix*mvPosition;\n#endif\nmvPosition=modelViewMatrix*mvPosition;\ngl_Position=projectionMatrix*mvPosition;\n#if defined(BACKGROUND_DEPTH)\ngl_Position.z=gl_Position.w;\n#endif",dithering_fragment="#ifdef DITHERING\ngl_FragColor.rgb=dithering(gl_FragColor.rgb);\n#endif",dithering_pars_fragment="#ifdef DITHERING\nvec3 dithering(vec3 color){\nfloat grid_position=rand(gl_FragCoord.xy);\nvec3 dither_shift_RGB=vec3(0.25/255.0,-0.25/255.0,0.25/255.0);\ndither_shift_RGB=mix(2.0*dither_shift_RGB,-2.0*dither_shift_RGB,grid_position);\nreturn color+dither_shift_RGB;\n}\n#endif",roughnessmap_fragment="float roughnessFactor=roughness;\n#ifdef USE_ROUGHNESSMAP\nvec4 texelRoughness=texture2D(roughnessMap,vUv);\nroughnessFactor*=texelRoughness.g;\n#endif",roughnessmap_pars_fragment="#ifdef USE_ROUGHNESSMAP\nuniform sampler2D roughnessMap;\n#endif",shadowmap_pars_fragment="\n#define BIAS_FRUSTUM_SCALE_COEFF 30.0\n#define ESM_SPOT_SINGLE_BLUR_COEFF 0.25\n#define PCF_POISSON_SPOT_OMNI_BLUR_COEFF 4.0\n#define PCF_POISSON_POINT_BLUR_COEFF 2.5\n#define ESM_BIAS_COEFF 100.0\n#ifndef ESM_DISTANCE_SCALE\n#define ESM_DISTANCE_SCALE 1.0\n#endif\n#ifdef USE_SHADOWMAP\n#if NUM_SPOT_LIGHT_SHADOWS>0\nuniform sampler2D spotShadowMap[NUM_SPOT_LIGHT_SHADOWS];\nvarying vec4 vSpotShadowCoord[NUM_SPOT_LIGHT_SHADOWS];\nstruct SpotLightShadow {\nfloat shadowBias;\nfloat shadowNormalBias;\nfloat shadowRadius;\nvec2 shadowMapSize;\nint shadow;\nfloat shadowCameraNear;\nfloat shadowCameraFar;\nfloat expBias;\n};\nuniform SpotLightShadow spotLightShadows[NUM_SPOT_LIGHT_SHADOWS];\n#endif\n#if NUM_POINT_LIGHT_SHADOWS>0\nuniform sampler2D pointShadowMap[NUM_POINT_LIGHT_SHADOWS];\nvarying vec4 vPointShadowCoord[NUM_POINT_LIGHT_SHADOWS];\nstruct PointLightShadow {\nfloat shadowBias;\nfloat shadowNormalBias;\nfloat shadowRadius;\nvec2 shadowMapSize;\nfloat shadowCameraNear;\nfloat shadowCameraFar;\nfloat expBias;\n};\nuniform PointLightShadow pointLightShadows[NUM_POINT_LIGHT_SHADOWS];\n#endif\n#if NUM_RECT_AREA_LIGHT_SHADOWS>0\nuniform sampler2D rectAreaShadowMap[NUM_RECT_AREA_LIGHT_SHADOWS];\nvarying vec4 vRectAreaShadowCoord[NUM_RECT_AREA_LIGHT_SHADOWS];\nstruct RectAreaLightShadow {\nfloat shadowBias;\nfloat shadowNormalBias;\nfloat shadowRadius;\nvec2 shadowMapSize;\nfloat shadowCameraNear;\nfloat shadowCameraFar;\nfloat expBias;\n};\nuniform RectAreaLightShadow rectAreaLightShadows[NUM_RECT_AREA_LIGHT_SHADOWS];\n#endif\n#if NUM_DIR_LIGHT_SHADOWS_CSM>0\nuniform sampler2D directionalShadowCSMMap[NUM_DIR_LIGHT_SHADOW_CASCADES_CSM];\nvarying vec4 vDirectionalShadowCSMCoord[NUM_DIR_LIGHT_SHADOW_CASCADES_CSM];\nstruct DirectionalLightShadowCascade {\nfloat shadowBias;\nfloat shadowNormalBias;\nfloat shadowRadius;\nvec2 shadowMapSize;\nfloat shadowCameraNear;\nfloat shadowCameraFar;\nvec2 cascade;\nfloat expBias;\nvec3 position;\nint csmIdx;\n};\nstruct DirectionalLightShadowCSM {\nint cascadeIdxEnd;\nfloat cameraNear;\nfloat shadowFar;\nfloat fade;\n};\nuniform DirectionalLightShadowCSM directionalLightShadowsCSM[NUM_DIR_LIGHT_SHADOWS_CSM];\nuniform DirectionalLightShadowCascade directionalLightShadowsCSMCascade[NUM_DIR_LIGHT_SHADOW_CASCADES_CSM];\n#endif\nconst vec3 PERMUTE_DIR_X=vec3(1.0,0.0,0.0);\nconst vec3 PERMUTE_DIR_Y=vec3(0.0,1.0,0.0);\nconst vec3 PERMUTE_DIR_Z=vec3(0.0,0.0,1.0);\nconst mat4 POISSON_DISK_0=mat4(0.954845,0.242214,-0.623893,-0.235473,-0.173288,0.799228,0.605969,-0.548050,-0.560406,0.327647,-0.448307,-0.774344,0.308258,0.417332,-0.125623,-0.056098\n);\nconst mat4 POISSON_DISK_1=mat4(0.145585,-0.305634,0.264060,-0.661648,0.617942,0.652121,-0.041412,-0.893582,0.463911,0.039752,0.212664,0.810727,-0.955989,-0.014390,-0.652588,0.671204\n);\nfloat texture2DCompare(sampler2D depths,vec2 uv,float compare){\nreturn step(compare,unpackRGBAToDepth(texture2D(depths,uv)));\n}\nfloat texture2DShadowLerp(sampler2D depths,vec2 size,vec2 uv,float compare){\nconst vec2 offset=vec2(0.0,1.0);\nvec2 texelSize=vec2(1.0)/size;\nvec2 centroidUV=floor(uv*size+0.5)/size;\nfloat lb=texture2DCompare(depths,centroidUV+texelSize*offset.xx,compare);\nfloat lt=texture2DCompare(depths,centroidUV+texelSize*offset.xy,compare);\nfloat rb=texture2DCompare(depths,centroidUV+texelSize*offset.yx,compare);\nfloat rt=texture2DCompare(depths,centroidUV+texelSize*offset.yy,compare);\nvec2 f=fract(uv*size+0.5);\nfloat a=mix(lb,lt,f.y);\nfloat b=mix(rb,rt,f.y);\nfloat c=mix(a,b,f.x);\nreturn c;\n}\nvec2 cubeToUV(vec3 v,float texelSizeY){\nvec3 absV=abs(v);\nfloat scaleToCube=1.0/max(absV.x,max(absV.y,absV.z));\nabsV*=scaleToCube;\nv*=scaleToCube*(1.0-2.0*texelSizeY);\nvec2 planar=v.xy;\nfloat almostATexel=1.5*texelSizeY;\nfloat almostOne=1.0-almostATexel;\nif (absV.z>=almostOne){\nif (v.z>0.0)\nplanar.x=4.0-v.x;\n} else if (absV.x>=almostOne){\nfloat signX=sign(v.x);\nplanar.x=v.z*signX+2.0*signX;\n} else if (absV.y>=almostOne){\nfloat signY=sign(v.y);\nplanar.x=v.x+2.0*signY+2.0;\nplanar.y=v.z*signY-2.0;\n}\nreturn vec2(0.125,0.25)*planar+vec2(0.375,0.75);\n}\nfloat texture2DShadowAvgCube(sampler2D depths,vec2 size,vec3 bd3D,float compare){\nvec2 texelSize=vec2(1.0)/size;\nvec3 dirX=normalize(abs(bd3D.y)<0.99999?vec3(bd3D.z,0.0,-bd3D.x)\n: vec3(0.0,-bd3D.z,bd3D.y));\nvec3 dirY=cross(bd3D,dirX);\nfloat theta=PI_HALF*texelSize.y;\nvec3 sX=sin(theta)*dirX;\nvec3 sY=sin(theta)*dirY;\nfloat cosT=cos(theta);\nvec3 sampleVec[4];\nsampleVec[0]=bd3D;\nsampleVec[1]=bd3D*cosT+sY;\nsampleVec[2]=bd3D*cosT+sX;\nsampleVec[3]=sampleVec[2]*cosT+sY;\nfloat avg=0.0;\nfor (int i=0;i<4;i++){\navg+=texture2DCompare(depths,cubeToUV(sampleVec[i],texelSize.y),compare);\n}\navg/=4.0;\nreturn avg;\n}\nfloat getShadow(sampler2D shadowMap,vec2 shadowMapSize,float shadowBias,float shadowRadius,vec4 shadowCoord,float expBias,float distWorld){\nfloat shadow=1.0;\nshadowCoord.xyz/=shadowCoord.w;\nbool inFrustum=shadowCoord.x>=0.0&&shadowCoord.x<=1.0&&shadowCoord.y>=0.0&&shadowCoord.y<=1.0;\nbool frustumTest=inFrustum&&shadowCoord.z<=1.0&&shadowCoord.z>=0.0;\nif (frustumTest){\n#if defined(SHADOWMAP_TYPE_BILINEAR)\nshadowCoord.z+=shadowBias;\nshadow=texture2DShadowLerp(shadowMap,shadowMapSize,shadowCoord.xy,shadowCoord.z);\n#elif defined(SHADOWMAP_TYPE_PCF)\nshadowCoord.z+=shadowBias;\nvec2 texelSize=vec2(1.0)/shadowMapSize;\nfloat randAngle=rand(gl_FragCoord.xy)*PI2;\nfloat c=cos(randAngle),s=sin(randAngle);\nmat2 sampleMat=mat2(c,s,-s,c)\n* mat2(shadowRadius*texelSize.x,0.0,0.0,shadowRadius*texelSize.y);\nvec2 sampleVec[16];\nsampleVec[0]=POISSON_DISK_0[0].xy;\nsampleVec[1]=POISSON_DISK_0[0].zw;\nsampleVec[2]=POISSON_DISK_0[1].xy;\nsampleVec[3]=POISSON_DISK_0[1].zw;\nsampleVec[4]=POISSON_DISK_0[2].xy;\nsampleVec[5]=POISSON_DISK_0[2].zw;\nsampleVec[6]=POISSON_DISK_0[3].xy;\nsampleVec[7]=POISSON_DISK_0[3].zw;\nsampleVec[8]=POISSON_DISK_1[0].xy;\nsampleVec[9]=POISSON_DISK_1[0].zw;\nsampleVec[10]=POISSON_DISK_1[1].xy;\nsampleVec[11]=POISSON_DISK_1[1].zw;\nsampleVec[12]=POISSON_DISK_1[2].xy;\nsampleVec[13]=POISSON_DISK_1[2].zw;\nsampleVec[14]=POISSON_DISK_1[3].xy;\nsampleVec[15]=POISSON_DISK_1[3].zw;\nshadow=0.0;\nfor (int i=0;i<16;i++){\nshadow+=texture2DCompare(shadowMap,shadowCoord.xy\n+ sampleMat*sampleVec[i],shadowCoord.z);\n}\nshadow/=16.0;\n#elif defined(SHADOWMAP_TYPE_ESM)\nshadow=saturate(exp(expBias*(texture2D(shadowMap,shadowCoord.xy).x\n- length(distWorld)*ESM_DISTANCE_SCALE\n- ESM_BIAS_COEFF*shadowBias)));\n#else\nshadowCoord.z+=shadowBias;\nshadow=texture2DCompare(shadowMap,shadowCoord.xy,shadowCoord.z);\n#endif\n}\nreturn shadow;\n}\nfloat getOmniShadow(sampler2D shadowMap,vec2 shadowMapSize,float shadowBias,float expBias,float shadowRadius,vec4 shadowCoord,float shadowCameraNear,float shadowCameraFar){\nfloat shadow=1.0;\nvec3 lightToPosition=shadowCoord.xyz;\nfloat dp=(length(lightToPosition)-shadowCameraNear)\n/ (shadowCameraFar-shadowCameraNear);\nbool frustumTest=dp<=1.0&&dp>=0.0;\nif (frustumTest){\nfloat biasScaleCoeff=BIAS_FRUSTUM_SCALE_COEFF\n/ (shadowCameraFar-shadowCameraNear);\ndp+=shadowBias*biasScaleCoeff;\nvec3 bd3D=normalize(lightToPosition);\nvec2 texelSize=1.0/shadowMapSize;\n#if defined(SHADOWMAP_TYPE_BILINEAR)\nshadow=texture2DShadowAvgCube(shadowMap,shadowMapSize,bd3D,dp);\n#elif defined(SHADOWMAP_TYPE_ESM)\nshadow=saturate(exp(expBias*(texture2D(shadowMap,cubeVecToOctUV(bd3D,texelSize)).x\n- length(lightToPosition)*ESM_DISTANCE_SCALE\n- ESM_BIAS_COEFF*shadowBias)));\n#elif defined(SHADOWMAP_TYPE_PCF)\nfloat randAngle=rand(gl_FragCoord.xy)*PI2;\nfloat c=cos(randAngle),s=sin(randAngle);\nmat2 sampleMat=mat2(c,s,-s,c)\n* mat2(shadowRadius*texelSize.y,0.0,0.0,shadowRadius*texelSize.y);\nvec3 absBd3D=abs(bd3D);\nabsBd3D/=max(absBd3D.x,max(absBd3D.y,absBd3D.z));\nbvec2 isPointingCubeFace=greaterThan(absBd3D.xy,vec2(0.999));\nmat3 permuteMat=mat3(isPointingCubeFace.x?PERMUTE_DIR_Y:PERMUTE_DIR_X,isPointingCubeFace.x||isPointingCubeFace.y?PERMUTE_DIR_Z:PERMUTE_DIR_Y,isPointingCubeFace.x?PERMUTE_DIR_X:isPointingCubeFace.y?PERMUTE_DIR_Y:PERMUTE_DIR_Z\n);\nvec2 sampleVec[16];\nsampleVec[0]=POISSON_DISK_0[0].xy;\nsampleVec[1]=POISSON_DISK_0[0].zw;\nsampleVec[2]=POISSON_DISK_0[1].xy;\nsampleVec[3]=POISSON_DISK_0[1].zw;\nsampleVec[4]=POISSON_DISK_0[2].xy;\nsampleVec[5]=POISSON_DISK_0[2].zw;\nsampleVec[6]=POISSON_DISK_0[3].xy;\nsampleVec[7]=POISSON_DISK_0[3].zw;\nsampleVec[8]=POISSON_DISK_1[0].xy;\nsampleVec[9]=POISSON_DISK_1[0].zw;\nsampleVec[10]=POISSON_DISK_1[1].xy;\nsampleVec[11]=POISSON_DISK_1[1].zw;\nsampleVec[12]=POISSON_DISK_1[2].xy;\nsampleVec[13]=POISSON_DISK_1[2].zw;\nsampleVec[14]=POISSON_DISK_1[3].xy;\nsampleVec[15]=POISSON_DISK_1[3].zw;\nshadow=0.0;\nfor (int i=0;i<16;i++){\nshadow+=texture2DCompare(shadowMap,cubeToUV(bd3D+permuteMat*vec3(sampleMat*sampleVec[i],0.0),texelSize.y),dp);\n}\nshadow/=16.0;\n#else\nshadow=texture2DCompare(shadowMap,cubeToUV(bd3D,texelSize.y),dp);\n#endif\n}\nreturn shadow;\n}\n#if NUM_POINT_LIGHT_SHADOWS>0\nfloat getPointShadow(PointLightShadow light,sampler2D shadowMap,vec4 shadowCoord){\nfloat shadowRadius=light.shadowRadius;\nvec2 mapSize=light.shadowMapSize;\n#if defined(SHADOWMAP_TYPE_ESM)\nmapSize*=2.0;\n#else\nmapSize*=vec2(4.0,2.0);\n#if defined(SHADOWMAP_TYPE_PCF)\nshadowRadius*=PCF_POISSON_POINT_BLUR_COEFF;\n#endif\n#endif\nreturn getOmniShadow(shadowMap,mapSize,light.shadowBias,light.expBias,shadowRadius,shadowCoord,light.shadowCameraNear,light.shadowCameraFar);\n}\n#endif\n#if NUM_RECT_AREA_LIGHT_SHADOWS>0\nfloat getRectAreaShadow(RectAreaLightShadow light,sampler2D shadowMap,vec4 shadowCoord){\nfloat shadowRadius=light.shadowRadius;\nvec2 mapSize=light.shadowMapSize;\n#if defined(SHADOWMAP_TYPE_ESM)\nmapSize*=2.0;\n#else\nmapSize*=vec2(4.0,2.0);\n#if defined(SHADOWMAP_TYPE_PCF)\nshadowRadius*=PCF_POISSON_POINT_BLUR_COEFF;\n#endif\n#endif\nreturn getOmniShadow(shadowMap,mapSize,light.shadowBias,light.expBias,shadowRadius,shadowCoord,light.shadowCameraNear,light.shadowCameraFar);\n}\n#endif\n#if NUM_SPOT_LIGHT_SHADOWS>0\nfloat getSpotOmniShadow(SpotLightShadow light,sampler2D shadowMap,vec4 shadowCoord){\nfloat shadowRadius=light.shadowRadius;\nvec2 mapSize=light.shadowMapSize;\n#if defined(SHADOWMAP_TYPE_ESM)\n#else\nmapSize*=vec2(4.0,2.0);\n#if defined(SHADOWMAP_TYPE_PCF)\nshadowRadius*=PCF_POISSON_SPOT_OMNI_BLUR_COEFF;\n#endif\n#endif\nreturn getOmniShadow(shadowMap,mapSize,light.shadowBias,light.expBias,shadowRadius,shadowCoord,light.shadowCameraNear,light.shadowCameraFar);\n}\nfloat biasLinearNormalizedToNonlinear(float bias,float near,float far,float projZ,float projW){\nreturn (bias*(far+near)+2.0*projZ)/(bias*(far-near)+2.0*projW)\n- projZ/projW;\n}\nfloat getSpotShadow(SpotLightShadow light,sampler2D shadowMap,vec4 shadowCoord,float distWorld){\nfloat shadowRadius=light.shadowRadius;\nfloat shadowBias=light.shadowBias;\n#if defined(SHADOWMAP_TYPE_ESM)\nshadowRadius*=ESM_SPOT_SINGLE_BLUR_COEFF;\n#endif\nshadowBias*=BIAS_FRUSTUM_SCALE_COEFF\n/ (light.shadowCameraFar-light.shadowCameraNear);\n#if defined(SHADOWMAP_TYPE_BASIC)||defined(SHADOWMAP_TYPE_BILINEAR)||defined(SHADOWMAP_TYPE_PCF)\nshadowBias=biasLinearNormalizedToNonlinear(shadowBias,light.shadowCameraNear,light.shadowCameraFar,shadowCoord.z,shadowCoord.w);\n#endif\nreturn getShadow(shadowMap,light.shadowMapSize,shadowBias,shadowRadius,shadowCoord,light.expBias,distWorld);\n}\n#endif\n#if NUM_DIR_LIGHT_SHADOWS_CSM>0\nfloat getDirShadowCSM(DirectionalLightShadowCascade light,sampler2D shadowMap,vec4 shadowCoord,float distWorld){\nreturn getShadow(shadowMap,light.shadowMapSize,light.shadowBias,light.shadowRadius,shadowCoord,light.expBias,distWorld);\n}\n#endif\n#endif",shadowmap_pars_vertex="#ifdef USE_SHADOWMAP\n#if NUM_SPOT_LIGHT_SHADOWS>0\nuniform mat4 spotShadowMatrix[NUM_SPOT_LIGHT_SHADOWS];\nvarying vec4 vSpotShadowCoord[NUM_SPOT_LIGHT_SHADOWS];\nstruct SpotLightShadow {\nfloat shadowBias;\nfloat shadowNormalBias;\nfloat shadowRadius;\nvec2 shadowMapSize;\nint shadow;\nfloat shadowCameraNear;\nfloat shadowCameraFar;\nfloat expBias;\n};\nuniform SpotLightShadow spotLightShadows[NUM_SPOT_LIGHT_SHADOWS];\n#endif\n#if NUM_POINT_LIGHT_SHADOWS>0\nuniform mat4 pointShadowMatrix[NUM_POINT_LIGHT_SHADOWS];\nvarying vec4 vPointShadowCoord[NUM_POINT_LIGHT_SHADOWS];\nstruct PointLightShadow {\nfloat shadowBias;\nfloat shadowNormalBias;\nfloat shadowRadius;\nvec2 shadowMapSize;\nfloat shadowCameraNear;\nfloat shadowCameraFar;\nfloat expBias;\n};\nuniform PointLightShadow pointLightShadows[NUM_POINT_LIGHT_SHADOWS];\n#endif\n#if NUM_RECT_AREA_LIGHT_SHADOWS>0\nuniform mat4 rectAreaShadowMatrix[NUM_RECT_AREA_LIGHT_SHADOWS];\nvarying vec4 vRectAreaShadowCoord[NUM_RECT_AREA_LIGHT_SHADOWS];\nstruct RectAreaLightShadow {\nfloat shadowBias;\nfloat shadowNormalBias;\nfloat shadowRadius;\nvec2 shadowMapSize;\nfloat shadowCameraNear;\nfloat shadowCameraFar;\nfloat expBias;\n};\nuniform RectAreaLightShadow rectAreaLightShadows[NUM_RECT_AREA_LIGHT_SHADOWS];\n#endif\n#if NUM_DIR_LIGHT_SHADOWS_CSM>0\nuniform mat4 directionalShadowCSMMatrix[NUM_DIR_LIGHT_SHADOW_CASCADES_CSM];\nvarying vec4 vDirectionalShadowCSMCoord[NUM_DIR_LIGHT_SHADOW_CASCADES_CSM];\nstruct DirectionalLightShadowCascade {\nfloat shadowBias;\nfloat shadowNormalBias;\nfloat shadowRadius;\nvec2 shadowMapSize;\nfloat shadowCameraNear;\nfloat shadowCameraFar;\nvec2 cascade;\nfloat expBias;\nvec3 position;\nint csmIdx;\n};\nstruct DirectionalLightShadowCSM {\nint cascadeIdxEnd;\nfloat cameraNear;\nfloat shadowFar;\nfloat fade;\n};\nuniform DirectionalLightShadowCSM directionalLightShadowsCSM[NUM_DIR_LIGHT_SHADOWS_CSM];\nuniform DirectionalLightShadowCascade directionalLightShadowsCSMCascade[NUM_DIR_LIGHT_SHADOW_CASCADES_CSM];\n#endif\n#endif",shadowmap_vertex="#if defined(USE_SHADOWMAP)\n#if NUM_SPOT_LIGHT_SHADOWS>0||NUM_POINT_LIGHT_SHADOWS>0||NUM_RECT_AREA_LIGHT_SHADOWS>0||NUM_DIR_LIGHT_SHADOWS_CSM>0\nvec3 shadowWorldNormal=inverseTransformDirection(transformedNormal,viewMatrix);\nvec4 shadowWorldPosition;\n#endif\n#if NUM_SPOT_LIGHT_SHADOWS>0\n#pragma unroll_loop\nfor (int i=0;i<NUM_SPOT_LIGHT_SHADOWS;i++){\nshadowWorldPosition=worldPosition+vec4(shadowWorldNormal*spotLightShadows[i].shadowNormalBias,0);\nvSpotShadowCoord[i]=spotShadowMatrix[i]*shadowWorldPosition;\n}\n#endif\n#if NUM_POINT_LIGHT_SHADOWS>0\n#pragma unroll_loop\nfor (int i=0;i<NUM_POINT_LIGHT_SHADOWS;i++){\nshadowWorldPosition=worldPosition+vec4(shadowWorldNormal*pointLightShadows[i].shadowNormalBias,0);\nvPointShadowCoord[i]=pointShadowMatrix[i]*shadowWorldPosition;\n}\n#endif\n#if NUM_RECT_AREA_LIGHT_SHADOWS>0\n#pragma unroll_loop\nfor (int i=0;i<NUM_RECT_AREA_LIGHT_SHADOWS;i++){\nshadowWorldPosition=worldPosition+vec4(shadowWorldNormal*rectAreaLightShadows[i].shadowNormalBias,0);\nvRectAreaShadowCoord[i]=rectAreaShadowMatrix[i]*shadowWorldPosition;\n}\n#endif\n#if NUM_DIR_LIGHT_SHADOWS_CSM>0\n#pragma unroll_loop\nfor (int i=0;i<NUM_DIR_LIGHT_SHADOW_CASCADES_CSM;i++){\nshadowWorldPosition=worldPosition+vec4(shadowWorldNormal*directionalLightShadowsCSMCascade[i].shadowNormalBias,0);\nvDirectionalShadowCSMCoord[i]=directionalShadowCSMMatrix[i]*shadowWorldPosition;\n}\n#endif\n#endif",shadowmask_pars_fragment="float getShadowMask(){\nfloat shadow=1.0;\n#ifdef USE_SHADOWMAP\n#if NUM_SPOT_LIGHT_SHADOWS>0\nSpotLightShadow spotLight;\n#pragma unroll_loop\nfor (int i=0;i<NUM_SPOT_LIGHT_SHADOWS;i++){\nspotLight=spotLightShadows[i];\nif (receiveShadow){\nif (spotLight.shadow==1){\nfloat distWorld=0.0;\n#if defined(SHADOWMAP_TYPE_ESM)\ndistWorld=length((invViewMatrix*vec4(spotLight.position\n+ vViewPosition,0.0)).xyz);\n#endif\nshadow*=getSpotShadow(spotLight,spotShadowMap[i],vSpotShadowCoord[i],distWorld);\n} else if (spotLight.shadow==2){\nshadow*=getSpotOmniShadow(spotLight,spotShadowMap[i],vSpotShadowCoord[i]);\n}\n}\n}\n#endif\n#if NUM_POINT_LIGHT_SHADOWS>0\nPointLightShadow pointLight;\n#pragma unroll_loop\nfor (int i=0;i<NUM_POINT_LIGHT_SHADOWS;i++){\npointLight=pointLightShadows[i];\nshadow*=receiveShadow?getPointShadow(pointLight,pointShadowMap[i],vPointShadowCoord[i]):1.0;\n}\n#endif\n#if NUM_RECT_AREA_LIGHT_SHADOWS>0\nRectAreaLightShadow rectAreaLight;\n#pragma unroll_loop\nfor (int i=0;i<NUM_RECT_AREA_LIGHT_SHADOWS;i++){\nrectAreaLight=rectAreaLightShadows[i];\nshadow*=receiveShadow?getRectAreaShadow(rectAreaLight,rectAreaShadowMap[i],vRectAreaShadowCoord[i]):1.0;\n}\n#endif\n#if NUM_DIR_LIGHT_SHADOWS_CSM>0\nDirectionalLightShadowCascade dirShadowCascade;\n#pragma unroll_loop\nfor (int i=0;i<NUM_DIR_LIGHT_SHADOW_CASCADES_CSM;i++){\ndirShadowCascade=directionalLightShadowsCSMCascade[i];\nfloat distWorld=0.0;\n#if defined(SHADOWMAP_TYPE_ESM)\ndistWorld=length((invViewMatrix*vec4(dirShadowCascade.position\n+ vViewPosition,0.0)).xyz);\n#endif\nshadow*=((vViewPosition.z<dirShadowCascade.shadowCameraFar)&&receiveShadow)?\ngetDirShadowCSM(dirShadowCascade,directionalShadowCSMMap[i],vDirectionalShadowCSMCoord[i],distWorld)\n: 1.0;\n}\n#endif\n#endif\nreturn shadow;\n}",skinbase_vertex="#ifdef USE_SKINNING\nmat4 boneMatX=getBoneMatrix(skinIndex.x);\nmat4 boneMatY=getBoneMatrix(skinIndex.y);\nmat4 boneMatZ=getBoneMatrix(skinIndex.z);\nmat4 boneMatW=getBoneMatrix(skinIndex.w);\n#endif",skinning_pars_vertex="#ifdef USE_SKINNING\nuniform mat4 bindMatrix;\nuniform mat4 bindMatrixInverse;\nuniform highp sampler2D boneTexture;\nuniform int boneTextureSize;\nmat4 getBoneMatrix(const in float i){\nfloat j=i*4.0;\nfloat x=mod(j,float(boneTextureSize));\nfloat y=floor(j/float(boneTextureSize));\nfloat dx=1.0/float(boneTextureSize);\nfloat dy=1.0/float(boneTextureSize);\ny=dy*(y+0.5);\nvec4 v1=texture2D(boneTexture,vec2(dx*(x+0.5),y));\nvec4 v2=texture2D(boneTexture,vec2(dx*(x+1.5),y));\nvec4 v3=texture2D(boneTexture,vec2(dx*(x+2.5),y));\nvec4 v4=texture2D(boneTexture,vec2(dx*(x+3.5),y));\nmat4 bone=mat4(v1,v2,v3,v4);\nreturn bone;\n}\n#endif",skinning_vertex="#ifdef USE_SKINNING\nvec4 skinVertex=bindMatrix*vec4(transformed,1.0);\nvec4 skinned=vec4(0.0);\nskinned+=boneMatX*skinVertex*skinWeight.x;\nskinned+=boneMatY*skinVertex*skinWeight.y;\nskinned+=boneMatZ*skinVertex*skinWeight.z;\nskinned+=boneMatW*skinVertex*skinWeight.w;\ntransformed=(bindMatrixInverse*skinned).xyz;\n#endif",skinnormal_vertex="#ifdef USE_SKINNING\nmat4 skinMatrix=mat4(0.0);\nskinMatrix+=skinWeight.x*boneMatX;\nskinMatrix+=skinWeight.y*boneMatY;\nskinMatrix+=skinWeight.z*boneMatZ;\nskinMatrix+=skinWeight.w*boneMatW;\nskinMatrix=bindMatrixInverse*skinMatrix*bindMatrix;\nobjectNormal=vec4(skinMatrix*vec4(objectNormal,0.0)).xyz;\n#ifdef USE_TANGENT\nobjectTangent=vec4(skinMatrix*vec4(objectTangent,0.0)).xyz;\n#endif\n#endif",tonemapping_fragment="#if defined(TONE_MAPPING)\ngl_FragColor.rgb=toneMapping(gl_FragColor.rgb);\n#endif",tonemapping_pars_fragment="#ifndef saturate\n#define saturate(a)clamp(a,0.0,1.0)\n#endif\nuniform float toneMappingExposure;\nuniform float toneMappingMidTones;\nuniform float toneMappingPhysicalScale;\nuniform float toneMappingBrightness;\nuniform float toneMappingContrast;\nuniform bool toneMappingChromaticAdaptation;\nuniform vec3 toneMappingWhiteColor;\nuniform bool toneMappingColorDifferentiation;\nuniform bool toneMappingExteriorDaylight;\nuniform vec3 toneMappingWhiteBalance;\nuniform float toneMappingHighlights;\nuniform float toneMappingShadows;\nuniform float toneMappingSaturation;\nuniform float toneMappingAperture;\nuniform float toneMappingShutter;\nuniform float toneMappingISO;\nuniform float toneMappingVignetting;\nuniform vec2 toneMappingResolution;\nconst mat3 LINEAR_REC2020_TO_LINEAR_SRGB=mat3(vec3( 1.6605,-0.1246,-0.0182),vec3(-0.5876,1.1329,-0.1006),vec3(-0.0728,-0.0083,1.1187)\n);\nconst mat3 LINEAR_SRGB_TO_LINEAR_REC2020=mat3(vec3(0.6274,0.0691,0.0164),vec3(0.3293,0.9195,0.0880),vec3(0.0433,0.0113,0.8956)\n);\n#define TONE_MAPPING_LOOK_NONE 0\n#define TONE_MAPPING_LOOK_AGX_PUNCHY 1\nconst float FILMIC_BLENDER_LOG_MIN=-12.473931188;\nconst float FILMIC_BLENDER_LOG_MAX=12.526068812;\nconst float FILMIC_BLENDER_EXPOSURE_LATITUDE_RATIO=0.66;\nvec3 LinearToneMapping(vec3 color){\nreturn toneMappingExposure*color;\n}\nvec3 ReinhardToneMapping(vec3 color){\ncolor*=toneMappingExposure;\nreturn saturate(color/(vec3(1.0)+color));\n}\nvec3 OptimizedCineonToneMapping(vec3 color){\ncolor*=toneMappingExposure;\ncolor=max(vec3(0.0),color-0.004);\nreturn pow((color*(6.2*color+0.5))/(color*(6.2*color+1.7)+0.06),vec3(2.2));\n}\nvec3 RRTAndODTFit(vec3 v){\nvec3 a=v*(v+0.0245786)-0.000090537;\nvec3 b=v*(0.983729*v+0.4329510)+0.238081;\nreturn a/b;\n}\nvec3 ACESFilmicToneMapping(vec3 color){\nconst mat3 ACESInputMat=mat3(vec3(0.59719,0.07600,0.02840),vec3(0.35458,0.90834,0.13383),vec3(0.04823,0.01566,0.83777)\n);\nconst mat3 ACESOutputMat=mat3(vec3( 1.60475,-0.10208,-0.00327),vec3(-0.53108,1.10813,-0.07276),vec3(-0.07367,-0.00605,1.07602)\n);\ncolor*=toneMappingExposure/0.6;\ncolor=ACESInputMat*color;\ncolor=RRTAndODTFit(color);\ncolor=ACESOutputMat*color;\nreturn saturate(color);\n}\nvec3 agxDefaultContrastApprox(vec3 x){\nvec3 x2=x*x;\nvec3 x4=x2*x2;\nreturn+15.5*x4*x2\n-40.14*x4*x\n+ 31.96*x4\n-6.868*x2*x\n+ 0.4298*x2\n+ 0.1191*x\n-0.00232;\n}\nvec3 toneMappingLook(vec3 color,int look){\nif (look==TONE_MAPPING_LOOK_NONE){\nreturn color;\n}\nconst vec3 lw=vec3(0.2126,0.7152,0.0722);\nfloat luma=dot(color,lw);\nvec3 offset=vec3(0.0);\nvec3 slope=vec3(1.0);\nvec3 power=vec3(1.0);\nfloat sat=1.0;\nif (look==TONE_MAPPING_LOOK_AGX_PUNCHY){\nslope=vec3(1.0);\npower=vec3(1.35,1.35,1.35);\nsat=1.4;\n}\ncolor=pow(color*slope+offset,power);\nreturn luma+sat*(color-luma);\n}\nvec3 AgXToneMapping(vec3 color){\ncolor=max(color,0.0);\nconst mat3 AgXInsetMatrix=mat3(vec3(0.856627153315983,0.137318972929847,0.11189821299995),vec3(0.0951212405381588,0.761241990602591,0.0767994186031903),vec3(0.0482516061458583,0.101439036467562,0.811302368396859)\n);\nconst mat3 AgXOutsetMatrix=mat3(vec3(1.1271005818144368,-0.1413297634984383,-0.14132976349843826),vec3(- 0.11060664309660323,1.157823702216272,-0.11060664309660294),vec3(- 0.016493938717834573,-0.016493938717834257,1.2519364065950405)\n);\nconst float AgxMinEv=-12.47393;\nconst float AgxMaxEv=4.026069;\ncolor*=toneMappingExposure;\ncolor=LINEAR_SRGB_TO_LINEAR_REC2020*color;\ncolor=AgXInsetMatrix*color;\ncolor=max(color,1e-10);\ncolor=log2(color);\ncolor=(color-AgxMinEv)/(AgxMaxEv-AgxMinEv);\ncolor=clamp(color,0.0,1.0);\ncolor=agxDefaultContrastApprox(color);\ncolor=toneMappingLook(color,TONE_MAPPING_LOOK);\ncolor=AgXOutsetMatrix*color;\ncolor=pow(max(vec3(0.0),color),vec3(2.2));\ncolor=LINEAR_REC2020_TO_LINEAR_SRGB*color;\ncolor=clamp(color,0.0,1.0);\nreturn color;\n}\nvec3 CustomToneMapping(vec3 color){return color;}\n#define ORDERS_OF_MAG 5.0\n#define PI_TONE 3.14159265359\nfloat toneCalcBrightness(in vec3 color)\n{\nreturn (abs(color.r)*0.263+abs(color.g)*0.655+abs(color.b)*0.082);\n}\nfloat toneApproximateScotopicLuminance(vec3 color)\n{\nreturn (0.062*color.r+0.608*color.g+0.330*color.b);\n}\nvec3 LogarithmicMaxToneMapping(vec3 color){\nfloat inputScaleFactor=toneMappingPhysicalScale/PI_TONE;\nfloat brightness=(toneMappingBrightness<0.0)?0.0:(toneMappingBrightness*0.7);\nfloat powerBot=toneMappingExteriorDaylight?4.0:2.0;\nfloat res=100.0/ORDERS_OF_MAG;\nfloat mag=floor((50.0/res));\nfloat power=((brightness/20.0-ORDERS_OF_MAG)-powerBot)+mag;\nfloat stepsize=9.0/res;\nfloat step=50.0-(mag*res);\nfloat param_c=(0.02*toneMappingContrast)*2.0;\nfloat param_b=pow(10.0,power)*(1.0+(stepsize*step));\nfloat param_a=param_b*(1.0+param_c);\nparam_c/=pow(2.0,toneMappingMidTones-1.0);\nparam_b*=PI_TONE;\nvec3 whiteConstancyFactor=toneMappingWhiteColor;\nif (toneMappingChromaticAdaptation){\nfloat luminance=toneCalcBrightness(whiteConstancyFactor);\nwhiteConstancyFactor.r=(whiteConstancyFactor.r>0.001)?luminance/whiteConstancyFactor.r:luminance/0.001;\nwhiteConstancyFactor.g=(whiteConstancyFactor.g>0.001)?luminance/whiteConstancyFactor.g:luminance/0.001;\nwhiteConstancyFactor.b=(whiteConstancyFactor.b>0.001)?luminance/whiteConstancyFactor.b:luminance/0.001;\n}\nvec3 outColor=inputScaleFactor*color;\nif (toneMappingChromaticAdaptation){\noutColor*=whiteConstancyFactor.rgb;\n}\nfloat luminance=toneCalcBrightness(outColor);\nif (toneMappingColorDifferentiation&&(luminance<5.62)){\nfloat sLuminance=toneApproximateScotopicLuminance(outColor);\nif (luminance<=5.62e-3){\noutColor=vec3(sLuminance);\n} else {\nfloat w=(luminance-5.62e-3)/5.61438;\noutColor=outColor*w+sLuminance*(1.0-w);\n}\n}\noutColor=outColor*(param_a/(param_b*outColor+param_c));\nreturn outColor;\n}\nfloat maxExposurePhotographic(in vec4 color1,in vec4 color2)\n{\nreturn ((color1.r*color2.r)+(color1.g*color2.g))+(color1.b*color2.b);\n}\nvec3 PhysicalMaxToneMapping(vec3 color){\nfloat vignettingInfluence=1.0;\nif (toneMappingVignetting>0.0){\nvec3 vignettingCoords=vec3(0.0,0.0,0.0);\nfloat aspect=toneMappingResolution.x/toneMappingResolution.y;\nvignettingCoords.x=gl_FragCoord.x/toneMappingResolution.x-0.5;\nvignettingCoords.y=(gl_FragCoord.y/toneMappingResolution.y-0.5)/aspect;\nvignettingCoords.z=1.0;\nvignettingCoords=normalize(vignettingCoords);\nvignettingInfluence=pow(vignettingCoords.z,toneMappingVignetting);\n}\nfloat inputScaleFactor=toneMappingPhysicalScale/PI_TONE;\nfloat filmISO=toneMappingISO;\nfloat camShutter=1.0/toneMappingShutter;\nfloat fNumber=toneMappingAperture;\nfloat cm2=1.0;\nfloat burnHighlights=toneMappingHighlights;\nfloat crushBlacks=toneMappingShadows;\nfloat saturation=toneMappingSaturation;\nvec3 whitePointInfluence=toneMappingWhiteBalance;\nif (whitePointInfluence.r>0.0){\nwhitePointInfluence.r=1.0/whitePointInfluence.r;\n} else {\nwhitePointInfluence.r=1.0;\n}\nif (whitePointInfluence.g>0.0){\nwhitePointInfluence.g=1.0/whitePointInfluence.g;\n} else {\nwhitePointInfluence.g=1.0;\n}\nif (whitePointInfluence.b>0.0){\nwhitePointInfluence.b=1.0/whitePointInfluence.b;\n} else {\nwhitePointInfluence.b=1.0;\n}\nvec4 lumFactor=vec4(0.212671,0.715160,0.072169,0.0);\nfloat whiteLumFactor=maxExposurePhotographic(lumFactor,vec4(whitePointInfluence,0.0));\nwhitePointInfluence.r/=whiteLumFactor;\nwhitePointInfluence.g/=whiteLumFactor;\nwhitePointInfluence.b/=whiteLumFactor;\nfloat isoInfluence=0.0;\nfloat camShutterInv=1.0/camShutter;\nif (filmISO>0.0){\nisoInfluence=((cm2*0.169811)*(filmISO*camShutterInv))/((15.4*fNumber)*fNumber);\n} else {\nisoInfluence=cm2;\n}\nvec3 outColor=inputScaleFactor*color;\noutColor.r=outColor.r*whitePointInfluence.r*isoInfluence*vignettingInfluence;\noutColor.g=outColor.g*whitePointInfluence.g*isoInfluence*vignettingInfluence;\noutColor.b=outColor.b*whitePointInfluence.b*isoInfluence*vignettingInfluence;\noutColor.r=(outColor.r*(1.0+(outColor.r*burnHighlights)))/(1.0+outColor.r);\noutColor.g=(outColor.g*(1.0+(outColor.g*burnHighlights)))/(1.0+outColor.g);\noutColor.b=(outColor.b*(1.0+(outColor.b*burnHighlights)))/(1.0+outColor.b);\nfloat lumFactor2=maxExposurePhotographic(lumFactor,vec4(outColor,0.0));\nfloat tmpFloat=1.0-saturation;\noutColor.r=outColor.r*saturation+lumFactor2*tmpFloat;\noutColor.g=outColor.g*saturation+lumFactor2*tmpFloat;\noutColor.b=outColor.b*saturation+lumFactor2*tmpFloat;\noutColor=max(vec3(0.0),outColor);\nfloat crushBlacksFac=crushBlacks*2.0+1.0;\nfloat crushBlacksFac2=pow(maxExposurePhotographic(lumFactor,vec4(outColor,0.0)),0.5);\ntmpFloat=(1.0-crushBlacksFac2);\nif (crushBlacksFac2<1.0){\noutColor.r=outColor.r*crushBlacksFac2+pow(outColor.r,crushBlacksFac)*tmpFloat;\noutColor.g=outColor.g*crushBlacksFac2+pow(outColor.g,crushBlacksFac)*tmpFloat;\noutColor.b=outColor.b*crushBlacksFac2+pow(outColor.b,crushBlacksFac)*tmpFloat;\n}\nreturn outColor;\n}\nfloat filmicBlenderDesaturationMinIntensity(vec3 color){\nfloat maxChannel=max(color.r,max(color.g,color.b));\nfloat x=max(maxChannel,0.6251);\nreturn (1.2192868*x-0.63221059)\n* ((x-0.65069831)/(abs(x-0.65069831)+0.00952982)+0.73015231);\n}\nvec3 filmicBlenderDesaturationTransform(vec3 color){\nconst float CURVE_SMOOTHNESS=0.03;\nfloat minIntensity=filmicBlenderDesaturationMinIntensity(color);\nvec4 x=vec4(color,1.0)-minIntensity;\nx=pow(x,vec4(2.0))/(abs(x)+CURVE_SMOOTHNESS);\nreturn (x.rgb-x.a+color+1.0)/2.0;\n}\nvec3 filmicBlenderDynamicRangeTransform(vec3 color){\nreturn pow((0.28882259*color-0.15880336)\n/ (pow(color-0.6229693,vec3(2.0))+0.16965022)\n+ 0.20453365*color+0.37847142,vec3(3.0)\n);\n}\nvec3 FilmicBlenderToneMapping(vec3 color){\ncolor*=toneMappingExposure;\ncolor=max(color,0.000175);\ncolor=clamp((log2(color)-FILMIC_BLENDER_LOG_MIN)\n/ (FILMIC_BLENDER_LOG_MAX-FILMIC_BLENDER_LOG_MIN),0.0,1.0);\ncolor=filmicBlenderDesaturationTransform(color);\ncolor=clamp(color/FILMIC_BLENDER_EXPOSURE_LATITUDE_RATIO,0.0,1.0);\ncolor=filmicBlenderDynamicRangeTransform(color);\nreturn color;\n}\nvec3 PbrNeutralToneMapping(vec3 color){\ncolor*=toneMappingExposure;\ncolor=max(color,0.0);\nconst float startCompression=0.8-0.04;\nconst float desaturation=0.15;\nfloat x=min(color.r,min(color.g,color.b));\nfloat offset=x<0.08?x-6.25*x*x:0.04;\ncolor-=offset;\nfloat peak=max(color.r,max(color.g,color.b));\nif (peak<startCompression)\nreturn color;\nconst float d=1.0-startCompression;\nfloat newPeak=1.0-d*d/(peak+d-startCompression);\ncolor*=newPeak/peak;\nfloat g=1.0-1.0/(desaturation*(peak-newPeak)+1.);\nreturn mix(color,newPeak*vec3(1,1,1),g);\n}",uv_pars_fragment="#if (defined(USE_UV)&&!defined(UVS_VERTEX_ONLY))\nvarying vec2 vUv;\n#endif",uv_pars_vertex="#ifdef USE_UV\n#ifdef UVS_VERTEX_ONLY\nvec2 vUv;\n#else\nvarying vec2 vUv;\n#endif\nuniform mat3 uvTransform;\n#endif",uv_vertex="#ifdef USE_UV\nvUv=(uvTransform*vec3(uv,1)).xy;\n#endif",uv2_pars_fragment="#if defined(USE_LIGHTMAP)||defined(USE_AOMAP)\nvarying vec2 vUv2;\n#endif",uv2_pars_vertex="#if defined(USE_LIGHTMAP)||defined(USE_AOMAP)\nattribute vec2 uv2;\nvarying vec2 vUv2;\nuniform mat3 uv2Transform;\n#endif",uv2_vertex="#if defined(USE_LIGHTMAP)||defined(USE_AOMAP)\nvUv2=(uv2Transform*vec3(uv2,1)).xy;\n#endif",webgl1_compat="float cosh(float x){\nreturn (exp(x)+exp(-x))/2.0;\n}\nvec2 cosh(vec2 x){\nreturn (exp(x)+exp(-x))/2.0;\n}\nvec3 cosh(vec3 x){\nreturn (exp(x)+exp(-x))/2.0;\n}\nvec4 cosh(vec4 x){\nreturn (exp(x)+exp(-x))/2.0;\n}\nfloat sinh(float x){\nreturn (exp(x)-exp(-x))/2.0;\n}\nvec2 sinh(vec2 x){\nreturn (exp(x)-exp(-x))/2.0;\n}\nvec3 sinh(vec3 x){\nreturn (exp(x)-exp(-x))/2.0;\n}\nvec4 sinh(vec4 x){\nreturn (exp(x)-exp(-x))/2.0;\n}\nfloat tanh(float x){\nfloat exp2x=exp(2.0*x);\nreturn (exp2x-1.0)/(exp2x+1.0);\n}\nvec2 tanh(vec2 x){\nvec2 exp2x=exp(2.0*x);\nreturn (exp2x-1.0)/(exp2x+1.0);\n}\nvec3 tanh(vec3 x){\nvec3 exp2x=exp(2.0*x);\nreturn (exp2x-1.0)/(exp2x+1.0);\n}\nvec4 tanh(vec4 x){\nvec4 exp2x=exp(2.0*x);\nreturn (exp2x-1.0)/(exp2x+1.0);\n}\nfloat trunc(float x){\nreturn floor(abs(x))*sign(x);\n}\nvec2 trunc(vec2 x){\nreturn floor(abs(x))*sign(x);\n}\nvec3 trunc(vec3 x){\nreturn floor(abs(x))*sign(x);\n}\nvec4 trunc(vec4 x){\nreturn floor(abs(x))*sign(x);\n}",worldpos_vertex="#if defined(USE_ENVMAP)||defined(DISTANCE)||defined (USE_SHADOWMAP)||defined(MASK)||defined(NODE)\nvec4 worldPosition=vec4(transformed,1.0);\n#ifdef USE_INSTANCING\nworldPosition=instanceMatrix*worldPosition;\n#endif\nworldPosition=modelMatrix*worldPosition;\n#endif";const vertex$f="varying vec2 vUv;\nuniform mat3 uvTransform;\nvoid main(){\nvUv=(uvTransform*vec3(uv,1)).xy;\ngl_Position=vec4(position.xy,1.0,1.0);\n}",fragment$f="uniform sampler2D t2D;\nuniform float backgroundIntensity;\nvarying vec2 vUv;\nvoid main(){\nvec4 texColor=texture2D(t2D,vUv);\n#ifdef DECODE_VIDEO_TEXTURE\ntexColor=vec4(mix(pow(texColor.rgb*0.9478672986+vec3(0.0521327014),vec3(2.4)),texColor.rgb*0.0773993808,vec3(lessThanEqual(texColor.rgb,vec3(0.04045)))),texColor.w);\n#endif\ntexColor.rgb*=backgroundIntensity;\ngl_FragColor=texColor;\n#include <tonemapping_fragment>\n#include <encodings_fragment>\n}",vertex$e="varying vec3 vWorldDirection;\n#include <common>\nvoid main(){\nvWorldDirection=transformDirection(position,modelMatrix);\n#include <begin_vertex>\n#include <project_vertex>\ngl_Position.z=gl_Position.w;\n}",fragment$e="#ifdef ENVMAP_TYPE_CUBE\nuniform samplerCube envMap;\n#elif defined(ENVMAP_TYPE_CUBE_UV)\nuniform sampler2D envMap;\n#endif\nuniform float flipEnvMap;\nuniform float backgroundBlurriness;\nuniform float backgroundIntensity;\nvarying vec3 vWorldDirection;\n#include <cube_uv_reflection_fragment>\nvoid main(){\n#ifdef ENVMAP_TYPE_CUBE\nvec4 texColor=textureCube(envMap,vec3(flipEnvMap*vWorldDirection.x,vWorldDirection.yz));\n#elif defined(ENVMAP_TYPE_CUBE_UV)\nvec4 texColor=textureCubeUV(envMap,vWorldDirection,backgroundBlurriness);\n#else\nvec4 texColor=vec4(0.0,0.0,0.0,1.0);\n#endif\ntexColor.rgb*=backgroundIntensity;\ngl_FragColor=texColor;\n#include <tonemapping_fragment>\n#include <encodings_fragment>\n}",vertex$d="varying vec3 vWorldDirection;\n#include <common>\nvoid main(){\nvWorldDirection=transformDirection(position,modelMatrix);\n#include <begin_vertex>\n#include <project_vertex>\ngl_Position.z=gl_Position.w;\n}",fragment$d="uniform samplerCube tCube;\nuniform float tFlip;\nuniform float opacity;\nvarying vec3 vWorldDirection;\nvoid main(){\nvec4 texColor=textureCube(tCube,vec3(tFlip*vWorldDirection.x,vWorldDirection.yz));\ngl_FragColor=texColor;\ngl_FragColor.a*=opacity;\n#include <tonemapping_fragment>\n#include <encodings_fragment>\n}",vertex$c="#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvarying vec3 vViewPosition;\nvarying vec2 vProjectedPosZW;\nvoid main(){\n#include <uv_vertex>\n#include <skinbase_vertex>\n#ifdef USE_DISPLACEMENTMAP\n#include <beginnormal_vertex>\n#include <morphnormal_vertex>\n#include <skinnormal_vertex>\n#endif\n#include <begin_vertex>\n#include <morphtarget_vertex>\n#include <skinning_vertex>\n#include <displacementmap_vertex>\n#include <project_vertex>\n#include <logdepthbuf_vertex>\n#include <clipping_planes_vertex>\nvViewPosition=mvPosition.xyz;\nvProjectedPosZW=mat2(projectionMatrix[2][2],projectionMatrix[2][3],projectionMatrix[3][2],projectionMatrix[3][3]\n)*mvPosition.zw;\n#ifdef PANCAKE_DEPTH\ngl_Position.z=max(gl_Position.z,-1.0);\n#endif\n}",fragment$c="#if DEPTH_PACKING==3200\nuniform float opacity;\n#endif\n#ifdef USE_SLOPE_SCALED_BIAS\nuniform float slopeScaledBias;\nconst float ONE_MINUS_EPS=0.9999999;\n#endif\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvarying vec3 vViewPosition;\nvarying vec2 vProjectedPosZW;\nvoid main(){\n#include <clipping_planes_fragment>\nvec4 diffuseColor=vec4(1.0);\n#if DEPTH_PACKING==3200\ndiffuseColor.a=opacity;\n#endif\n#include <map_fragment>\n#include <alphamap_fragment>\n#include <alphatest_fragment>\n#include <logdepthbuf_fragment>\n#if DEPTH_PACKING != 3202\nfloat depth=vProjectedPosZW.x/vProjectedPosZW.y;\ndepth=(depth+1.0)/2.0;\n#ifdef PANCAKE_DEPTH\ndepth=max(depth,0.0);\n#endif\n#ifdef USE_SLOPE_SCALED_BIAS\nvec2 dxdy=abs(vec2(dFdx(depth),dFdy(depth)));\nfloat bias=slopeScaledBias*max(dxdy.x,dxdy.y);\ndepth=clamp(depth+max(bias,1e-6),0.0,ONE_MINUS_EPS);\n#endif\n#if DEPTH_PACKING==3200\ngl_FragColor=vec4(vec3(1.0-depth),opacity);\n#elif DEPTH_PACKING==3201\ngl_FragColor=packDepthToRGBA(depth);\n#endif\n#else\ngl_FragColor=vec4(vViewPosition.z);\n#endif\n}",vertex$b="#define DISTANCE\nvarying vec3 vWorldPosition;\n#ifdef PANCAKE_DEPTH\nvarying vec4 vMVPPosition;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main(){\n#include <uv_vertex>\n#include <skinbase_vertex>\n#ifdef USE_DISPLACEMENTMAP\n#include <beginnormal_vertex>\n#include <morphnormal_vertex>\n#include <skinnormal_vertex>\n#endif\n#include <begin_vertex>\n#include <morphtarget_vertex>\n#include <skinning_vertex>\n#include <displacementmap_vertex>\n#include <project_vertex>\n#include <worldpos_vertex>\n#include <clipping_planes_vertex>\nvWorldPosition=worldPosition.xyz;\n#ifdef PANCAKE_DEPTH\nvec4 mvpPosition=projectionMatrix*mvPosition;\ngl_Position.z=max(mvpPosition.z,-1.0);\nvMVPPosition=mvpPosition;\n#endif\n}",fragment$b="#define DISTANCE\n#ifdef USE_SLOPE_SCALED_BIAS\nuniform float slopeScaledBias;\nconst float ONE_MINUS_EPS=0.9999999;\n#endif\nuniform vec3 referencePosition;\nuniform float nearDistance;\nuniform float farDistance;\nvarying vec3 vWorldPosition;\n#ifdef PANCAKE_DEPTH\nvarying vec4 vMVPPosition;\n#endif\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <clipping_planes_pars_fragment>\n#ifndef DISTANCE_SCALE\n#define DISTANCE_SCALE 1.0\n#endif\nvoid main (){\n#include <clipping_planes_fragment>\nvec4 diffuseColor=vec4(1.0);\n#include <map_fragment>\n#include <alphamap_fragment>\n#include <alphatest_fragment>\nfloat dist=length(vWorldPosition-referencePosition);\n#if DISTANCE_PACKING==3301\ndist=(dist-nearDistance)/(farDistance-nearDistance);\ndist=saturate(dist);\n#ifdef USE_SLOPE_SCALED_BIAS\nvec2 dxdy=abs(vec2(dFdx(dist),dFdy(dist)));\nfloat bias=slopeScaledBias*max(dxdy.x,dxdy.y);\ndist=clamp(dist+bias,0.0,ONE_MINUS_EPS);\n#endif\ngl_FragColor=packDepthToRGBA(dist);\n#elif DISTANCE_PACKING==3302\n#ifdef USE_SLOPE_SCALED_BIAS\nvec2 dxdy=abs(vec2(dFdx(dist),dFdy(dist)));\ndist+=slopeScaledBias*max(dxdy.x,dxdy.y);\n#endif\n#ifdef PANCAKE_DEPTH\nif (vMVPPosition.z<-1.0){\ndist=length(vec3(vMVPPosition.x*CAM_WIDTH,vMVPPosition.y*CAM_HEIGHT,nearDistance));\n}\n#endif\ngl_FragColor=vec4(dist*DISTANCE_SCALE,0.0,0.0,1.0);\n#endif\n}",vertex$a="uniform float scale;\nattribute float lineDistance;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main(){\nvLineDistance=scale*lineDistance;\n#include <color_vertex>\n#include <begin_vertex>\n#include <morphtarget_vertex>\n#include <project_vertex>\n#include <logdepthbuf_vertex>\n#include <clipping_planes_vertex>\n#include <fog_vertex>\n}",fragment$a="uniform vec3 diffuse;\nuniform float opacity;\nuniform float dashSize;\nuniform float totalSize;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main(){\n#include <clipping_planes_fragment>\nif (mod(vLineDistance,totalSize)>dashSize){\ndiscard;\n}\nvec3 outgoingLight=vec3(0.0);\nvec4 diffuseColor=vec4(diffuse,opacity);\n#include <logdepthbuf_fragment>\n#include <color_fragment>\noutgoingLight=diffuseColor.rgb;\n#include <output_fragment>\n#include <tonemapping_fragment>\n#include <encodings_fragment>\n#include <fog_fragment>\n#include <premultiplied_alpha_fragment>\n}",vertex$9="#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main(){\n#include <uv_vertex>\n#include <uv2_vertex>\n#include <color_vertex>\n#if defined (USE_ENVMAP)||defined (USE_SKINNING)\n#include <beginnormal_vertex>\n#include <morphnormal_vertex>\n#include <skinbase_vertex>\n#include <skinnormal_vertex>\n#include <defaultnormal_vertex>\n#endif\n#include <begin_vertex>\n#include <morphtarget_vertex>\n#include <skinning_vertex>\n#include <project_vertex>\n#include <logdepthbuf_vertex>\n#include <clipping_planes_vertex>\n#include <worldpos_vertex>\n#include <envmap_vertex>\n#include <fog_vertex>\n}",fragment$9="uniform vec3 diffuse;\nuniform float opacity;\n#ifndef FLAT_SHADED\nvarying vec3 vNormal;\n#endif\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main(){\n#include <clipping_planes_fragment>\nvec4 diffuseColor=vec4(diffuse,opacity);\n#include <logdepthbuf_fragment>\n#include <map_fragment>\n#include <color_fragment>\n#include <alphamap_fragment>\n#include <alphatest_fragment>\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\n#ifdef USE_LIGHTMAP\nvec4 lightMapTexel=texture2D(lightMap,vUv2);\nreflectedLight.indirectDiffuse+=lightMapTexel.rgb*lightMapIntensity*RECIPROCAL_PI;\n#else\nreflectedLight.indirectDiffuse+=vec3(1.0);\n#endif\n#include <aomap_fragment>\nreflectedLight.indirectDiffuse*=diffuseColor.rgb;\nvec3 outgoingLight=reflectedLight.indirectDiffuse;\n#include <envmap_fragment>\n#include <output_fragment>\n#include <tonemapping_fragment>\n#include <encodings_fragment>\n#include <fog_fragment>\n#include <premultiplied_alpha_fragment>\n#include <dithering_fragment>\n}",vertex$8="#define LAMBERT\nvarying vec3 vViewPosition;\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main(){\n#include <uv_vertex>\n#include <uv2_vertex>\n#include <color_vertex>\n#include <beginnormal_vertex>\n#include <morphnormal_vertex>\n#include <skinbase_vertex>\n#include <skinnormal_vertex>\n#include <defaultnormal_vertex>\n#include <normal_vertex>\n#include <begin_vertex>\n#include <morphtarget_vertex>\n#include <skinning_vertex>\n#include <displacementmap_vertex>\n#include <project_vertex>\n#include <logdepthbuf_vertex>\n#include <clipping_planes_vertex>\nvViewPosition=-mvPosition.xyz;\n#include <worldpos_vertex>\n#include <envmap_vertex>\n#include <shadowmap_vertex>\n#include <fog_vertex>\n}",fragment$8="#define LAMBERT\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\n#if defined(SHADOWMAP_TYPE_ESM)||defined(USE_ENVMAP)\nuniform mat4 invViewMatrix;\n#endif\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_lambert_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main(){\n#include <clipping_planes_fragment>\nvec4 diffuseColor=vec4(diffuse,opacity);\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\nvec3 totalEmissiveRadiance=emissive;\n#include <logdepthbuf_fragment>\n#include <map_fragment>\n#include <color_fragment>\n#include <alphamap_fragment>\n#include <alphatest_fragment>\n#include <normal_fragment_begin>\n#include <normal_fragment_maps>\n#include <emissivemap_fragment>\n#include <lights_lambert_fragment>\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#include <aomap_fragment>\nvec3 outgoingLight=reflectedLight.directDiffuse+reflectedLight.indirectDiffuse+totalEmissiveRadiance;\n#include <envmap_fragment>\n#include <output_fragment>\n#include <tonemapping_fragment>\n#include <encodings_fragment>\n#include <fog_fragment>\n#include <premultiplied_alpha_fragment>\n#include <dithering_fragment>\n}",vertex$7="#define NORMAL\n#if defined(FLAT_SHADED)||defined(USE_BUMPMAP)||defined(TANGENTSPACE_NORMALMAP)\nvarying vec3 vViewPosition;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main(){\n#include <uv_vertex>\n#include <beginnormal_vertex>\n#include <morphnormal_vertex>\n#include <skinbase_vertex>\n#include <skinnormal_vertex>\n#include <defaultnormal_vertex>\n#include <normal_vertex>\n#include <begin_vertex>\n#include <morphtarget_vertex>\n#include <skinning_vertex>\n#include <displacementmap_vertex>\n#include <project_vertex>\n#include <logdepthbuf_vertex>\n#include <clipping_planes_vertex>\n#if defined(FLAT_SHADED)||defined(USE_BUMPMAP)||defined(TANGENTSPACE_NORMALMAP)\nvViewPosition=-mvPosition.xyz;\n#endif\n}",fragment$7="#define NORMAL\nuniform float opacity;\n#if defined(FLAT_SHADED)||defined(USE_BUMPMAP)||defined(TANGENTSPACE_NORMALMAP)\nvarying vec3 vViewPosition;\n#endif\n#include <packing>\n#include <uv_pars_fragment>\n#include <normal_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main(){\n#include <clipping_planes_fragment>\n#include <logdepthbuf_fragment>\n#include <normal_fragment_begin>\n#include <normal_fragment_maps>\ngl_FragColor=vec4(packNormalToRGB(normal),opacity);\n#ifdef OPAQUE\ngl_FragColor.a=1.0;\n#endif\n}",vertex$6="#define STANDARD\nvarying vec3 vViewPosition;\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\n#include <plane_reflection_pars_vertex>\nvoid main(){\n#include <uv_vertex>\n#include <uv2_vertex>\n#include <color_vertex>\n#include <beginnormal_vertex>\n#include <morphnormal_vertex>\n#include <skinbase_vertex>\n#include <skinnormal_vertex>\n#include <defaultnormal_vertex>\n#include <normal_vertex>\n#include <begin_vertex>\n#include <morphtarget_vertex>\n#include <skinning_vertex>\n#include <displacementmap_vertex>\n#include <project_vertex>\n#include <plane_reflection_vertex>\n#include <logdepthbuf_vertex>\n#include <clipping_planes_vertex>\nvViewPosition=-mvPosition.xyz;\n#include <worldpos_vertex>\n#include <shadowmap_vertex>\n#include <fog_vertex>\n}",fragment$6="#define STANDARD\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\n#if defined(SHADOWMAP_TYPE_ESM)||defined(USE_ENVMAP)\nuniform mat4 invViewMatrix;\n#endif\n#if defined(USE_PLANE_REFLECTION)\nuniform mat4 modelMatrix;\n#endif\nvarying vec3 vViewPosition;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <bsdfs>\n#include <cube_uv_reflection_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_physical_pars_fragment>\n#include <fog_pars_fragment>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_physical_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <roughnessmap_pars_fragment>\n#include <metalnessmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\n#include <plane_reflection_pars_fragment>\n#include <oit_weighted_pars_fragment>\nvoid main(){\n#include <clipping_planes_fragment>\nvec4 diffuseColor=vec4(diffuse,opacity);\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\nvec3 totalEmissiveRadiance=emissive;\n#include <logdepthbuf_fragment>\n#include <map_fragment>\n#include <color_fragment>\n#include <alphamap_fragment>\n#include <alphatest_fragment>\n#include <roughnessmap_fragment>\n#include <metalnessmap_fragment>\n#include <normal_fragment_begin>\n#include <normal_fragment_maps>\n#include <emissivemap_fragment>\n#include <lights_physical_fragment>\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#include <aomap_fragment>\nvec3 totalDiffuse=reflectedLight.directDiffuse+reflectedLight.indirectDiffuse;\nvec3 totalSpecular=reflectedLight.directSpecular+reflectedLight.indirectSpecular;\nvec3 outgoingLight=totalDiffuse+totalSpecular+totalEmissiveRadiance;\n#include <output_fragment>\n#include <tonemapping_fragment>\n#include <encodings_fragment>\n#include <fog_fragment>\n#include <premultiplied_alpha_fragment>\n#include <dithering_fragment>\n#include <oit_weighted_fragment>\n}",vertex$5="uniform float size;\nuniform float scale;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main(){\n#include <color_vertex>\n#include <begin_vertex>\n#include <morphtarget_vertex>\n#include <project_vertex>\ngl_PointSize=size;\n#ifdef USE_SIZEATTENUATION\nbool isPerspective=isPerspectiveMatrix(projectionMatrix);\nif (isPerspective)gl_PointSize*=(scale/- mvPosition.z);\n#endif\n#include <logdepthbuf_vertex>\n#include <clipping_planes_vertex>\n#include <worldpos_vertex>\n#include <fog_vertex>\n}",fragment$5="uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <color_pars_fragment>\n#include <map_particle_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main(){\n#include <clipping_planes_fragment>\nvec3 outgoingLight=vec3(0.0);\nvec4 diffuseColor=vec4(diffuse,opacity);\n#include <logdepthbuf_fragment>\n#include <map_particle_fragment>\n#include <color_fragment>\n#include <alphatest_fragment>\noutgoingLight=diffuseColor.rgb;\n#include <output_fragment>\n#include <tonemapping_fragment>\n#include <encodings_fragment>\n#include <fog_fragment>\n#include <premultiplied_alpha_fragment>\n}",vertex$4="#include <common>\n#ifdef USE_SHADOWMAP\nvarying vec3 vViewPosition;\n#endif\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\nvoid main(){\n#include <beginnormal_vertex>\n#include <morphnormal_vertex>\n#include <skinbase_vertex>\n#include <skinnormal_vertex>\n#include <defaultnormal_vertex>\n#include <begin_vertex>\n#include <morphtarget_vertex>\n#include <skinning_vertex>\n#include <project_vertex>\n#include <worldpos_vertex>\n#include <shadowmap_vertex>\n#include <fog_vertex>\n#ifdef USE_SHADOWMAP\nvViewPosition=-mvPosition.xyz;\n#endif\n}",fragment$4="uniform vec3 color;\nuniform float opacity;\n#ifdef USE_SHADOWMAP\nvarying vec3 vViewPosition;\n#ifdef SHADOWMAP_TYPE_ESM\nuniform mat4 invViewMatrix;\n#endif\n#endif\n#include <common>\n#include <packing>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\nvoid main(){\ngl_FragColor=vec4(color,opacity*(1.0-getShadowMask()));\n#include <tonemapping_fragment>\n#include <encodings_fragment>\n#include <fog_fragment>\n}",vertex$3="uniform float rotation;\nuniform vec2 center;\n#include <common>\n#include <uv_pars_vertex>\n#include <fog_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main(){\n#include <uv_vertex>\nvec4 mvPosition=modelViewMatrix*vec4(0.0,0.0,0.0,1.0);\nvec2 scale;\nscale.x=length(vec3(modelMatrix[0].x,modelMatrix[0].y,modelMatrix[0].z));\nscale.y=length(vec3(modelMatrix[1].x,modelMatrix[1].y,modelMatrix[1].z));\n#ifndef USE_SIZEATTENUATION\nbool isPerspective=isPerspectiveMatrix(projectionMatrix);\nif (isPerspective)scale*=-mvPosition.z;\n#endif\nvec2 alignedPosition=(position.xy-(center-vec2(0.5)))*scale;\nvec2 rotatedPosition;\nrotatedPosition.x=cos(rotation)*alignedPosition.x-sin(rotation)*alignedPosition.y;\nrotatedPosition.y=sin(rotation)*alignedPosition.x+cos(rotation)*alignedPosition.y;\nmvPosition.xy+=rotatedPosition;\ngl_Position=projectionMatrix*mvPosition;\n#include <logdepthbuf_vertex>\n#include <clipping_planes_vertex>\n#include <fog_vertex>\n}",fragment$3="uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main(){\n#include <clipping_planes_fragment>\nvec3 outgoingLight=vec3(0.0);\nvec4 diffuseColor=vec4(diffuse,opacity);\n#include <logdepthbuf_fragment>\n#include <map_fragment>\n#include <alphamap_fragment>\n#include <alphatest_fragment>\noutgoingLight=diffuseColor.rgb;\n#include <output_fragment>\n#include <tonemapping_fragment>\n#include <encodings_fragment>\n#include <fog_fragment>\n}",vertex$2="#define MASK\n#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nuniform mat4 textureMatrix;\nvarying vec3 vViewPosition;\nvarying vec4 projTexCoord;\nvoid main(){\n#include <uv_vertex>\n#include <skinbase_vertex>\n#ifdef USE_DISPLACEMENTMAP\n#include <beginnormal_vertex>\n#include <morphnormal_vertex>\n#include <skinnormal_vertex>\n#endif\n#include <begin_vertex>\n#include <morphtarget_vertex>\n#include <skinning_vertex>\n#include <displacementmap_vertex>\n#include <project_vertex>\nvViewPosition=-mvPosition.xyz;\n#include <worldpos_vertex>\nprojTexCoord=textureMatrix*worldPosition;\n#include <logdepthbuf_vertex>\n#include <clipping_planes_vertex>\n}",fragment$2="#define MASK\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nuniform float opacity;\nuniform sampler2D depthTexture;\nuniform vec2 cameraNearFar;\nvarying vec3 vViewPosition;\nvarying vec4 projTexCoord;\nvoid main(){\n#include <clipping_planes_fragment>\nvec4 diffuseColor=vec4(1.0);\ndiffuseColor.a=opacity;\n#include <map_fragment>\n#include <alphamap_fragment>\n#include <alphatest_fragment>\n#include <logdepthbuf_fragment>\nfloat depth=unpackRGBAToDepth(texture2DProj(depthTexture,projTexCoord));\nfloat viewZ;\nif (isOrthographic)\nviewZ=-orthographicDepthToViewZ(depth,cameraNearFar.x,cameraNearFar.y);\nelse\nviewZ=-perspectiveDepthToViewZ(depth,cameraNearFar.x,cameraNearFar.y);\nfloat depthTest=(vViewPosition.z>viewZ)?1.0:0.0;\ngl_FragColor=vec4(0.0,depthTest,1.0,0.0);\n}",vertex$1="#define NODE\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\nvarying vec3 vNormal;\n#endif\n#include <common>\n#include <displacementmap_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\n#include <plane_reflection_pars_vertex>\n#if defined(NODE_REFLECT_REFRACT_MX)||defined(NODE_BITMAP_ENV_MX)||defined(NODE_BUMP_BL)||defined(NODE_PHY_SUN_SKY_ENV_MX)||defined(NODE_ENV_SPHERE_MY)||defined(NODE_UV_PROJECTION_AR)||defined(NODE_SUB_TRANSFORM_MX)||defined(NODE_SUB_TRANSFORM_MY)\nvarying vec3 vWorldPosition;\n#endif\n#include <node_pars_vertex>\nvoid main(){\n#include <beginnormal_vertex>\n#include <morphnormal_vertex>\n#include <skinbase_vertex>\n#include <skinnormal_vertex>\n#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\nvNormal=normalize(transformedNormal);\n#endif\n#include <begin_vertex>\n#include <morphtarget_vertex>\n#include <skinning_vertex>\n#include <displacementmap_vertex>\n#include <project_vertex>\n#include <plane_reflection_vertex>\n#include <logdepthbuf_vertex>\n#include <clipping_planes_vertex>\nvViewPosition=-mvPosition.xyz;\n#include <worldpos_vertex>\n#include <shadowmap_vertex>\n#include <fog_vertex>\n#if defined(NODE_REFLECT_REFRACT_MX)||defined(NODE_BITMAP_ENV_MX)||defined(NODE_BUMP_BL)||defined(NODE_PHY_SUN_SKY_ENV_MX)||defined(NODE_ENV_SPHERE_MY)||defined(NODE_UV_PROJECTION_AR)||defined(NODE_SUB_TRANSFORM_MX)||defined(NODE_SUB_TRANSFORM_MY)\nvWorldPosition=worldPosition.xyz;\n#endif\n#include <node_vertex>\n}",fragment$1="#define NODE\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <bsdfs>\n#include <cube_uv_reflection_fragment>\n#include <envmap_common_pars_fragment>\n#if defined(NODE_NEW_GEOMETRY_BL)||defined(NODE_VECT_TRANSFORM_BL)||defined(NODE_TEX_COORD_BL)||defined(NODE_NORMAL_MAP_BL)||defined(NODE_LAYER_WEIGHT_BL)||defined(NODE_FRESNEL_BL)||defined(NODE_BUMP_BL)||defined(NODE_BSDF_GLASS_BL)||defined(NODE_BSDF_PRINCIPLED_BL)||defined(NODE_TANGENT_BL)||defined(NODE_BITMAP_MX)||defined(NODE_GRADIENT_MX)||defined(NODE_GRADIENT_RAMP_MX)||defined(NODE_NOISE_MX)||defined(NODE_SUB_TRANSFORM_MX)||defined(NODE_SUB_TRANSFORM_MY)||defined(NODE_SAMPLER_INFO_MY)||defined(NODE_INCIDENT)||defined(NODE_POSITION)||defined(NODE_NORMAL)||defined(USE_OSL)||defined(USE_ENVMAP)||defined(SHADOWMAP_TYPE_ESM)&&(defined(NODE_BSDF_DIFFUSE_BL)||defined(NODE_EEVEE_SPECULAR_BL)||defined(NODE_BSDF_GLOSSY_BL)||defined(NODE_BSDF_REFRACTION_BL)||defined(NODE_MATERIAL_MX)||defined(NODE_PHYSICAL_MX)||defined(NODE_STANDARD_SURFACE_AR)||defined(NODE_SHADOW_MATTE_AR))\nuniform mat4 invViewMatrix;\n#endif\n#include <envmap_physical_pars_fragment>\n#include <fog_pars_fragment>\n#include <lights_pars_begin>\n#include <lights_node_pars_fragment>\n#include <lights_node_gtao_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\n#if defined(USE_SSR)\nuniform mat4 projectionMatrix;\n#endif\n#if defined(NODE_VECT_TRANSFORM_BL)||defined(NODE_TEX_COORD_BL)||defined(NODE_NEW_GEOMETRY_BL)||defined(NODE_TANGENT_BL)||defined(NODE_OBJECT_INFO_BL)||defined(NODE_BITMAP_MX)||defined(NODE_GRADIENT_MX)||defined(NODE_GRADIENT_RAMP_MX)||defined(NODE_NOISE_MX)||defined(NODE_SAMPLER_INFO_MY)||defined(NODE_TRANSFORM_MY)||defined(USE_OSL)||defined(USE_PLANE_REFLECTION)||defined(NODE_UV_PROJECTION_AR)||defined(NODE_SUB_TRANSFORM_MX)||defined(NODE_SUB_TRANSFORM_MY)\nuniform mat4 modelMatrix;\nuniform mat4 invModelMatrix;\n#endif\n#if defined(NODE_VECT_TRANSFORM_BL)||defined(NODE_NORMAL_MAP_BL)||defined(NODE_NORMAL_BUMP_MX)||defined(NODE_BUMP_2D_MY)||defined(NODE_SAMPLER_INFO_MY)\nuniform mat4 modelViewMatrix;\n#endif\n#if defined(NODE_TEX_IMAGE_BL)\nuniform mat3 normalMatrix;\n#endif\n#if defined(NODE_TEX_COORD_BL)||defined(NODE_NEW_GEOMETRY_BL)||defined(NODE_TANGENT_BL)\nuniform vec3 boundingBoxMin;\nuniform vec3 boundingBoxMax;\n#endif\n#if defined(NODE_REFLECT_REFRACT_MX)||defined(NODE_BITMAP_ENV_MX)||defined(NODE_BUMP_BL)||defined(NODE_PHY_SUN_SKY_ENV_MX)||defined(NODE_ENV_SPHERE_MY)||defined(NODE_UV_PROJECTION_AR)||defined(NODE_SUB_TRANSFORM_MX)||defined(NODE_SUB_TRANSFORM_MY)\nvarying vec3 vWorldPosition;\n#endif\n#if defined(NODE_TEX_COORD_BL)\nuniform vec2 viewWidthHeight;\n#endif\n#include <ssr_pars_fragment>\n#include <plane_reflection_pars_fragment>\n#include <node_common_frag>\n#include <node_pars_fragment>\n#include <oit_weighted_pars_fragment>\nvoid main(){\n#include <clipping_planes_fragment>\n#include <logdepthbuf_fragment>\n#include <normal_fragment_begin>\nvec4 outgoingLight=vec4(0.0);\n#include <node_fragment>\n#if WORLD_NODES==1\noutgoingLight.a=1.0;\n#endif\n#ifdef USE_ALPHATEST\nif (outgoingLight.a<alphaTest)\ndiscard;\nelse\noutgoingLight.a=1.0;\n#endif\n#if defined(OPAQUE)&&!(defined(NODE_HOLDOUT_BL)||defined(NODE_MATTE_SHADOW_MX)||defined(NODE_SHADOW_MATTE_AR))\noutgoingLight.a=1.0;\n#endif\ngl_FragColor=vec4(outgoingLight);\n#include <tonemapping_fragment>\n#include <encodings_fragment>\n#include <fog_fragment>\n#include <premultiplied_alpha_fragment>\n#include <dithering_fragment>\n#include <normal_output_fragment>\n#include <oit_weighted_fragment>\n}";var lights_node_pars_fragment="\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\nvarying vec3 vNormal;\n#endif\nstruct NodeMaterial {\nvec3 diffuseColor;\nfloat roughness;\nvec3 specularColor;\nfloat specularF90;\nvec3 fresnelRefl90;\nvec3 refractionColor;\nfloat refractionRoughness;\nfloat refractionIOR;\n#ifdef USE_CLEARCOAT\nfloat clearcoat;\nfloat clearcoatRoughness;\nvec3 clearcoatF0;\nfloat clearcoatF90;\n#endif\n#ifdef USE_SHEEN\nvec3 sheenColor;\nfloat sheenRoughness;\n#endif\n};\nvec3 clearcoatSpecular=vec3(0.0);\nvec3 sheenSpecular=vec3(0.0);\nfloat IBLSheenBRDF(const in vec3 normal,const in vec3 viewDir,const in float roughness){\nfloat dotNV=saturate(dot(normal,viewDir));\nfloat r2=roughness*roughness;\nfloat a=roughness<0.25?-339.2*r2+161.4*roughness-25.9:-8.48*r2+14.3*roughness-9.95;\nfloat b=roughness<0.25?44.0*r2-23.7*roughness+3.26:1.97*r2-3.27*roughness+0.72;\nfloat DG=exp(a*dotNV+b)+(roughness<0.25?0.0:0.1*(roughness-0.25));\nreturn saturate(DG*RECIPROCAL_PI);\n}\n#if NUM_RECT_AREA_LIGHTS>0\nvoid RE_Direct_RectArea_Node(const in RectAreaLight rectAreaLight,const in GeometricContext geometry,const in NodeMaterial material,inout ReflectedLight reflectedLight){\nvec3 normal=geometry.normal;\nvec3 viewDir=geometry.viewDir;\nvec3 position=geometry.position;\nvec3 lightPos=rectAreaLight.position;\nvec3 halfWidth=rectAreaLight.halfWidth;\nvec3 halfHeight=rectAreaLight.halfHeight;\nvec3 lightColor=rectAreaLight.color;\nfloat roughness=material.roughness;\nvec3 rectCoords[4];\nrectCoords[0]=lightPos+halfWidth-halfHeight;\nrectCoords[1]=lightPos-halfWidth-halfHeight;\nrectCoords[2]=lightPos-halfWidth+halfHeight;\nrectCoords[3]=lightPos+halfWidth+halfHeight;\nvec2 uv=LTC_Uv(normal,viewDir,roughness);\nvec4 t1=texture2D(ltc_1,uv);\nvec4 t2=texture2D(ltc_2,uv);\nmat3 mInv=mat3(vec3(t1.x,0,t1.y),vec3( 0,1,0),vec3(t1.z,0,t1.w)\n);\nvec3 fresnel=(material.specularColor*t2.x+(vec3(1.0)-material.specularColor)*t2.y);\nreflectedLight.directSpecular+=lightColor*fresnel*LTC_Evaluate(normal,viewDir,position,mInv,rectCoords);\nreflectedLight.directDiffuse+=lightColor*material.diffuseColor*LTC_Evaluate(normal,viewDir,position,mat3(1.0),rectCoords);\n}\n#endif\nvoid RE_Direct_Node(const in IncidentLight directLight,const in GeometricContext geometry,const in NodeMaterial material,inout ReflectedLight reflectedLight){\nfloat dotNL=saturate(dot(geometry.normal,directLight.direction));\nvec3 irradiance=dotNL*directLight.color;\n#ifdef USE_CLEARCOAT\nfloat dotNLcc=saturate(dot(geometry.clearcoatNormal,directLight.direction));\nvec3 ccIrradiance=dotNLcc*directLight.color;\nclearcoatSpecular+=ccIrradiance*BRDF_GGX(directLight.direction,geometry.viewDir,geometry.clearcoatNormal,material.clearcoatF0,material.clearcoatF90,material.clearcoatRoughness);\n#endif\n#ifdef USE_SHEEN\nsheenSpecular+=irradiance*BRDF_Sheen(directLight.direction,geometry.viewDir,geometry.normal,material.sheenColor,material.sheenRoughness);\n#endif\nreflectedLight.directSpecular+=irradiance*BRDF_GGX(directLight.direction,geometry.viewDir,geometry.normal,material.specularColor,material.specularF90,material.roughness);\nreflectedLight.directDiffuse+=irradiance*BRDF_Lambert(material.diffuseColor);\n}\nvoid RE_IndirectDiffuse_Node(const in vec3 irradiance,const in GeometricContext geometry,const in NodeMaterial material,inout ReflectedLight reflectedLight){\nreflectedLight.indirectDiffuse+=irradiance*BRDF_Lambert(material.diffuseColor);\n}\nvoid RE_IndirectSpecular_Node(const in vec3 radiance,const in vec3 irradiance,const in vec3 clearcoatRadiance,const in GeometricContext geometry,const in NodeMaterial material,inout ReflectedLight reflectedLight){\n#ifdef USE_CLEARCOAT\nclearcoatSpecular+=clearcoatRadiance*BRDF_Specular_GGX_Environment(geometry.viewDir,geometry.clearcoatNormal,material.clearcoatF0,vec3(material.clearcoatF90),material.clearcoatRoughness);\n#endif\n#ifdef USE_SHEEN\nsheenSpecular+=irradiance*material.sheenColor*IBLSheenBRDF(geometry.normal,geometry.viewDir,material.sheenRoughness);\n#endif\n#ifdef MT_BLENDER\nvec3 specEnv=BRDF_Specular_GGX_Environment(geometry.viewDir,geometry.normal,material.specularColor,material.fresnelRefl90,material.roughness);\n#elif defined(MT_MAX)\nfloat alphaEnv=pow2(pow2(material.roughness));\nvec3 specEnv=material.specularColor/(1.0-alphaEnv+PI*alphaEnv);\n#elif defined(MT_MAYA)\nvec3 specEnv=BRDF_Specular_GGX_Environment(geometry.viewDir,geometry.normal,material.specularColor,material.fresnelRefl90,material.roughness);\n#else\nvec3 specEnv=vec3(1.0);\n#endif\nreflectedLight.indirectSpecular+=radiance*specEnv;\n}\nvoid RE_Refraction_Node(const vec3 refraction,const NodeMaterial material,inout vec3 refractedLight){\nrefractedLight+=refraction*material.refractionColor;\n}\nvoid RE_DirectDiffuseOnly_Node(const in IncidentLight directLight,const in GeometricContext geometry,const in NodeMaterial material,inout ReflectedLight reflectedLight){\nfloat dotNL=saturate(dot(geometry.normal,directLight.direction));\nvec3 irradiance=dotNL*directLight.color;\nreflectedLight.directDiffuse+=irradiance*BRDF_Lambert(material.diffuseColor);\n}\nvoid RE_IndirectDiffuse_Empty(const in vec3 irradiance,const in GeometricContext geometry,const in NodeMaterial material,inout ReflectedLight reflectedLight){}\n#define RE_Direct_RectArea RE_Direct_RectArea_Node",lights_node_gtao_pars_fragment="#ifdef USE_GTAO\nuniform sampler2D gtaoMap;\nuniform vec2 currResolution;\nfloat calcGTAOVisibilityFix(vec3 viewDir,vec3 normal){\nfloat slopeCoeff=saturate(dot(viewDir,normal));\nreturn pow(2.0/(slopeCoeff+1.0),log2(PI)-1.0);\n}\nfloat calcSolidAngle(float radiusAngle){\nreturn PI2*(1.0-cos(radiusAngle));\n}\nfloat calcSolidAnglesIntersectionApprox(float radiusAngle0,float radiusAngle1,float distanceAngle){\nfloat rp=radiusAngle0,rl=radiusAngle1,d=distanceAngle;\nfloat rDiff=abs(rp-rl);\nreturn PI2*(1.0-cos(min(rp,rl)))*smoothstep(0.0,1.0,1.0 -\n(d-rDiff)/(rp+rl-rDiff));\n}\nfloat calcGTSOVisibility(float aoVisibility,vec3 bentNormal,vec3 viewDir,vec3 normal,float roughness){\naoVisibility=saturate(aoVisibility*calcGTAOVisibilityFix(viewDir,normal));\nfloat radiusAngleVisCone=acos(clamp(sqrt(1.0-aoVisibility),-1.0,1.0));\nfloat radiusAngleSpecCone=acos(clamp(exp2(-3.32193*pow2(roughness)),-1.0,1.0));\nradiusAngleSpecCone=max(0.001,radiusAngleSpecCone);\nvec3 specularConeAxis=-reflect(viewDir,normal);\nfloat distanceAngle=acos(clamp(dot(bentNormal,specularConeAxis),-1.0,1.0));\nfloat solidAngleIntersection=calcSolidAnglesIntersectionApprox(radiusAngleVisCone,radiusAngleSpecCone,distanceAngle);\nfloat solidAngleSpecular=calcSolidAngle(radiusAngleSpecCone);\nfloat specVisibility=solidAngleIntersection/solidAngleSpecular;\nreturn mix(specVisibility,1.0,aoVisibility);\n}\n#endif",lights_fragment_gtso="#ifdef USE_GTAO\nreflectedLight.indirectSpecular*=calcGTSOVisibility(gtaoVisibility,gtaoBentNormal,gtaoViewDir,gtaoNormal,gtaoRoughness);\n#endif",normal_output_fragment="#if NORMAL_OUTPUT==1\ngl_FragColor=vec4(packNormalToRGB(normal),gl_FragColor.a);\n#endif",ssr_pars_fragment="#ifdef USE_SSR\nuniform sampler2D ssrSourceBuffer;\nuniform sampler2D ssrDepthBuffer;\nuniform sampler2D ssrBackfaceDepthBuffer;\nuniform mat4 invProjectionMatrix;\nuniform float ssrStride;\nuniform float ssrJitter;\nuniform float ssrMaxDistance;\n#ifdef USE_SSR_REFRACT\n#define STEPS_FADE_AMOUNT 0.1\n#define SCREEN_FADE_THRESHOLD 0.6\n#else\n#define STEPS_FADE_AMOUNT 1.0\n#define SCREEN_FADE_THRESHOLD 0.6\n#endif\nvec3 deproject(vec3 p){\nvec4 res=invProjectionMatrix*vec4(p,1);\nreturn res.xyz/res.w;\n}\nbool doesIntersect(float rayzmax,float rayzmin,ivec2 uv){\nfloat sceneZMin=texelFetch(ssrDepthBuffer,uv,0).r;\nif (sceneZMin==0.0)\nreturn false;\n#ifdef USE_SSR_REFRACT\nreturn rayzmax<=sceneZMin;\n#else\nfloat sceneZMax=texelFetch(ssrBackfaceDepthBuffer,uv,0).r;\nif (sceneZMax==0.0)\nsceneZMax=-1e6;\nreturn rayzmin>=sceneZMax&&rayzmax<=sceneZMin;\n#endif\n}\nfloat distanceSquared(vec2 a,vec2 b){\na-=b;\nreturn dot(a,a);\n}\nvoid swapIfBigger(inout float a,inout float b){\nif (a>b){\nfloat t=a;\na=b;\nb=t;\n}\n}\nvec3 computeSSR(vec3 color,vec3 normal,float ior){\nvec3 vpos=-vViewPosition;\n#ifdef USE_SSR_REFRACT\nvec3 dir=normalize(refract(normalize(vpos),normalize(normal),1.0/ior));\n#else\nvec3 dir=normalize(reflect(normalize(vpos),normalize(normal)));\n#endif\nfloat maxDist=ssrMaxDistance;\nfloat nearClip=deproject(vec3(0,0,-1)).z;\nfloat rayLength=(vpos.z+dir.z*maxDist)>nearClip?(nearClip-vpos.z)/dir.z:maxDist;\nvec3 csOrig=vpos;\nvec3 csEndPoint=csOrig+dir*rayLength;\nvec4 H0=projectionMatrix*vec4(csOrig,1.0);\nvec4 H1=projectionMatrix*vec4(csEndPoint,1.0);\nfloat k0=1.0/H0.w,k1=1.0/H1.w;\nvec3 Q0=csOrig.xyz*k0,Q1=csEndPoint.xyz*k1;\nvec2 P0=H0.xy*k0,P1=H1.xy*k1;\nP0=P0*0.5+vec2(0.5),P1=P1*0.5+vec2(0.5);\n#ifndef SSR_SIMPLE_REFRACT\nvec2 ssrResolution=vec2(textureSize(ssrDepthBuffer,0));\nP0*=ssrResolution,P1*=ssrResolution;\nP1+=vec2((distanceSquared(P0,P1)<0.0001)?0.01:0.0);\nvec2 delta=P1-P0;\nbool permute=false;\nif (abs(delta.x)<abs(delta.y)){\npermute=true;\ndelta=delta.yx;\nP0=P0.yx;\nP1=P1.yx;\n}\nfloat stepDir=sign(delta.x);\nfloat invdx=stepDir/delta.x;\nvec3 dQ=(Q1-Q0)*invdx;\nfloat dk=(k1-k0)*invdx;\nvec2 dP=vec2(stepDir,delta.y*invdx);\nfloat pixelStride=ssrStride;\nfloat jitterMod=(gl_FragCoord.x+gl_FragCoord.y)*0.25;\nvec4 PQK=vec4(P0,Q0.z,k0);\nvec4 dPQK=vec4(dP,dQ.z,dk);\ndPQK*=pixelStride;\nPQK+=dPQK*mod(jitterMod,1.0)*ssrJitter;\nfloat end=P1.x*stepDir;\nfloat prevZMaxEstimate=PQK.z/PQK.w;\nfloat rayZMin=prevZMaxEstimate,rayZMax=prevZMaxEstimate;\nfloat stepped=0.0;\nvec2 hitPixel,hitUV;\nbool intersected=false;\nfor (float stepCount=1.0;stepCount<=float(MAX_STEPS);stepCount ++){\nrayZMin=prevZMaxEstimate;\nrayZMax=(dPQK.z*0.5+PQK.z)/(dPQK.w*0.5+PQK.w);\nprevZMaxEstimate=rayZMax;\nswapIfBigger(rayZMax,rayZMin);\nstepped=stepCount;\nhitPixel=(permute?PQK.yx: PQK.xy);\nhitUV=hitPixel/ssrResolution;\nintersected=doesIntersect(rayZMax,rayZMin,ivec2(hitPixel));\nif (intersected||(PQK.x*stepDir)>end)\nbreak;\nPQK+=dPQK;\n}\nif (intersected&&pixelStride>1.0){\nPQK-=dPQK;\ndPQK/=ssrStride;\nfloat ogStride=pixelStride*0.5;\nfloat currStride=pixelStride;\nprevZMaxEstimate=PQK.z/PQK.w;\nrayZMin=prevZMaxEstimate,rayZMax=prevZMaxEstimate;\nfor (int j=0;j<int(BINARY_SEARCH_ITERATIONS);j++){\nPQK+=dPQK*currStride;\nrayZMin=prevZMaxEstimate;\nrayZMax=(dPQK.z*0.5+PQK.z)/(dPQK.w*0.5+PQK.w);\nprevZMaxEstimate=rayZMax;\nswapIfBigger(rayZMax,rayZMin);\nvec2 newPixel=(permute?PQK.yx: PQK.xy);\nvec2 newUV=newPixel/ssrResolution;\nogStride*=0.5;\nif (doesIntersect(rayZMax,rayZMin,ivec2(newPixel))){\nhitUV=newUV;\ncurrStride=-ogStride;\n} else {\ncurrStride=ogStride;\n}\n}\n}\nvec3 result=color;\nif (intersected){\nvec4 col=texture(ssrSourceBuffer,hitUV);\nvec2 ndc=abs(hitUV*2.0-1.0);\nfloat maxndc=max(ndc.x,ndc.y);\nfloat fadeVal =\n(1.0-(max(0.0,maxndc-SCREEN_FADE_THRESHOLD)/(1.0-SCREEN_FADE_THRESHOLD)))*\n(1.0-STEPS_FADE_AMOUNT*(stepped/float(MAX_STEPS)));\ncol.a=fadeVal;\nresult=mix(result,col.rgb,col.a);\n}\n#else\nvec3 result=texture(ssrSourceBuffer,P1).xyz;\n#endif\nreturn result;\n}\n#endif",plane_reflection_pars_vertex="#ifdef USE_PLANE_REFLECTION\nuniform mat4 planeReflTextureMatrix;\nvarying vec4 vPlaneReflUv;\n#endif",plane_reflection_pars_fragment="#ifdef USE_PLANE_REFLECTION\nuniform sampler2D planeReflTexture;\nuniform mat4 planeReflTextureMatrix;\nuniform vec3 planeReflDir;\nuniform vec3 planeReflBoundingBoxMin;\nuniform vec3 planeReflBoundingBoxMax;\nuniform mat4 planeReflInvModelMatrix;\nuniform float planeReflFalloff;\nvarying vec4 vPlaneReflUv;\nvec3 computePlaneReflection(vec3 radiance,float roughness,vec3 position,vec3 normal,mat4 modelMatrix){\nvec3 posRefl=(planeReflInvModelMatrix*invViewMatrix*vec4(position,1.0)).xyz;\nif (any(lessThan(posRefl,planeReflBoundingBoxMin))||any(greaterThan(posRefl,planeReflBoundingBoxMax)))\nreturn radiance;\nvec3 norWorld=transformDirection(normal,invViewMatrix);\nvec3 uvNormalOffsetScale;\nuvNormalOffsetScale.x=length(vec3(modelMatrix[0].xyz));\nuvNormalOffsetScale.y=length(vec3(modelMatrix[1].xyz));\nuvNormalOffsetScale.z=length(vec3(modelMatrix[2].xyz));\nvec4 uvNormalOffset=planeReflTextureMatrix*vec4((norWorld-planeReflDir)*uvNormalOffsetScale,0.0);\nvec3 result=texture2DProj(planeReflTexture,vPlaneReflUv+uvNormalOffset).rgb;\nfloat falloffFactor;\nif (planeReflFalloff<EPSILON)\nfalloffFactor=0.0;\nelse if (posRefl.y>0.0)\nfalloffFactor=1.0-clamp((planeReflBoundingBoxMax.y-posRefl.y)/(planeReflBoundingBoxMax.y*(planeReflFalloff)),0.0,1.0);\nelse\nfalloffFactor=1.0-clamp((planeReflBoundingBoxMin.y-posRefl.y)/(planeReflBoundingBoxMin.y*(planeReflFalloff)),0.0,1.0);\nresult=mix(result,radiance,falloffFactor);\nresult=mix(result,radiance,(roughness<0.0526)?0.0:saturate(10.0*roughness));\nreturn result;\n}\n#endif",plane_reflection_vertex="#ifdef USE_PLANE_REFLECTION\nvPlaneReflUv=planeReflTextureMatrix*modelMatrix*vec4(transformed,1.0);\n#endif",oit_weighted_pars_fragment="#ifdef USE_OIT_WEIGHTED\nlayout(location=1)out float outFragR;\n#endif",oit_weighted_fragment="#ifdef USE_OIT_WEIGHTED\nfloat weight=1.0-gl_FragCoord.z;\noutFragR=gl_FragColor.a*weight;\noutFragColor=vec4(gl_FragColor.rgb*weight,gl_FragColor.a);\n#endif",node_common_frag="\n#define LUM_WEIGHTS vec3(0.2126,0.7152,0.0722)\n#define LUM_WEIGHTS_MAYA vec3(0.3,0.59,0.11)\n#define LUMENS_PER_WATT 683.0\n#define MAX_ENV_COORDS_DIR 0\n#define MAX_ENV_COORDS_REFLECT 1\n#define MAX_ENV_COORDS_REFRACT 2\n#if defined(NODE_COLOR_CONVERT_AR)||defined(NODE_COLOR_CORRECT_AR)||defined(NODE_COMBINE_COLOR_BL)||defined(NODE_SEPARATE_COLOR_BL)||defined(NODE_HUE_SAT_BL)||defined(NODE_COLOR_CORRECTION_MX)||defined(NODE_COMPOSITE_LAYER_MX)||defined(NODE_COLOR_CORRECT_MY)||defined(USE_OSL)\n#define HSV_NODES\n#endif\n#define OPENPBR_EMISSION_LUM_FACTOR 0.001\nfloat powCompat(const in float val,const in float power){\nif (power==0.0)\nreturn 1.0;\nelse if (val<0.0){\nif (mod(-power,2.0)==0.0)\nreturn pow(abs(val),power);\nelse\nreturn -pow(abs(val),power);\n} else if (val==0.0)\nreturn 0.0;\nreturn pow(abs(val),power);\n}\nfloat maxFromRGB(vec3 rgb){\nreturn max(max(rgb.r,rgb.g),rgb.b);\n}\nvec3 swizzleUpZ(const vec3 vec){\nreturn vec3(vec[0],-vec[2],vec[1]);\n}\nvec3 swizzleUpY(const vec3 vec){\nreturn vec3(vec[0],vec[2],-vec[1]);\n}\nfloat getSmoothFactor(float a,float b,float smoothness){\nreturn max(smoothness-abs(a-b),0.0)/smoothness;\n}\nfloat smoothMin(float a,float b,float smoothness){\nfloat smoothFac=getSmoothFactor(a,b,smoothness);\nreturn min(a,b)-smoothFac*smoothFac*smoothFac*smoothness*(1.0/6.0);\n}\nfloat smoothMax(float a,float b,float smoothness){\nfloat smoothFac=getSmoothFactor(a,b,smoothness);\nreturn max(a,b)+smoothFac*smoothFac*smoothFac*smoothness*(1.0/6.0);\n}\nfloat mat3GetDeterminant(mat3 mat){\nreturn mat[0][0]*mat[1][1]*mat[2][2]\n+ mat[0][2]*mat[1][0]*mat[2][1]\n+ mat[0][1]*mat[1][2]*mat[2][0]\n- mat[0][2]*mat[1][1]*mat[2][0]\n- mat[0][0]*mat[1][2]*mat[2][1]\n- mat[0][1]*mat[1][0]*mat[2][2];\n}\nmat3 mat3RotateX(float angle){\nfloat s=sin(angle),c=cos(angle);\nreturn mat3(1.0,0.0,0.0,0.0,c,s,0.0,-s,c);\n}\nmat3 mat3RotateY(float angle){\nfloat s=sin(angle),c=cos(angle);\nreturn mat3(c,0.0,-s,0.0,1.0,0.0,s,0.0,c);\n}\nmat3 mat3RotateZ(float angle){\nfloat s=sin(angle),c=cos(angle);\nreturn mat3(c,s,0.0,-s,c,0.0,0.0,0.0,1.0);\n}\nvec3 vec3RotateXAngle(vec3 vector,float angle){\nreturn mat3RotateX(angle)*vector;\n}\nvec3 vec3RotateYAngle(vec3 vector,float angle){\nreturn mat3RotateY(angle)*vector;\n}\nvec3 vec3RotateZAngle(vec3 vector,float angle){\nreturn mat3RotateZ(angle)*vector;\n}\nvec4 eulerToAxisAngle(vec3 euler){\nfloat c1=cos(euler.x/2.0),c2=cos(euler.y/2.0),c3=cos(euler.z/2.0);\nfloat s1=sin(euler.x/2.0),s2=sin(euler.y/2.0),s3=sin(euler.z/2.0);\nvec4 axisAngle=vec4(s1*c2*c3-c1*s2*s3,c1*s2*c3+s1*c2*s3,c1*c2*s3-s1*s2*c3,2.0*acos(c1*c2*c3+s1*s2*s3)\n);\naxisAngle.xyz=length(axisAngle.xyz)>0.0?normalize(axisAngle.xyz):vec3(1.0,0.0,0.0);\nreturn axisAngle;\n}\nmat3 axisAngleToMat3(vec3 axis,float angle){\nfloat s=sin(angle),c=cos(angle);\nfloat t=1.0-c;\nfloat x=axis.x,y=axis.y,z=axis.z;\nfloat tx=t*x,ty=t*y;\nreturn mat3(tx*x+c,tx*y-s*z,tx*z+s*y,tx*y+s*z,ty*y+c,ty*z-s*x,tx*z-s*y,ty*z+s*x,t*z*z+c);\n}\nmat3 toMat3(mat4 mat){\nreturn mat3(mat[0][0],mat[0][1],mat[0][2],mat[1][0],mat[1][1],mat[1][2],mat[2][0],mat[2][1],mat[2][2]);\n}\nmat4 toMat4(mat3 mat){\nreturn mat4(mat[0][0],mat[0][1],mat[0][2],0.0,mat[1][0],mat[1][1],mat[1][2],0.0,mat[2][0],mat[2][1],mat[2][2],0.0,0.0,0.0,0.0,1.0);\n}\nmat4 translationToMat4(vec3 v){\nreturn mat4(1.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0,0.0,v.x,v.y,v.z,1.0);\n}\nmat4 scalingToMat4(vec3 v){\nreturn mat4(v.x,0.0,0.0,0.0,0.0,v.y,0.0,0.0,0.0,0.0,v.z,0.0,0.0,0.0,0.0,1.0);\n}\nvec4 nodeTexelToLinear(in vec4 color,in int sourceType){\nif (sourceType==1)\nreturn vec4(pow(color.rgb,vec3(2.2)),color.a);\nelse\nreturn color;\n}\nvec3 xyz_to_sRGB(vec3 xyz){\nmat3 convMat=mat3(3.2406,-0.9689,0.0557,-1.5372,1.8758,-0.2040,-0.4986,0.0415,1.0570\n);\nreturn convMat*xyz;\n}\nvec3 xyY_to_XYZ(float x,float y,float Y){\nfloat X=0.0;\nfloat Z=0.0;\nif (y != 0.0){\nX=(Y/y)*x;\nZ=(Y/y)*(1.0-x-y);\n}\nreturn vec3(X,Y,Z);\n}\n#if defined HSV_NODES\nvoid hsvToRGB(vec4 hsv,out vec4 outCol)\n{\nfloat i,f,p,q,t,h,s,v;\nvec3 rgb;\nh=hsv[0];\ns=hsv[1];\nv=hsv[2];\nif (s==0.0)\nrgb=vec3(v,v,v);\nelse {\nif (h==1.0)\nh=0.0;\nh*=6.0;\ni=floor(h);\nf=h-i;\nrgb=vec3(f,f,f);\np=v*(1.0-s);\nq=v*(1.0-(s*f));\nt=v*(1.0-(s*(1.0-f)));\nif (i==0.0)\nrgb=vec3(v,t,p);\nelse if (i==1.0)\nrgb=vec3(q,v,p);\nelse if (i==2.0)\nrgb=vec3(p,v,t);\nelse if (i==3.0)\nrgb=vec3(p,q,v);\nelse if (i==4.0)\nrgb=vec3(t,p,v);\nelse\nrgb=vec3(v,p,q);\n}\noutCol=vec4(rgb,hsv.w);\n}\nvoid rgbToHSV(vec4 rgb,out vec4 outCol)\n{\nfloat cmax,cmin,h,s,v,cdelta;\nvec3 c;\ncmax=max(rgb[0],max(rgb[1],rgb[2]));\ncmin=min(rgb[0],min(rgb[1],rgb[2]));\ncdelta=cmax-cmin;\nv=cmax;\nif (cmax != 0.0)\ns=cdelta/cmax;\nelse {\ns=0.0;\nh=0.0;\n}\nif (s==0.0)\nh=0.0;\nelse {\nc=(vec3(cmax,cmax,cmax)-rgb.xyz)/cdelta;\nif (rgb.x==cmax)h=c[2]-c[1];\nelse if (rgb.y==cmax)h=2.0+c[0]-c[2];\nelse h=4.0+c[1]-c[0];\nh/=6.0;\nif (h<0.0)\nh+=1.0;\n}\noutCol=vec4(h,s,v,rgb.w);\n}\n#endif\n#if defined(NODE_REFLECT_REFRACT_MX)||defined(NODE_BITMAP_ENV_MX)||defined(NODE_ENV_SPHERE_MY)\nvec4 sampleEquirectangular(sampler2D map,vec3 reflectVec,mat3 uvTransform,int encoding)\n{\nreflectVec=normalize(reflectVec);\nvec2 sampleUV;\nsampleUV.y=asin(clamp(reflectVec.y,-1.0,1.0))*RECIPROCAL_PI+0.5;\nsampleUV.x=atan(reflectVec.x,reflectVec.z)*RECIPROCAL_PI2+0.5;\nsampleUV.y*=-1.0;\nconst float seamWidth=0.15;\nconst float seamBiasFactor=-10.0;\nfloat seam=max(0.0,1.0-abs (reflectVec.x)/seamWidth)*\nclamp (1.0-reflectVec.z/seamWidth,0.0,1.0);\nsampleUV=(uvTransform*vec3(sampleUV,1.0)).xy;\nreturn texture2D(map,sampleUV,seamBiasFactor*seam);\n}\n#endif\n#if defined(NODE_FRESNEL_BL)||defined(NODE_LAYER_WEIGHT_BL)||defined(NODE_FALLOFF_MX)||defined(NODE_BSDF_GLASS_BL)||defined(NODE_BSDF_PRINCIPLED_BL)\nfloat fresnelReflection(const vec3 dir,const vec3 normal,const float ior){\nfloat cosTheta=clamp(abs(dot(dir,normal)),-1.0,1.0);\nfloat gSquared=pow2(ior)+pow2(cosTheta)-1.0;\nif (gSquared<0.0)return 1.0;\nfloat g=sqrt(gSquared);\nreturn 0.5*pow2((g-cosTheta)/(g+cosTheta))\n* (1.0+pow2(((g+cosTheta)*cosTheta-1.0)/\n((g-cosTheta)*cosTheta+1.0)\n));\n}\n#endif\n#if defined(NODE_BITMAP_MX)||defined(NODE_BITMAP_ENV_MX)||defined(NODE_GRADIENT_MX)||defined(NODE_GRADIENT_RAMP_MX)\n#define MAPPING_EXPLICIT_MAP_CHANNEL 1\n#define MAPPING_VERTEX_COLOR_CHANNEL 2\n#define MAPPING_PLANAR_OBJECT_XYZ 3\n#define MAPPING_PLANAR_WORLD_XYZ 4\n#define AXIS_XY 1\n#define AXIS_YZ 2\n#define AXIS_ZX 3\n#endif\n#if defined(NODE_BITMAP_MX)||defined(NODE_BITMAP_ENV_MX)||defined(NODE_BUMP_MX)||defined(NODE_GRADIENT_MX)||defined(NODE_GRADIENT_RAMP_MX)||defined(NODE_PLACE_2D_TEXTURE_MY)\nmat3 calcUvTransform(float uOffset,float vOffset,float uTiling,float vTiling,float wAngle)\n{\nif (abs(uOffset)<EPSILON&&abs(vOffset)<EPSILON &&\n(abs(uTiling-1.0))<EPSILON&&(abs(vTiling-1.0))<EPSILON &&\nabs(wAngle)<EPSILON)\nreturn mat3(1.0);\nfloat sx=uTiling;\nfloat sy=vTiling;\nfloat c=cos(-wAngle);\nfloat s=sin(-wAngle);\n#if defined(NODE_PLACE_2D_TEXTURE_MY)\nfloat tx=uOffset;\nfloat ty=vOffset;\nfloat cx=0.5;\nfloat cy=0.5;\nreturn mat3(c*sx,s*sx,0.0,-s*sy,c*sy,0.0,s*(ty+sy-cy)+c*(tx-cx)+cx,-c*(ty+sy-cy)+s*(tx-cx)-cy+1.0,1.0);\n#else\nfloat tx=-uOffset;\nfloat ty=-vOffset;\nfloat cx=uOffset+0.5;\nfloat cy=vOffset+0.5;\nreturn mat3(sx*c,-sy*s,0.0,sx*s,sy*c,0.0,-sx*(c*cx+s*cy)+cx+tx,-sy*(- s*cx+c*cy)+cy+ty,1.0);\n#endif\n}\n#endif\n#if defined(NODE_NOISE_MX)\nmat4 calcXYZTransform(vec3 offset,vec3 tiling,vec3 angle){\nmat4 rot=mat4(cos(angle.y)*cos(angle.z),cos(angle.x)*sin(angle.z)+sin(angle.x)*sin(angle.y)*cos(angle.z),sin(angle.x)*sin(angle.z)-cos(angle.x)*sin(angle.y)*cos(angle.z),0.0,-cos(angle.y)*sin(angle.z),cos(angle.x)*cos(angle.z)-sin(angle.x)*sin(angle.y)*sin(angle.z),cos(angle.x)*sin(angle.y)*sin(angle.z)+sin(angle.x)*cos(angle.z),0.0,sin(angle.y),-sin(angle.x)*cos(angle.y),cos(angle.x)*cos(angle.y),0.0,0.0,0.0,0.0,1.0\n);\nmat4 til=mat4(tiling.x,0.0,0.0,0.0,0.0,tiling.y,0.0,0.0,0.0,0.0,tiling.z,0.0,0.0,0.0,0.0,1.0\n);\nmat4 off=mat4(1.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0,0.0,offset.x,offset.y,offset.z,1.0\n);\nreturn (til*rot*off);\n}\n#endif\n#if defined(NODE_TEX_NOISE_BL)||defined(NODE_TEX_WAVE_BL)||defined(NODE_NOISE_MX)||defined(USE_OSL)||defined(NODE_NOISE_MY)\n#define NOISE_AMP_HACK 0.75\n#define NOISE_BLENDER_MEAN 0.78\n#define NOISE_SCALE_HACK 0.5\n#define noiseModulo(x)(x-floor(x*(1.0/289.0))*289.0)\nvec4 noisePermute(vec4 x){\nreturn noiseModulo(((x*34.0)+1.0)*x);\n}\nvec4 taylorInvSqrt(vec4 r){\nreturn 1.79284291400159-0.85373472095314*r;\n}\nfloat taylorInvSqrt(float r){\nreturn 1.79284291400159-0.85373472095314*r;\n}\nfloat noisePerlin(vec3 v){\nconst vec2 C=vec2(1.0/6.0,1.0/3.0);\nconst vec4 D=vec4(0.0,0.5,1.0,2.0);\nvec3 i=floor(v+dot(v,C.yyy));\nvec3 x0=v-i+dot(i,C.xxx);\nvec3 g=step(x0.yzx,x0.xyz);\nvec3 l=1.0-g;\nvec3 i1=min(g.xyz,l.zxy);\nvec3 i2=max(g.xyz,l.zxy);\nvec3 x1=x0-i1+C.xxx;\nvec3 x2=x0-i2+C.yyy;\nvec3 x3=x0-D.yyy;\ni=noiseModulo(i);\nvec4 p=noisePermute(noisePermute(noisePermute(i.z+vec4(0.0,i1.z,i2.z,1.0))\n+ i.y+vec4(0.0,i1.y,i2.y,1.0))+i.x+vec4(0.0,i1.x,i2.x,1.0));\nfloat n_=0.142857142857;\nvec3 ns=n_*D.wyz-D.xzx;\nvec4 j=p-49.0*floor(p*ns.z*ns.z);\nvec4 x_=floor(j*ns.z);\nvec4 y_=floor(j-7.0*x_);\nvec4 x=x_*ns.x+ns.yyyy;\nvec4 y=y_*ns.x+ns.yyyy;\nvec4 h=1.0-abs(x)-abs(y);\nvec4 b0=vec4(x.xy,y.xy);\nvec4 b1=vec4(x.zw,y.zw);\nvec4 s0=floor(b0)*2.0+1.0;\nvec4 s1=floor(b1)*2.0+1.0;\nvec4 sh=-step(h,vec4(0.0));\nvec4 a0=b0.xzyw+s0.xzyw*sh.xxyy;\nvec4 a1=b1.xzyw+s1.xzyw*sh.zzww;\nvec3 p0=vec3(a0.xy,h.x);\nvec3 p1=vec3(a0.zw,h.y);\nvec3 p2=vec3(a1.xy,h.z);\nvec3 p3=vec3(a1.zw,h.w);\nvec4 norm=taylorInvSqrt(vec4(dot(p0,p0),dot(p1,p1),dot(p2,p2),dot(p3,p3)));\np0*=norm.x;\np1*=norm.y;\np2*=norm.z;\np3*=norm.w;\nvec4 m=max(0.6-vec4(dot(x0,x0),dot(x1,x1),dot(x2,x2),dot(x3,x3)),0.0);\nm=m*m;\nreturn 42.0*dot(m*m,vec4(dot(p0,x0),dot(p1,x1),dot(p2,x2),dot(p3,x3)));\n}\nvec4 permute(vec4 x){\nreturn mod(((x*34.0)+1.0)*x,289.0);\n}\nfloat permute(float x){\nreturn floor(mod(((x*34.0)+1.0)*x,289.0));\n}\nvec4 grad4(float j,vec4 ip){\nconst vec4 ones=vec4(1.0,1.0,1.0,-1.0);\nvec4 p,s;\np.xyz=floor( fract (vec3(j)*ip.xyz)*7.0)*ip.z-1.0;\np.w=1.5-dot(abs(p.xyz),ones.xyz);\ns=vec4(lessThan(p,vec4(0.0)));\np.xyz=p.xyz+(s.xyz*2.0-1.0)*s.www;\nreturn p;\n}\nfloat snoise(vec4 v){\nconst vec2 C=vec2(0.138196601125010504,0.309016994374947451);\nvec4 i=floor(v+dot(v,C.yyyy));\nvec4 x0=v-i+dot(i,C.xxxx);\nvec4 i0;\nvec3 isX=step( x0.yzw,x0.xxx );\nvec3 isYZ=step( x0.zww,x0.yyz );\ni0.x=isX.x+isX.y+isX.z;\ni0.yzw=1.0-isX;\ni0.y+=isYZ.x+isYZ.y;\ni0.zw+=1.0-isYZ.xy;\ni0.z+=isYZ.z;\ni0.w+=1.0-isYZ.z;\nvec4 i3=clamp( i0,0.0,1.0 );\nvec4 i2=clamp( i0-1.0,0.0,1.0 );\nvec4 i1=clamp( i0-2.0,0.0,1.0 );\nvec4 x1=x0-i1+1.0*C.xxxx;\nvec4 x2=x0-i2+2.0*C.xxxx;\nvec4 x3=x0-i3+3.0*C.xxxx;\nvec4 x4=x0-1.0+4.0*C.xxxx;\ni=mod(i,289.0);\nfloat j0=permute( permute( permute( permute(i.w)+i.z)+i.y)+i.x);\nvec4 j1=permute( permute( permute( permute (i.w+vec4(i1.w,i2.w,i3.w,1.0 ))\n+ i.z+vec4(i1.z,i2.z,i3.z,1.0 ))\n+ i.y+vec4(i1.y,i2.y,i3.y,1.0 ))\n+ i.x+vec4(i1.x,i2.x,i3.x,1.0 ));\nvec4 ip=vec4(1.0/294.0,1.0/49.0,1.0/7.0,0.0);\nvec4 p0=grad4(j0,ip);\nvec4 p1=grad4(j1.x,ip);\nvec4 p2=grad4(j1.y,ip);\nvec4 p3=grad4(j1.z,ip);\nvec4 p4=grad4(j1.w,ip);\nvec4 norm=taylorInvSqrt(vec4(dot(p0,p0),dot(p1,p1),dot(p2,p2),dot(p3,p3)));\np0*=norm.x;\np1*=norm.y;\np2*=norm.z;\np3*=norm.w;\np4*=taylorInvSqrt(dot(p4,p4));\nvec3 m0=max(0.6-vec3(dot(x0,x0),dot(x1,x1),dot(x2,x2)),0.0);\nvec2 m1=max(0.6-vec2(dot(x3,x3),dot(x4,x4)),0.0);\nm0=m0*m0;\nm1=m1*m1;\nreturn 49.0*( dot(m0*m0,vec3( dot( p0,x0 ),dot( p1,x1 ),dot( p2,x2 )))\n+ dot(m1*m1,vec2( dot( p3,x3 ),dot( p4,x4 ))));\n}\nfloat noiseBlender(vec3 p){\nreturn 0.5*NOISE_AMP_HACK*(noisePerlin(NOISE_SCALE_HACK*vec3(p.x,p.y,p.z)))+0.5;\n}\nfloat noiseSmooth(vec3 p,float octaveLenPerPixel,float falloffFactor,float dispersionFactor){\nfloat mixFac=mix(1.0,smoothstep(0.0,1.0,octaveLenPerPixel)*falloffFactor,dispersionFactor);\nreturn mix(noiseBlender(p),NOISE_BLENDER_MEAN,mixFac);\n}\n#define MAX_OCTAVES_NUM 16\nfloat noiseTurbulence(vec3 p,float octaves,float octaveLenPerPixel,float falloffFactor,float dispersionFactor){\nfloat fscale=1.0;\nfloat amp=1.0;\nfloat sum=0.0;\noctaves=clamp(octaves,0.0,16.0);\nint octavesInt=int(octaves);\nfor (int i=0;i<=MAX_OCTAVES_NUM;i++){\nif (i>octavesInt)\nbreak;\nfloat t=noiseSmooth(fscale*p,octaveLenPerPixel,falloffFactor,dispersionFactor);\nsum+=t*amp;\namp*=0.5;\nfscale*=2.0;\noctaveLenPerPixel*=2.0;\n}\nfloat octavesFrac=fract(octaves);\nfloat octavesCoeff=pow(2.0,float(octavesInt));\nif (octavesFrac != 0.0){\nfloat t=noiseSmooth(fscale*p,octaveLenPerPixel,falloffFactor,dispersionFactor);\nfloat sum2=sum+t*amp;\nsum*=octavesCoeff/(2.0*octavesCoeff-1.0);\nsum2*=2.0*octavesCoeff/(4.0*octavesCoeff-1.0);\nreturn mix(sum,sum2,octavesFrac);\n} else {\nreturn sum*octavesCoeff/(2.0*octavesCoeff-1.0);\n}\n}\n#endif\n#if (defined(USE_OSL)||defined(NODE_WAVELENGTH_BL))&&__VERSION__==300\nvec3 cieColorMatch[81]=vec3[](vec3(0.0014,0.0000,0.0065),vec3(0.0022,0.0001,0.0105),vec3(0.0042,0.0001,0.0201),vec3(0.0076,0.0002,0.0362),vec3(0.0143,0.0004,0.0679),vec3(0.0232,0.0006,0.1102),vec3(0.0435,0.0012,0.2074),vec3(0.0776,0.0022,0.3713),vec3(0.1344,0.0040,0.6456),vec3(0.2148,0.0073,1.0391),vec3(0.2839,0.0116,1.3856),vec3(0.3285,0.0168,1.6230),vec3(0.3483,0.0230,1.7471),vec3(0.3481,0.0298,1.7826),vec3(0.3362,0.0380,1.7721),vec3(0.3187,0.0480,1.7441),vec3(0.2908,0.0600,1.6692),vec3(0.2511,0.0739,1.5281),vec3(0.1954,0.0910,1.2876),vec3(0.1421,0.1126,1.0419),vec3(0.0956,0.1390,0.8130),vec3(0.0580,0.1693,0.6162),vec3(0.0320,0.2080,0.4652),vec3(0.0147,0.2586,0.3533),vec3(0.0049,0.3230,0.2720),vec3(0.0024,0.4073,0.2123),vec3(0.0093,0.5030,0.1582),vec3(0.0291,0.6082,0.1117),vec3(0.0633,0.7100,0.0782),vec3(0.1096,0.7932,0.0573),vec3(0.1655,0.8620,0.0422),vec3(0.2257,0.9149,0.0298),vec3(0.2904,0.9540,0.0203),vec3(0.3597,0.9803,0.0134),vec3(0.4334,0.9950,0.0087),vec3(0.5121,1.0000,0.0057),vec3(0.5945,0.9950,0.0039),vec3(0.6784,0.9786,0.0027),vec3(0.7621,0.9520,0.0021),vec3(0.8425,0.9154,0.0018),vec3(0.9163,0.8700,0.0017),vec3(0.9786,0.8163,0.0014),vec3(1.0263,0.7570,0.0011),vec3(1.0567,0.6949,0.0010),vec3(1.0622,0.6310,0.0008),vec3(1.0456,0.5668,0.0006),vec3(1.0026,0.5030,0.0003),vec3(0.9384,0.4412,0.0002),vec3(0.8544,0.3810,0.0002),vec3(0.7514,0.3210,0.0001),vec3(0.6424,0.2650,0.0000),vec3(0.5419,0.2170,0.0000),vec3(0.4479,0.1750,0.0000),vec3(0.3608,0.1382,0.0000),vec3(0.2835,0.1070,0.0000),vec3(0.2187,0.0816,0.0000),vec3(0.1649,0.0610,0.0000),vec3(0.1212,0.0446,0.0000),vec3(0.0874,0.0320,0.0000),vec3(0.0636,0.0232,0.0000),vec3(0.0468,0.0170,0.0000),vec3(0.0329,0.0119,0.0000),vec3(0.0227,0.0082,0.0000),vec3(0.0158,0.0057,0.0000),vec3(0.0114,0.0041,0.0000),vec3(0.0081,0.0029,0.0000),vec3(0.0058,0.0021,0.0000),vec3(0.0041,0.0015,0.0000),vec3(0.0029,0.0010,0.0000),vec3(0.0020,0.0007,0.0000),vec3(0.0014,0.0005,0.0000),vec3(0.0010,0.0004,0.0000),vec3(0.0007,0.0002,0.0000),vec3(0.0005,0.0002,0.0000),vec3(0.0003,0.0001,0.0000),vec3(0.0002,0.0001,0.0000),vec3(0.0002,0.0001,0.0000),vec3(0.0001,0.0000,0.0000),vec3(0.0001,0.0000,0.0000),vec3(0.0001,0.0000,0.0000),vec3(0.0000,0.0000,0.0000)\n);\n#endif\n#if defined(USE_OSL)||defined(NODE_BLACKBODY_BL)\nvec3 colorTempToRGB(float temp)\n{\nvec3 retColor;\ntemp=clamp(temp,100.0,40000.0)/100.0;\nif (temp<=66.0){\nretColor.r=1.0;\nretColor.g=saturate(0.390081578*log(temp)-0.631841443);\n} else {\nfloat t=temp-60.0;\nretColor.r=saturate(1.292936186*pow(t,-0.133204759));\nretColor.g=saturate(1.129890860*pow(t,-0.075514849));\n}\nif (temp>=66.0)\nretColor.b=1.0;\nelse if (temp<=19.0)\nretColor.b=0.0;\nelse\nretColor.b=saturate(0.543206789*log(temp-10.0)-1.196254089);\nretColor.rgb=pow(retColor.rgb,vec3(2.2));\nreturn retColor;\n}\n#endif\n#if (defined(NODE_TEX_WHITE_NOISE_BL)||defined(NODE_TEX_GABOR_BL))&&__VERSION__==300\n#define rotUint32(x,k)(((x)<< (k))|((x)>> (32-(k))))\n#define mixUint32(a,b,c){a-=c;a ^= rotUint32(c,4);c+=b;b-=a;b ^= rotUint32(a,6);a+=c;c-=b;c ^= rotUint32(b,8);b+=a;a-=c;a ^= rotUint32(c,16);c+=b;b-=a;b ^= rotUint32(a,19);a+=c;c-=b;c ^= rotUint32(b,4);b+=a;}\n#define finalUint32(a,b,c){c ^= b;c-=rotUint32(b,14);a ^= c;a-=rotUint32(c,11);b ^= a;b-=rotUint32(a,25);c ^= b;c-=rotUint32(b,16);a ^= c;a-=rotUint32(c,4);b ^= a;b-=rotUint32(a,14);c ^= b;c-=rotUint32(b,24);}\nuint hashUint(uint x){\nuint a=0xdeadbeefu+17u+x;\nuint b=0xdeadbeefu+17u;\nuint c=0xdeadbeefu+17u;\nfinalUint32(a,b,c);\nreturn c;\n}\nuint hashUint2(uvec2 vec){\nuvec3 abc=uvec3(0xdeadbeefu+21u)+uvec3(vec,0u);\nfinalUint32(abc.x,abc.y,abc.z);\nreturn abc.z;\n}\nuint hashUint3(uvec3 vec){\nuvec3 abc=uvec3(0xdeadbeefu+25u)+vec;\nfinalUint32(abc.x,abc.y,abc.z);\nreturn abc.z;\n}\nuint hashUint4(uvec4 vec){\nuvec3 abc=uvec3(0xdeadbeefu+29u)+vec.xyz;\nmixUint32(abc.x,abc.y,abc.z);\nabc.x+=vec.w;\nfinalUint32(abc.x,abc.y,abc.z);\nreturn abc.z;\n}\n#undef rotUint32\n#undef mixUint32\n#undef finalUint32\nfloat uintToFloat(uint value){\nreturn float(value)/float(0xFFFFFFFFu);\n}\nfloat hashFloatToFloat(float value){\nreturn uintToFloat(hashUint(floatBitsToUint(value)));\n}\nfloat hashVec2ToFloat(vec2 vec){\nreturn uintToFloat(hashUint2(floatBitsToUint(vec)));\n}\nfloat hashVec3ToFloat(vec3 vec){\nreturn uintToFloat(hashUint3(floatBitsToUint(vec)));\n}\nfloat hashVec4ToFloat(vec4 vec){\nreturn uintToFloat(hashUint4(floatBitsToUint(vec)));\n}\nvec2 hashVec3ToVec2(vec3 k){\nreturn vec2(hashVec3ToFloat(k.xyz),hashVec3ToFloat(k.zxy));\n}\nvec2 hashVec4ToVec2(vec4 k){\nreturn vec2(hashVec4ToFloat(k.xyzw),hashVec4ToFloat(k.zxwy));\n}\nvec3 hashFloatToVec3(float val){\nreturn vec3(hashFloatToFloat(val),hashVec2ToFloat(vec2(val,1.0)),hashVec2ToFloat(vec2(val,2.0)));\n}\nvec3 hashVec2ToVec3(vec2 vec){\nreturn vec3(hashVec2ToFloat(vec),hashVec3ToFloat(vec3(vec,1.0)),hashVec3ToFloat(vec3(vec,2.0)));\n}\nvec3 hashVec3ToVec3(vec3 vec){\nreturn vec3(hashVec3ToFloat(vec),hashVec4ToFloat(vec4(vec,1.0)),hashVec4ToFloat(vec4(vec,2.0)));\n}\nvec3 hashVec4ToVec3(vec4 vec){\nreturn vec3(hashVec4ToFloat(vec.xyzw),hashVec4ToFloat(vec.zxwy),hashVec4ToFloat(vec.wzyx));\n}\n#endif",node_osl_frag="#ifdef USE_OSL\n#define M_PI PI\n#define M_PI_2 PI/2.0\n#define M_PI_4 PI/4.0\n#define M_2_PI 2.0/PI\n#define M_2PI 2.0*PI\n#define M_4PI 4.0*PI\n#define M_2_SQRTPI 2.0/sqrt(PI)\n#define M_E 2.718281828459\n#define M_LN2 0.69314718056\n#define M_LN10 2.30258509299\n#define M_LOG2E 1.4426950409\n#define M_LOG10E 0.43429448190\n#define M_SQRT2 sqrt(2.0)\n#define M_SQRT1_2 sqrt(0.5)\n#define OSL_ALPHA 33633\n#define OSL_ANISOTROPIC 40205\n#define OSL_AVERAGEALPHA 57701\n#define OSL_AVERAGECOLOR 46077\n#define OSL_BANDWIDTH 37485\n#define OSL_BEZIER 27645\n#define OSL_BLACK 62409\n#define OSL_BSPLINE 16959\n#define OSL_CAMERA 8198\n#define OSL_CAMERA_CLIP 34380\n#define OSL_CAMERA_CLIP_FAR 31933\n#define OSL_CAMERA_CLIP_NEAR 21485\n#define OSL_CAMERA_FOV 60706\n#define OSL_CAMERA_PIXELASPECT 4950\n#define OSL_CAMERA_PROJECTION 29369\n#define OSL_CAMERA_RESOLUTION 39679\n#define OSL_CAMERA_SCREEN_WINDOW 47009\n#define OSL_CAMERA_SHUTTER 7107\n#define OSL_CAMERA_SHUTTER_CLOSE 34406\n#define OSL_CAMERA_SHUTTER_OPEN 40085\n#define OSL_CATMULL_ROM 31642\n#define OSL_CELL 20984\n#define OSL_CHANNELS 8726\n#define OSL_CLAMP 20052\n#define OSL_COLOR 53753\n#define OSL_COMMON 49871\n#define OSL_CONSTANT 25144\n#define OSL_DATAWINDOW 54276\n#define OSL_DEFAULT 54870\n#define OSL_DIFFUSE 40389\n#define OSL_DIRECTION 42220\n#define OSL_DISPLAYWINDOW 30728\n#define OSL_DISTANCE 51337\n#define OSL_DO_FILTER 35765\n#define OSL_EMPTY 9314\n#define OSL_ERRORMESSAGE 38305\n#define OSL_EXISTS 41510\n#define OSL_FILL 39132\n#define OSL_FIRSTCHANNEL 48155\n#define OSL_GABOR 57764\n#define OSL_GEOM_NAME 63686\n#define OSL_GLOSSY 47998\n#define OSL_HASH 49390\n#define OSL_HERMITE 63643\n#define OSL_HIT 48491\n#define OSL_HITDIST 22029\n#define OSL_HSL 49898\n#define OSL_HSV 29073\n#define OSL_IMPULSES 56191\n#define OSL_INDEX 1731\n#define OSL_INTERP 10557\n#define OSL_LINEAR 2182\n#define OSL_MIRROR 64591\n#define OSL_MISSINGALPHA 39755\n#define OSL_MISSINGCOLOR 51667\n#define OSL_NDC 48899\n#define OSL_NORMAL 16520\n#define OSL_OBJECT 59084\n#define OSL_OSL_VERSION 47920\n#define OSL_PERIODIC 8749\n#define OSL_PERLIN 730\n#define OSL_POSITION 43041\n#define OSL_RASTER 2618\n#define OSL_REFLECTION 37621\n#define OSL_REFRACTION 37287\n#define OSL_RESOLUTION 48704\n#define OSL_RGB 26673\n#define OSL_RWRAP 47801\n#define OSL_SCREEN 55875\n#define OSL_SHADER 21066\n#define OSL_SHADER_GROUPNAME 62327\n#define OSL_SHADER_LAYERNAME 51796\n#define OSL_SHADER_SHADERNAME 65123\n#define OSL_SHADOW 60708\n#define OSL_SIMPLEX 61636\n#define OSL_SUBIMAGE 33526\n#define OSL_SUBIMAGES 2366\n#define OSL_SWRAP 4328\n#define OSL_TEXTUREFORMAT 17851\n#define OSL_TIME 52235\n#define OSL_TRACE 62908\n#define OSL_TWRAP 30524\n#define OSL_TYPE 64071\n#define OSL_UPERLIN 65308\n#define OSL_USIMPLEX 11314\n#define OSL_WIDTH 48751\n#define OSL_WORLD 9059\n#define OSL_WORLDTOCAMERA 32273\n#define OSL_WORLDTOSCREEN 33876\n#define OSL_WRAP 58300\n#define OSL_XYY 2228\n#define OSL_XYZ 47351\n#define OSL_YIQ 15839\nvec3 oslGetP(vec3 viewPos){\n#if WORLD_NODES==1\nreturn swizzleUpZ((invViewMatrix*vec4(-viewPos,0.0)).xyz);\n#else\nreturn swizzleUpZ((invViewMatrix*vec4(-viewPos,1.0)).xyz);\n#endif\n}\nvec3 oslGetI(vec3 viewPos){\n#if WORLD_NODES==1\nreturn swizzleUpZ((invViewMatrix*vec4(normalize(-viewPos),0.0)).xyz);\n#else\nreturn swizzleUpZ((invViewMatrix*vec4(normalize(-viewPos),0.0)).xyz);\n#endif\n}\nvec3 oslGetN(vec3 viewNorm){\nreturn swizzleUpZ(normalize(invViewMatrix*vec4(viewNorm,0.0)).xyz);\n}\nvec3 oslBlackbody(float temperatureK){\nreturn vec4(colorTempToRGB(temperatureK),1.0).rgb;\n}\nfloat oslDistance(vec3 p0,vec3 p1){\nreturn distance(p0,p1);\n}\nfloat oslDistance(vec3 p0,vec3 p1,vec3 q){\nvec3 d=p1-p0;\nfloat dd=dot(d,d);\nif (dd==0.0)\nreturn distance(q,p0);\nfloat t=dot(q-p0,d)/dd;\nreturn distance(q,p0+clamp(t,0.0,1.0)*d);\n}\nint oslEndsWith(int name1,int name2){\nreturn int(name1==name2);\n}\nint oslFormat(int name1,int name2){\nreturn name2;\n}\nint oslGetAttribute(int name,out int value){\nvalue=0;\nreturn 0;\n}\nint oslGetAttribute(int name,out float value){\nvalue=0.0;\nreturn 0;\n}\nint oslGetAttribute(int name,out vec3 vec){\nvec=vec3(0.0,0.0,0.0);\nreturn 0;\n}\nvoid oslGetTextureInfo(int filename,int name,out int value){\nvalue=4;\n}\nvoid oslGetTextureInfo(int filename,int name,out int value[2]){\nvalue[0]=1024;\nvalue[1]=1024;\n}\nvec3 oslHSV(float h,float s,float v){\nvec4 outCol;\nhsvToRGB(vec4(h,s,v,1.0),outCol);\nreturn outCol.rgb;\n}\nfloat oslHypot(float x,float y){\nreturn sqrt(x*x+y*y);\n}\nfloat oslHypot(float x,float y,float z){\nreturn sqrt(x*x+y*y+z*z);\n}\nfloat oslLog2(float x,float y){\nreturn log(x)/log(y);\n}\nfloat oslLuminance(vec3 color){\nreturn linearToRelativeLuminance(color);\n}\nfloat oslNoise(int type,vec3 vec,float phase){\nfloat n=snoise(vec4(vec,phase));\nif (type==OSL_UPERLIN)\nn=n*0.5+0.5;\nreturn n;\n}\nfloat oslNoise(int type,float value,float phase){\nreturn oslNoise(type,vec3(value),phase);\n}\nfloat oslNoise(int type,vec3 vec){\nreturn oslNoise(type,vec,0.0);\n}\nfloat oslNoise(int type,float value){\nreturn oslNoise(type,vec3(value),0.0);\n}\nvec3 oslNoise3D(int type,vec3 vec,float phase){\nfloat x=snoise(vec4(vec,phase));\nfloat y=snoise(vec4(vec.y,vec.x,vec.z,phase));\nfloat z=snoise(vec4(vec.y,vec.z,vec.x,phase));\nvec3 n=vec3(x,y,z);\nif (type==OSL_UPERLIN)\nn=n*0.5+0.5;\nreturn n;\n}\nvec3 oslNoise3D(int type,float value,float phase){\nreturn oslNoise3D(type,vec3(value),phase);\n}\nvec3 oslNoise3D(int type,vec3 vec){\nreturn oslNoise3D(type,vec,0.0);\n}\nvec3 oslNoise3D(int type,float value){\nreturn oslNoise3D(type,vec3(value),0.0);\n}\nfloat oslPow(float a,float b){\nreturn pow(a,b);\n}\nvec3 oslPow(vec3 a,float b){\nreturn pow(a,vec3(b));\n}\nint oslRayType(int name){\nif (name==OSL_CAMERA)\n#if LIGHT_PATH_IS_CAM_RAY\nreturn 1;\n#else\nreturn 0;\n#endif\nelse\nreturn 0;\n}\nvec3 oslRotate(vec3 vec,float angle,vec3 p0,vec3 p1){\nvec3 axis=normalize(p1-p0);\nfloat c=cos(angle);\nfloat s=sin(angle);\nfloat x=axis[0];\nfloat y=axis[1];\nfloat z=axis[2];\nmat4 mat=mat4(x*x+(1.0-x*x)*c,x*y*(1.0-c)+z*s,x*z*(1.0-c)-y*s,0.0,x*y*(1.0-c)-z*s,y*y+(1.0-y*y)*c,y*z*(1.0-c)+x*s,0.0,x*z*(1.0-c)+y*s,y*z*(1.0-c)-x*s,z*z+(1.0-z*z)*c,0.0,0.0,0.0,0.0,1.0\n);\nreturn (mat*vec4((vec-p0),1.0)+vec4(p0,1.0)).xyz;\n}\nvec3 oslRotate(vec3 vec,float angle,vec3 axis){\nreturn oslRotate(vec,angle,vec3(0.0),axis);\n}\nint oslStartsWith(int name1,int name2){\nreturn int(name1==name2);\n}\nint oslStrLen(int name){\nif (name==OSL_EMPTY)\nreturn 0;\nelse\nreturn 1;\n}\nint oslSubStr(int s,int start,int len){\nreturn s;\n}\nint oslSubStr(int s,int start){\nreturn s;\n}\nvec3 oslTexture(sampler2D image,float u,float v,int wrapModeFlag,int wrapMode,int alphaFlag,out float alpha){\nif (wrapMode==OSL_DEFAULT||wrapMode==OSL_BLACK){\nif (u<0.0||u>1.0||v<0.0||v>1.0)\nreturn vec3(0.0);\n} else if (wrapMode==OSL_CLAMP){\nu=clamp(u,0.0,1.0);\nv=clamp(v,0.0,1.0);\n} else if (wrapMode==OSL_PERIODIC){\nu=mod(u,1.0);\nv=mod(v,1.0);\n} else if (wrapMode==OSL_MIRROR){\nif (mod(floor(u),2.0)==0.0)\nu=u-floor(u);\nelse\nu=1.0-(u-floor(u));\nif (mod(floor(v),2.0)==0.0)\nv=v-floor(v);\nelse\nv=1.0-(v-floor(v));\n}\nvec4 colAlpha=texture2D(image,vec2(u,v));\nalpha=colAlpha.a;\nreturn colAlpha.rgb;\n}\nvec3 oslTexture(sampler2D image,float u,float v,int alphaFlag,out float alpha,int wrapModeFlag,int wrapMode){\nreturn oslTexture(image,u,v,wrapModeFlag,wrapMode,alphaFlag,alpha);\n}\nvec3 oslTexture(sampler2D image,float u,float v,int alphaFlag,out float alpha){\nreturn oslTexture(image,u,v,OSL_WRAP,OSL_DEFAULT,alphaFlag,alpha);\n}\nvec3 oslTexture(sampler2D image,float u,float v,int wrapModeFlag,int wrapMode){\nfloat alpha;\nreturn oslTexture(image,u,v,wrapModeFlag,wrapMode,OSL_ALPHA,alpha);\n}\nvec3 oslTexture(sampler2D image,float u,float v){\nfloat alpha;\nreturn oslTexture(image,u,v,OSL_WRAP,OSL_DEFAULT,OSL_ALPHA,alpha);\n}\nvec3 oslTexture(sampler2D image,float u,float v,int wrapModeFlag,int wrapMode,int colorSpaceFlag,int colorSpace){\nfloat alpha;\nreturn oslTexture(image,u,v,wrapModeFlag,wrapMode,OSL_ALPHA,alpha);\n}\nvec3 oslTransform(int fromSpace,int toSpace,vec4 vec){\nif (toSpace==OSL_WORLD||toSpace==OSL_SHADER||toSpace==OSL_COMMON){\nreturn vec.xyz;\n} else if (toSpace==OSL_OBJECT){\nvec=vec4(swizzleUpY(vec.xyz),vec.w);\nvec=invModelMatrix*vec;\nreturn swizzleUpZ(vec.xyz);\n} else if (toSpace==OSL_CAMERA){\nvec=vec4(swizzleUpY(vec.xyz),vec.w);\nreturn (viewMatrix*vec).xyz;\n} else if (toSpace==OSL_SCREEN){\nreturn vec.xyz;\n} else if (toSpace==OSL_RASTER){\nreturn gl_FragCoord.xyz;\n} else if (toSpace==OSL_NDC){\nreturn vec.xyz;\n} else {\nreturn vec.xyz;\n}\n}\nvec3 oslTransform(int fromSpace,int toSpace,vec3 vec){\nreturn oslTransform(fromSpace,toSpace,vec4(vec,1.0));\n}\nvec3 oslTransform(int toSpace,vec3 vec){\nreturn oslTransform(OSL_COMMON,toSpace,vec4(vec,1.0));\n}\nvec3 oslTransformDir(int fromSpace,int toSpace,vec3 vec){\nreturn oslTransform(fromSpace,toSpace,vec4(vec,0.0));\n}\nvec3 oslTransformDir(int toSpace,vec3 vec){\nreturn oslTransform(OSL_COMMON,toSpace,vec4(vec,0.0));\n}\nvec3 oslTransformC(int fromSpace,int toSpace,vec3 vec){\nvec4 outVec=vec4(vec,1.0);\nif (fromSpace==OSL_HSV&&toSpace==OSL_RGB)\nhsvToRGB(vec4(vec,1.0),outVec);\nelse if (fromSpace==OSL_RGB&&toSpace==OSL_HSV)\nrgbToHSV(vec4(vec,1.0),outVec);\nreturn outVec.rgb;\n}\nvec3 oslTransformC(int toSpace,vec3 vec){\nreturn oslTransformC(OSL_RGB,toSpace,vec);\n}\nvoid oslError(){}\nvoid oslFPrintf(){}\nvoid oslPrintf(){}\nvoid oslWarning(){}\nvec3 oslWaveLengthColor(float lambdaNM){\n#if __VERSION__==300\nvec3 xyz=vec3(0.0);\nfloat ii=(lambdaNM-380.0)/5.0;\nint i=int(ii);\nif (i<0||i>=80)\nreturn xyz;\nii-=float(i);\nvec3 c1=cieColorMatch[i];\nvec3 c2=cieColorMatch[i+1];\nxyz=mix(c1,c2,ii);\nreturn xyz_to_sRGB(xyz);\n#else\nreturn vec3(0.0);\n#endif\n}\n#endif",node_incident_frag="void node_incident(vec3 viewPos,out vec3 incident)\n{\n\nvec4 viewDir=vec4(normalize(viewPos),0.0);\nincident=-swizzleUpZ(viewDir.xyz);\n}",node_normal_frag="void node_normal(vec3 norParam,out vec3 norOut)\n{\n#ifdef MT_BLENDER\n#if WORLD_NODES==1\nvec4 viewDir=isOrthographic?vec4(0.0,0.0,-1.0,0.0):vec4(normalize(-vViewPosition),0.0);\nviewDir=invViewMatrix*viewDir;\nnorOut=-swizzleUpZ(viewDir.xyz);\n#else\nnorOut=normalize(invViewMatrix*vec4(norParam,0.0)).xyz;\nnorOut=swizzleUpZ(norOut);\n#endif\n#else\nnorOut=norParam;\n#endif\n}",node_position_frag="void node_position(vec3 posParam,out vec3 posOut)\n{\n#if defined(MT_BLENDER)||defined(MT_MAX)\nposOut=swizzleUpZ(-posParam);\n#else\nposOut=-posParam;\n#endif\n}",node_rgb_alpha_frag="uniform vec4 nodeRGB[NODE_RGB_NUM];\nvoid node_rgb_alpha(vec4 color,out vec3 outColor,out float outAlpha)\n{\noutColor=color.rgb;\noutAlpha=color.a;\n}",node_value_frag="uniform float nodeValue[NODE_VALUE_NUM];\nvoid node_value(float value,out float outValue)\n{\noutValue=value;\n}",node_u_float_frag="void node_u_float(vec2 inUv,out float u)\n{\nu=inUv.x;\n}",node_abs_ar_frag="void node_abs(vec3 inputVal,out vec3 outColor)\n{\noutColor=abs(inputVal);\n}",node_add_ar_frag="void node_add(vec3 input1,vec3 input2,out vec3 outColor)\n{\noutColor=input1+input2;\n}",node_atan_ar_frag="void node_atan(int units,vec3 x,vec3 y,out vec3 outColor)\n{\noutColor=atan(y,x);\nif (units==1)\noutColor=degrees(outColor);\n}",node_checkerboard_ar_frag="void node_checkerboard(const vec2 inUv,vec3 color1,vec3 color2,float uFrequency,float vFrequency,float uOffset,float vOffset,float contrast,out vec3 outColor){\nvec2 uv=-1.0+2.0*inUv;\nfloat fmodResult=mod(floor(uOffset*2.0+uFrequency*uv.x)+floor(vOffset*2.0+vFrequency*uv.y),2.0);\nfloat final=max(sign(fmodResult),0.0);\nvec3 col=vec3(final);\nif (final==0.0)\ncol=color1;\nelse\ncol=color2;\noutColor=col*vec3(contrast)+vec3(1.0-contrast);\n}",node_clamp_ar_frag="void node_clamp(const int mode,vec3 inputValue,float minValue,float maxValue,vec3 minColor,vec3 maxColor,out vec3 outColor,out vec3 outTransparency)\n{\nif (mode==0)\noutColor=clamp(inputValue,vec3(minValue),vec3(maxValue));\nelse\noutColor=clamp(inputValue,minColor,maxColor);\noutTransparency=outColor;\n}",node_color_to_float_ar_frag="void node_color_to_float(const int mode,vec3 inputValue,out float outValue)\n{\nif (mode==0)\noutValue=min(min(inputValue.r,inputValue.g),inputValue.b);\nelse if (mode==1)\noutValue=max(max(inputValue.r,inputValue.g),inputValue.b);\nelse if (mode==2)\noutValue=(inputValue.r+inputValue.g+inputValue.b)/3.0;\nelse if (mode==3)\noutValue=inputValue.r+inputValue.g+inputValue.b;\nelse if (mode==4){\noutValue=dot(inputValue,LUM_WEIGHTS);\n}\nelse if (mode==5)\noutValue=inputValue.r;\nelse if (mode==6)\noutValue=inputValue.g;\nelse if (mode==7)\noutValue=inputValue.b;\n}",node_color_convert_ar_frag="void node_color_convert(const int from,const int to,vec3 inputValue,out vec3 outColor,out vec3 outTransparency)\n{\nvec4 c;\nif (from==to)\nc=vec4(inputValue,1.0);\nelse if (from==0)\nrgbToHSV(vec4(inputValue,1.0),c);\nelse if (from==1)\nhsvToRGB(vec4(inputValue,1.0),c);\noutColor=c.rgb;\noutTransparency=outColor;\n}",node_color_correct_ar_frag="void node_color_correct(vec3 inputValue,float mask,float gamma,float hueShift,float saturation,float contrast,float contrastPivot,float exposure,vec3 multiply,vec3 add,bool invert,bool alphaIsLuminance,float alphaMultiply,float alphaAdd,bool invertAlpha,out vec3 outColor,out float outAlpha)\n{\noutColor=inputValue;\noutColor=invert?1.0-outColor:outColor;\noutColor=vec3(pow(abs(outColor.r),gamma),pow(abs(outColor.g),gamma),pow(abs(outColor.b),gamma));\nvec4 hsv;\nrgbToHSV(vec4(outColor,1.0),hsv);\nhsv[0]+=hueShift/360.0;\nif (hsv[0]>1.0)\nhsv[0]-=1.0;\nelse if (hsv[0]<0.0)\nhsv[0]+=1.0;\n\nhsv[1]*=(saturation);\nhsv[1]=saturate(hsv[1]);\nhsv[2]+=exposure*2.0;\nvec4 c=hsv;\nhsvToRGB(hsv,c);\nc=((c-contrastPivot)*contrast+contrastPivot)*vec4(multiply,1.0)+vec4(add,1.0);\noutColor=c.rgb;\noutAlpha=1.0;\n}",node_compare_ar_frag="void node_compare(int test,float input1,float input2,out bool outValue)\n{\nif (test==0)\noutValue=input1==input2;\nelse if (test==1)\noutvalue=input1 != input2;\nelse if (test==2)\noutValue=input1<input2;\nelse if (test==3)\noutValue=input1>input2;\nelse if (test==4)\noutValue=input1<=input2;\nelse if (test==5)\noutValue=input1>=input2;\n}",node_complement_ar_frag="void node_complement(vec3 inputValue,out vec3 outColor)\n{\noutColor=1.0-inputValue;\n}",node_composite_ar_frag="void node_composite(const int operation,const int alphaOperation,vec3 A,vec3 B,float AA,float BA,out float outAlpha,out vec3 outColor,out vec3 outTransparency)\n{\nvec4 A1=vec4(A,AA);\nvec4 B1=vec4(B,BA);\nvec4 color=vec4(0.0);\nif (operation==0)\ncolor=A1;\nelse if (operation==1)\ncolor=B1;\nelse if (operation==2)\ncolor=A1*B1.a+B1*(1.0-A1.a);\nelse if (operation==3)\ncolor=(A1+B1)/2.0;\nelse if (operation==4)\ncolor=A1.a>B1.a?A1:(A1+B1*(1.0-A1.a)/B1.a);\nelse if (operation==5)\ncolor=abs(A1-B1);\nelse if (operation==6)\ncolor=A1.a+B1.a<1.0?A1+B1:A1+B1*(1.0-A1.a)/B1.a;\nelse if (operation==7)\nfor (int i=0;i<4;i++)\ncolor[i]=B1[i]==0.0?0.0:(A1[i]/B1[i]);\nelse if (operation==8)\ncolor=A1+B1-2.0*A1*B1;\nelse if (operation==9)\ncolor=B1-A1;\nelse if (operation==10)\ncolor=2.0*A1*B1/(A1+B1);\nelse if (operation==11)\nfor (int i=0;i<4;i++)\ncolor[i]=A1[i]<0.5?(A1[i]*B1[i]):(A1[i]>=0.0&&A1[i]<=1.0&&B1[i]>=0.0&&B1[i]<=1.0)?(A1[i]+B1[i]-A1[i]*B1[i]):max(A1[i],B1[i]);\nelse if (operation==12)\ncolor=sqrt(A1*A1+B1*B1);\nelse if (operation==13)\ncolor=A1*B1.a;\nelse if (operation==14)\ncolor=B1*A1.a;\nelse if (operation==15)\ncolor=A1*A1.a+B1*(1.0-A1.a);\nelse if (operation==16)\ncolor=max(A1,B1);\nelse if (operation==17)\ncolor=min(A1,B1);\nelse if (operation==18)\ncolor=A1-B1;\nelse if (operation==19)\ncolor=A1*B1;\nelse if (operation==20)\ncolor=A1*(1.0-B1.a);\nelse if (operation==21)\ncolor=A1+B1*(1.0-A1.a);\nelse if (operation==22)\nfor (int i=0;i<4;i++)\ncolor[i]=B1[i]<0.5?(A1[i]*B1[i]):(A1[i]>=0.0&&A1[i]<=1.0&&B1[i]>=0.0&&B1[i]<=1.0)?(A1[i]+B1[i]-A1[i]*B1[i]):max(A1[i],B1[i]);\nelse if (operation==23)\ncolor=A1+B1;\nelse if (operation==24)\nfor (int i=0;i<4;i++)\ncolor[i]=(A1[i]>=0.0&&A1[i]<=1.0&&B1[i]>=0.0&&B1[i]<=1.0)?(A1[i]+B1[i]-A1[i]*B1[i]):max(A1[i],B1[i]);\n\nelse if (operation==25)\nfor (int i=0;i<4;i++)\ncolor[i]=(A1[i]<.75)?(A1[i]*B1[i]):(A1[i]>=0.0&&A1[i]<=1.0&&B1[i]>=0.0&&B1[i]<=1.0)?(A1[i]+B1[i]-A1[i]*B1[i]):max(A1[i],B1[i]);\nelse if (operation==26)\ncolor=B1*(1.0-A1.a);\nelse if (operation==27)\ncolor=A1*(1.0-B1.a)+B1;\nelse if (operation==28)\ncolor=A1*(1.0-B1.a)+B1*(1.0-A1.a);\nif (alphaOperation==1)\ncolor.a=AA;\nelse if (alphaOperation ==2)\ncolor.a=BA;\noutColor=color.rgb;\noutAlpha=color.a;\noutTransparency=outColor;\n}",node_cross_ar_frag="void node_cross(vec3 input1,vec3 input2,out vec3 outValue)\n{\noutValue=cross(input1,input2);\n}",node_divide_ar_frag="void node_divide(vec3 input1,vec3 input2,out vec3 outColor)\n{\noutColor=input1/input2;\n}",node_dot_ar_frag="void node_dot(vec3 input1,vec3 input2,out vec3 outValue)\n{\noutValue=dot(input1,input2);\n}",node_exp_ar_frag="void node_exp(vec3 inputVal,out vec3 outColor)\n{\noutColor=exp(inputVal);\n}",node_facing_ratio_ar_frag="void node_facing_ratio(vec3 viewNorm,const float bias,const float gain,const bool invert,const bool linear,out float outValue)\n{\noutValue=dot(normalize(viewNorm),normalize(vViewPosition));\n}",node_flat_ar_frag="void node_flat(vec3 color,out vec3 outColor)\n{\noutColor=color;\n}",node_float_to_int_ar_frag="void node_float_to_int(const int mode,float inputValue,out int outValue)\n{\nif (mode==0)\noutValue=int(round(inputValue));\nelse if (mode==1)\noutValue=int(trunc(inputValue));\nelse if (mode==2)\noutValue=int(floor(inputValue));\nelse if (mode==3)\noutValue=int(ceil(inputValue));\n}",node_float_to_matrix_ar_frag="void node_float_to_matrix(float input00,float input01,float input02,float input03,float input10,float input11,float input12,float input13,float input20,float input21,float input22,float input23,float input30,float input31,float input32,float input33,out mat4 outValue)\n{\noutValue=mat4(input00,input01,input02,input03,input10,input11,input12,input13,input20,input21,input22,input23,input30,input31,input32,input33);\n}",node_float_to_rgba_ar_frag="void node_float_to_rgba(float r,float g,float b,float a,out vec4 outColor,out float outAlpha,out vec3 outTransparency)\n{\noutAlpha=a;\noutColor=vec4(r,g,b,a);\noutTransparency=vec3(1.0-a);\n}",node_float_to_rgb_ar_frag="void node_float_to_rgb(float r,float g,float b,out vec3 outValue)\n{\noutValue=vec3(r,g,b);\n}",node_fraction_ar_frag="void node_fraction(vec3 inputValue,out vec3 outColor)\n{\noutColor=fract(inputValue);\n}",node_is_finite_ar_frag="void node_is_finite(vec3 inputValue,out bool outValue)\n{\noutValue=!any(isinf(inputValue));\n}",node_image_ar_frag="\nvoid node_image(sampler2D ima,const int encoding,vec3 multiply,vec3 offset,vec2 uvcoords,float soffset,float toffset,float sscale,float tscale,bool sflip,bool tflip,bool swapSt,out vec3 outColor,out float outAlpha,out vec3 outTransparency){\nvec2 uv=vec2(uvcoords.x,uvcoords.y);\nuv+=vec2(soffset,toffset);\nuv=mix(uv.xy,uv.yx,float(swapSt));\nvec2 stFlip=vec2(float(sflip),float(tflip));\nuv=mix(uv,1.0-uv,stFlip);\nuv*=vec2(sscale,tscale);\nuv.y=1.0-uv.y;\nvec4 tex=texture2D(ima,uv);\noutColor=nodeTexelToLinear(tex,encoding).rgb*multiply+offset;\noutAlpha=tex.a;\noutTransparency=outColor.rgb;\n}\nvoid node_image(sampler2D ima,const int encoding,vec3 multiply,vec3 offset,vec2 uvcoords,float soffset,float toffset,float sscale,float tscale,bool sflip,bool tflip,bool swapSt,vec2 dUVdx,vec2 dUVdy,out vec3 outColor,out float outAlpha,out vec3 outTransparency){\nvec2 uv=vec2(uvcoords.x,uvcoords.y);\nuv+=vec2(soffset,toffset);\nuv=mix(uv.xy,uv.yx,float(swapSt));\nvec2 stFlip=vec2(float(sflip),float(tflip));\nuv=mix(uv,1.0-uv,stFlip);\nuv*=vec2(sscale,tscale);\nuv.y=1.0-uv.y;\n#if __VERSION__==300\nvec2 dInvOp=stFlip*(-2.0)+1.0;\ndUVdx*=vec2(sscale,tscale)*dInvOp;\ndUVdy*=vec2(sscale,tscale)*dInvOp;\nvec4 tex=textureGrad(ima,uv,dUVdx,dUVdy);\n#else\nvec4 tex=texture2D(ima,uv);\n#endif\noutColor=nodeTexelToLinear(tex,encoding).rgb*multiply+offset;\noutAlpha=tex.a;\noutTransparency=outColor.rgb;\n}\nvoid node_image(sampler2D ima,const int encoding,vec4 multiply,vec4 offset,vec2 uvcoords,float soffset,float toffset,float sscale,float tscale,bool sflip,bool tflip,bool swapSt,out vec4 outColor){\nvec2 uv=vec2(uvcoords.x,uvcoords.y);\nuv+=vec2(soffset,toffset);\nuv=mix(uv.xy,uv.yx,float(swapSt));\nvec2 stFlip=vec2(float(sflip),float(tflip));\nuv=mix(uv,1.0-uv,stFlip);\nuv*=vec2(sscale,tscale);\nuv.y=1.0-uv.y;\nvec4 tex=texture2D(ima,uv);\noutColor=nodeTexelToLinear(tex,encoding).rgba*multiply+offset;\n}\nvoid node_image(sampler2D ima,const int encoding,vec4 multiply,vec4 offset,vec2 uvcoords,float soffset,float toffset,float sscale,float tscale,bool sflip,bool tflip,bool swapSt,vec2 dUVdx,vec2 dUVdy,out vec4 outColor){\nvec2 uv=vec2(uvcoords.x,uvcoords.y);\nuv+=vec2(soffset,toffset);\nuv=mix(uv.xy,uv.yx,float(swapSt));\nvec2 stFlip=vec2(float(sflip),float(tflip));\nuv=mix(uv,1.0-uv,stFlip);\nuv*=vec2(sscale,tscale);\nuv.y=1.0-uv.y;\n#if __VERSION__==300\nvec2 dInvOp=stFlip*(-2.0)+1.0;\ndUVdx*=vec2(sscale,tscale)*dInvOp;\ndUVdy*=vec2(sscale,tscale)*dInvOp;\nvec4 tex=textureGrad(ima,uv,dUVdx,dUVdy);\n#else\nvec4 tex=texture2D(ima,uv);\n#endif\noutColor=nodeTexelToLinear(tex,encoding).rgba*multiply+offset;\n}",node_lambert_ar_frag="void node_lambert(vec3 geometryNormal,float base,vec3 baseColor,vec3 normalCamera,vec3 opacity,out vec4 outColor,out float outAlpha,out vec3 outTransparency)\n{\nNodeMaterial material;\nmaterial.diffuseColor=base*baseColor;\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\n#ifdef USE_CLEARCOAT\n#undef USE_CLEARCOAT\n#define _CLEARCOAT_RESTORE\n#endif\nvec3 normal=normalCamera;\n#define RE_Direct RE_DirectDiffuseOnly_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#ifdef _CLEARCOAT_RESTORE\n#undef _CLEARCOAT_RESTORE\n#define USE_CLEARCOAT\n#endif\noutAlpha=average(opacity);\noutColor=vec4(reflectedLight.directDiffuse+reflectedLight.indirectDiffuse,outAlpha);\noutTransparency=vec3(1.0)-opacity;\n}",node_length_ar_frag="void node_length(int mode,vec3 inputVec,out float outValue)\n{\nif (mode==0)\noutValue=length(inputVec);\nelse if (mode==1)\noutValue=dot(inputVec,inputVec);\nelse\noutValue=abs(inputVec.x)+abs(inputVec.y)+abs(inputVec.z);\n}",node_log_ar_frag="void node_log(vec3 inputVec,vec3 base,out vec3 outColor)\n{\noutColor=log(inputVec)/log(base);\n}",node_map_to_mtl_ar_frag="void node_map_to_mtl(bool opaqueEnabled,vec4 color,out vec4 outColor)\n{\noutColor=vec4(color.rgb,opaqueEnabled?color.a:1.0);\n}",node_matrix_transform_ar_frag="\nvoid node_matrix_transform(const int transformOrder,const int rotationType,const int rotationUnits,const int rotationOrder,vec3 rotationEuler,vec3 rotationAxis,float rotationAngle,vec3 translation,vec3 scaling,vec3 pivot,out mat4 outMatrix)\n{\nmat4 tMat=translationToMat4(translation);\nmat4 sMat=scalingToMat4(scaling);\nmat4 rMat=mat4(1.0);\nif (rotationType==0){\nvec3 rot=float(rotationUnits)*radians(rotationEuler)+float(1-rotationUnits)*rotationEuler;\nmat3 matX=mat3RotateX(rot.x);\nmat3 matY=mat3RotateY(-rot.y);\nmat3 matZ=mat3RotateZ(rot.z);\nmat3 rotMat3;\nif (rotationOrder==0){\nrotMat3=matX*matY*matZ;\n} else if (rotationOrder==1){\nrotMat3=matX*matZ*matY;\n} else if (rotationOrder==2){\nrotMat3=matY*matX*matZ;\n} else if (rotationOrder==3){\nrotMat3=matY*matZ*matX;\n} else if (rotationOrder==4){\nrotMat3=matZ*matX*matY;\n} else if (rotationOrder==5){\nrotMat3=matZ*matY*matX;\n}\nrMat=toMat4(rotMat3);\n} else if (rotationType==1){\nfloat angleInRadians=float(rotationUnits)*radians(rotationAngle)+float(1-rotationUnits)*rotationAngle;\nrotationAxis=normalize(rotationAxis);\nrMat=toMat4(axisAngleToMat3(rotationAxis,angleInRadians));\n}\nif (transformOrder==0){\noutMatrix=sMat*rMat*tMat;\n} else if (transformOrder==1){\noutMatrix=sMat*tMat*rMat;\n} else if (transformOrder==2){\noutMatrix=rMat*sMat*tMat;\n} else if (transformOrder==3){\noutMatrix=rMat*tMat*sMat;\n} else if (transformOrder==4){\noutMatrix=tMat*sMat*rMat;\n} else if (transformOrder==5){\noutMatrix=tMat*rMat*sMat;\n}\nmat4 rotX90=toMat4(mat3RotateX(PI*0.5));\nmat4 pivotMat=translationToMat4(pivot);\nmat4 invPivotMat=inverse(pivotMat);\noutMatrix=invPivotMat*outMatrix*pivotMat*rotX90;\n}\nvoid node_matrix_transform(const int transformOrder,const int rotationType,const int rotationUnits,const int rotationOrder,vec3 rotationEuler,vec3 rotationAxis,float rotationAngle,vec3 translation,vec3 scaling,vec3 pivot,out mat4 outMatrix,out vec3 outTransparency)\n{\nmat4 tMat=translationToMat4(translation);\nmat4 sMat=scalingToMat4(scaling);\nmat4 rMat=mat4(1.0);\nif (rotationType==0){\nvec3 rot=mix(rotationEuler,radians(rotationEuler),float(rotationUnits));\nmat3 matX=mat3RotateX(rot.x);\nmat3 matY=mat3RotateY(-rot.y);\nmat3 matZ=mat3RotateZ(rot.z);\nmat3 rotMat3;\nif (rotationOrder==0){\nrotMat3=matX*matY*matZ;\n} else if (rotationOrder==1){\nrotMat3=matX*matZ*matY;\n} else if (rotationOrder==2){\nrotMat3=matY*matX*matZ;\n} else if (rotationOrder==3){\nrotMat3=matY*matZ*matX;\n} else if (rotationOrder==4){\nrotMat3=matZ*matX*matY;\n} else if (rotationOrder==5){\nrotMat3=matZ*matY*matX;\n}\nrMat=toMat4(rotMat3);\n} else if (rotationType==1){\nfloat angleInRadians=mix(rotationAngle,radians(rotationAngle),float(rotationUnits));\nrotationAxis=normalize(rotationAxis);\nrMat=toMat4(axisAngleToMat3(rotationAxis,angleInRadians));\n}\noutMatrix=rMat;\nif (transformOrder==0){\noutMatrix=sMat*rMat*tMat;\n} else if (transformOrder==1){\noutMatrix=sMat*tMat*rMat;\n} else if (transformOrder==2){\noutMatrix=rMat*sMat*tMat;\n} else if (transformOrder==3){\noutMatrix=rMat*tMat*sMat;\n} else if (transformOrder==4){\noutMatrix=tMat*sMat*rMat;\n} else if (transformOrder==5){\noutMatrix=tMat*rMat*sMat;\n}\nmat4 pivotMat=translationToMat4(pivot);\nmat4 invPivotMat=inverse(pivotMat);\noutMatrix=invPivotMat*outMatrix*pivotMat;\n}",node_max_ar_frag="void node_max(vec3 input1,vec3 input2,out vec3 outColor)\n{\noutColor=max(input1,input2);\n}",node_min_ar_frag="void node_min(vec3 input1,vec3 input2,out vec3 outColor)\n{\noutColor=min(input1,input2);\n}",node_mix_shader_ar_frag="void node_mix_shader(const int mode,const float mixAmt,vec4 shader1,vec4 shader2,out vec4 color)\n{\nshader1.rgb*=shader1.a;\nshader2.rgb*=shader2.a;\nif (mode==0)\ncolor=mix(shader1,shader2,clamp(mixAmt,0.0,1.0));\nelse\ncolor=vec4(shader1.rgb+shader2.rgb,min(shader1.a,shader2.a));\ncolor.rgb/=color.a;\n}",node_modulo_ar_frag="void node_modulo(vec3 inputVec,vec3 divisor,out vec3 outColor)\n{\noutColor=mod(inputVec,divisor);\n}",node_multiply_ar_frag="void node_multiply(vec3 input1,vec3 input2,out vec3 outColor)\n{\noutColor=input1*input2;\n}",node_negate_ar_frag="void node_negate(vec3 inputVec,out vec3 outColor)\n{\noutColor=-inputVec;\n}",node_normalize_ar_frag="void node_normalize(vec3 inputVec,out vec3 outValue)\n{\noutValue=normalize(inputVec);\n}",node_normal_map_ar_frag="void node_normal_map(vec4 tangentParam,vec3 inputVal,vec3 normal,float strength,vec3 tangent,out vec3 outValue){\n#ifdef DOUBLE_SIDED\nnormal=normal*(float(gl_FrontFacing)*2.0-1.0);\n#endif\nvec3 normalTex=inputVal.xyz*2.0-1.0;\nvec3 bitangent=tangentParam.w*cross(normal,tangent);\noutValue=normalize(normalTex.x*tangent+normalTex.y*bitangent+normalTex.z*normal);\noutValue=mix(normal,outValue,strength);\n}",node_pow_ar_frag="void node_pow(vec3 base,vec3 exponent,out vec3 outColor)\n{\noutColor=pow(base,exponent);\n}",node_random_ar_frag="void node_abs(vec3 inputColor,out vec3 outColor)\n{\noutColor=inputColor;\n}",node_range_ar_frag="void node_range(vec3 inputValue,float inputMin,float inputMax,float outputMin,float outputMax,bool smoothstep1,float contrast,float contrastPivot,float bias,float gain,out vec3 outColor,out vec3 outTransparency)\n{\n\noutColor=min(max(inputValue,vec3(inputMin)),vec3(inputMax));\noutColor=(outColor-contrastPivot)*contrast+contrastPivot;\nif (smoothstep1==true){\nfor (int i=0;i<3;i++)\noutColor[i]=smoothstep(outputMin,outputMax,outColor[i]);\n} else\noutColor=min(max(outColor,vec3(outputMin)),vec3(outputMax));\noutTransparency=outColor;\n}",node_ray_switch_ar_frag="void node_ray_switch(vec3 camera,vec3 diffuseReflection,vec3 diffuseTransmission,vec3 shadow,vec3 specularReflection,vec3 specularTransmission,out vec3 outColor,out float outAlpha)\n{\n#if LIGHT_PATH_IS_CAM_RAY\noutColor=camera;\n#else\noutColor=diffuseReflection;\n#endif\noutAlpha=1.0;\n}",node_reciprocal_ar_frag="void node_reciprocal(vec3 inputVec,out vec3 outColor)\n{\noutColor=1.0/inputVec;\n}",node_rgba_to_float_ar_frag="void node_rgba_to_float(const int mode,vec3 inputValue,float inputA,out float outValue,out vec3 outTransparency)\n{\noutTransparency=inputValue+vec3(inputA/4.0);\nif (mode==0)\noutValue=min(min(min(inputValue.r,inputValue.g),inputValue.b),inputA);\nelse if (mode==1)\noutValue=max(max(max(inputValue.r,inputValue.g),inputValue.b),inputA);\nelse if (mode==2)\noutValue=(inputValue.r+inputValue.g+inputValue.b+inputA)/4.0;\nelse if (mode==3)\noutValue=inputValue.r+inputValue.g+inputValue.b+inputA;\nelse if (mode==4){\noutValue=dot(inputValue,LUM_WEIGHTS);\n}\nelse if (mode==5)\noutValue=inputValue.r;\nelse if (mode==6)\noutValue=inputValue.g;\nelse if (mode==7)\noutValue=inputValue.b;\n}",node_rgb_to_float_ar_frag="void node_rgb_to_float(const int mode,vec3 inputValue,out float outValue)\n{\nif (mode==0)\noutValue=min(min(inputValue.r,inputValue.g),inputValue.b);\nelse if (mode==1)\noutValue=max(max(inputValue.r,inputValue.g),inputValue.b);\nelse if (mode==2)\noutValue=(inputValue.r+inputValue.g+inputValue.b)/3.0;\nelse if (mode==3)\noutValue=inputValue.r+inputValue.g+inputValue.b;\nelse if (mode==4){\noutValue=dot(inputValue,LUM_WEIGHTS);\n}\nelse if (mode==5)\noutValue=inputValue.r;\nelse if (mode==6)\noutValue=inputValue.g;\nelse if (mode==7)\noutValue=inputValue.b;\n}",node_rgb_to_vector_ar_frag="void node_rgb_to_vector(const int mode,vec3 inputValue,out vec3 outValue)\n{\n\noutValue=inputValue;\n}",node_shadow_matte_ar_frag="#include <shadowmask_pars_fragment>\nvoid node_shadow_matte(vec3 normal,vec3 shadowColor,float backlighting,float shadowOpacity,out vec4 outColor,out float outAlpha){\nfloat shadow=getShadowMask();\noutColor=vec4(shadowColor,shadowOpacity*(1.0-shadow));\noutAlpha=outColor.a;\n}",node_shuffle_ar_frag="\nvoid node_shuffle(const int channelR,const int channelG,const int channelB,const int channelA,vec3 color,float alpha,bool negateR,bool negateG,bool negateB,bool negateA,out vec3 outColor,out float outAlpha)\n{\noutColor=vec3(0.0);\nvec4 choose=vec4(color,alpha);\noutAlpha=1.0;\n#if __VERSION__==100\noutColor.r=choose[0];\noutColor.g=choose[1];\noutColor.b=choose[2];\noutAlpha=choose[3];\n#else\noutColor.r=choose[channelR];\noutColor.g=choose[channelG];\noutColor.b=choose[channelB];\noutAlpha=choose[channelA];\n#endif\nif (negateR)\noutColor.r=-outColor.r;\nif (negateG)\noutColor.g=-outColor.g;\nif (negateB)\noutColor.b=-outColor.b;\nif (negateA)\noutAlpha=-outAlpha;\n}\nvoid node_shuffle(const int channelR,const int channelG,const int channelB,const int channelA,vec4 color,float alpha,bool negateR,bool negateG,bool negateB,bool negateA,out vec4 outColor)\n{\noutColor=vec4(0.0);\nvec4 choose=vec4(color.rgb,alpha);\n#if __VERSION__==100\noutColor.r=choose[0];\noutColor.g=choose[1];\noutColor.b=choose[2];\noutColor.a=choose[3];\n#else\noutColor.r=choose[channelR];\noutColor.g=choose[channelG];\noutColor.b=choose[channelB];\noutColor.a=choose[channelA];\n#endif\nif (negateR)\noutColor.r=-outColor.r;\nif (negateG)\noutColor.g=-outColor.g;\nif (negateB)\noutColor.b=-outColor.b;\nif (negateA)\noutColor.a=-outColor.a;\n}",node_sign_ar_frag="void node_sign(vec3 inputVec,out vec3 outColor)\n{\noutColor=sign(inputVec);\n}",node_skydome_light_ar_frag="void node_skydome_light(vec3 color,float intensity,out vec4 outgoingLight)\n{\noutgoingLight=vec4(color*intensity,1.0);\n}",node_sqrt_ar_frag="void node_sqrt(vec3 inputVec,out vec3 outColor)\n{\noutColor=sqrt(inputVec);\n}",node_standard_surface_ar_frag="void node_standard_surface(vec3 geometryNormal,const bool thinWalled,const float base,const vec3 baseColor,const float diffuseRoughness,const float metalness,const float specular,const vec3 specularColor,const float specularRoughness,const float trans,const vec3 transColor,const float transDepth,const vec3 transScatter,const float transExtraRoughness,const float subsurface,const vec3 subsurfaceColor,const vec3 subsurfaceRadius,const float clearcoat,const vec3 clearcoatColor,const float clearcoatRoughness,const float sheen,const vec3 sheenColor,const float sheenRoughness,const float emission,const vec3 emissionColor,const vec3 opacity,const vec3 normal,const vec3 clearcoatNormal,const float specularIOR,out vec4 outColor,out vec3 outTransparency)\n{\nNodeMaterial material;\nvec3 baseColorWeighted=base*baseColor.rgb;\nmaterial.diffuseColor=baseColorWeighted*(1.0-metalness)*(1.0-trans);\n#ifdef USE_CLEARCOAT\nmaterial.clearcoat=saturate(clearcoat);\nmaterial.clearcoatRoughness=clamp(clearcoatRoughness,0.0,1.0);\nmaterial.clearcoatF0=vec3(0.04);\nmaterial.clearcoatF90=1.0;\n#endif\n#ifdef USE_SHEEN\nmaterial.sheenColor=saturate(sheen*sheenColor);\nmaterial.sheenRoughness=clamp(sheenRoughness,0.0,1.0);\n#endif\nvec3 dxy=max(abs(dFdx(geometryNormal)),abs(dFdy(geometryNormal)));\nfloat geometryRoughness=max(max(dxy.x,dxy.y),dxy.z);\nmaterial.roughness=max(specularRoughness,0.0525);\nmaterial.roughness+=geometryRoughness;\nmaterial.roughness=min(material.roughness,1.0);\nvec3 specularColorWeighted=specular*specularColor;\nvec3 dielRefl=pow2((1.0-specularIOR)/(1.0+specularIOR))*specularColorWeighted;\nmaterial.specularColor=mix(dielRefl,baseColorWeighted,metalness);\nmaterial.fresnelRefl90=mix(specularColorWeighted,vec3(1.0),metalness);\nmaterial.specularF90=average(material.fresnelRefl90);\nmaterial.refractionColor=pow(trans*(1.0-metalness)*transColor.rgb,vec3(2.0));\nmaterial.refractionIOR=specularIOR;\nmaterial.refractionRoughness=material.roughness;\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\nvec3 refractedLight=vec3(0.0);\n#ifdef USE_GTAO\nvec4 gtaoVisibilityBentNormal=texture2D(gtaoMap,gl_FragCoord.xy/currResolution);\nvec3 bentNormal=normalize(unpackRGBToNormal(gtaoVisibilityBentNormal.gba));\n#define PROBE_NORMAL bentNormal\n#endif\n#define RE_Direct RE_Direct_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Node\n#define RE_IndirectSpecular RE_IndirectSpecular_Node\n#define RE_Refraction RE_Refraction_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#undef RE_IndirectSpecular\n#undef RE_Refraction\n#ifdef PROBE_NORMAL\n#undef PROBE_NORMAL\n#endif\n#ifdef USE_GTAO\nreflectedLight.indirectDiffuse*=gtaoVisibilityBentNormal.r;\nfloat gtaoVisibility=gtaoVisibilityBentNormal.r;\nvec3 gtaoBentNormal=bentNormal;\nvec3 gtaoViewDir=geometry.viewDir;\nvec3 gtaoNormal=normal;\nfloat gtaoRoughness=material.roughness;\n#endif\n#include <lights_fragment_gtso>\nvec3 totalEmissiveRadiance=emission*emissionColor;\nvec3 outSpecular=reflectedLight.directSpecular+reflectedLight.indirectSpecular;\nvec3 outColor3=reflectedLight.directDiffuse+reflectedLight.indirectDiffuse +\noutSpecular+totalEmissiveRadiance;\n#ifdef USE_SHEEN\nfloat sheenEnergyComp=1.0-0.157*max3(material.sheenColor);\noutColor3=outColor3*sheenEnergyComp+sheenSpecular;\n#endif\n#ifdef USE_CLEARCOAT\nfloat dotNVcc=saturate(dot(geometry.normal,geometry.viewDir));\nvec3 Fcc=F_Schlick(material.clearcoatF0,material.clearcoatF90,dotNVcc);\noutColor3=outColor3*(1.0-material.clearcoat*Fcc)+clearcoatSpecular*material.clearcoat;\n#endif\nfloat alpha=1.0;\nif (thinWalled){\nalpha=average(opacity)*(1.0-saturate(trans)+maxFromRGB(outSpecular)*saturate(trans));\n} else {\noutColor3+=refractedLight;\n}\noutColor=vec4(outColor3,saturate(alpha));\noutTransparency=outColor3;\n}",node_subtract_ar_frag="void node_subtract(vec3 input1,vec3 input2,out vec3 outColor)\n{\noutColor=input1-input2;\n}",node_trigo_ar_frag="void node_trigo(const int function,const int units,vec3 inputVec,float frequency,float phase,out vec3 outColor)\n{\nif (units==1&&function>=0&&function <=2)\ninputVec=radians(inputVec);\nif (function==0)\noutColor=cos(inputVec*frequency+phase);\nelse if (function==1)\noutColor=sin(inputVec*frequency+phase);\nelse if (function==2)\noutColor=tan(inputVec*frequency+phase);\nelse if (function==3)\noutColor=acos(inputVec*frequency+phase);\nelse if (function==4)\noutColor=asin(inputVec*frequency+phase);\nelse if (function==5)\noutColor=atan(inputVec*frequency+phase);\nelse if (function==6)\noutColor=cosh(inputVec*frequency+phase);\nelse if (function==7)\noutColor=sinh(inputVec*frequency+phase);\nelse\noutColor=tanh(inputVec*frequency+phase);\nif (units==1&&function>=3&&function <=5)\noutColor=degrees(outColor);\n}",node_triplanar_ar_frag="\nvoid node_triplanar(const int coordSpace,const bool inputPerAxis,const bool flipOnOppositeDirection,const float blendFactor,vec4 inputColor,vec4 inputColorY,vec4 inputColorZ,vec3 scaling,vec3 rotation,vec3 offset,vec3 normal,out vec4 outColor)\n{\nif (inputPerAxis==true){\nvec3 barycentric=abs(normal);\nbarycentric/=barycentric.x+barycentric.y+barycentric.z;\nvec3 edgeShape=min(min(barycentric.yzx,barycentric.zxy),(blendFactor-1.0)/(blendFactor-3.0));\nvec3 edgeValue=(1.0-blendFactor)*(1.0-edgeShape)/2.0;\nvec3 weight=max((barycentric-edgeValue)/(1.0-edgeValue),EPSILON);\nweight/=(weight.x+weight.y+weight.z);\noutColor=weight.x*inputColor+weight.y*inputColorY+weight.z*inputColorZ;\n} else {\noutColor=inputColor;\n}\n}\nvoid node_triplanar(const int coordSpace,const bool inputPerAxis,const bool flipOnOppositeDirection,const float blendFactor,vec3 inputColor,vec3 inputColorY,vec3 inputColorZ,vec3 scaling,vec3 rotation,vec3 offset,vec3 normal,out vec3 outColor)\n{\nif (inputPerAxis==true){\nvec3 barycentric=abs(normal);\nbarycentric/=barycentric.x+barycentric.y+barycentric.z;\nvec3 edgeShape=min(min(barycentric.yzx,barycentric.zxy),(blendFactor-1.0)/(blendFactor-3.0));\nvec3 edgeValue=(1.0-blendFactor)*(1.0-edgeShape)/2.0;\nvec3 weight=max((barycentric-edgeValue)/(1.0-edgeValue),EPSILON);\nweight/=(weight.x+weight.y+weight.z);\noutColor=weight.x*inputColor+weight.y*inputColorY+weight.z*inputColorZ;\n} else {\noutColor=inputColor;\n}\n}",node_triplanar_uv_ar_frag="\nfloat screenSpaceDither12(vec2 vScreenPos){\nfloat vDither=dot(vec2(171.0,231.0),vScreenPos.xy);\nreturn fract(vDither/103.0);\n}\nvec3 smoothContrast(vec3 alpha,float contrast){\nvec3 powAlpha=pow(alpha,vec3(contrast));\nreturn powAlpha/(powAlpha.x+powAlpha.y+powAlpha.z);\n}\nvoid node_triplanar_uv(const bool flipOnOppositeDirection,const float blendFactor,vec3 vector,vec3 normal,out vec2 outUV,out vec2 dUVdx,out vec2 dUVdy)\n{\nvec3 norm=normal;\nfloat fp=float(flipOnOppositeDirection);\nvec2 xFac=mix(vec2(1.0),vec2(-sign(norm.x),1.0),fp);\nvec2 uvX=vec2(vector.z,vector.y)*xFac+0.5;\nvec2 yFac=mix(vec2(1.0),vec2(1.0,-sign(norm.y)),fp);\nvec2 uvY=vec2(vector.x,vector.z)*yFac+0.5;\nvec2 zFac=vec2(mix(1.0,sign(norm.z),fp),1.0);\nvec2 uvZ=vec2(vector.x,vector.y)*zFac+0.5;\n#if __VERSION__==300\nvec3 alpha=abs(norm);\nfloat contrast=mix(20.0,1.0,blendFactor);\nalpha=smoothContrast(alpha,contrast);\nfloat dither=screenSpaceDither12(gl_FragCoord.xy);\ndither=clamp(dither,0.01,0.99);\nvec3 duvwdx=dFdx(vector);\nvec3 duvwdy=dFdy(vector);\nif (alpha.x>dither){\noutUV=uvX;\ndUVdx=duvwdx.yz*xFac;\ndUVdy=duvwdy.yz*xFac;\n} else if (1.0-alpha.z>dither){\noutUV=uvY;\ndUVdx=duvwdx.xz*yFac;\ndUVdy=duvwdy.xz*yFac;\n} else {\noutUV=uvZ;\ndUVdx=duvwdx.xy*zFac;\ndUVdy=duvwdy.xy*zFac;\n}\n#else\nvec3 absNorm=abs(norm);\nvec3 faceMask=step(absNorm.yzx,absNorm)*step(absNorm.zxy,absNorm);\noutUV=faceMask.x*uvX+faceMask.y*uvY+faceMask.z*uvZ;\n#endif\n}\nvoid node_triplanar_uv(const bool flipOnOppositeDirection,const int projectionAxis,vec3 vector,vec3 normal,out vec2 outUV)\n{\nvec3 norm=normal;\nfloat fp=float(flipOnOppositeDirection);\nif (projectionAxis==0){\nvec2 xFac=mix(vec2(1.0),vec2(-sign(norm.x),1.0),fp);\noutUV=vec2(vector.z,vector.y)*xFac+0.5;\n} else if (projectionAxis==1){\nvec2 yFac=mix(vec2(1.0),vec2(1.0,-sign(norm.y)),fp);\noutUV=vec2(vector.x,vector.z)*yFac+0.5;\n} else if (projectionAxis==2){\nvec2 zFac=vec2(mix(1.0,sign(norm.z),fp),1.0);\noutUV=vec2(vector.x,vector.y)*zFac+0.5;\n} else if (projectionAxis==3){\nvec2 xFac=mix(vec2(1.0),vec2(-sign(norm.x),1.0),fp);\nvec2 uvX=vec2(vector.z,vector.y)*xFac+0.5;\nvec2 yFac=mix(vec2(1.0),vec2(1.0,-sign(norm.y)),fp);\nvec2 uvY=vec2(vector.x,vector.z)*yFac+0.5;\nvec2 zFac=vec2(mix(1.0,sign(norm.z),fp),1.0);\nvec2 uvZ=vec2(vector.x,vector.y)*zFac+0.5;\nvec3 absNorm=abs(norm);\nvec3 faceMask=step(absNorm.yzx,absNorm)*step(absNorm.zxy,absNorm);\noutUV=faceMask.x*uvX+faceMask.y*uvY+faceMask.z*uvZ;\n}\n}",node_two_sided_ar_frag="void node_two_sided(float frontFacing,vec3 front,vec3 back,out vec3 outColor)\n{\noutColor=(frontFacing>0.0)?front:back;\n}",node_user_data_color_ar_frag="void node_user_data_color(vec4 color,out vec3 outColor,out float outAlpha)\n{\noutColor=color.rgb;\noutAlpha=color.a;\n}",node_uv_projection_ar_frag="#define TEX_PROJ_PLANAR 0\n#define TEX_PROJ_SPHERICAL 1\n#define TEX_PROJ_CYLINDRICAL 2\n#define TEX_PROJ_BALL 3\n#define TEX_PROJ_CUBIC 4\n#define TEX_PROJ_SHRINK_WRAP 5\n#define COORD_WORLD_SPACE 0\n#define COORD_OBJECT_SPACE 1\nvoid node_uv_projection(const int projectionType,const int coordSpace,vec3 projectionColor,float uAngleDegrees,float vAngleDegrees,mat4 matrix,out vec2 outUV)\n{\nvec3 vector=vWorldPosition.xyz;\nif (coordSpace==COORD_OBJECT_SPACE){\nvector=(invModelMatrix*vec4(vector,1.0)).xyz;\n}\nvector=(matrix*vec4(vector,1.0)).xyz;\nif (projectionType==TEX_PROJ_PLANAR){\noutUV=vector.xy*0.5+0.5;\n} else if (projectionType==TEX_PROJ_SPHERICAL){\nvector=normalize(vector);\nfloat uAngle=radians(uAngleDegrees);\nfloat vAngle=radians(vAngleDegrees);\nfloat theta=atan(vector.x,vector.z)/(uAngle);\ntheta=theta*0.5+0.5;\nfloat vAngleNormalized=vAngle*2.0/PI;\nfloat phi=(acos(-vector.y)/PI-0.5)/vAngleNormalized+0.5;\noutUV=vec2(theta,phi);\n} else if (projectionType==TEX_PROJ_CYLINDRICAL){\nvector.xz=normalize(vector).xz;\nfloat uAngle=radians(uAngleDegrees);\nvec2 uv=vec2((atan(vector.x,vector.z))/(uAngle),(vector.y)/2.0);\noutUV=uv+0.5;\n} else if (projectionType==TEX_PROJ_BALL){\nvec3 normal=normalize(vector);\nnormal.z+=1.0;\nnormal/=(2.0*sqrt(max(0.5*normal.z,0.0)));\noutUV=clamp(0.5*normal.xy+0.5,0.0,1.0);\n} else if (projectionType==TEX_PROJ_CUBIC){\nvec2 uvX=vec2(vector.z,vector.y)/abs(vector.x);\nvec2 uvY=vec2(vector.x,vector.z)/abs(vector.y);\nvec2 uvZ=vec2(vector.x,vector.y)/abs(vector.z);\nvec3 absVec=abs(vector);\nvec3 faceMask=step(absVec.yzx,absVec)*step(absVec.zxy,absVec);\nvec2 uv=faceMask.x*uvX+faceMask.y*uvY+faceMask.z*uvZ;\nuv=uv*0.5+0.5;\noutUV=uv;\n} else if (projectionType==TEX_PROJ_SHRINK_WRAP){\nvector=normalize(vector);\noutUV=normalize(vector.xz)*acos(vector.y)/PI;\noutUV=outUV*0.5+0.5;\n}\n}",node_vector_to_rgb_ar_frag="void node_vector_to_rgb(const int mode,vec3 inputValue,out vec3 outColor)\n{\nif (mode==0)\noutColor=inputValue;\nelse if (mode==1)\noutColor=normalize(inputValue);\nelse if (mode==2)\noutColor=inputValue;\n}",node_add_shader_bl_frag="void node_add_shader(vec4 color1,vec4 color2,out vec4 outColor){\noutColor.rgb=color1.rgb+color2.rgb;\noutColor.a=clamp(color1.a+color2.a,0.0,1.0);\n}",node_ambient_occlusion_bl_frag="void node_ambient_occlusion(vec4 color,float distance,vec3 normal,out vec4 outColor,out float outAO){\noutColor=color;\noutAO=1.0;\n}",node_attribute_bl_frag="void node_attribute(vec4 paramAttr,out vec4 outColor,out vec3 outVector,out float outFac,out float outAlpha){\noutColor=vec4(paramAttr.xyz,1.0);\noutVector=paramAttr.xyz;\noutFac=average(paramAttr.xyz);\noutAlpha=paramAttr.w;\n}",node_background_bl_frag="void node_background(vec4 color,float strength,out vec4 outColor)\n{\noutColor=strength*color;\n}",node_bevel_bl_frag="void node_bevel(float radius,vec3 normal,out vec3 outNormal){\noutNormal=normal;\n}",node_blackbody_bl_frag="void node_blackbody(float temp,out vec4 outColor)\n{\noutColor=vec4(colorTempToRGB(temp),1.0);\n}",node_brightcontrast_bl_frag="void node_brightcontrast(vec4 color,float bright,float contrast,out vec4 outColor)\n{\nfloat bminc=bright-contrast*0.5;\noutColor.r=max((1.0+contrast)*color.r+bminc,0.0);\noutColor.g=max((1.0+contrast)*color.g+bminc,0.0);\noutColor.b=max((1.0+contrast)*color.b+bminc,0.0);\noutColor.a=color.a;\n}",node_bsdf_anisotropic_bl_frag="void node_bsdf_anisotropic(vec4 color,float roughness,float anisotropy,float rotation,vec3 normal,vec3 tangent,out vec4 outColor)\n{\noutColor=color;\n}",node_bsdf_diffuse_bl_frag="void node_bsdf_diffuse(vec4 color,float roughness,vec3 normal,out vec4 outColor){\nnormal=vec3(normal[0],normal[2],-normal[1]);\nnormal=(viewMatrix*vec4(normal.xyz,0.0)).xyz;\nNodeMaterial material;\nmaterial.diffuseColor=color.rgb;\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\n#ifdef USE_CLEARCOAT\n#undef USE_CLEARCOAT\n#define _CLEARCOAT_RESTORE\n#endif\n#ifdef USE_GTAO\nvec4 gtaoVisibilityBentNormal=texture2D(gtaoMap,gl_FragCoord.xy/currResolution);\nvec3 bentNormal=normalize(unpackRGBToNormal(gtaoVisibilityBentNormal.gba));\n#define PROBE_NORMAL bentNormal\n#endif\n#define RE_Direct RE_DirectDiffuseOnly_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#ifdef PROBE_NORMAL\n#undef PROBE_NORMAL\n#endif\n#ifdef _CLEARCOAT_RESTORE\n#undef _CLEARCOAT_RESTORE\n#define USE_CLEARCOAT\n#endif\n#ifdef USE_GTAO\nreflectedLight.indirectDiffuse*=gtaoVisibilityBentNormal.r;\n#endif\noutColor=vec4(reflectedLight.directDiffuse+reflectedLight.indirectDiffuse,1.0);\n}",node_bsdf_glass_bl_frag="void node_bsdf_glass(vec3 geometryNormal,vec4 color,float roughness,float ior,vec3 normal,float thinFilmThickness,float thinFilmIOR,out vec4 outColor){\nnormal=normalize(normal);\nnormal=swizzleUpY(normal);\nvec3 normalWorld=normal;\nnormal=(viewMatrix*vec4(normal.xyz,0.0)).xyz;\nNodeMaterial material;\nmaterial.specularColor=vec3(1.0);\nmaterial.fresnelRefl90=vec3(1.0);\nmaterial.roughness=clamp(roughness,0.0,1.0);\nmaterial.refractionColor=vec3(1.0);\nmaterial.refractionIOR=ior;\nmaterial.refractionRoughness=pow2(roughness);\n#if defined(ENVMAP_TYPE_CUBE)||defined(ENVMAP_TYPE_CUBE_UV)\nfloat geomRoughness=calcGeometryRoughness(geometryNormal);\nmaterial.roughness=calcCubeUVAdjustedRoughness(material.roughness,geomRoughness);\nmaterial.refractionRoughness=calcCubeUVAdjustedRoughness(material.refractionRoughness,geomRoughness);\n#endif\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\nvec3 refractedLight=vec3(0.0);\n#ifdef USE_CLEARCOAT\n#undef USE_CLEARCOAT\n#define _CLEARCOAT_RESTORE\n#endif\n#ifdef USE_GTAO\nvec4 gtaoVisibilityBentNormal=texture2D(gtaoMap,gl_FragCoord.xy/currResolution);\nvec3 bentNormal=normalize(unpackRGBToNormal(gtaoVisibilityBentNormal.gba));\n#define PROBE_NORMAL bentNormal\n#endif\n#define RE_Direct RE_Direct_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Empty\n#define RE_IndirectSpecular RE_IndirectSpecular_Node\n#define RE_Refraction RE_Refraction_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#undef RE_IndirectSpecular\n#undef RE_Refraction\n#ifdef PROBE_NORMAL\n#undef PROBE_NORMAL\n#endif\n#ifdef _CLEARCOAT_RESTORE\n#undef _CLEARCOAT_RESTORE\n#define USE_CLEARCOAT\n#endif\n#ifdef USE_GTAO\nfloat gtaoVisibility=gtaoVisibilityBentNormal.r;\nvec3 gtaoBentNormal=bentNormal;\nvec3 gtaoViewDir=geometry.viewDir;\nvec3 gtaoNormal=normal;\nfloat gtaoRoughness=material.roughness;\n#endif\n#include <lights_fragment_gtso>\nvec3 viewWorld;\nif (isOrthographic)\nviewWorld=(invViewMatrix*vec4(0.0,0.0,-1.0,0.0)).xyz;\nelse\nviewWorld=(invViewMatrix*vec4(-vViewPosition,0.0)).xyz;\nviewWorld=normalize(viewWorld);\nfloat fresnel=fresnelReflection(viewWorld,normalWorld,ior);\noutColor=vec4(color.rgb*mix(refractedLight,reflectedLight.directSpecular\n+ reflectedLight.indirectSpecular,fresnel),1.0);\n}\nvoid node_bsdf_glass(vec3 geometryNormal,vec4 color,float roughness,float ior,vec3 normal,out vec4 outColor){\nnode_bsdf_glass(geometryNormal,color,roughness,ior,normal,0.0,0.0,outColor);\n}",node_bsdf_glossy_bl_frag="void node_bsdf_glossy(vec3 geometryNormal,vec4 color,float roughness,float anisotropy,float rotation,vec3 normal,vec3 tangent,out vec4 outColor){\nnormal=vec3(normal[0],normal[2],-normal[1]);\nnormal=normalize((viewMatrix*vec4(normal.xyz,0.0)).xyz);\nNodeMaterial material;\nmaterial.specularColor=vec3(1.0);\nmaterial.fresnelRefl90=vec3(1.0);\nmaterial.roughness=clamp(roughness,0.0,1.0);\n#if defined(ENVMAP_TYPE_CUBE)||defined(ENVMAP_TYPE_CUBE_UV)\nfloat geomRoughness=calcGeometryRoughness(geometryNormal);\nmaterial.roughness=calcCubeUVAdjustedRoughness(material.roughness,geomRoughness);\n#endif\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\n#ifdef USE_CLEARCOAT\n#undef USE_CLEARCOAT\n#define _CLEARCOAT_RESTORE\n#endif\n#ifdef USE_GTAO\nvec4 gtaoVisibilityBentNormal=texture2D(gtaoMap,gl_FragCoord.xy/currResolution);\nvec3 bentNormal=normalize(unpackRGBToNormal(gtaoVisibilityBentNormal.gba));\n#define PROBE_NORMAL bentNormal\n#endif\n#define RE_Direct RE_Direct_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Empty\n#define RE_IndirectSpecular RE_IndirectSpecular_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#undef RE_IndirectSpecular\n#ifdef PROBE_NORMAL\n#undef PROBE_NORMAL\n#endif\n#ifdef _CLEARCOAT_RESTORE\n#undef _CLEARCOAT_RESTORE\n#define USE_CLEARCOAT\n#endif\n#ifdef USE_GTAO\nfloat gtaoVisibility=gtaoVisibilityBentNormal.r;\nvec3 gtaoBentNormal=bentNormal;\nvec3 gtaoViewDir=geometry.viewDir;\nvec3 gtaoNormal=normal;\nfloat gtaoRoughness=material.roughness;\n#endif\n#include <lights_fragment_gtso>\noutColor=vec4(color.rgb*(reflectedLight.directSpecular\n+ reflectedLight.indirectSpecular),1.0);\n}",node_bsdf_hair_bl_frag="void node_bsdf_hair(vec4 color,float offset,float roughnessU,float roughnessV,vec3 tangent,out vec4 outColor)\n{\noutColor=color;\n}",node_bsdf_metallic_bl_frag="#define BSDF_METALLIC_BECKMANN 0\n#define BSDF_METALLIC_GGX 1\n#define BSDF_METALLIC_MULTI_GGX 2\nvec3 fresnelConductor(float cosi,vec3 eta,vec3 k){\nvec3 cosiSqr=vec3(cosi*cosi);\nvec3 tmpF=(eta*eta)+(k*k);\nvec3 tmp2EtaCosI=2.0*eta*vec3(cosi);\nvec3 tmp=tmpF*cosiSqr;\nvec3 rparl2=(tmp-tmp2EtaCosI+vec3(1.0))/(tmp+tmp2EtaCosI+vec3(1.0));\nvec3 rperp2=(tmpF-tmp2EtaCosI+cosiSqr)/(tmpF+tmp2EtaCosI+cosiSqr);\nreturn (rparl2+rperp2)*0.5;\n}\nvoid node_bsdf_metallic(vec3 geometryNormal,const int distribution,const bool usePhysicalConductor,vec4 baseColor,vec4 edgeTint,vec3 ior,vec3 extinction,float roughness,float anisotropy,float rotation,vec3 normal,vec3 tangent,float thinFilmThickness,float thinFilmIOR,out vec4 outColor){\nnormal=vec3(normal[0],normal[2],-normal[1]);\nnormal=normalize((viewMatrix*vec4(normal.xyz,0.0)).xyz);\nNodeMaterial material;\nif (usePhysicalConductor){\nmaterial.specularColor=saturate(fresnelConductor(1.0,ior,extinction));\nmaterial.fresnelRefl90=saturate(fresnelConductor(1.0/7.0,ior,extinction));\n} else {\nmaterial.specularColor=saturate(baseColor.rgb);\nmaterial.fresnelRefl90=saturate(edgeTint.rgb);\n}\nmaterial.specularF90=average(material.fresnelRefl90);\nmaterial.roughness=saturate(roughness);\n#if defined(ENVMAP_TYPE_CUBE)||defined(ENVMAP_TYPE_CUBE_UV)\nfloat geomRoughness=calcGeometryRoughness(geometryNormal);\nmaterial.roughness=calcCubeUVAdjustedRoughness(material.roughness,geomRoughness);\n#endif\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\n#ifdef USE_CLEARCOAT\n#undef USE_CLEARCOAT\n#define _CLEARCOAT_RESTORE\n#endif\n#ifdef USE_GTAO\nvec4 gtaoVisibilityBentNormal=texture2D(gtaoMap,gl_FragCoord.xy/currResolution);\nvec3 bentNormal=normalize(unpackRGBToNormal(gtaoVisibilityBentNormal.gba));\n#define PROBE_NORMAL bentNormal\n#endif\n#define RE_Direct RE_Direct_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Empty\n#define RE_IndirectSpecular RE_IndirectSpecular_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#undef RE_IndirectSpecular\n#ifdef PROBE_NORMAL\n#undef PROBE_NORMAL\n#endif\n#ifdef _CLEARCOAT_RESTORE\n#undef _CLEARCOAT_RESTORE\n#define USE_CLEARCOAT\n#endif\n#ifdef USE_GTAO\nfloat gtaoVisibility=gtaoVisibilityBentNormal.r;\nvec3 gtaoBentNormal=bentNormal;\nvec3 gtaoViewDir=geometry.viewDir;\nvec3 gtaoNormal=normal;\nfloat gtaoRoughness=material.roughness;\n#endif\n#include <lights_fragment_gtso>\noutColor=vec4(reflectedLight.directDiffuse+reflectedLight.indirectDiffuse+reflectedLight.directSpecular+reflectedLight.indirectSpecular,1.0);\n}\nvoid node_bsdf_metallic(vec3 geometryNormal,const int distribution,const bool usePhysicalConductor,vec4 baseColor,vec4 edgeTint,vec3 ior,vec3 extinction,float roughness,float anisotropy,float rotation,vec3 normal,vec3 tangent,out vec4 outColor){\nnode_bsdf_metallic(geometryNormal,distribution,usePhysicalConductor,baseColor,edgeTint,ior,extinction,roughness,anisotropy,rotation,normal,tangent,0.0,0.0,outColor);\n}",node_bsdf_principled_bl_frag="float iorToF0(float eta){\nfloat A=(eta-1.0)/(eta+1.0);\nreturn A*A;\n}\n#ifdef USE_SHEEN_BLENDER\nfloat principledSheen(float NV,float rough){\nfloat den=35.6694*rough*rough-24.4269*rough*NV-0.1405*NV*NV+6.1211*rough+0.28105*NV-0.1405;\nfloat num=58.5299*rough*rough-85.0941*rough*NV+9.8955*NV*NV+1.9250*rough+74.2268*NV-0.2246;\nreturn saturate(den/num);\n}\n#endif\nvoid node_bsdf_principled(vec3 geometryNormal,vec4 baseColor,float metallic,float roughness,float ior,float alpha,vec3 normal,float diffuseRoughness,float subsurface,vec3 subsurfaceRadius,float subsurfaceScale,float subsurfaceIOR,float subsurfaceAnisotropy,float specularIORLevel,vec4 specularTint,float anisotropic,float anisotropicRotation,vec3 tangent,float transmission,float clearcoat,float clearcoatRoughness,float clearcoatIOR,vec4 clearcoatTint,vec3 clearcoatNormal,float sheen,float sheenRoughness,vec4 sheenTint,vec4 emission,float emissionStrength,float thinFilmThickness,float thinFilmIOR,out vec4 outColor){\nnormal=vec3(normal[0],normal[2],-normal[1]);\nvec3 normalWorld=normal;\nnormal=(viewMatrix*vec4(normal.xyz,0.0)).xyz;\nNodeMaterial material;\nmetallic=clamp(metallic,0.0,1.0);\nfloat dielectric=1.0-metallic;\ntransmission*=dielectric;\nmaterial.diffuseColor=baseColor.rgb*dielectric;\n#ifdef USE_CLEARCOAT\nmaterial.clearcoat=saturate(clearcoat);\nmaterial.clearcoatRoughness=clamp(clearcoatRoughness,0.0,1.0);\nmaterial.clearcoatF0=vec3(0.04);\nmaterial.clearcoatF90=1.0;\n#endif\n#ifdef USE_SHEEN_BLENDER\nfloat dotNVsh=dot(normal,(isOrthographic)?vec3(0,0,1):normalize(vViewPosition));\nmaterial.diffuseColor+=sheen*sheenTint.rgb*principledSheen(dotNVsh,sheenRoughness);\n#endif\nmaterial.roughness=clamp(roughness,0.0,1.0);\nvec3 viewWorld;\nif (isOrthographic)\nviewWorld=(invViewMatrix*vec4(0.0,0.0,-1.0,0.0)).xyz;\nelse\nviewWorld=(invViewMatrix*vec4(-vViewPosition,0.0)).xyz;\nviewWorld=normalize(viewWorld);\nfloat f0d=iorToF0(ior);\nif (specularIORLevel != 0.5)\nf0d*=2.0*specularIORLevel;\nvec3 F0d=vec3(f0d)*specularTint.rgb;\nF0d=clamp(F0d,vec3(0.0),vec3(1.0));\nvec3 F90d=vec3(1.0);\nmaterial.specularColor=mix(F0d,baseColor.rgb,metallic);\nmaterial.fresnelRefl90=mix(F90d,specularTint.rgb,metallic);\nmaterial.specularF90=average(material.fresnelRefl90);\nmaterial.refractionColor=baseColor.rgb;\nmaterial.refractionIOR=ior;\nmaterial.refractionRoughness=pow2(roughness);\n#if defined(ENVMAP_TYPE_CUBE)||defined(ENVMAP_TYPE_CUBE_UV)\nfloat geomRoughness=calcGeometryRoughness(geometryNormal);\nmaterial.roughness=calcCubeUVAdjustedRoughness(material.roughness,geomRoughness);\nmaterial.refractionRoughness=calcCubeUVAdjustedRoughness(material.refractionRoughness,geomRoughness);\n#ifdef USE_CLEARCOAT\nmaterial.clearcoatRoughness=calcCubeUVAdjustedRoughness(material.clearcoatRoughness,geomRoughness);\nclearcoatNormal=normalize(vec3(clearcoatNormal[0],clearcoatNormal[2],-clearcoatNormal[1]));\nclearcoatNormal=(viewMatrix*vec4(clearcoatNormal.xyz,0.0)).xyz;\n#endif\n#endif\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\nvec3 refractedLight=vec3(0.0);\n#ifdef USE_GTAO\nvec4 gtaoVisibilityBentNormal=texture2D(gtaoMap,gl_FragCoord.xy/currResolution);\nvec3 bentNormal=normalize(unpackRGBToNormal(gtaoVisibilityBentNormal.gba));\n#define PROBE_NORMAL bentNormal\n#endif\n#define RE_Direct RE_Direct_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Node\n#define RE_IndirectSpecular RE_IndirectSpecular_Node\n#define RE_Refraction RE_Refraction_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#ifdef USE_CLEARCOAT\nclearcoatSpecular+=clearcoatRadiance*BRDF_Specular_GGX_Environment(geometry.viewDir,geometry.clearcoatNormal,material.clearcoatF0,vec3(material.clearcoatF90),material.clearcoatRoughness);\n#endif\nirradiance+=iblIrradiance;\nvec3 specEnv=BRDF_Specular_GGX_Environment(geometry.viewDir,geometry.normal,material.specularColor,material.fresnelRefl90,material.roughness);\nreflectedLight.indirectSpecular+=radiance*specEnv;\nfloat weight=1.0;\nweight*=max((1.0-max3(specEnv)),0.0);\nmaterial.diffuseColor*=weight;\nRE_IndirectDiffuse(irradiance,geometry,material,reflectedLight);\nRE_Refraction(refraction,material,refractedLight);\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#undef RE_IndirectSpecular\n#undef RE_Refraction\n#ifdef PROBE_NORMAL\n#undef PROBE_NORMAL\n#endif\n#ifdef USE_GTAO\nreflectedLight.indirectDiffuse*=gtaoVisibilityBentNormal.r;\nfloat gtaoVisibility=gtaoVisibilityBentNormal.r;\nvec3 gtaoBentNormal=bentNormal;\nvec3 gtaoViewDir=geometry.viewDir;\nvec3 gtaoNormal=normal;\nfloat gtaoRoughness=material.roughness;\n#endif\n#include <lights_fragment_gtso>\nfloat fresnel=fresnelReflection(viewWorld,normalWorld,ior);\nvec3 outColor3=(reflectedLight.directDiffuse+reflectedLight.indirectDiffuse)*(1.0-transmission)\n+ reflectedLight.directSpecular+reflectedLight.indirectSpecular\n+ refractedLight*transmission*(1.0-fresnel)\n+ emission.rgb*emissionStrength;\n#ifdef USE_CLEARCOAT\nfloat dotNVcc=saturate(dot(geometry.normal,geometry.viewDir));\nvec3 Fcc=F_Schlick(material.clearcoatF0,material.clearcoatF90,dotNVcc);\noutColor3=outColor3*(1.0-material.clearcoat*Fcc)+clearcoatSpecular*material.clearcoat;\n#endif\noutColor=vec4(outColor3,alpha);\n}\nvoid node_bsdf_principled(vec3 geometryNormal,vec4 baseColor,float metallic,float roughness,float ior,float alpha,vec3 normal,float subsurface,vec3 subsurfaceRadius,float subsurfaceScale,float subsurfaceIOR,float subsurfaceAnisotropy,float specularIORLevel,vec4 specularTint,float anisotropic,float anisotropicRotation,vec3 tangent,float transmission,float clearcoat,float clearcoatRoughness,float clearcoatIOR,vec4 clearcoatTint,vec3 clearcoatNormal,float sheen,float sheenRoughness,vec4 sheenTint,vec4 emission,float emissionStrength,float thinFilmThickness,float thinFilmIOR,out vec4 outColor){\nnode_bsdf_principled(geometryNormal,baseColor,metallic,roughness,ior,alpha,normal,0.0,subsurface,subsurfaceRadius,subsurfaceScale,subsurfaceIOR,subsurfaceAnisotropy,specularIORLevel,specularTint,anisotropic,anisotropicRotation,tangent,transmission,clearcoat,clearcoatRoughness,clearcoatIOR,clearcoatTint,clearcoatNormal,sheen,sheenRoughness,sheenTint,emission,emissionStrength,0.0,0.0,outColor);\n}",node_bsdf_refraction_bl_frag="#define BSDF_REFRACTION_GGX 0\n#define BSDF_REFRACTION_BECKMANN 1\n#define BSDF_REFRACTION_SHARP 2\nvoid node_bsdf_refraction(vec3 geometryNormal,const int distribution,vec4 color,float roughness,float ior,vec3 normal,out vec4 outColor){\nnormal=swizzleUpY(normal);\nnormal=(viewMatrix*vec4(normal.xyz,0.0)).xyz;\nNodeMaterial material;\nmaterial.refractionColor=color.rgb;\nmaterial.refractionIOR=ior;\nif (distribution==BSDF_REFRACTION_SHARP){\nmaterial.refractionRoughness=0.0;\n} else {\nmaterial.refractionRoughness=pow2(roughness);\n}\n#if defined(ENVMAP_TYPE_CUBE)||defined(ENVMAP_TYPE_CUBE_UV)\nfloat geomRoughness=calcGeometryRoughness(geometryNormal);\nmaterial.refractionRoughness=calcCubeUVAdjustedRoughness(material.refractionRoughness,geomRoughness);\n#endif\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\nvec3 refractedLight=vec3(0.0);\n#ifdef USE_CLEARCOAT\n#undef USE_CLEARCOAT\n#define _CLEARCOAT_RESTORE\n#endif\n#define RE_Refraction RE_Refraction_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Refraction\n#ifdef _CLEARCOAT_RESTORE\n#undef _CLEARCOAT_RESTORE\n#define USE_CLEARCOAT\n#endif\noutColor=vec4(refractedLight,1.0);\n}",node_bsdf_sheen_bl_frag="\nvoid node_bsdf_sheen(vec4 color,float roughness,vec3 normal,out vec4 outColor)\n{\nnormal=vec3(normal[0],normal[2],-normal[1]);\nnormal=(viewMatrix*vec4(normal.xyz,0.0)).xyz;\nNodeMaterial material;\nmaterial.diffuseColor=color.rgb;\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\n#ifdef USE_CLEARCOAT\n#undef USE_CLEARCOAT\n#define _CLEARCOAT_RESTORE\n#endif\n#define RE_Direct RE_DirectDiffuseOnly_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#ifdef _CLEARCOAT_RESTORE\n#undef _CLEARCOAT_RESTORE\n#define USE_CLEARCOAT\n#endif\noutColor=vec4(reflectedLight.directDiffuse+reflectedLight.indirectDiffuse,1.0);\n}",node_bsdf_toon_bl_frag="void node_bsdf_toon(vec4 color,float size,float smoothFac,vec3 normal,out vec4 outColor)\n{\noutColor=color;\n}",node_bsdf_translucent_bl_frag="void node_bsdf_translucent(vec4 color,vec3 normal,out vec4 outColor){\nnormal=-vec3(normal[0],normal[2],-normal[1]);\nnormal=(viewMatrix*vec4(normal.xyz,0.0)).xyz;\nNodeMaterial material;\nmaterial.diffuseColor=color.rgb;\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\n#ifdef USE_CLEARCOAT\n#undef USE_CLEARCOAT\n#define _CLEARCOAT_RESTORE\n#endif\n#define RE_Direct RE_DirectDiffuseOnly_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#ifdef _CLEARCOAT_RESTORE\n#undef _CLEARCOAT_RESTORE\n#define USE_CLEARCOAT\n#endif\noutColor=vec4(reflectedLight.directDiffuse+reflectedLight.indirectDiffuse,1.0);\n}",node_bsdf_transparent_bl_frag="void node_bsdf_transparent(vec4 color,out vec4 outColor)\n{\nfloat alpha=saturate(1.0-dot(color.rgb,vec3(0.333333)));\noutColor=vec4(0.0,0.0,0.0,alpha);\n}",node_bump_bl_frag="void node_bump(const bool invert,float strength,float bumpDist,float filterWidth,float height,vec3 normal,out vec3 outNormal){\nvec3 position=swizzleUpZ(vWorldPosition);\nif (invert)\nbumpDist*=-1.0;\nvec3 dPdx=dFdx(position);\nvec3 dPdy=dFdy(position);\nfloat dHdx=dFdx(height);\nfloat dHdy=dFdy(height);\nvec3 tanX=cross(dPdy,normal);\nvec3 tanY=cross(normal,dPdx);\nvec3 surfaceGrad=dHdx*tanX+dHdy*tanY;\nfloat dotPosTanX=dot(dPdx,tanX);\noutNormal=normalize(normal*abs(dotPosTanX)-surfaceGrad*bumpDist*sign(dotPosTanX));\noutNormal=normalize(mix(normal,outNormal,max(0.0,strength)));\n}\nvoid node_bump(const bool invert,float strength,float bumpDist,float height,vec3 normal,out vec3 outNormal){\nnode_bump(invert,strength,bumpDist,1.0,height,normal,outNormal);\n}",node_camera_bl_frag="void node_camera(vec3 viewPos,const bool invCamZ,out vec3 outViewVector,out float outViewZDepth,out float outViewDistance)\n{\nviewPos=-viewPos;\nif (invCamZ)\nviewPos.z=-viewPos.z;\noutViewVector=normalize(viewPos);\noutViewZDepth=abs(viewPos.z);\noutViewDistance=length(viewPos);\n}",node_clamp_bl_frag="void node_clamp(bool clampRange,float value,float minVal,float maxVal,out float result){\nif (clampRange)\nresult=(maxVal>minVal)?clamp(value,minVal,maxVal):clamp(value,maxVal,minVal);\nelse\nresult=min(max(value,minVal),maxVal);\n}",node_combine_color_bl_frag="#define NODE_COMB_COL_RGB 0\n#define NODE_COMB_COL_HSV 1\n#define NODE_COMB_COL_HSL 2\nvoid hslToRGB(vec3 hsl,out vec3 outCol)\n{\nfloat nr,ng,nb,chroma;\nfloat h,s,l;\nh=hsl[0];\ns=hsl[1];\nl=hsl[2];\nnr=abs(h*6.0-3.0)-1.0;\nng=2.0-abs(h*6.0-2.0);\nnb=2.0-abs(h*6.0-4.0);\nnr=clamp(nr,0.0,1.0);\nnb=clamp(nb,0.0,1.0);\nng=clamp(ng,0.0,1.0);\nchroma=(1.0-abs(2.0*l-1.0))*s;\noutCol=vec3((nr-0.5)*chroma+l,(ng-0.5)*chroma+l,(nb-0.5)*chroma+l);\n}\nvoid node_combine_color(int mode,float r,float g,float b,out vec4 col)\n{\nif (mode==NODE_COMB_COL_RGB){\ncol=vec4(r,g,b,1.0);\n} else if (mode==NODE_COMB_COL_HSV){\nhsvToRGB(vec4(r,g,b,1.0),col);\n} else {\nvec3 col3;\nhslToRGB(vec3(r,g,b),col3);\ncol=vec4(col3,1.0);\n}\n}",node_combxyz_bl_frag="void node_combxyz(float x,float y,float z,out vec3 outVector)\n{\noutVector=vec3(x,y,z);\n}",node_curve_float_bl_frag="void node_curve_float(sampler2D curveData,float fac,float value,out float outValue)\n{\noutValue=texture2D(curveData,vec2((value+1.0)*0.5,0.0)).x;\noutValue=mix(value,outValue*2.0-1.0,fac);\n}",node_curve_rgb_bl_frag="void node_curve_rgb(sampler2D curveData,float fac,vec4 col,out vec4 outCol)\n{\noutCol.r=texture2D(curveData,vec2(texture2D(curveData,vec2(col.r,0.0)).a,0.0)).r;\noutCol.g=texture2D(curveData,vec2(texture2D(curveData,vec2(col.g,0.0)).a,0.0)).g;\noutCol.b=texture2D(curveData,vec2(texture2D(curveData,vec2(col.b,0.0)).a,0.0)).b;\noutCol=mix(col,outCol,fac);\noutCol.a=col.a;\n}",node_curve_vec_bl_frag="void node_curve_vec(sampler2D curveData,float fac,vec3 vec,out vec3 outVec)\n{\noutVec.x=texture2D(curveData,vec2((vec.x+1.0)*0.5,0.0)).x;\noutVec.y=texture2D(curveData,vec2((vec.y+1.0)*0.5,0.0)).y;\noutVec.z=texture2D(curveData,vec2((vec.z+1.0)*0.5,0.0)).z;\noutVec=mix(vec,outVec*2.0-vec3(1.0),fac);\n}",node_displacement_bl_frag="void node_displacement(float height,float midlevel,float scale,vec3 normal,out vec3 outDisplacement){\noutDisplacement=vec3(0.0);\n}",node_eevee_specular_bl_frag="void node_eevee_specular(vec3 geometryNormal,vec4 baseColor,vec4 specular,float roughness,vec4 emissiveColor,float transparency,vec3 normal,float clearcoat,float clearcoatRoughness,vec3 clearcoatNormal,float ambientOcclusion,out vec4 outColor){\nnormal=vec3(normal[0],normal[2],-normal[1]);\nvec3 normalWorld=normal;\nnormal=(viewMatrix*vec4(normal.xyz,0.0)).xyz;\nNodeMaterial material;\nmaterial.diffuseColor=baseColor.rgb;\nmaterial.specularColor=specular.rgb;\nmaterial.roughness=clamp(roughness,0.0,1.0);\n#ifdef USE_CLEARCOAT\nmaterial.clearcoat=saturate(clearcoat);\nmaterial.clearcoatRoughness=clamp(clearcoatRoughness,0.0,1.0);\n#endif\n#if defined(ENVMAP_TYPE_CUBE)||defined(ENVMAP_TYPE_CUBE_UV)\nfloat geomRoughness=calcGeometryRoughness(geometryNormal);\nmaterial.roughness=calcCubeUVAdjustedRoughness(material.roughness,geomRoughness);\n#ifdef USE_CLEARCOAT\nmaterial.clearcoatRoughness=calcCubeUVAdjustedRoughness(material.clearcoatRoughness,geomRoughness);\nclearcoatNormal=normalize(vec3(clearcoatNormal[0],clearcoatNormal[2],-clearcoatNormal[1]));\nclearcoatNormal=(viewMatrix*vec4(clearcoatNormal.xyz,0.0)).xyz;\n#endif\n#endif\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\n#ifdef USE_GTAO\nvec4 gtaoVisibilityBentNormal=texture2D(gtaoMap,gl_FragCoord.xy/currResolution);\nvec3 bentNormal=normalize(unpackRGBToNormal(gtaoVisibilityBentNormal.gba));\n#define PROBE_NORMAL bentNormal\n#endif\n#define RE_Direct RE_Direct_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Node\n#define RE_IndirectSpecular RE_IndirectSpecular_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#undef RE_IndirectSpecular\n#ifdef PROBE_NORMAL\n#undef PROBE_NORMAL\n#endif\n#ifdef USE_GTAO\nreflectedLight.indirectDiffuse*=gtaoVisibilityBentNormal.r;\nfloat gtaoVisibility=gtaoVisibilityBentNormal.r;\nvec3 gtaoBentNormal=bentNormal;\nvec3 gtaoViewDir=geometry.viewDir;\nvec3 gtaoNormal=normal;\nfloat gtaoRoughness=material.roughness;\n#endif\n#include <lights_fragment_gtso>\nvec3 outColor3=(reflectedLight.directDiffuse+reflectedLight.indirectDiffuse\n+ reflectedLight.directSpecular+reflectedLight.indirectSpecular)*ambientOcclusion\n+ emissiveColor.rgb;\noutColor=vec4(outColor3,1.0-transparency);\n}",node_emission_bl_frag="void node_emission(vec4 color,float strength,out vec4 outColor)\n{\noutColor=vec4(strength*color.rgb,1.0);\n}",node_fresnel_bl_frag="void node_fresnel(vec3 viewPos,float IOR,vec3 normal,out float fac)\n{\nvec3 worldDir;\nif (isOrthographic)\nworldDir=(invViewMatrix*vec4(0.0,0.0,-1.0,0.0)).xyz;\nelse\nworldDir=(invViewMatrix*vec4(-viewPos,0.0)).xyz;\nworldDir=normalize(swizzleUpZ(worldDir));\nfloat eta=max(IOR,0.00001);\nfac=fresnelReflection(worldDir,normal,(gl_FrontFacing)?eta:1.0/eta);\n}",node_gamma_bl_frag="void node_gamma(vec4 col,float gamma,out vec4 outCol)\n{\noutCol=col;\nif (col.r>0.0)\noutCol.r=powCompat(col.r,gamma);\nif (col.g>0.0)\noutCol.g=powCompat(col.g,gamma);\nif (col.b>0.0)\noutCol.b=powCompat(col.b,gamma);\n}",node_hair_info_bl_frag="\nvoid node_hair_info(out float isStrand,out float intercept,out float len,out float thickness,out vec3 tangentNormal,out float random){\nisStrand=0.0;\nintercept=0.0;\nlen=0.0;\nthickness=0.0;\ntangentNormal=vec3(0.0);\nrandom=1.0;\n}",node_holdout_bl_frag="void node_holdout(out vec4 outColor)\n{\noutColor=vec4(0.0);\n}",node_hue_sat_bl_frag="void node_hue_sat(float hue,float sat,float value,float fac,vec4 col,out vec4 outCol)\n{\nvec4 hsv;\nrgbToHSV(col,hsv);\nhsv[0]+=(fract(hue)-0.5);\nif (hsv[0]>1.0)hsv[0]-=1.0;else if (hsv[0]<0.0)hsv[0]+=1.0;\nhsv[1]*=sat;\nif (hsv[1]>1.0)hsv[1]=1.0;else if (hsv[1]<0.0)hsv[1]=0.0;\nhsv[2]*=value;\nhsvToRGB(hsv,outCol);\noutCol=mix(col,outCol,fac);\n}",node_invert_bl_frag="void node_invert(float fac,vec4 col,out vec4 outCol)\n{\noutCol.xyz=mix(col.xyz,vec3(1.0,1.0,1.0)-col.xyz,fac);\noutCol.w=col.w;\n}",node_layer_weight_bl_frag="void node_layer_weight(vec3 viewPos,float blend,vec3 normal,out float fresnel,out float facing)\n{\nvec3 worldDir;\nif (isOrthographic)\nworldDir=(invViewMatrix*vec4(0.0,0.0,-1.0,0.0)).xyz;\nelse\nworldDir=(invViewMatrix*vec4(-viewPos,0.0)).xyz;\nworldDir=normalize(swizzleUpZ(worldDir));\nfloat eta=max(1.0-blend,EPSILON);\nfresnel=fresnelReflection(worldDir,normal,(gl_FrontFacing)?1.0/eta:eta);\nfacing=abs(dot(worldDir,normal));\nif (blend != 0.5){\nblend=clamp(blend,0.0,1.0-EPSILON);\nblend=(blend<0.5)?blend*2.0:0.5/(1.0-blend);\nfacing=pow(facing,blend);\n}\nfacing=1.0-facing;\n}",node_light_falloff_bl_frag="void node_light_falloff(float strength,float inSmooth,out float quadratic,out float linear,out float constant)\n{\nquadratic=1.0;\nlinear=1.0;\nconstant=1.0;\n}",node_light_path_bl_frag="void node_light_path(out float isCameraRay,out float isShadowRay,out float isDiffuseRay,out float isGlossyRay,out float isSingularRay,out float isReflectionRay,out float isTransmissionRay,out float isVolumeScatterRay,out float rayLength,out float rayDepth,out float diffuseDepth,out float glossyDepth,out float transparentDepth,out float transmissionDepth,out float portalDepth)\n{\n#if LIGHT_PATH_IS_CAM_RAY\nisCameraRay=1.0;\n#else\nisCameraRay=0.0;\n#endif\nisShadowRay=0.0;\nisDiffuseRay=0.0;\nisGlossyRay=0.0;\nisSingularRay=0.0;\nisReflectionRay=0.0;\nisTransmissionRay=0.0;\nisVolumeScatterRay=0.0;\nrayLength=1.0;\nrayDepth=1.0;\ndiffuseDepth=1.0;\nglossyDepth=1.0;\ntransparentDepth=1.0;\ntransmissionDepth=1.0;\nportalDepth=0.0;\n}\nvoid node_light_path(out float isCameraRay,out float isShadowRay,out float isDiffuseRay,out float isGlossyRay,out float isSingularRay,out float isReflectionRay,out float isTransmissionRay,out float isVolumeScatterRay,out float rayLength,out float rayDepth,out float diffuseDepth,out float glossyDepth,out float transparentDepth,out float transmissionDepth)\n{\n#if LIGHT_PATH_IS_CAM_RAY\nisCameraRay=1.0;\n#else\nisCameraRay=0.0;\n#endif\nisShadowRay=0.0;\nisDiffuseRay=0.0;\nisGlossyRay=0.0;\nisSingularRay=0.0;\nisReflectionRay=0.0;\nisTransmissionRay=0.0;\nisVolumeScatterRay=0.0;\nrayLength=1.0;\nrayDepth=1.0;\ndiffuseDepth=1.0;\nglossyDepth=1.0;\ntransparentDepth=1.0;\ntransmissionDepth=1.0;\n}\nvoid node_light_path(out float isCameraRay,out float isShadowRay,out float isDiffuseRay,out float isGlossyRay,out float isSingularRay,out float isReflectionRay,out float isTransmissionRay,out float rayLength,out float rayDepth,out float diffuseDepth,out float glossyDepth,out float transparentDepth,out float transmissionDepth)\n{\n#if LIGHT_PATH_IS_CAM_RAY\nisCameraRay=1.0;\n#else\nisCameraRay=0.0;\n#endif\nisShadowRay=0.0;\nisDiffuseRay=0.0;\nisGlossyRay=0.0;\nisSingularRay=0.0;\nisReflectionRay=0.0;\nisTransmissionRay=0.0;\nrayLength=1.0;\nrayDepth=1.0;\ndiffuseDepth=1.0;\nglossyDepth=1.0;\ntransparentDepth=1.0;\ntransmissionDepth=1.0;\n}",node_mapping_bl_frag="#define NODE_MAPPING_POINT 1\n#define NODE_MAPPING_TEXTURE 2\n#define NODE_MAPPING_VECTOR 3\n#define NODE_MAPPING_NORMAL 4\nmat3 rotationMatrix(float angleX,float angleY,float angleZ){\nfloat cx=cos(angleX);\nfloat sx=sin(angleX);\nfloat cy=cos(angleY);\nfloat sy=sin(angleY);\nfloat cz=cos(angleZ);\nfloat sz=sin(angleZ);\nmat3 mat;\nmat[0][0]=cy*cz;\nmat[0][1]=cy*sz;\nmat[0][2]=-sy;\nmat[1][0]=sy*sx*cz-cx*sz;\nmat[1][1]=sy*sx*sz+cx*cz;\nmat[1][2]=cy*sx;\nmat[2][0]=sy*cx*cz+sx*sz;\nmat[2][1]=sy*cx*sz-sx*cz;\nmat[2][2]=cy*cx;\nreturn mat;\n}\nmat3 mat3GetInverseTransposed(mat3 mat){\nfloat det=mat3GetDeterminant(mat);\nfloat a00=(mat[1][1]*mat[2][2]-mat[1][2]*mat[2][1])/det;\nfloat a01=- (mat[1][0]*mat[2][2]-mat[1][2]*mat[2][0])/det;\nfloat a02=(mat[1][0]*mat[2][1]-mat[1][1]*mat[2][0])/det;\nfloat a10=- (mat[0][1]*mat[2][2]-mat[0][2]*mat[2][1])/det;\nfloat a11=(mat[0][0]*mat[2][2]-mat[0][2]*mat[2][0])/det;\nfloat a12=- (mat[0][0]*mat[2][1]-mat[0][1]*mat[2][0])/det;\nfloat a20=(mat[0][1]*mat[1][2]-mat[0][2]*mat[1][1])/det;\nfloat a21=- (mat[0][0]*mat[1][2]-mat[0][2]*mat[1][0])/det;\nfloat a22=(mat[0][0]*mat[1][1]-mat[0][1]*mat[1][0])/det;\nreturn mat3(a00,a01,a02,a10,a11,a12,a20,a21,a22\n);\n}\nvoid node_mapping(int type,vec3 vec,vec3 loc,vec3 rot,vec3 scale,out vec3 outVec)\n{\nif (type==NODE_MAPPING_POINT)\noutVec=rotationMatrix(rot.x,rot.y,rot.z)*(vec*scale)+loc;\nelse if (type==NODE_MAPPING_TEXTURE)\noutVec=transposeMat3(rotationMatrix(rot.x,rot.y,rot.z))*(vec-loc)/scale;\nelse if (type==NODE_MAPPING_VECTOR)\noutVec=rotationMatrix(rot.x,rot.y,rot.z)*(vec*scale);\nelse {\nmat3 rot=rotationMatrix(rot.x,rot.y,rot.z)*mat3(scale[0],0.0,0.0,0.0,scale[1],0.0,0.0,0.0,scale[2]\n);\noutVec=normalize(mat3GetInverseTransposed(rot)*vec);\n}\n}",node_map_range_bl_frag="#define NODE_MAP_RANGE_INTERP_LINEAR 0\n#define NODE_MAP_RANGE_INTERP_STEPPED 1\n#define NODE_MAP_RANGE_INTERP_SMOOTHSTEP 2\n#define NODE_MAP_RANGE_INTERP_SMOOTHERSTEP 3\n#define NODE_MAP_RANGE_TYPE_FLOAT 0\n#define NODE_MAP_RANGE_TYPE_FLOAT_VECTOR 1\nfloat smootherstep(float edge0,float edge1,float x){\nfloat t=clamp((x-edge0)/(edge1-edge0),0.0,1.0);\nreturn t*t*t*(t*(t*6.0-15.0)+10.0);\n}\nvec3 smootherstep(vec3 x){\nvec3 t=clamp(x,0.0,1.0);\nreturn (t*(t*6.0-15.0)+10.0)*t*t*t;\n}\nvoid node_map_range(const int dataType,const int interpolation,bool inClamp,float value,float fromMin,float fromMax,float toMin,float toMax,float steps,vec3 valueVec,vec3 fromMinVec,vec3 fromMaxVec,vec3 toMinVec,vec3 toMaxVec,vec3 stepsVec,out float result,out vec3 resultVec){\nif (dataType==NODE_MAP_RANGE_TYPE_FLOAT){\nif (fromMax==fromMin){\nresult=0.0;\n} else if (interpolation==NODE_MAP_RANGE_INTERP_LINEAR){\nresult=(value-fromMin)/(fromMax-fromMin)*(toMax-toMin)+toMin;\n} else if (interpolation==NODE_MAP_RANGE_INTERP_STEPPED){\nfloat fac=(value-fromMin)/(fromMax-fromMin);\nfac=(steps>0.0)?floor(fac*(steps+1.0))/steps:0.0;\nresult=fac*(toMax-toMin)+toMin;\n} else if (interpolation==NODE_MAP_RANGE_INTERP_SMOOTHSTEP){\nfloat fac=(fromMin>fromMax)?\n1.0-smoothstep(fromMax,fromMin,value):\nsmoothstep(fromMin,fromMax,value);\nresult=fac*(toMax-toMin)+toMin;\n} else {\nfloat fac=(fromMin>fromMax)?\n1.0-smootherstep(fromMax,fromMin,value):\nsmootherstep(fromMin,fromMax,value);\nresult=fac*(toMax-toMin)+toMin;\n}\nif (inClamp&&interpolation<=NODE_MAP_RANGE_INTERP_STEPPED){\nresult=clamp(result,toMin,toMax);\n}\n} else if (dataType==NODE_MAP_RANGE_TYPE_FLOAT_VECTOR){\nvec3 deltaVec=fromMaxVec-fromMinVec;\nvec3 fac=vec3(deltaVec.x==0.0?0.0:(valueVec.x-fromMinVec.x)/deltaVec.x,deltaVec.y==0.0?0.0:(valueVec.y-fromMinVec.y)/deltaVec.y,deltaVec.z==0.0?0.0:(valueVec.z-fromMinVec.z)/deltaVec.z\n);\nif (interpolation==NODE_MAP_RANGE_INTERP_LINEAR){\nresultVec=fac*(toMaxVec-toMinVec)+toMinVec;\n} else if (interpolation==NODE_MAP_RANGE_INTERP_STEPPED){\nfac.x=stepsVec.x==0.0?0.0:floor(fac.x*(stepsVec.x+1.0))/stepsVec.x;\nfac.y=stepsVec.y==0.0?0.0:floor(fac.y*(stepsVec.y+1.0))/stepsVec.y;\nfac.z=stepsVec.z==0.0?0.0:floor(fac.z*(stepsVec.z+1.0))/stepsVec.z;\nresultVec=fac*(toMaxVec-toMinVec)+toMinVec;\n} else if (interpolation==NODE_MAP_RANGE_INTERP_SMOOTHSTEP){\nfac=clamp(fac,0.0,1.0);\nfac=fac*fac*(3.0-2.0*fac);\nresultVec=fac*(toMaxVec-toMinVec)+toMinVec;\n} else {\nresultVec=smootherstep(fac)*(toMaxVec-toMinVec)+toMinVec;\n}\nif (inClamp&&interpolation<=NODE_MAP_RANGE_INTERP_STEPPED){\nvec3 sumVec=toMinVec+toMaxVec;\ntoMaxVec=max(toMaxVec,toMinVec);\ntoMinVec=sumVec-toMaxVec;\nresultVec=clamp(resultVec,toMinVec,toMaxVec);\n}\n}\n}",node_math_bl_frag="void node_math_add(float val1,float val2,float val3,out float outVal)\n{\noutVal=val1+val2;\n}\nvoid node_math_subtract(float val1,float val2,float val3,out float outVal)\n{\noutVal=val1-val2;\n}\nvoid node_math_multiply(float val1,float val2,float val3,out float outVal)\n{\noutVal=val1*val2;\n}\nvoid node_math_divide(float val1,float val2,float val3,out float outVal)\n{\nif (val2==0.0)\noutVal=0.0;\nelse\noutVal=val1/val2;\n}\nvoid node_math_sine(float val,float val2,float val3,out float outVal)\n{\noutVal=sin(val);\n}\nvoid node_math_cosine(float val,float val2,float val3,out float outVal)\n{\noutVal=cos(val);\n}\nvoid node_math_tangent(float val,float val2,float val3,out float outVal)\n{\noutVal=tan(val);\n}\nvoid node_math_arcsine(float val,float val2,float val3,out float outVal)\n{\nif (val<=1.0&&val>=-1.0)\noutVal=asin(val);\nelse\noutVal=0.0;\n}\nvoid node_math_arccosine(float val,float val2,float val3,out float outVal)\n{\nif (val<=1.0&&val>=-1.0)\noutVal=acos(val);\nelse\noutVal=0.0;\n}\nvoid node_math_arctangent(float val,float val2,float val3,out float outVal)\n{\noutVal=atan(val);\n}\nvoid node_math_arctan2(float val,float val2,float val3,out float outVal)\n{\noutVal=atan(val,val2);\n}\nvoid node_math_power(float val1,float val2,float val3,out float outVal)\n{\nif (val1>=0.0)\noutVal=powCompat(val1,val2);\nelse {\nfloat val2_mod_1=mod(abs(val2),1.0);\nif (val2_mod_1>0.999||val2_mod_1<0.001)\noutVal=powCompat(val1,floor(val2+0.5));\nelse\noutVal=0.0;\n}\n}\nvoid node_math_logarithm(float val1,float val2,float val3,out float outVal)\n{\nif (val1>0.0&&val2>0.0)\noutVal=log2(val1)/log2(val2);\nelse\noutVal=0.0;\n}\nvoid node_math_sqrt(float val1,float val2,float val3,out float outVal)\n{\noutVal=sqrt(val1);\n}\nvoid node_math_maximum(float val1,float val2,float val3,out float outVal)\n{\noutVal=max(val1,val2);\n}\nvoid node_math_minimum(float val1,float val2,float val3,out float outVal)\n{\noutVal=min(val1,val2);\n}\nvoid node_math_round(float val1,float val2,float val3,out float outVal)\n{\noutVal=floor(val1+0.5);\n}\nvoid node_math_floor(float val1,float val2,float val3,out float outVal)\n{\noutVal=floor(val1);\n}\nvoid node_math_ceil(float val1,float val2,float val3,out float outVal)\n{\noutVal=ceil(val1);\n}\nvoid node_math_fract(float val1,float val2,float val3,out float outVal)\n{\noutVal=fract(val1);\n}\nvoid node_math_less_than(float val1,float val2,float val3,out float outVal)\n{\nif (val1<val2)\noutVal=1.0;\nelse\noutVal=0.0;\n}\nvoid node_math_greater_than(float val1,float val2,float val3,out float outVal)\n{\nif (val1>val2)\noutVal=1.0;\nelse\noutVal=0.0;\n}\nvoid node_math_modulo(float val1,float val2,float val3,out float outVal)\n{\nif (val2==0.0)\noutVal=0.0;\nelse\noutVal=mod(val1,val2);\noutVal=(val1>0.0)?outVal:outVal-val2;\n}\nvoid node_math_floored_modulo(float val1,float val2,float val3,out float outVal)\n{\noutVal=(val2 != 0.0)?val1-floor(val1/val2)*val2:0.0;\n}\nvoid node_math_absolute(float val1,float val2,float val3,out float outVal)\n{\noutVal=abs(val1);\n}\nvoid node_math_compare(float val1,float val2,float val3,out float outVal){\noutVal=step(abs(val1-val2),val3);\n}\nvoid node_math_cosh(float val1,float val2,float val3,out float outVal){\noutVal=cosh(val1);\n}\nvoid node_math_degrees(float val1,float val2,float val3,out float outVal){\noutVal=val1/PI*180.0;\n}\nvoid node_math_exponent(float val1,float val2,float val3,out float outVal){\noutVal=exp(val1);\n}\nvoid node_math_inverse_sqrt(float val1,float val2,float val3,out float outVal){\nif (val1>=0.0){\noutVal=1.0/sqrt(val1);\n} else {\noutVal=0.0;\n}\n}\nvoid node_math_multiply_add(float val1,float val2,float val3,out float outVal){\noutVal=val1*val2+val3;\n}\nvoid node_math_pingpong(float val1,float val2,float val3,out float outVal){\nif (val2==0.0){\noutVal=0.0;\n} else {\nfloat absVal2=abs(val2);\nfloat rem=mod(val1,absVal2);\noutVal=mix(rem,absVal2-rem,mod(floor(val1/absVal2),2.0));\n}\n}\nvoid node_math_radians(float val1,float val2,float val3,out float outVal){\noutVal=val1/180.0*PI;\n}\nvoid node_math_sign(float val1,float val2,float val3,out float outVal){\noutVal=sign(val1);\n}\nvoid node_math_sinh(float val1,float val2,float val3,out float outVal){\noutVal=sinh(val1);\n}\nvoid node_math_smooth_max(float val1,float val2,float val3,out float outVal){\noutVal=smoothMax(val1,val2,val3);\n}\nvoid node_math_smooth_min(float val1,float val2,float val3,out float outVal){\noutVal=smoothMin(val1,val2,val3);\n}\nvoid node_math_snap(float val1,float val2,float val3,out float outVal){\nval1+=1e-5*sign(val2);\nfloat quot=val1/val2;\noutVal=floor(quot)*val2;\n}\nvoid node_math_tanh(float val1,float val2,float val3,out float outVal){\noutVal=tanh(val1);\n}\nvoid node_math_trunc(float val1,float val2,float val3,out float outVal){\nval1+=1e-5;\noutVal=trunc(val1);\n}\nvoid node_math_wrap(float val1,float val2,float val3,out float outVal){\nval1+=1e-5;\noutVal=mod(val1-val3,val2-val3)+val3;\n}",node_mix_bl_frag="void node_mix_rgba_mix(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\noutCol=mix(col1,col2,fac);\noutCol.a=col1.a;\n}\nvoid node_mix_rgba_add(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\noutCol=mix(col1,col1+col2,fac);\noutCol.a=col1.a;\n}\nvoid node_mix_rgba_multiply(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\noutCol=mix(col1,col1*col2,fac);\noutCol.a=col1.a;\n}\nvoid node_mix_rgba_screen(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\nfloat facm=1.0-fac;\noutCol=vec4(1.0)-(vec4(facm)+fac*(vec4(1.0)-col2))*(vec4(1.0)-col1);\noutCol.a=col1.a;\n}\nvoid node_mix_rgba_overlay(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\nfloat facm=1.0-fac;\noutCol=col1;\nif (outCol.r<0.5)\noutCol.r*=facm+2.0*fac*col2.r;\nelse\noutCol.r=1.0-(facm+2.0*fac*(1.0-col2.r))*(1.0-outCol.r);\nif (outCol.g<0.5)\noutCol.g*=facm+2.0*fac*col2.g;\nelse\noutCol.g=1.0-(facm+2.0*fac*(1.0-col2.g))*(1.0-outCol.g);\nif (outCol.b<0.5)\noutCol.b*=facm+2.0*fac*col2.b;\nelse\noutCol.b=1.0-(facm+2.0*fac*(1.0-col2.b))*(1.0-outCol.b);\n}\nvoid node_mix_rgba_exclusion(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\noutCol=max(mix(col1,col1+col2-2.0*col1*col2,fac),0.0);\noutCol.a=col1.a;\n}\nvoid node_mix_rgba_subtract(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\noutCol=mix(col1,col1-col2,fac);\noutCol.a=col1.a;\n}\nvoid node_mix_rgba_divide(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\nfloat facm=1.0-fac;\noutCol=col1;\nif (col2.r != 0.0)outCol.r=facm*outCol.r+fac*outCol.r/col2.r;\nif (col2.g != 0.0)outCol.g=facm*outCol.g+fac*outCol.g/col2.g;\nif (col2.b != 0.0)outCol.b=facm*outCol.b+fac*outCol.b/col2.b;\n}\nvoid node_mix_rgba_difference(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\noutCol=mix(col1,abs(col1-col2),fac);\noutCol.a=col1.a;\n}\nvoid node_mix_rgba_darken(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\noutCol.rgb=mix(col1.rgb,min(col1.rgb,col2.rgb),fac);\noutCol.a=col1.a;\n}\nvoid node_mix_rgba_lighten(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\noutCol.rgb=mix(col1.rgb,max(col1.rgb,col2.rgb),fac);\noutCol.a=col1.a;\n}\nvoid node_mix_rgba_dodge(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\noutCol=col1;\nif (outCol.r != 0.0){\nfloat tmp=1.0-fac*col2.r;\nif (tmp<=0.0)\noutCol.r=1.0;\nelse if ((tmp=outCol.r/tmp)>1.0)\noutCol.r=1.0;\nelse\noutCol.r=tmp;\n}\nif (outCol.g != 0.0){\nfloat tmp=1.0-fac*col2.g;\nif (tmp<=0.0)\noutCol.g=1.0;\nelse if ((tmp=outCol.g/tmp)>1.0)\noutCol.g=1.0;\nelse\noutCol.g=tmp;\n}\nif (outCol.b != 0.0){\nfloat tmp=1.0-fac*col2.b;\nif (tmp<=0.0)\noutCol.b=1.0;\nelse if ((tmp=outCol.b/tmp)>1.0)\noutCol.b=1.0;\nelse\noutCol.b=tmp;\n}\n}\nvoid node_mix_rgba_burn(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\nfloat tmp,facm=1.0-fac;\noutCol=col1;\ntmp=facm+fac*col2.r;\nif (tmp<=0.0)\noutCol.r=0.0;\nelse if ((tmp=(1.0-(1.0-outCol.r)/tmp))<0.0)\noutCol.r=0.0;\nelse if (tmp>1.0)\noutCol.r=1.0;\nelse\noutCol.r=tmp;\ntmp=facm+fac*col2.g;\nif (tmp<=0.0)\noutCol.g=0.0;\nelse if ((tmp=(1.0-(1.0-outCol.g)/tmp))<0.0)\noutCol.g=0.0;\nelse if (tmp>1.0)\noutCol.g=1.0;\nelse\noutCol.g=tmp;\ntmp=facm+fac*col2.b;\nif (tmp<=0.0)\noutCol.b=0.0;\nelse if ((tmp=(1.0-(1.0-outCol.b)/tmp))<0.0)\noutCol.b=0.0;\nelse if (tmp>1.0)\noutCol.b=1.0;\nelse\noutCol.b=tmp;\n}\n#ifdef HSV_NODES\nvoid node_mix_rgba_hue(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\nfloat facm=1.0-fac;\noutCol=col1;\nvec4 hsv,hsv2,tmp;\nrgbToHSV(col2,hsv2);\nif (hsv2.y != 0.0){\nrgbToHSV(outCol,hsv);\nhsv.x=hsv2.x;\nhsvToRGB(hsv,tmp);\noutCol=mix(outCol,tmp,fac);\noutCol.a=col1.a;\n}\n}\nvoid node_mix_rgba_saturation(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\nfloat facm=1.0-fac;\noutCol=col1;\nvec4 hsv,hsv2;\nrgbToHSV(outCol,hsv);\nif (hsv.y != 0.0){\nrgbToHSV(col2,hsv2);\nhsv.y=facm*hsv.y+fac*hsv2.y;\nhsvToRGB(hsv,outCol);\n}\n}\nvoid node_mix_rgba_value(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\nfloat facm=1.0-fac;\nvec4 hsv,hsv2;\nrgbToHSV(col1,hsv);\nrgbToHSV(col2,hsv2);\nhsv.z=facm*hsv.z+fac*hsv2.z;\nhsvToRGB(hsv,outCol);\n}\nvoid node_mix_rgba_color(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\nfloat facm=1.0-fac;\noutCol=col1;\nvec4 hsv,hsv2,tmp;\nrgbToHSV(col2,hsv2);\nif (hsv2.y != 0.0){\nrgbToHSV(outCol,hsv);\nhsv.x=hsv2.x;\nhsv.y=hsv2.y;\nhsvToRGB(hsv,tmp);\noutCol=mix(outCol,tmp,fac);\noutCol.a=col1.a;\n}\n}\n#endif\nvoid node_mix_rgba_soft_light(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\nfloat facm=1.0-fac;\nvec4 one=vec4(1.0);\nvec4 scr=one-(one-col2)*(one-col1);\noutCol=facm*col1+fac*((one-col1)*col2*col1+col1*scr);\n}\nvoid node_mix_rgba_linear_light(float fac,vec4 col1,vec4 col2,out vec4 outCol)\n{\nfac=clamp(fac,0.0,1.0);\noutCol=col1+fac*(2.0*(col2-vec4(0.5)));\n}\nvoid node_mix_vector_uniform(float fac,vec3 facVec,vec3 v1,vec3 v2,out vec3 outVec)\n{\nfac=clamp(fac,0.0,1.0);\noutVec=mix(v1,v2,fac);\n}\nvoid node_mix_vector_non_uniform(float fac,vec3 facVec,vec3 v1,vec3 v2,out vec3 outVec)\n{\nfacVec=clamp(facVec,0.0,1.0);\noutVec=mix(v1,v2,facVec);\n}\nvoid node_mix_float(float fac,float val1,float val2,out float outVal)\n{\nfac=clamp(fac,0.0,1.0);\noutVal=mix(val1,val2,fac);\n}",node_mix_shader_bl_frag="void node_mix_shader(int transpShaderNum,float fac,vec4 color1,vec4 color2,out vec4 outColor)\n{\nif (transpShaderNum==0)\ncolor1.rgb=color2.rgb;\nelse if (transpShaderNum==1)\ncolor2.rgb=color1.rgb;\noutColor=mix(color1,color2,clamp(fac,0.0,1.0));\n}",node_new_geometry_bl_frag="void node_new_geometry(float frontFacing,vec3 viewPos,vec3 viewNorm,out vec3 position,out vec3 normal,out vec3 tangent,out vec3 trueNormal,out vec3 incoming,out vec3 parametric,out float backfacing,out float pointiness,out float randomPerIsland)\n{\nvec4 posWorld=invViewMatrix*vec4(-viewPos,1.0);\nposition=swizzleUpZ(posWorld.xyz);\nvec4 viewDir=isOrthographic?vec4(0.0,0.0,-1.0,0.0):vec4(normalize(-viewPos),0.0);\nviewDir=invViewMatrix*viewDir;\nvec3 incomingVec=-swizzleUpZ(viewDir.xyz);\n#if WORLD_NODES==1\nnormal=incomingVec;\ntangent=vec3(0.0);\n#else\nvec3 norWorld=normalize(invViewMatrix*vec4(viewNorm,0.0)).xyz;\nnormal=swizzleUpZ(norWorld);\nvec4 posLocal=invModelMatrix*posWorld;\nvec3 posLocalDelta=posLocal.xyz-boundingBoxMin;\nvec3 bbDelta=boundingBoxMax-boundingBoxMin;\nvec3 posOrco=vec3(bbDelta.x<1e-5?-sign(posLocal.y):posLocalDelta.x/bbDelta.x,0.0,bbDelta.z<1e-5?sign(posLocal.y):posLocalDelta.z/bbDelta.z\n);\nposOrco-=0.5;\nvec3 tangWorld=(modelMatrix*vec4(posOrco.z,0.0,-posOrco.x,0.0)).xyz;\ntangWorld=cross(norWorld,normalize(cross(tangWorld,norWorld)));\ntangent=swizzleUpZ(tangWorld);\n#endif\ntrueNormal=normal;\nincoming=incomingVec;\nparametric=vec3(0.0);\nbackfacing=(frontFacing>0.0)?0.0:1.0;\n#if WORLD_NODES==1\npointiness=0.0;\n#else\npointiness=0.5;\n#endif\nrandomPerIsland=0.0;\n}",node_normal_bl_frag="void node_normal(vec3 norParam,vec3 norIn,out vec3 norOut,out float dotOut)\n{\nnorOut=norParam;\ndotOut=dot(normalize(norIn),norParam);\n}",node_normal_map_bl_frag="void node_normal_map(vec4 tangent,vec3 normal,float strength,vec4 normalColor,out vec3 normalOut)\n{\n#ifdef DOUBLE_SIDED\nnormal=normal*(float(gl_FrontFacing)*2.0-1.0);\n#endif\nif (all(lessThan(abs(tangent.xyz),vec3(EPSILON)))){\nnormalOut=normal;\n} else {\nvec3 normalTex=(normalColor.xyz*2.0-1.0);\nvec4 viewTangent=vec4(normalize((modelViewMatrix*vec4(tangent.xyz,0.0)).xyz),tangent.w);\nvec3 bitangent=viewTangent.w*cross(normal,viewTangent.xyz);\nnormalOut=normalize(normalTex.x*viewTangent.xyz+normalTex.y*bitangent\n+ normalTex.z*normal);\nnormalOut=mix(normal,normalOut,strength);\n}\nnormalOut=normalize((invViewMatrix*vec4(normalOut,0.0)).xyz);\nnormalOut=swizzleUpZ(normalOut);\n}",node_object_info_bl_frag="uniform int objectIndex;\nuniform vec4 objectColor;\nuniform int materialIndex;\nuniform float objectRandom;\nvoid node_object_info(out vec3 location,out vec4 color,out float alpha,out float objIndex,out float matIndex,out float random){\n#if WORLD_NODES==1\nlocation=vec3(0.0);\ncolor=vec4(1.0);\nalpha=1.0;\nobjIndex=0.0;\nmatIndex=0.0;\nrandom=0.0;\n#else\nlocation=swizzleUpZ(modelMatrix[3].xyz);\ncolor=vec4(objectColor.rgb,1.0);\nalpha=objectColor.a;\nobjIndex=float(objectIndex);\nmatIndex=float(materialIndex);\nrandom=float(objectRandom);\n#endif\n}",node_output_lamp_bl_frag="void node_output_lamp(out vec4 outColor)\n{\noutColor=vec4(0.0);\n}",node_output_material_bl_frag="void node_output_material(vec4 surface,vec4 volume,vec3 displacement,float thickness,out vec4 outgoingLight){\noutgoingLight=surface+volume;\n}",node_output_world_bl_frag="void node_output_world(vec4 surface,vec4 volume,out vec4 outgoingLight)\n{\noutgoingLight=surface;\n}",node_particle_info_bl_frag="void node_particle_info(out float index,out float random,out float age,out float lifeTime,out vec3 location,out float size,out vec3 velocity,out vec3 angularVelocity){\n#if WORLD_NODES==1\nindex=0.0;\nrandom=0.0;\nage=0.0;\nlifeTime=0.0;\nlocation=vec3(0.0);\nsize=0.0;\nvelocity=vec3(0.0);\nangularVelocity=vec3(0.0);\n#else\nindex=0.0;\nrandom=0.0;\nage=0.0;\nlifeTime=0.0;\nlocation=vec3(0.0);\nsize=0.0;\nvelocity=vec3(0.0);\nangularVelocity=vec3(0.0);\n#endif\n}",node_point_info_bl_frag="void node_point_info(out vec3 position,out float radius,out float random){\nposition=vec3(0.0);\nradius=0.0;\nrandom=0.0;\n}",node_principled_volume_bl_frag="void node_principled_volume(vec4 color,float colorAttribute,float density,float densityAttribute,float anisotropy,vec4 absorptionColor,float emissionStrength,vec4 emissionColor,float blackbodyIntensity,vec4 blackbodyTint,float temperature,float temperatureAttribute,out vec4 volume){\nvolume=vec4(0.0);\n}",node_rgb_bl_frag="uniform vec4 nodeRGB[NODE_RGB_NUM];\nvoid node_rgb(vec4 color,out vec4 outColor)\n{\noutColor=color;\n}",node_rgbtobw_bl_frag="void node_rgbtobw(vec4 color,out float outVal){\noutVal=linearToRelativeLuminance(color.rgb);\n}",node_script_bl_frag="void node_script(out vec4 outColor)\n{\noutColor=vec4(0.0);\n}",node_separate_color_bl_frag="#define NODE_SEP_COL_RGB 0\n#define NODE_SEP_COL_HSV 1\n#define NODE_SEP_COL_HSL 2\nvoid rgbToHSL(vec3 rgb,out vec3 outCol)\n{\nfloat cMax,cMin;\nfloat h,s,l;\ncMax=max(rgb[0],max(rgb[1],rgb[2]));\ncMin=min(rgb[0],min(rgb[1],rgb[2]));\nl=min(1.0,(cMax+cMin)/2.0);\nif (cMax==cMin){\nh=s=0.0;\n} else {\nfloat cdelta=cMax-cMin;\ns=l>0.5?cdelta/(2.0-cMax-cMin):cdelta/(cMax+cMin);\nif (cMax==rgb[0]){\nh=(rgb[1]-rgb[2])/cdelta+(rgb[1]<rgb[2]?6.0:0.0);\n} else if (cMax==rgb[1]){\nh=(rgb[2]-rgb[0])/cdelta+2.0;\n} else {\nh=(rgb[0]-rgb[1])/cdelta+4.0;\n}\n}\nh/=6.0;\noutCol=vec3(h,s,l);\n}\nvoid node_separate_color(int mode,vec4 color,out float r,out float g,out float b)\n{\nif (mode==NODE_SEP_COL_RGB){\nr=color.r;\ng=color.g;\nb=color.b;\n} else if (mode==NODE_SEP_COL_HSV){\nvec4 hsv;\nrgbToHSV(color,hsv);\nr=hsv[0];\ng=hsv[1];\nb=hsv[2];\n} else {\nvec3 hsl;\nrgbToHSL(color.rgb,hsl);\nr=hsl[0];\ng=hsl[1];\nb=hsl[2];\n}\n}",node_sepxyz_bl_frag="void node_sepxyz(vec3 vector,out float x,out float y,out float z)\n{\nx=vector.x;\ny=vector.y;\nz=vector.z;\n}",node_shadertorgb_bl_frag="void node_shadertorgb(vec4 shader,out vec4 color,out float alpha){\ncolor=vec4(shader.rgb,1.0);\nalpha=shader.a;\n}",node_squeeze_bl_frag="void node_squeeze(float val,float width,float center,out float outVal)\n{\noutVal=1.0/(1.0+pow(2.71828183,-((val-center)*width)));\n}",node_subsurface_scattering_bl_frag="void node_subsurface_scattering(vec4 color,float scale,vec3 radius,float ior,float anisotropy,float roughness,vec3 normal,out vec4 outColor)\n{\noutColor=color;\n}",node_tangent_bl_frag="#define TANGENT_AXIS_X 0\n#define TANGENT_AXIS_Y 1\n#define TANGENT_AXIS_Z 2\nvoid node_tangent(int axis,vec3 viewPos,vec3 viewNorm,out vec3 outTangent){\noutTangent=vec3(0.0);\n#if WORLD_NODES==0\nvec4 posWorld=invViewMatrix*vec4(-viewPos,1.0);\nvec3 norWorld=normalize(invViewMatrix*vec4(viewNorm,0.0)).xyz;\nvec3 posLocal=(invModelMatrix*posWorld).xyz;\nvec3 posOrco=(posLocal-boundingBoxMin)\n/ (boundingBoxMax-boundingBoxMin)-0.5;\nvec4 posOrcoPermuted;\nif (axis==TANGENT_AXIS_X){\nposOrcoPermuted=vec4(0.0,-posOrco.z,posOrco.y,0.0);\n} else if (axis==TANGENT_AXIS_Y){\nposOrcoPermuted=vec4(-posOrco.y,posOrco.x,0.0,0.0);\n} else if (axis==TANGENT_AXIS_Z){\nposOrcoPermuted=vec4(posOrco.z,0.0,-posOrco.x,0.0);\n}\nvec3 tangWorld=(modelMatrix*posOrcoPermuted).xyz;\ntangWorld=cross(norWorld,normalize(cross(tangWorld,norWorld)));\noutTangent=swizzleUpZ(tangWorld);\n#endif\n}\nvoid node_tangent(vec4 tangent,out vec3 outTangent){\n#if WORLD_NODES==0\noutTangent=normalize((modelMatrix*vec4(tangent.xyz,0.0)).xyz);\noutTangent=swizzleUpZ(outTangent);\n#endif\n}",node_tex_brick_bl_frag="float integer_noise(int rowCount,int brickCount)\n{\n#if __VERSION__==300\nint n=(rowCount << 16)+(brickCount&0xFFFF);\nn=(n+1013)&0x7fffffff;\nn=(n >> 13)^ n;\nint nn=(n*(n*n*60493+19990303)+1376312589)&0x7fffffff;\nreturn 0.5*(float(nn)/1073741824.0);\n#else\nconst int RAND_MAX=32767;\nint next=((123456*rowCount)+brickCount)*1103515245+12345;\nreturn (mod(float(next/65536),float(RAND_MAX+1)))/float(RAND_MAX);\n#endif\n}\nvoid node_tex_brick(float offset,int offsetFrequency,float squash,int squashFrequency,vec3 vector,vec4 color1,vec4 color2,vec4 mortar,float scale,float mortarSize,float mortarSmooth,float bias,float brickWidth,float rowHeight,out vec4 outColor,out float outFac)\n{\nfloat x,y;\nvec3 p=vector*scale;\nfloat rowCount=floor(p.y/rowHeight);\nif (offsetFrequency != 0&&squashFrequency != 0){\nbrickWidth*=mod(rowCount,float(squashFrequency))>0.5?1.0:squash;\noffset=mod(rowCount,float(offsetFrequency))>0.5?0.0:(brickWidth*offset);\n} \nint brickCount=int((p.x+offset)/brickWidth);\nfloat tint=clamp((integer_noise(int(rowCount),brickCount)+bias),0.0,1.0);\n\nx=abs((p.x+offset)-brickWidth*float(brickCount));\ny=abs(p.y-rowHeight*rowCount);\nfloat min_dist=min(min(x,y),min(brickWidth-x,rowHeight-y));\n\nfloat f=step(min_dist,mortarSize);\nif (mortarSmooth>0.0){\nmin_dist=1.0-min_dist/mortarSize;\nf*=smoothstep(0.0,mortarSmooth,min_dist);\n}\noutColor=mix(mix(color1,color2,tint),mortar,f);\noutFac=f;\n}",node_tex_checker_bl_frag="void node_tex_checker(vec3 vector,vec4 color1,vec4 color2,float scale,out vec4 outColor,out float outFac)\n{\nvec3 p=vector*scale;\np=(p+0.00001)*0.99999;\nfloat cx=floor(p.x);\nfloat cy=floor(p.y);\nfloat cz=floor(p.z);\nfloat result=sign(mod(cx+cy+cz,2.0));\noutFac=max(result,0.0);\noutColor=mix(color2,color1,outFac);\n}",node_tex_coord_bl_frag="uniform mat4 nodeTexCoordObjectMatrices[NODE_TEX_COORD_NUM];\nvoid node_tex_coord(mat4 objectMat,vec3 viewPos,vec3 viewNorm,vec2 uv,out vec3 outGenerated,out vec3 outNormal,out vec3 outUV,out vec3 outObject,out vec3 outCamera,out vec3 outWindow,out vec3 outReflection)\n{\nvec4 view=vec4(-viewPos,1.0);\nvec4 posWorld=invViewMatrix*view;\nvec3 loc=swizzleUpZ((invModelMatrix*posWorld).xyz);\n#if WORLD_NODES==1\nloc=normalize(loc);\n#endif\n#if WORLD_NODES==1\noutGenerated=loc;\n#else\nvec3 boxMin=vec3(boundingBoxMin.x,-boundingBoxMax.z,boundingBoxMin.y);\nvec3 boxMax=vec3(boundingBoxMax.x,-boundingBoxMin.z,boundingBoxMax.y);\nvec3 boxSize=boxMax-boxMin;\nif (abs(boxSize.x)<0.001){\noutGenerated.x=0.5;\n} else {\noutGenerated.x=(loc.x-boxMin.x)/boxSize.x;\n}\nif (abs(boxSize.y)<0.001){\noutGenerated.y=0.5;\n} else {\noutGenerated.y=(loc.y-boxMin.y)/boxSize.y;\n}\nif (abs(boxSize.z)<0.001){\noutGenerated.z=0.5;\n} else {\noutGenerated.z=(loc.z-boxMin.z)/boxSize.z;\n}\n#endif\n#if WORLD_NODES==1\noutNormal=-loc;\n#else\noutNormal=normalize(invModelMatrix*invViewMatrix*vec4(viewNorm,0.0)).rgb;\noutNormal=swizzleUpZ(outNormal);\n#endif\n#if WORLD_NODES==1\noutUV=vec3(0.0);\n#else\nuv.y=1.0-uv.y;\noutUV=vec3(uv,0.0);\n#endif\n#if WORLD_NODES==1\noutObject=loc;\n#else\noutObject=swizzleUpZ((objectMat*posWorld).xyz);\n#endif\noutCamera=vec3(view.xy,-view.z);\n#if WORLD_NODES==1\noutWindow=vec3(0.0);\n#else\noutWindow=vec3(gl_FragCoord.xy/viewWidthHeight,0.0);\n#endif\n#if WORLD_NODES==1\noutReflection=-loc;\n#else\nvec4 reflection=(invViewMatrix*vec4(reflect(view.xyz,normalize(viewNorm)),0.0));\noutReflection=normalize(swizzleUpZ(reflection.xyz));\n#endif\n}",node_tex_environment_bl_frag="#define TEX_PROJ_EQUIRECTANGULAR 0\n#define TEX_PROJ_MIRROR_BALL 1\nvoid node_tex_environment(sampler2D tex,const int encoding,const int projection,vec3 vector,out vec4 outColor){\nvec2 uv;\nfloat bias;\nif (projection==TEX_PROJ_EQUIRECTANGULAR){\nvec3 direction=swizzleUpY(vector);\nif (length(direction)==0.0){\ndirection=vec3(0.0,1.0,0.0);\n} else {\ndirection=normalize(direction);\n}\nuv=equirectUv(direction);\n#if WORLD_NODES==1\nbias=-16.0;\n#else\nconst float seamWidth=0.15;\nconst float seamBiasFactor=-10.0;\nfloat seam=max(0.0,1.0-abs (direction.z)/seamWidth)*\nclamp (1.0-direction.x/seamWidth,0.0,1.0);\nbias=seamBiasFactor*seam;\n#endif\n} else {\nvec3 normal=normalize(vector);\nnormal.y-=1.0;\nnormal/=(2.0*sqrt(max(-0.5*normal.y,0.0)));\nuv=clamp(0.5*normal.xz+0.5,0.0,1.0);\nbias=0.0;\n}\nuv.y=1.0-uv.y;\noutColor=texture2D(tex,uv,bias);\noutColor=nodeTexelToLinear(outColor,encoding);\n}",node_tex_environment_none_bl_frag="void node_tex_environment_none(vec3 vector,out vec4 outColor){\noutColor=vec4(1.0,0.0,1.0,1.0);\n}",node_tex_gabor_bl_frag="#define TEX_GABOR_2D 0\n#define TEX_GABOR_3D 1\n#define IMPULSES_COUNT 8\n#if __VERSION__==300\nvec2 compute2DGaborKernel(vec2 position,float frequency,float orientation){\nfloat distanceSq=dot(position,position);\nfloat hannWindow=0.5+0.5*cos(PI*distanceSq);\nfloat gaussianEnvelop=exp(-PI*distanceSq);\nfloat windowedGaussianEnvelope=gaussianEnvelop*hannWindow;\nvec2 frequencyVector=frequency*vec2(cos(orientation),sin(orientation));\nfloat angle=2.0*PI*dot(position,frequencyVector);\nvec2 phasor=vec2(cos(angle),sin(angle));\nreturn windowedGaussianEnvelope*phasor;\n}\nfloat compute2DGaborStandardDeviation(){\nfloat integralOfGaborSq=0.25;\nfloat secondMoment=0.5;\nreturn sqrt(float(IMPULSES_COUNT)*secondMoment*integralOfGaborSq);\n}\nvec2 compute2DGaborNoiseCell(vec2 cell,vec2 position,float frequency,float isotropy,float baseOrientation){\nvec2 noise=vec2(0.0);\nfor (int i=0;i<IMPULSES_COUNT;++i){\nvec3 seedForOrientation=vec3(cell,i*3);\nvec3 seedForKernelCenter=vec3(cell,i*3+1);\nvec3 seedForWeight=vec3(cell,i*3+2);\nfloat random_orientation=(hashVec3ToFloat(seedForOrientation)-0.5)*PI;\nfloat orientation=baseOrientation+random_orientation*isotropy;\nvec2 kernelCenter=hashVec3ToVec2(seedForKernelCenter);\nvec2 positionInKernelSpace=position-kernelCenter;\nif (dot(positionInKernelSpace,positionInKernelSpace)>=1.0)\ncontinue;\nfloat weight=hashVec3ToFloat(seedForWeight)<0.5?-1.0:1.0;\nnoise+=weight*compute2DGaborKernel(positionInKernelSpace,frequency,orientation);\n}\nreturn noise;\n}\nvec2 compute2DGaborNoise(vec2 coordinates,float frequency,float isotropy,float baseOrientation){\nvec2 cellPosition=floor(coordinates);\nvec2 localPosition=coordinates-cellPosition;\nvec2 sum=vec2(0.0);\nfor (int j=-1;j<=1;j++){\nfor (int i=-1;i<=1;i++){\nvec2 cellOffset=vec2(i,j);\nvec2 currCellPosition=cellPosition+cellOffset;\nvec2 positionInCellSpace=localPosition-cellOffset;\nsum+=compute2DGaborNoiseCell(currCellPosition,positionInCellSpace,frequency,isotropy,baseOrientation);\n}\n}\nreturn sum;\n}\nvec2 compute3DGaborKernel(vec3 position,float frequency,vec3 orientation){\nfloat distanceSq=dot(position,position);\nfloat hannWindow=0.5+0.5*cos(PI*distanceSq);\nfloat gaussianEnvelop=exp(-PI*distanceSq);\nfloat windowedGaussianEnvelope=gaussianEnvelop*hannWindow;\nvec3 frequencyVector=frequency*orientation;\nfloat angle=2.0*PI*dot(position,frequencyVector);\nvec2 phasor=vec2(cos(angle),sin(angle));\nreturn windowedGaussianEnvelope*phasor;\n}\nfloat compute3DGaborStandardDeviation(){\nfloat integralOfGaborSq=1.0/(4.0*sqrt(2.0));\nfloat secondMoment=0.5;\nreturn sqrt(float(IMPULSES_COUNT)*secondMoment*integralOfGaborSq);\n}\nvec3 compute3DOrientation(vec3 orientation,float isotropy,vec4 seed){\nif (isotropy==0.0)\nreturn orientation;\nfloat inclination=acos(orientation.z);\nfloat azimuth=sign(orientation.y)*acos(orientation.x/length(orientation.xy));\nvec2 randomAngles=hashVec4ToVec2(seed)*PI;\ninclination+=randomAngles.x*isotropy;\nazimuth+=randomAngles.y*isotropy;\nreturn vec3(sin(inclination)*cos(azimuth),sin(inclination)*sin(azimuth),cos(inclination));\n}\nvec2 compute3DGaborNoiseCell(vec3 cell,vec3 position,float frequency,float isotropy,vec3 baseOrientation){\nvec2 noise=vec2(0.0);\nfor (int i=0;i<IMPULSES_COUNT;++i){\nvec4 seedForOrientation=vec4(cell,i*3);\nvec4 seedForKernelCenter=vec4(cell,i*3+1);\nvec4 seedForWeight=vec4(cell,i*3+2);\nvec3 orientation=compute3DOrientation(baseOrientation,isotropy,seedForOrientation);\nvec3 kernelCenter=hashVec4ToVec3(seedForKernelCenter);\nvec3 positionInKernelSpace=position-kernelCenter;\nif (dot(positionInKernelSpace,positionInKernelSpace)>=1.0)\ncontinue;\nfloat weight=hashVec4ToFloat(seedForWeight)<0.5?-1.0:1.0;\nnoise+=weight*compute3DGaborKernel(positionInKernelSpace,frequency,orientation);\n}\nreturn noise;\n}\nvec2 compute3DGaborNoise(vec3 coordinates,float frequency,float isotropy,vec3 baseOrientation){\nvec3 cellPosition=floor(coordinates);\nvec3 localPosition=coordinates-cellPosition;\nvec2 sum=vec2(0.0);\nfor (int k=-1;k<=1;k++){\nfor (int j=-1;j<=1;j++){\nfor (int i=-1;i<=1;i++){\nvec3 cellOffset=vec3(i,j,k);\nvec3 currCellPosition=cellPosition+cellOffset;\nvec3 positionInCellSpace=localPosition-cellOffset;\nsum+=compute3DGaborNoiseCell(currCellPosition,positionInCellSpace,frequency,isotropy,baseOrientation);\n}\n}\n}\nreturn sum;\n}\nvoid node_tex_gabor(int gaborType,vec3 vector,float scale,float frequency,float anisotropy,float orientation2D,vec3 orientation3D,out float outValue,out float outPhase,out float outIntensity){\nvec3 scaledVector=vector*scale;\nfloat isotropy=1.0-clamp(anisotropy,0.0,1.0);\nfrequency=max(0.001,frequency);\nvec2 phasor=vec2(0.0);\nfloat standard_deviation=1.0;\nif (gaborType==TEX_GABOR_2D){\nphasor=compute2DGaborNoise(scaledVector.xy,frequency,isotropy,orientation2D);\nstandard_deviation=compute2DGaborStandardDeviation();\n} else {\nvec3 orientation=normalize(orientation3D);\nphasor=compute3DGaborNoise(scaledVector,frequency,isotropy,orientation);\nstandard_deviation=compute3DGaborStandardDeviation();\n}\nfloat normalizationFactor=6.0*standard_deviation;\noutValue=(phasor.y/normalizationFactor)*0.5+0.5;\noutPhase=(atan(phasor.y,phasor.x)+PI)/(2.0*PI);\noutIntensity=length(phasor)/normalizationFactor;\n}\n#else\nvoid node_tex_gabor(int gaborType,vec3 vector,float scale,float frequency,float anisotropy,float orientation2D,vec3 orientation3D,out float outValue,out float outPhase,out float outIntensity){\noutValue=0.0;\noutPhase=0.0;\noutIntensity=0.0;\n}\n#endif",node_tex_gradient_bl_frag="#define TEX_GRAD_LINEAR 0\n#define TEX_GRAD_QUADRATIC 1\n#define TEX_GRAD_EASING 2\n#define TEX_GRAD_DIAGONAL 3\n#define TEX_GRAD_SPHERICAL 4\n#define TEX_GRAD_QUADRATIC_SPHERE 5\n#define TEX_GRAD_RADIAL 6\nvoid node_tex_gradient(const int type,vec3 vector,out vec4 outColor,out float outFac)\n{\nfloat x,y,z,r;\nx=vector.x;\ny=vector.y;\nz=vector.z;\nif (type==TEX_GRAD_LINEAR){\noutFac=x;\n} else if (type==TEX_GRAD_QUADRATIC){\nr=max(x,0.0);\noutFac=pow2(r);\n} else if (type==TEX_GRAD_EASING){\nr=min(max(x,0.0),1.0);\noutFac=(3.0*pow2(r)-2.0*pow3(r));\n} else if (type==TEX_GRAD_DIAGONAL){\noutFac=(x+y)*0.5;\n} else if (type==TEX_GRAD_RADIAL){\noutFac=atan(y,x)/PI2+0.5;\n} else {\nr=max(0.99999-sqrt(x*x+y*y+z*z),0.0);\nif (type==TEX_GRAD_QUADRATIC_SPHERE){\noutFac=pow2(r);\n} else if (type==TEX_GRAD_SPHERICAL){\noutFac=r;\n}\n}\noutFac=clamp(outFac,0.0,1.0);\noutColor=vec4(outFac,outFac,outFac,1.0);\n}",node_tex_ies_bl_frag="void node_tex_ies(vec3 vector,float strength,out float fac){\nfac=0.0;\n}",node_tex_image_bl_frag="#define TEX_PROJ_FLAT 0\n#define TEX_PROJ_BOX 1\n#define TEX_PROJ_SPHERE 2\n#define TEX_PROJ_TUBE 3\n#define TEX_ALPHA_CLEAR 0\n#define TEX_ALPHA_PREMUL 1\n#define TEX_ALPHA_UNPREMUL 2\n#define TEX_ALPHA_ONE 3\nvec4 applyAlphaMode(vec4 color,const int alphaMode){\nif (alphaMode==TEX_ALPHA_CLEAR){\n} else if (alphaMode==TEX_ALPHA_PREMUL){\ncolor.rgb=color.rgb*color.a;\n} else if (alphaMode==TEX_ALPHA_UNPREMUL){\nfloat alpha=color.a;\ncolor.rgb=clamp(color.rgb,0.0,alpha);\nif (alpha==0.0)\ncolor.rgb=vec3(0.0);\nelse\ncolor.rgb/=alpha;\n}\nreturn color;\n}\nvoid node_tex_image(sampler2D ima,const int encoding,const int alphaMode,vec3 viewNorm,const int projection,const float projectionBlend,const bool clampToEdgeNoExtend,vec3 vector,out vec4 outColor,out float outAlpha){\nif (projection==TEX_PROJ_FLAT){\nvec2 uv=vector.xy;\nuv.y=1.0-uv.y;\nif (clampToEdgeNoExtend&&(uv.x<0.0||uv.x>1.0||uv.y<0.0||uv.y>1.0)){\noutColor=vec4(0.0);\noutAlpha=0.0;\n} else {\noutColor=texture2D(ima,uv);\noutAlpha=outColor.a;\n}\noutColor=nodeTexelToLinear(outColor,encoding);\n} else if (projection==TEX_PROJ_BOX){\nvec3 norm=normalize(viewNorm*normalMatrix);\nvector=swizzleUpY(vector);\nvec2 uvX=vec2(-sign(norm.x)*vector.z,-vector.y);\nvec2 uvY=vec2(sign(norm.y)*vector.z,-vector.x);\nvec2 uvZ=vec2(sign(norm.z)*vector.x,-vector.y);\nvec4 colX=nodeTexelToLinear(texture2D(ima,uvX),encoding);\nvec4 colY=nodeTexelToLinear(texture2D(ima,uvY),encoding);\nvec4 colZ=nodeTexelToLinear(texture2D(ima,uvZ),encoding);\nvec3 barycentric=abs(norm);\nbarycentric/=barycentric.x+barycentric.y+barycentric.z;\nvec3 edgeShape=min(min(barycentric.yzx,barycentric.zxy),(projectionBlend-1.0)/(projectionBlend-3.0));\nvec3 edgeValue=(1.0-projectionBlend)*(1.0-edgeShape)/2.0;\nvec3 weight=max((barycentric-edgeValue)/(1.0-edgeValue),EPSILON);\nweight/=(weight.x+weight.y+weight.z);\noutColor=weight.x*colX+weight.y*colY+weight.z*colZ;\noutAlpha=outColor.a;\n} else if (projection==TEX_PROJ_SPHERE){\nvector=normalize(vector*2.0-1.0);\nvector=swizzleUpY(vector);\nvec2 uv=vec2(atan(vector.x,vector.z)/PI2,acos(vector.y)/PI);\nuv.x=mod(uv.x,1.0);\noutColor=texture2D(ima,uv);\noutAlpha=outColor.a;\noutColor=nodeTexelToLinear(outColor,encoding);\n} else if (projection==TEX_PROJ_TUBE){\nvector=vector*2.0-1.0;\nvector=swizzleUpY(vector);\nvec2 uv=vec2(atan(vector.x,vector.z)/PI2,(1.0-vector.y)/2.0);\nuv.x=mod(uv.x,1.0);\noutColor=texture2D(ima,uv);\noutAlpha=outColor.a;\noutColor=nodeTexelToLinear(outColor,encoding);\n}\noutColor=applyAlphaMode(outColor,alphaMode);\nif (alphaMode==TEX_ALPHA_ONE)\noutAlpha=1.0;\n}",node_tex_image_none_bl_frag="void node_tex_image_none(vec3 vector,out vec4 color,out float alpha)\n{\ncolor=vec4(1.0,0.0,1.0,1.0);\nalpha=1.0;\n}",node_tex_magic_bl_frag="void node_tex_magic(const int depth,vec3 vector,float scale,float distortion,out vec4 outColor,out float outFac)\n{\nvec3 p=mod(vector*scale,2.0*PI);\nfloat x=sin((p.x+p.y+p.z)*5.0);\nfloat y=cos((-p.x+p.y-p.z)*5.0);\nfloat z=-cos((-p.x-p.y+p.z)*5.0);\nif (depth>0){\nx*=distortion;\ny*=distortion;\nz*=distortion;\ny=-cos(x-y+z);\ny*=distortion;\nif (depth>1){\nx=cos(x-y-z);\nx*=distortion;\nif (depth>2){\nz=sin(-x-y-z);\nz*=distortion;\nif (depth>3){\nx=-cos(-x+y-z);\nx*=distortion;\nif (depth>4){\ny=-sin(-x+y+z);\ny*=distortion;\nif (depth>5){\ny=-cos(-x+y+z);\ny*=distortion;\nif (depth>6){\nx=cos(x+y+z);\nx*=distortion;\nif (depth>7){\nz=sin(x+y-z);\nz*=distortion;\nif (depth>8){\nx=-cos(-x-y+z);\nx*=distortion;\nif (depth>9){\ny=-sin(x-y+z);\ny*=distortion;\n}\n}\n}\n}\n}\n}\n}\n}\n}\n}\nif (distortion != 0.0){\ndistortion*=2.0;\nx/=distortion;\ny/=distortion;\nz/=distortion;\n}\noutColor=vec4(0.5-x,0.5-y,0.5-z,1.0);\noutFac=(outColor.x+outColor.y+outColor.z)/3.0;\n}",node_tex_noise_bl_frag="#define TEX_NOISE_MULTIFRACTAL 0\n#define TEX_NOISE_RIDGED_MULTIFRACTAL 1\n#define TEX_NOISE_HYBRID_MULTIFRACTAL 2\n#define TEX_NOISE_FBM 3\n#define TEX_NOISE_HETERO_TERRAIN 4\nvoid node_tex_noise(int noiseType,float falloffFactor,float dispersionFactor,vec3 vector,float w,float scale,float detail,float roughness,float lacunarity,float offset,float gain,float distortion,out float outFac,out vec4 outColor){\nvec3 p=vector*scale;\nvec3 dx=dFdx(p);\nvec3 dy=dFdy(p);\nfloat octaveLenPerPixel=(length(dx)+length(dy))/4.0;\nif (distortion != 0.0){\nvec3 r,offset=vec3(13.5,13.5,13.5);\nr.x=noiseSmooth(p+offset,octaveLenPerPixel,falloffFactor,dispersionFactor)*distortion;\nr.y=noiseSmooth(p,octaveLenPerPixel,falloffFactor,dispersionFactor)*distortion;\nr.z=noiseSmooth(p-offset,octaveLenPerPixel,falloffFactor,dispersionFactor)*distortion;\np+=r;\n}\noutFac=noiseTurbulence(p,detail,octaveLenPerPixel,falloffFactor,dispersionFactor);\nvec3 color=vec3(outFac,noiseTurbulence(vec3(p.y,p.x,p.z),detail,octaveLenPerPixel,falloffFactor,dispersionFactor),noiseTurbulence(vec3(p.y,p.z,p.x),detail,octaveLenPerPixel,falloffFactor,dispersionFactor)\n);\noutColor=vec4(color,1.0);\n}",node_tex_pointdensity_bl_frag="void node_tex_pointdensity(vec3 vector,out vec4 outColor,out float outDensity)\n{\noutColor=vec4(0.0);\noutDensity=0.0;\n}",node_tex_sky_bl_frag="\n#define TEX_SKY_PREETHAM 0\n#define TEX_SKY_HOSEK_WILKIE 1\n#define TEX_SKY_NISHITA 2\n#define Km 683.0\nvec3 sky_spherical_coordinates(vec3 dir){\nreturn vec3(PI_HALF-atan(dir.z,length(dir.xy)),atan(dir.x,dir.y),0.0);\n}\nvoid node_tex_sky(const int skyType,vec3 param0,vec3 param1,vec3 param2,vec3 param3,vec3 param4,vec3 param5,vec3 param6,vec3 param7,vec3 param8,vec3 radiance,vec3 sunDirection,vec3 vectorIn,out vec4 outColor){\nif (length(vectorIn)==0.0){\nvectorIn=vec3(0.0,1.0,0.0);\n} else {\nvectorIn=normalize(vectorIn);\n}\nvectorIn=swizzleUpY(vectorIn);\nsunDirection=swizzleUpY(sunDirection);\nfloat cosGamma=clamp(dot(vectorIn,sunDirection),-1.0,1.0);\nfloat cosTheta=clamp(vectorIn.y,0.0,1.0);\nif (skyType==TEX_SKY_PREETHAM){\nvec3 radInternal=(1.0+param0*exp(param1/cosTheta))*(1.0+param2*exp(param3*acos(cosGamma))\n+ param4*pow(cosGamma,2.0)\n);\nvec3 XYZ=xyY_to_XYZ(radInternal.y*radiance.y,radInternal.z*radiance.z,radInternal.x*radiance.x);\noutColor=vec4(max(xyz_to_sRGB(XYZ),0.0),1.0);\n} else if (skyType==TEX_SKY_HOSEK_WILKIE){\nfloat cosGammaSq=pow(cosGamma,2.0);\nvec3 chi=(1.0+cosGammaSq)/pow(1.0+pow(param8,vec3(2.0))\n- 2.0*param8*cosGamma,vec3(1.5));\nvec3 radInternal=(1.0+param0*exp(param1/(cosTheta+0.01)))*(param2+param3*exp(param4*acos(cosGamma))\n+ param5*cosGammaSq+param6*chi+param7*sqrt(cosTheta)\n);\noutColor=vec4(max(xyz_to_sRGB(radInternal*radiance),0.0)*PI2/Km,1.0);\n} else {\noutColor=vec4(0.0,0.0,0.0,1.0);\n}\n}\nvoid node_tex_sky(sampler2D ima,float sunRotation,vec3 vectorIn,out vec4 outColor){\nvec3 spherical=sky_spherical_coordinates(vectorIn);\nif (vectorIn.z<-0.4f){\noutColor=vec4(0,0,0,1);\n} else {\nconst float tau=6.28318530717958647692;\nfloat x=(spherical.y+PI+sunRotation)/tau;\nif (x>1.0){\nx-=1.0;\n}\nfloat fade;\nfloat y;\nif (vectorIn.z<0.0){\nfade=1.0f+vectorIn.z*2.5;\nfade=fade*fade*fade;\ny=0.0;\n} else {\nfade=1.0;\ny=sqrt((PI_HALF-spherical.x)/PI_HALF);\n}\nvec3 xyz=fade*texture(ima,vec2(x,y)).rgb;\noutColor=vec4(xyz_to_sRGB(xyz),1.0);\n}\n}",node_tex_voronoi_bl_frag="#define DISTANCE_EUCLIDEAN 0\n#define DISTANCE_MANHATTAN 1\n#define DISTANCE_CHEBYCHEV 2\n#define DISTANCE_MINKOWSKI 3\n#define FEATURE_F1 0\n#define FEATURE_F2 1\n#define FEATURE_SMOOTH_F1 2\n#define FEATURE_DISTANCE_TO_EDGE 3\n#define FEATURE_N_SPHERE_RADIUS 4\nstruct VoronoiGridData {\nvec3 point;\nvec3 randVec;\nvec3 toClosest;\nfloat dist;\n};\nhighp vec3 rand3(const in vec3 v){\nconst highp float c=43758.5453;\nconst highp mat3 coeffs=mat3(165.15,253.34,323.22,241.49,329.07,147.79,376.31,143.45,281.63\n);\nhighp vec3 sn=mod(coeffs*v,PI);\nreturn fract(sin(sn)*c);\n}\nfloat worleyLength(vec3 vec,int distance,float exponent){\nif (distance==DISTANCE_EUCLIDEAN){\nreturn length(vec);\n} else if (distance==DISTANCE_MANHATTAN){\nreturn abs(vec.x)+abs(vec.y)+abs(vec.z);\n} else if (distance==DISTANCE_CHEBYCHEV){\nreturn max(max(abs(vec.x),abs(vec.y)),abs(vec.z));\n} else if (distance==DISTANCE_MINKOWSKI){\nreturn pow(pow(abs(vec.x),exponent)\n+ pow(abs(vec.y),exponent)\n+ pow(abs(vec.z),exponent),1.0/exponent);\n}\nreturn 0.0;\n}\nvoid worleyNoise(vec3 pos,int distance,float exponent,int feature,float smoothness,float randomness,out float outDist,out vec4 outColor,out vec3 outPosition,out float outW,out float outRadius){\nconst highp float RAND_FIX_ZERO=0.125;\nvec3 posI=floor(pos);\nvec3 posF=fract(pos);\nVoronoiGridData vgd[27];\n#pragma unroll_loop\nfor (int i=0;i<=2;i++){\n#pragma unroll_loop\nfor (int j=0;j<=2;j++){\n#pragma unroll_loop\nfor (int k=0;k<=2;k++){\nvec3 point=vec3((i),(j),(k))-1.0;\nvec3 randVec=rand3(posI+point+RAND_FIX_ZERO);\nvec3 toClosest=point+randomness*randVec-posF;\nconst int counter=(i)+(j)*3+(k)*9;\nvgd[counter].point=point;\nvgd[counter].randVec=randVec;\nvgd[counter].toClosest=toClosest;\nvgd[counter].dist=worleyLength(toClosest,distance,exponent);\n}\n}\n}\nfloat f1=1e10;\nfloat f2=1e10;\nvec3 edgeToClosest=vec3(0.0);\nfloat distToEdge=1e10;\nvec3 randColF1=vec3(0.0);\nvec3 randColF2=vec3(0.0);\nvec3 toClosestF1=vec3(0.0);\nvec3 toClosestF2=vec3(0.0);\nvec3 radPoint=vec3(0.0);\nvec3 radToClosest=vec3(0.0);\n#pragma unroll_loop\nfor (int i=0;i<27;i++){\nif (feature==FEATURE_F1){\nif (vgd[i].dist<f1){\nf1=vgd[i].dist;\nrandColF1=vgd[i].randVec;\ntoClosestF1=vgd[i].toClosest;\n}\n} else if (feature==FEATURE_F2){\nif (vgd[i].dist<f1){\nf2=f1;\nf1=vgd[i].dist;\nrandColF2=randColF1;\nrandColF1=vgd[i].randVec;\ntoClosestF2=toClosestF1;\ntoClosestF1=vgd[i].toClosest;\n} else if (vgd[i].dist<f2){\nf2=vgd[i].dist;\nrandColF2=vgd[i].randVec;\ntoClosestF2=vgd[i].toClosest;\n}\n} else if (feature==FEATURE_SMOOTH_F1){\nf1=smoothMin(f1,vgd[i].dist,smoothness);\n} else if (feature==FEATURE_DISTANCE_TO_EDGE){\nfloat dist=worleyLength(vgd[i].toClosest,DISTANCE_EUCLIDEAN,exponent);\nif (dist<f1){\nf1=dist;\nedgeToClosest=vgd[i].toClosest;\n}\n} else if (feature==FEATURE_N_SPHERE_RADIUS){\nfloat dist=worleyLength(vgd[i].toClosest,DISTANCE_EUCLIDEAN,exponent);\nif (dist<f1){\nf1=dist;\nradPoint=vgd[i].point;\nradToClosest=vgd[i].toClosest;\n}\n}\n}\nif (feature==FEATURE_F1){\noutDist=f1;\noutColor=vec4(randColF1,1.0);\noutPosition=pos+toClosestF1;\n} else if (feature==FEATURE_F2){\noutDist=f2;\noutColor=vec4(randColF2,1.0);\noutPosition=pos+toClosestF2;\n} else if (feature==FEATURE_SMOOTH_F1){\noutDist=f1;\nvec3 avgCol=vec3(0.0);\nvec3 avgOff=vec3(0.0);\nfloat sumWeightsCol=0.0;\nfloat sumWeightsOff=0.0;\n#pragma unroll_loop\nfor (int i=0;i<27;i++){\nfloat smoothFac=getSmoothFactor(f1,vgd[i].dist,smoothness);\nfloat weightOff=smoothFac*smoothFac*smoothFac;\nfloat weightCol=weightOff*smoothFac;\navgCol+=vgd[i].randVec*weightCol;\navgOff+=vgd[i].toClosest*weightOff;\nsumWeightsCol+=weightCol;\nsumWeightsOff+=weightOff;\n}\noutColor=vec4(avgCol/sumWeightsCol,1.0);\noutPosition=pos+avgOff/sumWeightsOff;\n} else if (feature==FEATURE_DISTANCE_TO_EDGE){\n#pragma unroll_loop\nfor (int i=0;i<27;i++){\nif (vgd[i].toClosest != edgeToClosest){\nfloat dist=dot(0.5*(edgeToClosest+vgd[i].toClosest),normalize(vgd[i].toClosest-edgeToClosest));\ndistToEdge=min(distToEdge,dist);\n}\n}\noutDist=distToEdge;\n} else if (feature==FEATURE_N_SPHERE_RADIUS){\nfloat diam=1e10;\n#pragma unroll_loop\nfor (int i=0;i<=2;i++){\n#pragma unroll_loop\nfor (int j=0;j<=2;j++){\n#pragma unroll_loop\nfor (int k=0;k<=2;k++){\nvec3 localPoint=vec3((i),(j),(k))-1.0;\nif (length(localPoint)>0.0){\nvec3 point=localPoint+radPoint;\nvec3 randVec=rand3(posI+point+RAND_FIX_ZERO);\nvec3 toClosest=point+randomness*randVec-posF;\ndiam=min(diam,length(toClosest-radToClosest));\n}\n}\n}\n}\noutRadius=diam/2.0;\n}\n}\n#define VORONOI_SMOOTH_COEFF 0.74\nvoid node_tex_voronoi(int distance,int feature,vec3 vector,float w,float scale,float detail,float roughness,float lacunarity,float smoothness,float exponent,float randomness,out float outDistance,out vec4 outColor,out vec3 outPosition,out float outW,out float outRadius){\nvector=scale*(vector-0.0001);\nsmoothness=clamp(smoothness,1e-3,1.0);\nsmoothness*=VORONOI_SMOOTH_COEFF;\nworleyNoise(vector,distance,exponent,feature,smoothness,randomness,outDistance,outColor,outPosition,outW,outRadius);\noutPosition/=scale;\n}\n#define FEATURE_F3 5\n#define FEATURE_F4 6\n#define FEATURE_F2F1 7\n#define COLORING_INTENSITY 0\n#define COLORING_CELLS 1\nstruct VoronoiClosest {\nvec4 closestDists;\nvec4 closestInds;\n};\nvoid updateVoronoiClosest(inout VoronoiClosest vf,vec3 newDistances,vec3 newIndices){\n#pragma unroll_loop\nfor (int i=0;i<3;i++){\nfloat currDist=newDistances[i];\nfloat currIdx=newIndices[i];\n#pragma unroll_loop\nfor (int j=0;j<4;j++){\nif (currDist<vf.closestDists[j]){\nfloat tmp=vf.closestDists[j];\nvf.closestDists[j]=currDist;\ncurrDist=tmp;\ntmp=vf.closestInds[j];\nvf.closestInds[j]=currIdx;\ncurrIdx=tmp;\n}\n}\n}\n}\nvec3 worleyPermute(vec3 x){\nreturn mod((34.0*x+1.0)*x,289.0);\n}\nvec3 worleyDist(vec3 x,vec3 y,vec3 z,int distance,float exponent){\nif (distance==DISTANCE_EUCLIDEAN){\nreturn x*x+y*y+z*z;\n} else if (distance==DISTANCE_MANHATTAN){\nreturn abs(x)+abs(y)+abs(z);\n} else if (distance==DISTANCE_CHEBYCHEV){\nreturn max(max(abs(x),abs(y)),abs(z));\n} else if (distance==DISTANCE_MINKOWSKI){\nvec3 expVec=vec3(exponent);\nreturn pow(pow(abs(x),expVec)\n+ pow(abs(y),expVec)\n+ pow(abs(z),expVec),1.0/expVec);\n}\nreturn vec3(0.0);\n}\nVoronoiClosest worleyClosest(vec3 P,float jitter,int distance,float exponent){\nfloat K=0.142857142857;\nfloat Ko=0.428571428571;\nfloat K2=0.020408163265306;\nfloat Kz=0.166666666667;\nfloat Kzo=0.416666666667;\nvec3 Pi=mod(floor(P),289.0);\nvec3 Pf=fract(P)-0.5;\nvec3 Pfx=Pf.x+vec3(1.0,0.0,-1.0);\nvec3 Pfy=Pf.y+vec3(1.0,0.0,-1.0);\nvec3 Pfz=Pf.z+vec3(1.0,0.0,-1.0);\nvec3 p=worleyPermute(Pi.x+vec3(-1.0,0.0,1.0));\nvec3 p1=worleyPermute(p+Pi.y-1.0);\nvec3 p2=worleyPermute(p+Pi.y);\nvec3 p3=worleyPermute(p+Pi.y+1.0);\nvec3 p11=worleyPermute(p1+Pi.z-1.0);\nvec3 p12=worleyPermute(p1+Pi.z);\nvec3 p13=worleyPermute(p1+Pi.z+1.0);\nvec3 p21=worleyPermute(p2+Pi.z-1.0);\nvec3 p22=worleyPermute(p2+Pi.z);\nvec3 p23=worleyPermute(p2+Pi.z+1.0);\nvec3 p31=worleyPermute(p3+Pi.z-1.0);\nvec3 p32=worleyPermute(p3+Pi.z);\nvec3 p33=worleyPermute(p3+Pi.z+1.0);\nvec3 ox11=fract(p11*K)-Ko;\nvec3 oy11=mod(floor(p11*K),7.0)*K-Ko;\nvec3 oz11=floor(p11*K2)*Kz-Kzo;\nvec3 ox12=fract(p12*K)-Ko;\nvec3 oy12=mod(floor(p12*K),7.0)*K-Ko;\nvec3 oz12=floor(p12*K2)*Kz-Kzo;\nvec3 ox13=fract(p13*K)-Ko;\nvec3 oy13=mod(floor(p13*K),7.0)*K-Ko;\nvec3 oz13=floor(p13*K2)*Kz-Kzo;\nvec3 ox21=fract(p21*K)-Ko;\nvec3 oy21=mod(floor(p21*K),7.0)*K-Ko;\nvec3 oz21=floor(p21*K2)*Kz-Kzo;\nvec3 ox22=fract(p22*K)-Ko;\nvec3 oy22=mod(floor(p22*K),7.0)*K-Ko;\nvec3 oz22=floor(p22*K2)*Kz-Kzo;\nvec3 ox23=fract(p23*K)-Ko;\nvec3 oy23=mod(floor(p23*K),7.0)*K-Ko;\nvec3 oz23=floor(p23*K2)*Kz-Kzo;\nvec3 ox31=fract(p31*K)-Ko;\nvec3 oy31=mod(floor(p31*K),7.0)*K-Ko;\nvec3 oz31=floor(p31*K2)*Kz-Kzo;\nvec3 ox32=fract(p32*K)-Ko;\nvec3 oy32=mod(floor(p32*K),7.0)*K-Ko;\nvec3 oz32=floor(p32*K2)*Kz-Kzo;\nvec3 ox33=fract(p33*K)-Ko;\nvec3 oy33=mod(floor(p33*K),7.0)*K-Ko;\nvec3 oz33=floor(p33*K2)*Kz-Kzo;\nvec3 dx11=Pfx+jitter*ox11;\nvec3 dy11=Pfy.x+jitter*oy11;\nvec3 dz11=Pfz.x+jitter*oz11;\nvec3 dx12=Pfx+jitter*ox12;\nvec3 dy12=Pfy.x+jitter*oy12;\nvec3 dz12=Pfz.y+jitter*oz12;\nvec3 dx13=Pfx+jitter*ox13;\nvec3 dy13=Pfy.x+jitter*oy13;\nvec3 dz13=Pfz.z+jitter*oz13;\nvec3 dx21=Pfx+jitter*ox21;\nvec3 dy21=Pfy.y+jitter*oy21;\nvec3 dz21=Pfz.x+jitter*oz21;\nvec3 dx22=Pfx+jitter*ox22;\nvec3 dy22=Pfy.y+jitter*oy22;\nvec3 dz22=Pfz.y+jitter*oz22;\nvec3 dx23=Pfx+jitter*ox23;\nvec3 dy23=Pfy.y+jitter*oy23;\nvec3 dz23=Pfz.z+jitter*oz23;\nvec3 dx31=Pfx+jitter*ox31;\nvec3 dy31=Pfy.z+jitter*oy31;\nvec3 dz31=Pfz.x+jitter*oz31;\nvec3 dx32=Pfx+jitter*ox32;\nvec3 dy32=Pfy.z+jitter*oy32;\nvec3 dz32=Pfz.y+jitter*oz32;\nvec3 dx33=Pfx+jitter*ox33;\nvec3 dy33=Pfy.z+jitter*oy33;\nvec3 dz33=Pfz.z+jitter*oz33;\nvec3 d11=worleyDist(dx11,dy11,dz11,distance,exponent);\nvec3 d12=worleyDist(dx12,dy12,dz12,distance,exponent);\nvec3 d13=worleyDist(dx13,dy13,dz13,distance,exponent);\nvec3 d21=worleyDist(dx21,dy21,dz21,distance,exponent);\nvec3 d22=worleyDist(dx22,dy22,dz22,distance,exponent);\nvec3 d23=worleyDist(dx23,dy23,dz23,distance,exponent);\nvec3 d31=worleyDist(dx31,dy31,dz31,distance,exponent);\nvec3 d32=worleyDist(dx32,dy32,dz32,distance,exponent);\nvec3 d33=worleyDist(dx33,dy33,dz33,distance,exponent);\nVoronoiClosest vf=VoronoiClosest(vec4(1e10),vec4(0.0));\nupdateVoronoiClosest(vf,d11,p11);\nupdateVoronoiClosest(vf,d12,p12);\nupdateVoronoiClosest(vf,d13,p13);\nupdateVoronoiClosest(vf,d21,p21);\nupdateVoronoiClosest(vf,d22,p22);\nupdateVoronoiClosest(vf,d23,p23);\nupdateVoronoiClosest(vf,d31,p31);\nupdateVoronoiClosest(vf,d32,p32);\nupdateVoronoiClosest(vf,d33,p33);\nreturn vf;\n}\nvoid node_tex_voronoi(int coloring,int distance,int feature,vec3 vector,float scale,float exponent,out vec4 outColor,out float outFac){\nvector=scale*(vector-0.0001);\nVoronoiClosest vf=worleyClosest(vector,1.0,distance,exponent);\nvec4 vorColorData;\nif (coloring==COLORING_INTENSITY){\nvorColorData=vf.closestDists;\n} else if (coloring==COLORING_CELLS){\nvorColorData=vf.closestInds;\n}\nfloat vorColorFac;\nif (feature==FEATURE_F1){\nvorColorFac=vorColorData.x;\n} else if (feature==FEATURE_F2){\nvorColorFac=vorColorData.y;\n} else if (feature==FEATURE_F3){\nvorColorFac=vorColorData.z;\n} else if (feature==FEATURE_F4){\nvorColorFac=vorColorData.w;\n} else if (feature==FEATURE_F2F1){\nvorColorFac=vorColorData.y-vorColorData.x;\n}\nif (coloring==COLORING_INTENSITY){\noutFac=vorColorFac;\noutColor=vec4(vec3(outFac),1.0);\n} else if (coloring==COLORING_CELLS){\nvorColorFac+=1e-3;\nfloat r=rand(vec2(vorColorFac/289.0));\nfloat g=rand(vec2(vorColorFac/23535.0));\nfloat b=rand(vec2(vorColorFac/4353.0));\noutFac=(r+g+b)/3.0;\noutColor=vec4(r,g,b,1.0);\n}\n}",node_tex_wave_bl_frag="#define TEX_WAVE_TYPE_BANDS 0\n#define TEX_WAVE_TYPE_RINGS 1\n#define TEX_WAVE_PROFILE_SIN 0\n#define TEX_WAVE_PROFILE_SAW 1\n#define TEX_WAVE_PROFILE_TRI 2\n#define TEX_WAVE_BANDS_DIR_X 0\n#define TEX_WAVE_BANDS_DIR_Y 1\n#define TEX_WAVE_BANDS_DIR_Z 2\n#define TEX_WAVE_BANDS_DIR_DIAGONAL 3\n#define TEX_WAVE_RINGS_DIR_X 0\n#define TEX_WAVE_RINGS_DIR_Y 1\n#define TEX_WAVE_RINGS_DIR_Z 2\n#define TEX_WAVE_RINGS_DIR_SPHERICAL 3\nvoid node_tex_wave(int waveType,int waveProfile,int bandsDirection,int ringsDirection,vec3 vector,float scale,float distortion,float detail,float detailScale,float detailRoughness,float phaseOffset,out vec4 outColor,out float outFac){\nvec3 coScaled=vector*scale;\nfloat waveFac;\nvec3 waveVec=coScaled;\nif (waveType==TEX_WAVE_TYPE_BANDS){\nconst float BANDS_AXIS_SCALE=2.0/3.0;\nif (bandsDirection==TEX_WAVE_BANDS_DIR_X){\nwaveVec=waveVec.xxx*BANDS_AXIS_SCALE;\n} else if (bandsDirection==TEX_WAVE_BANDS_DIR_Y){\nwaveVec=waveVec.yyy*BANDS_AXIS_SCALE;\n} else if (bandsDirection==TEX_WAVE_BANDS_DIR_Z){\nwaveVec=waveVec.zzz*BANDS_AXIS_SCALE;\n} else if (bandsDirection==TEX_WAVE_BANDS_DIR_DIAGONAL){\n}\nwaveFac=(waveVec.x+waveVec.y+waveVec.z)*10.0;\n} else {\nif (ringsDirection==TEX_WAVE_RINGS_DIR_X){\nwaveVec.x=0.0;\n} else if (ringsDirection==TEX_WAVE_RINGS_DIR_Y){\nwaveVec.y=0.0;\n} else if (ringsDirection==TEX_WAVE_RINGS_DIR_Z){\nwaveVec.z=0.0;\n} else if (ringsDirection==TEX_WAVE_RINGS_DIR_SPHERICAL){\n}\nwaveFac=length(waveVec)*20.0;\n}\nif (distortion != 0.0){\nwaveFac+=distortion*noiseTurbulence(coScaled*detailScale,detail,0.0,0.0,1.0);\n}\nif (waveProfile==TEX_WAVE_PROFILE_SIN){\nwaveFac=0.5+0.5*sin(waveFac-PI_HALF+phaseOffset);\n} else if (waveProfile==TEX_WAVE_PROFILE_SAW){\nwaveFac=fract((waveFac+phaseOffset+1e-4)/PI2);\n} else if (waveProfile==TEX_WAVE_PROFILE_TRI){\nwaveFac=abs(2.0*fract((waveFac+PI+phaseOffset)/PI2)-1.0);\n}\noutColor=vec4(waveFac,waveFac,waveFac,1.0);\noutFac=waveFac;\n}",node_tex_white_noise_bl_frag="#if __VERSION__==300\nvoid node_tex_white_noise_1d(vec3 vector,float w,out float outValue,out vec4 outColor)\n{\noutValue=hashFloatToFloat(w);\noutColor=vec4(hashFloatToVec3(w),1.0);\n}\nvoid node_tex_white_noise_2d(vec3 vector,float w,out float outValue,out vec4 outColor)\n{\noutValue=hashVec2ToFloat(vector.xy);\noutColor=vec4(hashVec2ToVec3(vector.xy),1.0);\n}\nvoid node_tex_white_noise_3d(vec3 vector,float w,out float outValue,out vec4 outColor)\n{\noutValue=hashVec3ToFloat(vector);\noutColor=vec4(hashVec3ToVec3(vector),1.0);\n}\nvoid node_tex_white_noise_4d(vec3 vector,float w,out float outValue,out vec4 outColor)\n{\noutValue=hashVec4ToFloat(vec4(vector,w));\noutColor=vec4(hashVec4ToVec3(vec4(vector,w)),1.0);\n}\n#else\nvoid node_tex_white_noise_1d(vec3 vector,float w,out float outValue,out vec4 outColor)\n{\noutValue=0.0;\noutColor=vec4(0.0);\n}\nvoid node_tex_white_noise_2d(vec3 vector,float w,out float outValue,out vec4 outColor)\n{\noutValue=0.0;\noutColor=vec4(0.0);\n}\nvoid node_tex_white_noise_3d(vec3 vector,float w,out float outValue,out vec4 outColor)\n{\noutValue=0.0;\noutColor=vec4(0.0);\n}\nvoid node_tex_white_noise_4d(vec3 vector,float w,out float outValue,out vec4 outColor)\n{\noutValue=0.0;\noutColor=vec4(0.0);\n}\n#endif",node_uvmap_bl_frag="void node_uvmap(vec2 uv,out vec3 outUV){\n#if WORLD_NODES==1\noutUV=vec3(0.0);\n#else\nuv.y=1.0-uv.y;\noutUV=vec3(uv,0.0);\n#endif\n}",node_valtorgb_bl_frag="void node_valtorgb(sampler2D colormap,float fac,out vec4 colOut,out float alphaOut)\n{\ncolOut=texture2D(colormap,vec2(fac,0.0));\nalphaOut=colOut.a;\n}",node_value_bl_frag="uniform float nodeValue[NODE_VALUE_NUM];\nvoid node_value(float value,out float outValue)\n{\noutValue=value;\n}",node_vect_math_bl_frag="void node_vect_math_add(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=v1+v2;\n}\nvoid node_vect_math_subtract(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=v1-v2;\n}\nvoid node_vect_math_multiply(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=v1*v2;\n}\nvoid node_vect_math_divide(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec.x=v2.x==0.0?0.0:v1.x/v2.x;\noutVec.y=v2.y==0.0?0.0:v1.y/v2.y;\noutVec.z=v2.z==0.0?0.0:v1.z/v2.z;\n}\nvoid node_vect_math_cross_product(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=cross(v1,v2);\n}\nvoid node_vect_math_project(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\nfloat d=dot(v2,v2);\noutVec=(d != 0.0)?(dot(v1,v2)/d)*v2:vec3(0.0);\n}\nvoid node_vect_math_reflect(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\nif (v2 != vec3(0.0)){\nv2=normalize(v2);\n}\noutVec=reflect(v1,v2);\n}\nvoid node_vect_math_dot_product(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVal=dot(v1,v2);\n}\nvoid node_vect_math_distance(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVal=distance(v1,v2);\n}\nvoid node_vect_math_length(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVal=length(v1);\n}\nvoid node_vect_math_scale(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=v1*val;\n}\nvoid node_vect_math_normalize(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\nif (v1 != vec3(0.0)){\nv1=normalize(v1);\n}\noutVec=v1;\n}\nvoid node_vect_math_snap(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec.x=v2.x==0.0?0.0:floor(v1.x/v2.x)*v2.x;\noutVec.y=v2.y==0.0?0.0:floor(v1.y/v2.y)*v2.y;\noutVec.z=v2.z==0.0?0.0:floor(v1.z/v2.z)*v2.z;\n}\nvoid node_vect_math_floor(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=floor(v1);\n}\nvoid node_vect_math_ceil(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=ceil(v1);\n}\nvoid node_vect_math_modulo(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\nvec3 signProduct=sign(v1)*sign(v2);\nv1+=1e-5*signProduct;\noutVec.x=signProduct.x>0.0?mod(v1.x,abs(v2.x)):0.0;\noutVec.y=signProduct.y>0.0?mod(v1.y,abs(v2.y)):0.0;\noutVec.z=signProduct.z>0.0?mod(v1.z,abs(v2.z)):0.0;\n}\nvoid node_vect_math_fraction(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=fract(v1);\n}\nvoid node_vect_math_absolute(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=abs(v1);\n}\nvoid node_vect_math_power(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=vec3(powCompat(v1.x,v2.x),powCompat(v1.y,v2.y),powCompat(v1.z,v2.z));\n}\nvoid node_vect_math_sign(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=sign(v1);\n}\nvoid node_vect_math_minimum(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=min(v1,v2);\n}\nvoid node_vect_math_maximum(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=max(v1,v2);\n}\nvoid node_vect_math_cosine(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=cos(v1);\n}\nvoid node_vect_math_sine(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=sin(v1);\n}\nvoid node_vect_math_tangent(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=tan(v1);\n}\nvoid node_vect_math_wrap(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\nv1+=1e-5;\noutVec.x=v2.x==v3.x?v2.x:mod(v1.x-v3.x,v2.x-v3.x)+v3.x;\noutVec.y=v2.y==v3.y?v2.y:mod(v1.y-v3.y,v2.y-v3.y)+v3.y;\noutVec.z=v2.z==v3.z?v2.z:mod(v1.z-v3.z,v2.z-v3.z)+v3.z;\n}\nvoid node_vect_math_faceforward(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=dot(v2,v3)<0.0?v1:-v1;\n}\nvoid node_vect_math_multiply_add(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\noutVec=v1*v2+v3;\n}\nvoid node_vect_math_refract(vec3 v1,vec3 v2,vec3 v3,float val,out vec3 outVec,out float outVal){\nif (v2 != vec3(0.0)){\nv2=normalize(v2);\n}\noutVec=refract(v1,v2,val);\n}",node_vect_transform_bl_frag="#define VEC_TRANS_NONE 0\n#define VEC_TRANS_W_O 1\n#define VEC_TRANS_W_C 2\n#define VEC_TRANS_O_W 3\n#define VEC_TRANS_O_C 4\n#define VEC_TRANS_C_W 5\n#define VEC_TRANS_C_O 6\n#define VEC_TRANS_W_O_DIR 7\n#define VEC_TRANS_W_C_DIR 8\n#define VEC_TRANS_O_W_DIR 9\n#define VEC_TRANS_O_C_DIR 10\n#define VEC_TRANS_C_W_DIR 11\n#define VEC_TRANS_C_O_DIR 12\nvoid node_vect_transform(const int vecTransType,const bool invCamZ,vec3 vIn,out vec3 vOut)\n{\nif (vecTransType==VEC_TRANS_NONE)\nvOut=vIn;\nelse {\nvec4 vec;\nif (vecTransType<VEC_TRANS_W_O_DIR)\nvec=vec4(vIn.xyz,1.0);\nelse\nvec=vec4(vIn.xyz,0.0);\nif (vecTransType==VEC_TRANS_W_O||vecTransType==VEC_TRANS_W_O_DIR){\nvec=vec4(vec.x,vec.z,-vec.y,vec.w);\nvec=invModelMatrix*vec;\nvec=vec4(vec.x,-vec.z,vec.y,vec.w);\n} else if (vecTransType==VEC_TRANS_W_C||vecTransType==VEC_TRANS_W_C_DIR){\nvec=vec4(vec.x,vec.z,-vec.y,vec.w);\nvec=viewMatrix*vec;\nif (invCamZ)\nvec[2]=-vec[2];\n} else if (vecTransType==VEC_TRANS_O_W||vecTransType==VEC_TRANS_O_W_DIR){\nvec=vec4(vec.x,vec.z,-vec.y,vec.w);\nvec=modelMatrix*vec;\nvec=vec4(vec.x,-vec.z,vec.y,vec.w);\n} else if (vecTransType==VEC_TRANS_O_C||vecTransType==VEC_TRANS_O_C_DIR){\nvec=vec4(vec.x,vec.z,-vec.y,vec.w);\nvec=modelViewMatrix*vec;\nif (invCamZ)\nvec[2]=-vec[2];\n} else if (vecTransType==VEC_TRANS_C_W||vecTransType==VEC_TRANS_C_W_DIR){\nif (invCamZ)\nvec[2]=-vec[2];\nvec=invViewMatrix*vec;\nvec=vec4(vec.x,-vec.z,vec.y,vec.w);\n} else if (vecTransType==VEC_TRANS_C_O||vecTransType==VEC_TRANS_C_O_DIR){\nif (invCamZ)\nvec[2]=-vec[2];\nvec=invModelMatrix*invViewMatrix*vec;\nvec=vec4(vec.x,-vec.z,vec.y,vec.w);\n}\nvOut=vec.xyz;\n}\n}",node_vector_displacement_bl_frag="void node_vector_displacement(vec4 vector,float midLevel,float scale,out vec3 displacement){\ndisplacement=vec3(0.0);\n}",node_vector_rotate_bl_frag="void node_vector_rotate_axis_angle(float invert,vec3 vector,vec3 center,vec3 axis,float angle,vec3 rotation,out vec3 outVector){\nif (length(axis)>0.0){\nvector-=center;\noutVector=vec3RotateAxisAngle(vector,axis,invert*angle);\noutVector+=center;\n} else {\noutVector=vector;\n}\n}\nvoid node_vector_rotate_euler_xyz(float invert,vec3 vector,vec3 center,vec3 axis,float angle,vec3 rotation,out vec3 outVector){\nvec4 axisAngle=eulerToAxisAngle(rotation);\nvector-=center;\noutVector=vec3RotateAxisAngle(vector,axisAngle.xyz,invert*axisAngle.w);\noutVector+=center;\n}\nvoid node_vector_rotate_x_axis(float invert,vec3 vector,vec3 center,vec3 axis,float angle,vec3 rotation,out vec3 outVector){\nvector-=center;\noutVector=vec3RotateXAngle(vector,invert*angle);\noutVector+=center;\n}\nvoid node_vector_rotate_y_axis(float invert,vec3 vector,vec3 center,vec3 axis,float angle,vec3 rotation,out vec3 outVector){\nvector-=center;\noutVector=vec3RotateYAngle(vector,invert*angle);\noutVector+=center;\n}\nvoid node_vector_rotate_z_axis(float invert,vec3 vector,vec3 center,vec3 axis,float angle,vec3 rotation,out vec3 outVector){\nvector-=center;\noutVector=vec3RotateZAngle(vector,invert*angle);\noutVector+=center;\n}",node_vertex_color_bl_frag="void node_vertex_color(vec4 color,out vec4 outColor,out float outAlpha){\noutColor=color;\noutAlpha=color.a;\n}",node_volume_absorption_bl_frag="void node_volume_absorption(vec4 color,float density,out vec4 outColor)\n{\noutColor=color;\n}",node_volume_coefficients_bl_frag="void node_volume_coefficients(vec3 absorptionCoefficients,vec3 scatterCoefficients,float anisotropy,float IOR,float backscatter,float alpha,float Diameter,vec3 emissionCoefficients,out vec4 outColor){\noutColor=vec4(0.0,0.0,0.0,1.0);\n}",node_volume_info_bl_frag="void node_volume_info(out vec4 color,out float density,out float flame,out float temperature){\ncolor=vec4(vec3(0.0),1.0);\ndensity=0.0;\nflame=0.0;\ntemperature=0.0;\n}",node_volume_scatter_bl_frag="void node_volume_scatter(vec4 color,float density,float anisotropy,float ior,float backscatter,float alpha,float diameter,out vec4 outColor)\n{\noutColor=vec4(color);\n}\nvoid node_volume_scatter(vec4 color,float density,float anisotropy,out vec4 outColor)\n{\noutColor=vec4(color);\n}",node_wavelength_bl_frag="void node_wavelength(float wavelength,out vec4 outColor)\n{\noutColor=vec4(0.0,0.0,0.0,1.0);\n#if __VERSION__==300\nvec3 xyz=vec3(0.0);\nfloat ii=(wavelength-380.0)/5.0;\nint i=int(ii);\nif (i<0||i>=80){\nreturn;\n}\nii-=float(i);\nvec3 c1=cieColorMatch[i];\nvec3 c2=cieColorMatch[i+1];\nxyz=mix(c1,c2,ii);\noutColor=vec4(xyz_to_sRGB(xyz),1.0);\n#endif\n}",node_wireframe_bl_frag="void node_wireframe(float size,out float outFac)\n{\noutFac=0.0;\n}",node_bitmap_none_mx_frag="void node_bitmap_none(out vec4 color)\n{\ncolor=vec4(1.0);\n}",node_bitmap_env_mx_frag="void node_bitmap_env(sampler2D envMap,int reflectMode,float IOR,const int encoding,const bool alphaAsMono,const bool alphaAsRGB,float uOffset,float vOffset,float uTiling,float vTiling,float wAngle,vec3 normal,out vec4 color,out float value)\n{\nvec3 cameraToVertex=normalize(vWorldPosition-cameraPosition);\nvec3 worldNormal=inverseTransformDirection(normal,viewMatrix);\nvec3 reflectVec;\n#if WORLD_NODES\nreflectVec=normalize(cameraToVertex);\n#else\nif (reflectMode==MAX_ENV_COORDS_REFLECT)\nreflectVec=reflect(cameraToVertex,worldNormal);\nelse {\nfloat refrRatio=1.0/IOR;\nreflectVec=refract(cameraToVertex,worldNormal,refrRatio);\n}\n#endif\nmat3 uvTransform=calcUvTransform(uOffset,vOffset,uTiling,vTiling,wAngle);\ncolor=sampleEquirectangular(envMap,reflectVec,uvTransform,encoding);\nif (alphaAsMono)\nvalue=color.a;\nelse\nvalue=average(color.rgb);\nif (alphaAsRGB)\ncolor=vec4(color.a);\n}",node_bitmap_mx_frag="void node_bitmap(sampler2D map,const vec2 uvIn,const int mapping,const int axis,const ivec2 clampToEdgeNoExtend,const int encoding,const bool alphaAsMono,const bool alphaAsRGB,float uOffset,float vOffset,float uTiling,float vTiling,float wAngle,out vec4 color,out float value)\n{\nvec3 coordsIn;\nif (mapping==MAPPING_EXPLICIT_MAP_CHANNEL){\ncoordsIn=vec3(uvIn.x,1.0-uvIn.y,0.0);\n} else if (mapping==MAPPING_VERTEX_COLOR_CHANNEL){\ncoordsIn=vec3(0.0);\n} else if (mapping==MAPPING_PLANAR_OBJECT_XYZ){\ncoordsIn=swizzleUpZ((invModelMatrix*invViewMatrix*vec4(-vViewPosition,1.0)).xyz);\n} else {\ncoordsIn=swizzleUpZ((invViewMatrix*vec4(-vViewPosition,1.0)).xyz);\n}\nif (axis==AXIS_XY)\ncoordsIn=vec3(coordsIn.x,coordsIn.y,1.0);\nelse if (axis==AXIS_YZ)\ncoordsIn=vec3(coordsIn.y,coordsIn.z,1.0);\nelse if (axis==AXIS_ZX)\ncoordsIn=vec3(coordsIn.z,coordsIn.x,1.0);\nvec3 coordsOut=calcUvTransform(uOffset,vOffset,uTiling,vTiling,wAngle)*coordsIn;\nvec2 uv=vec2(coordsOut.x,1.0-coordsOut.y);\nif ((clampToEdgeNoExtend[0]==1&&(uvIn.x<0.0||uvIn.x>1.0))||\n(clampToEdgeNoExtend[1]==1&&(uvIn.y<0.0||uvIn.y>1.0))){\ncolor=vec4(0.0,0.0,0.0,1.0);\n} else {\ncolor=texture2D(map,uv);\ncolor=nodeTexelToLinear(color,encoding);\n}\nif (alphaAsMono)\nvalue=color.a;\nelse\nvalue=average(color.rgb);\nif (alphaAsRGB)\ncolor=vec4(color.a);\n}",node_bump_mx_frag="void node_bump(sampler2D bumpMap,const vec3 eyePos,const vec3 normal,const vec2 uvIn,float uOffset,float vOffset,float uTiling,float vTiling,float wAngle,out vec3 normalOut)\n{\nvec3 coordsIn;\ncoordsIn=vec3(uvIn.x,1.0-uvIn.y,1.0);\nvec3 coordsOut=calcUvTransform(uOffset,vOffset,uTiling,vTiling,wAngle)*coordsIn;\nvec2 uv=vec2(coordsOut.x,1.0-coordsOut.y);\nvec2 dSTdx=dFdx(uv);\nvec2 dSTdy=dFdy(uv);\nif (any(equal(dSTdx,vec2(0.0)))||any(equal(dSTdy,vec2(0.0)))){\nnormalOut=normal;\n} else {\nconst float bumpScale=1.0;\nvec3 vSigmaX=vec3(dFdx(eyePos.x),dFdx(eyePos.y),dFdx(eyePos.z));\nvec3 vSigmaY=vec3(dFdy(eyePos.x),dFdy(eyePos.y),dFdy(eyePos.z));\nvec3 vN=normal;\nvec3 R1=cross(vSigmaY,vN);\nvec3 R2=cross(vN,vSigmaX);\nfloat fDet=dot(vSigmaX,R1);\nfloat Hll=bumpScale*texture2D(bumpMap,uv).x;\nfloat dBx=bumpScale*texture2D(bumpMap,uv+dSTdx).x-Hll;\nfloat dBy=bumpScale*texture2D(bumpMap,uv+dSTdy).x-Hll;\nvec2 dHdxy=vec2(dBx,dBy);\nvec3 vGrad=sign(fDet)*(dHdxy.x*R1+dHdxy.y*R2);\nnormalOut=normalize(abs(fDet)*normal-vGrad);\n}\n}",node_blend_mx_frag="void node_blend(const bool useCurve,const float curveLower,const float curveUpper,const vec4 color1,const vec4 color2,float mask,out vec4 color)\n{\nif (useCurve)\nmask=smoothstep(curveLower,curveUpper,mask);\nelse\nmask=clamp(mask,0.0,1.0);\ncolor=mix(color1,color2,mask);\n}",node_color_correction_mx_frag="#define REWIRE_RED 0\n#define REWIRE_GREEN 1\n#define REWIRE_BLUE 2\n#define REWIRE_ALPHA 3\n#define REWIRE_RED_INV 4\n#define REWIRE_GREEN_INV 5\n#define REWIRE_BLUE_INV 6\n#define REWIRE_ALPHA_INV 7\n#define REWIRE_MONOCHROME 8\n#define REWIRE_ONE 9\n#define REWIRE_ZERO 10\nfloat rewireChannel(int type,vec4 color)\n{\nif (type==REWIRE_RED)\nreturn color.r;\nelse if (type==REWIRE_GREEN)\nreturn color.g;\nelse if (type==REWIRE_BLUE)\nreturn color.b;\nelse if (type==REWIRE_ALPHA)\nreturn color.a;\nelse if (type==REWIRE_RED_INV)\nreturn 1.0-color.r;\nelse if (type==REWIRE_GREEN_INV)\nreturn 1.0-color.g;\nelse if (type==REWIRE_BLUE_INV)\nreturn 1.0-color.b;\nelse if (type==REWIRE_ALPHA_INV)\nreturn 1.0-color.a;\nelse if (type==REWIRE_MONOCHROME)\nreturn average(color.rgb);\nelse if (type==REWIRE_ONE)\nreturn 1.0;\nelse\nreturn 0.0;\n}\nvec3 gainPivotGammaLift(vec3 color,float gain,float pivot,float gamma,float lift,int exposureMode,float printerLights)\n{\ngain=gain/100.0;\nif (exposureMode==0){\ncolor=color*gain/pivot;\n} else if (exposureMode==1){\ncolor=color*pow(2.0,gain)/pivot;\n} else {\ncolor=color*pow(printerLights,gain)/pivot;\n}\nvec3 tmp=pivot*pow(color,vec3(1.0/gamma));\nreturn step(0.00001,color)*tmp+lift;\n}\nfloat gainPivotGammaLift(float value,float gain,float pivot,float gamma,float lift,int exposureMode,float printerLights)\n{\ngain=gain/100.0;\nif (exposureMode==0){\nvalue=value*gain/pivot;\n} else if (exposureMode==1){\nvalue=value*pow(2.0,gain)/pivot;\n} else {\nvalue=value*pow(printerLights,gain)/pivot;\n}\nfloat tmp=pivot*pow(value,1.0/gamma);\nreturn step(0.00001,value)*tmp+lift;\n}\nvoid node_color_correction(const ivec4 rewire,const vec4 color,const float hueShift,const float saturation,const vec4 tint,const float tintStrength,const float brightness,const float contrast,out vec4 outColor)\n{\nif (all(equal(rewire,ivec4(REWIRE_RED,REWIRE_GREEN,REWIRE_BLUE,REWIRE_ALPHA)))){\noutColor=color;\n} else {\noutColor.r=rewireChannel(rewire.x,color);\noutColor.g=rewireChannel(rewire.y,color);\noutColor.b=rewireChannel(rewire.z,color);\noutColor.a=rewireChannel(rewire.w,color);\n}\nvec4 hsv;\nrgbToHSV(outColor,hsv);\nhsv[0]+=hueShift/360.0;\nif (hsv[0]>1.0)\nhsv[0]-=1.0;\nelse if (hsv[0]<0.0)\nhsv[0]+=1.0;\nhsv[1]*=(saturation/100.0+1.0);\nhsv[1]=saturate(hsv[1]);\nif (tintStrength>0.0){\nvec4 hsvTint;\nrgbToHSV(tint,hsvTint);\nhsv[0]=hsv[0]+(hsvTint[0]-hsv[0])*tintStrength/100.0;\n}\nhsvToRGB(hsv,outColor);\noutColor=(outColor-0.5)*(contrast/100.0+1.0)+0.5+brightness/100.0;\noutColor=max(outColor,0.0);\n}\nvoid node_color_correction(const ivec4 rewire,const mat4 params,bool enableR,bool enableG,bool enableB,int exposureMode,float printerLights,const vec4 color,const float hueShift,const float saturation,const vec4 tint,const float tintStrength,out vec4 outColor)\n{\nif (all(equal(rewire,ivec4(REWIRE_RED,REWIRE_GREEN,REWIRE_BLUE,REWIRE_ALPHA)))){\noutColor=color;\n} else {\noutColor.r=rewireChannel(rewire.x,color);\noutColor.g=rewireChannel(rewire.y,color);\noutColor.b=rewireChannel(rewire.z,color);\noutColor.a=rewireChannel(rewire.w,color);\n}\nvec4 hsv;\nrgbToHSV(outColor,hsv);\nhsv[0]+=hueShift/360.0;\nif (hsv[0]>1.0)\nhsv[0]-=1.0;\nelse if (hsv[0]<0.0)\nhsv[0]+=1.0;\nhsv[1]*=(saturation/100.0+1.0);\nhsv[1]=saturate(hsv[1]);\nif (tintStrength>0.0){\nvec4 hsvTint;\nrgbToHSV(tint,hsvTint);\nhsv[0]=hsv[0]+(hsvTint[0]-hsv[0])*tintStrength/100.0;\n}\nhsvToRGB(hsv,outColor);\noutColor.rgb=gainPivotGammaLift(outColor.rgb,params[0][0],params[0][1],params[0][2],params[0][3],exposureMode,printerLights);\nif (enableR)\noutColor.r=gainPivotGammaLift(outColor.r,params[1][0],params[1][1],params[1][2],params[1][3],exposureMode,printerLights);\nif (enableG)\noutColor.g=gainPivotGammaLift(outColor.g,params[2][0],params[2][1],params[2][2],params[2][3],exposureMode,printerLights);\nif (enableB)\noutColor.b=gainPivotGammaLift(outColor.b,params[3][0],params[3][1],params[3][2],params[3][3],exposureMode,printerLights);\noutColor=max(outColor,0.0);\n}",node_color_map_mx_frag="void node_color_map(const bool reverseGamma,const vec4 color,const float gamma,const float gain,out vec4 outColor)\n{\nfloat p=reverseGamma?gamma:1.0/gamma;\nfloat g=reverseGamma?(gain>EPSILON?1.0/gain:1.0):gain;\noutColor=vec4(g*pow(abs(color.rgb),vec3(p)),color.a);\n}",node_composite_layer_mx_frag="#define COMP_BLEND_NORMAL 0\n#define COMP_BLEND_AVERAGE 1\n#define COMP_BLEND_ADD 2\n#define COMP_BLEND_SUBTRACT 3\n#define COMP_BLEND_DARKEN 4\n#define COMP_BLEND_MULTIPLY 5\n#define COMP_BLEND_COLORBURN 6\n#define COMP_BLEND_LINEARBURN 7\n#define COMP_BLEND_LIGHTEN 8\n#define COMP_BLEND_SCREEN 9\n#define COMP_BLEND_COLORDODGE 10\n#define COMP_BLEND_LINEARDODGE 11\n#define COMP_BLEND_SPOT 12\n#define COMP_BLEND_SPOTBLEND 13\n#define COMP_BLEND_OVERLAY 14\n#define COMP_BLEND_SOFTLIGHT 15\n#define COMP_BLEND_HARDLIGHT 16\n#define COMP_BLEND_PINLIGHT 17\n#define COMP_BLEND_HARDMIX 18\n#define COMP_BLEND_DIFFERENCE 19\n#define COMP_BLEND_EXCLUSION 20\n#define COMP_BLEND_HUE 21\n#define COMP_BLEND_SATURATION 22\n#define COMP_BLEND_COLOR 23\n#define COMP_BLEND_VALUE 24\nvec4 calcBlending(const vec4 colorBG,const vec4 colorFG,const int blendMode){\nif (blendMode==COMP_BLEND_NORMAL)\nreturn colorFG;\nelse if (blendMode==COMP_BLEND_AVERAGE)\nreturn (colorFG+colorBG)/2.0;\nelse if (blendMode==COMP_BLEND_ADD)\nreturn colorBG+colorFG;\nelse if (blendMode==COMP_BLEND_SUBTRACT)\nreturn colorBG-colorFG;\nelse if (blendMode==COMP_BLEND_DARKEN)\nreturn min(colorFG,colorBG);\nelse if (blendMode==COMP_BLEND_MULTIPLY)\nreturn colorBG*colorFG;\nelse if (blendMode==COMP_BLEND_COLORBURN){\nif (colorFG.r==0.0&&colorFG.g==0.0&&colorFG.b==0.0)\nreturn vec4(0.0,0.0,0.0,1.0);\nelse\nreturn max(1.0-(1.0-colorBG)/colorFG,0.0);\n} else if (blendMode==COMP_BLEND_LINEARBURN)\nreturn max(colorFG+colorBG-1.0,0.0);\nelse if (blendMode==COMP_BLEND_LIGHTEN)\nreturn max(colorFG,colorBG);\nelse if (blendMode==COMP_BLEND_SCREEN)\nreturn colorFG+colorBG-colorFG*colorBG;\nelse if (blendMode==COMP_BLEND_COLORDODGE){\nif (colorFG.r==1.0&&colorFG.g==1.0&&colorFG.b==1.0)\nreturn vec4(1.0);\nelse\nreturn min(colorBG/(1.0-colorFG),1.0);\n} else if (blendMode==COMP_BLEND_LINEARDODGE)\nreturn min(colorFG+colorBG,1.0);\nelse if (blendMode==COMP_BLEND_SPOT)\nreturn min(2.0*colorFG*colorBG,1.0);\nelse if (blendMode==COMP_BLEND_SPOTBLEND)\nreturn min(colorFG*colorBG+colorBG,1.0);\nelse if (blendMode==COMP_BLEND_OVERLAY){\nif (colorBG.r<=0.5&&colorBG.g<=0.5&&colorBG.b<=0.5)\nreturn saturate(2.0*colorFG*colorBG);\nelse\nreturn saturate(1.0-2.0*(1.0-colorFG)*(1.0-colorBG));\n} else if (blendMode==COMP_BLEND_SOFTLIGHT){\nif (colorFG.r<=0.5&&colorFG.g<=0.5&&colorFG.b<=0.5)\nreturn saturate(colorBG*(colorBG+2.0*colorFG*(1.0-colorBG)));\nelse\nreturn saturate(colorBG+(2.0*colorFG-1.0)*(sqrt(colorBG)-colorBG));\n} else if (blendMode==COMP_BLEND_HARDLIGHT){\nif (colorFG.r<=0.5&&colorFG.g<=0.5&&colorFG.b<=0.5)\nreturn saturate(2.0*colorFG*colorBG);\nelse\nreturn saturate(1.0-2.0*(1.0-colorFG)*(1.0-colorBG));\n} else if (blendMode==COMP_BLEND_PINLIGHT){\nif (((colorFG.r>0.5&&colorFG.g>0.5&&colorFG.b>0.5)&&all(greaterThan(colorFG,colorBG)))||\n((colorFG.r<=0.5&&colorFG.g<=0.5&&colorFG.b<=0.5)&&all(lessThan(colorFG,colorBG))))\nreturn colorFG;\nelse\nreturn colorBG;\n} else if (blendMode==COMP_BLEND_HARDMIX){\nif (colorFG.r+colorBG.r<=1.0&&colorFG.g+colorBG.g<=1.0&&colorFG.b+colorBG.b<=1.0)\nreturn vec4(0.0,0.0,0.0,1.0);\nelse\nreturn vec4(1.0);\n} else if (blendMode==COMP_BLEND_DIFFERENCE)\nreturn abs(colorFG-colorBG);\nelse if (blendMode==COMP_BLEND_EXCLUSION)\nreturn colorFG+colorBG-2.0*colorFG*colorBG;\n}\nvec4 calcBlendingHSV(const vec4 colorBG,const vec4 colorFG,const int blendMode)\n{\nvec4 hsvBG,hsvFG;\nvec4 outColor;\nif (blendMode==COMP_BLEND_HUE){\nrgbToHSV(colorBG,hsvBG);\nrgbToHSV(colorFG,hsvFG);\nhsvToRGB(vec4(hsvFG[0],hsvBG[1],hsvBG[2],1.0),outColor);\n} else if (blendMode==COMP_BLEND_SATURATION){\nrgbToHSV(colorBG,hsvBG);\nrgbToHSV(colorFG,hsvFG);\nhsvToRGB(vec4(hsvBG[0],hsvFG[1],hsvBG[2],1.0),outColor);\n} else if (blendMode==COMP_BLEND_COLOR){\nrgbToHSV(colorBG,hsvBG);\nrgbToHSV(colorFG,hsvFG);\nhsvToRGB(vec4(hsvFG[0],hsvFG[1],hsvBG[2],1.0),outColor);\n} else if (blendMode==COMP_BLEND_VALUE){\nrgbToHSV(colorBG,hsvBG);\nrgbToHSV(colorFG,hsvFG);\nhsvToRGB(vec4(hsvBG[0],hsvBG[1],hsvFG[2],1.0),outColor);\n}\nreturn outColor;\n}\nvoid node_composite_layer(const int blendMode,const float opacity,const vec4 colorBG,const vec4 colorFG,const vec4 mask,out vec4 outColor)\n{\nfloat fac=saturate(opacity*average(mask.rgb));\nif (blendMode<COMP_BLEND_HUE)\noutColor=calcBlending(colorBG,colorFG,blendMode);\nelse\noutColor=calcBlendingHSV(colorBG,colorFG,blendMode);\noutColor=mix(colorBG,outColor,fac);\n}",node_falloff_mx_frag="#define FALLOFF_TYPE_TOWARDS_AWAY 0\n#define FALLOFF_TYPE_PERP_PARALL 1\n#define FALLOFF_TYPE_FRESHNEL 2\n#define FALLOFF_TYPE_SHADOW_LIGHT 3\n#define FALLOFF_TYPE_DIST_BLEND 4\nvoid node_falloff(const vec3 viewPos,const float IOR,const int falloffType,const vec4 color1,const vec4 color2,const vec3 normal,out vec4 color)\n{\nvec3 dir=normalize(viewPos);\nfloat fac;\nif (falloffType==FALLOFF_TYPE_TOWARDS_AWAY){\nfac=1.0-(0.5*(abs(dot(dir,normal))+1.0));\n} else if (falloffType==FALLOFF_TYPE_PERP_PARALL){\nfac=1.0-abs(dot(dir,normal));\n} else if (falloffType==FALLOFF_TYPE_FRESHNEL){\nfloat eta=max(IOR,0.00001);\nfac=fresnelReflection(dir,normal,(gl_FrontFacing)?eta:1.0/eta);\n} else {\nfac=0.0;\n}\ncolor=mix(color1,color2,fac);\n}\nvoid node_falloff(const vec3 viewPos,bool extrapolateOn,float nearDistance,float farDistance,const vec4 color1,const vec4 color2,const vec3 normal,out vec4 color)\n{\nfloat dist=length(viewPos);\nfloat fac;\nif (!extrapolateOn&&dist<=nearDistance){\nfac=1.0;\n} else if (!extrapolateOn&&dist>farDistance){\nfac=0.0;\n} else {\nfac=((farDistance-nearDistance)!= 0.0)?((farDistance-dist)/(farDistance-nearDistance)):10000.0;\n}\ncolor=mix(color1,color2,fac);\n}",node_gradient_mx_frag="#define GRAD_TYPE_LINEAR 0\n#define GRAD_TYPE_RADIAL 1\nvoid node_gradient(float color2Pos,int gradientType,vec2 uvIn,vec3 viewPos,int mapping,int axis,ivec2 clampToEdgeNoExtend,vec3 color1,vec3 color2,vec3 color3,float uOffset,float vOffset,float uTiling,float vTiling,float wAngle,out vec4 outCol)\n{\nvec3 coordsIn;\nif (mapping==MAPPING_EXPLICIT_MAP_CHANNEL){\ncoordsIn=vec3(uvIn.x,1.0-uvIn.y,0.0);\n} else if (mapping==MAPPING_VERTEX_COLOR_CHANNEL){\ncoordsIn=vec3(0.0);\n} else if (mapping==MAPPING_PLANAR_OBJECT_XYZ){\ncoordsIn=swizzleUpZ((invModelMatrix*invViewMatrix*vec4(-viewPos,1.0)).xyz);\n} else {\ncoordsIn=swizzleUpZ((invViewMatrix*vec4(-vViewPosition,1.0)).xyz);\n}\nif (axis==AXIS_XY)\ncoordsIn=vec3(coordsIn.x,coordsIn.y,1.0);\nelse if (axis==AXIS_YZ)\ncoordsIn=vec3(coordsIn.y,coordsIn.z,1.0);\nelse if (axis==AXIS_ZX)\ncoordsIn=vec3(coordsIn.z,coordsIn.x,1.0);\nvec3 coordsOut=calcUvTransform(uOffset,vOffset,uTiling,vTiling,wAngle)*coordsIn;\nfloat coord=uvIn.x;\nuvIn=coordsOut.xy;\nif ((clampToEdgeNoExtend[0]==1&&(uvIn.x<0.0||uvIn.x>1.0))||\n(clampToEdgeNoExtend[1]==1&&(uvIn.y<0.0||uvIn.y>1.0))){\noutCol=vec4(0.0,0.0,0.0,1.0);\nreturn;\n}\nuvIn=fract(uvIn);\nif (gradientType==GRAD_TYPE_LINEAR){\ncoord=uvIn.y;\n} else {\ncoord=length(uvIn-vec2(0.5))*2.0;\nif (coord>1.0)\ncoord=1.0;\n}\nif (coord<color2Pos){\ncoord=coord/color2Pos;\noutCol=vec4(color3*(1.0-coord)+color2*coord,1.0);\n} else if (coord>color2Pos){\ncoord=(coord-color2Pos)/(1.0-color2Pos);\noutCol=vec4(color2*(1.0-coord)+color1*coord,1.0);\n} else {\noutCol=vec4(color2,1.0);\n}\n}",node_gradient_ramp_mx_frag="#define GRAD_TYPE_4_CORNER 0\n#define GRAD_TYPE_BOX 1\n#define GRAD_TYPE_DIAGONAL 2\n#define GRAD_TYPE_LIGHTING 3\n#define GRAD_TYPE_LINEAR 4\n#define GRAD_TYPE_MAPPED 5\n#define GRAD_TYPE_NORMAL 6\n#define GRAD_TYPE_PONG 7\n#define GRAD_TYPE_RADIAL 8\n#define GRAD_TYPE_SPIRAL 9\n#define GRAD_TYPE_SWEEP 10\n#define GRAD_TYPE_TARTAN 11\nvoid node_gradient_ramp(sampler2D gradientData,int gradientType,vec2 uvIn,vec3 geometryNormal,vec3 viewPos,int mapping,int axis,ivec2 clampToEdgeNoExtend,vec4 sourceMap,float uOffset,float vOffset,float uTiling,float vTiling,float wAngle,out vec4 outCol)\n{\nvec3 coordsIn;\nif (mapping==MAPPING_EXPLICIT_MAP_CHANNEL){\ncoordsIn=vec3(uvIn.x,1.0-uvIn.y,0.0);\n} else if (mapping==MAPPING_VERTEX_COLOR_CHANNEL){\ncoordsIn=vec3(0.0);\n} else if (mapping==MAPPING_PLANAR_OBJECT_XYZ){\ncoordsIn=swizzleUpZ((invModelMatrix*invViewMatrix*vec4(-viewPos,1.0)).xyz);\n} else {\ncoordsIn=swizzleUpZ((invViewMatrix*vec4(-vViewPosition,1.0)).xyz);\n}\nif (axis==AXIS_XY)\ncoordsIn=vec3(coordsIn.x,coordsIn.y,1.0);\nelse if (axis==AXIS_YZ)\ncoordsIn=vec3(coordsIn.y,coordsIn.z,1.0);\nelse if (axis==AXIS_ZX)\ncoordsIn=vec3(coordsIn.z,coordsIn.x,1.0);\nvec3 coordsOut=calcUvTransform(uOffset,vOffset,uTiling,vTiling,wAngle)*coordsIn;\nfloat coord=uvIn.x;\nuvIn=coordsOut.xy;\nif ((clampToEdgeNoExtend[0]==1&&(uvIn.x<0.0||uvIn.x>1.0))||\n(clampToEdgeNoExtend[1]==1&&(uvIn.y<0.0||uvIn.y>1.0))){\noutCol=vec4(0.0,0.0,0.0,1.0);\nreturn;\n}\nuvIn=fract(uvIn);\nif (gradientType==GRAD_TYPE_4_CORNER){\ncoord=pow(uvIn.x,2.0);\n} else if (gradientType==GRAD_TYPE_BOX){\nvec2 boxUv=abs(uvIn-vec2(0.5))*2.0;\ncoord=max(boxUv.x,boxUv.y);\n} else if (gradientType==GRAD_TYPE_DIAGONAL){\ncoord=abs(uvIn.x-uvIn.y)*sqrt(2.0);\n} else if (gradientType==GRAD_TYPE_LIGHTING){\nIncidentLight directLight;\nGeometricContext geometry;\ngeometry.position=-viewPos;\nvec3 irr=vec3(0.0);\n#if (NUM_POINT_LIGHTS>0)\n#pragma unroll_loop\nfor (int i=0;i<NUM_POINT_LIGHTS;i++){\ngetPointLightInfo(pointLights[i],geometry,directLight);\nfloat dotNL=saturate(dot(geometryNormal,directLight.direction));\nirr+=dotNL*directLight.color;\n}\n#endif\n#if (NUM_SPOT_LIGHTS>0)\n#pragma unroll_loop\nfor (int i=0;i<NUM_SPOT_LIGHTS;i++){\ngetSpotLightInfo(spotLights[i],geometry,directLight);\nfloat dotNL=saturate(dot(geometryNormal,directLight.direction));\nirr+=dotNL*directLight.color;\n}\n#endif\n#if (NUM_DIR_LIGHTS>0)\n#pragma unroll_loop\nfor (int i=0;i<NUM_DIR_LIGHTS;i++){\ngetDirectionalLightInfo(directionalLights[i],geometry,directLight);\nfloat dotNL=saturate(dot(geometryNormal,directLight.direction));\nirr+=dotNL*directLight.color;\n}\n#endif\nirr/=PI;\nvec3 ambIrr=getAmbientLightIrradiance(ambientLightColor);\nirr+=ambIrr;\ncoord=(irr.x+irr.y+irr.z)/3.0;\n} else if (gradientType==GRAD_TYPE_LINEAR){\ncoord=uvIn.x;\n} else if (gradientType==GRAD_TYPE_MAPPED){\ncoord=(sourceMap.x+sourceMap.y+sourceMap.z)/3.0;\n} else if (gradientType==GRAD_TYPE_NORMAL){\nfloat angle=acos(clamp(dot(geometryNormal,normalize(viewPos)),-1.0,1.0));\nfloat k=100.0;\ncoord=1.0-sin(pow2(k)-k*sqrt(pow2(k)-pow2(angle)));\n} else if (gradientType==GRAD_TYPE_PONG){\nfloat y=min(uvIn.y,uvIn.x);\nfloat x=max(uvIn.y,uvIn.x);\ncoord=y/x;\n} else if (gradientType==GRAD_TYPE_RADIAL){\ncoord=length(uvIn-vec2(0.5))*2.0;\n} else if (gradientType==GRAD_TYPE_SPIRAL){\nvec2 uvSpiral=mat2(0.0,1.0,-1.0,0.0)*(uvIn-vec2(0.5));\ncoord=atan(uvSpiral.y,uvSpiral.x)/PI2+0.5;\n} else if (gradientType==GRAD_TYPE_SWEEP){\ncoord=atan(uvIn.x,uvIn.y)/PI_HALF;\n} else if (gradientType==GRAD_TYPE_TARTAN){\nvec2 uvTartan=abs(uvIn-vec2(0.5));\ncoord=1.0-min(uvTartan.x,uvTartan.y)*2.0;\n}\noutCol=texture2D(gradientData,vec2(coord,0.0));\n}",node_map_mx_frag="\nvoid node_map(const vec4 colorIn,out vec4 color)\n{\ncolor=colorIn;\n}",node_mask_mx_frag="void node_mask(const bool maskInverted,const vec4 color,vec4 mask,out vec4 outColor)\n{\nmask=maskInverted?vec4(vec3(1.0)-mask.rgb,mask.a):mask;\noutColor=color*mask;\n}",node_material_mx_frag="void node_material(float reflectionRatio,const float refractionRatio,const bool selfIllumColorOn,const vec4 ambientColor,const vec4 diffuseColor,const vec4 specularColor,const float glossiness,const float specularLevel,const vec4 selfIllum,const float opacity,const vec4 filterColor,const vec3 normal,const vec4 reflection,const vec4 refraction,const float displacement,out vec4 outColor)\n{\nvec3 diffuse,specular;\nNodeMaterial material;\nfloat ior=1.5;\nfloat facing=pow2((1.0-ior)/(1.0+ior));\nfloat edge=1.0;\nfloat slope=5.0;\nfloat cosTheta=saturate(dot(normal,normalize(vViewPosition)));\nfloat fresnelRefl=(facing+(edge-facing)*pow(1.0-cosTheta,slope))*saturate(specularLevel);\nfloat kd=1.0-fresnelRefl;\nmaterial.diffuseColor=diffuseColor.rgb*kd;\nmaterial.specularColor=mix(vec3(0.0),specularColor.rgb,fresnelRefl);\nmaterial.roughness=1.0-glossiness;\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\n#define RE_Direct RE_Direct_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Node\n#define RE_IndirectSpecular RE_IndirectSpecular_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#undef RE_IndirectSpecular\ndiffuse=reflectedLight.directDiffuse+reflectedLight.indirectDiffuse;\nif (selfIllumColorOn){\ndiffuse+=selfIllum.rgb;\n} else {\ndiffuse=mix(diffuse,material.diffuseColor,selfIllum[0]);\n}\nspecular=reflectedLight.directSpecular+reflectedLight.indirectSpecular;\noutColor=vec4(saturate(diffuse+specular),1.0);\nfloat alpha=opacity-saturate(maxFromRGB(specular))*(opacity-1.0);\noutColor+=reflection*specularColor*reflectionRatio;\noutColor+=refraction*refractionRatio;\nalpha+=saturate(maxFromRGB(reflection.rgb)*maxFromRGB(specularColor.rgb))*reflectionRatio;\nalpha+=saturate(maxFromRGB(refraction.rgb))*refractionRatio;\noutColor.a=alpha;\n}",node_matte_shadow_mx_frag="#include <shadowmask_pars_fragment>\nvoid node_matte_shadow(vec3 normal,bool receiveShadow,float shadowBrightness,vec3 color,out vec4 outColor){\nfloat shadow=getShadowMask();\noutColor=vec4(color,1.0-(shadowBrightness+(1.0-shadowBrightness)*shadow));\n}",node_mix_mx_frag="void node_mix(const vec4 color1,const vec4 color2,const float amount,out vec4 color)\n{\ncolor=mix(color1,color2,clamp(amount,0.0,1.0));\n}",node_noise_mx_frag="#define NOISE_REGULAR 0\n#define NOISE_FRACTAL 1\n#define NOISE_TURBULENCE 2\nfloat noise(vec3 vec,const int noiseType,const float size,const float thresholdLow,const float thresholdHigh,const float levels,float phase){\nvec/=size;\nfloat n=0.0;\nif (noiseType==NOISE_REGULAR){\nn=(1.0+snoise(vec4(vec,phase)))*0.5;\n} else if (noiseType==NOISE_FRACTAL){\nfloat l,f=1.0;\n#if __VERSION__==100\nfor (float l=3.0;l>=1.0;l-=1.0){\n#else\nfor (l=levels;l>=1.0;l-=1.0){\n#endif\nn+=snoise(vec4(vec*f,phase))/f;\nf*=2.0;\n}\nif (l>0.0)\nn+=l*snoise(vec4(vec*f,phase))/f;\nn=0.5*(n+1.0);\n} else {\nfloat l,f=1.0;\nfloat ml=levels;\n#if __VERSION__==100\nfor (float l=3.0;l>=1.0;l-=1.0){\n#else\nfor (l=levels;l>=1.0;l-=1.0,ml-=1.0){\n#endif\nn+=abs(snoise(vec4(vec*f,phase)))/f;\nf*=2.0;\n}\nif (l>0.0)\nn+=l*abs(snoise(vec4(vec*f,phase)))/f;\n}\nreturn clamp(smoothstep(thresholdLow,thresholdHigh,n),0.0,1.0);\n}\nvoid node_noise(const vec2 uv,const int noiseType,const int coordType,const vec3 color1,const vec3 color2,const float size,const float thresholdLow,const float thresholdHigh,const float levels,const float phase,const vec3 offset,const vec3 tiling,const vec3 angle,out vec4 color){\nvec3 vec=(calcXYZTransform(offset,tiling,angle)*vec4(uv.x,1.0-uv.y,1.0,1.0)).xyz;\ncolor=vec4(mix(color1,color2,noise(vec,noiseType,size,thresholdLow,thresholdHigh,levels,phase)),1.0);\n}\nvoid node_noise(const vec3 viewPos,const int noiseType,const int coordType,const vec3 color1,const vec3 color2,const float size,const float thresholdLow,const float thresholdHigh,const float levels,const float phase,const vec3 offset,const vec3 tiling,const vec3 angle,out vec4 color){\nvec4 posWorld=invViewMatrix*vec4(-viewPos,1.0);\nvec3 vec;\nif (coordType==0)\nvec=(invModelMatrix*posWorld).xyz;\nelse\nvec=posWorld.xyz;\nvec=(calcXYZTransform(offset,tiling,angle)*vec4(swizzleUpZ(vec),1.0)).xyz;\ncolor=vec4(mix(color1,color2,noise(vec,noiseType,size,thresholdLow,thresholdHigh,levels,phase)),1.0);\n}",node_normal_bump_mx_frag="void node_normal_bump(const vec4 tangent,const vec3 normal,ivec2 flip,vec4 normalColor,vec3 additionalBump,float normalMult,float addBumpMult,out vec3 normalOut)\n{\nif (flip[0]==1)\nnormalColor.x=1.0-normalColor.x;\nif (flip[1]==0)\nnormalColor.y=1.0-normalColor.y;\nvec3 normalTex=(normalColor.xyz*2.0-1.0);\nvec4 viewTangent=vec4(normalize(modelViewMatrix*vec4(tangent.xyz,0.0)).xyz,tangent.w);\nvec3 bitangent=viewTangent.w*cross(normal,viewTangent.xyz);\nnormalOut=normalize(normalTex.x*viewTangent.xyz+normalTex.y*bitangent \n+ normalTex.z*normal);\nnormalOut=mix(normal,normalOut,normalMult);\nadditionalBump=mix(normal,additionalBump,addBumpMult);\nnormalOut=normalize(normalOut+additionalBump);\n}",node_openpbr_surface_mx_frag="void node_openpbr_surface(vec3 geometryNormal,const bool thinWalled,const float baseWeight,const vec3 baseColor,const float baseMetalness,const float baseDiffuseRoughness,const float specularWeight,const vec3 specularColor,const float specularRoughness,const float specularIOR,const float transmissionWeight,const vec3 transmissionColor,const float transmissionDepth,const float coatWeight,const vec3 coatColor,const float coatRoughness,const float fuzzWeight,const vec3 fuzzColor,const float fuzzRoughness,const float emissionWeight,const vec3 emissionColor,const float emissionLuminance,const float geometryOpacity,const vec3 normal,const vec3 clearcoatNormal,out vec4 outColor)\n{\nNodeMaterial material;\nvec3 baseColorWeighted=baseWeight*baseColor.rgb;\nmaterial.diffuseColor=baseColorWeighted*(1.0-baseMetalness)*(1.0-transmissionWeight);\n#ifdef USE_CLEARCOAT\nmaterial.clearcoat=saturate(coatWeight);\nmaterial.clearcoatRoughness=clamp(coatRoughness,0.0,1.0);\nmaterial.clearcoatF0=vec3(0.04);\nmaterial.clearcoatF90=1.0;\n#endif\n#ifdef USE_SHEEN\nmaterial.sheenColor=saturate(fuzzWeight*fuzzColor);\nmaterial.sheenRoughness=clamp(fuzzRoughness,0.0,1.0);\n#endif\nvec3 dxy=max(abs(dFdx(geometryNormal)),abs(dFdy(geometryNormal)));\nfloat geometryRoughness=max(max(dxy.x,dxy.y),dxy.z);\nmaterial.roughness=max(specularRoughness,0.0525);\nmaterial.roughness+=geometryRoughness;\nmaterial.roughness=min(material.roughness,1.0);\nvec3 specularColorWeighted=specularWeight*specularColor;\nvec3 dielRefl=pow2((1.0-specularIOR)/(1.0+specularIOR))*specularColorWeighted;\nmaterial.specularColor=mix(dielRefl,baseColorWeighted,baseMetalness);\nmaterial.fresnelRefl90=mix(specularColorWeighted,vec3(1.0),baseMetalness);\nmaterial.specularF90=average(material.fresnelRefl90);\nmaterial.refractionColor=pow(transmissionWeight*(1.0-baseMetalness)*transmissionColor.rgb,vec3(2.0));\nmaterial.refractionIOR=specularIOR;\nmaterial.refractionRoughness=material.roughness;\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\nvec3 refractedLight=vec3(0.0);\n#ifdef USE_GTAO\nvec4 gtaoVisibilityBentNormal=texture2D(gtaoMap,gl_FragCoord.xy/currResolution);\nvec3 bentNormal=normalize(unpackRGBToNormal(gtaoVisibilityBentNormal.gba));\n#define PROBE_NORMAL bentNormal\n#endif\n#define RE_Direct RE_Direct_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Node\n#define RE_IndirectSpecular RE_IndirectSpecular_Node\n#define RE_Refraction RE_Refraction_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#undef RE_IndirectSpecular\n#undef RE_Refraction\n#ifdef PROBE_NORMAL\n#undef PROBE_NORMAL\n#endif\n#ifdef USE_GTAO\nreflectedLight.indirectDiffuse*=gtaoVisibilityBentNormal.r;\nfloat gtaoVisibility=gtaoVisibilityBentNormal.r;\nvec3 gtaoBentNormal=bentNormal;\nvec3 gtaoViewDir=geometry.viewDir;\nvec3 gtaoNormal=normal;\nfloat gtaoRoughness=material.roughness;\n#endif\n#include <lights_fragment_gtso>\nvec3 totalEmissiveRadiance=emissionWeight*emissionColor*emissionLuminance*OPENPBR_EMISSION_LUM_FACTOR;\nvec3 outSpecular=reflectedLight.directSpecular+reflectedLight.indirectSpecular;\nvec3 outColor3=reflectedLight.directDiffuse+reflectedLight.indirectDiffuse +\noutSpecular+totalEmissiveRadiance;\n#ifdef USE_SHEEN\nfloat sheenEnergyComp=1.0-0.157*max3(material.sheenColor);\noutColor3=outColor3*sheenEnergyComp+sheenSpecular;\n#endif\n#ifdef USE_CLEARCOAT\nfloat dotNVcc=saturate(dot(geometry.normal,geometry.viewDir));\nvec3 Fcc=F_Schlick(material.clearcoatF0,material.clearcoatF90,dotNVcc);\noutColor3=outColor3*(1.0-material.clearcoat*Fcc)+clearcoatSpecular*material.clearcoat;\n#endif\nfloat alpha=1.0;\nif (thinWalled){\nalpha=geometryOpacity*(1.0-saturate(transmissionWeight)+maxFromRGB(outSpecular)*saturate(transmissionWeight));\n} else {\noutColor3+=refractedLight;\n}\noutColor=vec4(outColor3,saturate(alpha));\n}",node_output_map_mx_frag="vec4 processOutputColor(vec4 color,const bool invert,const bool clampColor,const bool alphaFromRGB,const float rgbLevel,const float rgbOffset,const float outputAmount)\n{\nvec3 color3=color.rgb;\ncolor3=clampColor?saturate(color3):color3;\ncolor3=color3*rgbLevel+vec3(rgbOffset);\ncolor3=invert?(vec3(1.0)-color3):color3;\ncolor=outputAmount*vec4(color3,color.a);\ncolor.a=alphaFromRGB?average(color.rgb):color.a;\nreturn color;\n}\nvoid node_output_map(const bool invert,const bool clampColor,const bool alphaFromRGB,const vec4 color,const float rgbLevel,const float rgbOffset,const float outputAmount,const float bumpAmount,out vec4 outColor)\n{\noutColor=processOutputColor(color,invert,clampColor,alphaFromRGB,rgbLevel,rgbOffset,outputAmount);\n}\nvoid node_output_map(const bool invert,const bool clampColor,const bool alphaFromRGB,sampler2D colormap,vec4 color,const float rgbLevel,const float rgbOffset,const float outputAmount,const float bumpAmount,out vec4 outColor)\n{\nfloat r=texture2D(colormap,vec2(color.r,0.0)).r;\nfloat g=texture2D(colormap,vec2(color.g,0.0)).g;\nfloat b=texture2D(colormap,vec2(color.b,0.0)).b;\noutColor=processOutputColor(vec4(r,g,b,color.a),invert,clampColor,alphaFromRGB,rgbLevel,rgbOffset,outputAmount);\n}",node_output_mx_frag="void node_output(vec4 color,out vec4 outgoingLight)\n{\noutgoingLight=color;\n}",node_physical_mx_frag="#define DEFAULT_REFLECTION_EDGE 1.0\n#define DEFAULT_REFLECTION_SLOPE 5.0\nvoid node_physical(vec3 geometryNormal,const float emitLuminance,const bool useCustomReflCurve,const float reflFacing,const float reflEdge,const float reflSlope,const bool roughnessInv,const bool transRoughnessLock,const bool transRoughnessInv,const bool thinWalled,const float base,const vec4 baseColor,const float reflectivity,const vec4 reflColor,const float roughness,const float metalness,const float diffRoughness,const float anisotropy,const float anisoangle,const float transparency,const vec4 transColor,const float transRoughness,const float ior,const float scattering,const vec4 sssColor,const float sssScale,const float emission,const vec4 emitColor,const float clearcoat,const vec4 clearcoatColor,const float clearcoatRoughness,const vec3 normal,const vec3 clearcoatNormal,const float displacement,const float opacity,out vec4 outColor)\n{\nNodeMaterial material;\nvec3 baseColorWeighted=base*baseColor.rgb;\nmaterial.diffuseColor=baseColorWeighted*(1.0-transparency);\n#ifdef USE_CLEARCOAT\nmaterial.clearcoat=saturate(clearcoat);\nmaterial.clearcoatRoughness=clamp(clearcoatRoughness,0.0,1.0);\nmaterial.clearcoatF0=vec3(0.04);\nmaterial.clearcoatF90=1.0;\n#endif\nfloat facing,edge,slope;\nif (useCustomReflCurve){\nfacing=reflFacing;\nedge=reflEdge;\nslope=reflSlope;\n} else {\nfacing=pow2((1.0-ior)/(1.0+ior));\nedge=DEFAULT_REFLECTION_EDGE;\nslope=DEFAULT_REFLECTION_SLOPE;\n}\nfloat cosTheta=saturate(dot(normal,normalize(vViewPosition)));\nfloat fresnelRefl=(facing+(edge-facing)*pow(1.0-cosTheta,slope))\n* saturate(reflectivity+metalness);\nfloat kd=1.0-(metalness*(1.0-fresnelRefl)+fresnelRefl);\nmaterial.specularColor=mix(metalness*baseColorWeighted,reflColor.rgb,fresnelRefl);\nmaterial.diffuseColor*=kd;\nmaterial.specularF90=1.0;\nmaterial.roughness=clamp(roughnessInv?(1.0-roughness):roughness,0.0,1.0);\nmaterial.refractionColor=pow(transparency*(1.0-metalness)*transColor.rgb,vec3(2.0));\nmaterial.refractionIOR=ior;\nfloat tRough;\nif (transRoughnessLock){\ntRough=roughnessInv?1.0-roughness:roughness;\n} else {\ntRough=transRoughnessInv?1.0-transRoughness:transRoughness;\n}\nmaterial.refractionRoughness=pow2(tRough);\n#if defined(ENVMAP_TYPE_CUBE)||defined(ENVMAP_TYPE_CUBE_UV)\nfloat geomRoughness=calcGeometryRoughness(geometryNormal);\nmaterial.roughness=calcCubeUVAdjustedRoughness(material.roughness,geomRoughness);\nmaterial.refractionRoughness=calcCubeUVAdjustedRoughness(material.refractionRoughness,geomRoughness);\n#ifdef USE_CLEARCOAT\nmaterial.clearcoatRoughness=calcCubeUVAdjustedRoughness(material.clearcoatRoughness,geomRoughness);\n#endif\n#endif\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\nvec3 refractedLight=vec3(0.0);\n#ifdef USE_GTAO\nvec4 gtaoVisibilityBentNormal=texture2D(gtaoMap,gl_FragCoord.xy/currResolution);\nvec3 bentNormal=normalize(unpackRGBToNormal(gtaoVisibilityBentNormal.gba));\n#define PROBE_NORMAL bentNormal\n#endif\n#define RE_Direct RE_Direct_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Node\n#define RE_IndirectSpecular RE_IndirectSpecular_Node\n#define RE_Refraction RE_Refraction_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#undef RE_IndirectSpecular\n#undef RE_Refraction\n#ifdef PROBE_NORMAL\n#undef PROBE_NORMAL\n#endif\n#ifdef USE_GTAO\nreflectedLight.indirectDiffuse*=gtaoVisibilityBentNormal.r;\nfloat gtaoVisibility=gtaoVisibilityBentNormal.r;\nvec3 gtaoBentNormal=bentNormal;\nvec3 gtaoViewDir=geometry.viewDir;\nvec3 gtaoNormal=normal;\nfloat gtaoRoughness=material.roughness;\n#endif\n#include <lights_fragment_gtso>\nvec3 totalEmissiveRadiance=emitLuminance/LUMENS_PER_WATT*emission*emitColor.rgb;\nvec3 specular=reflectedLight.directSpecular+reflectedLight.indirectSpecular;\nvec3 outColor3=reflectedLight.directDiffuse+reflectedLight.indirectDiffuse +\nspecular+totalEmissiveRadiance;\n#ifdef USE_CLEARCOAT\nfloat dotNVcc=saturate(dot(geometry.normal,geometry.viewDir));\nvec3 Fcc=F_Schlick(material.clearcoatF0,material.clearcoatF90,dotNVcc);\noutColor3=outColor3*(1.0-material.clearcoat*Fcc)+clearcoatSpecular*material.clearcoat;\n#endif\nfloat alpha=1.0;\nif (thinWalled){\nalpha=1.0-saturate(transparency)+maxFromRGB(specular)*saturate(transparency);\n} else {\noutColor3+=refractedLight;\n}\noutColor=vec4(outColor3,saturate(alpha)*opacity);\n}",node_phy_sun_sky_env_mx_frag="vec3 perezSky(vec3 paramA,vec3 paramB,vec3 paramC,vec3 paramD,vec3 paramE,vec3 radiance,vec3 sunDirection,vec3 direction)\n{\nfloat cosGamma=clamp(dot(direction,sunDirection),-1.0,1.0);\nfloat cosTheta=clamp(direction.y,0.0,1.0);\nvec3 radInternal=(1.0+paramA*exp(paramB/cosTheta))*(1.0+paramC*exp(paramD*acos(cosGamma))\n+ paramE*pow(cosGamma,2.0)\n);\nfloat ciex=radInternal.y*radiance.y;\nfloat ciey=radInternal.z*radiance.z;\nfloat cieY=clamp(radInternal.x*radiance.x,0.0,1000000.0);\nvec3 XYZ=xyY_to_XYZ(ciex,ciey,cieY);\nreturn max(xyz_to_sRGB(XYZ),0.0);\n}\n#define GROUND_SKY_SAMPLES 16\nvec3 groundSky(vec3 paramA,vec3 paramB,vec3 paramC,vec3 paramD,vec3 paramE,vec3 radiance,vec3 sunDirection,vec3 sunIlluminance)\n{\nconst int horizSamples=GROUND_SKY_SAMPLES;\nconst int vertSamples=GROUND_SKY_SAMPLES/2;\nvec3 result=vec3(0.0);\nfor (int horizSampleIdx=0;horizSampleIdx<horizSamples;horizSampleIdx++){\nfloat horizSample=float(horizSampleIdx)/float(horizSamples);\nfloat horizAngle=PI2*horizSample;\nfor (int vertSampleIdx=0;vertSampleIdx<vertSamples;vertSampleIdx++){\nfloat vertSample=float(vertSampleIdx)/float(vertSamples);\nfloat y=1.0-vertSample;\nfloat x=sqrt(1.0-y*y)*cos(horizAngle);\nfloat z=-sqrt(1.0-y*y)*sin(horizAngle);\nvec3 direction=vec3(x,y,z);\nvec3 sampleColor=perezSky(paramA,paramB,paramC,paramD,paramE,radiance,sunDirection,direction);\n\nresult+=direction.y*sampleColor;\n}\n}\nresult/=float(horizSamples*vertSamples);\nresult+=(sunIlluminance*sunDirection.y)/PI;\nreturn result;\n}\nvoid node_phy_sun_sky_env(vec3 paramA,vec3 paramB,vec3 paramC,vec3 paramD,vec3 paramE,vec3 radiance,vec3 sunDirection,vec3 sunIlluminance,vec3 sunLuminance,float globalIntensity,vec4 groundColor,out vec4 outColor)\n{\nvec3 dir=vWorldPosition;\nif (length(dir)==0.0){\ndir=vec3(0.0,0.0,-1.0);\n} else {\ndir=normalize(dir);\n}\nif (dir.y<0.0){\noutColor=groundColor*vec4(groundSky(paramA,paramB,paramC,paramD,paramE,radiance,sunDirection,sunIlluminance),1.0);\n} else {\noutColor=vec4(perezSky(paramA,paramB,paramC,paramD,paramE,radiance,sunDirection,dir),1.0);\n}\noutColor=globalIntensity*outColor;\n}",node_reflect_refract_mx_frag="void node_reflect_refract(sampler2D envMap,int reflectMode,const float IOR,const int encoding,vec3 normal,out vec4 color)\n{\nvec3 cameraToVertex=normalize(vWorldPosition-cameraPosition);\nvec3 worldNormal=inverseTransformDirection(normal,viewMatrix);\nvec3 reflectVec;\nif (reflectMode==MAX_ENV_COORDS_REFLECT)\nreflectVec=reflect(cameraToVertex,worldNormal);\nelse {\nfloat refrRatio=1.0/IOR;\nreflectVec=refract(cameraToVertex,worldNormal,refrRatio);\n}\nreflectVec=normalize(reflectVec);\ncolor=sampleEquirectangular(envMap,reflectVec,mat3(1.0),encoding);\n}",node_reflect_refract_color_mx_frag="void node_reflect_refract_color(const vec4 colorIn,out vec4 color)\n{\ncolor=vec4(colorIn);\n}",node_rgb_multiply_mx_frag="void node_rgb_multiply(const vec4 color1,const vec4 color2,out vec4 color)\n{\ncolor=color1*color2;\n}",node_rgb_tint_mx_frag="void node_rgb_tint(const vec4 color,const vec4 red,const vec4 green,const vec4 blue,out vec4 outColor)\n{\nmat3 tintMatrix=mat3(red.rgb,green.rgb,blue.rgb);\noutColor=vec4(tintMatrix*color.rgb,color.a);\n}",node_rgb_mx_frag="uniform vec4 nodeRGB[NODE_RGB_NUM];\nvoid node_rgb(vec4 color,out vec4 outColor)\n{\noutColor=color;\n}",node_shellac_mx_frag="void node_shellac(const vec4 color1,const vec4 color2,const float amount,out vec4 color)\n{\ncolor=mix(color1,color2,clamp(amount,0.0,1.0));\n}",node_sub_transform_mx_frag="#define COORD_WORLD_SPACE 0\n#define COORD_OBJECT_SPACE 1\nvoid node_sub_transform(const int coordSpace,vec3 scale,vec3 rotate,vec3 offset,out vec3 outVector,out vec3 outNormal)\n{\nvec3 norm=vNormal;\nnorm=(invViewMatrix*vec4(norm,0.0)).xyz;\nvec3 vector=vWorldPosition.xyz;\nif (coordSpace==COORD_OBJECT_SPACE){\nvector=(invModelMatrix*vec4(vector,1.0)).xyz;\nnorm=(invModelMatrix*vec4(norm,0.0)).xyz;\n}\nvector-=swizzleUpY(offset.xyz);\nvector*=scale.xzy;\nmat3 rotX90=mat3RotateX(PI*0.5);\nmat3 rotX=mat3RotateX(radians(rotate.x));\nmat3 rotY=mat3RotateY(radians(-rotate.y));\nmat3 rotZ=mat3RotateZ(radians(rotate.z));\nmat3 rotMat=rotX*rotY*rotZ*rotX90;\nvector=rotMat*vector;\nnorm=rotMat*norm;\noutVector=vector;\noutNormal=normalize(norm);\n}",node_value_mx_frag="uniform float nodeValue[NODE_VALUE_NUM];\nvoid node_value(float value,out float outValue)\n{\noutValue=value;\n}",node_vertex_color_mx_frag="void node_vertex_color(vec3 color,out vec4 outColor)\n{\noutColor=vec4(color,1.0);\n}",node_add_double_linear_my_frag="void node_add_double_linear(float input1,float input2,out float outValue){\noutValue=input1+input2;\n}",node_add_matrix_my_frag="void node_add_matrix(mat4 matrixIn1,out mat4 matrixSum)\n{\nmatrixSum=matrixIn1;\n}\nvoid node_add_matrix(mat4 matrixIn1,mat4 matrixIn2,out mat4 matrixSum)\n{\nmatrixSum=matrixIn1+matrixIn2;\n}\nvoid node_add_matrix(mat4 matrixIn1,mat4 matrixIn2,mat4 matrixIn3,out mat4 matrixSum)\n{\nmatrixSum=matrixIn1+matrixIn2+matrixIn3;\n}",node_anim_curve_ta_my_frag="#ifndef NODE_VALUE\nuniform float nodeValue[NODE_VALUE_NUM];\n#endif\nvoid node_anim_curve_ta(float val,out float outVal)\n{\noutVal=val;\n}",node_anim_curve_tu_my_frag="#ifndef NODE_VALUE\nuniform float nodeValue[NODE_VALUE_NUM];\n#endif\nvoid node_anim_curve_tu(float val,out float outVal)\n{\noutVal=val;\n}",node_blend_colors_my_frag="void node_blend_colors(float blender,vec3 color1,vec3 color2,out vec3 outColor)\n{\nblender=clamp(blender,0.0,1.0);\noutColor=mix(color1,color2,1.0-blender);\n}\nvoid node_blend_colors(float blender,vec4 color1,vec4 color2,out vec4 outColor)\n{\nblender=clamp(blender,0.0,1.0);\noutColor=mix(color1,color2,1.0-blender);\n}",node_blinn_my_frag="void node_blinn(vec3 geometryNormal,vec3 color,vec3 ambientColor,vec3 incandescence,float matteOpacity,float diffuse,vec3 normal,float reflectivity,vec3 reflectedColor,float eccentricity,vec3 specularColor,float specularRollOff,float translucence,vec3 transparency,out vec4 outColor){\nNodeMaterial material;\nmaterial.diffuseColor=diffuse*color;\n#ifdef USE_CLEARCOAT\n#undef USE_CLEARCOAT\n#define _CLEARCOAT_RESTORE\n#endif\nvec3 dxy=max(abs(dFdx(geometryNormal)),abs(dFdy(geometryNormal)));\nfloat geometryRoughness=max(max(dxy.x,dxy.y),dxy.z);\nmaterial.roughness=max(eccentricity,0.0525);\nmaterial.roughness+=geometryRoughness;\nmaterial.roughness=min(material.roughness,1.0);\nmaterial.specularColor=specularColor;\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\n#define RE_Direct RE_Direct_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Node\n#define RE_IndirectSpecular RE_IndirectSpecular_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#undef RE_IndirectSpecular\n#ifdef _CLEARCOAT_RESTORE\n#undef _CLEARCOAT_RESTORE\n#define USE_CLEARCOAT\n#endif\nfloat alpha=1.0-average(transparency);\noutColor=vec4(reflectedLight.directDiffuse+reflectedLight.indirectDiffuse +\nreflectedLight.directSpecular+reflectedLight.indirectSpecular+incandescence,alpha);\n}",node_bulge_my_frag="void node_bulge(float uWidth,float vWidth,vec2 uvCoord,out float outAlpha,out vec3 outColor){\nuvCoord=2.0*fract(uvCoord);\nfloat bulge=0.0;\nif (uvCoord.x>uWidth&&uvCoord.x<2.0-uWidth &&\nuvCoord.y>vWidth&&uvCoord.y<2.0-vWidth){\nuvCoord.x=(uvCoord.x-uWidth)/(1.0-uWidth);\nuvCoord.y=(uvCoord.y-vWidth)/(1.0-vWidth);\nbulge=uvCoord.x*(2.0-uvCoord.x)*uvCoord.y*(2.0-uvCoord.y);\n}\noutAlpha=bulge;\noutColor=vec3(bulge,bulge,bulge);\n}",node_bump_2d_my_frag="void node_bump_2d(vec3 normal,float bumpDepth,float bumpValue,out vec3 outNormal){\nvec3 position=vViewPosition;\nvec3 dPdx=dFdx(position);\nvec3 dPdy=dFdy(position);\nfloat dHdx=dFdx(bumpValue);\nfloat dHdy=dFdy(bumpValue);\nvec3 tanX=cross(dPdy,normal);\nvec3 tanY=cross(normal,dPdx);\nvec3 surfaceGrad=dHdx*tanX+dHdy*tanY;\nfloat dotPosTanX=dot(dPdx,tanX);\noutNormal=normalize(normal*abs(dotPosTanX)-surfaceGrad*sign(dotPosTanX));\noutNormal=normalize(mix(normal,outNormal,max(0.0,bumpDepth)));\n}\nvoid node_bump_2d(vec3 normal,vec4 tangent,float bumpDepth,vec3 bumpValue,out vec3 outNormal){\n#ifdef DOUBLE_SIDED\nnormal=normal*(float(gl_FrontFacing)*2.0-1.0);\n#endif\nif (length(tangent.xyz)==0.0)\ntangent.x=1.0;\nvec3 normalTex=(bumpValue.xyz*2.0-1.0);\nvec4 viewTangent=vec4(normalize((modelViewMatrix*vec4(tangent.xyz,0.0)).xyz),tangent.w);\nvec3 bitangent=viewTangent.w*cross(normal,viewTangent.xyz);\noutNormal=normalize(normalTex.x*viewTangent.xyz+normalTex.y*bitangent\n+ normalTex.z*normal);\noutNormal=mix(normal,outNormal,bumpDepth);\n}",node_channels_my_frag="void node_channels(int channelR,int channelG,int channelB,int channelA,float inAlpha,vec3 inColor,out float outAlpha,out vec3 outColor){\noutAlpha=1.0;\noutColor=vec3(1.0);\nif (channelR==0)\noutColor.r=inColor.r;\nelse if (channelR==1)\noutColor.r=inColor.g;\nelse if (channelR==2)\noutColor.r=inColor.b;\nelse\noutColor.r=inAlpha;\nif (channelG==0)\noutColor.g=inColor.r;\nelse if (channelG==1)\noutColor.g=inColor.g;\nelse if (channelG==2)\noutColor.g=inColor.b;\nelse\noutColor.g=inAlpha;\nif (channelB==0)\noutColor.b=inColor.r;\nelse if (channelB==1)\noutColor.b=inColor.g;\nelse if (channelB==2)\noutColor.b=inColor.b;\nelse\noutColor.b=inAlpha;\nif (channelA==0)\noutAlpha=inColor.r;\nelse if (channelA==1)\noutAlpha=inColor.g;\nelse if (channelA==2)\noutAlpha=inColor.b;\nelse\noutAlpha=inAlpha;\n}",node_checker_my_frag="void node_checker(vec3 color1,vec3 color2,float contrast,vec2 uvCoord,out float outAlpha,out vec3 outColor){\nuvCoord-=floor(uvCoord);\nvec3 deltaColor=color2-color1;\ncolor1+=(1.0-contrast)*0.5*deltaColor;\ncolor2-=(1.0-contrast)*0.5*deltaColor;\nif ((uvCoord.x<0.5&&uvCoord.y>=0.5)||(uvCoord.x>=0.5&&uvCoord.y<0.5)){\noutColor=color2;\noutAlpha=1.0;\n} else {\noutColor=color1;\noutAlpha=0.0;\n}\n}",node_clamp_my_frag="void node_clamp(vec3 inputValue,vec3 maxValue,vec3 minValue,out vec3 outputValue){\noutputValue=clamp(inputValue,minValue,maxValue);\n}",node_cloth_my_frag="void node_cloth(float brightSpread,vec3 gapColor,float randomness,vec3 uColor,float uWave,float uWidth,vec3 vColor,float vWave,float vWidth,float widthSpread,vec2 uvCoord,out float outAlpha,out vec3 outColor){\nif (abs(uWave)>-EPSILON||abs(vWave)>-EPSILON){\nuvCoord.x+=- uWave*sin(PI2*uvCoord.y);\nuvCoord.y+=vWave*sin(PI2*uvCoord.x);\n}\nuvCoord=fract(uvCoord);\nint thread=0;\nif ((uvCoord.x>=0.5&&uvCoord.y<0.5)||(uvCoord.x<0.5&&uvCoord.y>=0.5)){\nfloat flippedCoord;\nflippedCoord=uvCoord.x;\nuvCoord.x=uvCoord.y;\nuvCoord.y=flippedCoord;\nflippedCoord=uWidth;\nuWidth=vWidth;\nvWidth=flippedCoord;\nthread=1;\n}\nuvCoord=fract(2.0*uvCoord);\nfloat cloth=1.0;\nif (uvCoord.y<=vWidth){\nfloat clothU=uvCoord.x-0.5*uWidth;\nfloat clothV=2.0*uvCoord.y/vWidth-1.0;\ncloth=0.75*(clothU*clothU+clothV*clothV);\n} else if (uvCoord.x<=uWidth){\nfloat clothU=2.0*uvCoord.x/uWidth-1.0;\nfloat clothV=uvCoord.y-0.5*vWidth-1.0;\ncloth=0.75*(clothU*clothU+clothV*clothV);\nthread=1-thread;\n}\noutColor=gapColor;\nif (cloth<1.0){\ncloth=1.0-cloth;\ncloth=min(cloth,1.0);\noutColor*=(1.0-cloth);\nvec3 threadColor=uColor;\nif (thread==0)\nthreadColor=vColor;\noutColor+=threadColor*cloth;\n}\noutAlpha=dot(outColor,LUM_WEIGHTS_MAYA);\n}",node_color_condition_my_frag="void node_color_condition(float alphaA,float alphaB,vec3 colorA,vec3 colorB,bool condition,out float outAlpha,out vec3 outColor){\noutAlpha=condition?alphaA:alphaB;\noutColor=condition?colorA:colorB;\n}",node_color_composite_my_frag="void node_color_composite(int operation,vec3 colorA,float alphaA,vec3 colorB,float alphaB,float factor,out vec3 outColor,out float outAlpha)\n{\nif (factor<=0.0){\noutColor=colorA;\noutAlpha=alphaA;\nreturn;\n}\nif (operation==0){\noutColor[0]=colorA[0]+(colorB[0]*factor);\noutColor[1]=colorA[1]+(colorB[1]*factor);\noutColor[2]=colorA[2]+(colorB[2]*factor);\noutAlpha=alphaA+(alphaB*factor);\n} else if (operation==1){\noutColor[0]=colorA[0]+((colorB[0]-1.0)*factor);\noutColor[1]=colorA[1]+((colorB[1]-1.0)*factor);\noutColor[2]=colorA[2]+((colorB[2]-1.0)*factor);\noutAlpha=alphaA+((alphaB-1.0)*factor);\n} else if (operation==2){\nif (factor>=1.0){\noutColor=colorB;\noutAlpha=alphaB;\nreturn;\n}\noutColor[0]=mix(colorA[0],colorB[0],factor);\noutColor[1]=mix(colorA[1],colorB[1],factor);\noutColor[2]=mix(colorA[2],colorB[2],factor);\noutAlpha=mix(alphaA,alphaB,factor);\n} else if (operation==3){\noutColor[0]=colorA[0]*(colorB[0]*factor+(1.0-factor));\noutColor[1]=colorA[1]*(colorB[1]*factor+(1.0-factor));\noutColor[2]=colorA[2]*(colorB[2]*factor+(1.0-factor));\noutAlpha=alphaA*(alphaB*factor+(1.0-factor));\n} else if (operation==4){\noutColor[0]=1.0-((1.0-colorA[0])*(1.0-colorB[0]*factor));\noutColor[1]=1.0-((1.0-colorA[1])*(1.0-colorB[1]*factor));\noutColor[2]=1.0-((1.0-colorA[2])*(1.0-colorB[2]*factor));\noutAlpha=1.0-((1.0-alphaA)*(1.0-alphaB*factor));\n} else if (operation==5){\noutColor[0]=colorB[0]>0.5?(2.0*colorA[0]*colorB[0]*factor)+colorA[0]*(1.0-factor):\n1.0-((1.0-colorA[0])*(1.0-colorB[0]*factor))*(2.0-(1.0-factor));\noutColor[1]=colorB[1]>0.5?(2.0*colorA[1]*colorB[1]*factor)+colorA[1]*(1.0-factor):\n1.0-((1.0-colorA[1])*(1.0-colorB[1]*factor))*(2.0-(1.0-factor));\noutColor[2]=colorB[2]>0.5?(2.0*colorA[2]*colorB[2]*factor)+colorA[2]*(1.0-factor):\n1.0-((1.0-colorA[2])*(1.0-colorB[2]*factor))*(2.0-(1.0-factor));\noutAlpha=alphaB>0.5?(2.0*alphaA*alphaB*factor)+alphaA*(1.0-factor):\n1.0-((1.0-alphaA)*(1.0-alphaB*factor))*(2.0-(1.0-factor));\n} else if (operation==6){\noutColor[0]=abs(colorA[0]-(colorB[0]*factor));\noutColor[1]=abs(colorA[1]-(colorB[1]*factor));\noutColor[2]=abs(colorA[2]-(colorB[2]*factor));\noutAlpha=abs(alphaA-(alphaB*factor));\n} else if (operation==7){\noutColor[0]=clamp(mix(colorA[0],colorA[0]/max(1.0-colorB[0],0.00001),factor),colorA[0],colorB[0]);\noutColor[1]=clamp(mix(colorA[1],colorA[1]/max(1.0-colorB[1],0.00001),factor),colorA[1],colorB[1]);\noutColor[2]=clamp(mix(colorA[2],colorA[2]/max(1.0-colorB[2],0.00001),factor),colorA[2],colorB[2]);\noutAlpha=clamp(mix(alphaA,alphaA/max(1.0-alphaB,0.00001),factor),alphaA,alphaB);\n} else if (operation==8){\noutColor[0]=clamp(mix(colorA[0],1.0-(colorA[0]/max(1.0-colorB[0],0.00001)),factor),colorA[0],colorB[0]);\noutColor[1]=clamp(mix(colorA[1],1.0-(colorA[1]/max(1.0-colorB[1],0.00001)),factor),colorA[1],colorB[1]);\noutColor[2]=clamp(mix(colorA[2],1.0-(colorA[2]/max(1.0-colorB[2],0.00001)),factor),colorA[2],colorB[2]);\noutAlpha=clamp(mix(alphaA,1.0-(alphaA/max(1.0-alphaB,0.00001)),factor),alphaA,alphaB);\n}\n}",node_color_constant_my_frag="void node_color_constant(vec3 inColor,float inAlpha,out vec3 outColor,out float outAlpha)\n{\noutColor=inColor;\noutAlpha=inAlpha;\n}",node_color_correct_my_frag="void node_color_correct(bool colClamp,vec3 colClampMin,vec3 colClampMax,bool alphaClamp,float alphaClampMin,float alphaClampMax,bool unpremultInput,bool premultResult,float alphaGain,float alphaGamma,float alphaOffset,vec3 colGain,vec3 colGamma,vec3 colOffset,float hueShift,float inAlpha,vec3 inColor,float satGain,float valGain,out float outAlpha,out vec3 outColor)\n{\noutColor=unpremultInput?inColor/inAlpha:inColor;\nif (hueShift != 0.0||satGain != 1.0||valGain != 1.0){\nvec4 color=vec4(outColor,1.0);\nrgbToHSV(vec4(inColor,1.0),color);\ncolor.r+=hueShift/360.0;\nif (color.r>1.0)\ncolor.r-=1.0;\nelse if (color.r<0.0)\ncolor.r+=1.0;\ncolor.g*=satGain;\ncolor.b*=valGain;\nhsvToRGB(color,color);\noutColor=color.rgb;\n}\noutColor*=colGain;\noutColor+=colOffset;\nif (any(notEqual(colGamma,vec3(1.0))))\noutColor=pow(outColor,1.0/colGamma);\nif (colClamp)\noutColor=clamp(outColor,colClampMin,colClampMax);\noutAlpha=inAlpha*alphaGain;\noutAlpha+=alphaOffset;\nif (alphaGamma != 1.0)\noutAlpha=pow(outAlpha,1.0/alphaGamma);\nif (alphaClamp)\noutAlpha=clamp(outAlpha,alphaClampMin,alphaClampMax);\nif (premultResult)\noutColor*=outAlpha;\n}",node_color_logic_my_frag="void node_color_logic(int operation,vec3 colorA,vec3 colorB,out bool outBool){\nif (operation==0){\noutBool=all(equal(colorA,colorB));\n} else if (operation==1){\noutBool=any(notEqual(colorA,colorB));\n} else if (operation==2){\noutBool=((colorA.x+colorA.y+colorA.z)<(colorB.x+colorB.y+colorB.z));\n} else if (operation==3){\noutBool=((colorA.x+colorA.y+colorA.z)>(colorB.x+colorB.y+colorB.z));\n} else if (operation==4){\noutBool=((colorA.x+colorA.y+colorA.z)<=(colorB.x+colorB.y+colorB.z));\n} else {\noutBool=((colorA.x+colorA.y+colorA.z)>=(colorB.x+colorB.y+colorB.z));\n}\n}",node_color_mask_my_frag="void node_color_mask(bool maskAlphaIsLuminance,float inAlpha,vec3 inColor,vec3 mask,float maskAlpha,out float outAlpha,out vec3 outColor){\nif (maskAlphaIsLuminance)\nmaskAlpha=1.0-dot(mask,LUM_WEIGHTS_MAYA);\noutColor=inColor*(1.0-maskAlpha);\n}",node_color_math_my_frag="void node_color_math(int operation,float alphaA,float alphaB,vec3 colorA,vec3 colorB,out float outAlpha,out vec3 outColor){\nif (operation==0){\noutColor=colorA+colorB;\noutAlpha=alphaA+alphaB;\n} else if (operation==1){\noutColor=colorA-colorB;\noutAlpha=alphaA-alphaB;\n} else if (operation==2){\noutColor=colorA*colorB;\noutAlpha=alphaA*alphaB;\n} else if (operation==3){\noutColor=colorA/colorB;\noutAlpha=alphaA/alphaB;\n} else if (operation==4){\noutColor=min(colorA,colorB);\noutAlpha=min(alphaA,alphaB);\n} else {\noutColor=max(colorA,colorB);\noutAlpha=max(alphaA,alphaB);\n}\n}",node_compose_matrix_my_frag="mat3 quatToMat3(vec4 quat){\nfloat x=quat.x,y=quat.y,z=quat.z,w=quat.w;\nfloat x2=x+x;\nfloat y2=y+y;\nfloat z2=z+z;\n\nfloat xx=x*x2;\nfloat yx=y*x2;\nfloat yy=y*y2;\nfloat zx=z*x2;\nfloat zy=z*y2;\nfloat zz=z*z2;\nfloat wx=w*x2;\nfloat wy=w*y2;\nfloat wz=w*z2;\n\nmat3 mat;\n\nmat[0][0]=1.0-yy-zz;\nmat[1][0]=yx-wz;\nmat[2][0]=zx+wy;\n\nmat[0][1]=yx+wz;\nmat[1][1]=1.0-xx-zz;\nmat[2][1]=zy-wx;\n\nmat[0][2]=zx-wy;\nmat[1][2]=zy+wx;\nmat[2][2]=1.0-xx-yy;\nreturn mat;\n}\nvoid node_compose_matrix(bool useEulerRotation,int inputRotateOrder,vec4 inputQuat,vec3 inputRotate,vec3 inputScale,vec3 inputShear,vec3 inputTranslate,out mat4 outputMatrix)\n{\nmat4 rotateMatrix;\ninputRotate=radians(inputRotate);\nif (useEulerRotation)\nrotateMatrix=toMat4(mat3RotateX(inputRotate.x)*mat3RotateY(inputRotate.y)*mat3RotateZ(inputRotate.z));\nelse\nrotateMatrix=toMat4(quatToMat3(normalize(inputQuat)));\nmat4 scaleMatrix=mat4(inputScale.x,0.0,0.0,0.0,0.0,inputScale.y,0.0,0.0,0.0,0.0,inputScale.z,0.0,0.0,0.0,0.0,1.0);\nmat4 shearMatrix=mat4(1.0,0.0,0.0,0.0,inputShear.x,1.0,0.0,0.0,inputShear.y,inputShear.z,1.0,0.0,0.0,0.0,0.0,1.0);\nmat4 transMatrix=mat4(1.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0,0.0,inputTranslate.x,inputTranslate.y,inputTranslate.z,1.0);\noutputMatrix=scaleMatrix*shearMatrix*rotateMatrix*transMatrix;\n}",node_condition_my_frag="void node_condition(int operation,vec3 colorIfFalse,vec3 colorIfTrue,float firstTerm,float secondTerm,out vec3 outColor){\nif (operation==0){\nif (firstTerm==secondTerm)\noutColor=colorIfTrue;\nelse\noutColor=colorIfFalse;\n} else if (operation==1){\nif (firstTerm != secondTerm)\noutColor=colorIfTrue;\nelse\noutColor=colorIfFalse;\n} else if (operation==2){\nif (firstTerm>secondTerm)\noutColor=colorIfTrue;\nelse\noutColor=colorIfFalse;\n} else if (operation==3){\nif (firstTerm>=secondTerm)\noutColor=colorIfTrue;\nelse\noutColor=colorIfFalse;\n} else if (operation==4){\nif (firstTerm<secondTerm)\noutColor=colorIfTrue;\nelse\noutColor=colorIfFalse;\n} else if (operation==5){\nif (firstTerm<=secondTerm)\noutColor=colorIfTrue;\nelse\noutColor=colorIfFalse;\n}\n}",node_contrast_my_frag="float mayaApplyContrast(float value,float contrast,float bias){\nif (value<=0.0){\nreturn 0.0;\n} else {\nfloat xp=log(2.0)/log(clamp(bias,0.00001,0.99999));\nxp=2.0*pow(value,-xp);\nif (xp<=1.0)\nreturn 0.5*pow(xp,contrast);\nelse\nreturn 1.0-(0.5*pow(2.0-xp,contrast));\n}\n}\nvoid node_contrast(vec3 value,vec3 contrast,vec3 bias,out vec3 outColor){\noutColor.x=mayaApplyContrast(value.x,contrast.x,bias.x);\noutColor.y=mayaApplyContrast(value.y,contrast.y,bias.y);\noutColor.z=mayaApplyContrast(value.z,contrast.z,bias.z);\n}",node_decompose_matrix_my_frag="vec4 mat3ToQuat(mat3 m){\nfloat trace=m[0][0]+m[1][1]+m[2][2];\nvec4 q=vec4(0.0,0.0,0.0,0.0);\nif (trace>0.0){\nfloat s=sqrt(trace+1.0)*2.0;\nq.w=0.25*s;\nq.x=(m[2][1]-m[1][2])/s;\nq.y=(m[0][2]-m[2][0])/s;\nq.z=(m[1][0]-m[0][1])/s;\n} else if ((m[0][0]>m[1][1])&&(m[0][0]>m[2][2])){\nfloat s=sqrt(1.0+m[0][0]-m[1][1]-m[2][2])*2.0;\nq.w=(m[2][1]-m[1][2])/s;\nq.x=0.25*s;\nq.y=(m[0][1]+m[1][0])/s;\nq.z=(m[0][2]+m[2][0])/s;\n} else if (m[1][1]>m[2][2]){\nfloat s=sqrt(1.0+m[1][1]-m[0][0]-m[2][2])*2.0;\nq.w=(m[0][2]-m[2][0])/s;\nq.x=(m[0][1]+m[1][0])/s;\nq.y=0.25*s;\nq.z=(m[1][2]+m[2][1])/s;\n} else {\nfloat s=sqrt(1.0+m[2][2]-m[0][0]-m[1][1])*2.0;\nq.w=(m[1][0]-m[0][1])/s;\nq.x=(m[0][2]+m[2][0])/s;\nq.y=(m[1][2]+m[2][1])/s;\nq.z=0.25*s;\n}\nreturn q;\n}\nvec3 mat3ToEuler(mat3 m){\nfloat m11=m[0][0],m12=m[1][0],m13=m[2][0];\nfloat m21=m[0][1],m22=m[1][1],m23=m[2][1];\nfloat m31=m[0][2],m32=m[1][2],m33=m[2][2];\nvec3 euler;\neuler.y=asin(clamp(m13,-1.0,1.0));\nif (abs(m13)<0.9999999){\neuler.x=atan(-m23,m33);\neuler.z=atan(-m12,m11);\n} else {\neuler.x=atan(m32,m22);\neuler.z=0.0;\n}\nreturn euler;\n}\nvoid decomposeMat4(mat4 m,out vec3 position,out vec4 quat,out vec3 euler,out vec3 scale){\nfloat sx=length(vec3(m[0][0],m[0][1],m[0][2]));\nfloat sy=length(vec3(m[1][0],m[1][1],m[1][2]));\nfloat sz=length(vec3(m[2][0],m[2][1],m[2][2]));\nfloat det=mat3GetDeterminant(toMat3(m));\nif (det<0.0)\nsx=-sx;\nposition.x=m[3][0];\nposition.y=m[3][1];\nposition.z=m[3][2];\nfloat invSX=1.0/sx;\nfloat invSY=1.0/sy;\nfloat invSZ=1.0/sz;\nm[0][0]*=invSX;\nm[0][1]*=invSX;\nm[0][2]*=invSX;\nm[1][0]*=invSY;\nm[1][1]*=invSY;\nm[1][2]*=invSY;\nm[2][0]*=invSZ;\nm[2][1]*=invSZ;\nm[2][2]*=invSZ;\nquat=mat3ToQuat(toMat3(m));\neuler=mat3ToEuler(toMat3(m));\nscale.x=sx;\nscale.y=sy;\nscale.z=sz;\n}\nvoid node_decompose_matrix(mat4 inputMatrix,out vec4 outputQuat,out vec3 outputRotate,out vec3 outputScale,out vec3 outputShear,out vec3 outputTranslate)\n{\ndecomposeMat4(inputMatrix,outputTranslate,outputQuat,outputRotate,outputScale);\noutputShear=vec3(0.0,0.0,0.0);\n}",node_env_sphere_my_frag="void node_env_sphere(sampler2D envMap,int encoding,vec3 normal,mat4 placementMatrix,out float outAlpha,out vec3 outColor)\n{\nvec3 cameraToVertex=normalize(vWorldPosition-cameraPosition);\nvec3 reflectVec;\n#if WORLD_NODES\nreflectVec=normalize(cameraToVertex);\n#else\nvec3 worldNormal=inverseTransformDirection(normal,viewMatrix);\nreflectVec=reflect(cameraToVertex,worldNormal);\n#endif\nmat3 uvTransform=mat3(1.0);\nreflectVec=toMat3(placementMatrix)*reflectVec;\nvec4 tex=sampleEquirectangular(envMap,reflectVec,uvTransform,encoding);\noutAlpha=tex.a;\noutColor=tex.rgb;\n}",node_file_my_frag="void node_file(sampler2D ima,const int encoding,const bool rgbToAlpha,vec2 uvCoord,out float outAlpha,out vec3 outColor,out vec2 outSize,out vec3 outTransparency){\nvec2 uv=vec2(uvCoord.x,1.0-uvCoord.y);\nvec4 tex=texture2D(ima,uv);\noutColor=nodeTexelToLinear(tex,encoding).rgb;\nif (rgbToAlpha)\noutAlpha=dot(tex.rgb,LUM_WEIGHTS_MAYA);\nelse\noutAlpha=tex.a;\noutSize=vec2(0.0);\noutTransparency=vec3(1.0-outAlpha,1.0-outAlpha,1.0-outAlpha);\n}",node_float_condition_my_frag="void node_float_condition(bool condition,float floatA,float floatB,out float outFloat){\noutFloat=condition?floatA:floatB;\n}",node_float_composite_my_frag="void node_float_composite(int operation,float floatA,float floatB,float factor,out float outFloat)\n{\nif (factor<=0.0){\noutFloat=floatA;\nreturn;\n}\nif (operation==0){\noutFloat=floatA+(floatB*factor);\n} else if (operation==1){\noutFloat=floatA+((floatB-1.0)*factor);\n} else if (operation==2){\nif (factor>=1.0){\noutFloat=floatB;\nreturn;\n}\noutFloat=mix(floatA,floatB,factor);\n} else if (operation==3){\noutFloat=floatA*(floatB*factor+(1.0-factor));\n} else if (operation==4){\noutFloat=1.0-((1.0-floatA)*(1.0-floatB*factor));\n} else if (operation==5){\noutFloat=floatB>0.5?(2.0*floatA*floatB*factor)+floatA*(1.0-factor):\n1.0-((1.0-floatA)*(1.0-floatB*factor))*(2.0-(1.0-factor));\n} else if (operation==6){\noutFloat=abs(floatA-(floatB*factor));\n} else if (operation==7){\noutFloat=clamp(mix(floatA,floatA/max(1.0-floatB,0.00001),factor),floatA,floatB);\n} else if (operation==8){\noutFloat=clamp(mix(floatA,1.0-(floatA/max(1.0-floatB,0.00001)),factor),floatA,floatB);\n}\n}",node_float_constant_my_frag="void node_float_constant(float value,out float outValue)\n{\noutValue=value;\n}",node_float_logic_my_frag="void node_float_logic(int operation,float floatA,float floatB,out bool outBool){\nif (operation==0){\noutBool=(floatA==floatB);\n} else if (operation==1){\noutBool=(floatA != floatB);\n} else if (operation==2){\noutBool=(floatA<floatB);\n} else if (operation==3){\noutBool=(floatA>floatB);\n} else if (operation==4){\noutBool=(floatA<=floatB);\n} else {\noutBool=(floatA>=floatB);\n}\n}",node_float_mask_my_frag="void node_float_mask(float inFloat,float mask,out float outFloat){\noutFloat=inFloat-mask;\n}",node_float_math_my_frag="void node_float_math(int operation,float floatA,float floatB,out float outFloat){\nif (operation==0){\noutFloat=floatA+floatB;\n} else if (operation==1){\noutFloat=floatA-floatB;\n} else if (operation==2){\noutFloat=floatA*floatB;\n} else if (operation==3){\noutFloat=floatA/floatB;\n} else if (operation==4){\noutFloat=min(floatA,floatB);\n} else if (operation==5){\noutFloat=max(floatA,floatB);\n} else {\noutFloat=pow(floatA,floatB);\n}\n}",node_four_by_four_matrix_my_frag="void node_four_by_four_matrix(float in00,float in01,float in02,float in03,float in10,float in11,float in12,float in13,float in20,float in21,float in22,float in23,float in30,float in31,float in32,float in33,out mat4 outMatrix)\n{\noutMatrix=mat4(in00,in01,in02,in03,in10,in11,in12,in13,in20,in21,in22,in23,in30,in31,in32,in33);\n}",node_gamma_correct_my_frag="void node_gamma_correct(vec3 gamma,vec3 value,out vec3 outValue){\noutValue=pow(value,1.0/gamma);\n}",node_grid_my_frag="void node_grid(float contrast,vec3 fillerColor,vec3 lineColor,float uWidth,float vWidth,vec2 uvCoord,out float outAlpha,out vec3 outColor){\nuvCoord=fract(uvCoord);\nfloat v0=max(uvCoord.y,0.5*vWidth);\nfloat v1=min(uvCoord.y,1.0-0.5*vWidth);\nfloat u0=max(uvCoord.x,0.5*uWidth);\nfloat u1=min(uvCoord.x,1.0-0.5*uWidth);\nfloat gridFactor=(v0<=v1&&u0<=u1)?1.0:0.0;\ngridFactor=0.5-contrast*(gridFactor-0.5);\ngridFactor=max(gridFactor,0.0);\nvec3 gridColor=mix(fillerColor,lineColor,gridFactor);\ngridColor.r=max(gridColor.r,0.0);\ngridColor.g=max(gridColor.g,0.0);\ngridColor.b=max(gridColor.b,0.0);\noutAlpha=saturate(gridFactor);\noutColor=gridColor;\n}",node_inverse_matrix_my_frag="\nmat4 inverseMat4(mat4 m){\nfloat a00=m[0][0],a01=m[0][1],a02=m[0][2],a03=m[0][3],a10=m[1][0],a11=m[1][1],a12=m[1][2],a13=m[1][3],a20=m[2][0],a21=m[2][1],a22=m[2][2],a23=m[2][3],a30=m[3][0],a31=m[3][1],a32=m[3][2],a33=m[3][3];\nfloat b00=a00*a11-a01*a10,b01=a00*a12-a02*a10,b02=a00*a13-a03*a10,b03=a01*a12-a02*a11,b04=a01*a13-a03*a11,b05=a02*a13-a03*a12,b06=a20*a31-a21*a30,b07=a20*a32-a22*a30,b08=a20*a33-a23*a30,b09=a21*a32-a22*a31,b10=a21*a33-a23*a31,b11=a22*a33-a23*a32;\nfloat det=b00*b11-b01*b10+b02*b09+b03*b08-b04*b07+b05*b06;\nreturn mat4(a11*b11-a12*b10+a13*b09,a02*b10-a01*b11-a03*b09,a31*b05-a32*b04+a33*b03,a22*b04-a21*b05-a23*b03,a12*b08-a10*b11-a13*b07,a00*b11-a02*b08+a03*b07,a32*b02-a30*b05-a33*b01,a20*b05-a22*b02+a23*b01,a10*b10-a11*b08+a13*b06,a01*b08-a00*b10-a03*b06,a30*b04-a31*b02+a33*b00,a21*b02-a20*b04-a23*b00,a11*b07-a10*b09-a12*b06,a00*b09-a01*b07+a02*b06,a31*b01-a30*b03-a32*b00,a20*b03-a21*b01+a22*b00)/det;\n}\nvoid node_inverse_matrix(mat4 inputMatrix,out mat4 outputMatrix)\n{\noutputMatrix=inverseMat4(inputMatrix);\n}",node_lambert_my_frag="void node_lambert(vec3 geometryNormal,vec3 color,vec3 ambientColor,vec3 incandescence,float matteOpacity,float diffuse,vec3 normal,float translucence,vec3 transparency,out vec4 outColor){\nNodeMaterial material;\nmaterial.diffuseColor=diffuse*color.rgb;\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\n#ifdef USE_CLEARCOAT\n#undef USE_CLEARCOAT\n#define _CLEARCOAT_RESTORE\n#endif\n#define RE_Direct RE_DirectDiffuseOnly_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#ifdef _CLEARCOAT_RESTORE\n#undef _CLEARCOAT_RESTORE\n#define USE_CLEARCOAT\n#endif\nfloat alpha=1.0-average(transparency);\noutColor=vec4(reflectedLight.directDiffuse+reflectedLight.indirectDiffuse+incandescence,alpha);\n}",node_layered_texture_layer_my_frag="#define LAYER_BLEND_MODE_NONE 0.0\n#define LAYER_BLEND_MODE_OVER 1.0\n#define LAYER_BLEND_MODE_IN 2.0\n#define LAYER_BLEND_MODE_OUT 3.0\n#define LAYER_BLEND_MODE_ADD 4.0\n#define LAYER_BLEND_MODE_SUBTRACT 5.0\n#define LAYER_BLEND_MODE_MULTIPLY 6.0\n#define LAYER_BLEND_MODE_DIFFERENCE 7.0\n#define LAYER_BLEND_MODE_LIGHTEN 8.0\n#define LAYER_BLEND_MODE_DARKEN 9.0\n#define LAYER_BLEND_MODE_SATURATE 10.0\n#define LAYER_BLEND_MODE_DESATURATE 11.0\n#define LAYER_BLEND_MODE_ILLUMINATE 12.0\nvoid node_layered_texture_layer(const float alphaBG,const vec3 colorBG,const vec3 color,const float alpha,const float blendMode,const bool isVisible,out float outAlpha,out vec3 outColor)\n{\noutAlpha=alphaBG;\noutColor=colorBG;\nif (!isVisible)\nreturn;\nif (blendMode==LAYER_BLEND_MODE_NONE){\noutColor=color;\n} else if (blendMode==LAYER_BLEND_MODE_OVER){\noutColor=mix(colorBG,color,alpha);\n} else if (blendMode==LAYER_BLEND_MODE_IN){\noutColor=alpha*colorBG;\n} else if (blendMode==LAYER_BLEND_MODE_OUT){\noutColor=(1.0-alpha)*colorBG;\n} else if (blendMode==LAYER_BLEND_MODE_ADD){\noutColor=mix(colorBG,colorBG+color,alpha);\n} else if (blendMode==LAYER_BLEND_MODE_SUBTRACT){\noutColor=mix(colorBG,colorBG-color,alpha);\n} else if (blendMode==LAYER_BLEND_MODE_MULTIPLY){\noutColor=mix(colorBG,colorBG*color,alpha);\n} else {\noutColor=mix(colorBG,color,alpha);\n}\n}",node_luminance_my_frag="void node_luminance(vec3 value,out float outValue){\noutValue=dot(value,LUM_WEIGHTS_MAYA);\n}",node_multiply_divide_my_frag="void node_multiply_divide(int operation,vec3 input1,vec3 input2,out vec3 outValue){\nif (operation==0){\noutValue=input1;\n} else if (operation==1){\noutValue=input1*input2;\n} else if (operation==2){\n\noutValue=input1/input2;\n} else {\noutValue=pow(input1,input2);\n}\n}",node_mult_double_linear_my_frag="void node_mult_double_linear(float input1,float input2,out float outValue){\noutValue=input1*input2;\n}",node_mult_matrix_my_frag="\nvoid node_mult_matrix(mat4 matrixIn1,out mat4 matrixSum)\n{\nmatrixSum=matrixIn1;\n}\nvoid node_mult_matrix(mat4 matrixIn1,mat4 matrixIn2,out mat4 matrixSum)\n{\nmatrixSum=matrixIn2*matrixIn1;\n}\nvoid node_mult_matrix(mat4 matrixIn1,mat4 matrixIn2,mat4 matrixIn3,out mat4 matrixSum)\n{\nmatrixSum=matrixIn3*matrixIn2*matrixIn1;\n}",node_noise_my_frag="vec2 calcNoiseImplode(float implode,vec2 implodeCenter,vec2 uv){\nif (abs(implode)>=EPSILON){\nuv-=implodeCenter;\nfloat len=length(uv);\nif (len>EPSILON){\nfloat factor=pow(len,1.0-implode)/len;\nuv*=factor;\n}\nuv+=implodeCenter;\n}\nreturn uv;\n}\nvoid node_noise(float amplitude,int depthMax,float frequency,float frequencyRatio,float implode,vec2 implodeCenter,bool inflection,float ratio,float threshold,float time,vec2 uvCoord,out float outAlpha,out vec3 outColor){\nuvCoord=calcNoiseImplode(implode,implodeCenter,uvCoord);\nfrequency*=0.6;\namplitude*=0.9;\nuvCoord*=frequency;\nfloat noiseAccum=0.0;\nvec2 freqOffset=vec2(0.02,0.3);\n#if __VERSION__==300\nfor (int depthId=0;depthId<depthMax;depthId++){\n#else\nfor (int depthId=0;depthId<3;depthId++){\n#endif\nint stepVal=depthId;\nfloat noise=noisePerlin(vec3(uvCoord+freqOffset,time+0.5*float(stepVal)));\nif (inflection)\nnoise=abs(noise);\nnoiseAccum+=amplitude*noise;\nuvCoord*=frequencyRatio;\ntime*=sqrt(frequencyRatio);\namplitude*=ratio;\nfreqOffset+=vec2(0.02,0.3);\n}\nif (!inflection)\nnoiseAccum=0.5*noiseAccum+0.5;\nnoiseAccum+=threshold;\noutAlpha=min(1.0,noiseAccum);\noutColor=vec3(outAlpha,outAlpha,outAlpha);\n}",node_openpbr_surface_my_frag="void node_openpbr_surface(vec3 geometryNormal,const bool thinWalled,const float baseWeight,const vec3 baseColor,const float baseDiffuseRoughness,const float baseMetalness,const float specularWeight,const vec3 specularColor,const float specularRoughness,const float specularIOR,const float transmissionWeight,const vec3 transmissionColor,const float transmissionDepth,const vec3 transmissionScatter,const float fuzzWeight,const vec3 fuzzColor,const float fuzzRoughness,const float coatWeight,const vec3 coatColor,const float coatRoughness,const float emissionLuminance,const vec3 emissionColor,const float geometryOpacity,const vec3 normal,out vec4 outColor)\n{\nNodeMaterial material;\nvec3 baseColorWeighted=baseWeight*baseColor.rgb;\nmaterial.diffuseColor=baseColorWeighted*(1.0-baseMetalness)*(1.0-transmissionWeight);\nvec3 clearcoatNormal=normal;\n#ifdef USE_CLEARCOAT\nmaterial.clearcoat=saturate(coatWeight);\nmaterial.clearcoatRoughness=clamp(coatRoughness,0.0,1.0);\nmaterial.clearcoatF0=vec3(0.04);\nmaterial.clearcoatF90=1.0;\n#endif\n#ifdef USE_SHEEN\nmaterial.sheenColor=saturate(fuzzWeight*fuzzColor);\nmaterial.sheenRoughness=clamp(fuzzRoughness,0.0,1.0);\n#endif\nvec3 dxy=max(abs(dFdx(geometryNormal)),abs(dFdy(geometryNormal)));\nfloat geometryRoughness=max(max(dxy.x,dxy.y),dxy.z);\nmaterial.roughness=max(specularRoughness,0.0525);\nmaterial.roughness+=geometryRoughness;\nmaterial.roughness=min(material.roughness,1.0);\nvec3 specularColorWeighted=specularWeight*specularColor;\nvec3 dielRefl=pow2((1.0-specularIOR)/(1.0+specularIOR))*specularColorWeighted;\nmaterial.specularColor=mix(dielRefl,baseColorWeighted,baseMetalness);\nmaterial.fresnelRefl90=mix(specularColorWeighted,vec3(1.0),baseMetalness);\nmaterial.specularF90=average(material.fresnelRefl90);\nmaterial.refractionColor=pow(transmissionWeight*(1.0-baseMetalness)*transmissionColor.rgb,vec3(2.0));\nmaterial.refractionIOR=specularIOR;\nmaterial.refractionRoughness=material.roughness;\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\nvec3 refractedLight=vec3(0.0);\n#ifdef USE_GTAO\nvec4 gtaoVisibilityBentNormal=texture2D(gtaoMap,gl_FragCoord.xy/currResolution);\nvec3 bentNormal=normalize(unpackRGBToNormal(gtaoVisibilityBentNormal.gba));\n#define PROBE_NORMAL bentNormal\n#endif\n#define RE_Direct RE_Direct_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Node\n#define RE_IndirectSpecular RE_IndirectSpecular_Node\n#define RE_Refraction RE_Refraction_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#undef RE_IndirectSpecular\n#undef RE_Refraction\n#ifdef PROBE_NORMAL\n#undef PROBE_NORMAL\n#endif\n#ifdef USE_GTAO\nreflectedLight.indirectDiffuse*=gtaoVisibilityBentNormal.r;\nfloat gtaoVisibility=gtaoVisibilityBentNormal.r;\nvec3 gtaoBentNormal=bentNormal;\nvec3 gtaoViewDir=geometry.viewDir;\nvec3 gtaoNormal=normal;\nfloat gtaoRoughness=material.roughness;\n#endif\n#include <lights_fragment_gtso>\nvec3 totalEmissiveRadiance=emissionLuminance*OPENPBR_EMISSION_LUM_FACTOR*emissionColor;\nvec3 outSpecular=reflectedLight.directSpecular+reflectedLight.indirectSpecular;\nvec3 outColor3=reflectedLight.directDiffuse+reflectedLight.indirectDiffuse +\noutSpecular+totalEmissiveRadiance;\n#ifdef USE_SHEEN\nfloat sheenEnergyComp=1.0-0.157*max3(material.sheenColor);\noutColor3=outColor3*sheenEnergyComp+sheenSpecular;\n#endif\n#ifdef USE_CLEARCOAT\nfloat dotNVcc=saturate(dot(geometry.normal,geometry.viewDir));\nvec3 Fcc=F_Schlick(material.clearcoatF0,material.clearcoatF90,dotNVcc);\noutColor3=outColor3*(1.0-material.clearcoat*Fcc)+clearcoatSpecular*material.clearcoat;\n#endif\nfloat alpha=1.0;\nif (thinWalled){\nalpha=geometryOpacity*(1.0-saturate(transmissionWeight)+maxFromRGB(outSpecular)*saturate(transmissionWeight));\n} else {\noutColor3+=refractedLight;\n}\noutColor=vec4(outColor3,saturate(alpha));\n}",node_output_my_frag="void node_output(vec4 rgb,out vec4 outgoingLight)\n{\noutgoingLight=rgb;\n}",node_phong_my_frag="void node_phong(vec3 geometryNormal,vec3 color,vec3 ambientColor,vec3 incandescence,float matteOpacity,float diffuse,vec3 normal,float reflectivity,vec3 reflectedColor,float cosinePower,vec3 specularColor,float translucence,vec3 transparency,out vec4 outColor){\nNodeMaterial material;\nmaterial.diffuseColor=diffuse*color;\n#ifdef USE_CLEARCOAT\n#undef USE_CLEARCOAT\n#define _CLEARCOAT_RESTORE\n#endif\nvec3 dxy=max(abs(dFdx(geometryNormal)),abs(dFdy(geometryNormal)));\nfloat geometryRoughness=max(max(dxy.x,dxy.y),dxy.z);\nfloat roughness=sqrt(1.0/(0.454*cosinePower+3.357));\nmaterial.roughness=max(roughness,0.0525);\nmaterial.roughness+=geometryRoughness;\nmaterial.roughness=min(material.roughness,1.0);\nmaterial.specularColor=specularColor;\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\n#define RE_Direct RE_Direct_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Node\n#define RE_IndirectSpecular RE_IndirectSpecular_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#undef RE_IndirectSpecular\n#ifdef _CLEARCOAT_RESTORE\n#undef _CLEARCOAT_RESTORE\n#define USE_CLEARCOAT\n#endif\nfloat alpha=1.0-average(transparency);\noutColor=vec4(reflectedLight.directDiffuse+reflectedLight.indirectDiffuse +\nreflectedLight.directSpecular+reflectedLight.indirectSpecular+incandescence,alpha);\n}",node_phong_e_my_frag="void node_phong_e(vec3 geometryNormal,vec3 color,vec3 ambientColor,vec3 incandescence,float matteOpacity,float diffuse,vec3 normal,float reflectivity,vec3 reflectedColor,float highlightSize,float roughness,vec3 specularColor,float translucence,vec3 transparency,out vec4 outColor){\nNodeMaterial material;\nmaterial.diffuseColor=diffuse*color;\n#ifdef USE_CLEARCOAT\n#undef USE_CLEARCOAT\n#define _CLEARCOAT_RESTORE\n#endif\nvec3 dxy=max(abs(dFdx(geometryNormal)),abs(dFdy(geometryNormal)));\nfloat geometryRoughness=max(max(dxy.x,dxy.y),dxy.z);\nmaterial.roughness=max(roughness,0.0525);\nmaterial.roughness+=geometryRoughness;\nmaterial.roughness=min(material.roughness,1.0);\nmaterial.specularColor=specularColor;\nReflectedLight reflectedLight=ReflectedLight(vec3(0.0),vec3(0.0),vec3(0.0),vec3(0.0));\n#define RE_Direct RE_Direct_Node\n#define RE_IndirectDiffuse RE_IndirectDiffuse_Node\n#define RE_IndirectSpecular RE_IndirectSpecular_Node\n#include <lights_fragment_begin>\n#include <lights_fragment_maps>\n#include <lights_fragment_end>\n#undef RE_Direct\n#undef RE_IndirectDiffuse\n#undef RE_IndirectSpecular\n#ifdef _CLEARCOAT_RESTORE\n#undef _CLEARCOAT_RESTORE\n#define USE_CLEARCOAT\n#endif\nfloat alpha=1.0-average(transparency);\noutColor=vec4(reflectedLight.directDiffuse+reflectedLight.indirectDiffuse +\nreflectedLight.directSpecular+reflectedLight.indirectSpecular+incandescence,alpha);\n}",node_place_2d_texture_my_frag="void node_place_2d_texture(const vec2 inUv,vec2 offset,vec2 repeatUv,float rotateUv,out vec2 outUv)\n{\noutUv=(calcUvTransform(offset.x,offset.y,repeatUv.x,repeatUv.y,rotateUv)*vec3(inUv,1.0)).xy;\noutUv.y=1.0-outUv.y;\n}",node_premultiply_my_frag="void node_premultiply(float inAlpha,vec3 inColor,out float outAlpha,out vec3 outColor){\noutColor=inColor*inAlpha;\noutAlpha=inAlpha;\n}",node_ramp_my_frag="#define RAMP_WRAP_REPEAT 1000\n#define RAMP_WRAP_CLAMP_TO_EDGE 1001\n#define RAMP_WRAP_MIRROR 1002\nfloat applyWrap(float coord,int wrap){\nif (coord<0.0||coord>1.0){\nif (wrap==RAMP_WRAP_REPEAT)\ncoord=mod(coord,1.0);\nelse if (wrap==RAMP_WRAP_CLAMP_TO_EDGE)\ncoord=clamp(coord,0.0,1.0);\nelse if (wrap==RAMP_WRAP_MIRROR){\nif (mod(floor(coord),2.0)==0.0)\ncoord=coord-floor(coord);\nelse\ncoord=1.0-(coord-floor(coord));\n}\n}\nreturn coord;\n}\nvoid node_ramp(sampler2D rampData,int rampType,int wrapU,int wrapV,vec2 uvCoord,out float outAlpha,out vec3 outColor)\n{\nuvCoord.x=applyWrap(uvCoord.x,wrapU);\nuvCoord.y=applyWrap(uvCoord.y,wrapV);\nfloat coord;\nif (rampType==0){\ncoord=uvCoord.y;\n} else if (rampType==1){\ncoord=uvCoord.x;\n} else if (rampType==2){\ncoord=abs(uvCoord.x+uvCoord.y)/2.0;\n} else if (rampType==3){\nvec2 uvSpiral=mat2(0.0,1.0,1.0,0.0)*(uvCoord-vec2(0.5));\ncoord=atan(uvSpiral.y,uvSpiral.x)/PI2+0.5;\n} else if (rampType==4){\ncoord=length(uvCoord-vec2(0.5))*sqrt(2.0);\n} else if (rampType==5){\nvec2 boxUv=abs(uvCoord-vec2(0.5))*2.0;\ncoord=max(boxUv.x,boxUv.y);\n} else if (rampType==6){\nuvCoord=abs((uvCoord-vec2(0.5))*2.0);\ncoord=uvCoord.y;\n} else if (rampType==7){\ncoord=uvCoord.y;\n} else {\ncoord=uvCoord.y;\n}\nfloat offset=0.5/float(RAMP_TEX_SIZE);\nfloat scale=1.0-(1.0/float(RAMP_TEX_SIZE));\ncoord=coord*scale+offset;\nvec4 tex=texture2D(rampData,vec2(coord,0.0));\noutAlpha=average(tex.xyz);\noutColor=tex.xyz;\n}",node_remap_hsv_my_frag="void node_remap_hsv(vec3 color,out vec3 outColor)\n{\noutColor=color;\n}",node_reverse_my_frag="void node_reverse(vec3 inValue,out vec3 outValue){\noutValue=1.0-inValue;\n}",node_sampler_info_my_frag="void node_sampler_info(float frontFacing,vec4 tangent,vec2 uv,vec3 viewNorm,out float facingRatio,out bool flippedNormal,out mat4 matrixEyeToWorld,out vec3 normalCamera,out vec2 pixelCenter,out vec3 pointCamera,out vec3 pointObj,out vec3 pointWorld,out vec3 tangentUCamera,out vec3 tangentVCamera,out vec2 uvCoord)\n{\nvec4 worldPos=invViewMatrix*vec4(-vViewPosition,1.0);\nfacingRatio=dot(normalize(viewNorm),normalize(vViewPosition));\nflippedNormal=(frontFacing>0.0);\nmatrixEyeToWorld=invViewMatrix;\nnormalCamera=viewNorm;\npixelCenter=vec2(1.0);\npointCamera=-vViewPosition*UNITS_SCALE_FACTOR;\npointObj=(invModelMatrix*worldPos).xyz*UNITS_SCALE_FACTOR;\npointWorld=worldPos.xyz*UNITS_SCALE_FACTOR;\ntangentUCamera=normalize((modelViewMatrix*vec4(tangent.xyz,0.0)).xyz);\ntangentVCamera=tangent.w*cross(viewNorm,tangentUCamera);\nuvCoord=vec2(uv.x,1.0-uv.y);\n}",node_set_range_my_frag="void node_set_range(vec3 maxValue,vec3 minValue,vec3 oldMax,vec3 oldMin,vec3 value,out vec3 outValue){\noutValue=minValue+(((value-oldMin)/(oldMax-oldMin))*(maxValue-minValue));\n}",node_shading_engine_my_frag="void node_shading_engine(vec4 surface,vec4 volume,vec3 displacement,out vec4 outgoingLight){\noutgoingLight=surface+volume;\n}",node_sub_transform_my_frag="#define COORD_WORLD_SPACE 0\n#define COORD_OBJECT_SPACE 1\nvoid node_sub_transform(const int coordSpace,vec3 scale,vec3 rotate,vec3 offset,out vec3 outVector,out vec3 outNormal)\n{\nvec3 norm=vNormal;\nnorm=(invViewMatrix*vec4(norm,0.0)).xyz;\nvec3 vector=vWorldPosition.xyz;\nif (coordSpace==COORD_OBJECT_SPACE){\nvector=(invModelMatrix*vec4(vector,1.0)).xyz;\nnorm=(invModelMatrix*vec4(norm,0.0)).xyz;\n}\nvector-=offset;\nvector*=scale;\nmat3 rotX=mat3RotateX(radians(rotate.x));\nmat3 rotY=mat3RotateY(radians(-rotate.y));\nmat3 rotZ=mat3RotateZ(radians(rotate.z));\nmat3 rotMat=rotX*rotY*rotZ;\nvector=rotMat*vector;\nnorm=rotMat*norm;\noutVector=vector;\noutNormal=normalize(norm);\n}",node_surface_shader_my_frag="void node_surface_shader(vec3 color,vec3 glowColor,vec3 matteOpacity,vec3 transparency,out vec4 outColor,out vec3 outGlowColor,out vec3 outMatteOpacity,out vec3 outTransparency)\n{\noutColor=vec4(color,saturate(1.0-average(transparency)));\noutGlowColor=glowColor;\noutMatteOpacity=matteOpacity;\noutTransparency=transparency;\n}\nvoid node_surface_shader(vec3 color,vec3 glowColor,vec3 matteOpacity,vec3 transparency,out vec3 outColor,out vec3 outGlowColor,out vec3 outMatteOpacity,out vec3 outTransparency)\n{\noutColor=color;\noutGlowColor=glowColor;\noutMatteOpacity=matteOpacity;\noutTransparency=transparency;\n}",node_transform_my_frag="void node_transform(out vec3 center,out mat4 inverseMatrix,out mat4 matrix,out mat4 parentInverseMatrix,out mat4 parentMatrix,out mat4 worldInverseMatrix,out mat4 worldMatrix,out mat4 xformMatrix)\n{\ncenter=modelMatrix[3].xyz;\ninverseMatrix=invModelMatrix;\nmatrix=modelMatrix;\nparentInverseMatrix=mat4(1.0);\nparentMatrix=mat4(1.0);\nworldInverseMatrix=invModelMatrix;\nworldMatrix=modelMatrix;\nxformMatrix=matrix;\n}",node_transpose_matrix_my_frag="mat4 transposeMat4(mat4 m){\nreturn mat4(vec4(m[0].x,m[1].x,m[2].x,m[3].x),vec4(m[0].y,m[1].y,m[2].y,m[3].y),vec4(m[0].z,m[1].z,m[2].z,m[3].z),vec4(m[0].w,m[1].w,m[2].w,m[3].w));\n}\nvoid node_transpose_matrix(mat4 inputMatrix,out mat4 outputMatrix)\n{\noutputMatrix=transposeMat4(inputMatrix);\n}",node_unit_conversion_my_frag="void node_unit_conversion(float conversionFactor,float inInput,out float outOutput)\n{\noutOutput=conversionFactor*inInput;\n}\nvoid node_unit_conversion(float conversionFactor,vec3 inInput,out vec3 outOutput)\n{\noutOutput=conversionFactor*inInput;\n}",node_unpremultiply_my_frag="void node_unpremultiply(float inAlpha,vec3 inColor,out float outAlpha,out vec3 outColor){\noutColor=inColor/inAlpha;\noutAlpha=inAlpha;\n}",node_vector_product_my_frag="void node_vector_product(const int operation,const bool normalizeOutput,vec3 input1,vec3 input2,mat4 matrix,out vec3 outVector){\nif (operation==0){\noutVector=input1;\n} else if (operation==1){\nif (normalizeOutput){\ninput1=normalize(input1);\ninput2=normalize(input2);\n}\noutVector=vec3(dot(input1,input2));\n} else if (operation==2){\noutVector=cross(input1,input2);\n} else if (operation==3){\noutVector=(matrix*vec4(input1,0.0)).xyz;\n} else {\noutVector=(matrix*vec4(input1,1.0)).xyz;\n}\n\nif (operation>1&&normalizeOutput)\noutVector=normalize(outVector);\n}",node_wt_add_matrix_my_frag="void node_wt_add_matrix(mat4 matrixIn1,float weightIn1,out mat4 matrixSum)\n{\nmatrixSum=weightIn1*matrixIn1;\n}\nvoid node_wt_add_matrix(mat4 matrixIn1,float weightIn1,mat4 matrixIn2,float weightIn2,out mat4 matrixSum)\n{\nmatrixSum=weightIn1*matrixIn1+weightIn2*matrixIn2;\n}\nvoid node_wt_add_matrix(mat4 matrixIn1,float weightIn1,mat4 matrixIn2,float weightIn2,mat4 matrixIn3,float weightIn3,out mat4 matrixSum)\n{\nmatrixSum=weightIn1*matrixIn1+weightIn2*matrixIn2+weightIn3*matrixIn3;\n}",pmrem_common_vert="precision mediump float;\nprecision mediump int;\nattribute vec3 position;\nattribute vec2 uv;\nattribute float faceIndex;\nvarying vec3 vOutputDirection;\nvec3 getDirection(vec2 uv,float face){\nuv=2.0*uv-1.0;\nvec3 direction=vec3(uv,1.0);\nif (face==0.0){\ndirection=direction.zyx;\ndirection.z*=-1.0;\n} else if (face==1.0){\ndirection=direction.xzy;\ndirection.z*=-1.0;\n} else if (face==3.0){\ndirection=direction.zyx;\ndirection.x*=-1.0;\n} else if (face==4.0){\ndirection=direction.xzy;\ndirection.y*=-1.0;\n} else if (face==5.0){\ndirection.xz*=-1.0;\n}\nreturn direction;\n}\nvoid main(){\nvOutputDirection=getDirection(uv,faceIndex);\ngl_Position=vec4(position,1.0);\n}",pmrem_blur_frag="precision highp float;\nprecision highp int;\nvarying vec3 vOutputDirection;\nuniform sampler2D envMap;\nuniform int samples;\nuniform float weights[n];\nuniform bool latitudinal;\nuniform float dTheta;\nuniform float lodIdx;\nuniform vec3 poleAxis;\n#define ENVMAP_TYPE_CUBE_UV\n#include <cube_uv_reflection_fragment>\nvec3 getSample(float theta,vec3 axis){\nfloat cosTheta=cos(theta);\nvec3 sampleDirection=vOutputDirection*cosTheta\n+ cross(axis,vOutputDirection)*sin(theta)\n+ axis*dot(axis,vOutputDirection)*(1.0-cosTheta);\nreturn bilinearCubeUV(envMap,sampleDirection,lodIdx);\n}\nvoid main(){\nvec3 axis=latitudinal?poleAxis:cross(poleAxis,vOutputDirection);\nif (all(equal(axis,vec3(0.0)))){\naxis=vec3(vOutputDirection.z,0.0,-vOutputDirection.x);\n}\naxis=normalize(axis);\ngl_FragColor=vec4(0.0);\ngl_FragColor.rgb+=weights[0]*getSample(0.0,axis);\nfor (int i=1;i<n;i++){\nif (i>=samples){\nbreak;\n}\nfloat theta=dTheta*float(i);\ngl_FragColor.rgb+=weights[i]*getSample(-1.0*theta,axis);\ngl_FragColor.rgb+=weights[i]*getSample(theta,axis);\n}\n}",pmrem_cubemap_frag="precision mediump float;\nprecision mediump int;\nuniform bool flipCubemapX;\nuniform samplerCube envMap;\nvarying vec3 vOutputDirection;\nvoid main(){\ngl_FragColor=textureCube(envMap,vec3(vOutputDirection.x*(flipCubemapX?-1.0:1.0),vOutputDirection.yz));\n}",pmrem_equirect_frag="precision mediump float;\nprecision mediump int;\nvarying vec3 vOutputDirection;\nuniform sampler2D envMap;\nuniform vec2 texelSize;\n#define RECIPROCAL_PI 0.31830988618\n#define RECIPROCAL_PI2 0.15915494\nvoid main(){\ngl_FragColor=vec4(0.0);\nvec3 outputDirection=normalize(vOutputDirection);\nvec2 uv;\nuv.y=asin(clamp(outputDirection.y,-1.0,1.0))*RECIPROCAL_PI+0.5;\nuv.x=atan(outputDirection.z,outputDirection.x)*RECIPROCAL_PI2+0.5;\nvec2 f=fract(uv/texelSize-0.5);\nuv-=f*texelSize;\nvec3 tl=texture2D(envMap,uv).rgb;\nuv.x+=texelSize.x;\nvec3 tr=texture2D(envMap,uv).rgb;\nuv.y+=texelSize.y;\nvec3 br=texture2D(envMap,uv).rgb;\nuv.x-=texelSize.x;\nvec3 bl=texture2D(envMap,uv).rgb;\nvec3 tm=mix(tl,tr,f.x);\nvec3 bm=mix(bl,br,f.x);\ngl_FragColor.rgb=mix(tm,bm,f.y);\n}",pp_plane_vert="varying vec2 vUv;\nvoid main(){\nvUv=uv;\ngl_Position=projectionMatrix*modelViewMatrix*vec4(position,1.0);\n}",pp_oit_weighted_frag="varying vec2 vUv;\nuniform sampler2D tRGBABuffer;\nuniform sampler2D tFloatBuffer;\nvoid main(){\nvec4 color=texture(tRGBABuffer,vUv);\nvec3 colorSum=color.rgb;\nfloat alphaProduct=color.a;\nfloat alphaSum=texture(tFloatBuffer,vUv).r;\ngl_FragColor=vec4(colorSum.rgb/max(alphaSum,1e-5),1.0-alphaProduct);\n}",pp_afterimage_frag="uniform float damp;\nuniform sampler2D tOld;\nuniform sampler2D tNew;\nvarying vec2 vUv;\nvec4 when_gt(vec4 x,float y){\nreturn max(sign(x-y),0.0);\n}\nvoid main(){\nvec4 texelOld=texture(tOld,vUv);\nvec4 texelNew=texture(tNew,vUv);\n\ntexelOld*=damp*when_gt(texelOld,0.1);\ngl_FragColor=max(texelNew,texelOld);\n}",pp_bloom_composite_frag="varying vec2 vUv;\nuniform sampler2D blurTexture1;\nuniform sampler2D blurTexture2;\nuniform sampler2D blurTexture3;\nuniform sampler2D blurTexture4;\nuniform sampler2D blurTexture5;\nuniform sampler2D dirtTexture;\nuniform float bloomStrength;\nuniform float bloomRadius;\nuniform float bloomFactors[NUM_MIPS];\nuniform vec3 bloomTintColors[NUM_MIPS];\nfloat lerpBloomFactor(const in float factor){\nfloat mirrorFactor=1.2-factor;\nreturn mix(factor,mirrorFactor,bloomRadius);\n}\nvoid main(){\ngl_FragColor=bloomStrength*(lerpBloomFactor(bloomFactors[0])*vec4(bloomTintColors[0],1.0)*texture(blurTexture1,vUv)+\nlerpBloomFactor(bloomFactors[1])*vec4(bloomTintColors[1],1.0)*texture(blurTexture2,vUv)+\nlerpBloomFactor(bloomFactors[2])*vec4(bloomTintColors[2],1.0)*texture(blurTexture3,vUv)+\nlerpBloomFactor(bloomFactors[3])*vec4(bloomTintColors[3],1.0)*texture(blurTexture4,vUv)+\nlerpBloomFactor(bloomFactors[4])*vec4(bloomTintColors[4],1.0)*texture(blurTexture5,vUv)\n);\n}",pp_bloom_lum_high_pass_frag="uniform sampler2D tDiffuse;\nuniform vec3 defaultColor;\nuniform float defaultOpacity;\nuniform float luminosityThreshold;\nuniform float smoothWidth;\nvarying vec2 vUv;\nvoid main(){\nvec4 texel=texture(tDiffuse,vUv);\nvec3 luma=vec3(0.299,0.587,0.114);\nfloat v=dot(texel.xyz,luma);\nvec4 outputColor=vec4(defaultColor.rgb,defaultOpacity);\nfloat alpha=smoothstep(luminosityThreshold,luminosityThreshold+smoothWidth,v);\ngl_FragColor=mix(outputColor,texel,alpha);\ngl_FragColor=clamp(gl_FragColor,0.0,10.0);\n}",pp_bloom_separable_blur_frag="#include <common>\nvarying vec2 vUv;\nuniform sampler2D colorTexture;\nuniform vec2 texSize;\nuniform vec2 direction;\nuniform int kernelRadius;\nuniform float sigma;\nfloat gaussianPdf(const float x,const float sigma){\nreturn 0.39894*exp(-0.5*x*x/(sigma*sigma))/sigma;\n}\nvoid main(){\nvec2 invSize=1.0/texSize;\nfloat weightSum=gaussianPdf(0.0,sigma);\nvec3 diffuseSum=texture(colorTexture,vUv).rgb*weightSum;\nfor (int i=1;i<kernelRadius;i++){\nfloat x=float(i);\nfloat w=gaussianPdf(x,sigma);\nvec2 uvOffset=direction*invSize*x;\nvec3 sample1=texture(colorTexture,vUv+uvOffset).rgb;\nvec3 sample2=texture(colorTexture,vUv-uvOffset).rgb;\ndiffuseSum+=(sample1+sample2)*w;\nweightSum+=2.0*w;\n}\ngl_FragColor=vec4(diffuseSum/weightSum,1.0);\n}",pp_blur_frag="#include <common>\nvarying vec2 vUv;\nuniform sampler2D colorTexture;\nuniform vec2 texSize;\nuniform vec2 direction;\nuniform float kernelRadius;\nfloat gaussianPdf(in float x,in float sigma){\nreturn 0.39894*exp(-0.5*x*x/(sigma*sigma))/sigma;\n}\nvoid main(){\nvec2 invSize=1.0/texSize;\nfloat weightSum=gaussianPdf(0.0,kernelRadius);\n#if LOG_SPACE==1\nfloat origDiffuse=texture2D(colorTexture,vUv).r;\nfloat diffuseSum=weightSum;\n#else\nfloat diffuseSum=texture2D(colorTexture,vUv).r*weightSum;\n#endif\nvec2 delta=direction*invSize*kernelRadius/float(MAX_SAMPLE_RADIUS);\nvec2 uvOffset=delta;\n#if OCTAHEDRAL_MAP==1\nvec3 cubeDir=normalize(octUVToCubeVec(vUv,invSize));\nvec3 dirX=normalize(abs(cubeDir.y)<0.99999?vec3(cubeDir.z,0.0,-cubeDir.x)\n: vec3(0.0,-cubeDir.z,cubeDir.y));\nvec3 dirY=cross(cubeDir,dirX);\n#endif\n#pragma unroll_loop\nfor (int i=1;i<=MAX_SAMPLE_RADIUS;i++){\nfloat w=gaussianPdf(uvOffset.x,kernelRadius);\n#if OCTAHEDRAL_MAP==1\nvec3 cubeOffset=uvOffset.x*dirX+uvOffset.y*dirY;\nvec2 uv1=cubeVecToOctUV(cubeDir+cubeOffset,invSize);\nvec2 uv2=cubeVecToOctUV(cubeDir-cubeOffset,invSize);\n#else\nvec2 uv1=vUv+uvOffset;\nvec2 uv2=vUv-uvOffset;\n#endif\nfloat sample1=texture2D(colorTexture,uv1).r;\nfloat sample2=texture2D(colorTexture,uv2).r;\n#if LOG_SPACE==1\ndiffuseSum+=(clamp(exp(sample1-origDiffuse),0.0,1e38)+\nclamp(exp(sample2-origDiffuse),0.0,1e38)\n)*w;\n#else\ndiffuseSum+=((sample1+sample2)*w);\n#endif\nweightSum+=2.0*w;\nuvOffset+=delta;\n}\n#if LOG_SPACE==1\ngl_FragColor=vec4(origDiffuse+log(diffuseSum/weightSum),0.0,0.0,1.0);\n#else\ngl_FragColor=vec4(diffuseSum/weightSum,0.0,0.0,1.0);\n#endif\n}",pp_bokeh_frag="#include <common>\nvarying vec2 vUv;\nuniform sampler2D tColor;\nuniform sampler2D tDepth;\nuniform float maxblur;\nuniform float aperture;\nuniform float nearClip;\nuniform float farClip;\nuniform float focus;\nuniform float aspect;\nuniform float depthLeakThreshold;\n#include <packing>\nfloat getDepth(const in vec2 screenPosition){\n#if DEPTH_PACKING==1\nreturn unpackRGBAToDepth(texture(tDepth,screenPosition));\n#else\nreturn texture(tDepth,screenPosition).x;\n#endif\n}\nfloat getViewZ(const in float depth){\n#if PERSPECTIVE_CAMERA==1\nreturn perspectiveDepthToViewZ(depth,nearClip,farClip);\n#else\nreturn orthoDepthToViewZ(depth,nearClip,farClip);\n#endif\n}\nvec4 blurSample(vec2 uvOffset,vec4 centerCol,float viewZCenter){\nfloat viewZ=-getViewZ(getDepth(vUv+uvOffset));\nfloat blurFactor=(viewZ>=viewZCenter)?1.0:\nmin(depthLeakThreshold*abs((focus-viewZ)/aperture),1.0);\nreturn mix(centerCol,texture(tColor,vUv+uvOffset),blurFactor);\n}\nvoid main(){\nvec2 aspectcorrect=vec2(1.0,aspect);\nfloat viewZ=-getViewZ(getDepth(vUv));\nfloat factor=abs(focus-viewZ);\n\nfloat dofblur=maxblur*min(factor/aperture,1.0);\nfloat dofblur9=dofblur*0.9;\nfloat dofblur7=dofblur*0.7;\nfloat dofblur4=dofblur*0.4;\nvec4 centerCol=texture(tColor,vUv);\nvec4 col=centerCol;\ncol+=blurSample((vec2( 0.0,0.4 )*aspectcorrect)*dofblur,centerCol,viewZ);\ncol+=blurSample((vec2( 0.15,0.37)*aspectcorrect)*dofblur,centerCol,viewZ);\ncol+=blurSample((vec2( 0.29,0.29)*aspectcorrect)*dofblur,centerCol,viewZ);\ncol+=blurSample((vec2(-0.37,0.15)*aspectcorrect)*dofblur,centerCol,viewZ);\ncol+=blurSample((vec2( 0.40,0.0 )*aspectcorrect)*dofblur,centerCol,viewZ);\ncol+=blurSample((vec2( 0.37,-0.15)*aspectcorrect)*dofblur,centerCol,viewZ);\ncol+=blurSample((vec2( 0.29,-0.29)*aspectcorrect)*dofblur,centerCol,viewZ);\ncol+=blurSample((vec2(-0.15,-0.37)*aspectcorrect)*dofblur,centerCol,viewZ);\ncol+=blurSample((vec2( 0.0,-0.4 )*aspectcorrect)*dofblur,centerCol,viewZ);\ncol+=blurSample((vec2(-0.15,0.37)*aspectcorrect)*dofblur,centerCol,viewZ);\ncol+=blurSample((vec2(-0.29,0.29)*aspectcorrect)*dofblur,centerCol,viewZ);\ncol+=blurSample((vec2( 0.37,0.15)*aspectcorrect)*dofblur,centerCol,viewZ);\ncol+=blurSample((vec2(-0.4,0.0 )*aspectcorrect)*dofblur,centerCol,viewZ);\ncol+=blurSample((vec2(-0.37,-0.15)*aspectcorrect)*dofblur,centerCol,viewZ);\ncol+=blurSample((vec2(-0.29,-0.29)*aspectcorrect)*dofblur,centerCol,viewZ);\ncol+=blurSample((vec2( 0.15,-0.37)*aspectcorrect)*dofblur,centerCol,viewZ);\n\ncol+=blurSample((vec2( 0.15,0.37)*aspectcorrect)*dofblur9,centerCol,viewZ);\ncol+=blurSample((vec2(-0.37,0.15)*aspectcorrect)*dofblur9,centerCol,viewZ);\ncol+=blurSample((vec2( 0.37,-0.15)*aspectcorrect)*dofblur9,centerCol,viewZ);\ncol+=blurSample((vec2(-0.15,-0.37)*aspectcorrect)*dofblur9,centerCol,viewZ);\ncol+=blurSample((vec2(-0.15,0.37)*aspectcorrect)*dofblur9,centerCol,viewZ);\ncol+=blurSample((vec2( 0.37,0.15)*aspectcorrect)*dofblur9,centerCol,viewZ);\ncol+=blurSample((vec2(-0.37,-0.15)*aspectcorrect)*dofblur9,centerCol,viewZ);\ncol+=blurSample((vec2( 0.15,-0.37)*aspectcorrect)*dofblur9,centerCol,viewZ);\n\ncol+=blurSample((vec2( 0.29,0.29)*aspectcorrect)*dofblur7,centerCol,viewZ);\ncol+=blurSample((vec2( 0.40,0.0 )*aspectcorrect)*dofblur7,centerCol,viewZ);\ncol+=blurSample((vec2( 0.29,-0.29)*aspectcorrect)*dofblur7,centerCol,viewZ);\ncol+=blurSample((vec2( 0.0,-0.4 )*aspectcorrect)*dofblur7,centerCol,viewZ);\ncol+=blurSample((vec2(-0.29,0.29)*aspectcorrect)*dofblur7,centerCol,viewZ);\ncol+=blurSample((vec2(-0.4,0.0 )*aspectcorrect)*dofblur7,centerCol,viewZ);\ncol+=blurSample((vec2(-0.29,-0.29)*aspectcorrect)*dofblur7,centerCol,viewZ);\ncol+=blurSample((vec2( 0.0,0.4 )*aspectcorrect)*dofblur7,centerCol,viewZ);\n\ncol+=blurSample((vec2( 0.29,0.29)*aspectcorrect)*dofblur4,centerCol,viewZ);\ncol+=blurSample((vec2( 0.4,0.0 )*aspectcorrect)*dofblur4,centerCol,viewZ);\ncol+=blurSample((vec2( 0.29,-0.29)*aspectcorrect)*dofblur4,centerCol,viewZ);\ncol+=blurSample((vec2( 0.0,-0.4 )*aspectcorrect)*dofblur4,centerCol,viewZ);\ncol+=blurSample((vec2(-0.29,0.29)*aspectcorrect)*dofblur4,centerCol,viewZ);\ncol+=blurSample((vec2(-0.4,0.0 )*aspectcorrect)*dofblur4,centerCol,viewZ);\ncol+=blurSample((vec2(-0.29,-0.29)*aspectcorrect)*dofblur4,centerCol,viewZ);\ncol+=blurSample((vec2( 0.0,0.4 )*aspectcorrect)*dofblur4,centerCol,viewZ);\ngl_FragColor=col/41.0;\ngl_FragColor.a=centerCol.a;\n}",pp_brightness_contrast_frag="\nuniform sampler2D tDiffuse;\nuniform float brightness;\nuniform float contrast;\nvarying vec2 vUv;\nvoid main(){\nvec4 texel=texture(tDiffuse,vUv);\ntexel.rgb+=brightness;\nif (contrast>0.0)\ntexel.rgb=(texel.rgb-0.5)/(1.0-contrast)+0.5;\nelse\ntexel.rgb=(texel.rgb-0.5)*(1.0+contrast)+0.5;\ngl_FragColor=texel;\n}",pp_copy_frag="uniform sampler2D tDiffuse;\nuniform float opacity;\nvarying vec2 vUv;\nvoid main(){\nvec4 texel=(texture2D(tDiffuse,vUv));\ngl_FragColor=opacity*texel;\n}",pp_cube_octahedral_proj_frag="#include <common>\nuniform samplerCube tCube;\nuniform vec2 texelSize;\nvarying vec2 vUv;\nvoid main(){\ngl_FragColor=textureCube(tCube,octUVToCubeVec(gl_FragCoord.xy*texelSize,texelSize));\n}",pp_fxaa_frag="\nprecision highp float;\nuniform sampler2D tDiffuse;\nuniform vec2 resolution;\nin vec2 vUv;\n#define FXAA_QUALITY_PS 5\n#define FXAA_QUALITY_P0 1.0\n#define FXAA_QUALITY_P1 1.5\n#define FXAA_QUALITY_P2 2.0\n#define FXAA_QUALITY_P3 4.0\n#define FXAA_QUALITY_P4 12.0\n#define FxaaTexTop(t,p)textureLod(t,p,0.0)\n#define FxaaTexOff(t,p,o,r)textureLodOffset(t,p,0.0,o)\nfloat FxaaLuma(vec4 rgba){return rgba.y;}\nvec4 FxaaPixelShader(vec2 pos,sampler2D tex,vec2 fxaaQualityRcpFrame,float fxaaQualitySubpix,float fxaaQualityEdgeThreshold,float fxaaQualityEdgeThresholdMin\n){\nvec2 posM;\nposM.x=pos.x;\nposM.y=pos.y;\nvec4 rgbyM=FxaaTexTop(tex,posM);\n#define lumaM rgbyM.y\nfloat lumaS=FxaaLuma(FxaaTexOff(tex,posM,ivec2(0,1),fxaaQualityRcpFrame.xy));\nfloat lumaE=FxaaLuma(FxaaTexOff(tex,posM,ivec2(1,0),fxaaQualityRcpFrame.xy));\nfloat lumaN=FxaaLuma(FxaaTexOff(tex,posM,ivec2(0,-1),fxaaQualityRcpFrame.xy));\nfloat lumaW=FxaaLuma(FxaaTexOff(tex,posM,ivec2(-1,0),fxaaQualityRcpFrame.xy));\nfloat maxSM=max(lumaS,lumaM);\nfloat minSM=min(lumaS,lumaM);\nfloat maxESM=max(lumaE,maxSM);\nfloat minESM=min(lumaE,minSM);\nfloat maxWN=max(lumaN,lumaW);\nfloat minWN=min(lumaN,lumaW);\nfloat rangeMax=max(maxWN,maxESM);\nfloat rangeMin=min(minWN,minESM);\nfloat rangeMaxScaled=rangeMax*fxaaQualityEdgeThreshold;\nfloat range=rangeMax-rangeMin;\nfloat rangeMaxClamped=max(fxaaQualityEdgeThresholdMin,rangeMaxScaled);\nbool earlyExit=range<rangeMaxClamped;\nif (earlyExit)\nreturn rgbyM;\nfloat lumaNW=FxaaLuma(FxaaTexOff(tex,posM,ivec2(-1,-1),fxaaQualityRcpFrame.xy));\nfloat lumaSE=FxaaLuma(FxaaTexOff(tex,posM,ivec2(1,1),fxaaQualityRcpFrame.xy));\nfloat lumaNE=FxaaLuma(FxaaTexOff(tex,posM,ivec2(1,-1),fxaaQualityRcpFrame.xy));\nfloat lumaSW=FxaaLuma(FxaaTexOff(tex,posM,ivec2(-1,1),fxaaQualityRcpFrame.xy));\nfloat lumaNS=lumaN+lumaS;\nfloat lumaWE=lumaW+lumaE;\nfloat subpixRcpRange=1.0/range;\nfloat subpixNSWE=lumaNS+lumaWE;\nfloat edgeHorz1=(-2.0*lumaM)+lumaNS;\nfloat edgeVert1=(-2.0*lumaM)+lumaWE;\nfloat lumaNESE=lumaNE+lumaSE;\nfloat lumaNWNE=lumaNW+lumaNE;\nfloat edgeHorz2=(-2.0*lumaE)+lumaNESE;\nfloat edgeVert2=(-2.0*lumaN)+lumaNWNE;\nfloat lumaNWSW=lumaNW+lumaSW;\nfloat lumaSWSE=lumaSW+lumaSE;\nfloat edgeHorz4=(abs(edgeHorz1)*2.0)+abs(edgeHorz2);\nfloat edgeVert4=(abs(edgeVert1)*2.0)+abs(edgeVert2);\nfloat edgeHorz3=(-2.0*lumaW)+lumaNWSW;\nfloat edgeVert3=(-2.0*lumaS)+lumaSWSE;\nfloat edgeHorz=abs(edgeHorz3)+edgeHorz4;\nfloat edgeVert=abs(edgeVert3)+edgeVert4;\nfloat subpixNWSWNESE=lumaNWSW+lumaNESE;\nfloat lengthSign=fxaaQualityRcpFrame.x;\nbool horzSpan=edgeHorz>=edgeVert;\nfloat subpixA=subpixNSWE*2.0+subpixNWSWNESE;\nif (!horzSpan)lumaN=lumaW;\nif (!horzSpan)lumaS=lumaE;\nif (horzSpan)lengthSign=fxaaQualityRcpFrame.y;\nfloat subpixB=(subpixA*(1.0/12.0))-lumaM;\nfloat gradientN=lumaN-lumaM;\nfloat gradientS=lumaS-lumaM;\nfloat lumaNN=lumaN+lumaM;\nfloat lumaSS=lumaS+lumaM;\nbool pairN=abs(gradientN)>=abs(gradientS);\nfloat gradient=max(abs(gradientN),abs(gradientS));\nif (pairN)lengthSign=-lengthSign;\nfloat subpixC=clamp(abs(subpixB)*subpixRcpRange,0.0,1.0);\nvec2 posB;\nposB.x=posM.x;\nposB.y=posM.y;\nvec2 offNP;\noffNP.x=(!horzSpan)?0.0:fxaaQualityRcpFrame.x;\noffNP.y=(horzSpan)?0.0:fxaaQualityRcpFrame.y;\nif (!horzSpan)posB.x+=lengthSign*0.5;\nif (horzSpan)posB.y+=lengthSign*0.5;\nvec2 posN;\nposN.x=posB.x-offNP.x*FXAA_QUALITY_P0;\nposN.y=posB.y-offNP.y*FXAA_QUALITY_P0;\nvec2 posP;\nposP.x=posB.x+offNP.x*FXAA_QUALITY_P0;\nposP.y=posB.y+offNP.y*FXAA_QUALITY_P0;\nfloat subpixD=((-2.0)*subpixC)+3.0;\nfloat lumaEndN=FxaaLuma(FxaaTexTop(tex,posN));\nfloat subpixE=subpixC*subpixC;\nfloat lumaEndP=FxaaLuma(FxaaTexTop(tex,posP));\nif (!pairN)lumaNN=lumaSS;\nfloat gradientScaled=gradient*1.0/4.0;\nfloat lumaMM=lumaM-lumaNN*0.5;\nfloat subpixF=subpixD*subpixE;\nbool lumaMLTZero=lumaMM<0.0;\nlumaEndN-=lumaNN*0.5;\nlumaEndP-=lumaNN*0.5;\nbool doneN=abs(lumaEndN)>=gradientScaled;\nbool doneP=abs(lumaEndP)>=gradientScaled;\nif (!doneN)posN.x-=offNP.x*FXAA_QUALITY_P1;\nif (!doneN)posN.y-=offNP.y*FXAA_QUALITY_P1;\nbool doneNP=(!doneN)||(!doneP);\nif (!doneP)posP.x+=offNP.x*FXAA_QUALITY_P1;\nif (!doneP)posP.y+=offNP.y*FXAA_QUALITY_P1;\nif (doneNP){\nif (!doneN)lumaEndN=FxaaLuma(FxaaTexTop(tex,posN.xy));\nif (!doneP)lumaEndP=FxaaLuma(FxaaTexTop(tex,posP.xy));\nif (!doneN)lumaEndN=lumaEndN-lumaNN*0.5;\nif (!doneP)lumaEndP=lumaEndP-lumaNN*0.5;\ndoneN=abs(lumaEndN)>=gradientScaled;\ndoneP=abs(lumaEndP)>=gradientScaled;\nif (!doneN)posN.x-=offNP.x*FXAA_QUALITY_P2;\nif (!doneN)posN.y-=offNP.y*FXAA_QUALITY_P2;\ndoneNP=(!doneN)||(!doneP);\nif (!doneP)posP.x+=offNP.x*FXAA_QUALITY_P2;\nif (!doneP)posP.y+=offNP.y*FXAA_QUALITY_P2;\n#if (FXAA_QUALITY_PS>3)\nif (doneNP){\nif (!doneN)lumaEndN=FxaaLuma(FxaaTexTop(tex,posN.xy));\nif (!doneP)lumaEndP=FxaaLuma(FxaaTexTop(tex,posP.xy));\nif (!doneN)lumaEndN=lumaEndN-lumaNN*0.5;\nif (!doneP)lumaEndP=lumaEndP-lumaNN*0.5;\ndoneN=abs(lumaEndN)>=gradientScaled;\ndoneP=abs(lumaEndP)>=gradientScaled;\nif (!doneN)posN.x-=offNP.x*FXAA_QUALITY_P3;\nif (!doneN)posN.y-=offNP.y*FXAA_QUALITY_P3;\ndoneNP=(!doneN)||(!doneP);\nif (!doneP)posP.x+=offNP.x*FXAA_QUALITY_P3;\nif (!doneP)posP.y+=offNP.y*FXAA_QUALITY_P3;\n#if (FXAA_QUALITY_PS>4)\nif (doneNP){\nif (!doneN)lumaEndN=FxaaLuma(FxaaTexTop(tex,posN.xy));\nif (!doneP)lumaEndP=FxaaLuma(FxaaTexTop(tex,posP.xy));\nif (!doneN)lumaEndN=lumaEndN-lumaNN*0.5;\nif (!doneP)lumaEndP=lumaEndP-lumaNN*0.5;\ndoneN=abs(lumaEndN)>=gradientScaled;\ndoneP=abs(lumaEndP)>=gradientScaled;\nif (!doneN)posN.x-=offNP.x*FXAA_QUALITY_P4;\nif (!doneN)posN.y-=offNP.y*FXAA_QUALITY_P4;\ndoneNP=(!doneN)||(!doneP);\nif (!doneP)posP.x+=offNP.x*FXAA_QUALITY_P4;\nif (!doneP)posP.y+=offNP.y*FXAA_QUALITY_P4;\n#if (FXAA_QUALITY_PS>5)\nif (doneNP){\nif (!doneN)lumaEndN=FxaaLuma(FxaaTexTop(tex,posN.xy));\nif (!doneP)lumaEndP=FxaaLuma(FxaaTexTop(tex,posP.xy));\nif (!doneN)lumaEndN=lumaEndN-lumaNN*0.5;\nif (!doneP)lumaEndP=lumaEndP-lumaNN*0.5;\ndoneN=abs(lumaEndN)>=gradientScaled;\ndoneP=abs(lumaEndP)>=gradientScaled;\nif (!doneN)posN.x-=offNP.x*FXAA_QUALITY_P5;\nif (!doneN)posN.y-=offNP.y*FXAA_QUALITY_P5;\ndoneNP=(!doneN)||(!doneP);\nif (!doneP)posP.x+=offNP.x*FXAA_QUALITY_P5;\nif (!doneP)posP.y+=offNP.y*FXAA_QUALITY_P5;\n#if (FXAA_QUALITY_PS>6)\nif (doneNP){\nif (!doneN)lumaEndN=FxaaLuma(FxaaTexTop(tex,posN.xy));\nif (!doneP)lumaEndP=FxaaLuma(FxaaTexTop(tex,posP.xy));\nif (!doneN)lumaEndN=lumaEndN-lumaNN*0.5;\nif (!doneP)lumaEndP=lumaEndP-lumaNN*0.5;\ndoneN=abs(lumaEndN)>=gradientScaled;\ndoneP=abs(lumaEndP)>=gradientScaled;\nif (!doneN)posN.x-=offNP.x*FXAA_QUALITY_P6;\nif (!doneN)posN.y-=offNP.y*FXAA_QUALITY_P6;\ndoneNP=(!doneN)||(!doneP);\nif (!doneP)posP.x+=offNP.x*FXAA_QUALITY_P6;\nif (!doneP)posP.y+=offNP.y*FXAA_QUALITY_P6;\n#if (FXAA_QUALITY_PS>7)\nif (doneNP){\nif (!doneN)lumaEndN=FxaaLuma(FxaaTexTop(tex,posN.xy));\nif (!doneP)lumaEndP=FxaaLuma(FxaaTexTop(tex,posP.xy));\nif (!doneN)lumaEndN=lumaEndN-lumaNN*0.5;\nif (!doneP)lumaEndP=lumaEndP-lumaNN*0.5;\ndoneN=abs(lumaEndN)>=gradientScaled;\ndoneP=abs(lumaEndP)>=gradientScaled;\nif (!doneN)posN.x-=offNP.x*FXAA_QUALITY_P7;\nif (!doneN)posN.y-=offNP.y*FXAA_QUALITY_P7;\ndoneNP=(!doneN)||(!doneP);\nif (!doneP)posP.x+=offNP.x*FXAA_QUALITY_P7;\nif (!doneP)posP.y+=offNP.y*FXAA_QUALITY_P7;\n#if (FXAA_QUALITY_PS>8)\nif (doneNP){\nif (!doneN)lumaEndN=FxaaLuma(FxaaTexTop(tex,posN.xy));\nif (!doneP)lumaEndP=FxaaLuma(FxaaTexTop(tex,posP.xy));\nif (!doneN)lumaEndN=lumaEndN-lumaNN*0.5;\nif (!doneP)lumaEndP=lumaEndP-lumaNN*0.5;\ndoneN=abs(lumaEndN)>=gradientScaled;\ndoneP=abs(lumaEndP)>=gradientScaled;\nif (!doneN)posN.x-=offNP.x*FXAA_QUALITY_P8;\nif (!doneN)posN.y-=offNP.y*FXAA_QUALITY_P8;\ndoneNP=(!doneN)||(!doneP);\nif (!doneP)posP.x+=offNP.x*FXAA_QUALITY_P8;\nif (!doneP)posP.y+=offNP.y*FXAA_QUALITY_P8;\n#if (FXAA_QUALITY_PS>9)\nif (doneNP){\nif (!doneN)lumaEndN=FxaaLuma(FxaaTexTop(tex,posN.xy));\nif (!doneP)lumaEndP=FxaaLuma(FxaaTexTop(tex,posP.xy));\nif (!doneN)lumaEndN=lumaEndN-lumaNN*0.5;\nif (!doneP)lumaEndP=lumaEndP-lumaNN*0.5;\ndoneN=abs(lumaEndN)>=gradientScaled;\ndoneP=abs(lumaEndP)>=gradientScaled;\nif (!doneN)posN.x-=offNP.x*FXAA_QUALITY_P9;\nif (!doneN)posN.y-=offNP.y*FXAA_QUALITY_P9;\ndoneNP=(!doneN)||(!doneP);\nif (!doneP)posP.x+=offNP.x*FXAA_QUALITY_P9;\nif (!doneP)posP.y+=offNP.y*FXAA_QUALITY_P9;\n#if (FXAA_QUALITY_PS>10)\nif (doneNP){\nif (!doneN)lumaEndN=FxaaLuma(FxaaTexTop(tex,posN.xy));\nif (!doneP)lumaEndP=FxaaLuma(FxaaTexTop(tex,posP.xy));\nif (!doneN)lumaEndN=lumaEndN-lumaNN*0.5;\nif (!doneP)lumaEndP=lumaEndP-lumaNN*0.5;\ndoneN=abs(lumaEndN)>=gradientScaled;\ndoneP=abs(lumaEndP)>=gradientScaled;\nif (!doneN)posN.x-=offNP.x*FXAA_QUALITY_P10;\nif (!doneN)posN.y-=offNP.y*FXAA_QUALITY_P10;\ndoneNP=(!doneN)||(!doneP);\nif (!doneP)posP.x+=offNP.x*FXAA_QUALITY_P10;\nif (!doneP)posP.y+=offNP.y*FXAA_QUALITY_P10;\n#if (FXAA_QUALITY_PS>11)\nif (doneNP){\nif (!doneN)lumaEndN=FxaaLuma(FxaaTexTop(tex,posN.xy));\nif (!doneP)lumaEndP=FxaaLuma(FxaaTexTop(tex,posP.xy));\nif (!doneN)lumaEndN=lumaEndN-lumaNN*0.5;\nif (!doneP)lumaEndP=lumaEndP-lumaNN*0.5;\ndoneN=abs(lumaEndN)>=gradientScaled;\ndoneP=abs(lumaEndP)>=gradientScaled;\nif (!doneN)posN.x-=offNP.x*FXAA_QUALITY_P11;\nif (!doneN)posN.y-=offNP.y*FXAA_QUALITY_P11;\ndoneNP=(!doneN)||(!doneP);\nif (!doneP)posP.x+=offNP.x*FXAA_QUALITY_P11;\nif (!doneP)posP.y+=offNP.y*FXAA_QUALITY_P11;\n#if (FXAA_QUALITY_PS>12)\nif (doneNP){\nif (!doneN)lumaEndN=FxaaLuma(FxaaTexTop(tex,posN.xy));\nif (!doneP)lumaEndP=FxaaLuma(FxaaTexTop(tex,posP.xy));\nif (!doneN)lumaEndN=lumaEndN-lumaNN*0.5;\nif (!doneP)lumaEndP=lumaEndP-lumaNN*0.5;\ndoneN=abs(lumaEndN)>=gradientScaled;\ndoneP=abs(lumaEndP)>=gradientScaled;\nif (!doneN)posN.x-=offNP.x*FXAA_QUALITY_P12;\nif (!doneN)posN.y-=offNP.y*FXAA_QUALITY_P12;\ndoneNP=(!doneN)||(!doneP);\nif (!doneP)posP.x+=offNP.x*FXAA_QUALITY_P12;\nif (!doneP)posP.y+=offNP.y*FXAA_QUALITY_P12;\n}\n#endif\n}\n#endif\n}\n#endif\n}\n#endif\n}\n#endif\n}\n#endif\n}\n#endif\n}\n#endif\n}\n#endif\n}\n#endif\n}\nfloat dstN=posM.x-posN.x;\nfloat dstP=posP.x-posM.x;\nif (!horzSpan)dstN=posM.y-posN.y;\nif (!horzSpan)dstP=posP.y-posM.y;\nbool goodSpanN=(lumaEndN<0.0)!= lumaMLTZero;\nfloat spanLength=(dstP+dstN);\nbool goodSpanP=(lumaEndP<0.0)!= lumaMLTZero;\nfloat spanLengthRcp=1.0/spanLength;\nbool directionN=dstN<dstP;\nfloat dst=min(dstN,dstP);\nbool goodSpan=directionN?goodSpanN:goodSpanP;\nfloat subpixG=subpixF*subpixF;\nfloat pixelOffset=(dst*(-spanLengthRcp))+0.5;\nfloat subpixH=subpixG*fxaaQualitySubpix;\nfloat pixelOffsetGood=goodSpan?pixelOffset:0.0;\nfloat pixelOffsetSubpix=max(pixelOffsetGood,subpixH);\nif (!horzSpan)posM.x+=pixelOffsetSubpix*lengthSign;\nif (horzSpan)posM.y+=pixelOffsetSubpix*lengthSign;\nreturn FxaaTexTop(tex,posM);\n}\nvoid main(){\ngl_FragColor=FxaaPixelShader(vUv,tDiffuse,resolution,0.75,0.166,0.0);\n}",pp_grayscale_frag="uniform sampler2D tDiffuse;\nvarying vec2 vUv;\nvoid main(){\nvec4 texel=texture(tDiffuse,vUv);\nfloat bw=texel.r*0.35+texel.g*0.45+texel.b*0.2;\ntexel=vec4(bw,bw,bw,texel.a);\ngl_FragColor=texel;\n}",pp_gtao_blur_frag="uniform sampler2D tDiffuse;\nuniform sampler2D tNormal;\nuniform vec2 direction;\nuniform vec2 resolution;\nvarying vec2 vUv;\n#include <packing>\nconst float SIGMA_SPATIAL=1.5;\nconst float SIGMA_INTENSITY=0.01;\nfloat gaussianPdf(float x,float sigma){\nreturn 0.39894*exp(-0.5*x*x/(sigma*sigma))/sigma;\n}\nvoid main(){\nfloat weightSum=gaussianPdf(0.0,SIGMA_SPATIAL)\n* gaussianPdf(0.0,SIGMA_INTENSITY);\nvec4 diffSample=texture(tDiffuse,vUv);\nvec4 gtaoDataSum=vec4(diffSample.r,unpackRGBToNormal(diffSample.gba))*weightSum;\nvec3 normCenter=unpackRGBToNormal(texture(tNormal,vUv).xyz);\nvec2 delta=direction/resolution;\nvec2 offset=delta;\n#pragma unroll_loop\nfor (int i=1;i<=BLUR_RADIUS_PX;i++){\nvec2 uvCoords0=vUv+offset;\nvec2 uvCoords1=vUv-offset;\nvec4 diffSample0=texture(tDiffuse,uvCoords0);\nvec4 diffSample1=texture(tDiffuse,uvCoords1);\nvec4 gtaoData0=vec4(diffSample0.r,unpackRGBToNormal(diffSample0.gba));\nvec4 gtaoData1=vec4(diffSample1.r,unpackRGBToNormal(diffSample1.gba));\nvec3 normSample0=unpackRGBToNormal(texture(tNormal,uvCoords0).xyz);\nvec3 normSample1=unpackRGBToNormal(texture(tNormal,uvCoords1).xyz);\nfloat weightSpatial=gaussianPdf(float(i),SIGMA_SPATIAL);\nfloat weight0=weightSpatial*gaussianPdf(1.0-max(0.0,dot(normCenter,normSample0)),SIGMA_INTENSITY);\nfloat weight1=weightSpatial*gaussianPdf(1.0-max(0.0,dot(normCenter,normSample1)),SIGMA_INTENSITY);\nweightSum+=weight0+weight1;\ngtaoDataSum+=weight0*gtaoData0+weight1*gtaoData1;\noffset+=delta;\n}\nfloat visibility=gtaoDataSum.r/weightSum;\nvec3 bentNormal=normalize(gtaoDataSum.gba);\ngl_FragColor=vec4(visibility,packNormalToRGB(bentNormal));\n}",pp_gtao_frag="uniform sampler2D tNormal;\nuniform sampler2D tDepth;\nuniform sampler2D tNoise;\nuniform float occlDistance;\nuniform float factor;\nuniform float occlPrecision;\nuniform mat4 mainCameraProjMat;\nuniform vec2 resolution;\nvarying vec2 vUv;\n#include <common>\n#include <packing>\nconst vec3 AXIS_Z=vec3(0.0,0.0,1.0);\nconst float NUM_SAMPLES_HALF_MIN=4.0;\nconst float NUM_SAMPLES_HALF_MAX=8.0;\nconst float NOISE_TEX_SIZE=32.0;\nconst float NEAR_FIELD_COEFF=0.5;\nconst float SELF_OCCL_BIAS=-1e-5;\nconst float NORMAL_RENDER_GEOM_MAX_DIFF_ANGLE=0.85*PI_HALF;\nfloat integrateArc(vec2 horizonAngles,float normalAngle){\nvec2 visCoeffs=(-cos(2.0*horizonAngles-normalAngle)+cos(normalAngle)\n+ 2.0*horizonAngles*sin(normalAngle))/4.0;\nreturn visCoeffs.x+visCoeffs.y;\n}\nvec3 calcViewFromUVDepth(vec2 uv,float depth,float zBias){\nvec3 ndcCo=2.0*vec3(uv,depth)-1.0;\n#if ORTHO_CAMERA==1\nfloat viewZ=(ndcCo.z-mainCameraProjMat[3][2])/mainCameraProjMat[2][2]+zBias;\nvec2 _00_11=vec2(mainCameraProjMat[0][0],mainCameraProjMat[1][1]);\nvec2 _30_31=vec2(mainCameraProjMat[3][0],mainCameraProjMat[3][1]);\nreturn vec3((ndcCo.xy-_30_31)/_00_11,viewZ);\n#else\nfloat viewZ=-mainCameraProjMat[3][2]/(mainCameraProjMat[2][2]+ndcCo.z)+zBias;\nvec2 _00_11=vec2(mainCameraProjMat[0][0],mainCameraProjMat[1][1]);\nvec2 _20_21=vec2(mainCameraProjMat[2][0],mainCameraProjMat[2][1]);\nreturn vec3(-viewZ*(ndcCo.xy+_20_21)/_00_11,viewZ);\n#endif\n}\nvec2 calcSliceRadiusUV(float viewZ){\nvec4 distView=vec4(occlDistance,occlDistance,viewZ,1.0);\nvec4 distClip=mainCameraProjMat*distView;\nvec2 xyNDC=distClip.xy/distClip.w;\nreturn clamp(0.5*xyNDC,0.0,0.5);\n}\nvec2 calcHorizonAngles(vec3 viewPos,vec3 viewVec,vec2 sliceDir,float offsetNoise){\nvec2 maxHorizonCos=vec2(-1.0);\nvec2 sliceRadius=calcSliceRadiusUV(viewPos.z);\nvec2 pxSize=1.0/resolution;\nint NUM_SAMPLES_HALF=int(occlPrecision\n* (NUM_SAMPLES_HALF_MAX-NUM_SAMPLES_HALF_MIN)+NUM_SAMPLES_HALF_MIN);\nfor (int i=0;i<NUM_SAMPLES_HALF;i++){\nvec2 offset=sliceDir*(pxSize*(1.0+float(i))\n+ sliceRadius*pow((float(i)+offsetNoise)/float(NUM_SAMPLES_HALF),2.0));\nvec2 uvs=vUv-offset;\nvec3 ps=calcViewFromUVDepth(uvs,texture(tDepth,uvs).x,SELF_OCCL_BIAS);\nvec3 ds=normalize(ps-viewPos);\nvec2 uvt=vUv+offset;\nvec3 pt=calcViewFromUVDepth(uvt,texture(tDepth,uvt).x,SELF_OCCL_BIAS);\nvec3 dt=normalize(pt-viewPos);\nvec2 sampleLen=vec2(length(ps-viewPos),length(pt-viewPos));\nvec2 blendWeight=(sampleLen/occlDistance-1.0)/(NEAR_FIELD_COEFF-1.0);\nblendWeight=clamp(blendWeight,0.0,1.0);\nvec2 maxHorizonCosNoBlending=max(maxHorizonCos,vec2(dot(ds,viewVec),dot(dt,viewVec)));\nmaxHorizonCos=mix(maxHorizonCos,maxHorizonCosNoBlending,blendWeight);\n}\nvec2 horizons=acos(maxHorizonCos);\nreturn vec2(-horizons.x,horizons.y);\n}\nvec2 calcNormalAngleAndProjLen(vec3 viewVec,vec3 normal,vec2 sliceDir){\nvec3 sliceVec=vec3(sliceDir,0.0);\nsliceVec=sliceVec-dot(sliceVec,viewVec)*viewVec;\nvec3 sliceOrthoVec=cross(sliceVec,viewVec);\nvec3 normalProj=normal-dot(normal,sliceOrthoVec)*sliceOrthoVec;\nfloat normalProjLen=length(normalProj);\nfloat normalAngle=acos(clamp(dot(normalProj/normalProjLen,viewVec),0.0,1.0));\nnormalAngle*=sign(dot(normalProj,sliceVec));\nreturn vec2(normalAngle,normalProjLen);\n}\n#if CALC_BENT_NORMALS==1\nvec3 calcSliceBentNormal(vec2 sliceDir,vec2 h,float n){\nvec2 t=vec2(6.0*sin(h[0]-n)-sin(3.0*h[0]-n)+6.0*sin(h[1]-n)\n- sin(3.0*h[1]-n)+16.0*sin(n)-3.0*(sin(h[0]+n)+sin(h[1]+n)),-cos(3.0*h[0]-n)-cos(3.0*h[1]-n)+8.0*cos(n)\n- 3.0*(cos(h[0]+n)+cos(h[1]+n))\n)/12.0;\nreturn vec3(sliceDir*t[0],t[1]);\n}\n#endif\nvec2 clampHorizonAnglesAroundNormal(vec2 horizonAngles,float normalAngle,float geomNormalAngle){\nhorizonAngles=normalAngle+clamp(horizonAngles-normalAngle,-PI_HALF,PI_HALF);\nif (abs(normalAngle-geomNormalAngle)<NORMAL_RENDER_GEOM_MAX_DIFF_ANGLE){\nhorizonAngles=geomNormalAngle+clamp(horizonAngles-geomNormalAngle,-PI_HALF,PI_HALF);\n}\nreturn horizonAngles;\n}\nvoid main(){\nfloat depth=texture(tDepth,vUv).x;\n#ifndef GTAO_DISABLE_BKG_FIX\nif (depth==1.0){\ngl_FragColor=vec4(vec3(1.0),1.0);\n} else {\n#endif\nvec3 viewPos=calcViewFromUVDepth(vUv,depth,0.0);\n#if ORTHO_CAMERA==1\nvec3 viewVec=vec3(0.0,0.0,1.0);\n#else\nvec3 viewVec=normalize(-viewPos);\n#endif\nvec3 viewNormal=unpackRGBToNormal(texture(tNormal,vUv).xyz);\nvec3 geomViewNormal=normalize(cross(dFdx(viewPos),dFdy(viewPos)));\nvec2 noiseScale=resolution/NOISE_TEX_SIZE;\nvec4 noiseData=texture(tNoise,vUv*noiseScale);\nfloat randAngle=noiseData.r*PI_HALF;\nfloat visibility=0.0;\nvec3 bentNormalAvg=viewNormal;\nfloat normalAngle,normalProjLen,geomNormalAngle;\nvec2 horizonAngles,_vec2Tmp;\nvec3 sliceBentNormal;\n#if CALC_BENT_NORMALS==1\nbentNormalAvg=vec3(0.0);\n#if ORTHO_CAMERA==0\nvec3 bentRotAxis=cross(AXIS_Z,viewVec);\nfloat bentRotAngle=acos(clamp(dot(AXIS_Z,viewVec),-1.0,1.0));\n#endif\n#endif\nvec2 sliceDir=vec2(cos(randAngle),sin(randAngle));\n#pragma unroll_loop\nfor (int i=0;i<2;i++){\n_vec2Tmp=calcNormalAngleAndProjLen(viewVec,viewNormal,sliceDir);\nnormalAngle=_vec2Tmp[0],normalProjLen=_vec2Tmp[1];\n_vec2Tmp=calcNormalAngleAndProjLen(viewVec,geomViewNormal,sliceDir);\ngeomNormalAngle=_vec2Tmp[0];\nhorizonAngles=calcHorizonAngles(viewPos,viewVec,sliceDir,noiseData.g);\nhorizonAngles=clampHorizonAnglesAroundNormal(horizonAngles,normalAngle,geomNormalAngle);\nvisibility+=normalProjLen*integrateArc(horizonAngles,normalAngle);\n#if CALC_BENT_NORMALS==1\nsliceBentNormal=calcSliceBentNormal(sliceDir,horizonAngles,normalAngle);\n#if ORTHO_CAMERA==0\nsliceBentNormal=vec3RotateAxisAngle(sliceBentNormal,bentRotAxis,bentRotAngle);\n#endif\nbentNormalAvg+=sliceBentNormal*normalProjLen;\n#endif\nsliceDir=vec2(-sliceDir.y,sliceDir.x);\n}\nvisibility/=2.0;\n#if CALC_BENT_NORMALS==1\nfloat mixFactor=clamp((1.0-2.0*visibility)/(3.0*visibility-4.0),0.0,1.0);\nbentNormalAvg=normalize(mix(bentNormalAvg,viewNormal,mixFactor));\n#endif\ngl_FragColor=vec4(pow(visibility,factor),packNormalToRGB(bentNormalAvg));\n#ifndef GTAO_DISABLE_BKG_FIX\n}\n#endif\n}",pp_outline_edge_frag="varying vec2 vUv;\nuniform sampler2D maskTexture;\nuniform vec2 texSize;\nuniform vec4 visibleEdgeColor;\nuniform vec4 hiddenEdgeColor;\nvoid main(){\nvec2 invSize=1.0/texSize;\nvec4 uvOffset=vec4(1.0,0.0,0.0,1.0)*vec4(invSize,invSize);\nvec4 c1=texture(maskTexture,vUv+uvOffset.xy);\nvec4 c2=texture(maskTexture,vUv-uvOffset.xy);\nvec4 c3=texture(maskTexture,vUv+uvOffset.yw);\nvec4 c4=texture(maskTexture,vUv-uvOffset.yw);\nfloat diff1=(c1.r-c2.r)*0.5;\nfloat diff2=(c3.r-c4.r)*0.5;\nfloat d=length(vec2(diff1,diff2));\nfloat a1=min(c1.g,c2.g);\nfloat a2=min(c3.g,c4.g);\nfloat visibilityFactor=min(a1,a2);\nvec4 edgeColor=(1.0-visibilityFactor>0.001)?visibleEdgeColor:hiddenEdgeColor;\ngl_FragColor=edgeColor*vec4(d);\n}",pp_outline_blur_frag="#include <common>\nvarying vec2 vUv;\nuniform sampler2D colorTexture;\nuniform vec2 texSize;\nuniform vec2 direction;\nuniform float kernelRadius;\nfloat gaussianPdf(in float x,in float sigma){\nreturn 0.39894*exp(-0.5*x*x/(sigma*sigma))/sigma;\n}\nvoid main(){\nvec2 invSize=1.0/texSize;\nfloat weightSum=gaussianPdf(0.0,kernelRadius);\nvec4 diffuseSum=texture(colorTexture,vUv);\n#if defined(LOG_SPACE)\ndiffuseSum=exp(diffuseSum);\n#endif\ndiffuseSum*=weightSum;\nvec2 delta=direction*invSize*kernelRadius/float(MAX_RADIUS);\nvec2 uvOffset=delta;\nfor (int i=1;i<=MAX_RADIUS;i++){\nfloat w=gaussianPdf(uvOffset.x,kernelRadius);\nvec4 sample1=texture(colorTexture,vUv+uvOffset);\nvec4 sample2=texture(colorTexture,vUv-uvOffset);\n#if defined(LOG_SPACE)\nsample1=exp(sample1);\nsample2=exp(sample2);\n#endif\ndiffuseSum+=((sample1+sample2)*w);\nweightSum+=(2.0*w);\nuvOffset+=delta;\n}\nvec4 finalCol=diffuseSum/weightSum;\n#if defined(LOG_SPACE)\nfinalCol=log(finalCol);\n#endif\ngl_FragColor=finalCol;\n}",pp_outline_overlay_frag="varying vec2 vUv;\nuniform sampler2D maskTexture;\nuniform sampler2D edgeTexture1;\nuniform sampler2D edgeTexture2;\nuniform sampler2D patternTexture;\nuniform float edgeStrength;\nuniform float edgeGlow;\nuniform bool usePatternTexture;\nvoid main(){\nvec4 edgeValue1=texture(edgeTexture1,vUv);\nvec4 edgeValue2=texture(edgeTexture2,vUv);\nvec4 maskColor=texture(maskTexture,vUv);\nvec4 patternColor=texture(patternTexture,6.0*vUv);\nfloat visibilityFactor=1.0-maskColor.g>0.0?1.0:0.5;\nvec4 edgeValue=edgeValue1+edgeValue2*edgeGlow;\nvec4 finalColor=edgeStrength*maskColor.r*edgeValue;\nif (usePatternTexture)\nfinalColor+=+ visibilityFactor*(1.0-maskColor.r)*(1.0-patternColor.r);\nfloat maxChannel=max(finalColor.r,max(finalColor.g,finalColor.b));\nif (maxChannel != 0.0){\nfinalColor.rgb/=maxChannel;\n}\ngl_FragColor=finalColor;\n}",pp_tonemap_frag="#include <common>\nuniform sampler2D tDiffuse;\nvarying vec2 vUv;\nvoid main(){\nvec4 texel=texture(tDiffuse,vUv);\nfloat alpha=clamp(texel.a,0.0,1.0);\ngl_FragColor=texel;\ngl_FragColor.rgb/=alpha;\n#include <tonemapping_fragment>\ngl_FragColor=LinearTosRGB(gl_FragColor);\ngl_FragColor.rgb*=alpha;\n}";const vertex="precision highp float;\nattribute vec3 position;\nattribute vec3 previous;\nattribute vec3 next;\nattribute float side;\nattribute float width;\nattribute vec2 uv;\nattribute float counters;\nuniform mat4 projectionMatrix;\nuniform mat4 modelViewMatrix;\nuniform vec2 resolution;\nuniform float lineWidth;\nuniform float sizeAttenuation;\nvarying float vCounters;\nvarying vec2 vUV;\nconst float EQ_EPS=0.000001;\nvec2 fix(vec4 i,float aspect){\nvec2 res=i.xy/i.w;\nres.x*=aspect;\nreturn res;\n}\nbool posEqual(vec2 pos0,vec2 pos1){\nreturn length(pos0-pos1)<EQ_EPS;\n}\nvoid main(){\nfloat aspect=resolution.x/resolution.y;\nvCounters=counters;\nvUV=uv;\nmat4 m=projectionMatrix*modelViewMatrix;\nvec4 finalPosition=m*vec4(position,1.0);\nvec4 prevPos=m*vec4(previous,1.0);\nvec4 nextPos=m*vec4(next,1.0);\nvec2 currentP=fix(finalPosition,aspect);\nvec2 prevP=fix(prevPos,aspect);\nvec2 nextP=fix(nextPos,aspect);\nfloat w=lineWidth*width;\nif (sizeAttenuation==0.0){\nw*=finalPosition.w/resolution.x;\n}\nvec2 dir;\nif (posEqual(nextP,currentP)){\ndir=normalize(currentP-prevP);\n} else if (posEqual(prevP,currentP)){\ndir=normalize(nextP-currentP);\n} else {\nvec2 dir1=normalize(currentP-prevP);\nvec2 dir2=normalize(nextP-currentP);\ndir=normalize(dir1+dir2);\n}\nvec2 offset=vec2(-dir.y,dir.x);\noffset.y*=aspect;\noffset*=w;\nfinalPosition.xy+=offset*side;\ngl_Position=finalPosition;\n}",fragment="precision mediump float;\nuniform sampler2D map;\nuniform sampler2D alphaMap;\nuniform float useMap;\nuniform float useAlphaMap;\nuniform float visibility;\nuniform float alphaTest;\nuniform vec2 repeat;\nuniform vec3 color;\nuniform float opacity;\nvarying vec2 vUV;\nvarying float vCounters;\n#include <encodings_pars_fragment>\nvoid main(){\nvec4 c=vec4(color,opacity);\nif (useMap==1.0){\nc*=texture2D(map,vUV*repeat);\n}\nif (useAlphaMap==1.0){\nc.a*=texture2D(alphaMap,vUV*repeat).a;\n}\nif (c.a<alphaTest){\ndiscard;\n}\ngl_FragColor=c;\ngl_FragColor.a*=step(vCounters,visibility);\ngl_FragColor=LinearTosRGB(gl_FragColor);\n}",ShaderChunk={alphamap_fragment:alphamap_fragment,alphamap_pars_fragment:alphamap_pars_fragment,alphatest_fragment:alphatest_fragment,alphatest_pars_fragment:alphatest_pars_fragment,aomap_fragment:aomap_fragment,aomap_pars_fragment:aomap_pars_fragment,begin_vertex:begin_vertex,beginnormal_vertex:beginnormal_vertex,bsdfs:bsdfs,bumpmap_pars_fragment:bumpmap_pars_fragment,clipping_planes_fragment:clipping_planes_fragment,clipping_planes_pars_fragment:clipping_planes_pars_fragment,clipping_planes_pars_vertex:clipping_planes_pars_vertex,clipping_planes_vertex:clipping_planes_vertex,color_fragment:color_fragment,color_pars_fragment:color_pars_fragment,color_pars_vertex:color_pars_vertex,color_vertex:color_vertex,common:common,cube_uv_reflection_fragment:cube_uv_reflection_fragment,defaultnormal_vertex:defaultnormal_vertex,displacementmap_pars_vertex:displacementmap_pars_vertex,displacementmap_vertex:displacementmap_vertex,emissivemap_fragment:emissivemap_fragment,emissivemap_pars_fragment:emissivemap_pars_fragment,encodings_fragment:encodings_fragment,encodings_pars_fragment:encodings_pars_fragment,envmap_fragment:envmap_fragment,envmap_common_pars_fragment:envmap_common_pars_fragment,envmap_pars_fragment:envmap_pars_fragment,envmap_pars_vertex:envmap_pars_vertex,envmap_physical_pars_fragment:envmap_physical_pars_fragment,envmap_vertex:envmap_vertex,fog_vertex:fog_vertex,fog_pars_vertex:fog_pars_vertex,fog_fragment:fog_fragment,fog_pars_fragment:fog_pars_fragment,lightmap_fragment:lightmap_fragment,lightmap_pars_fragment:lightmap_pars_fragment,lights_lambert_fragment:lights_lambert_fragment,lights_lambert_pars_fragment:lights_lambert_pars_fragment,lights_pars_begin:lights_pars_begin,lights_physical_fragment:lights_physical_fragment,lights_physical_pars_fragment:lights_physical_pars_fragment,lights_fragment_begin:lights_fragment_begin,lights_fragment_maps:lights_fragment_maps,lights_fragment_end:lights_fragment_end,logdepthbuf_fragment:logdepthbuf_fragment,logdepthbuf_pars_fragment:logdepthbuf_pars_fragment,logdepthbuf_pars_vertex:logdepthbuf_pars_vertex,logdepthbuf_vertex:logdepthbuf_vertex,map_fragment:map_fragment,map_pars_fragment:map_pars_fragment,map_particle_fragment:map_particle_fragment,map_particle_pars_fragment:map_particle_pars_fragment,metalnessmap_fragment:metalnessmap_fragment,metalnessmap_pars_fragment:metalnessmap_pars_fragment,morphnormal_vertex:morphnormal_vertex,morphtarget_pars_vertex:morphtarget_pars_vertex,morphtarget_vertex:morphtarget_vertex,normal_fragment_begin:normal_fragment_begin,normal_fragment_maps:normal_fragment_maps,normal_pars_fragment:normal_pars_fragment,normal_pars_vertex:normal_pars_vertex,normal_vertex:normal_vertex,normalmap_pars_fragment:normalmap_pars_fragment,output_fragment:output_fragment,packing:packing,premultiplied_alpha_fragment:premultiplied_alpha_fragment,project_vertex:project_vertex,dithering_fragment:dithering_fragment,dithering_pars_fragment:dithering_pars_fragment,roughnessmap_fragment:roughnessmap_fragment,roughnessmap_pars_fragment:roughnessmap_pars_fragment,shadowmap_pars_fragment:shadowmap_pars_fragment,shadowmap_pars_vertex:shadowmap_pars_vertex,shadowmap_vertex:shadowmap_vertex,shadowmask_pars_fragment:shadowmask_pars_fragment,skinbase_vertex:skinbase_vertex,skinning_pars_vertex:skinning_pars_vertex,skinning_vertex:skinning_vertex,skinnormal_vertex:skinnormal_vertex,tonemapping_fragment:tonemapping_fragment,tonemapping_pars_fragment:tonemapping_pars_fragment,uv_pars_fragment:uv_pars_fragment,uv_pars_vertex:uv_pars_vertex,uv_vertex:uv_vertex,uv2_pars_fragment:uv2_pars_fragment,uv2_pars_vertex:uv2_pars_vertex,uv2_vertex:uv2_vertex,webgl1_compat:webgl1_compat,worldpos_vertex:worldpos_vertex,background_vert:vertex$f,background_frag:fragment$f,backgroundCube_vert:vertex$e,backgroundCube_frag:fragment$e,cube_vert:vertex$d,cube_frag:fragment$d,depth_vert:vertex$c,depth_frag:fragment$c,distanceRGBA_vert:vertex$b,distanceRGBA_frag:fragment$b,linedashed_vert:vertex$a,linedashed_frag:fragment$a,meshbasic_vert:vertex$9,meshbasic_frag:fragment$9,meshlambert_vert:vertex$8,meshlambert_frag:fragment$8,meshnormal_vert:vertex$7,meshnormal_frag:fragment$7,meshphysical_vert:vertex$6,meshphysical_frag:fragment$6,points_vert:vertex$5,points_frag:fragment$5,shadow_vert:vertex$4,shadow_frag:fragment$4,sprite_vert:vertex$3,sprite_frag:fragment$3,mask_vert:vertex$2,mask_frag:fragment$2,meshnode_vert:vertex$1,meshnode_frag:fragment$1,lights_node_pars_fragment:lights_node_pars_fragment,lights_node_gtao_pars_fragment:lights_node_gtao_pars_fragment,lights_fragment_gtso:lights_fragment_gtso,normal_output_fragment:normal_output_fragment,ssr_pars_fragment:ssr_pars_fragment,plane_reflection_pars_vertex:plane_reflection_pars_vertex,plane_reflection_pars_fragment:plane_reflection_pars_fragment,plane_reflection_vertex:plane_reflection_vertex,oit_weighted_pars_fragment:oit_weighted_pars_fragment,oit_weighted_fragment:oit_weighted_fragment,node_common_frag:node_common_frag,node_osl_frag:node_osl_frag,node_incident_frag:node_incident_frag,node_normal_frag:node_normal_frag,node_position_frag:node_position_frag,node_rgb_alpha_frag:node_rgb_alpha_frag,node_value_frag:node_value_frag,node_u_float_frag:node_u_float_frag,node_abs_ar_frag:node_abs_ar_frag,node_add_ar_frag:node_add_ar_frag,node_atan_ar_frag:node_atan_ar_frag,node_checkerboard_ar_frag:node_checkerboard_ar_frag,node_clamp_ar_frag:node_clamp_ar_frag,node_color_convert_ar_frag:node_color_convert_ar_frag,node_color_correct_ar_frag:node_color_correct_ar_frag,node_color_to_float_ar_frag:node_color_to_float_ar_frag,node_compare_ar_frag:node_compare_ar_frag,node_complement_ar_frag:node_complement_ar_frag,node_composite_ar_frag:node_composite_ar_frag,node_cross_ar_frag:node_cross_ar_frag,node_divide_ar_frag:node_divide_ar_frag,node_dot_ar_frag:node_dot_ar_frag,node_exp_ar_frag:node_exp_ar_frag,node_facing_ratio_ar_frag:node_facing_ratio_ar_frag,node_flat_ar_frag:node_flat_ar_frag,node_float_to_int_ar_frag:node_float_to_int_ar_frag,node_float_to_matrix_ar_frag:node_float_to_matrix_ar_frag,node_float_to_rgba_ar_frag:node_float_to_rgba_ar_frag,node_float_to_rgb_ar_frag:node_float_to_rgb_ar_frag,node_fraction_ar_frag:node_fraction_ar_frag,node_is_finite_ar_frag:node_is_finite_ar_frag,node_image_ar_frag:node_image_ar_frag,node_lambert_ar_frag:node_lambert_ar_frag,node_length_ar_frag:node_length_ar_frag,node_log_ar_frag:node_log_ar_frag,node_map_to_mtl_ar_frag:node_map_to_mtl_ar_frag,node_matrix_transform_ar_frag:node_matrix_transform_ar_frag,node_max_ar_frag:node_max_ar_frag,node_min_ar_frag:node_min_ar_frag,node_mix_shader_ar_frag:node_mix_shader_ar_frag,node_modulo_ar_frag:node_modulo_ar_frag,node_multiply_ar_frag:node_multiply_ar_frag,node_negate_ar_frag:node_negate_ar_frag,node_normalize_ar_frag:node_normalize_ar_frag,node_normal_map_ar_frag:node_normal_map_ar_frag,node_pow_ar_frag:node_pow_ar_frag,node_random_ar_frag:node_random_ar_frag,node_range_ar_frag:node_range_ar_frag,node_ray_switch_ar_frag:node_ray_switch_ar_frag,node_reciprocal_ar_frag:node_reciprocal_ar_frag,node_rgba_to_float_ar_frag:node_rgba_to_float_ar_frag,node_rgb_to_float_ar_frag:node_rgb_to_float_ar_frag,node_rgb_to_vector_ar_frag:node_rgb_to_vector_ar_frag,node_shadow_matte_ar_frag:node_shadow_matte_ar_frag,node_shuffle_ar_frag:node_shuffle_ar_frag,node_sign_ar_frag:node_sign_ar_frag,node_skydome_light_ar_frag:node_skydome_light_ar_frag,node_sqrt_ar_frag:node_sqrt_ar_frag,node_standard_surface_ar_frag:node_standard_surface_ar_frag,node_subtract_ar_frag:node_subtract_ar_frag,node_trigo_ar_frag:node_trigo_ar_frag,node_triplanar_ar_frag:node_triplanar_ar_frag,node_triplanar_uv_ar_frag:node_triplanar_uv_ar_frag,node_two_sided_ar_frag:node_two_sided_ar_frag,node_user_data_color_ar_frag:node_user_data_color_ar_frag,node_uv_projection_ar_frag:node_uv_projection_ar_frag,node_vector_to_rgb_ar_frag:node_vector_to_rgb_ar_frag,node_add_shader_bl_frag:node_add_shader_bl_frag,node_ambient_occlusion_bl_frag:node_ambient_occlusion_bl_frag,node_attribute_bl_frag:node_attribute_bl_frag,node_background_bl_frag:node_background_bl_frag,node_bevel_bl_frag:node_bevel_bl_frag,node_blackbody_bl_frag:node_blackbody_bl_frag,node_brightcontrast_bl_frag:node_brightcontrast_bl_frag,node_bsdf_anisotropic_bl_frag:node_bsdf_anisotropic_bl_frag,node_bsdf_diffuse_bl_frag:node_bsdf_diffuse_bl_frag,node_bsdf_glass_bl_frag:node_bsdf_glass_bl_frag,node_bsdf_glossy_bl_frag:node_bsdf_glossy_bl_frag,node_bsdf_metallic_bl_frag:node_bsdf_metallic_bl_frag,node_bsdf_hair_bl_frag:node_bsdf_hair_bl_frag,node_bsdf_principled_bl_frag:node_bsdf_principled_bl_frag,node_bsdf_refraction_bl_frag:node_bsdf_refraction_bl_frag,node_bsdf_sheen_bl_frag:node_bsdf_sheen_bl_frag,node_bsdf_toon_bl_frag:node_bsdf_toon_bl_frag,node_bsdf_translucent_bl_frag:node_bsdf_translucent_bl_frag,node_bsdf_transparent_bl_frag:node_bsdf_transparent_bl_frag,node_bump_bl_frag:node_bump_bl_frag,node_camera_bl_frag:node_camera_bl_frag,node_clamp_bl_frag:node_clamp_bl_frag,node_combine_color_bl_frag:node_combine_color_bl_frag,node_combxyz_bl_frag:node_combxyz_bl_frag,node_curve_float_bl_frag:node_curve_float_bl_frag,node_curve_rgb_bl_frag:node_curve_rgb_bl_frag,node_curve_vec_bl_frag:node_curve_vec_bl_frag,node_displacement_bl_frag:node_displacement_bl_frag,node_eevee_specular_bl_frag:node_eevee_specular_bl_frag,node_emission_bl_frag:node_emission_bl_frag,node_fresnel_bl_frag:node_fresnel_bl_frag,node_gamma_bl_frag:node_gamma_bl_frag,node_hair_info_bl_frag:node_hair_info_bl_frag,node_holdout_bl_frag:node_holdout_bl_frag,node_hue_sat_bl_frag:node_hue_sat_bl_frag,node_invert_bl_frag:node_invert_bl_frag,node_layer_weight_bl_frag:node_layer_weight_bl_frag,node_light_falloff_bl_frag:node_light_falloff_bl_frag,node_light_path_bl_frag:node_light_path_bl_frag,node_mapping_bl_frag:node_mapping_bl_frag,node_map_range_bl_frag:node_map_range_bl_frag,node_math_bl_frag:node_math_bl_frag,node_mix_bl_frag:node_mix_bl_frag,node_mix_shader_bl_frag:node_mix_shader_bl_frag,node_new_geometry_bl_frag:node_new_geometry_bl_frag,node_normal_bl_frag:node_normal_bl_frag,node_normal_map_bl_frag:node_normal_map_bl_frag,node_object_info_bl_frag:node_object_info_bl_frag,node_output_lamp_bl_frag:node_output_lamp_bl_frag,node_output_material_bl_frag:node_output_material_bl_frag,node_output_world_bl_frag:node_output_world_bl_frag,node_particle_info_bl_frag:node_particle_info_bl_frag,node_point_info_bl_frag:node_point_info_bl_frag,node_principled_volume_bl_frag:node_principled_volume_bl_frag,node_rgb_bl_frag:node_rgb_bl_frag,node_rgbtobw_bl_frag:node_rgbtobw_bl_frag,node_script_bl_frag:node_script_bl_frag,node_separate_color_bl_frag:node_separate_color_bl_frag,node_sepxyz_bl_frag:node_sepxyz_bl_frag,node_shadertorgb_bl_frag:node_shadertorgb_bl_frag,node_squeeze_bl_frag:node_squeeze_bl_frag,node_subsurface_scattering_bl_frag:node_subsurface_scattering_bl_frag,node_tangent_bl_frag:node_tangent_bl_frag,node_tex_brick_bl_frag:node_tex_brick_bl_frag,node_tex_checker_bl_frag:node_tex_checker_bl_frag,node_tex_coord_bl_frag:node_tex_coord_bl_frag,node_tex_environment_bl_frag:node_tex_environment_bl_frag,node_tex_environment_none_bl_frag:node_tex_environment_none_bl_frag,node_tex_gabor_bl_frag:node_tex_gabor_bl_frag,node_tex_gradient_bl_frag:node_tex_gradient_bl_frag,node_tex_ies_bl_frag:node_tex_ies_bl_frag,node_tex_image_bl_frag:node_tex_image_bl_frag,node_tex_image_none_bl_frag:node_tex_image_none_bl_frag,node_tex_magic_bl_frag:node_tex_magic_bl_frag,node_tex_noise_bl_frag:node_tex_noise_bl_frag,node_tex_pointdensity_bl_frag:node_tex_pointdensity_bl_frag,node_tex_sky_bl_frag:node_tex_sky_bl_frag,node_tex_voronoi_bl_frag:node_tex_voronoi_bl_frag,node_tex_wave_bl_frag:node_tex_wave_bl_frag,node_tex_white_noise_bl_frag:node_tex_white_noise_bl_frag,node_uvmap_bl_frag:node_uvmap_bl_frag,node_valtorgb_bl_frag:node_valtorgb_bl_frag,node_value_bl_frag:node_value_bl_frag,node_vect_math_bl_frag:node_vect_math_bl_frag,node_vect_transform_bl_frag:node_vect_transform_bl_frag,node_vector_displacement_bl_frag:node_vector_displacement_bl_frag,node_vector_rotate_bl_frag:node_vector_rotate_bl_frag,node_vertex_color_bl_frag:node_vertex_color_bl_frag,node_volume_absorption_bl_frag:node_volume_absorption_bl_frag,node_volume_coefficients_bl_frag:node_volume_coefficients_bl_frag,node_volume_info_bl_frag:node_volume_info_bl_frag,node_volume_scatter_bl_frag:node_volume_scatter_bl_frag,node_wavelength_bl_frag:node_wavelength_bl_frag,node_wireframe_bl_frag:node_wireframe_bl_frag,node_bitmap_none_mx_frag:node_bitmap_none_mx_frag,node_bitmap_env_mx_frag:node_bitmap_env_mx_frag,node_bitmap_mx_frag:node_bitmap_mx_frag,node_bump_mx_frag:node_bump_mx_frag,node_blend_mx_frag:node_blend_mx_frag,node_color_correction_mx_frag:node_color_correction_mx_frag,node_color_map_mx_frag:node_color_map_mx_frag,node_composite_layer_mx_frag:node_composite_layer_mx_frag,node_falloff_mx_frag:node_falloff_mx_frag,node_gradient_mx_frag:node_gradient_mx_frag,node_gradient_ramp_mx_frag:node_gradient_ramp_mx_frag,node_map_mx_frag:node_map_mx_frag,node_mask_mx_frag:node_mask_mx_frag,node_material_mx_frag:node_material_mx_frag,node_matte_shadow_mx_frag:node_matte_shadow_mx_frag,node_mix_mx_frag:node_mix_mx_frag,node_noise_mx_frag:node_noise_mx_frag,node_normal_bump_mx_frag:node_normal_bump_mx_frag,node_openpbr_surface_mx_frag:node_openpbr_surface_mx_frag,node_output_map_mx_frag:node_output_map_mx_frag,node_output_mx_frag:node_output_mx_frag,node_physical_mx_frag:node_physical_mx_frag,node_phy_sun_sky_env_mx_frag:node_phy_sun_sky_env_mx_frag,node_reflect_refract_mx_frag:node_reflect_refract_mx_frag,node_reflect_refract_color_mx_frag:node_reflect_refract_color_mx_frag,node_rgb_multiply_mx_frag:node_rgb_multiply_mx_frag,node_rgb_tint_mx_frag:node_rgb_tint_mx_frag,node_rgb_mx_frag:node_rgb_mx_frag,node_shellac_mx_frag:node_shellac_mx_frag,node_sub_transform_mx_frag:node_sub_transform_mx_frag,node_value_mx_frag:node_value_mx_frag,node_vertex_color_mx_frag:node_vertex_color_mx_frag,node_add_double_linear_my_frag:node_add_double_linear_my_frag,node_add_matrix_my_frag:node_add_matrix_my_frag,node_anim_curve_ta_my_frag:node_anim_curve_ta_my_frag,node_anim_curve_tu_my_frag:node_anim_curve_tu_my_frag,node_blend_colors_my_frag:node_blend_colors_my_frag,node_bulge_my_frag:node_bulge_my_frag,node_blinn_my_frag:node_blinn_my_frag,node_bump_2d_my_frag:node_bump_2d_my_frag,node_channels_my_frag:node_channels_my_frag,node_checker_my_frag:node_checker_my_frag,node_clamp_my_frag:node_clamp_my_frag,node_cloth_my_frag:node_cloth_my_frag,node_color_condition_my_frag:node_color_condition_my_frag,node_color_composite_my_frag:node_color_composite_my_frag,node_color_constant_my_frag:node_color_constant_my_frag,node_color_correct_my_frag:node_color_correct_my_frag,node_color_logic_my_frag:node_color_logic_my_frag,node_color_mask_my_frag:node_color_mask_my_frag,node_color_math_my_frag:node_color_math_my_frag,node_compose_matrix_my_frag:node_compose_matrix_my_frag,node_condition_my_frag:node_condition_my_frag,node_contrast_my_frag:node_contrast_my_frag,node_decompose_matrix_my_frag:node_decompose_matrix_my_frag,node_env_sphere_my_frag:node_env_sphere_my_frag,node_file_my_frag:node_file_my_frag,node_float_condition_my_frag:node_float_condition_my_frag,node_float_composite_my_frag:node_float_composite_my_frag,node_float_constant_my_frag:node_float_constant_my_frag,node_float_logic_my_frag:node_float_logic_my_frag,node_float_mask_my_frag:node_float_mask_my_frag,node_float_math_my_frag:node_float_math_my_frag,node_four_by_four_matrix_my_frag:node_four_by_four_matrix_my_frag,node_gamma_correct_my_frag:node_gamma_correct_my_frag,node_grid_my_frag:node_grid_my_frag,node_inverse_matrix_my_frag:node_inverse_matrix_my_frag,node_lambert_my_frag:node_lambert_my_frag,node_layered_texture_layer_my_frag:node_layered_texture_layer_my_frag,node_luminance_my_frag:node_luminance_my_frag,node_multiply_divide_my_frag:node_multiply_divide_my_frag,node_mult_double_linear_my_frag:node_mult_double_linear_my_frag,node_mult_matrix_my_frag:node_mult_matrix_my_frag,node_noise_my_frag:node_noise_my_frag,node_openpbr_surface_my_frag:node_openpbr_surface_my_frag,node_output_my_frag:node_output_my_frag,node_place_2d_texture_my_frag:node_place_2d_texture_my_frag,node_phong_my_frag:node_phong_my_frag,node_phong_e_my_frag:node_phong_e_my_frag,node_premultiply_my_frag:node_premultiply_my_frag,node_ramp_my_frag:node_ramp_my_frag,node_remap_hsv_my_frag:node_remap_hsv_my_frag,node_reverse_my_frag:node_reverse_my_frag,node_sampler_info_my_frag:node_sampler_info_my_frag,node_set_range_my_frag:node_set_range_my_frag,node_shading_engine_my_frag:node_shading_engine_my_frag,node_sub_transform_my_frag:node_sub_transform_my_frag,node_surface_shader_my_frag:node_surface_shader_my_frag,node_transform_my_frag:node_transform_my_frag,node_transpose_matrix_my_frag:node_transpose_matrix_my_frag,node_unit_conversion_my_frag:node_unit_conversion_my_frag,node_unpremultiply_my_frag:node_unpremultiply_my_frag,node_vector_product_my_frag:node_vector_product_my_frag,node_wt_add_matrix_my_frag:node_wt_add_matrix_my_frag,pmrem_common_vert:pmrem_common_vert,pmrem_blur_frag:pmrem_blur_frag,pmrem_cubemap_frag:pmrem_cubemap_frag,pmrem_equirect_frag:pmrem_equirect_frag,pp_plane_vert:pp_plane_vert,pp_afterimage_frag:pp_afterimage_frag,pp_bloom_composite_frag:pp_bloom_composite_frag,pp_bloom_lum_high_pass_frag:pp_bloom_lum_high_pass_frag,pp_bloom_separable_blur_frag:pp_bloom_separable_blur_frag,pp_blur_frag:pp_blur_frag,pp_brightness_contrast_frag:pp_brightness_contrast_frag,pp_bokeh_frag:pp_bokeh_frag,pp_copy_frag:pp_copy_frag,pp_cube_octahedral_proj_frag:pp_cube_octahedral_proj_frag,pp_fxaa_frag:pp_fxaa_frag,pp_grayscale_frag:pp_grayscale_frag,pp_gtao_blur_frag:pp_gtao_blur_frag,pp_gtao_frag:pp_gtao_frag,pp_outline_edge_frag:pp_outline_edge_frag,pp_outline_blur_frag:pp_outline_blur_frag,pp_outline_overlay_frag:pp_outline_overlay_frag,pp_tonemap_frag:pp_tonemap_frag,pp_oit_weighted_frag:pp_oit_weighted_frag,raw_meshline_vert:vertex,raw_meshline_frag:fragment},UniformsLib={common:{diffuse:{value:new Color(16777215)},opacity:{value:1},map:{value:null},uvTransform:{value:new Matrix3},uv2Transform:{value:new Matrix3},alphaMap:{value:null},alphaTest:{value:0}},envmap:{envMap:{value:null},flipEnvMap:{value:-1},reflectivity:{value:1},refractionRatio:{value:.98}},aomap:{aoMap:{value:null},aoMapIntensity:{value:1}},lightmap:{lightMap:{value:null},lightMapIntensity:{value:1}},emissivemap:{emissiveMap:{value:null}},bumpmap:{bumpMap:{value:null},bumpScale:{value:1}},normalmap:{normalMap:{value:null},normalScale:{value:new Vector2(1,1)}},displacementmap:{displacementMap:{value:null},displacementScale:{value:1},displacementBias:{value:0}},roughnessmap:{roughnessMap:{value:null}},metalnessmap:{metalnessMap:{value:null}},fog:{fogDensity:{value:25e-5},fogNear:{value:1},fogFar:{value:2e3},fogColor:{value:new Color(16777215)}},lights:{ambientLightColor:{value:[],needsUpdate:!0},lightProbe:{value:[],needsUpdate:!0},directionalLights:{value:[],needsUpdate:!0},directionalLightShadowsCSM:{value:[],needsUpdate:!0},directionalLightShadowsCSMCascade:{value:[],needsUpdate:!0},directionalShadowCSMMap:{value:[]},directionalShadowCSMMatrix:{value:[]},spotLights:{value:[],needsUpdate:!0},spotLightShadows:{value:[],needsUpdate:!0},spotShadowMap:{value:[]},spotShadowMatrix:{value:[]},pointLights:{value:[],needsUpdate:!0},pointLightShadows:{value:[],needsUpdate:!0},pointShadowMap:{value:[]},pointShadowMatrix:{value:[]},rectAreaLights:{value:[],needsUpdate:!0},rectAreaLightShadows:{value:[],needsUpdate:!0},rectAreaShadowMap:{value:[]},rectAreaShadowMatrix:{value:[]},ltc_1:{value:null},ltc_2:{value:null}},points:{diffuse:{value:new Color(16777215)},opacity:{value:1},size:{value:1},scale:{value:1},map:{value:null},alphaMap:{value:null},alphaTest:{value:0},uvTransform:{value:new Matrix3}},sprite:{diffuse:{value:new Color(16777215)},opacity:{value:1},center:{value:new Vector2(.5,.5)},rotation:{value:0},map:{value:null},alphaMap:{value:null},alphaTest:{value:0},uvTransform:{value:new Matrix3}},mask:{depthTexture:{value:null},cameraNearFar:{value:new Vector2(.5,.5)},textureMatrix:{value:new Matrix4}},node:{nodeRGB:{value:[]},nodeValue:{value:[]},nodeInputsFloat:{value:[]},nodeInputsInt:{value:[]},nodeInputsBool:{value:[]},nodeInputsVec2:{value:[]},nodeInputsVec3:{value:[]},nodeInputsVec4:{value:[]},nodeInputsMat3:{value:[]},nodeInputsMat4:{value:[]},flipCubeMap:{value:-1},materialIndex:{value:0}},nodeGTAO:{gtaoMap:{value:null}},ssr:{invProjectionMatrix:{value:new Matrix4},ssrSourceBuffer:{value:null},ssrDepthBuffer:{value:null},ssrBackfaceDepthBuffer:{value:null},ssrStride:{value:20},ssrJitter:{value:1},ssrMaxDistance:{value:100}},planeReflectionProbe:{planeReflTexture:{value:null},planeReflTextureMatrix:{value:new Matrix4},planeReflDir:{value:new Vector3},planeReflBoundingBoxMin:{value:new Vector3},planeReflBoundingBoxMax:{value:new Vector3},planeReflInvModelMatrix:{value:new Matrix4},planeReflFalloff:{value:0}}},ShaderLib={basic:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.envmap,UniformsLib.aomap,UniformsLib.lightmap,UniformsLib.fog]),vertexShader:ShaderChunk.meshbasic_vert,fragmentShader:ShaderChunk.meshbasic_frag},lambert:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.envmap,UniformsLib.aomap,UniformsLib.lightmap,UniformsLib.emissivemap,UniformsLib.bumpmap,UniformsLib.normalmap,UniformsLib.displacementmap,UniformsLib.fog,UniformsLib.lights,{emissive:{value:new Color(0)}}]),vertexShader:ShaderChunk.meshlambert_vert,fragmentShader:ShaderChunk.meshlambert_frag},standard:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.envmap,UniformsLib.aomap,UniformsLib.lightmap,UniformsLib.emissivemap,UniformsLib.bumpmap,UniformsLib.normalmap,UniformsLib.displacementmap,UniformsLib.roughnessmap,UniformsLib.metalnessmap,UniformsLib.fog,UniformsLib.lights,UniformsLib.planeReflectionProbe,{emissive:{value:new Color(0)},roughness:{value:1},metalness:{value:0},envMapIntensity:{value:1},envMapParallaxType:{value:0},envMapParallaxMatrix:{value:new Matrix4},envMapParallaxMatrixInv:{value:new Matrix4}}]),vertexShader:ShaderChunk.meshphysical_vert,fragmentShader:ShaderChunk.meshphysical_frag},points:{uniforms:mergeUniforms([UniformsLib.points,UniformsLib.fog]),vertexShader:ShaderChunk.points_vert,fragmentShader:ShaderChunk.points_frag},dashed:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.fog,{scale:{value:1},dashSize:{value:1},totalSize:{value:2}}]),vertexShader:ShaderChunk.linedashed_vert,fragmentShader:ShaderChunk.linedashed_frag},depth:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.displacementmap,{slopeScaledBias:{value:0}}]),vertexShader:ShaderChunk.depth_vert,fragmentShader:ShaderChunk.depth_frag},normal:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.bumpmap,UniformsLib.normalmap,UniformsLib.displacementmap,{opacity:{value:1}}]),vertexShader:ShaderChunk.meshnormal_vert,fragmentShader:ShaderChunk.meshnormal_frag},sprite:{uniforms:mergeUniforms([UniformsLib.sprite,UniformsLib.fog]),vertexShader:ShaderChunk.sprite_vert,fragmentShader:ShaderChunk.sprite_frag},background:{uniforms:{uvTransform:{value:new Matrix3},t2D:{value:null},backgroundIntensity:{value:1}},vertexShader:ShaderChunk.background_vert,fragmentShader:ShaderChunk.background_frag},backgroundCube:{uniforms:{envMap:{value:null},flipEnvMap:{value:-1},backgroundBlurriness:{value:0},backgroundIntensity:{value:1}},vertexShader:ShaderChunk.backgroundCube_vert,fragmentShader:ShaderChunk.backgroundCube_frag},cube:{uniforms:{tCube:{value:null},tFlip:{value:-1},opacity:{value:1}},vertexShader:ShaderChunk.cube_vert,fragmentShader:ShaderChunk.cube_frag},distanceRGBA:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.displacementmap,{referencePosition:{value:new Vector3},nearDistance:{value:1},farDistance:{value:1e3},slopeScaledBias:{value:0}}]),vertexShader:ShaderChunk.distanceRGBA_vert,fragmentShader:ShaderChunk.distanceRGBA_frag},shadow:{uniforms:mergeUniforms([UniformsLib.lights,UniformsLib.fog,{color:{value:new Color(0)},opacity:{value:1}}]),vertexShader:ShaderChunk.shadow_vert,fragmentShader:ShaderChunk.shadow_frag},mask:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.displacementmap,UniformsLib.mask]),vertexShader:ShaderChunk.mask_vert,fragmentShader:ShaderChunk.mask_frag},node:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.displacementmap,UniformsLib.envmap,UniformsLib.fog,UniformsLib.lights,UniformsLib.ssr,UniformsLib.planeReflectionProbe,UniformsLib.node,UniformsLib.nodeGTAO,{envMapIntensity:{value:1},envMapParallaxType:{value:0},envMapParallaxMatrix:{value:new Matrix4},envMapParallaxMatrixInv:{value:new Matrix4}}]),vertexShader:ShaderChunk.meshnode_vert,fragmentShader:ShaderChunk.meshnode_frag},cubeOctahedral:{uniforms:{tCube:{value:null},texelSize:{value:new Vector2(.5,.5)}},vertexShader:ShaderChunk.pp_plane_vert,fragmentShader:ShaderChunk.pp_cube_octahedral_proj_frag}};ShaderLib.copy={uniforms:{tDiffuse:{value:null},opacity:{value:1}},vertexShader:ShaderChunk.pp_plane_vert,fragmentShader:ShaderChunk.pp_copy_frag},ShaderLib.bokeh={defines:{DEPTH_PACKING:1,PERSPECTIVE_CAMERA:1},uniforms:{tColor:{value:null},tDepth:{value:null},focus:{value:1},aspect:{value:1},aperture:{value:.025},maxblur:{value:1},nearClip:{value:1},farClip:{value:1e3},depthLeakThreshold:{value:.2}},vertexShader:ShaderChunk.pp_plane_vert,fragmentShader:ShaderChunk.pp_bokeh_frag},ShaderLib.fxaa={uniforms:{tDiffuse:{value:null},resolution:{value:new Vector2(1/1024,1/512)}},vertexShader:ShaderChunk.pp_plane_vert,fragmentShader:ShaderChunk.pp_fxaa_frag},ShaderLib.grayscale={uniforms:{tDiffuse:{value:null}},vertexShader:ShaderChunk.pp_plane_vert,fragmentShader:ShaderChunk.pp_grayscale_frag},ShaderLib.brightness_contrast={uniforms:{tDiffuse:{value:null},brightness:{value:0},contrast:{value:0}},vertexShader:ShaderChunk.pp_plane_vert,fragmentShader:ShaderChunk.pp_brightness_contrast_frag},ShaderLib.bloomLumHighPass={uniforms:{tDiffuse:{type:"t",value:null},luminosityThreshold:{type:"f",value:1},smoothWidth:{type:"f",value:1},defaultColor:{type:"c",value:new Color(0)},defaultOpacity:{type:"f",value:0}},vertexShader:ShaderChunk.pp_plane_vert,fragmentShader:ShaderChunk.pp_bloom_lum_high_pass_frag},ShaderLib.blur={defines:{LOG_SPACE:0,OCTAHEDRAL_MAP:0},uniforms:{colorTexture:{value:null},texSize:{value:new Vector2(.5,.5)},direction:{value:new Vector2(.5,.5)},kernelRadius:{value:1}},customPrepTokens:{MAX_SAMPLE_RADIUS:4},vertexShader:ShaderChunk.pp_plane_vert,fragmentShader:ShaderChunk.pp_blur_frag},ShaderLib.tonemap={uniforms:{tDiffuse:{value:null}},vertexShader:ShaderChunk.pp_plane_vert,fragmentShader:ShaderChunk.pp_tonemap_frag},ShaderLib.afterimage={uniforms:{damp:{value:.96},tOld:{value:null},tNew:{value:null}},vertexShader:ShaderChunk.pp_plane_vert,fragmentShader:ShaderChunk.pp_afterimage_frag},ShaderLib.oitWeighted={uniforms:{tRGBABuffer:{value:null},tFloatBuffer:{value:null}},vertexShader:ShaderChunk.pp_plane_vert,fragmentShader:ShaderChunk.pp_oit_weighted_frag};const _rgb={r:0,b:0,g:0};function WebGLBackground(e,t,n,o,r,i,a){const s=new Color(0);let l,c,u=!0===i?0:1,d=null,h=0,p=null;function f(t,n){t.getRGB(_rgb,getUnlitUniformColorSpace(e)),o.buffers.color.setClear(_rgb.r,_rgb.g,_rgb.b,n,a)}return{getClearColor:function(){return s},setClearColor:function(e,t=1){s.set(e),u=t,f(s,u)},getClearAlpha:function(){return u},setClearAlpha:function(e){u=e,f(s,u)},dispose:function(){l&&(l.geometry.dispose(),l.material.dispose()),l=void 0,c&&(c.geometry.dispose(),c.material.dispose()),c=void 0},render:function(o,i){let a=!1,m=!0===i.isScene?i.background:null;if(m&&m.isTexture){m=(i.backgroundBlurriness>0?n:t).get(m)}const g=e.xr,_=g.getSession&&g.getSession();_&&"additive"===_.environmentBlendMode&&(m=null),null===m?f(s,u):m&&m.isColor&&(f(m,1),a=!0),(e.autoClear||a)&&e.clear(e.autoClearColor,e.autoClearDepth,e.autoClearStencil),m&&(m.isCubeTexture||306===m.mapping)?(void 0===c&&(c=new Mesh(new BoxGeometry(1,1,1),new ShaderMaterial({type:"BackgroundCubeMaterial",uniforms:cloneUniforms(ShaderLib.backgroundCube.uniforms),vertexShader:ShaderLib.backgroundCube.vertexShader,fragmentShader:ShaderLib.backgroundCube.fragmentShader,side:1,depthTest:!1,depthWrite:!1,fog:!1})),c.geometry.deleteAttribute("normal"),c.geometry.deleteAttribute("uv"),c.onBeforeRender=function(e,t,n){const o=n.far;this.matrixWorld.makeScale(o,o,o),this.matrixWorld.copyPosition(n.matrixWorld)},Object.defineProperty(c.material,"envMap",{get:function(){return this.uniforms.envMap.value}}),r.update(c)),c.material.uniforms.envMap.value=m,c.material.uniforms.flipEnvMap.value=m.isCubeTexture&&!1===m.isRenderTargetTexture?-1:1,c.material.uniforms.backgroundBlurriness.value=i.backgroundBlurriness,c.material.uniforms.backgroundIntensity.value=i.backgroundIntensity,c.material.toneMapped=i.backgroundToneMapped,d===m&&h===m.version&&p===e.toneMapping||(c.material.needsUpdate=!0,d=m,h=m.version,p=e.toneMapping),c.layers.enableAll(),o.unshift(c,c.geometry,c.material,0,0,null)):m&&m.isTexture&&(void 0===l&&(l=new Mesh(new PlaneGeometry(2,2),new ShaderMaterial({type:"BackgroundMaterial",uniforms:cloneUniforms(ShaderLib.background.uniforms),vertexShader:ShaderLib.background.vertexShader,fragmentShader:ShaderLib.background.fragmentShader,side:0,depthTest:!1,depthWrite:!1,fog:!1})),l.geometry.deleteAttribute("normal"),Object.defineProperty(l.material,"map",{get:function(){return this.uniforms.t2D.value}}),r.update(l)),l.material.uniforms.t2D.value=m,l.material.uniforms.backgroundIntensity.value=i.backgroundIntensity,l.material.toneMapped=i.backgroundToneMapped,!0===m.matrixAutoUpdate&&m.updateMatrix(),l.material.uniforms.uvTransform.value.copy(m.matrix),d===m&&h===m.version&&p===e.toneMapping||(l.material.needsUpdate=!0,d=m,h=m.version,p=e.toneMapping),l.layers.enableAll(),o.unshift(l,l.geometry,l.material,0,0,null))}}}function WebGLBindingStates(e,t,n,o){const r=e.getParameter(34921),i=o.isWebGL2?null:t.get("OES_vertex_array_object"),a=o.isWebGL2||null!==i,s={},l=p(null);let c=l,u=!1;function d(t){return o.isWebGL2?e.bindVertexArray(t):i.bindVertexArrayOES(t)}function h(t){return o.isWebGL2?e.deleteVertexArray(t):i.deleteVertexArrayOES(t)}function p(e){const t=[],n=[],o=[];for(let e=0;e<r;e++)t[e]=0,n[e]=0,o[e]=0;return{geometry:null,program:null,wireframe:!1,newAttributes:t,enabledAttributes:n,attributeDivisors:o,object:e,attributes:{},index:null}}function f(){const e=c.newAttributes;for(let t=0,n=e.length;t<n;t++)e[t]=0}function m(e){g(e,0)}function g(n,r){const i=c.newAttributes,a=c.enabledAttributes,s=c.attributeDivisors;if(i[n]=1,0===a[n]&&(e.enableVertexAttribArray(n),a[n]=1),s[n]!==r){(o.isWebGL2?e:t.get("ANGLE_instanced_arrays"))[o.isWebGL2?"vertexAttribDivisor":"vertexAttribDivisorANGLE"](n,r),s[n]=r}}function _(){const t=c.newAttributes,n=c.enabledAttributes;for(let o=0,r=n.length;o<r;o++)n[o]!==t[o]&&(e.disableVertexAttribArray(o),n[o]=0)}function A(t,n,o,r,i,a,s){!0===s?e.vertexAttribIPointer(t,n,o,i,a):e.vertexAttribPointer(t,n,o,r,i,a)}function v(){x(),u=!0,c!==l&&(c=l,d(c.object))}function x(){l.geometry=null,l.program=null,l.wireframe=!1}return{setup:function(r,l,h,v,x){let y=!1;if(a){const t=function(t,n,r){const a=!0===r.wireframe;let l=s[t.id];void 0===l&&(l={},s[t.id]=l);let c=l[n.id];void 0===c&&(c={},l[n.id]=c);let u=c[a];void 0===u&&(u=p(o.isWebGL2?e.createVertexArray():i.createVertexArrayOES()),c[a]=u);return u}(v,h,l);c!==t&&(c=t,d(c.object)),y=function(e,t,n,o){const r=c.attributes,i=t.attributes;let a=0;const s=n.getAttributes();for(const t in s){if(s[t].location>=0){const n=r[t];let o=i[t];if(void 0===o&&("instanceMatrix"===t&&e.instanceMatrix&&(o=e.instanceMatrix),"instanceColor"===t&&e.instanceColor&&(o=e.instanceColor)),void 0===n)return!0;if(n.attribute!==o)return!0;if(o&&n.data!==o.data)return!0;a++}}return c.attributesNum!==a||c.index!==o}(r,v,h,x),y&&function(e,t,n,o){const r={},i=t.attributes;let a=0;const s=n.getAttributes();for(const t in s){if(s[t].location>=0){let n=i[t];void 0===n&&("instanceMatrix"===t&&e.instanceMatrix&&(n=e.instanceMatrix),"instanceColor"===t&&e.instanceColor&&(n=e.instanceColor));const o={};o.attribute=n,n&&n.data&&(o.data=n.data),r[t]=o,a++}}c.attributes=r,c.attributesNum=a,c.index=o}(r,v,h,x)}else{const e=!0===l.wireframe;c.geometry===v.id&&c.program===h.id&&c.wireframe===e||(c.geometry=v.id,c.program=h.id,c.wireframe=e,y=!0)}null!==x&&n.update(x,34963),(y||u)&&(u=!1,function(r,i,a,s){if(!1===o.isWebGL2&&(r.isInstancedMesh||s.isInstancedBufferGeometry)&&null===t.get("ANGLE_instanced_arrays"))return;f();const l=s.attributes,c=a.getAttributes(),u=i.defaultAttributeValues;for(const t in c){const i=c[t];if(i.location>=0){let a=l[t];if(void 0===a&&("instanceMatrix"===t&&r.instanceMatrix&&(a=r.instanceMatrix),"instanceColor"===t&&r.instanceColor&&(a=r.instanceColor)),void 0!==a){const t=a.normalized,l=a.itemSize,c=n.get(a);if(void 0===c)continue;const u=c.buffer,d=c.type,h=c.bytesPerElement,p=!0===o.isWebGL2&&(5124===d||5125===d||1013===a.gpuType);if(a.isInstancedBufferAttribute){for(let e=0;e<i.locationSize;e++)g(i.location+e,a.meshPerAttribute);!0!==r.isInstancedMesh&&void 0===s._maxInstanceCount&&(s._maxInstanceCount=a.meshPerAttribute*a.count)}else for(let e=0;e<i.locationSize;e++)m(i.location+e);e.bindBuffer(34962,u);for(let e=0;e<i.locationSize;e++)A(i.location+e,l/i.locationSize,d,t,l*h,l/i.locationSize*e*h,p)}else if(void 0!==u){const n=u[t];if(void 0!==n)switch(n.length){case 2:e.vertexAttrib2fv(i.location,n);break;case 3:e.vertexAttrib3fv(i.location,n);break;case 4:e.vertexAttrib4fv(i.location,n);break;default:e.vertexAttrib1fv(i.location,n)}}}}_()}(r,l,h,v),null!==x&&e.bindBuffer(34963,n.get(x).buffer))},reset:v,resetDefaultState:x,dispose:function(){v();for(const e in s){const t=s[e];for(const e in t){const n=t[e];for(const e in n)h(n[e].object),delete n[e];delete t[e]}delete s[e]}},releaseStatesOfGeometry:function(e){if(void 0===s[e.id])return;const t=s[e.id];for(const e in t){const n=t[e];for(const e in n)h(n[e].object),delete n[e];delete t[e]}delete s[e.id]},releaseStatesOfProgram:function(e){for(const t in s){const n=s[t];if(void 0===n[e.id])continue;const o=n[e.id];for(const e in o)h(o[e].object),delete o[e];delete n[e.id]}},initAttributes:f,enableAttribute:m,disableUnusedAttributes:_}}function WebGLBufferRenderer(e,t,n,o){const r=o.isWebGL2;let i;this.setMode=function(e){i=e},this.render=function(t,o){e.drawArrays(i,t,o),n.update(o,i,1)},this.renderInstances=function(o,a,s){if(0===s)return;let l,c;if(r)l=e,c="drawArraysInstanced";else if(l=t.get("ANGLE_instanced_arrays"),c="drawArraysInstancedANGLE",null===l)return void console.error("v3d.WebGLBufferRenderer: using v3d.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");l[c](i,o,a,s),n.update(a,i,s)}}function WebGLCapabilities(e,t,n){let o;function r(t){if("highp"===t){if(e.getShaderPrecisionFormat(35633,36338).precision>0&&e.getShaderPrecisionFormat(35632,36338).precision>0)return"highp";t="mediump"}return"mediump"===t&&e.getShaderPrecisionFormat(35633,36337).precision>0&&e.getShaderPrecisionFormat(35632,36337).precision>0?"mediump":"lowp"}const i="undefined"!=typeof WebGL2RenderingContext&&e instanceof WebGL2RenderingContext||"undefined"!=typeof WebGL2ComputeRenderingContext&&e instanceof WebGL2ComputeRenderingContext;let a=void 0!==n.precision?n.precision:"highp";const s=r(a);s!==a&&(console.warn("v3d.WebGLRenderer:",a,"not supported, using",s,"instead."),a=s);const l=!0===n.logarithmicDepthBuffer,c=e.getParameter(34930),u=e.getParameter(35660),d=e.getParameter(3379),h=e.getParameter(34076),p=e.getParameter(34921),f=e.getParameter(36347),m=e.getParameter(36348),g=e.getParameter(36349),_=u>0,A=i||t.has("OES_texture_float");return{isWebGL2:i,getMaxAnisotropy:function(){if(void 0!==o)return o;if(!0===t.has("EXT_texture_filter_anisotropic")){const n=t.get("EXT_texture_filter_anisotropic");o=e.getParameter(n.MAX_TEXTURE_MAX_ANISOTROPY_EXT)}else o=0;return o},getMaxPrecision:r,precision:a,logarithmicDepthBuffer:l,maxTextures:c,maxVertexTextures:u,maxTextureSize:d,maxCubemapSize:h,maxAttributes:p,maxVertexUniforms:f,maxVaryings:m,maxFragmentUniforms:g,vertexTextures:_,floatFragmentTextures:A,floatVertexTextures:_&&A,maxSamples:i?e.getParameter(36183):0}}function WebGLClipping(e){const t=this;let n=null,o=0,r=!1,i=!1;const a=new Plane,s=new Matrix3,l={value:null,needsUpdate:!1};function c(){l.value!==n&&(l.value=n,l.needsUpdate=o>0),t.numPlanes=o,t.numIntersection=0}function u(e,n,o,r){const i=null!==e?e.length:0;let c=null;if(0!==i){if(c=l.value,!0!==r||null===c){const t=o+4*i,r=n.matrixWorldInverse;s.getNormalMatrix(r),(null===c||c.length<t)&&(c=new Float32Array(t));for(let t=0,n=o;t!==i;++t,n+=4)a.copy(e[t]).applyMatrix4(r,s),a.normal.toArray(c,n),c[n+3]=a.constant}l.value=c,l.needsUpdate=!0}return t.numPlanes=i,t.numIntersection=0,c}this.uniform=l,this.numPlanes=0,this.numIntersection=0,this.init=function(e,t,i){const a=0!==e.length||t||0!==o||r;return r=t,n=u(e,i,0),o=e.length,a},this.beginShadows=function(){i=!0,u(null)},this.endShadows=function(){i=!1,c()},this.setState=function(t,a,s){const d=t.clippingPlanes,h=t.clipIntersection,p=t.clipShadows,f=e.get(t);if(!r||null===d||0===d.length||i&&!p)i?u(null):c();else{const e=i?0:o,t=4*e;let r=f.clippingState||null;l.value=r,r=u(d,a,t,s);for(let e=0;e!==t;++e)r[e]=n[e];f.clippingState=r,this.numIntersection=h?this.numPlanes:0,this.numPlanes+=e}}}function WebGLCubeMaps(e){let t=new WeakMap;function n(e,t){return 303===t?e.mapping=301:304===t&&(e.mapping=302),e}function o(e){const n=e.target;n.removeEventListener("dispose",o);const r=t.get(n);void 0!==r&&(t.delete(n),r.dispose())}return{get:function(r){if(r&&r.isTexture&&!1===r.isRenderTargetTexture){const i=r.mapping;if(303===i||304===i){if(t.has(r)){return n(t.get(r).texture,r.mapping)}{const i=r.image;if(i&&i.height>0){const a=new WebGLCubeRenderTarget(i.height/2);return a.fromEquirectangularTexture(e,r),t.set(r,a),r.addEventListener("dispose",o),n(a.texture,r.mapping)}return null}}}return r},dispose:function(){t=new WeakMap}}}class OrthographicCamera extends Camera{constructor(e=-1,t=1,n=1,o=-1,r=.1,i=2e3){super(),this.isOrthographicCamera=!0,this.type="OrthographicCamera",this.zoom=1,this.view=null,this.left=e,this.right=t,this.top=n,this.bottom=o,this.near=r,this.far=i,this.updateProjectionMatrix()}copy(e,t){return super.copy(e,t),this.left=e.left,this.right=e.right,this.top=e.top,this.bottom=e.bottom,this.near=e.near,this.far=e.far,this.zoom=e.zoom,this.view=null===e.view?null:Object.assign({},e.view),this}setViewOffset(e,t,n,o,r,i){null===this.view&&(this.view={enabled:!0,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=!0,this.view.fullWidth=e,this.view.fullHeight=t,this.view.offsetX=n,this.view.offsetY=o,this.view.width=r,this.view.height=i,this.updateProjectionMatrix()}clearViewOffset(){null!==this.view&&(this.view.enabled=!1),this.updateProjectionMatrix()}updateProjectionMatrix(){const e=(this.right-this.left)/(2*this.zoom),t=(this.top-this.bottom)/(2*this.zoom),n=(this.right+this.left)/2,o=(this.top+this.bottom)/2;let r=n-e,i=n+e,a=o+t,s=o-t;if(null!==this.view&&this.view.enabled){const e=(this.right-this.left)/this.view.fullWidth/this.zoom,t=(this.top-this.bottom)/this.view.fullHeight/this.zoom;r+=e*this.view.offsetX,i=r+e*this.view.width,a-=t*this.view.offsetY,s=a-t*this.view.height}this.projectionMatrix.makeOrthographic(r,i,a,s,this.near,this.far),this.projectionMatrixInverse.copy(this.projectionMatrix).invert()}}class RawShaderMaterial extends ShaderMaterial{constructor(e){super(e),this.isRawShaderMaterial=!0,this.type="RawShaderMaterial"}}let MAX_TILE_SIZE=256;const LOD_CONFIG=[{relSize:1,sigma:0,origin:[0,0]},{relSize:.5,sigma:.025,origin:[0,2/3]},{relSize:1/4,sigma:.07,origin:[.5,2/3]},{relSize:1/8,sigma:.18,origin:[.75,2/3]},{relSize:1/16,sigma:.24,origin:[.875,2/3]},{relSize:1/16,sigma:.3,origin:[.875,17/24]},{relSize:1/16,sigma:.36,origin:[.875,.75]},{relSize:1/16,sigma:.42,origin:[.875,19/24]},{relSize:1/16,sigma:.48,origin:[.875,20/24]},{relSize:1/16,sigma:.54,origin:[.875,.875]},{relSize:1/16,sigma:.6,origin:[.875,22/24]}];function _getLodTileSize(e){return LOD_CONFIG[e].relSize*MAX_TILE_SIZE}function _getLodOrigin(e){return LOD_CONFIG[e].origin.map(function(e){return e*MAX_TILE_SIZE*3})}const MAX_SAMPLES=20,_flatCamera=new OrthographicCamera,_lodPlanes=_createPlanes(),_clearColor$2=new Color;let _oldTarget=null;const PHI=(1+Math.sqrt(5))/2,INV_PHI=1/PHI,_axisDirections=[new Vector3(1,1,1),new Vector3(-1,1,1),new Vector3(1,1,-1),new Vector3(-1,1,-1),new Vector3(0,PHI,INV_PHI),new Vector3(0,PHI,-INV_PHI),new Vector3(INV_PHI,0,PHI),new Vector3(-INV_PHI,0,PHI),new Vector3(PHI,INV_PHI,0),new Vector3(-PHI,INV_PHI,0)];class PMREMGenerator{constructor(e,t){this._renderer=e,this._pingPongRenderTarget=null,this._equirectShader=null,this._cubemapShader=null,this.flipCubemapX=!1,Object.defineProperties(this,{maxTileSize:{get:function(){return MAX_TILE_SIZE},set:function(e){MAX_TILE_SIZE=e}}}),void 0!==t&&(this.maxTileSize=t),this._blurMaterial=_getBlurShader(20,this.maxTileSize),this._compileMaterial(this._blurMaterial)}fromScene(e,t=0,n=.1,o=100){_oldTarget=this._renderer.getRenderTarget();const r=this._allocateTargets();return this._sceneToCubeUV(e,n,o,r),t>0&&this._blur(r,0,0,t),this._applyPMREM(r),this._cleanup(r),r}fromEquirectangular(e){return e.magFilter=1006,e.minFilter=1006,e.generateMipmaps=!1,this.fromCubemap(e)}fromCubemap(e){_oldTarget=this._renderer.getRenderTarget();const t=this._allocateTargets(e);return this._textureToCubeUV(e,t,this.flipCubemapX),this._applyPMREM(t),this._cleanup(t),t}fromCubeRenderTarget(e,t){const n=this._allocateTargets(e.texture,t);return this._cubeRTToCubeUV(e,n,this.flipCubemapX),this._applyPMREM(n),this._cleanup(n),n}compileCubemapShader(){null===this._cubemapShader&&(this._cubemapShader=_getCubemapShader(),this._compileMaterial(this._cubemapShader))}compileEquirectangularShader(){null===this._equirectShader&&(this._equirectShader=_getEquirectShader(),this._compileMaterial(this._equirectShader))}dispose(){this._blurMaterial.dispose(),null!==this._pingPongRenderTarget&&this._pingPongRenderTarget.dispose(),null!==this._cubemapShader&&this._cubemapShader.dispose(),null!==this._equirectShader&&this._equirectShader.dispose();for(let e=0;e<_lodPlanes.length;e++)_lodPlanes[e].dispose();this._renderer=null}_cleanup(e){this._renderer.setRenderTarget(_oldTarget),e.scissorTest=!1,e.setSize(e.width,e.height)}_allocateTargets(e,t){const n={magFilter:1006,minFilter:1006,generateMipmaps:!1,type:e?e.type:1016,format:e?e.format:1023,encoding:e?e.encoding:3e3,depthBuffer:!1,stencilBuffer:!1};void 0!==t&&Object.assign(n,t);const o=_createRenderTarget(n);return o.depthBuffer=!e,null===this._pingPongRenderTarget&&(this._pingPongRenderTarget=_createRenderTarget(n)),o}_compileMaterial(e){const t=new Scene;t.add(new Mesh(_lodPlanes[0],e)),this._renderer.compile(t,_flatCamera)}_sceneToCubeUV(e,t,n,o){const r=new PerspectiveCamera(90,1,t,n),i=[1,1,1,1,-1,1],a=[1,1,-1,-1,-1,1],s=this._renderer,l=s.outputEncoding,c=s.toneMapping,u=s.toneMappingExposure;s.getClearColor(_clearColor$2);const d=s.getClearAlpha();s.toneMapping=1,s.toneMappingExposure=1,s.outputEncoding=3e3,e.scale.z*=-1;let h=e.background;if(h&&h.isColor){h.convertSRGBToLinear();const t=Math.max(h.r,h.g,h.b),n=Math.min(Math.max(Math.ceil(Math.log2(t)),-128),127);h=h.multiplyScalar(Math.pow(2,-n));const o=(n+128)/255;s.setClearColor(h,o),e.background=null}for(let t=0;t<6;t++){const n=t%3;0===n?(r.up.set(0,i[t],0),r.lookAt(a[t],0,0)):1===n?(r.up.set(0,0,i[t]),r.lookAt(0,a[t],0)):(r.up.set(0,i[t],0),r.lookAt(0,0,a[t]));const l=_getLodTileSize(0);_setViewport(o,n*l,t>2?l:0,l,l),s.setRenderTarget(o),s.render(e,r)}s.toneMapping=c,s.toneMappingExposure=u,s.outputEncoding=l,s.setClearColor(_clearColor$2,d),e.scale.z*=-1}_textureToCubeUV(e,t,n){const o=this._renderer,r=new Scene;e.isCubeTexture?null===this._cubemapShader&&(this._cubemapShader=_getCubemapShader()):null===this._equirectShader&&(this._equirectShader=_getEquirectShader());const i=e.isCubeTexture?this._cubemapShader:this._equirectShader;r.add(new Mesh(_lodPlanes[0],i));const a=i.uniforms;a.envMap.value=e,e.isCubeTexture?a.flipCubemapX.value=n||!1:a.texelSize.value.set(1/e.image.width,1/e.image.height);const s=_getLodTileSize(0);_setViewport(t,0,0,3*s,2*s),o.setRenderTarget(t),o.render(r,_flatCamera)}_applyPMREM(e){const t=this._renderer,n=t.autoClear;t.autoClear=!1;for(let t=1;t<LOD_CONFIG.length;t++){const n=LOD_CONFIG[t].sigma,o=LOD_CONFIG[t-1].sigma,r=Math.sqrt(n*n-o*o),i=_axisDirections[(t-1)%_axisDirections.length];this._blur(e,t-1,t,r,i)}t.autoClear=n}_blur(e,t,n,o,r){const i=this._pingPongRenderTarget;this._halfBlur(e,i,t,n,o,"latitudinal",r),this._halfBlur(i,e,n,n,o,"longitudinal",r)}_halfBlur(e,t,n,o,r,i,a){const s=this._renderer,l=this._blurMaterial;"latitudinal"!==i&&"longitudinal"!==i&&console.error("blur direction must be either latitudinal or longitudinal!");const c=new Scene;c.add(new Mesh(_lodPlanes[o],l));const u=l.uniforms,d=_getLodTileSize(n)-1;let h=isFinite(r)?Math.PI/(2*d):2*Math.PI/39,p=r/h,f=isFinite(r)?1+Math.floor(3*p):20;f>20&&(f=20,p=19/3,h=r/p);const m=[];let g=0;for(let e=0;e<20;++e){const t=e/p,n=Math.exp(-t*t/2);m.push(n),0===e?g+=n:e<f&&(g+=2*n)}for(let e=0;e<m.length;e++)m[e]=m[e]/g;u.envMap.value=e.texture,u.samples.value=f,u.weights.value=m,u.latitudinal.value="latitudinal"===i,a&&(u.poleAxis.value=a),u.dTheta.value=h,u.lodIdx.value=n;l.defines.cubeUV_maxTileSize=shaderFloatStr(_getLodTileSize(0));const[_,A]=_getLodOrigin(o),v=_getLodTileSize(o);_setViewport(t,_,A,3*v,2*v),s.setRenderTarget(t),s.render(c,_flatCamera)}_cubeRTToCubeUV(e,t,n){const o=this._renderer,r=new Scene;null==this._cubemapShader&&(this._cubemapShader=_getCubemapShader());const i=this._cubemapShader;r.add(new Mesh(_lodPlanes[0],i));const a=i.uniforms;a.envMap.value=e.texture,a.flipCubemapX.value=n||!1;const s=_getLodTileSize(0);_setViewport(t,0,0,3*s,2*s),o.setRenderTarget(t),o.render(r,_flatCamera)}}function _createPlanes(){return LOD_CONFIG.map(function(e,t){const n=1/(_getLodTileSize(t)-1),o=-n/2,r=1+n/2,i=[o,o,r,o,r,r,o,o,r,r,o,r],a=new Float32Array(108),s=new Float32Array(72),l=new Float32Array(36);for(let e=0;e<6;e++){const t=e%3*2/3-1,n=e>2?0:-1,o=[t,n,0,t+2/3,n,0,t+2/3,n+1,0,t,n,0,t+2/3,n+1,0,t,n+1,0];a.set(o,18*e),s.set(i,12*e);const r=[e,e,e,e,e,e];l.set(r,6*e)}const c=new BufferGeometry;return c.setAttribute("position",new BufferAttribute(a,3)),c.setAttribute("uv",new BufferAttribute(s,2)),c.setAttribute("faceIndex",new BufferAttribute(l,1)),c})}function _createRenderTarget(e){const t=_getLodTileSize(0),n=new WebGLRenderTarget(3*t,3*t,e);return n.texture.mapping=306,n.texture.name="PMREM.cubeUV",n.scissorTest=!0,n}function _setViewport(e,t,n,o,r){e.viewport.set(t,n,o,r),e.scissor.set(t,n,o,r)}function _getBlurShader(e,t){const n=new Float32Array(e),o=new Vector3(0,1,0),r=new RawShaderMaterial({defines:{n:e,cubeUV_maxTileSize:shaderFloatStr(t)},uniforms:{envMap:{value:null},samples:{value:1},weights:{value:n},latitudinal:{value:!1},dTheta:{value:0},lodIdx:{value:0},poleAxis:{value:o}},vertexShader:ShaderChunk.pmrem_common_vert,fragmentShader:ShaderChunk.pmrem_blur_frag,blending:0,depthTest:!1,depthWrite:!1});return r.type="SphericalGaussianBlur",r}function _getEquirectShader(){const e=new Vector2(1,1),t=new RawShaderMaterial({uniforms:{envMap:{value:null},texelSize:{value:e}},vertexShader:ShaderChunk.pmrem_common_vert,fragmentShader:ShaderChunk.pmrem_equirect_frag,blending:0,depthTest:!1,depthWrite:!1});return t.type="EquirectangularToCubeUV",t}function _getCubemapShader(){const e=new RawShaderMaterial({uniforms:{envMap:{value:null},flipCubemapX:{value:!1}},vertexShader:ShaderChunk.pmrem_common_vert,fragmentShader:ShaderChunk.pmrem_cubemap_frag,blending:0,depthTest:!1,depthWrite:!1});return e.type="CubemapToCubeUV",e}function WebGLCubeUVMaps(e){let t=new WeakMap,n=null;function o(e){const n=e.target;n.removeEventListener("dispose",o);const r=t.get(n);void 0!==r&&(t.delete(n),r.dispose())}return{get:function(r){if(r&&r.isTexture){const i=r.mapping,a=303===i||304===i,s=301===i||302===i;if(a||s){if(r.isRenderTargetTexture&&!0===r.needsPMREMUpdate){r.needsPMREMUpdate=!1;let o=t.get(r);return null===n&&(n=new PMREMGenerator(e)),o=a?n.fromEquirectangular(r,o):n.fromCubemap(r,o),t.set(r,o),o.texture}if(t.has(r))return t.get(r).texture;{const i=r.image;if(a&&i&&i.height>0||s&&i&&function(e){let t=0;const n=6;for(let o=0;o<n;o++)void 0!==e[o]&&t++;return t===n}(i)){null===n&&(n=new PMREMGenerator(e));const i=a?n.fromEquirectangular(r):n.fromCubemap(r);return t.set(r,i),r.addEventListener("dispose",o),i.texture}return null}}}return r},dispose:function(){t=new WeakMap,null!==n&&(n.dispose(),n=null)}}}function WebGLExtensions(e){const t={};function n(n){if(void 0!==t[n])return t[n];let o;switch(n){case"WEBGL_depth_texture":o=e.getExtension("WEBGL_depth_texture")||e.getExtension("MOZ_WEBGL_depth_texture")||e.getExtension("WEBKIT_WEBGL_depth_texture");break;case"EXT_texture_filter_anisotropic":o=e.getExtension("EXT_texture_filter_anisotropic")||e.getExtension("MOZ_EXT_texture_filter_anisotropic")||e.getExtension("WEBKIT_EXT_texture_filter_anisotropic");break;case"WEBGL_compressed_texture_s3tc":o=e.getExtension("WEBGL_compressed_texture_s3tc")||e.getExtension("MOZ_WEBGL_compressed_texture_s3tc")||e.getExtension("WEBKIT_WEBGL_compressed_texture_s3tc");break;case"WEBGL_compressed_texture_pvrtc":o=e.getExtension("WEBGL_compressed_texture_pvrtc")||e.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc");break;default:o=e.getExtension(n)}return t[n]=o,o}return{has:function(e){return null!==n(e)},init:function(e){e.isWebGL2?n("EXT_color_buffer_float"):(n("WEBGL_depth_texture"),n("OES_texture_float"),n("OES_texture_half_float"),n("OES_texture_half_float_linear"),n("OES_standard_derivatives"),n("OES_element_index_uint"),n("OES_vertex_array_object"),n("ANGLE_instanced_arrays")),n("OES_texture_float_linear"),n("EXT_color_buffer_half_float"),n("WEBGL_multisampled_render_to_texture")},get:function(e){const t=n(e);return null===t&&console.warn("v3d.WebGLRenderer: "+e+" extension not supported."),t}}}function WebGLGeometries(e,t,n,o){const r={},i=new WeakMap;function a(e){const s=e.target;null!==s.index&&t.remove(s.index);for(const e in s.attributes)t.remove(s.attributes[e]);s.removeEventListener("dispose",a),delete r[s.id];const l=i.get(s);l&&(t.remove(l),i.delete(s)),o.releaseStatesOfGeometry(s),!0===s.isInstancedBufferGeometry&&delete s._maxInstanceCount,n.memory.geometries--}function s(e){const n=[],o=e.index,r=e.attributes.position;let a=0;if(null!==o){const e=o.array;a=o.version;for(let t=0,o=e.length;t<o;t+=3){const o=e[t+0],r=e[t+1],i=e[t+2];n.push(o,r,r,i,i,o)}}else{const e=r.array;a=r.version;for(let t=0,o=e.length/3-1;t<o;t+=3){const e=t+0,o=t+1,r=t+2;n.push(e,o,o,r,r,e)}}const s=new(arrayNeedsUint32(n)?Uint32BufferAttribute:Uint16BufferAttribute)(n,1);s.version=a;const l=i.get(e);l&&t.remove(l),i.set(e,s)}return{get:function(e,t){return!0===r[t.id]||(t.addEventListener("dispose",a),r[t.id]=!0,n.memory.geometries++),t},update:function(e){const n=e.attributes;for(const e in n)t.update(n[e],34962);const o=e.morphAttributes;for(const e in o){const n=o[e];for(let e=0,o=n.length;e<o;e++)t.update(n[e],34962)}},getWireframeAttribute:function(e){const t=i.get(e);if(t){const n=e.index;null!==n&&t.version<n.version&&s(e)}else s(e);return i.get(e)}}}function WebGLIndexedBufferRenderer(e,t,n,o){const r=o.isWebGL2;let i,a,s;this.setMode=function(e){i=e},this.setIndex=function(e){a=e.type,s=e.bytesPerElement},this.render=function(t,o){e.drawElements(i,o,a,t*s),n.update(o,i,1)},this.renderInstances=function(o,l,c){if(0===c)return;let u,d;if(r)u=e,d="drawElementsInstanced";else if(u=t.get("ANGLE_instanced_arrays"),d="drawElementsInstancedANGLE",null===u)return void console.error("v3d.WebGLIndexedBufferRenderer: using v3d.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");u[d](i,l,a,o*s,c),n.update(l,i,c)}}function WebGLInfo(e){const t={geometries:0,textures:0,textureSpecs:new Map},n={frame:0,calls:0,triangles:0,points:0,lines:0,customCounter:0};return{memory:t,render:n,programs:null,numShaderCompiles:0,reset:function(){n.calls=0,n.triangles=0,n.points=0,n.lines=0,n.customCounter=0},update:function(e,t,o){switch(n.calls++,t){case 4:n.triangles+=o*(e/3);break;case 1:n.lines+=o*(e/2);break;case 3:n.lines+=o*(e-1);break;case 2:n.lines+=o*e;break;case 0:n.points+=o*e;break;default:console.error("v3d.WebGLInfo: Unknown draw mode:",t)}},count:function(){n.customCounter++},addTextureSpec:function(e){let n,o,r,i,a,s;e.isWebGLRenderTarget?(n=e.texture.name,o="RenderTarget",r=e.width,i=e.height,a=e.texture.format,s=!!e.texture.isCubeTexture):(n=e.name,o="Texture",r=e.image.width,i=e.image.height,a=e.format,s=!!e.isCubeTexture),t.textureSpecs.set(e,{name:n,type:o,width:r,height:i,format:a,isCube:s})},removeTextureSpec:function(e){t.textureSpecs.delete(e)}}}function WebGLMaterials(e,t){function n(e,n){e.opacity.value=n.opacity,n.color&&e.diffuse.value.copy(n.color),n.emissive&&e.emissive.value.copy(n.emissive).multiplyScalar(n.emissiveIntensity),n.map&&(e.map.value=n.map),n.alphaMap&&(e.alphaMap.value=n.alphaMap),n.bumpMap&&(e.bumpMap.value=n.bumpMap,e.bumpScale.value=n.bumpScale,1===n.side&&(e.bumpScale.value*=-1)),n.displacementMap&&(e.displacementMap.value=n.displacementMap,e.displacementScale.value=n.displacementScale,e.displacementBias.value=n.displacementBias),n.emissiveMap&&(e.emissiveMap.value=n.emissiveMap),n.normalMap&&(e.normalMap.value=n.normalMap,e.normalScale.value.copy(n.normalScale),1===n.side&&e.normalScale.value.negate()),n.alphaTest>0&&(e.alphaTest.value=n.alphaTest);const o=t.get(n).envMap;let r,i;o&&(e.envMap.value=o,e.flipEnvMap.value=o.isCubeTexture&&!1===o.isRenderTargetTexture?-1:1,e.reflectivity.value=n.reflectivity,e.refractionRatio.value=n.refractionRatio),n.lightMap&&(e.lightMap.value=n.lightMap,e.lightMapIntensity.value=n.lightMapIntensity),n.aoMap&&(e.aoMap.value=n.aoMap,e.aoMapIntensity.value=n.aoMapIntensity),n.map?r=n.map:n.displacementMap?r=n.displacementMap:n.normalMap?r=n.normalMap:n.bumpMap?r=n.bumpMap:n.roughnessMap?r=n.roughnessMap:n.metalnessMap?r=n.metalnessMap:n.alphaMap?r=n.alphaMap:n.emissiveMap&&(r=n.emissiveMap),void 0!==r&&(!0===r.matrixAutoUpdate&&r.updateMatrix(),e.uvTransform.value.copy(r.matrix)),n.aoMap?i=n.aoMap:n.lightMap&&(i=n.lightMap),void 0!==i&&(!0===i.matrixAutoUpdate&&i.updateMatrix(),e.uv2Transform.value.copy(i.matrix))}return{refreshFogUniforms:function(t,n){n.color.getRGB(t.fogColor.value,getUnlitUniformColorSpace(e)),n.isFog?(t.fogNear.value=n.near,t.fogFar.value=n.far):n.isFogExp2&&(t.fogDensity.value=n.density)},refreshMaterialUniforms:function(e,o,r,i){o.ssrParams&&function(e,t){e.invProjectionMatrix.value=t.ssrParams.invProjectionMatrix,e.ssrSourceBuffer.value=t.ssrParams.sourceBuffer.texture,e.ssrDepthBuffer.value=t.ssrParams.depthBuffer.texture,e.ssrBackfaceDepthBuffer.value=t.ssrParams.backfaceDepthBuffer.texture,e.ssrStride.value=t.ssrParams.stride,e.ssrJitter.value=t.ssrParams.jitter,e.ssrMaxDistance.value=t.ssrParams.maxDistance}(e,o),o.isMeshBasicMaterial||o.isMeshLambertMaterial?n(e,o):o.isMeshStandardMaterial?(n(e,o),function(e,n){e.roughness.value=n.roughness,e.metalness.value=n.metalness,n.roughnessMap&&(e.roughnessMap.value=n.roughnessMap);n.metalnessMap&&(e.metalnessMap.value=n.metalnessMap);const o=t.get(n).envMap;o&&(e.envMapIntensity.value=n.envMapIntensity,e.envMapParallaxType.value=n.envMapParallaxType,e.envMapParallaxMatrix.value.copy(n.envMapParallaxMatrix),e.envMapParallaxMatrixInv.value.copy(n.envMapParallaxMatrixInv))}(e,o)):o.isMeshDepthMaterial?(n(e,o),function(e,t){e.slopeScaledBias.value=t.slopeScaledBias}(e,o)):o.isMeshDistanceMaterial?(n(e,o),function(e,t){e.referencePosition.value.copy(t.referencePosition),e.nearDistance.value=t.nearDistance,e.farDistance.value=t.farDistance,e.slopeScaledBias.value=t.slopeScaledBias}(e,o)):o.isMeshNormalMaterial?n(e,o):o.isLineBasicMaterial?(function(e,t){e.diffuse.value.copy(t.color),e.opacity.value=t.opacity}(e,o),o.isLineDashedMaterial&&function(e,t){e.dashSize.value=t.dashSize,e.totalSize.value=t.dashSize+t.gapSize,e.scale.value=t.scale}(e,o)):o.isPointsMaterial?function(e,t,n,o){e.diffuse.value.copy(t.color),e.opacity.value=t.opacity,e.size.value=t.size*n,e.scale.value=.5*o,t.map&&(e.map.value=t.map);t.alphaMap&&(e.alphaMap.value=t.alphaMap);t.alphaTest>0&&(e.alphaTest.value=t.alphaTest);let r;t.map?r=t.map:t.alphaMap&&(r=t.alphaMap);void 0!==r&&(!0===r.matrixAutoUpdate&&r.updateMatrix(),e.uvTransform.value.copy(r.matrix))}(e,o,r,i):o.isSpriteMaterial?function(e,t){e.diffuse.value.copy(t.color),e.opacity.value=t.opacity,e.rotation.value=t.rotation,t.map&&(e.map.value=t.map);t.alphaMap&&(e.alphaMap.value=t.alphaMap);t.alphaTest>0&&(e.alphaTest.value=t.alphaTest);let n;t.map?n=t.map:t.alphaMap&&(n=t.alphaMap);void 0!==n&&(!0===n.matrixAutoUpdate&&n.updateMatrix(),e.uvTransform.value.copy(n.matrix))}(e,o):o.isShadowMaterial?(e.color.value.copy(o.color),e.opacity.value=o.opacity):o.isMeshMaskMaterial?(n(e,o),function(e,t){t.cameraNearFar&&(e.cameraNearFar.value=t.cameraNearFar);e.depthTexture.value=t.depthTexture,t.textureMatrix&&(e.textureMatrix.value=t.textureMatrix)}(e,o)):o.isMeshNodeMaterial?function(e,n){n.alphaTest>0&&(e.alphaTest.value=n.alphaTest);for(let t=0;t<n.nodeValue.length;t++)e.nodeValue.value[t]=n.nodeValue[t];for(let t=0;t<n.nodeRGB.length;t++){n.nodeRGB[t].toArray(e.nodeRGB.value,4*t)}const o=t.get(n).envMap;o&&(e.envMap.value=o,e.flipEnvMap.value=o.isCubeTexture&&o.isRenderTargetTexture?-1:1,e.envMapIntensity.value=n.envMapIntensity,e.envMapParallaxType.value=n.envMapParallaxType,e.envMapParallaxMatrix.value.copy(n.envMapParallaxMatrix),e.envMapParallaxMatrixInv.value.copy(n.envMapParallaxMatrixInv));n.displacementMap&&(e.displacementMap.value=n.displacementMap,e.displacementScale.value=n.displacementScale,e.displacementBias.value=n.displacementBias);e.materialIndex.value=n.materialIndex}(e,o):o.isMeshLineMaterial?function(e,t){e.lineWidth.value=t.lineWidth,e.sizeAttenuation.value=t.sizeAttenuation,e.color.value=t.color,e.opacity.value=t.opacity,e.useMap.value=t.useMap,t.map&&(e.map.value=t.map);e.useAlphaMap.value=t.useAlphaMap,t.alphaMap&&(e.alphaMap.value=t.alphaMap);e.visibility.value=t.visibility,e.alphaTest.value=t.alphaTest,e.repeat.value=t.repeat}(e,o):o.isShaderMaterial&&(o.uniformsNeedUpdate=!1)},refreshGTAOUniforms:function(e,t){e.gtaoMap.value=t},refreshPlaneReflProbeUniforms:function(e,t){e.planeReflTexture.value=t.renderTarget.texture,e.planeReflTextureMatrix.value.copy(t.textureMatrix),e.planeReflDir.value.copy(t.normal),e.planeReflBoundingBoxMin.value.copy(t.boundingBox.min),e.planeReflBoundingBoxMax.value.copy(t.boundingBox.max),e.planeReflInvModelMatrix.value.copy(t.matrixWorldInverse),e.planeReflFalloff.value=t.falloff}}}function numericalSort(e,t){return e[0]-t[0]}function absNumericalSort(e,t){return Math.abs(t[1])-Math.abs(e[1])}function WebGLMorphtargets(e,t,n){const o={},r=new Float32Array(12),i=new WeakMap,a=new Vector4,s=[];for(let e=0;e<12;e++)s[e]=[e,0];return{update:function(l,c,u,d){const h=l.morphTargetInfluences;if(!0===t.isWebGL2){const o=c.morphAttributes.position||c.morphAttributes.normal,r=void 0!==o?o.length:0;let s=i.get(c);if(void 0===s||s.count!==r){void 0!==s&&s.texture.dispose();const e=void 0!==c.morphAttributes.position,n=void 0!==c.morphAttributes.normal,o=c.morphAttributes.position||[],l=c.morphAttributes.normal||[];let u=0;!0===e&&(u=1),!0===n&&(u=2);let d=c.attributes.position.count*u,h=1;d>t.maxTextureSize&&(h=Math.ceil(d/t.maxTextureSize),d=t.maxTextureSize);const p=new Float32Array(d*h*4*r),f=new DataArrayTexture(p,d,h,r);f.type=1015,f.needsUpdate=!0;const m=4*u;for(let t=0;t<r;t++){const r=o[t],i=l[t],s=d*h*4*t;for(let t=0;t<r.count;t++){const o=t*m;!0===e&&(a.fromBufferAttribute(r,t),p[s+o+0]=a.x,p[s+o+1]=a.y,p[s+o+2]=a.z,p[s+o+3]=0),!0===n&&(a.fromBufferAttribute(i,t),p[s+o+4]=a.x,p[s+o+5]=a.y,p[s+o+6]=a.z,p[s+o+7]=0)}}s={count:r,texture:f,size:new Vector2(d,h)},i.set(c,s),c.addEventListener("dispose",function e(){f.dispose(),i.delete(c),c.removeEventListener("dispose",e)})}let l=0;for(let e=0;e<h.length;e++)l+=h[e];const u=c.morphTargetsRelative?1:1-l;d.getUniforms().setValue(e,"morphTargetBaseInfluence",u),d.getUniforms().setValue(e,"morphTargetInfluences",h),d.getUniforms().setValue(e,"morphTargetsTexture",s.texture,n),d.getUniforms().setValue(e,"morphTargetsTextureSize",s.size)}else{const t=void 0===h?0:h.length;let n=o[c.id];if(void 0===n||n.length!==t){n=[];for(let e=0;e<t;e++)n[e]=[e,0];o[c.id]=n}for(let e=0;e<t;e++){const t=n[e];t[0]=e,t[1]=h[e]}n.sort(absNumericalSort);for(let e=0;e<12;e++)e<t&&n[e][1]?(s[e][0]=n[e][0],s[e][1]=n[e][1]):(s[e][0]=Number.MAX_SAFE_INTEGER,s[e][1]=0);s.sort(numericalSort);const i=c.morphAttributes.position,a=c.morphAttributes.normal;let l=0;for(let e=0;e<12;e++){const t=s[e],n=t[0],o=t[1];n!==Number.MAX_SAFE_INTEGER&&o?(i&&c.getAttribute("morphTarget"+e)!==i[n]&&c.setAttribute("morphTarget"+e,i[n]),a&&c.getAttribute("morphNormal"+e)!==a[n]&&c.setAttribute("morphNormal"+e,a[n]),r[e]=o,l+=o):(i&&!0===c.hasAttribute("morphTarget"+e)&&c.deleteAttribute("morphTarget"+e),a&&!0===c.hasAttribute("morphNormal"+e)&&c.deleteAttribute("morphNormal"+e),r[e]=0)}const u=c.morphTargetsRelative?1:1-l;d.getUniforms().setValue(e,"morphTargetBaseInfluence",u),d.getUniforms().setValue(e,"morphTargetInfluences",r)}}}}class DepthTexture extends Texture{constructor(e,t,n,o,r,i,a,s,l,c){if(1026!==(c=void 0!==c?c:1026)&&1027!==c)throw new Error("DepthTexture format must be either v3d.DepthFormat or v3d.DepthStencilFormat");void 0===n&&1026===c&&(n=1014),void 0===n&&1027===c&&(n=1020),super(null,o,r,i,a,s,c,n,l),this.isDepthTexture=!0,this.image={width:e,height:t},this.magFilter=void 0!==a?a:1003,this.minFilter=void 0!==s?s:1003,this.flipY=!1,this.generateMipmaps=!1}}class Pass extends EventDispatcher{constructor(){super(),this.enabled=!0,this.needsSwap=!0,this.clear=!1,this.renderToScreen=!1}setSize(){}render(){console.error("v3d.Pass: .render() must be implemented in derived pass.")}setCamera(e){}dispose(){}}const _camera$1=new OrthographicCamera(-1,1,1,-1,0,1),_geometry$1=new BufferGeometry;_geometry$1.setAttribute("position",new BufferAttribute(new Float32Array([-1,3,0,-1,-1,0,3,-1,0]),3)),_geometry$1.setAttribute("uv",new BufferAttribute(new Float32Array([0,2,0,0,2,0]),2));class FullScreenQuad{constructor(e){this._mesh=new Mesh(_geometry$1,e)}dispose(){this._mesh.geometry.dispose()}render(e){e.render(this._mesh,_camera$1)}get material(){return this._mesh.material}set material(e){this._mesh.material=e}static dispose(){_geometry$1.dispose()}}const LAYER_TRANSPARENT=1,LAYER_TRANSPARENT_NOT_SUPPORTED=2,_clearColor$1=new Color,_tmpLayers=new Layers;class WebGLOITMethod{constructor(e,t){this.isWebGLOITMethod=!0,this.resolution=e,this.textureType=t,this.type="WebGLOITMethod",this.mute=!1}render(){this.mute}dispose(){}setSize(e,t){this.resolution.set(e,t)}_ensureProperBuffersClearing(e){e.state.buffers.depth.setTest(!0),e.state.buffers.depth.setMask(!0),e.state.buffers.color.setMask(!0)}}class WebGLOITWeighted extends WebGLOITMethod{constructor(e,t,n){super(e,t),this.isWebGLOITWeighted=!0,this.type="WebGLOITWeighted",this.shader=ShaderLib.oitWeighted,this.uniforms=UniformsUtils.clone(this.shader.uniforms),this.scene=null,this.camera=null,this.aaSamples=n||0,this.renderTargetMRT=new WebGLMultipleRenderTargets(this.resolution.x,this.resolution.y,2),this.renderTargetMRT.texture[0].name="wboit_rgba",this.renderTargetMRT.texture[0].format=1023,this.renderTargetMRT.texture[0].type=t,this.renderTargetMRT.texture[1].name="wboit_r",this.renderTargetMRT.texture[1].format=1028,this.renderTargetMRT.texture[1].type=t,this.aaSamples>0&&(this.renderTargetMRTMSAA=new WebGLMultipleRenderTargets(this.resolution.x,this.resolution.y,2,{samples:n}),this.renderTargetMRTMSAA.texture[0].name="wboit_rgba",this.renderTargetMRTMSAA.texture[0].format=1023,this.renderTargetMRTMSAA.texture[0].type=t,this.renderTargetMRTMSAA.texture[1].name="wboit_r",this.renderTargetMRTMSAA.texture[1].format=1028,this.renderTargetMRTMSAA.texture[1].type=t),this.fsQuadSolver=new FullScreenQuad(new ShaderMaterial({defines:Object.assign({},this.shader.defines),uniforms:UniformsUtils.clone(this.shader.uniforms),vertexShader:this.shader.vertexShader,fragmentShader:this.shader.fragmentShader,depthTest:!1,depthWrite:!1,blending:5,blendEquation:100,blendSrc:204,blendDst:205,blendEquationAlpha:100,blendSrcAlpha:201,blendDstAlpha:205})),this._layerMasks={},this._matSettings={},this._savedCameraLayers=new Layers}dispose(){super.dispose(),this.renderTargetMRT.dispose(),this.renderTargetMRTMSAA&&this.renderTargetMRTMSAA.dispose()}setSize(e,t){super.setSize(e,t),this.renderTargetMRT.setSize(e,t),this.renderTargetMRTMSAA&&this.renderTargetMRTMSAA.setSize(e,t)}render(e,t,n,o,r){if(this.mute)return;this._ensureProperBuffersClearing(e);const i=e.getRenderTarget();if(i.isWebGLCubeRenderTarget)return void t(n,o,r);const a=o.overrideMaterial;if(a&&!this.isSupportedMaterial(a))return void t(n,o,r);if(this.resolution.x!==i.width&&this.resolution.y!==i.height)return console.warn("v3d.WebGLOITRenderer: render target size mismatch in v3d.WebGLOITWeighted."),void t(n,o,r);this.scene=o,this.camera=r,this._savedCameraLayers.mask=this.camera.layers.mask;const s=e.getClearColor(_clearColor$1),l=e.getClearAlpha(),c=e.autoClear,u=e.useOIT,d=e.sortObjects;e.setClearColor(0),e.setClearAlpha(0),e.autoClear=!1,e.sortObjects=!1,e.useOIT=!1;const h=this.renderTargetMRTMSAA&&this.renderTargetMRTMSAA.samples==i.samples;if(a){const s=[{object:o,material:a}];this._accumulationPass(e,t,h,n,s);const l=a.colorWrite;a.colorWrite=!1,a.needsUpdate=!0,e.setRenderTarget(i),t(n,o,r),a.colorWrite=l,a.needsUpdate=!0}else this._saveLayers(n),this._setupLayers(n),r.layers.disableAll(),r.layers.enable(2),t(n,o,r),r.layers.disableAll(),r.layers.enable(1),this._accumulationPass(e,t,h,n),e.setRenderTarget(i),this._renderOnlyDepth(e,t,n,o,r),this._restoreLayers(n);e.setRenderTarget(i),this._solverPass(e,h),e.setClearColor(s),e.setClearAlpha(l),e.sortObjects=d,e.autoClear=c,e.useOIT=u}isSupportedMaterial(e){return!(!e||!e.isMeshStandardMaterial&&!e.isMeshNodeMaterial)}_accumulationPass(e,t,n,o,r){r||(r=o);const i=e.getContext(),a=e.getRenderTarget(),s=e.getClearAlpha();if(this._saveMatSettings(r),this._setupMatSettings(r),e.setClearAlpha(1),a)if(n){e.setRenderTarget(this.renderTargetMRTMSAA),e.clear();const n=e.properties.get(this.renderTargetMRTMSAA).__webglDepthRenderbuffer,r=e.properties.get(a).__webglDepthRenderbuffer;if(r&&(i.framebufferRenderbuffer(36160,36096,36161,r),36053!==i.checkFramebufferStatus(36160)))return void console.error("v3d.WebGLOITRenderer: incomplete framebuffer in v3d.WebGLOITWeighted.");t(o,this.scene,this.camera);if(e.getTextureUtils().updateMultisampleRenderTarget(this.renderTargetMRTMSAA),r&&(i.framebufferRenderbuffer(36160,36096,36161,n||null),36053!==i.checkFramebufferStatus(36160)))return void console.error("v3d.WebGLOITRenderer: incomplete framebuffer in v3d.WebGLOITWeighted.")}else if(a.samples>0){e.setRenderTarget(this.renderTargetMRT),e.clear();const n=e.properties.get(this.renderTargetMRT).__webglFramebuffer,r=e.properties.get(a).__webglMultisampledFramebuffer;if(r&&(i.bindFramebuffer(36008,r),i.bindFramebuffer(36009,n),i.blitFramebuffer(0,0,this.resolution.x,this.resolution.y,0,0,this.resolution.x,this.resolution.y,256,9728),i.bindFramebuffer(36160,n),36053!==i.checkFramebufferStatus(36160)))return void console.error("v3d.WebGLOITRenderer: incomplete framebuffer in v3d.WebGLOITWeighted. Can not blit depth buffer from multisample render target.");t(o,this.scene,this.camera)}else{e.setRenderTarget(this.renderTargetMRT),e.clear();const n=e.properties.get(this.renderTargetMRT),r=n.__webglDepthRenderbuffer||n.__webglDepthbuffer,s=e.properties.get(a),l=s.__webglDepthRenderbuffer||s.__webglDepthbuffer;if(l){if(i.framebufferRenderbuffer(36160,36096,36161,l),36053!==i.checkFramebufferStatus(36160))return void console.error("v3d.WebGLOITRenderer: incomplete framebuffer in v3d.WebGLOITWeighted.")}else if(a.depthTexture){const t=e.properties.get(a.depthTexture).__webglTexture;i.framebufferTexture2D(36160,36096,3553,t,0)}if(t(o,this.scene,this.camera),l){if(i.framebufferRenderbuffer(36160,36096,36161,r||null),36053!==i.checkFramebufferStatus(36160))return void console.error("v3d.WebGLOITRenderer: incomplete framebuffer in v3d.WebGLOITWeighted.")}else if(a.depthTexture&&(i.framebufferRenderbuffer(36160,36096,36161,r||null),36053!==i.checkFramebufferStatus(36160)))return void console.error("v3d.WebGLOITRenderer: incomplete framebuffer in v3d.WebGLOITWeighted.")}else console.error("v3d.WebGLOITRenderer: undefined render target in v3d.WebGLOITWeighted.");this._restoreMatSettings(r),e.setClearAlpha(s),e.setRenderTarget(a)}_solverPass(e,t){const n=t?this.renderTargetMRTMSAA:this.renderTargetMRT;this.fsQuadSolver.material.uniforms.tRGBABuffer.value=n.texture[0],this.fsQuadSolver.material.uniforms.tFloatBuffer.value=n.texture[1],this.fsQuadSolver.render(e)}_testInitialLayersWithInitialCameraLayers(e){const t=this._layerMasks[e.id];return _tmpLayers.mask=void 0!==t?t:e.layers.mask,this._savedCameraLayers.test(_tmpLayers)}_saveLayers(e){this._layerMasks[this.camera.id]=this.camera.layers.mask;for(let t=0,n=e.length;t<n;t++){const n=e[t].object;this._layerMasks[n.id]=n.layers.mask}}_setupLayers(e){for(let t=0,n=e.length;t<n;t++){const n=e[t],o=n.object,r=n.material;this._testInitialLayersWithInitialCameraLayers(o)?(o.layers.disableAll(),this.isSupportedMaterial(r)?o.layers.enable(1):o.layers.enable(2)):o.layers.disableAll()}}_restoreLayers(e){for(let t=0,n=e.length;t<n;t++){const n=e[t].object;n.layers.mask=this._layerMasks[n.id],delete this._layerMasks[n.id]}this.camera.layers.mask=this._layerMasks[this.camera.id],delete this._layerMasks[this.camera.id]}_saveMatSettings(e){for(let t=0,n=e.length;t<n;t++){const n=e[t],o=n.object,r=n.material;r&&r.id in this._matSettings||this._testInitialLayersWithInitialCameraLayers(o)&&this.isSupportedMaterial(r)&&(this._matSettings[r.id]={defines:{PREMULTIPLIED_ALPHA:r.defines.PREMULTIPLIED_ALPHA},properties:{blending:r.blending,blendEquation:r.blendEquation,blendSrc:r.blendSrc,blendDst:r.blendDst,blendEquationAlpha:r.blendEquationAlpha,blendSrcAlpha:r.blendSrcAlpha,blendDstAlpha:r.blendDstAlpha,depthTest:r.depthTest,depthWrite:r.depthWrite}})}}_setupMatSettings(e){for(let t=0,n=e.length;t<n;t++){const n=e[t],o=n.object,r=n.material;this._testInitialLayersWithInitialCameraLayers(o)&&(this.isSupportedMaterial(r)&&(r.defines.PREMULTIPLIED_ALPHA="",r.defines.USE_OIT_WEIGHTED="",r.blending=5,r.blendEquation=100,r.blendSrc=201,r.blendDst=201,r.blendEquationAlpha=100,r.blendSrcAlpha=200,r.blendDstAlpha=205,r.depthTest=!0,r.depthWrite=!1,r.needsUpdate=!0))}}_restoreMatSettings(e){for(let t=0,n=e.length;t<n;t++){const n=e[t],o=n.object,r=n.material;if(!r||!(r.id in this._matSettings))continue;if(!this._testInitialLayersWithInitialCameraLayers(o))continue;if(!this.isSupportedMaterial(r))continue;delete r.defines.USE_OIT_WEIGHTED;const i=this._matSettings[r.id];for(let e in i.properties)r[e]=i.properties[e];for(let e in i.defines)i.defines[e]?r.defines[e]=i.defines[e]:delete r.defines[e];r.needsUpdate=!0,delete this._matSettings[r.id]}}_renderOnlyDepth(e,t,n,o,r){const i={};for(let e=0,t=n.length;e<t;e++){const t=n[e],o=t.object,r=t.material;r&&r.id in i||this._testInitialLayersWithInitialCameraLayers(o)&&this.isSupportedMaterial(r)&&(i[r.id]={properties:{colorWrite:r.colorWrite}},r.colorWrite=!1,r.needsUpdate=!0)}t(n,o,r);for(let e=0,t=n.length;e<t;e++){const t=n[e];t.object;const o=t.material;if(!o||!(o.id in i))continue;const r=i[o.id];for(let e in r.properties)o[e]=r.properties[e];o.needsUpdate=!0,delete i[o.id]}}}class WebGLOITRenderer{constructor(e){this.isWebGLOITRenderer=!0,this.resolution=e,this.texType=1009,this.mute=!1,this.method=0,this.oitRenderer=null}render(e,t,n,o,r){this.mute||this.oitRenderer&&this.oitRenderer.render(e,t,n,o,r)}setMethod(e,t){this.method!==e&&(this.oitRenderer&&this.oitRenderer.dispose(),this.oitRenderer=null,this.method=e,0!==e&&1===e&&(this.oitRenderer=new WebGLOITWeighted(this.resolution,this.texType,t)))}isMethodCompatible(e,t){return 0===e||!(1!==e||!t.isWebGL2)}dispose(){this.oitRenderer&&this.oitRenderer.dispose(),this.method=0}setSize(e,t){this.resolution.set(e,t),this.oitRenderer&&this.oitRenderer.setSize(e,t)}}function WebGLObjects(e,t,n,o){let r=new WeakMap;function i(e){const t=e.target;t.removeEventListener("dispose",i),n.remove(t.instanceMatrix),null!==t.instanceColor&&n.remove(t.instanceColor)}return{update:function(e){const a=o.render.frame,s=e.geometry,l=t.get(e,s);return r.get(l)!==a&&(t.update(l),r.set(l,a)),e.isInstancedMesh&&(!1===e.hasEventListener("dispose",i)&&e.addEventListener("dispose",i),n.update(e.instanceMatrix,34962),null!==e.instanceColor&&n.update(e.instanceColor,34962)),l},dispose:function(){r=new WeakMap}}}const emptyTexture=new Texture,emptyArrayTexture=new DataArrayTexture,empty3dTexture=new Data3DTexture,emptyCubeTexture=new CubeTexture,arrayCacheF32=[],arrayCacheI32=[],mat4array=new Float32Array(16),mat3array=new Float32Array(9),mat2array=new Float32Array(4);function flatten(e,t,n){const o=e[0];if(o<=0||o>0)return e;const r=t*n;let i=arrayCacheF32[r];if(void 0===i&&(i=new Float32Array(r),arrayCacheF32[r]=i),0!==t){o.toArray(i,0);for(let o=1,r=0;o!==t;++o)r+=n,e[o].toArray(i,r)}return i}function arraysEqual(e,t){if(e.length!==t.length)return!1;for(let n=0,o=e.length;n<o;n++)if(e[n]!==t[n])return!1;return!0}function copyArray(e,t){for(let n=0,o=t.length;n<o;n++)e[n]=t[n]}function allocTexUnits(e,t){let n=arrayCacheI32[t];void 0===n&&(n=new Int32Array(t),arrayCacheI32[t]=n);for(let o=0;o!==t;++o)n[o]=e.allocateTextureUnit();return n}function setValueV1f(e,t){const n=this.cache;n[0]!==t&&(e.uniform1f(this.addr,t),n[0]=t)}function setValueV2f(e,t){const n=this.cache;if(void 0!==t.x)n[0]===t.x&&n[1]===t.y||(e.uniform2f(this.addr,t.x,t.y),n[0]=t.x,n[1]=t.y);else{if(arraysEqual(n,t))return;e.uniform2fv(this.addr,t),copyArray(n,t)}}function setValueV3f(e,t){const n=this.cache;if(void 0!==t.x)n[0]===t.x&&n[1]===t.y&&n[2]===t.z||(e.uniform3f(this.addr,t.x,t.y,t.z),n[0]=t.x,n[1]=t.y,n[2]=t.z);else if(void 0!==t.r)n[0]===t.r&&n[1]===t.g&&n[2]===t.b||(e.uniform3f(this.addr,t.r,t.g,t.b),n[0]=t.r,n[1]=t.g,n[2]=t.b);else{if(arraysEqual(n,t))return;e.uniform3fv(this.addr,t),copyArray(n,t)}}function setValueV4f(e,t){const n=this.cache;if(void 0!==t.x)n[0]===t.x&&n[1]===t.y&&n[2]===t.z&&n[3]===t.w||(e.uniform4f(this.addr,t.x,t.y,t.z,t.w),n[0]=t.x,n[1]=t.y,n[2]=t.z,n[3]=t.w);else{if(arraysEqual(n,t))return;e.uniform4fv(this.addr,t),copyArray(n,t)}}function setValueM2(e,t){const n=this.cache,o=t.elements;if(void 0===o){if(arraysEqual(n,t))return;e.uniformMatrix2fv(this.addr,!1,t),copyArray(n,t)}else{if(arraysEqual(n,o))return;mat2array.set(o),e.uniformMatrix2fv(this.addr,!1,mat2array),copyArray(n,o)}}function setValueM3(e,t){const n=this.cache,o=t.elements;if(void 0===o){if(arraysEqual(n,t))return;e.uniformMatrix3fv(this.addr,!1,t),copyArray(n,t)}else{if(arraysEqual(n,o))return;mat3array.set(o),e.uniformMatrix3fv(this.addr,!1,mat3array),copyArray(n,o)}}function setValueM4(e,t){const n=this.cache,o=t.elements;if(void 0===o){if(arraysEqual(n,t))return;e.uniformMatrix4fv(this.addr,!1,t),copyArray(n,t)}else{if(arraysEqual(n,o))return;mat4array.set(o),e.uniformMatrix4fv(this.addr,!1,mat4array),copyArray(n,o)}}function setValueV1i(e,t){const n=this.cache;n[0]!==t&&(e.uniform1i(this.addr,t),n[0]=t)}function setValueV2i(e,t){const n=this.cache;if(void 0!==t.x)n[0]===t.x&&n[1]===t.y||(e.uniform2i(this.addr,t.x,t.y),n[0]=t.x,n[1]=t.y);else{if(arraysEqual(n,t))return;e.uniform2iv(this.addr,t),copyArray(n,t)}}function setValueV3i(e,t){const n=this.cache;if(void 0!==t.x)n[0]===t.x&&n[1]===t.y&&n[2]===t.z||(e.uniform3i(this.addr,t.x,t.y,t.z),n[0]=t.x,n[1]=t.y,n[2]=t.z);else{if(arraysEqual(n,t))return;e.uniform3iv(this.addr,t),copyArray(n,t)}}function setValueV4i(e,t){const n=this.cache;if(void 0!==t.x)n[0]===t.x&&n[1]===t.y&&n[2]===t.z&&n[3]===t.w||(e.uniform4i(this.addr,t.x,t.y,t.z,t.w),n[0]=t.x,n[1]=t.y,n[2]=t.z,n[3]=t.w);else{if(arraysEqual(n,t))return;e.uniform4iv(this.addr,t),copyArray(n,t)}}function setValueV1ui(e,t){const n=this.cache;n[0]!==t&&(e.uniform1ui(this.addr,t),n[0]=t)}function setValueV2ui(e,t){const n=this.cache;if(void 0!==t.x)n[0]===t.x&&n[1]===t.y||(e.uniform2ui(this.addr,t.x,t.y),n[0]=t.x,n[1]=t.y);else{if(arraysEqual(n,t))return;e.uniform2uiv(this.addr,t),copyArray(n,t)}}function setValueV3ui(e,t){const n=this.cache;if(void 0!==t.x)n[0]===t.x&&n[1]===t.y&&n[2]===t.z||(e.uniform3ui(this.addr,t.x,t.y,t.z),n[0]=t.x,n[1]=t.y,n[2]=t.z);else{if(arraysEqual(n,t))return;e.uniform3uiv(this.addr,t),copyArray(n,t)}}function setValueV4ui(e,t){const n=this.cache;if(void 0!==t.x)n[0]===t.x&&n[1]===t.y&&n[2]===t.z&&n[3]===t.w||(e.uniform4ui(this.addr,t.x,t.y,t.z,t.w),n[0]=t.x,n[1]=t.y,n[2]=t.z,n[3]=t.w);else{if(arraysEqual(n,t))return;e.uniform4uiv(this.addr,t),copyArray(n,t)}}function setValueT1(e,t,n){const o=this.cache,r=n.allocateTextureUnit();o[0]!==r&&(e.uniform1i(this.addr,r),o[0]=r),n.setTexture2D(t||emptyTexture,r)}function setValueT3D1(e,t,n){const o=this.cache,r=n.allocateTextureUnit();o[0]!==r&&(e.uniform1i(this.addr,r),o[0]=r),n.setTexture3D(t||empty3dTexture,r)}function setValueT6(e,t,n){const o=this.cache,r=n.allocateTextureUnit();o[0]!==r&&(e.uniform1i(this.addr,r),o[0]=r),n.setTextureCube(t||emptyCubeTexture,r)}function setValueT2DArray1(e,t,n){const o=this.cache,r=n.allocateTextureUnit();o[0]!==r&&(e.uniform1i(this.addr,r),o[0]=r),n.setTexture2DArray(t||emptyArrayTexture,r)}function getSingularSetter(e){switch(e){case 5126:return setValueV1f;case 35664:return setValueV2f;case 35665:return setValueV3f;case 35666:return setValueV4f;case 35674:return setValueM2;case 35675:return setValueM3;case 35676:return setValueM4;case 5124:case 35670:return setValueV1i;case 35667:case 35671:return setValueV2i;case 35668:case 35672:return setValueV3i;case 35669:case 35673:return setValueV4i;case 5125:return setValueV1ui;case 36294:return setValueV2ui;case 36295:return setValueV3ui;case 36296:return setValueV4ui;case 35678:case 36198:case 36298:case 36306:case 35682:return setValueT1;case 35679:case 36299:case 36307:return setValueT3D1;case 35680:case 36300:case 36308:case 36293:return setValueT6;case 36289:case 36303:case 36311:case 36292:return setValueT2DArray1}}function setValueV1fArray(e,t){e.uniform1fv(this.addr,t)}function setValueV2fArray(e,t){const n=flatten(t,this.size,2);e.uniform2fv(this.addr,n)}function setValueV3fArray(e,t){const n=flatten(t,this.size,3);e.uniform3fv(this.addr,n)}function setValueV4fArray(e,t){const n=flatten(t,this.size,4);e.uniform4fv(this.addr,n)}function setValueM2Array(e,t){const n=flatten(t,this.size,4);e.uniformMatrix2fv(this.addr,!1,n)}function setValueM3Array(e,t){const n=flatten(t,this.size,9);e.uniformMatrix3fv(this.addr,!1,n)}function setValueM4Array(e,t){const n=flatten(t,this.size,16);e.uniformMatrix4fv(this.addr,!1,n)}function setValueV1iArray(e,t){e.uniform1iv(this.addr,t)}function setValueV2iArray(e,t){e.uniform2iv(this.addr,t)}function setValueV3iArray(e,t){e.uniform3iv(this.addr,t)}function setValueV4iArray(e,t){e.uniform4iv(this.addr,t)}function setValueV1uiArray(e,t){e.uniform1uiv(this.addr,t)}function setValueV2uiArray(e,t){e.uniform2uiv(this.addr,t)}function setValueV3uiArray(e,t){e.uniform3uiv(this.addr,t)}function setValueV4uiArray(e,t){e.uniform4uiv(this.addr,t)}function setValueT1Array(e,t,n){const o=this.cache,r=t.length,i=allocTexUnits(n,r);arraysEqual(o,i)||(e.uniform1iv(this.addr,i),copyArray(o,i));for(let e=0;e!==r;++e)n.setTexture2D(t[e]||emptyTexture,i[e])}function setValueT3DArray(e,t,n){const o=this.cache,r=t.length,i=allocTexUnits(n,r);arraysEqual(o,i)||(e.uniform1iv(this.addr,i),copyArray(o,i));for(let e=0;e!==r;++e)n.setTexture3D(t[e]||empty3dTexture,i[e])}function setValueT6Array(e,t,n){const o=this.cache,r=t.length,i=allocTexUnits(n,r);arraysEqual(o,i)||(e.uniform1iv(this.addr,i),copyArray(o,i));for(let e=0;e!==r;++e)n.setTextureCube(t[e]||emptyCubeTexture,i[e])}function setValueT2DArrayArray(e,t,n){const o=this.cache,r=t.length,i=allocTexUnits(n,r);arraysEqual(o,i)||(e.uniform1iv(this.addr,i),copyArray(o,i));for(let e=0;e!==r;++e)n.setTexture2DArray(t[e]||emptyArrayTexture,i[e])}function getPureArraySetter(e){switch(e){case 5126:return setValueV1fArray;case 35664:return setValueV2fArray;case 35665:return setValueV3fArray;case 35666:return setValueV4fArray;case 35674:return setValueM2Array;case 35675:return setValueM3Array;case 35676:return setValueM4Array;case 5124:case 35670:return setValueV1iArray;case 35667:case 35671:return setValueV2iArray;case 35668:case 35672:return setValueV3iArray;case 35669:case 35673:return setValueV4iArray;case 5125:return setValueV1uiArray;case 36294:return setValueV2uiArray;case 36295:return setValueV3uiArray;case 36296:return setValueV4uiArray;case 35678:case 36198:case 36298:case 36306:case 35682:return setValueT1Array;case 35679:case 36299:case 36307:return setValueT3DArray;case 35680:case 36300:case 36308:case 36293:return setValueT6Array;case 36289:case 36303:case 36311:case 36292:return setValueT2DArrayArray}}class SingleUniform{constructor(e,t,n){this.id=e,this.addr=n,this.cache=[],this.setValue=getSingularSetter(t.type)}}class PureArrayUniform{constructor(e,t,n){this.id=e,this.addr=n,this.cache=[],this.size=t.size,this.setValue=getPureArraySetter(t.type)}}class StructuredUniform{constructor(e){this.id=e,this.seq=[],this.map={}}setValue(e,t,n){const o=this.seq;for(let r=0,i=o.length;r!==i;++r){const i=o[r];i.setValue(e,t[i.id],n)}}}const RePathPart=/(\w+)(\])?(\[|\.)?/g;function addUniform(e,t){e.seq.push(t),e.map[t.id]=t}function parseUniform(e,t,n){const o=e.name,r=o.length;for(RePathPart.lastIndex=0;;){const i=RePathPart.exec(o),a=RePathPart.lastIndex;let s=i[1];const l="]"===i[2],c=i[3];if(l&&(s|=0),void 0===c||"["===c&&a+2===r){addUniform(n,void 0===c?new SingleUniform(s,e,t):new PureArrayUniform(s,e,t));break}{let e=n.map[s];void 0===e&&(e=new StructuredUniform(s),addUniform(n,e)),n=e}}}class WebGLUniforms{constructor(e,t){this.seq=[],this.map={};const n=e.getProgramParameter(t,35718);for(let o=0;o<n;++o){const n=e.getActiveUniform(t,o);parseUniform(n,e.getUniformLocation(t,n.name),this)}}setValue(e,t,n,o){const r=this.map[t];void 0!==r&&r.setValue(e,n,o)}setOptional(e,t,n){const o=t[n];void 0!==o&&this.setValue(e,n,o)}static upload(e,t,n,o){for(let r=0,i=t.length;r!==i;++r){const i=t[r],a=n[i.id];!1!==a.needsUpdate&&i.setValue(e,a.value,o)}}static seqWithValue(e,t){const n=[];for(let o=0,r=e.length;o!==r;++o){const r=e[o];r.id in t&&n.push(r)}return n}}function WebGLShader(e,t,n){const o=e.createShader(t);return e.shaderSource(o,n),e.compileShader(o),o}let programIdCount=0;function handleSource(e,t){const n=e.split("\n"),o=[],r=Math.max(t-6,0),i=Math.min(t+6,n.length);for(let e=r;e<i;e++){const r=e+1;o.push(`${r===t?">":" "} ${r}: ${n[e]}`)}return o.join("\n")}function getEncodingComponents(e){switch(e){case 3e3:return["Linear","(value)"];case 3001:return["sRGB","(value)"];default:return console.warn("v3d.WebGLProgram: Unsupported encoding:",e),["Linear","(value)"]}}function getShaderErrors(e,t,n){const o=e.getShaderParameter(t,35713),r=e.getShaderInfoLog(t).trim();if(o&&""===r)return"";const i=/ERROR: 0:(\d+)/.exec(r);if(i){const o=parseInt(i[1]);return n.toUpperCase()+"\n\n"+r+"\n\n"+handleSource(e.getShaderSource(t),o)}return r}function getTexelEncodingFunction(e,t){const n=getEncodingComponents(t);return"vec4 "+e+"(vec4 value) { return LinearTo"+n[0]+n[1]+"; }"}function getToneMappingFunction(e,t){let n;switch(t){case 1:n="Linear";break;case 2:n="Reinhard";break;case 3:n="OptimizedCineon";break;case 4:n="ACESFilmic";break;case 5:n="Custom";break;case 6:n="LogarithmicMax";break;case 7:n="PhysicalMax";break;case 8:n="FilmicBlender";break;case 9:n="AgX";break;case 10:n="PbrNeutral";break;default:console.warn("v3d.WebGLProgram: Unsupported toneMapping:",t),n="Linear"}return"vec3 "+e+"(vec3 color) { return "+n+"ToneMapping(color); }"}function genToneMappingLookDefine(e){let t="TONE_MAPPING_LOOK_NONE";return 1===e&&(t="TONE_MAPPING_LOOK_AGX_PUNCHY"),t}function generateWebGL1Extensions(e){return[e.extensionDerivatives||e.bumpMap||e.tangentSpaceNormalMap||e.flatShading||"node"===e.shaderID||e.useSlopeScaledBias?"#extension GL_OES_standard_derivatives : enable":"",(e.extensionFragDepth||e.logarithmicDepthBuffer)&&e.rendererExtensionFragDepth?"#extension GL_EXT_frag_depth : enable":""].filter(filterEmptyLine).join("\n")}function generateDefines(e,t){const n=[];for(const o in e){const r=e[o];!1===r||t&&t.has(o)||n.push("#define "+o+" "+r)}return n.join("\n")}function fetchAttributeLocations(e,t){const n={},o=e.getProgramParameter(t,35721);for(let r=0;r<o;r++){const o=e.getActiveAttrib(t,r),i=o.name;let a=1;35674===o.type&&(a=2),35675===o.type&&(a=3),35676===o.type&&(a=4),n[i]={type:o.type,location:e.getAttribLocation(t,i),locationSize:a}}return n}function filterEmptyLine(e){return""!==e}function replaceLightNums(e,t){return e.replace(/NUM_DIR_LIGHTS/g,t.numDirLights).replace(/NUM_SPOT_LIGHTS/g,t.numSpotLights).replace(/NUM_RECT_AREA_LIGHTS/g,t.numRectAreaLights).replace(/NUM_POINT_LIGHTS/g,t.numPointLights).replace(/NUM_SPOT_LIGHT_SHADOWS/g,t.numSpotLightShadows).replace(/NUM_POINT_LIGHT_SHADOWS/g,t.numPointLightShadows).replace(/NUM_RECT_AREA_LIGHT_SHADOWS/g,t.numRectAreaLightShadows).replace(/NUM_DIR_LIGHT_SHADOWS_CSM_WITH_FADE/g,t.numDirLightShadowsCSMWithFade).replace(/NUM_DIR_LIGHT_SHADOWS_CSM/g,t.numDirLightShadowsCSM).replace(/NUM_DIR_LIGHT_SHADOW_CASCADES_CSM/g,t.numDirLightShadowCSMCascades)}function replaceClippingPlaneNums(e,t){return e.replace(/NUM_CLIPPING_PLANES/g,t.numClippingPlanes).replace(/UNION_CLIPPING_PLANES/g,t.numClippingPlanes-t.numClipIntersection)}function replaceCustomTokens(e,t){const n=Object.keys(t);if(n.length){const o=new RegExp(n.join("|"),"g");return e.replace(o,function(e){return t[e]})}return e}function getMaterialProfile(e){switch(e){case"blender":return"#define MT_BLENDER";case"max":return"#define MT_MAX";case"maya":return"#define MT_MAYA";default:return""}}function replaceNodeChunks(e,t){for(const n in t){const o=checkDevTools()?`// included: "${n}"\n`:"";e=e.replace(`#include <${n}>`,o+t[n])}return e}const includePattern=/^[ \t]*#include +<([\w\d./]+)>/gm;function resolveIncludes(e){return e.replace(includePattern,includeReplacer)}function includeReplacer(e,t){const n=ShaderChunk[t];if(void 0===n)throw new Error("Can not resolve #include <"+t+">");return resolveIncludes((checkDevTools()?`// included: "${t}"\n`:"")+n)}function unrollLoops(e){const t=new RegExp("#pragma unroll_loop[\\s]+?for \\(int (\\w+) ?\\= ?(\\d+)\\; ?(\\w+) ?<(=?) ?(\\w+)\\; ?(\\w+)\\+\\+\\) ?\\{"),n=new RegExp("\\{|\\}","g");let o;for(;o=t.exec(e);){let t,r;t=r=n.lastIndex=o.index+o[0].length;let i,a=1;do{(i=n.exec(e))&&("{"==i[0]?a++:"}"==i[0]&&a--,r=i.index)}while(i&&a>0);if(0==a){const i=e.substring(o.index,n.lastIndex),a=e.substring(t,r),s=new RegExp(`\\[${o[1]}\\]`,"g"),l=new RegExp(`\\(${o[1]}\\)`,"g");let c="";const u=parseInt(o[2]),d=parseInt(o[5])+("="===o[4]?1:0);for(let e=u;e<d;e++)c+="{"+a.replace(s,`[${e}]`).replace(l,`(${e})`)+"}";e=e.replace(i,c)}}return e}function generatePrecision(e){return"precision "+e.precision+" float;\nprecision "+e.precision+" int;"}function generateShadowMapTypeDefine(e){let t="SHADOWMAP_TYPE_BASIC";return 1===e.shadowMapType?t="SHADOWMAP_TYPE_BILINEAR":2===e.shadowMapType?t="SHADOWMAP_TYPE_PCF":3===e.shadowMapType&&(t="SHADOWMAP_TYPE_ESM"),t}function generateEnvMapTypeDefine(e){let t="ENVMAP_TYPE_CUBE";if(e.envMap)switch(e.envMapMode){case 301:case 302:t="ENVMAP_TYPE_CUBE";break;case 306:t="ENVMAP_TYPE_CUBE_UV"}return t}function generateEnvMapModeDefine(e){let t="ENVMAP_MODE_REFLECTION";if(e.envMap&&302===e.envMapMode)t="ENVMAP_MODE_REFRACTION";return t}function generateEnvMapBlendingDefine(e){let t="ENVMAP_BLENDING_NONE";if(e.envMap)switch(e.combine){case 0:t="ENVMAP_BLENDING_MULTIPLY";break;case 1:t="ENVMAP_BLENDING_MIX";break;case 2:t="ENVMAP_BLENDING_ADD"}return t}function WebGLProgram(e,t,n,o){const r=e.getContext(),i=n.defines;let a=n.vertexShader,s=n.fragmentShader;const l=generateShadowMapTypeDefine(n),c=generateEnvMapTypeDefine(n),u=generateEnvMapModeDefine(n),d=generateEnvMapBlendingDefine(n),h=n.unitsScaleFactor%1?String(n.unitsScaleFactor):String(n.unitsScaleFactor)+".0",p=n.isWebGL2?"":generateWebGL1Extensions(n),f=generateDefines(i),m=generateDefines(i,n.definesFragOnly),g=r.createProgram(),_=this;let A,v,x=n.glslVersion?"#version "+n.glslVersion+"\n":"";n.isRawShaderMaterial?(A=[m].filter(filterEmptyLine).join("\n"),A.length>0&&(A+="\n"),v=[p,f].filter(filterEmptyLine).join("\n"),v.length>0&&(v+="\n")):(A=[generatePrecision(n),"#define SHADER_NAME "+n.shaderName,m,n.instancing?"#define USE_INSTANCING":"",n.instancingColor?"#define USE_INSTANCING_COLOR":"",n.supportsVertexTextures?"#define VERTEX_TEXTURES":"",n.useFog&&n.fog?"#define USE_FOG":"",n.useFog&&n.fogExp2?"#define FOG_EXP2":"",n.map?"#define USE_MAP":"",n.envMap?"#define USE_ENVMAP":"",n.envMap?"#define "+u:"",n.lightMap?"#define USE_LIGHTMAP":"",n.aoMap?"#define USE_AOMAP":"",n.emissiveMap?"#define USE_EMISSIVEMAP":"",n.bumpMap?"#define USE_BUMPMAP":"",n.normalMap?"#define USE_NORMALMAP":"",n.normalMap&&n.objectSpaceNormalMap?"#define OBJECTSPACE_NORMALMAP":"",n.normalMap&&n.tangentSpaceNormalMap?"#define TANGENTSPACE_NORMALMAP":"",n.displacementMap&&n.supportsVertexTextures?"#define USE_DISPLACEMENTMAP":"",n.roughnessMap?"#define USE_ROUGHNESSMAP":"",n.metalnessMap?"#define USE_METALNESSMAP":"",n.alphaMap?"#define USE_ALPHAMAP":"",n.vertexTangents?"#define USE_TANGENT":"",n.vertexColors?"#define USE_COLOR":"",n.vertexAlphas?"#define USE_COLOR_ALPHA":"",n.vertexUvs?"#define USE_UV":"",n.uvsVertexOnly?"#define UVS_VERTEX_ONLY":"",n.flatShading?"#define FLAT_SHADED":"",n.skinning?"#define USE_SKINNING":"",n.morphTargets?"#define USE_MORPHTARGETS":"",n.morphNormals&&!1===n.flatShading?"#define USE_MORPHNORMALS":"",n.morphTargetsCount>0&&n.isWebGL2?"#define MORPHTARGETS_TEXTURE":"",n.morphTargetsCount>0&&n.isWebGL2?"#define MORPHTARGETS_TEXTURE_STRIDE "+n.morphTextureStride:"",n.morphTargetsCount>0?"#define MORPHTARGETS_COUNT "+n.morphTargetsCount:"",n.doubleSided?"#define DOUBLE_SIDED":"",n.flipSided?"#define FLIP_SIDED":"",n.shadowMapEnabled?"#define USE_SHADOWMAP":"",n.shadowMapEnabled?"#define "+l:"",n.sizeAttenuation?"#define USE_SIZEATTENUATION":"",n.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",n.logarithmicDepthBuffer&&n.rendererExtensionFragDepth?"#define USE_LOGDEPTHBUF_EXT":"",n.planeReflProbe?"#define USE_PLANE_REFLECTION":"","\n            uniform mat4 modelMatrix;\n            uniform mat4 modelViewMatrix;\n            uniform mat4 projectionMatrix;\n            uniform mat4 viewMatrix;\n            uniform mat3 normalMatrix;\n            uniform vec3 cameraPosition;\n            uniform bool isOrthographic;\n\n            #ifdef USE_INSTANCING\n                attribute mat4 instanceMatrix;\n            #endif\n\n            #ifdef USE_INSTANCING_COLOR\n                attribute vec3 instanceColor;\n            #endif\n\n            attribute vec3 position;\n            attribute vec3 normal;\n            attribute vec2 uv;\n\n            #ifdef USE_TANGENT\n                attribute vec4 tangent;\n            #endif\n\n            #if defined(USE_COLOR_ALPHA)\n                attribute vec4 color;\n            #elif defined(USE_COLOR)\n                attribute vec3 color;\n            #endif\n\n            #if (defined(USE_MORPHTARGETS) && !defined(MORPHTARGETS_TEXTURE))\n                #if MORPHTARGETS_COUNT > 0\n                    attribute vec3 morphTarget0;\n                #endif\n                #if MORPHTARGETS_COUNT > 1\n                    attribute vec3 morphTarget1;\n                #endif\n                #if MORPHTARGETS_COUNT > 2\n                    attribute vec3 morphTarget2;\n                #endif\n                #if MORPHTARGETS_COUNT > 3\n                    attribute vec3 morphTarget3;\n                #endif\n                #if MORPHTARGETS_COUNT > 4\n                    attribute vec3 morphTarget4;\n                #endif\n                #if MORPHTARGETS_COUNT > 5\n                    attribute vec3 morphTarget5;\n                #endif\n\n                #ifdef USE_MORPHNORMALS\n                    #if MORPHTARGETS_COUNT > 0\n                        attribute vec3 morphNormal0;\n                    #endif\n                    #if MORPHTARGETS_COUNT > 1\n                        attribute vec3 morphNormal1;\n                    #endif\n                    #if MORPHTARGETS_COUNT > 2\n                        attribute vec3 morphNormal2;\n                    #endif\n                    #if MORPHTARGETS_COUNT > 3\n                        attribute vec3 morphNormal3;\n                    #endif\n                    #if MORPHTARGETS_COUNT > 4\n                        attribute vec3 morphNormal4;\n                    #endif\n                    #if MORPHTARGETS_COUNT > 5\n                        attribute vec3 morphNormal5;\n                    #endif\n                #else\n                    #if MORPHTARGETS_COUNT > 6\n                        attribute vec3 morphTarget6;\n                    #endif\n                    #if MORPHTARGETS_COUNT > 7\n                        attribute vec3 morphTarget7;\n                    #endif\n                    #if MORPHTARGETS_COUNT > 8\n                        attribute vec3 morphTarget8;\n                    #endif\n                    #if MORPHTARGETS_COUNT > 9\n                        attribute vec3 morphTarget9;\n                    #endif\n                    #if MORPHTARGETS_COUNT > 10\n                        attribute vec3 morphTarget10;\n                    #endif\n                    #if MORPHTARGETS_COUNT > 11\n                        attribute vec3 morphTarget11;\n                    #endif\n                #endif\n            #endif\n\n            #ifdef USE_SKINNING\n                attribute vec4 skinIndex;\n                attribute vec4 skinWeight;\n            #endif\n            "].filter(filterEmptyLine).join("\n"),v=[p,generatePrecision(n),"#define SHADER_NAME "+n.shaderName,f,getMaterialProfile(n.materialProfile),n.useFog&&n.fog?"#define USE_FOG":"",n.useFog&&n.fogExp2?"#define FOG_EXP2":"",n.map?"#define USE_MAP":"",n.envMap?"#define USE_ENVMAP":"",n.envMap?"#define "+c:"",n.envMap?"#define "+u:"",n.envMap?"#define "+d:"",0!==n.envMapCubeUVTileSize?`#define cubeUV_maxTileSize ${shaderFloatStr(n.envMapCubeUVTileSize)}`:"",n.lightMap?"#define USE_LIGHTMAP":"",n.aoMap?"#define USE_AOMAP":"",n.emissiveMap?"#define USE_EMISSIVEMAP":"",n.bumpMap?"#define USE_BUMPMAP":"",n.normalMap?"#define USE_NORMALMAP":"",n.normalMap&&n.objectSpaceNormalMap?"#define OBJECTSPACE_NORMALMAP":"",n.normalMap&&n.tangentSpaceNormalMap?"#define TANGENTSPACE_NORMALMAP":"",n.roughnessMap?"#define USE_ROUGHNESSMAP":"",n.metalnessMap?"#define USE_METALNESSMAP":"",n.alphaMap?"#define USE_ALPHAMAP":"",n.alphaTest?"#define USE_ALPHATEST":"",n.decodeVideoTexture?"#define DECODE_VIDEO_TEXTURE":"",n.vertexTangents?"#define USE_TANGENT":"",n.vertexColors||n.instancingColor?"#define USE_COLOR":"",n.vertexAlphas?"#define USE_COLOR_ALPHA":"",n.vertexUvs?"#define USE_UV":"",n.uvsVertexOnly?"#define UVS_VERTEX_ONLY":"",n.flatShading?"#define FLAT_SHADED":"",n.doubleSided?"#define DOUBLE_SIDED":"",n.flipSided?"#define FLIP_SIDED":"",n.shadowMapEnabled?"#define USE_SHADOWMAP":"",n.shadowMapEnabled?"#define "+l:"",n.premultipliedAlpha?"#define PREMULTIPLIED_ALPHA":"",n.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",n.logarithmicDepthBuffer&&n.rendererExtensionFragDepth?"#define USE_LOGDEPTHBUF_EXT":"","#define UNITS_SCALE_FACTOR "+h,"uniform mat4 viewMatrix;","uniform vec3 cameraPosition;","uniform bool isOrthographic;",0!==n.toneMapping?"#define TONE_MAPPING":"",0!==n.toneMapping?"#define TONE_MAPPING_LOOK "+genToneMappingLookDefine(n.toneMappingLook):"",0!==n.toneMapping?ShaderChunk.tonemapping_pars_fragment:"",0!==n.toneMapping?getToneMappingFunction("toneMapping",n.toneMapping):"",n.dithering?"#define DITHERING":"",n.opaque&&!n.alphaToCoverage?"#define OPAQUE":"",ShaderChunk.encodings_pars_fragment,getTexelEncodingFunction("linearToOutputTexel",n.outputEncoding),n.useDepthPacking?"#define DEPTH_PACKING "+n.depthPacking:"",n.distancePacking?"#define DISTANCE_PACKING "+n.distancePacking:"",n.useSlopeScaledBias?"#define USE_SLOPE_SCALED_BIAS":"",`#define ESM_DISTANCE_SCALE ${shaderFloatStr(n.esmDistanceScale)}`,n.planeReflProbe?"#define USE_PLANE_REFLECTION":"",n.useGTAO?"#define USE_GTAO":"",e.compatSettings.gtaoDisableBkgFix?"#define GTAO_DISABLE_BKG_FIX":"",n.dirLightShadowsCSMLUT.length>0&&n.isWebGL2?`#define LUT_DIR_LIGHT_SHADOWS_CSM int[](${n.dirLightShadowsCSMLUT})`:"","\n"].filter(filterEmptyLine).join("\n")),n.isWebGL2||!0===n.isRawShaderMaterial||(a="#include <webgl1_compat>\n"+a,s="#include <webgl1_compat>\n"+s),n.isMeshNodeMaterial&&(a=replaceNodeChunks(a,n.nodeChunks),s=replaceNodeChunks(s,n.nodeChunks)),a=resolveIncludes(a),a=replaceLightNums(a,n),a=replaceClippingPlaneNums(a,n),n.customPrepTokens&&(a=replaceCustomTokens(a,n.customPrepTokens)),s=resolveIncludes(s),s=replaceLightNums(s,n),s=replaceClippingPlaneNums(s,n),n.customPrepTokens&&(s=replaceCustomTokens(s,n.customPrepTokens)),a=unrollLoops(a),s=unrollLoops(s),n.isWebGL2&&!0!==n.isRawShaderMaterial&&(x="#version 300 es\n",A=["precision mediump sampler2DArray;","#define attribute in","#define varying out","#define texture2D texture"].join("\n")+"\n"+A,v=["#define varying in",n.glslVersion===GLSL3?"":"layout(location = 0) out highp vec4 outFragColor;",n.glslVersion===GLSL3?"":"#define gl_FragColor outFragColor","#define gl_FragDepthEXT gl_FragDepth","#define texture2D texture","#define textureCube texture","#define texture2DProj textureProj"].join("\n")+"\n"+v);let y=x+A+a,b=x+v+s;if(e.debug.disableCompiledShaderCache||checkDevTools()){const t=b.lastIndexOf("}");b=b.substr(0,t)+"    // disable shader cache\n    gl_FragColor += vec4("+1e-4*e.debug.random+");\n"+b.substr(t)}const C=WebGLShader(r,35633,y),S=WebGLShader(r,35632,b);sendDevTools("observe",{shaderName:n.shaderName,materialName:n.materialName,vertex:y,fragment:b}),r.attachShader(g,C),r.attachShader(g,S),void 0!==n.index0AttributeName?r.bindAttribLocation(g,0,n.index0AttributeName):!0===n.morphTargets&&r.bindAttribLocation(g,0,"position"),r.linkProgram(g);let E,M,T=!0;function w(){if(T=!1,e.debug.checkShaderErrors){const e=r.getProgramInfoLog(g).trim(),t=r.getShaderInfoLog(C).trim(),n=r.getShaderInfoLog(S).trim();let o=!0,i=!0;if(!1===r.getProgramParameter(g,35714)){o=!1;const t=getShaderErrors(r,C,"vertex"),n=getShaderErrors(r,S,"fragment");console.error("v3d.WebGLProgram: shader error: ",r.getError(),"35715",r.getProgramParameter(g,35715),"gl.getProgramInfoLog",e,t,n)}else""!==e?console.warn("v3d.WebGLProgram: gl.getProgramInfoLog()",e):""!==t&&""!==n||(i=!1);i&&(_.diagnostics={runnable:o,programLog:e,vertexShader:{log:t,prefix:A},fragmentShader:{log:n,prefix:v}})}r.deleteShader(C),r.deleteShader(S)}return this.getUniforms=function(){return void 0===E&&(T&&w(),E=new WebGLUniforms(r,g)),E},this.getAttributes=function(){return void 0===M&&(T&&w(),M=fetchAttributeLocations(r,g)),M},this.destroy=function(){o.releaseStatesOfProgram(this),r.deleteProgram(g),this.program=void 0},this.name=n.shaderName,this.id=programIdCount++,this.cacheKey=t,this.usedTimes=1,this.program=g,this.vertexShader=C,this.fragmentShader=S,this.profile={calcRenderTime:!1,renderTime:0,timerQueries:[],materials:new Set},this.getTexUniformCount=function(){return this.getUniforms().seq.reduce(function(e,t){if(t.info)switch(t.info.type){case 35678:case 35679:case 35680:case 35682:case 36289:case 36292:case 36293:case 36298:case 36299:case 36300:case 36303:case 36306:case 36307:case 36308:case 36311:e+=t.info.size}return e},0)},this.beginTimerQuery=function(e,t){if(!this.profile.calcRenderTime)return;const n=e.getExtension(t?"EXT_disjoint_timer_query_webgl2":"EXT_disjoint_timer_query");if(!n)return;let o;t?(o=e.createQuery(),e.beginQuery(n.TIME_ELAPSED_EXT,o)):(o=n.createQueryEXT(),n.beginQueryEXT(n.TIME_ELAPSED_EXT,o)),this.profile.timerQueries.push(o)},this.endTimerQuery=function(e,t){if(!this.profile.calcRenderTime)return;const n=e.getExtension(t?"EXT_disjoint_timer_query_webgl2":"EXT_disjoint_timer_query");if(!n)return;t?e.endQuery(n.TIME_ELAPSED_EXT):n.endQueryEXT(n.TIME_ELAPSED_EXT);const o=this.profile.timerQueries;for(let r=o.length-1;r>=0;r--){const i=o[r],a=t?e.getQueryParameter(i,34919):n.getQueryObjectEXT(i,n.QUERY_RESULT_AVAILABLE_EXT),s=e.getParameter(n.GPU_DISJOINT_EXT);if(a&&!s){const a=t?e.getQueryParameter(i,34918):n.getQueryObjectEXT(i,n.QUERY_RESULT_EXT);this.profile.renderTime+=a/1e6,o.splice(r,1)}}},this}function WebGLPrograms(e,t,n,o,r,i,a){const s=new Layers,l=[],c=r.isWebGL2,u=r.logarithmicDepthBuffer,d=r.vertexTextures;let h=r.precision,p=0;const f={MeshDepthMaterial:"depth",MeshDistanceMaterial:"distanceRGBA",MeshNormalMaterial:"normal",MeshBasicMaterial:"basic",MeshLambertMaterial:"lambert",MeshStandardMaterial:"standard",LineBasicMaterial:"basic",LineDashedMaterial:"dashed",PointsMaterial:"points",ShadowMaterial:"shadow",SpriteMaterial:"sprite",MeshMaskMaterial:"mask",MeshNodeMaterial:"node"};return{getParameters:function(i,s,l,p,m,g){const _=p.fog,A=m.geometry,v=i.isMeshNodeMaterial||i.isMeshStandardMaterial?p.environment:null,x=(i.isMeshNodeMaterial||i.isMeshStandardMaterial?n:t).get(i.envMap||v),y=f[i.type];null!==i.precision&&(h=r.getMaxPrecision(i.precision),h!==i.precision&&console.warn("v3d.WebGLProgram.getParameters:",i.precision,"not supported, using",h,"instead."));const b=A.morphAttributes.position||A.morphAttributes.normal,C=void 0!==b?b.length:0;let S,E,M=0;if(void 0!==A.morphAttributes.position&&(M=1),void 0!==A.morphAttributes.normal&&(M=2),y){const e=ShaderLib[y];S=e.vertexShader,E=e.fragmentShader}else S=i.vertexShader,E=i.fragmentShader;const T=e.getRenderTarget(),w=i.alphaTest>0;return{isWebGL2:c,shaderID:y,shaderName:i.type,vertexShader:S,fragmentShader:E,defines:i.defines,isRawShaderMaterial:!0===i.isRawShaderMaterial,glslVersion:i.glslVersion,precision:h,instancing:!0===m.isInstancedMesh,instancingColor:!0===m.isInstancedMesh&&null!==m.instanceColor,supportsVertexTextures:d,outputEncoding:null===T?e.outputEncoding:!0===T.isXRRenderTarget?T.texture.encoding:3e3,map:!!i.map,envMap:!!x,envMapMode:x&&x.mapping,lightMap:!!i.lightMap,aoMap:!!i.aoMap,emissiveMap:!!i.emissiveMap,bumpMap:!!i.bumpMap,normalMap:!!i.normalMap,objectSpaceNormalMap:1===i.normalMapType,tangentSpaceNormalMap:0===i.normalMapType,decodeVideoTexture:!!i.map&&!0===i.map.isVideoTexture&&3001===i.map.encoding,displacementMap:!!i.displacementMap,roughnessMap:!!i.roughnessMap,metalnessMap:!!i.metalnessMap,opaque:!1===i.transparent&&1===i.blending,alphaMap:!!i.alphaMap,alphaTest:w,combine:i.combine,vertexTangents:!!i.normalMap&&!!A.attributes.tangent,vertexColors:i.vertexColors,vertexAlphas:!0===i.vertexColors&&!!A.attributes.color&&4===A.attributes.color.itemSize,vertexUvs:!!(i.map||i.bumpMap||i.normalMap||i.alphaMap||i.emissiveMap||i.roughnessMap||i.metalnessMap||i.displacementMap),uvsVertexOnly:!(i.map||i.bumpMap||i.normalMap||i.alphaMap||i.emissiveMap||i.roughnessMap||i.metalnessMap||!i.displacementMap),fog:!!_,useFog:!0===i.fog,fogExp2:_&&_.isFogExp2,flatShading:!!i.flatShading,sizeAttenuation:i.sizeAttenuation,logarithmicDepthBuffer:u,skinning:!0===m.isSkinnedMesh,morphTargets:void 0!==A.morphAttributes.position,morphNormals:void 0!==A.morphAttributes.normal,morphTargetsCount:C,morphTextureStride:M,numDirLights:s?s.directional.length:0,numPointLights:s?s.point.length:0,numSpotLights:s?s.spot.length:0,numRectAreaLights:s?s.rectArea.length:0,numPointLightShadows:s?s.pointShadowMap.length:0,numSpotLightShadows:s?s.spotShadowMap.length:0,numClippingPlanes:a.numPlanes,numClipIntersection:a.numIntersection,dithering:i.dithering,shadowMapEnabled:e.shadowMap.enabled&&l.length>0,shadowMapType:e.shadowMap.type,toneMapping:i.toneMapped?e.toneMapping:0,toneMappingLook:i.toneMapped?e.toneMappingLook:0,premultipliedAlpha:i.premultipliedAlpha,doubleSided:2===i.side,flipSided:1===i.side,useDepthPacking:!!i.depthPacking,depthPacking:i.depthPacking||0,envMapCubeUVTileSize:x&&306===x.mapping&&void 0!==x.image?x.image.width/3:0,distancePacking:void 0!==i.distancePacking&&i.distancePacking,useSlopeScaledBias:void 0!==i.useSlopeScaledBias&&i.useSlopeScaledBias,esmDistanceScale:e.shadowMap.esmDistanceScale,numRectAreaLightShadows:s?s.rectAreaShadowMap.length:0,numDirLightShadowsCSM:s?s.directionalShadowCSM.length:0,numDirLightShadowCSMCascades:s?s.directionalShadowCSMCascade.length:0,numDirLightShadowsCSMWithFade:s?s.numDirectionalShadowsCSMWithFade:0,dirLightShadowsCSMLUT:s?s.directionalShadowCSMLUT:[],planeReflProbe:!!g,materialName:i.name,materialProfile:i.profile,unitsScaleFactor:e.unitsScaleFactor,alphaToCoverage:!!i.alphaToCoverage,customPrepTokens:i.customPrepTokens,definesFragOnly:i.definesFragOnly,isMeshNodeMaterial:i.isMeshNodeMaterial,nodeChunks:i.nodeChunks,nodeChunksHash:i.nodeChunksHash,useGTAO:e.canUseGTAO()&&i.isMeshNodeMaterial&&i.canUseGTAO(),index0AttributeName:i.index0AttributeName,extensionDerivatives:i.extensions&&i.extensions.derivatives,extensionFragDepth:i.extensions&&i.extensions.fragDepth,rendererExtensionFragDepth:c||o.has("EXT_frag_depth"),customProgramCacheKey:i.customProgramCacheKey()}},getProgramCacheKey:function(t){const n=[];t.shaderID?n.push(t.shaderID):(n.push(hashString(t.vertexShader)),n.push(hashString(t.fragmentShader)));for(const e in t.defines)n.push(e),n.push(t.defines[e]);if(void 0!==t.customPrepTokens)for(const e in t.customPrepTokens)n.push(e),n.push(t.customPrepTokens[e]);return!1===t.isRawShaderMaterial&&(!function(e,t){e.push(t.precision),e.push(t.outputEncoding),e.push(t.envMapMode),e.push(t.combine),e.push(t.vertexUvs),e.push(t.fogExp2),e.push(t.sizeAttenuation),e.push(t.morphTargetsCount),e.push(t.morphAttributeCount),e.push(t.numDirLights),e.push(t.numPointLights),e.push(t.numSpotLights),e.push(t.numRectAreaLights),e.push(t.numPointLightShadows),e.push(t.numSpotLightShadows),e.push(t.shadowMapType),e.push(t.toneMapping),e.push(t.toneMappingLook),e.push(t.numClippingPlanes),e.push(t.numClipIntersection),e.push(t.depthPacking),e.push(t.envMapCubeUVTileSize),e.push(t.unitsScaleFactor),e.push(t.esmDistanceScale),e.push(t.numRectAreaLightShadows),e.push(t.numDirLightShadowsCSM),e.push(t.numDirLightShadowCSMCascades),e.push(t.numDirLightShadowsCSMWithFade),e.push(t.dirLightShadowsCSMLUT)}(n,t),function(e,t){s.disableAll(),t.isWebGL2&&s.enable(0);t.supportsVertexTextures&&s.enable(1);t.instancing&&s.enable(2);t.instancingColor&&s.enable(3);t.map&&s.enable(4);t.envMap&&s.enable(5);t.lightMap&&s.enable(6);t.aoMap&&s.enable(7);t.emissiveMap&&s.enable(8);t.bumpMap&&s.enable(9);t.normalMap&&s.enable(10);t.objectSpaceNormalMap&&s.enable(11);t.tangentSpaceNormalMap&&s.enable(12);t.displacementMap&&s.enable(17);t.roughnessMap&&s.enable(19);t.metalnessMap&&s.enable(20);t.alphaMap&&s.enable(21);t.alphaTest&&s.enable(22);t.vertexColors&&s.enable(23);t.vertexAlphas&&s.enable(24);t.vertexUvs&&s.enable(25);t.vertexTangents&&s.enable(26);t.uvsVertexOnly&&s.enable(27);e.push(s.mask),s.disableAll(),t.fog&&s.enable(0);t.useFog&&s.enable(1);t.flatShading&&s.enable(2);t.logarithmicDepthBuffer&&s.enable(3);t.skinning&&s.enable(4);t.morphTargets&&s.enable(5);t.morphNormals&&s.enable(6);t.premultipliedAlpha&&s.enable(7);t.shadowMapEnabled&&s.enable(8);t.doubleSided&&s.enable(9);t.flipSided&&s.enable(10);t.useDepthPacking&&s.enable(11);t.dithering&&s.enable(12);t.decodeVideoTexture&&s.enable(18);t.opaque&&s.enable(19);t.distancePacking&&s.enable(20);t.useSlopeScaledBias&&s.enable(21);t.useGTAO&&s.enable(22);t.planeReflProbe&&s.enable(23);t.alphaToCoverage&&s.enable(24);e.push(s.mask)}(n,t),n.push(e.outputEncoding)),n.push(t.customProgramCacheKey),void 0!==t.nodeChunksHash&&n.push(t.nodeChunksHash),n.join()},getUniforms:function(e){const t=f[e.type];let n;if(t){const e=ShaderLib[t];n=UniformsUtils.clone(e.uniforms)}else n=e.uniforms;return n},acquireProgram:function(t,n){let o;for(let e=0,t=l.length;e<t;e++){const t=l[e];if(t.cacheKey===n){o=t,++o.usedTimes;break}}void 0===o&&(o=new WebGLProgram(e,n,t,i),l.push(o),p++);const r=o.profile.materials;return t.materialName&&!r.has(t.materialName)&&r.add(t.materialName),o},releaseProgram:function(e){if(0===--e.usedTimes){const t=l.indexOf(e);l[t]=l[l.length-1],l.pop(),e.destroy()}},programs:l,getNumShaderCompiles:function(){return p}}}function WebGLProperties(){let e=new WeakMap;return{get:function(t){let n=e.get(t);return void 0===n&&(n={},e.set(t,n)),n},remove:function(t){e.delete(t)},update:function(t,n,o){e.get(t)[n]=o},dispose:function(){e=new WeakMap}}}function painterSortStable(e,t){return e.groupOrder!==t.groupOrder?e.groupOrder-t.groupOrder:e.renderOrder!==t.renderOrder?e.renderOrder-t.renderOrder:e.material.id!==t.material.id?e.material.id-t.material.id:e.z!==t.z?e.z-t.z:e.id-t.id}function reversePainterSortStable(e,t){return e.groupOrder!==t.groupOrder?e.groupOrder-t.groupOrder:e.renderOrder!==t.renderOrder?e.renderOrder-t.renderOrder:e.z!==t.z?t.z-e.z:e.id-t.id}function WebGLRenderList(){const e=[];let t=0;const n=[],o=[];function r(n,o,r,i,a,s){let l=e[t];return void 0===l?(l={id:n.id,object:n,geometry:o,material:r,groupOrder:i,renderOrder:n.renderOrder,z:a,group:s},e[t]=l):(l.id=n.id,l.object=n,l.geometry=o,l.material=r,l.groupOrder=i,l.renderOrder=n.renderOrder,l.z=a,l.group=s),t++,l}return{opaque:n,transparent:o,init:function(){t=0,n.length=0,o.length=0},push:function(e,t,i,a,s,l){const c=r(e,t,i,a,s,l);!0===i.transparent?o.push(c):n.push(c)},unshift:function(e,t,i,a,s,l){const c=r(e,t,i,a,s,l);!0===i.transparent?o.unshift(c):n.unshift(c)},finish:function(){for(let n=t,o=e.length;n<o;n++){const t=e[n];if(null===t.id)break;t.id=null,t.object=null,t.geometry=null,t.material=null,t.group=null}},sort:function(e,t){n.length>1&&n.sort(e||painterSortStable),o.length>1&&o.sort(t||reversePainterSortStable)}}}function WebGLRenderLists(){let e=new WeakMap;return{get:function(t,n){const o=e.get(t);let r;return void 0===o?(r=new WebGLRenderList,e.set(t,[r])):n>=o.length?(r=new WebGLRenderList,o.push(r)):r=o[n],r},dispose:function(){e=new WeakMap}}}function UniformsCache(){const e={};return{get:function(t){if(void 0!==e[t.id])return e[t.id];let n;switch(t.type){case"DirectionalLight":n={direction:new Vector3,color:new Color};break;case"SpotLight":n={position:new Vector3,direction:new Vector3,color:new Color,distance:0,coneCos:0,penumbraCos:0,decay:0};break;case"PointLight":n={position:new Vector3,color:new Color,distance:0,decay:0};break;case"RectAreaLight":n={color:new Color,position:new Vector3,halfWidth:new Vector3,halfHeight:new Vector3}}return e[t.id]=n,n}}}function ShadowUniformsCache(){const e={};return{get:function(t){if(void 0!==e[t.id])return e[t.id];let n;switch(t.type){case"DirectionalLight":n={cascadeIdxEnd:1,cameraNear:1,shadowFar:0,fade:.25};break;case"SpotLight":n={shadowBias:0,shadowNormalBias:0,shadowRadius:1,shadowMapSize:new Vector2,shadow:0,shadowCameraNear:1,shadowCameraFar:1e3,expBias:1};break;case"PointLight":case"RectAreaLight":n={shadowBias:0,shadowNormalBias:0,shadowRadius:1,shadowMapSize:new Vector2,shadowCameraNear:1,shadowCameraFar:1e3,expBias:1}}return e[t.id]=n,n}}}let nextVersion=0;function sortOrderOfLights(e,t){const n=e.shadow,o=t.shadow;let r=0;return n&&n.isDirectionalLightShadowCSM&&o&&o.isDirectionalLightShadowCSM&&(r+=(0!=o.fade?1:0)-(0!=n.fade?1:0)),(t.castShadow?4:0)-(e.castShadow?4:0)+(t.map?2:0)-(e.map?2:0)+r}function WebGLLights(e,t){const n=new UniformsCache,o=ShadowUniformsCache(),r={version:0,hash:{directionalLength:-1,pointLength:-1,spotLength:-1,rectAreaLength:-1,numPointShadows:-1,numSpotShadows:-1,numRectAreaShadows:-1,numDirectionalShadowsCSM:-1,numDirectionalShadowsCSMCascade:-1,numDirectionalShadowsCSMWithFade:-1},ambient:[0,0,0],probe:[],directional:[],directionalShadow:[],directionalShadowMap:[],directionalShadowMatrix:[],spot:[],spotShadow:[],spotShadowMap:[],spotShadowMatrix:[],rectArea:[],rectAreaLTC1:null,rectAreaLTC2:null,point:[],pointShadow:[],pointShadowMap:[],pointShadowMatrix:[],rectAreaShadow:[],rectAreaShadowMap:[],rectAreaShadowMatrix:[],directionalShadowCSM:[],directionalShadowCSMMap:[],directionalShadowCSMMatrix:[],directionalShadowCSMCascade:[],directionalShadowCSMLUT:[],numDirectionalShadowsCSMWithFade:0};for(let e=0;e<9;e++)r.probe.push(new Vector3);const i=new Vector3,a=new Matrix4,s=new Matrix4;return{setup:function(i){let a=0,s=0,l=0;for(let e=0;e<9;e++)r.probe[e].set(0,0,0);let c=0,u=0,d=0,h=0,p=0,f=0,m=0,g=0,_=0,A=0;i.sort(sortOrderOfLights);for(let e=0,t=i.length;e<t;e++){const t=i[e],v=t.color,x=t.intensity,y=t.distance,b=t.shadow&&t.shadow.map?t.shadow.map.texture:null;if(t.isAmbientLight)a+=v.r*x,s+=v.g*x,l+=v.b*x;else if(t.isLightProbe)for(let e=0;e<9;e++)r.probe[e].addScaledVector(t.sh.coefficients[e],x);else if(t.isDirectionalLight){const e=n.get(t);if(e.color.copy(t.color).multiplyScalar(t.intensity),t.castShadow){const e=t.shadow,n=o.get(t);n.cascadeIdxEnd=A+e.numCascades,n.fade=e.fade,_+=0!=e.fade?e.numCascades:0;for(let t=0;t<e.numCascades;t++){let n=A+t;r.directionalShadowCSMCascade[n]||(r.directionalShadowCSMCascade[n]={shadowBias:0,shadowNormalBias:0,shadowRadius:1,shadowMapSize:new Vector2,shadowCameraNear:1,shadowCameraFar:1,cascade:new Vector2,expBias:1,position:new Vector3,csmIdx:0},r.directionalShadowCSMMap[n]=null,r.directionalShadowCSMMatrix[n]=e.matrix)}for(let t=0;t<e.numCascades;t++){const n=A+t,o=r.directionalShadowCSMCascade[n],i=e._cascades[t],a=i.map?i.map.texture:null;r.directionalShadowCSMMap[n]=a,r.directionalShadowCSMMatrix[n]=i.matrix,o.shadowBias=i.bias,o.shadowNormalBias=i.normalBias,o.shadowRadius=i.radius,o.shadowMapSize=i.mapSize,o.position.setFromMatrixPosition(i.camera.matrixWorld),o.shadowCameraNear=i.camera.near,o.shadowCameraFar=i.camera.far,e.getCascadeRange(o.cascade,t),o.expBias=i.expBias,o.csmIdx=g,r.directionalShadowCSMLUT[n]=g}A+=e.numCascades,r.directionalShadowCSM[g]=n,g++}r.directional[c]=e,c++}else if(t.isSpotLight){const e=n.get(t);if(e.position.setFromMatrixPosition(t.matrixWorld),e.color.copy(v).multiplyScalar(x),e.distance=y,e.coneCos=Math.cos(t.angle),e.penumbraCos=Math.cos(t.angle*(1-t.penumbra)),e.decay=t.decay,r.spot[d]=e,t.castShadow){const e=t.shadow,n=o.get(t);n.shadowBias=e.bias,n.shadowNormalBias=e.normalBias,n.shadowRadius=e.radius,n.shadowMapSize=e.mapSize,r.spotShadow[d]=n,r.spotShadowMap[d]=b,r.spotShadowMatrix[d]=e.matrix,n.shadow=t.castShadow?e.calcUseOmniMaps(t.angle)?2:1:0,n.shadowCameraNear=e.camera.near,n.shadowCameraFar=e.camera.far,n.expBias=e.expBias,f++}d++}else if(t.isRectAreaLight){const e=n.get(t);if(e.color.copy(v).multiplyScalar(x),e.halfWidth.set(.5*t.width,0,0),e.halfHeight.set(0,.5*t.height,0),t.castShadow){const e=t.shadow,n=o.get(t);n.shadowBias=e.bias,n.shadowNormalBias=e.normalBias,n.shadowRadius=e.radius,n.shadowMapSize=e.mapSize,n.shadowCameraNear=e.camera.near,n.shadowCameraFar=e.camera.far,n.expBias=e.expBias,r.rectAreaShadow[h]=n,r.rectAreaShadowMap[h]=b,r.rectAreaShadowMatrix[h]=e.matrix,m++}r.rectArea[h]=e,h++}else if(t.isPointLight){const e=n.get(t);if(e.color.copy(t.color).multiplyScalar(t.intensity),e.distance=t.distance,e.decay=t.decay,t.castShadow){const e=t.shadow,n=o.get(t);n.shadowBias=e.bias,n.shadowNormalBias=e.normalBias,n.shadowRadius=e.radius,n.shadowMapSize=e.mapSize,n.shadowCameraNear=e.camera.near,n.shadowCameraFar=e.camera.far,n.expBias=e.expBias,r.pointShadow[u]=n,r.pointShadowMap[u]=b,r.pointShadowMatrix[u]=e.matrix,p++}r.point[u]=e,u++}}h>0&&(t.isWebGL2||!0===e.has("OES_texture_float_linear")?(r.rectAreaLTC1=UniformsLib.LTC_FLOAT_1,r.rectAreaLTC2=UniformsLib.LTC_FLOAT_2):!0===e.has("OES_texture_half_float_linear")?(r.rectAreaLTC1=UniformsLib.LTC_HALF_1,r.rectAreaLTC2=UniformsLib.LTC_HALF_2):console.error("v3d.WebGLRenderer: Unable to use RectAreaLight. Missing WebGL extensions.")),r.ambient[0]=a,r.ambient[1]=s,r.ambient[2]=l;const v=r.hash;v.directionalLength===c&&v.pointLength===u&&v.spotLength===d&&v.rectAreaLength===h&&v.numPointShadows===p&&v.numSpotShadows===f&&v.numRectAreaShadows===m&&v.numDirectionalShadowsCSM===g&&v.numDirectionalShadowsCSMCascade===A&&v.numDirectionalShadowsCSMWithFade===_||(r.directional.length=c,r.spot.length=d,r.rectArea.length=h,r.point.length=u,r.pointShadow.length=p,r.pointShadowMap.length=p,r.spotShadow.length=f,r.spotShadowMap.length=f,r.pointShadowMatrix.length=p,r.spotShadowMatrix.length=f,v.directionalLength=c,v.pointLength=u,v.spotLength=d,v.rectAreaLength=h,v.numPointShadows=p,v.numSpotShadows=f,r.rectAreaShadow.length=m,r.rectAreaShadowMap.length=m,r.rectAreaShadowMatrix.length=m,r.directionalShadowCSM.length=g,r.directionalShadowCSMMap.length=A,r.directionalShadowCSMMatrix.length=A,r.directionalShadowCSMCascade.length=A,r.directionalShadowCSMLUT.length=A,r.numDirectionalShadowsCSMWithFade=_,v.numRectAreaShadows=m,v.numDirectionalShadowsCSM=g,v.numDirectionalShadowsCSMCascade=A,v.numDirectionalShadowsCSMWithFade=_,r.version=nextVersion++)},setupView:function(e,t){let n=0,l=0,c=0,u=0,d=0;const h=t.matrixWorldInverse;for(let p=0,f=e.length;p<f;p++){const f=e[p];if(f.isDirectionalLight){const e=r.directional[n];if(e.direction.setFromMatrixPosition(f.matrixWorld),i.setFromMatrixPosition(f.target.matrixWorld),e.direction.sub(i),e.direction.transformDirection(h),f.castShadow){const e=f.shadow,n=o.get(f);n.cameraNear=Math.min(e.maxDistance,t.near),n.shadowFar=Math.min(e.maxDistance,t.far);for(let t=0;t<e.numCascades;t++){const n=d+t,o=r.directionalShadowCSMCascade[n],i=e._cascades[t];o.shadowCameraFar=i.camera.far,o.position.setFromMatrixPosition(i.camera.matrixWorld),o.position.applyMatrix4(h)}d+=e.numCascades}n++}else if(f.isSpotLight){const e=r.spot[c];e.position.setFromMatrixPosition(f.matrixWorld),e.position.applyMatrix4(h),e.direction.setFromMatrixPosition(f.matrixWorld),i.setFromMatrixPosition(f.target.matrixWorld),e.direction.sub(i),e.direction.transformDirection(h),c++}else if(f.isRectAreaLight){const e=r.rectArea[u];e.position.setFromMatrixPosition(f.matrixWorld),e.position.applyMatrix4(h),s.identity(),a.copy(f.matrixWorld),a.premultiply(h),s.extractRotation(a),e.halfWidth.set(.5*f.width,0,0),e.halfHeight.set(0,.5*f.height,0),e.halfWidth.applyMatrix4(s),e.halfHeight.applyMatrix4(s),u++}else if(f.isPointLight){const e=r.point[l];e.position.setFromMatrixPosition(f.matrixWorld),e.position.applyMatrix4(h),l++}}},state:r}}function WebGLRenderState(e,t){const n=new WebGLLights(e,t),o=[],r=[],i=[],a=[];return{init:function(){o.length=0,r.length=0,i.length=0,a.length=0},state:{lightsArray:o,shadowsArray:r,envMapProbeArray:i,planeReflProbeArray:a,lights:n},setupLights:function(){n.setup(o)},setupLightsView:function(e){n.setupView(o,e)},pushLight:function(e){o.push(e)},pushShadow:function(e){r.push(e)},pushEnvMapProbe:function(e){i.push(e)},sortEnvMapProbes:function(){i.sort((e,t)=>e.influenceDistance-t.influenceDistance)},pushPlaneReflProbe:function(e){a.push(e)}}}function WebGLRenderStates(e,t){let n=new WeakMap;return{get:function(o,r=0){const i=n.get(o);let a;return void 0===i?(a=new WebGLRenderState(e,t),n.set(o,[a])):r>=i.length?(a=new WebGLRenderState(e,t),i.push(a)):a=i[r],a},dispose:function(){n=new WeakMap}}}class MeshDepthMaterial extends Material{constructor(e){super(),this.isMeshDepthMaterial=!0,this.type="MeshDepthMaterial",this.depthPacking=3200,this.useSlopeScaledBias=!1,this.slopeScaledBias=0,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.setValues(e)}copy(e){return super.copy(e),this.depthPacking=e.depthPacking,this.useSlopeScaledBias=e.useSlopeScaledBias,this.slopeScaledBias=e.slopeScaledBias,this.map=e.map,this.alphaMap=e.alphaMap,this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this}}class MeshDistanceMaterial extends Material{constructor(e){super(),this.isMeshDistanceMaterial=!0,this.type="MeshDistanceMaterial",this.referencePosition=new Vector3,this.nearDistance=1,this.farDistance=1e3,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.defines={DISTANCE_SCALE:"1.0"},this.distancePacking=3301,this.useSlopeScaledBias=!1,this.slopeScaledBias=0,this.setValues(e)}copy(e){return super.copy(e),this.referencePosition.copy(e.referencePosition),this.nearDistance=e.nearDistance,this.farDistance=e.farDistance,this.map=e.map,this.alphaMap=e.alphaMap,this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.distancePacking=e.distancePacking,this.useSlopeScaledBias=e.useSlopeScaledBias,this.slopeScaledBias=e.slopeScaledBias,this}}const _projScreenMatrix$2=new Matrix4,_lightPositionWorld$2=new Vector3,_lookTarget$2=new Vector3;class LightShadow{constructor(e){this.camera=e,this.bias=0,this.normalBias=0,this.radius=1,this.mapSize=new Vector2(512,512),this.map=null,this.matrix=new Matrix4,this.autoUpdate=!0,this.needsUpdate=!1,this._frustum=new Frustum,this._frameExtents=new Vector2(1,1),this._viewportCount=1,this._viewports=[new Vector4(0,0,1,1)],this.expBias=1,this.slopeScaledBias=0,this._additionalMap2D=null,this._additionalMapCube=null,this.isLightShadow=!0}getViewportCount(){return this._viewportCount}getFrustum(){return this._frustum}updateMatrices(e){const t=this.camera,n=this.matrix;_lightPositionWorld$2.setFromMatrixPosition(e.matrixWorld),t.position.copy(_lightPositionWorld$2),_lookTarget$2.setFromMatrixPosition(e.target.matrixWorld),t.lookAt(_lookTarget$2),t.updateMatrixWorld(),_projScreenMatrix$2.multiplyMatrices(t.projectionMatrix,t.matrixWorldInverse),this._frustum.setFromProjectionMatrix(_projScreenMatrix$2),n.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),n.multiply(_projScreenMatrix$2)}getViewport(e){return this._viewports[e]}getFrameExtents(){return this._frameExtents}dispose(){this.map&&this.map.dispose(),null!==this._additionalMap2D&&this._additionalMap2D.dispose(),null!==this._additionalMapCube&&this._additionalMapCube.dispose()}removeMaps(){this.map=null,this._additionalMap2D=null,this._additionalMapCube=null}copy(e){return this.camera=e.camera.clone(),this.bias=e.bias,this.radius=e.radius,this.mapSize.copy(e.mapSize),this.expBias=e.expBias,this.slopeScaledBias=e.slopeScaledBias,this}clone(){return(new this.constructor).copy(this)}}const OMNI_MAP_ANGLE=Math.PI/4,_projScreenMatrix$1=new Matrix4,_lightPositionWorld$1=new Vector3,_lookTarget$1=new Vector3;class SpotLightShadow extends LightShadow{constructor(){super(new PerspectiveCamera(50,1,.5,500)),this.isSpotLightShadow=!0,this.focus=1,this.useOmniMaps=!1,this.useMinFov90=!1,this._frameExtentsOmni=new Vector2(4,2),this._viewportCountOmni=6,this._viewportsOmni=[new Vector4(2,1,1,1),new Vector4(0,1,1,1),new Vector4(3,1,1,1),new Vector4(1,1,1,1),new Vector4(3,0,1,1),new Vector4(1,0,1,1)],this._cubeDirections=[new Vector3(1,0,0),new Vector3(-1,0,0),new Vector3(0,0,1),new Vector3(0,0,-1),new Vector3(0,1,0),new Vector3(0,-1,0)],this._cubeUps=[new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,0,1),new Vector3(0,0,-1)]}updateMatrices(e,t=0){if(this.useOmniMaps){const n=this.camera,o=this.matrix;_lightPositionWorld$1.setFromMatrixPosition(e.matrixWorld),n.position.copy(_lightPositionWorld$1),_lookTarget$1.copy(n.position),_lookTarget$1.add(this._cubeDirections[t]),n.up.copy(this._cubeUps[t]),n.lookAt(_lookTarget$1),n.updateMatrixWorld(),o.makeTranslation(-_lightPositionWorld$1.x,-_lightPositionWorld$1.y,-_lightPositionWorld$1.z),_projScreenMatrix$1.multiplyMatrices(n.projectionMatrix,n.matrixWorldInverse),this._frustum.setFromProjectionMatrix(_projScreenMatrix$1)}else{const t=this.camera,n=2*RAD2DEG*e.angle*this.focus,o=this.mapSize.width/this.mapSize.height,r=e.distance||t.far;n===t.fov&&o===t.aspect&&r===t.far||(t.fov=n,t.aspect=o,t.far=r,t.updateProjectionMatrix()),super.updateMatrices(e)}}getViewportCount(){return this.useOmniMaps?this._viewportCountOmni:super.getViewportCount()}getViewport(e){return this.useOmniMaps?this._viewportsOmni[e]:super.getViewport(e)}getFrameExtents(){return this.useOmniMaps?this._frameExtentsOmni:super.getFrameExtents()}calcUseOmniMaps(e){return this.useOmniMaps=e>OMNI_MAP_ANGLE,this.useOmniMaps}copy(e){return super.copy(e),this.focus=e.focus,this.useOmniMaps=e.useOmniMaps,this.useMinFov90=e.useMinFov90,this}}const ESM_BLUR_TO_SAMPLES_COEFF=.8,ESM_OCT_BLUR_TO_SAMPLES_COEFF=.2,SPOT_WIDE_TO_NARROW_COEFF=.8,DIR_ESM_BLUR_COEFF=50;function WebGLShadowMap(e,t,n){let o=new Frustum;const r=new Vector2,i=new Vector2,a=new Vector4,s=new MeshDepthMaterial({depthPacking:3201}),l=new MeshDistanceMaterial,c={},u=n.maxTextureSize,d=n.isWebGL2,h={0:1,1:0,2:2},p=new Matrix4;new Matrix4;const f=new Vector2(u,u),m=new Vector3,g=new Vector3;new Vector3;const _=[new Vector3(1,0,0),new Vector3(-1,0,0),new Vector3(0,1,0),new Vector3(0,-1,0),new Vector3(0,0,1),new Vector3(0,0,-1)],A=[new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,0,1),new Vector3(0,0,-1),new Vector3(0,1,0),new Vector3(0,1,0)];new Vector4,new Vector4,new Vector4,new Vector4,new Vector4,new Vector4,new Sphere,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3;const v=new Mesh(new PlaneGeometry(1,1,1,1));v.name="esmFarPlane",v.castShadow=!0,v.material.shadowSide=0;const x=new OrthographicCamera(-1,1,1,-1,0,10),y=new Mesh(new PlaneGeometry(2,2)),b=new ShaderMaterial({type:"ShadowCubeOctahedral",defines:Object.assign({},ShaderLib.cubeOctahedral.defines),uniforms:UniformsUtils.clone(ShaderLib.cubeOctahedral.uniforms),vertexShader:ShaderLib.cubeOctahedral.vertexShader,fragmentShader:ShaderLib.cubeOctahedral.fragmentShader}),C={},S={},E=this;function M(t,n,o,r,i,a,u,d,p){let f=null;const m=d||3===u?t.customDistanceMaterial:t.customDepthMaterial;if(f=void 0!==m?m:d||3===u?l:s,e.localClippingEnabled&&!0===o.clipShadows&&Array.isArray(o.clippingPlanes)&&0!==o.clippingPlanes.length||o.displacementMap&&0!==o.displacementScale||o.alphaMap&&o.alphaTest>0||o.map&&o.alphaTest>0){const e=f.uuid,t=o.uuid;let n=c[e];void 0===n&&(n={},c[e]=n);let r=n[t];void 0===r&&(r=f.clone(),n[t]=r),f=r}f.visible=o.visible,f.wireframe=o.wireframe,f.side=null!==o.shadowSide?o.shadowSide:h[o.side],f.alphaMap=o.alphaMap,f.alphaTest=o.alphaTest,f.map=o.map,f.clipShadows=o.clipShadows,f.clippingPlanes=o.clippingPlanes,f.clipIntersection=o.clipIntersection,f.displacementMap=o.displacementMap,f.displacementScale=o.displacementScale,f.displacementBias=o.displacementBias,f.wireframeLinewidth=o.wireframeLinewidth,f.linewidth=o.linewidth;const g=(d||3===u)&&!0===f.isMeshDistanceMaterial;switch(g&&(f.referencePosition.copy(p),f.nearDistance=i,f.farDistance=a,f.distancePacking=3===u?3302:3301),3===u&&(f.defines.DISTANCE_SCALE=shaderFloatStr(E.esmDistanceScale)),r.shadow.isDirectionalLightShadowCascade&&r.shadow.pancakeDepth&&(f.defines.PANCAKE_DEPTH="",g&&(f.defines.CAM_WIDTH=shaderFloatStr(r.shadow.camera.right),f.defines.CAM_HEIGHT=shaderFloatStr(r.shadow.camera.top))),u){case 0:case 1:case 2:f.useSlopeScaledBias=!0,f.slopeScaledBias=r.shadow.slopeScaledBias;break;case 3:f.useSlopeScaledBias=!0,f.slopeScaledBias=.5}return f}function T(n,r,i,a,s,l){if(!1===n.visible)return;if((r.ignoreShadowLayers||n.layers.test(r.layers))&&(n.isMesh||n.isLine||n.isPoints)&&n.castShadow&&(!n.frustumCulled||o.intersectsObject(n))){n.modelViewMatrix.multiplyMatrices(i.matrixWorldInverse,n.matrixWorld);const o=t.update(n),r=n.material;if(Array.isArray(r)){const t=o.groups;for(let c=0,u=t.length;c<u;c++){const u=t[c],d=r[u.materialIndex];if(d&&d.visible){const t=M(n,0,d,a,i.near,i.far,s,l,g);e.renderBufferDirect(i,null,o,t,n,u)}}}else if(r.visible){const t=M(n,0,r,a,i.near,i.far,s,l,g);e.renderBufferDirect(i,null,o,t,n,null)}}const c=n.children;for(let e=0,t=c.length;e<t;e++)T(c[e],r,i,a,s,l)}function w(t,n,s,l){const c=s.shadow,d=c.camera;c.isDirectionalLightShadowCascade?g.setFromMatrixPosition(d.matrixWorld):g.setFromMatrixPosition(s.matrixWorld),r.copy(c.mapSize);const h=c.getFrameExtents();if(r.multiply(h),i.copy(c.mapSize),(r.x>u||r.y>u)&&(r.x>u&&(i.x=Math.floor(u/h.x),r.x=i.x*h.x,c.mapSize.x=i.x),r.y>u&&(i.y=Math.floor(u/h.y),r.y=i.y*h.y,c.mapSize.y=i.y)),s.isSpotLight&&c.map&&c.map.width/c.map.height!==2){const e=c.map;c.map=c._additionalMap2D,c._additionalMap2D=e}const p=s.isPointLight||s.isRectAreaLight||s.isSpotLight&&c.useOmniMaps;if(p?s.isSpotLight&&(d.fov=90,d.updateProjectionMatrix()):s.isSpotLight&&c.useMinFov90&&(d.fov=90,d.updateProjectionMatrix()),null===c.map){const e={minFilter:1003,magFilter:1003,format:1023};c.map=new WebGLRenderTarget(r.x,r.y,e),c.map.texture.name=s.name+".shadowMap",d.updateProjectionMatrix()}e.state.buffers.color.setClear(1,1,1,1),e.setRenderTarget(c.map),e.clear();const f=c.getViewportCount();for(let r=0;r<f;r++){const u=c.getViewport(r);a.set(i.x*u.x,i.y*u.y,i.x*u.z,i.y*u.w),e.state.viewport(a),c.updateMatrices(s,r),o.copy(c.getFrustum()),T(t,n,c.camera,s,l,p)}}function I(t,n,i,a){const s=i.shadow,l=s.camera,c=s.matrix,u=i.isPointLight||i.isRectAreaLight?2:1,h=r.copy(s.mapSize).multiplyScalar(u).min(f).multiplyScalar(1/u);null===s._additionalMapCube&&(s._additionalMapCube=new WebGLCubeRenderTarget(h.x,{minFilter:1006,magFilter:1006,format:d?1028:1023,type:1016}),s._additionalMapCube.texture.name=i.name+".shadowMap.tmpCube"),null===s._additionalMap2D&&(s._additionalMap2D=new WebGLRenderTarget(h.x*u,h.y*u,{minFilter:1006,magFilter:1006,format:d?1028:1023,type:1016}),s._additionalMap2D.texture.name=i.name+".shadowMap.tmp2D"),null===s.map&&(s.map=new WebGLRenderTarget(h.x*u,h.y*u,{minFilter:1006,magFilter:1006,format:d?1028:1023,type:1016}),s.map.texture.name=i.name+".shadowMap"),g.setFromMatrixPosition(i.matrixWorld),l.position.copy(g),i.isSpotLight&&(l.fov=90,l.updateProjectionMatrix()),c.makeTranslation(-g.x,-g.y,-g.z);for(let r=0;r<6;r++)m.copy(l.position),m.add(_[r]),l.up.copy(A[r]),2!==r&&3!==r&&l.up.multiplyScalar(-1),l.lookAt(m),l.updateMatrixWorld(),p.multiplyMatrices(l.projectionMatrix,l.matrixWorldInverse),o.setFromProjectionMatrix(p),e.setRenderTarget(s._additionalMapCube,r),e.clearDepth(),B(n,l,i,a),T(t,n,l,i,a,!0);const v=Math.max(s.radius*u,.001),C=function(e){return Math.ceil(.2*e)}(v);!function(e,t,n){const o=y.material=b;o.uniforms.tCube.value=t.texture,o.uniforms.texelSize.value.set(1/n.width,1/n.height),o.uniformsNeedUpdate=!0,e.setRenderTarget(n),e.clear(),e.updateGeometry(y),e.renderBufferDirect(x,null,y.geometry,o,y,null)}(e,s._additionalMapCube,s.map),R(e,s.map,s._additionalMap2D,C,v,1,0),R(e,s._additionalMap2D,s.map,C,v,0,0)}function R(e,t,n,o,r,i,a){const s=y.material=0===a?function(e){if(!(e in C)){(C[e]=new ShaderMaterial({type:"ShadowBlur",defines:Object.assign({},ShaderLib.blur.defines,{LOG_SPACE:1,OCTAHEDRAL_MAP:1}),uniforms:UniformsUtils.clone(ShaderLib.blur.uniforms),customPrepTokens:Object.assign({},ShaderLib.blur.customPrepTokens),vertexShader:ShaderLib.blur.vertexShader,fragmentShader:ShaderLib.blur.fragmentShader})).customPrepTokens.MAX_SAMPLE_RADIUS=e}return C[e]}(o):function(e){if(!(e in S)){(S[e]=new ShaderMaterial({type:"ShadowBlur",defines:Object.assign({},ShaderLib.blur.defines,{LOG_SPACE:1}),uniforms:UniformsUtils.clone(ShaderLib.blur.uniforms),customPrepTokens:Object.assign({},ShaderLib.blur.customPrepTokens),vertexShader:ShaderLib.blur.vertexShader,fragmentShader:ShaderLib.blur.fragmentShader})).customPrepTokens.MAX_SAMPLE_RADIUS=e}return S[e]}(o);s.uniforms.direction.value.set(+(0===i),+(1===i)),s.uniforms.colorTexture.value=t.texture,s.uniforms.texSize.value.set(t.width,t.height),s.uniforms.kernelRadius.value=r,s.uniformsNeedUpdate=!0,e.setRenderTarget(n),e.clear(),e.updateGeometry(y),e.renderBufferDirect(x,null,y.geometry,s,y,null)}function L(t,n,i,a){const s=i.shadow,l=s.camera,c=s.matrix,u=r.copy(s.mapSize).min(f);let h;null===s._additionalMap2D&&(s._additionalMap2D=new WebGLRenderTarget(u.x,u.y,{minFilter:1006,magFilter:1006,format:d?1028:1023,type:1016}),s._additionalMap2D.texture.name=i.name+".shadowMap.tmp2D"),null===s.map&&(s.map=new WebGLRenderTarget(u.x,u.y,{minFilter:1006,magFilter:1006,format:d?1028:1023,type:1016}),s.map.texture.name=i.name+".shadowMap"),s.isDirectionalLightShadowCascade?g.setFromMatrixPosition(l.matrixWorld):(g.setFromMatrixPosition(i.matrixWorld),l.position.copy(g),m.setFromMatrixPosition(i.target.matrixWorld),l.lookAt(m),l.updateMatrixWorld()),i.isSpotLight&&s.useMinFov90&&(l.fov=90,l.updateProjectionMatrix()),s.isDirectionalLightShadowCascade?(s.updateMatrices(i),o.copy(s.getFrustum())):(c.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),c.multiply(l.projectionMatrix),c.multiply(l.matrixWorldInverse),p.multiplyMatrices(l.projectionMatrix,l.matrixWorldInverse),o.setFromProjectionMatrix(p)),e.setRenderTarget(s.map),e.clearDepth(),B(n,l,i,a),T(t,n,l,i,a,!1),h=i.isDirectionalLight&&i.shadow.isDirectionalLightShadowCascade?50*s.esmBlurRadius:i.isSpotLight?.8*s.radius:s.radius,h=Math.max(h,.001);const _=function(e){return Math.ceil(.8*e)}(h);R(e,s.map,s._additionalMap2D,_,h,0,1),R(e,s._additionalMap2D,s.map,_,h,1,1)}function B(e,t,n,o){let r,i,a,s,l,c;t.isPerspectiveCamera?(r=i=0,a=-.999*t.far,s=l=2*-a*Math.tan(degToRad(t.fov)/2),c=1):t.isOrthographicCamera&&(r=(t.right+t.left)/2,i=(t.top+t.bottom)/2,a=-.999*t.far,s=t.right-t.left,l=t.top-t.bottom,c=1),t.add(v),v.scale.set(s,l,c),v.position.set(r,i,a),v.updateMatrixWorld(),T(v,e,t,n,o,!0)}this.enabled=!1,this.autoUpdate=!0,this.needsUpdate=!1,this.type=2,this.esmDistanceScale=1,this.render=function(t,n,o){if(!1===E.enabled)return;if(!1===E.autoUpdate&&!1===E.needsUpdate)return;if(0===t.length)return;const r=e.getRenderTarget(),i=e.getActiveCubeFace(),a=e.getActiveMipmapLevel(),s=e.state;s.setBlending(0),s.buffers.color.setClear(1,1,1,1),s.buffers.depth.setTest(!0),s.setScissorTest(!1);for(let e=0,r=t.length;e<r;e++){const r=t[e],i=r.shadow;if(void 0!==i){if(!1!==i.autoUpdate||!1!==i.needsUpdate){if(r.isSpotLight&&i.calcUseOmniMaps(r.angle),r.isPointLight||r.isRectAreaLight||r.isSpotLight&&i.useOmniMaps)switch(E.type){case 0:case 1:case 2:w(n,o,r,E.type);break;case 3:I(n,o,r,E.type);break;default:continue}else{if(!r.isSpotLight&&!r.isDirectionalLight)continue;switch(E.type){case 0:case 1:case 2:if(i.isDirectionalLightShadowCSM){i.update(o,r);const e=r.shadow;for(let t=0;t<e.numCascades;t++)r.shadow=e._cascades[t],w(n,o,r,E.type);r.shadow=e}else w(n,o,r,E.type);break;case 3:if(i.isDirectionalLightShadowCSM){i.update(o,r);const e=r.shadow;for(let t=0;t<e.numCascades;t++)r.shadow=e._cascades[t],L(n,o,r,E.type);r.shadow=e}else L(n,o,r,E.type);break;default:continue}}i.needsUpdate=!1}}else console.warn("v3d.WebGLShadowMap:",r,"has no shadow.")}E.needsUpdate=!1,e.setRenderTarget(r,i,a)}}function WebGLState(e,t,n){const o=n.isWebGL2;const r=new function(){let t=!1;const n=new Vector4;let o=null;const r=new Vector4(0,0,0,0);return{setMask:function(n){o===n||t||(e.colorMask(n,n,n,n),o=n)},getMask:function(){return o},setLocked:function(e){t=e},setClear:function(t,o,i,a,s){!0===s&&(t*=a,o*=a,i*=a),n.set(t,o,i,a),!1===r.equals(n)&&(e.clearColor(t,o,i,a),r.copy(n))},reset:function(){t=!1,o=null,r.set(-1,0,0,0)}}},i=new function(){let t=!1,n=null,o=null,r=null,i=null;return{setTest:function(e){e!==i&&(e?G(2929):z(2929),i=e)},getTest:function(){return i},setMask:function(o){n===o||t||(e.depthMask(o),n=o)},setFunc:function(t){if(o!==t){switch(t){case 0:e.depthFunc(512);break;case 1:e.depthFunc(519);break;case 2:e.depthFunc(513);break;case 3:default:e.depthFunc(515);break;case 4:e.depthFunc(514);break;case 5:e.depthFunc(518);break;case 6:e.depthFunc(516);break;case 7:e.depthFunc(517)}o=t}},setLocked:function(e){t=e},setClear:function(t){r!==t&&(e.clearDepth(t),r=t)},reset:function(){t=!1,n=null,o=null,r=null}}},a=new function(){let t=!1,n=null,o=null,r=null,i=null,a=null,s=null,l=null,c=null;return{setTest:function(e){t||(e?G(2960):z(2960))},setMask:function(o){n===o||t||(e.stencilMask(o),n=o)},setFunc:function(t,n,a){o===t&&r===n&&i===a||(e.stencilFunc(t,n,a),o=t,r=n,i=a)},setOp:function(t,n,o){a===t&&s===n&&l===o||(e.stencilOp(t,n,o),a=t,s=n,l=o)},setLocked:function(e){t=e},setClear:function(t){c!==t&&(e.clearStencil(t),c=t)},reset:function(){t=!1,n=null,o=null,r=null,i=null,a=null,s=null,l=null,c=null}}},s=new WeakMap,l=new WeakMap;let c={},u={},d=new WeakMap,h=[],p=null,f=!1,m=null,g=null,_=null,A=null,v=null,x=null,y=null,b=!1,C=null,S=null,E=null,M=null,T=null;const w=e.getParameter(35661);let I=!1,R=0;const L=e.getParameter(7938);-1!==L.indexOf("WebGL")?(R=parseFloat(/^WebGL (\d)/.exec(L)[1]),I=R>=1):-1!==L.indexOf("OpenGL ES")&&(R=parseFloat(/^OpenGL ES (\d)/.exec(L)[1]),I=R>=2);let B=null,P={};const N=e.getParameter(3088),D=e.getParameter(2978),O=(new Vector4).fromArray(N),F=(new Vector4).fromArray(D);function V(t,n,o){const r=new Uint8Array(4),i=e.createTexture();e.bindTexture(t,i),e.texParameteri(t,10241,9728),e.texParameteri(t,10240,9728);for(let t=0;t<o;t++)e.texImage2D(n+t,0,6408,1,1,0,6408,5121,r);return i}const U={};function G(t){!0!==c[t]&&(e.enable(t),c[t]=!0)}function z(t){!1!==c[t]&&(e.disable(t),c[t]=!1)}U[3553]=V(3553,3553,1),U[34067]=V(34067,34069,6),r.setClear(0,0,0,1),i.setClear(1),a.setClear(0),G(2929),i.setFunc(3),H(!1),X(1),G(2884),Q(0);const k={[AddEquation]:32774,[SubtractEquation]:32778,[ReverseSubtractEquation]:32779};if(o)k[103]=32775,k[104]=32776;else{const e=t.get("EXT_blend_minmax");null!==e&&(k[103]=e.MIN_EXT,k[104]=e.MAX_EXT)}const W={[ZeroFactor]:0,[OneFactor]:1,[SrcColorFactor]:768,[SrcAlphaFactor]:770,[SrcAlphaSaturateFactor]:776,[DstColorFactor]:774,[DstAlphaFactor]:772,[OneMinusSrcColorFactor]:769,[OneMinusSrcAlphaFactor]:771,[OneMinusDstColorFactor]:775,[OneMinusDstAlphaFactor]:773};function Q(t,n,o,r,i,a,s,l){if(0!==t){if(!1===f&&(G(3042),f=!0),5===t)i=i||n,a=a||o,s=s||r,n===g&&i===v||(e.blendEquationSeparate(k[n],k[i]),g=n,v=i),o===_&&r===A&&a===x&&s===y||(e.blendFuncSeparate(W[o],W[r],W[a],W[s]),_=o,A=r,x=a,y=s),m=t,b=!1;else if(t!==m||l!==b){if(100===g&&100===v||(e.blendEquation(32774),g=100,v=100),l)switch(t){case 1:e.blendFuncSeparate(1,771,1,771);break;case 2:e.blendFunc(1,1);break;case 3:e.blendFuncSeparate(0,769,0,1);break;case 4:e.blendFuncSeparate(0,768,0,770);break;default:console.error("v3d.WebGLState: Invalid blending: ",t)}else switch(t){case 1:e.blendFuncSeparate(770,771,1,771);break;case 2:e.blendFunc(770,1);break;case 3:e.blendFuncSeparate(0,769,0,1);break;case 4:e.blendFunc(0,768);break;default:console.error("v3d.WebGLState: Invalid blending: ",t)}_=null,A=null,x=null,y=null,m=t,b=l}}else!0===f&&(z(3042),f=!1)}function H(t){C!==t&&(t?e.frontFace(2304):e.frontFace(2305),C=t)}function X(t){0!==t?(G(2884),t!==S&&(1===t?e.cullFace(1029):2===t?e.cullFace(1028):e.cullFace(1032))):z(2884),S=t}function Y(t,n,o){t?(G(32823),M===n&&T===o||(e.polygonOffset(n,o),M=n,T=o)):z(32823)}return{buffers:{color:r,depth:i,stencil:a},enable:G,disable:z,bindFramebuffer:function(t,n){return u[t]!==n&&(e.bindFramebuffer(t,n),u[t]=n,o&&(36009===t&&(u[36160]=n),36160===t&&(u[36009]=n)),!0)},drawBuffers:function(t,n){let o=h,r=!1;if(t)if(o=d.get(n),void 0===o&&(o=[],d.set(n,o)),t.isWebGLMultipleRenderTargets){const e=t.texture;if(o.length!==e.length||36064!==o[0]){for(let t=0,n=e.length;t<n;t++)o[t]=36064+t;o.length=e.length,r=!0}}else 36064!==o[0]&&(o[0]=36064,r=!0);else 1029!==o[0]&&(o[0]=1029,r=!0);r&&e.drawBuffers(o)},useProgram:function(t){return p!==t&&(e.useProgram(t),p=t,!0)},setBlending:Q,setMaterial:function(e,t){2===e.side?z(2884):G(2884);let n=1===e.side;t&&(n=!n),H(n),1===e.blending&&!1===e.transparent?Q(0):Q(e.blending,e.blendEquation,e.blendSrc,e.blendDst,e.blendEquationAlpha,e.blendSrcAlpha,e.blendDstAlpha,e.premultipliedAlpha),i.setFunc(e.depthFunc),i.setTest(e.depthTest),i.setMask(e.depthWrite),r.setMask(e.colorWrite);const o=e.stencilWrite;a.setTest(o),o&&(a.setMask(e.stencilWriteMask),a.setFunc(e.stencilFunc,e.stencilRef,e.stencilFuncMask),a.setOp(e.stencilFail,e.stencilZFail,e.stencilZPass)),Y(e.polygonOffset,e.polygonOffsetFactor,e.polygonOffsetUnits),!0===e.alphaToCoverage?G(32926):z(32926)},setFlipSided:H,setCullFace:X,setLineWidth:function(t){t!==E&&(I&&e.lineWidth(t),E=t)},setPolygonOffset:Y,setScissorTest:function(e){e?G(3089):z(3089)},activeTexture:function(t){void 0===t&&(t=33984+w-1),B!==t&&(e.activeTexture(t),B=t)},bindTexture:function(t,n,o){void 0===o&&(o=null===B?33984+w-1:B);let r=P[o];void 0===r&&(r={type:void 0,texture:void 0},P[o]=r),r.type===t&&r.texture===n||(B!==o&&(e.activeTexture(o),B=o),e.bindTexture(t,n||U[t]),r.type=t,r.texture=n)},unbindTexture:function(){const t=P[B];void 0!==t&&void 0!==t.type&&(e.bindTexture(t.type,null),t.type=void 0,t.texture=void 0)},compressedTexImage2D:function(){try{e.compressedTexImage2D.apply(e,arguments)}catch(e){console.error("v3d.WebGLState:",e)}},compressedTexImage3D:function(){try{e.compressedTexImage3D.apply(e,arguments)}catch(e){console.error("v3d.WebGLState:",e)}},texImage2D:function(){try{e.texImage2D.apply(e,arguments)}catch(e){console.error("v3d.WebGLState:",e)}},texImage3D:function(){try{e.texImage3D.apply(e,arguments)}catch(e){console.error("v3d.WebGLState:",e)}},updateUBOMapping:function(t,n){let o=l.get(n);void 0===o&&(o=new WeakMap,l.set(n,o));let r=o.get(t);void 0===r&&(r=e.getUniformBlockIndex(n,t.name),o.set(t,r))},uniformBlockBinding:function(t,n){const o=l.get(n).get(t);s.get(t)!==o&&(e.uniformBlockBinding(n,o,t.__bindingPointIndex),s.set(t,o))},texStorage2D:function(){try{e.texStorage2D.apply(e,arguments)}catch(e){console.error("v3d.WebGLState:",e)}},texStorage3D:function(){try{e.texStorage3D.apply(e,arguments)}catch(e){console.error("v3d.WebGLState:",e)}},texSubImage2D:function(){try{e.texSubImage2D.apply(e,arguments)}catch(e){console.error("v3d.WebGLState:",e)}},texSubImage3D:function(){try{e.texSubImage3D.apply(e,arguments)}catch(e){console.error("v3d.WebGLState:",e)}},compressedTexSubImage2D:function(){try{e.compressedTexSubImage2D.apply(e,arguments)}catch(e){console.error("v3d.WebGLState:",e)}},compressedTexSubImage3D:function(){try{e.compressedTexSubImage3D.apply(e,arguments)}catch(e){console.error("v3d.WebGLState:",e)}},scissor:function(t){!1===O.equals(t)&&(e.scissor(t.x,t.y,t.z,t.w),O.copy(t))},viewport:function(t){!1===F.equals(t)&&(e.viewport(t.x,t.y,t.z,t.w),F.copy(t))},reset:function(){e.disable(3042),e.disable(2884),e.disable(2929),e.disable(32823),e.disable(3089),e.disable(2960),e.disable(32926),e.blendEquation(32774),e.blendFunc(1,0),e.blendFuncSeparate(1,0,1,0),e.colorMask(!0,!0,!0,!0),e.clearColor(0,0,0,0),e.depthMask(!0),e.depthFunc(513),e.clearDepth(1),e.stencilMask(4294967295),e.stencilFunc(519,0,4294967295),e.stencilOp(7680,7680,7680),e.clearStencil(0),e.cullFace(1029),e.frontFace(2305),e.polygonOffset(0,0),e.activeTexture(33984),e.bindFramebuffer(36160,null),!0===o&&(e.bindFramebuffer(36009,null),e.bindFramebuffer(36008,null)),e.useProgram(null),e.lineWidth(1),e.scissor(0,0,e.canvas.width,e.canvas.height),e.viewport(0,0,e.canvas.width,e.canvas.height),c={},B=null,P={},u={},d=new WeakMap,h=[],p=null,f=!1,m=null,g=null,_=null,A=null,v=null,x=null,y=null,b=!1,C=null,S=null,E=null,M=null,T=null,O.set(0,0,e.canvas.width,e.canvas.height),F.set(0,0,e.canvas.width,e.canvas.height),r.reset(),i.reset(),a.reset()}}}function WebGLTextures(e,t,n,o,r,i,a){const s=r.isWebGL2,l=r.maxTextures,c=r.maxCubemapSize,u=r.maxTextureSize,d=r.maxSamples,h=t.has("WEBGL_multisampled_render_to_texture")?t.get("WEBGL_multisampled_render_to_texture"):null,p="undefined"!=typeof navigator&&/OculusBrowser/g.test(navigator.userAgent),f=new WeakMap;let m;const g=new WeakMap;let _=!1;try{_="undefined"!=typeof OffscreenCanvas&&null!==new OffscreenCanvas(1,1).getContext("2d")}catch(e){}function A(e,t){return _?new OffscreenCanvas(e,t):createElementNS("canvas")}function v(e,t,n,o){let r=1;if((e.width>o||e.height>o)&&(r=o/Math.max(e.width,e.height)),r<1||!0===t){if("undefined"!=typeof HTMLImageElement&&e instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&e instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap){const o=t?floorPowerOfTwo:Math.floor,i=o(r*e.width),a=o(r*e.height);void 0===m&&(m=A(i,a));const s=n?A(i,a):m;s.width=i,s.height=a;return s.getContext("2d").drawImage(e,0,0,i,a),console.warn("v3d.WebGLRenderer: Texture has been resized from ("+e.width+"x"+e.height+") to ("+i+"x"+a+")."),s}return"data"in e&&console.warn("v3d.WebGLRenderer: Image in DataTexture is too big ("+e.width+"x"+e.height+")."),e}return e}function x(e){return isPowerOfTwo(e.width)&&isPowerOfTwo(e.height)}function y(e,t){return e.generateMipmaps&&t&&1003!==e.minFilter&&1006!==e.minFilter}function b(t){e.generateMipmap(t)}function C(n,o,r,i,a=!1){if(!1===s)return o;if(null!==n){if(void 0!==e[n])return e[n];console.warn("v3d.WebGLRenderer: Attempt to use non-existing WebGL internal format '"+n+"'")}let l=o;return 6403===o&&(5126===r&&(l=33326),5131===r&&(l=33325),5121===r&&(l=33321)),36244===o&&(5121===r&&(l=33330),5123===r&&(l=33332),5125===r&&(l=33334),5120===r&&(l=33329),5122===r&&(l=33331),5124===r&&(l=33333)),33319===o&&(5126===r&&(l=33328),5131===r&&(l=33327),5121===r&&(l=33323)),33320===o&&(5121===r&&(l=33336),5123===r&&(l=33338),5125===r&&(l=33340),5120===r&&(l=33335),5122===r&&(l=33337),5124===r&&(l=33339)),36248===o&&(5121===r&&(l=36221),5123===r&&(l=36215),5125===r&&(l=36209),5120===r&&(l=36239),5122===r&&(l=36233),5124===r&&(l=36227)),36249===o&&(5121===r&&(l=36220),5123===r&&(l=36214),5125===r&&(l=36208),5120===r&&(l=36238),5122===r&&(l=36232),5124===r&&(l=36226)),6407===o&&35902===r&&(l=35901),6408===o&&(5126===r&&(l=34836),5131===r&&(l=34842),5121===r&&(l=3001===i&&!1===a?35907:32856),32819===r&&(l=32854),32820===r&&(l=32855)),33325!==l&&33326!==l&&33327!==l&&33328!==l&&34842!==l&&34836!==l||t.get("EXT_color_buffer_float"),l}function S(e,t,n){return!0===y(e,n)||e.isFramebufferTexture&&1003!==e.minFilter&&1006!==e.minFilter?Math.log2(Math.max(t.width,t.height))+1:void 0!==e.mipmaps&&e.mipmaps.length>0?e.mipmaps.length:e.isCompressedTexture&&Array.isArray(e.image)?t.mipmaps.length:1}function E(e){return 1003===e||1004===e||1005===e?9728:9729}function M(e){const t=e.target;t.removeEventListener("dispose",M),function(e){const t=o.get(e);if(void 0===t.__webglInit)return;const n=e.source,r=g.get(n);if(r){const o=r[t.__cacheKey];o.usedTimes--,0===o.usedTimes&&w(e),0===Object.keys(r).length&&g.delete(n)}o.remove(e)}(t),t.isVideoTexture&&f.delete(t)}function T(t){const n=t.target;n.removeEventListener("dispose",T),function(t){const n=t.texture,r=o.get(t),i=o.get(n);void 0!==i.__webglTexture&&(e.deleteTexture(i.__webglTexture),a.memory.textures--);t.depthTexture&&t.depthTexture.dispose();if(t.isWebGLCubeRenderTarget)for(let t=0;t<6;t++)e.deleteFramebuffer(r.__webglFramebuffer[t]),r.__webglDepthbuffer&&e.deleteRenderbuffer(r.__webglDepthbuffer[t]);else{if(e.deleteFramebuffer(r.__webglFramebuffer),r.__webglDepthbuffer&&e.deleteRenderbuffer(r.__webglDepthbuffer),r.__webglMultisampledFramebuffer&&e.deleteFramebuffer(r.__webglMultisampledFramebuffer),r.__webglColorRenderbuffer)for(let t=0;t<r.__webglColorRenderbuffer.length;t++)r.__webglColorRenderbuffer[t]&&e.deleteRenderbuffer(r.__webglColorRenderbuffer[t]);r.__webglDepthRenderbuffer&&e.deleteRenderbuffer(r.__webglDepthRenderbuffer)}if(t.isWebGLMultipleRenderTargets)for(let t=0,r=n.length;t<r;t++){const r=o.get(n[t]);r.__webglTexture&&(e.deleteTexture(r.__webglTexture),a.memory.textures--),o.remove(n[t])}o.remove(n),o.remove(t)}(n),a.removeTextureSpec(n)}function w(t){const n=o.get(t);e.deleteTexture(n.__webglTexture);const r=t.source;delete g.get(r)[n.__cacheKey],a.memory.textures--,a.removeTextureSpec(t)}let I=0;function R(e,t){const r=o.get(e);if(e.isVideoTexture&&function(e){const t=a.render.frame;f.get(e)!==t&&(f.set(e,t),e.update())}(e),!1===e.isRenderTargetTexture&&e.version>0&&r.__version!==e.version){const n=e.image;if(null===n)console.warn("v3d.WebGLRenderer: Texture marked for update but no image data found.");else{if(!1!==n.complete)return void D(r,e,t);console.warn("v3d.WebGLRenderer: Texture marked for update but image is incomplete")}}n.bindTexture(3553,r.__webglTexture,33984+t)}const L={[RepeatWrapping]:10497,[ClampToEdgeWrapping]:33071,[MirroredRepeatWrapping]:33648},B={[NearestFilter]:9728,[NearestMipmapNearestFilter]:9984,[NearestMipmapLinearFilter]:9986,[LinearFilter]:9729,[LinearMipmapNearestFilter]:9985,[LinearMipmapLinearFilter]:9987};function P(n,i,a){if(a?(e.texParameteri(n,10242,L[i.wrapS]),e.texParameteri(n,10243,L[i.wrapT]),32879!==n&&35866!==n||e.texParameteri(n,32882,L[i.wrapR]),e.texParameteri(n,10240,B[i.magFilter]),e.texParameteri(n,10241,B[i.minFilter])):(e.texParameteri(n,10242,33071),e.texParameteri(n,10243,33071),32879!==n&&35866!==n||e.texParameteri(n,32882,33071),1001===i.wrapS&&1001===i.wrapT||console.warn("v3d.WebGLRenderer: Texture is not power of two. Texture.wrapS and Texture.wrapT should be set to v3d.ClampToEdgeWrapping."),e.texParameteri(n,10240,E(i.magFilter)),e.texParameteri(n,10241,E(i.minFilter)),1003!==i.minFilter&&1006!==i.minFilter&&console.warn("v3d.WebGLRenderer: Texture is not power of two. Texture.minFilter should be set to v3d.NearestFilter or v3d.LinearFilter.")),!0===t.has("EXT_texture_filter_anisotropic")){const a=t.get("EXT_texture_filter_anisotropic");if(1003===i.magFilter)return;if(1005!==i.minFilter&&1008!==i.minFilter)return;if(1015===i.type&&!1===t.has("OES_texture_float_linear"))return;if(!1===s&&1016===i.type&&!1===t.has("OES_texture_half_float_linear"))return;(i.anisotropy>1||o.get(i).__currentAnisotropy)&&(e.texParameterf(n,a.TEXTURE_MAX_ANISOTROPY_EXT,Math.min(i.anisotropy,r.getMaxAnisotropy())),o.get(i).__currentAnisotropy=i.anisotropy)}}function N(t,n){let o=!1;void 0===t.__webglInit&&(t.__webglInit=!0,n.addEventListener("dispose",M));const r=n.source;let i=g.get(r);void 0===i&&(i={},g.set(r,i));const s=function(e){const t=[];return t.push(e.wrapS),t.push(e.wrapT),t.push(e.wrapR||0),t.push(e.magFilter),t.push(e.minFilter),t.push(e.anisotropy),t.push(e.internalFormat),t.push(e.format),t.push(e.type),t.push(e.generateMipmaps),t.push(e.premultiplyAlpha),t.push(e.flipY),t.push(e.unpackAlignment),t.push(e.encoding),t.join()}(n);if(s!==t.__cacheKey){void 0===i[s]&&(i[s]={texture:e.createTexture(),usedTimes:0},a.memory.textures++,a.addTextureSpec(n),o=!0),i[s].usedTimes++;const r=i[t.__cacheKey];void 0!==r&&(i[t.__cacheKey].usedTimes--,0===r.usedTimes&&w(n)),t.__cacheKey=s,t.__webglTexture=i[s].texture}return o}function D(t,r,a){let l=3553;(r.isDataArrayTexture||r.isCompressedArrayTexture)&&(l=35866),r.isData3DTexture&&(l=32879);const c=N(t,r),d=r.source;n.bindTexture(l,t.__webglTexture,33984+a);const h=o.get(d);if(d.version!==h.__version||!0===c){n.activeTexture(33984+a),e.pixelStorei(37440,r.flipY),e.pixelStorei(37441,r.premultiplyAlpha),e.pixelStorei(3317,r.unpackAlignment),e.pixelStorei(37443,0);const t=function(e){return!s&&(1001!==e.wrapS||1001!==e.wrapT||1003!==e.minFilter&&1006!==e.minFilter)}(r)&&!1===x(r.image);let o=v(r.image,t,!1,u);o=z(r,o);const p=x(o)||s,f=i.convert(r.format,r.encoding);let m,g=i.convert(r.type),_=C(r.internalFormat,f,g,r.encoding,r.isVideoTexture);P(l,r,p);const A=r.mipmaps,E=s&&!0!==r.isVideoTexture,M=void 0===h.__version||!0===c,T=S(r,o,p);if(r.isDepthTexture)_=6402,s?_=1015===r.type?36012:1014===r.type?33190:1020===r.type?35056:33189:1015===r.type&&console.error("WebGLRenderer: Floating point depth texture requires WebGL2."),1026===r.format&&6402===_&&1012!==r.type&&1014!==r.type&&(console.warn("v3d.WebGLRenderer: Use UnsignedShortType or UnsignedIntType for DepthFormat DepthTexture."),r.type=1014,g=i.convert(r.type)),1027===r.format&&6402===_&&(_=34041,1020!==r.type&&(console.warn("v3d.WebGLRenderer: Use UnsignedInt248Type for DepthStencilFormat DepthTexture."),r.type=1020,g=i.convert(r.type))),M&&(E?n.texStorage2D(3553,1,_,o.width,o.height):n.texImage2D(3553,0,_,o.width,o.height,0,f,g,null));else if(r.isDataTexture)if(A.length>0&&p){E&&M&&n.texStorage2D(3553,T,_,A[0].width,A[0].height);for(let e=0,t=A.length;e<t;e++)m=A[e],E?n.texSubImage2D(3553,e,0,0,m.width,m.height,f,g,m.data):n.texImage2D(3553,e,_,m.width,m.height,0,f,g,m.data);r.generateMipmaps=!1}else E?(M&&n.texStorage2D(3553,T,_,o.width,o.height),n.texSubImage2D(3553,0,0,0,o.width,o.height,f,g,o.data)):n.texImage2D(3553,0,_,o.width,o.height,0,f,g,o.data);else if(r.isCompressedTexture)if(r.isCompressedArrayTexture){E&&M&&n.texStorage3D(35866,T,_,A[0].width,A[0].height,o.depth);for(let e=0,t=A.length;e<t;e++)m=A[e],1023!==r.format?null!==f?E?n.compressedTexSubImage3D(35866,e,0,0,0,m.width,m.height,o.depth,f,m.data,0,0):n.compressedTexImage3D(35866,e,_,m.width,m.height,o.depth,0,m.data,0,0):console.warn("v3d.WebGLRenderer: Attempt to load unsupported compressed texture format in .uploadTexture()"):E?n.texSubImage3D(35866,e,0,0,0,m.width,m.height,o.depth,f,g,m.data):n.texImage3D(35866,e,_,m.width,m.height,o.depth,0,f,g,m.data)}else{E&&M&&n.texStorage2D(3553,T,_,A[0].width,A[0].height);for(let e=0,t=A.length;e<t;e++)m=A[e],1023!==r.format?null!==f?E?n.compressedTexSubImage2D(3553,e,0,0,m.width,m.height,f,m.data):n.compressedTexImage2D(3553,e,_,m.width,m.height,0,m.data):console.warn("v3d.WebGLRenderer: Attempt to load unsupported compressed texture format in .uploadTexture()"):E?n.texSubImage2D(3553,e,0,0,m.width,m.height,f,g,m.data):n.texImage2D(3553,e,_,m.width,m.height,0,f,g,m.data)}else if(r.isDataArrayTexture)E?(M&&n.texStorage3D(35866,T,_,o.width,o.height,o.depth),n.texSubImage3D(35866,0,0,0,0,o.width,o.height,o.depth,f,g,o.data)):n.texImage3D(35866,0,_,o.width,o.height,o.depth,0,f,g,o.data);else if(r.isData3DTexture)E?(M&&n.texStorage3D(32879,T,_,o.width,o.height,o.depth),n.texSubImage3D(32879,0,0,0,0,o.width,o.height,o.depth,f,g,o.data)):n.texImage3D(32879,0,_,o.width,o.height,o.depth,0,f,g,o.data);else if(r.isFramebufferTexture){if(M)if(E)n.texStorage2D(3553,T,_,o.width,o.height);else{let e=o.width,t=o.height;for(let o=0;o<T;o++)n.texImage2D(3553,o,_,e,t,0,f,g,null),e>>=1,t>>=1}}else if(A.length>0&&p){E&&M&&n.texStorage2D(3553,T,_,A[0].width,A[0].height);for(let e=0,t=A.length;e<t;e++)m=A[e],E?n.texSubImage2D(3553,e,0,0,f,g,m):n.texImage2D(3553,e,_,f,g,m);r.generateMipmaps=!1}else E?(M&&n.texStorage2D(3553,T,_,o.width,o.height),n.texSubImage2D(3553,0,0,0,f,g,o)):n.texImage2D(3553,0,_,f,g,o);y(r,p)&&b(l),h.__version=d.version,r.onUpdate&&r.onUpdate(r)}t.__version=r.version}function O(t,r,a,s,l){const c=i.convert(a.format,a.encoding),u=i.convert(a.type),d=C(a.internalFormat,c,u,a.encoding);o.get(r).__hasExternalTextures||(32879===l||35866===l?n.texImage3D(l,0,d,r.width,r.height,r.depth,0,c,u,null):n.texImage2D(l,0,d,r.width,r.height,0,c,u,null)),n.bindFramebuffer(36160,t),G(r)?h.framebufferTexture2DMultisampleEXT(36160,s,l,o.get(a).__webglTexture,0,U(r)):(3553===l||l>=34069&&l<=34074)&&e.framebufferTexture2D(36160,s,l,o.get(a).__webglTexture,0),n.bindFramebuffer(36160,null)}function F(t,n,o){if(e.bindRenderbuffer(36161,t),n.depthBuffer&&!n.stencilBuffer){let r=33189;if(s&&(r=33190),o||G(n)){const t=n.depthTexture;t&&t.isDepthTexture&&(1015===t.type?r=36012:1014===t.type&&(r=33190));const o=U(n);G(n)?h.renderbufferStorageMultisampleEXT(36161,o,r,n.width,n.height):e.renderbufferStorageMultisample(36161,o,r,n.width,n.height)}else e.renderbufferStorage(36161,r,n.width,n.height);e.framebufferRenderbuffer(36160,36096,36161,t)}else if(n.depthBuffer&&n.stencilBuffer){const r=U(n);o&&!1===G(n)?e.renderbufferStorageMultisample(36161,r,35056,n.width,n.height):G(n)?h.renderbufferStorageMultisampleEXT(36161,r,35056,n.width,n.height):e.renderbufferStorage(36161,34041,n.width,n.height),e.framebufferRenderbuffer(36160,33306,36161,t)}else{const t=!0===n.isWebGLMultipleRenderTargets?n.texture:[n.texture];for(let r=0;r<t.length;r++){const a=t[r],s=i.convert(a.format,a.encoding),l=i.convert(a.type),c=C(a.internalFormat,s,l,a.encoding),u=U(n);o&&!1===G(n)?e.renderbufferStorageMultisample(36161,u,c,n.width,n.height):G(n)?h.renderbufferStorageMultisampleEXT(36161,u,c,n.width,n.height):e.renderbufferStorage(36161,c,n.width,n.height)}}e.bindRenderbuffer(36161,null)}function V(t){const r=o.get(t),i=!0===t.isWebGLCubeRenderTarget;if(t.depthTexture&&!r.__autoAllocateDepthBuffer){if(i)throw new Error("target.depthTexture not supported in Cube render targets");!function(t,r){if(r&&r.isWebGLCubeRenderTarget)throw new Error("Depth Texture with cube render targets is not supported");if(n.bindFramebuffer(36160,t),!r.depthTexture||!r.depthTexture.isDepthTexture)throw new Error("renderTarget.depthTexture must be an instance of v3d.DepthTexture");o.get(r.depthTexture).__webglTexture&&r.depthTexture.image.width===r.width&&r.depthTexture.image.height===r.height||(r.depthTexture.image.width=r.width,r.depthTexture.image.height=r.height,r.depthTexture.needsUpdate=!0),R(r.depthTexture,0);const i=o.get(r.depthTexture).__webglTexture,a=U(r);if(1026===r.depthTexture.format)G(r)?h.framebufferTexture2DMultisampleEXT(36160,36096,3553,i,0,a):e.framebufferTexture2D(36160,36096,3553,i,0);else{if(1027!==r.depthTexture.format)throw new Error("Unknown depthTexture format");G(r)?h.framebufferTexture2DMultisampleEXT(36160,33306,3553,i,0,a):e.framebufferTexture2D(36160,33306,3553,i,0)}}(r.__webglFramebuffer,t)}else if(i){r.__webglDepthbuffer=[];for(let o=0;o<6;o++)n.bindFramebuffer(36160,r.__webglFramebuffer[o]),r.__webglDepthbuffer[o]=e.createRenderbuffer(),F(r.__webglDepthbuffer[o],t,!1)}else n.bindFramebuffer(36160,r.__webglFramebuffer),r.__webglDepthbuffer=e.createRenderbuffer(),F(r.__webglDepthbuffer,t,!1);n.bindFramebuffer(36160,null)}function U(e){return Math.min(d,e.samples)}function G(e){const n=o.get(e);return s&&e.samples>0&&!0===t.has("WEBGL_multisampled_render_to_texture")&&!1!==n.__useRenderToTexture}function z(e,n){const o=e.encoding,r=e.format,i=e.type;return!0===e.isCompressedTexture||!0===e.isVideoTexture||1035===e.format||3e3!==o&&(3001===o?!1===s?!0===t.has("EXT_sRGB")&&1023===r?(e.format=1035,e.minFilter=1006,e.generateMipmaps=!1):n=ImageUtils.sRGBToLinear(n):1023===r&&1009===i||console.warn("v3d.WebGLTextures: sRGB encoded textures have to use RGBAFormat and UnsignedByteType. Perhaps you've set sRGB color space for an HDR image?"):console.error("v3d.WebGLTextures: Unsupported texture encoding:",o)),n}this.allocateTextureUnit=function(){const e=I;return e>=l&&console.warn("v3d.WebGLTextures: Trying to use "+e+" texture units while this GPU supports only "+l),I+=1,e},this.resetTextureUnits=function(){I=0},this.setTexture2D=R,this.setTexture2DArray=function(e,t){const r=o.get(e);e.version>0&&r.__version!==e.version?D(r,e,t):n.bindTexture(35866,r.__webglTexture,33984+t)},this.setTexture3D=function(e,t){const r=o.get(e);e.version>0&&r.__version!==e.version?D(r,e,t):n.bindTexture(32879,r.__webglTexture,33984+t)},this.setTextureCube=function(t,r){const a=o.get(t);t.version>0&&a.__version!==t.version?function(t,r,a){if(6!==r.image.length)return;const l=N(t,r),u=r.source;n.bindTexture(34067,t.__webglTexture,33984+a);const d=o.get(u);if(u.version!==d.__version||!0===l){n.activeTexture(33984+a),e.pixelStorei(37440,r.flipY),e.pixelStorei(37441,r.premultiplyAlpha),e.pixelStorei(3317,r.unpackAlignment),e.pixelStorei(37443,0);const t=r.isCompressedTexture||r.image[0].isCompressedTexture,o=r.image[0]&&r.image[0].isDataTexture,h=[];for(let e=0;e<6;e++)h[e]=t||o?o?r.image[e].image:r.image[e]:v(r.image[e],!1,!0,c),h[e]=z(r,h[e]);const p=h[0],f=x(p)||s,m=i.convert(r.format,r.encoding),g=i.convert(r.type),_=C(r.internalFormat,m,g,r.encoding),A=s&&!0!==r.isVideoTexture,E=void 0===d.__version||!0===l;let M,T=S(r,p,f);if(P(34067,r,f),t){A&&E&&n.texStorage2D(34067,T,_,p.width,p.height);for(let e=0;e<6;e++){M=h[e].mipmaps;for(let t=0;t<M.length;t++){const o=M[t];1023!==r.format?null!==m?A?n.compressedTexSubImage2D(34069+e,t,0,0,o.width,o.height,m,o.data):n.compressedTexImage2D(34069+e,t,_,o.width,o.height,0,o.data):console.warn("v3d.WebGLRenderer: Attempt to load unsupported compressed texture format in .setTextureCube()"):A?n.texSubImage2D(34069+e,t,0,0,o.width,o.height,m,g,o.data):n.texImage2D(34069+e,t,_,o.width,o.height,0,m,g,o.data)}}}else{M=r.mipmaps,A&&E&&(M.length>0&&T++,n.texStorage2D(34067,T,_,h[0].width,h[0].height));for(let e=0;e<6;e++)if(o){A?n.texSubImage2D(34069+e,0,0,0,h[e].width,h[e].height,m,g,h[e].data):n.texImage2D(34069+e,0,_,h[e].width,h[e].height,0,m,g,h[e].data);for(let t=0;t<M.length;t++){const o=M[t].image[e].image;A?n.texSubImage2D(34069+e,t+1,0,0,o.width,o.height,m,g,o.data):n.texImage2D(34069+e,t+1,_,o.width,o.height,0,m,g,o.data)}}else{A?n.texSubImage2D(34069+e,0,0,0,m,g,h[e]):n.texImage2D(34069+e,0,_,m,g,h[e]);for(let t=0;t<M.length;t++){const o=M[t];A?n.texSubImage2D(34069+e,t+1,0,0,m,g,o.image[e]):n.texImage2D(34069+e,t+1,_,m,g,o.image[e])}}}y(r,f)&&b(34067),d.__version=u.version,r.onUpdate&&r.onUpdate(r)}t.__version=r.version}(a,t,r):n.bindTexture(34067,a.__webglTexture,33984+r)},this.rebindTextures=function(e,t,n){const r=o.get(e);void 0!==t&&O(r.__webglFramebuffer,e,e.texture,36064,3553),void 0!==n&&V(e)},this.setupRenderTarget=function(t){const l=t.texture,c=o.get(t),u=o.get(l);t.addEventListener("dispose",T),!0!==t.isWebGLMultipleRenderTargets&&(void 0===u.__webglTexture&&(u.__webglTexture=e.createTexture()),u.__version=l.version,a.memory.textures++),a.addTextureSpec(t);const d=!0===t.isWebGLCubeRenderTarget,h=!0===t.isWebGLMultipleRenderTargets,p=x(t)||s;if(d){c.__webglFramebuffer=[];for(let t=0;t<6;t++)c.__webglFramebuffer[t]=e.createFramebuffer()}else{if(c.__webglFramebuffer=e.createFramebuffer(),h)if(r.isWebGL2){const n=t.texture;for(let t=0,r=n.length;t<r;t++){const r=o.get(n[t]);void 0===r.__webglTexture&&(r.__webglTexture=e.createTexture(),a.memory.textures++)}}else console.warn("v3d.WebGLRenderer: WebGLMultipleRenderTargets can only be used with WebGL2.");if(s&&t.samples>0&&!1===G(t)){const o=h?l:[l];c.__webglMultisampledFramebuffer=e.createFramebuffer(),c.__webglColorRenderbuffer=[],n.bindFramebuffer(36160,c.__webglMultisampledFramebuffer);for(let n=0;n<o.length;n++){const r=o[n];c.__webglColorRenderbuffer[n]=e.createRenderbuffer(),e.bindRenderbuffer(36161,c.__webglColorRenderbuffer[n]);const a=i.convert(r.format,r.encoding),s=i.convert(r.type),l=C(r.internalFormat,a,s,r.encoding,!0===t.isXRRenderTarget),u=U(t);e.renderbufferStorageMultisample(36161,u,l,t.width,t.height),e.framebufferRenderbuffer(36160,36064+n,36161,c.__webglColorRenderbuffer[n])}e.bindRenderbuffer(36161,null),t.depthBuffer&&(c.__webglDepthRenderbuffer=e.createRenderbuffer(),F(c.__webglDepthRenderbuffer,t,!0)),n.bindFramebuffer(36160,null)}}if(d){n.bindTexture(34067,u.__webglTexture),P(34067,l,p);for(let e=0;e<6;e++)O(c.__webglFramebuffer[e],t,l,36064,34069+e);y(l,p)&&b(34067),n.unbindTexture()}else if(h){const e=t.texture;for(let r=0,i=e.length;r<i;r++){const i=e[r],a=o.get(i);n.bindTexture(3553,a.__webglTexture),P(3553,i,p),O(c.__webglFramebuffer,t,i,36064+r,3553),y(i,p)&&b(3553)}n.unbindTexture()}else{let e=3553;(t.isWebGL3DRenderTarget||t.isWebGLArrayRenderTarget)&&(s?e=t.isWebGL3DRenderTarget?32879:35866:console.error("v3d.WebGLTextures: v3d.Data3DTexture and v3d.DataArrayTexture only supported with WebGL2.")),n.bindTexture(e,u.__webglTexture),P(e,l,p),O(c.__webglFramebuffer,t,l,36064,e),y(l,p)&&b(e),n.unbindTexture()}t.depthBuffer&&V(t)},this.updateRenderTargetMipmap=function(e){const t=x(e)||s,r=!0===e.isWebGLMultipleRenderTargets?e.texture:[e.texture];for(let i=0,a=r.length;i<a;i++){const a=r[i];if(y(a,t)){const t=e.isWebGLCubeRenderTarget?34067:3553,r=o.get(a).__webglTexture;n.bindTexture(t,r),b(t),n.unbindTexture()}}},this.updateMultisampleRenderTarget=function(t){if(s&&t.samples>0&&!1===G(t)){const r=t.isWebGLMultipleRenderTargets?t.texture:[t.texture],i=t.width,a=t.height;let s=16384;const l=[],c=t.stencilBuffer?33306:36096,u=o.get(t),d=!0===t.isWebGLMultipleRenderTargets;if(d)for(let t=0;t<r.length;t++)n.bindFramebuffer(36160,u.__webglMultisampledFramebuffer),e.framebufferRenderbuffer(36160,36064+t,36161,null),n.bindFramebuffer(36160,u.__webglFramebuffer),e.framebufferTexture2D(36009,36064+t,3553,null,0);n.bindFramebuffer(36008,u.__webglMultisampledFramebuffer),n.bindFramebuffer(36009,u.__webglFramebuffer);for(let n=0;n<r.length;n++){l.push(36064+n),t.depthBuffer&&l.push(c);const h=void 0!==u.__ignoreDepthValues&&u.__ignoreDepthValues;if(!1===h&&(t.depthBuffer&&(s|=256),t.stencilBuffer&&(s|=1024)),d&&e.framebufferRenderbuffer(36008,36064,36161,u.__webglColorRenderbuffer[n]),!0===h&&(e.invalidateFramebuffer(36008,[c]),e.invalidateFramebuffer(36009,[c])),d){const t=o.get(r[n]).__webglTexture;e.framebufferTexture2D(36009,36064,3553,t,0)}e.blitFramebuffer(0,0,i,a,0,0,i,a,s,9728),p&&e.invalidateFramebuffer(36008,l)}if(n.bindFramebuffer(36008,null),n.bindFramebuffer(36009,null),d)for(let t=0;t<r.length;t++){n.bindFramebuffer(36160,u.__webglMultisampledFramebuffer),e.framebufferRenderbuffer(36160,36064+t,36161,u.__webglColorRenderbuffer[t]);const i=o.get(r[t]).__webglTexture;n.bindFramebuffer(36160,u.__webglFramebuffer),e.framebufferTexture2D(36009,36064+t,3553,i,0)}n.bindFramebuffer(36009,u.__webglMultisampledFramebuffer)}},this.setupDepthRenderbuffer=V,this.setupFrameBufferTexture=O,this.useMultisampledRTT=G}function WebGLUniformsGroups(e,t,n,o){let r={},i={},a=[];const s=n.isWebGL2?e.getParameter(35375):0;function l(e,t,n){const o=e.value;if(void 0===n[t]){if("number"==typeof o)n[t]=o;else{const e=Array.isArray(o)?o:[o],r=[];for(let t=0;t<e.length;t++)r.push(e[t].clone());n[t]=r}return!0}if("number"==typeof o){if(n[t]!==o)return n[t]=o,!0}else{const e=Array.isArray(n[t])?n[t]:[n[t]],r=Array.isArray(o)?o:[o];for(let t=0;t<e.length;t++){const n=e[t];if(!1===n.equals(r[t]))return n.copy(r[t]),!0}}return!1}function c(e){const t={boundary:0,storage:0};return"number"==typeof e?(t.boundary=4,t.storage=4):e.isVector2?(t.boundary=8,t.storage=8):e.isVector3||e.isColor?(t.boundary=16,t.storage=12):e.isVector4?(t.boundary=16,t.storage=16):e.isMatrix3?(t.boundary=48,t.storage=48):e.isMatrix4?(t.boundary=64,t.storage=64):e.isTexture?console.warn("v3d.WebGLRenderer: Texture samplers can not be part of an uniforms group."):console.warn("v3d.WebGLRenderer: Unsupported uniform value type.",e),t}function u(t){const n=t.target;n.removeEventListener("dispose",u);const o=a.indexOf(n.__bindingPointIndex);a.splice(o,1),e.deleteBuffer(r[n.id]),delete r[n.id],delete i[n.id]}return{bind:function(e,t){const n=t.program;o.uniformBlockBinding(e,n)},update:function(n,d){let h=r[n.id];void 0===h&&(!function(e){const t=e.uniforms;let n=0;const o=16;let r=0;for(let e=0,i=t.length;e<i;e++){const i=t[e],a={boundary:0,storage:0},s=Array.isArray(i.value)?i.value:[i.value];for(let e=0,t=s.length;e<t;e++){const t=c(s[e]);a.boundary+=t.boundary,a.storage+=t.storage}if(i.__data=new Float32Array(a.storage/Float32Array.BYTES_PER_ELEMENT),i.__offset=n,e>0){r=n%o;0!==r&&o-r-a.boundary<0&&(n+=o-r,i.__offset=n)}n+=a.storage}r=n%o,r>0&&(n+=o-r);e.__size=n,e.__cache={}}(n),h=function(t){const n=function(){for(let e=0;e<s;e++)if(-1===a.indexOf(e))return a.push(e),e;return console.error("v3d.WebGLRenderer: Maximum number of simultaneously usable uniforms groups reached."),0}();t.__bindingPointIndex=n;const o=e.createBuffer(),r=t.__size,i=t.usage;return e.bindBuffer(35345,o),e.bufferData(35345,r,i),e.bindBuffer(35345,null),e.bindBufferBase(35345,n,o),o}(n),r[n.id]=h,n.addEventListener("dispose",u));const p=d.program;o.updateUBOMapping(n,p);const f=t.render.frame;i[n.id]!==f&&(!function(t){const n=r[t.id],o=t.uniforms,i=t.__cache;e.bindBuffer(35345,n);for(let t=0,n=o.length;t<n;t++){const n=o[t];if(!0===l(n,t,i)){const t=n.__offset,o=Array.isArray(n.value)?n.value:[n.value];let r=0;for(let i=0;i<o.length;i++){const a=o[i],s=c(a);"number"==typeof a?(n.__data[0]=a,e.bufferSubData(35345,t+r,n.__data)):a.isMatrix3?(n.__data[0]=a.elements[0],n.__data[1]=a.elements[1],n.__data[2]=a.elements[2],n.__data[3]=a.elements[0],n.__data[4]=a.elements[3],n.__data[5]=a.elements[4],n.__data[6]=a.elements[5],n.__data[7]=a.elements[0],n.__data[8]=a.elements[6],n.__data[9]=a.elements[7],n.__data[10]=a.elements[8],n.__data[11]=a.elements[0]):(a.toArray(n.__data,r),r+=s.storage/Float32Array.BYTES_PER_ELEMENT)}e.bufferSubData(35345,t,n.__data)}}e.bindBuffer(35345,null)}(n),i[n.id]=f)},dispose:function(){for(const t in r)e.deleteBuffer(r[t]);a=[],r={},i={}}}}function WebGLUtils(e,t,n){const o=n.isWebGL2;return{convert:function(n,r=null){let i;if(1009===n)return 5121;if(1017===n)return 32819;if(1018===n)return 32820;if(1010===n)return 5120;if(1011===n)return 5122;if(1012===n)return 5123;if(1013===n)return 5124;if(1014===n)return 5125;if(1015===n)return 5126;if(1016===n)return o?5131:(i=t.get("OES_texture_half_float"),null!==i?i.HALF_FLOAT_OES:null);if(1021===n)return 6406;if(1023===n)return 6408;if(1024===n)return 6409;if(1025===n)return 6410;if(1026===n)return 6402;if(1027===n)return 34041;if(1035===n)return i=t.get("EXT_sRGB"),null!==i?i.SRGB_ALPHA_EXT:null;if(1028===n)return 6403;if(1029===n)return 36244;if(1030===n)return 33319;if(1031===n)return 33320;if(1033===n)return 36249;if(33776===n||33777===n||33778===n||33779===n)if(3001===r){if(i=t.get("WEBGL_compressed_texture_s3tc_srgb"),null===i)return null;if(33776===n)return i.COMPRESSED_SRGB_S3TC_DXT1_EXT;if(33777===n)return i.COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT;if(33778===n)return i.COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT;if(33779===n)return i.COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT}else{if(i=t.get("WEBGL_compressed_texture_s3tc"),null===i)return null;if(33776===n)return i.COMPRESSED_RGB_S3TC_DXT1_EXT;if(33777===n)return i.COMPRESSED_RGBA_S3TC_DXT1_EXT;if(33778===n)return i.COMPRESSED_RGBA_S3TC_DXT3_EXT;if(33779===n)return i.COMPRESSED_RGBA_S3TC_DXT5_EXT}if(35840===n||35841===n||35842===n||35843===n){if(i=t.get("WEBGL_compressed_texture_pvrtc"),null===i)return null;if(35840===n)return i.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;if(35841===n)return i.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;if(35842===n)return i.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;if(35843===n)return i.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG}if(36196===n)return i=t.get("WEBGL_compressed_texture_etc1"),null!==i?i.COMPRESSED_RGB_ETC1_WEBGL:null;if(37492===n||37496===n){if(i=t.get("WEBGL_compressed_texture_etc"),null===i)return null;if(37492===n)return 3001===r?i.COMPRESSED_SRGB8_ETC2:i.COMPRESSED_RGB8_ETC2;if(37496===n)return 3001===r?i.COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:i.COMPRESSED_RGBA8_ETC2_EAC}if(37808===n||37809===n||37810===n||37811===n||37812===n||37813===n||37814===n||37815===n||37816===n||37817===n||37818===n||37819===n||37820===n||37821===n){if(i=t.get("WEBGL_compressed_texture_astc"),null===i)return null;if(37808===n)return 3001===r?i.COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR:i.COMPRESSED_RGBA_ASTC_4x4_KHR;if(37809===n)return 3001===r?i.COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR:i.COMPRESSED_RGBA_ASTC_5x4_KHR;if(37810===n)return 3001===r?i.COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR:i.COMPRESSED_RGBA_ASTC_5x5_KHR;if(37811===n)return 3001===r?i.COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR:i.COMPRESSED_RGBA_ASTC_6x5_KHR;if(37812===n)return 3001===r?i.COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR:i.COMPRESSED_RGBA_ASTC_6x6_KHR;if(37813===n)return 3001===r?i.COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR:i.COMPRESSED_RGBA_ASTC_8x5_KHR;if(37814===n)return 3001===r?i.COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR:i.COMPRESSED_RGBA_ASTC_8x6_KHR;if(37815===n)return 3001===r?i.COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR:i.COMPRESSED_RGBA_ASTC_8x8_KHR;if(37816===n)return 3001===r?i.COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR:i.COMPRESSED_RGBA_ASTC_10x5_KHR;if(37817===n)return 3001===r?i.COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR:i.COMPRESSED_RGBA_ASTC_10x6_KHR;if(37818===n)return 3001===r?i.COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR:i.COMPRESSED_RGBA_ASTC_10x8_KHR;if(37819===n)return 3001===r?i.COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR:i.COMPRESSED_RGBA_ASTC_10x10_KHR;if(37820===n)return 3001===r?i.COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR:i.COMPRESSED_RGBA_ASTC_12x10_KHR;if(37821===n)return 3001===r?i.COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR:i.COMPRESSED_RGBA_ASTC_12x12_KHR}if(36492===n){if(i=t.get("EXT_texture_compression_bptc"),null===i)return null;if(36492===n)return 3001===r?i.COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT:i.COMPRESSED_RGBA_BPTC_UNORM_EXT}return 1020===n?o?34042:(i=t.get("WEBGL_depth_texture"),null!==i?i.UNSIGNED_INT_24_8_WEBGL:null):void 0!==e[n]?e[n]:null}}}class ArrayCamera extends PerspectiveCamera{constructor(e=[]){super(),this.isArrayCamera=!0,this.cameras=e}}class Group extends Object3D{constructor(){super(),this.isGroup=!0,this.type="Group"}getWorldDirection(e){this.updateWorldMatrix(!0,!1);const t=this.matrixWorld.elements;return e.set(t[8],t[9],t[10]).normalize()}}const _moveEvent={type:"move"};class WebXRController{constructor(){this._targetRay=null,this._grip=null,this._hand=null}getHandSpace(){return null===this._hand&&(this._hand=new Group,this._hand.matrixAutoUpdate=!1,this._hand.visible=!1,this._hand.joints={},this._hand.inputState={pinching:!1}),this._hand}getTargetRaySpace(e){return null===this._targetRay&&(this._targetRay=new Group,this._targetRay.matrixAutoUpdate=!1,this._targetRay.visible=!1,this._targetRay.hasLinearVelocity=!1,this._targetRay.linearVelocity=new Vector3,this._targetRay.hasAngularVelocity=!1,this._targetRay.angularVelocity=new Vector3,this._targetRay.name="XR_CONTROLLER_"+String(e)),this._targetRay}getGripSpace(){return null===this._grip&&(this._grip=new Group,this._grip.matrixAutoUpdate=!1,this._grip.visible=!1,this._grip.hasLinearVelocity=!1,this._grip.linearVelocity=new Vector3,this._grip.hasAngularVelocity=!1,this._grip.angularVelocity=new Vector3),this._grip}dispatchEvent(e){return null!==this._targetRay&&this._targetRay.dispatchEvent(e),null!==this._grip&&this._grip.dispatchEvent(e),null!==this._hand&&this._hand.dispatchEvent(e),this}connect(e){if(e&&e.hand){const t=this._hand;if(t)for(const n of e.hand.values())this._getHandJoint(t,n)}return this.dispatchEvent({type:"connected",data:e}),this}disconnect(e){return this.dispatchEvent({type:"disconnected",data:e}),null!==this._targetRay&&(this._targetRay.visible=!1),null!==this._grip&&(this._grip.visible=!1),null!==this._hand&&(this._hand.visible=!1),this}update(e,t,n){let o=null,r=null,i=null;const a=this._targetRay,s=this._grip,l=this._hand;if(e&&"visible-blurred"!==t.session.visibilityState){if(l&&e.hand){i=!0;for(const o of e.hand.values()){const e=t.getJointPose(o,n),r=this._getHandJoint(l,o);null!==e&&(r.matrix.fromArray(e.transform.matrix),r.matrix.decompose(r.position,r.rotation,r.scale),r.jointRadius=e.radius),r.visible=null!==e}const o=l.joints["index-finger-tip"],r=l.joints["thumb-tip"],a=o.position.distanceTo(r.position),s=.02,c=.005;l.inputState.pinching&&a>s+c?(l.inputState.pinching=!1,this.dispatchEvent({type:"pinchend",handedness:e.handedness,target:this})):!l.inputState.pinching&&a<=s-c&&(l.inputState.pinching=!0,this.dispatchEvent({type:"pinchstart",handedness:e.handedness,target:this}))}else null!==s&&e.gripSpace&&(r=t.getPose(e.gripSpace,n),null!==r&&(s.matrix.fromArray(r.transform.matrix),s.matrix.decompose(s.position,s.rotation,s.scale),r.linearVelocity?(s.hasLinearVelocity=!0,s.linearVelocity.copy(r.linearVelocity)):s.hasLinearVelocity=!1,r.angularVelocity?(s.hasAngularVelocity=!0,s.angularVelocity.copy(r.angularVelocity)):s.hasAngularVelocity=!1));null!==a&&(o=t.getPose(e.targetRaySpace,n),null===o&&null!==r&&(o=r),null!==o&&(a.matrix.fromArray(o.transform.matrix),a.matrix.decompose(a.position,a.rotation,a.scale),o.linearVelocity?(a.hasLinearVelocity=!0,a.linearVelocity.copy(o.linearVelocity)):a.hasLinearVelocity=!1,o.angularVelocity?(a.hasAngularVelocity=!0,a.angularVelocity.copy(o.angularVelocity)):a.hasAngularVelocity=!1,this.dispatchEvent(_moveEvent)))}return null!==a&&(a.visible=null!==o),null!==s&&(s.visible=null!==r),null!==l&&(l.visible=null!==i),this}_getHandJoint(e,t){if(void 0===e.joints[t.jointName]){const n=new Group;n.matrixAutoUpdate=!1,n.visible=!1,e.joints[t.jointName]=n,e.add(n)}return e.joints[t.jointName]}}class Raycaster{constructor(e,t,n=0,o=1/0){this.ray=new Ray(e,t),this.near=n,this.far=o,this.camera=null,this.layers=new Layers,this.params={Mesh:{omitGeometry:!1},Line:{threshold:.1},LOD:{},Points:{threshold:.1},Sprite:{},checkVisibility:!0},this.layers.enable(3),this.layers.enable(4),this.layers.enable(5),this.layers.enable(6),this.layers.enable(7)}set(e,t){this.ray.set(e,t)}setFromCamera(e,t){t.isPerspectiveCamera?(this.ray.origin.setFromMatrixPosition(t.matrixWorld),this.ray.direction.set(e.x,e.y,.5).unproject(t).sub(this.ray.origin).normalize(),this.camera=t):t.isOrthographicCamera?(this.ray.origin.set(e.x,e.y,(t.near+t.far)/(t.near-t.far)).unproject(t),this.ray.direction.set(0,0,-1).transformDirection(t.matrixWorld),this.camera=t):console.error("v3d.Raycaster: Unsupported camera type: "+t.type)}intersectObject(e,t=!0,n=[]){return intersectObject(e,this,n,t,this.params.checkVisibility),n.sort(ascSort),n}intersectObjects(e,t=!0,n=[]){for(let o=0,r=e.length;o<r;o++)intersectObject(e[o],this,n,t,this.params.checkVisibility);return n.sort(ascSort),n}}function ascSort(e,t){return e.distance-t.distance}function intersectObject(e,t,n,o,r){if(!(r&&(!1===e.visible||e.isMesh&&e.isMaterialGeneratedMesh&&e.parent&&!e.parent.visible)||(e.layers.test(t.layers)&&e.raycast(t,n),!0!==o))){const o=e.children;for(let e=0,i=o.length;e<i;e++)intersectObject(o[e],t,n,!0,r)}}class WebXRManager extends EventDispatcher{constructor(e,t){super();const n=this;let o=null,r=1,i=null,a="local-floor",s=null,l=null,c=null,u=null,d=null,h=null;const p=t.getContextAttributes();let f=null,m=null;const g=[],_=[],A=new Set,v=new Map,x=new Vector2;let y=null;const b=new PerspectiveCamera;b.layers.enable(1),b.viewport=new Vector4;const C=new PerspectiveCamera;C.layers.enable(2),C.viewport=new Vector4;const S=[b,C],E=new ArrayCamera;E.layers.enable(1),E.layers.enable(2),E.matrixAutoUpdate=!1;let M=null,T=null,w=null,I=null,R=null,L=new Matrix4;const B=new Vector3,P=new Vector3,N=new Quaternion;function D(e){const t=_.indexOf(e.inputSource);if(-1===t)return;const n=g[t];void 0!==n&&n.dispatchEvent({type:e.type,data:e.inputSource})}function O(){o.removeEventListener("select",D),o.removeEventListener("selectstart",D),o.removeEventListener("selectend",D),o.removeEventListener("squeeze",D),o.removeEventListener("squeezestart",D),o.removeEventListener("squeezeend",D),o.removeEventListener("end",O),o.removeEventListener("inputsourceschange",F);for(let e=0;e<g.length;e++){const t=_[e];null!==t&&(_[e]=null,g[e].disconnect(t))}M=null,T=null,e.setRenderTarget(f),d=null,u=null,c=null,o=null,m=null,w=null,k.stop(),n.isPresenting=!1,e.setPixelRatio(y),e.setSize(x.width,x.height,!1),n.dispatchEvent({type:"sessionend"})}function F(e){for(let t=0;t<e.removed.length;t++){const n=e.removed[t],o=_.indexOf(n);o>=0&&(_[o]=null,g[o].disconnect(n))}for(let t=0;t<e.added.length;t++){const n=e.added[t];let o=_.indexOf(n);if(-1===o){for(let e=0;e<g.length;e++){if(e>=_.length){_.push(n),o=e;break}if(null===_[e]){_[e]=n,o=e;break}}if(-1===o)break}const r=g[o];r&&r.connect(n)}}this.cameraAutoUpdate=!0,this.enabled=!1,this.isPresenting=!1,this.getController=function(e){let t=g[e];return void 0===t&&(t=new WebXRController,g[e]=t),t.getTargetRaySpace(e)},this.getControllerGrip=function(e){let t=g[e];return void 0===t&&(t=new WebXRController,g[e]=t),t.getGripSpace()},this.getHand=function(e){let t=g[e];return void 0===t&&(t=new WebXRController,g[e]=t),t.getHandSpace()},this.setFramebufferScaleFactor=function(e){r=e,!0===n.isPresenting&&console.warn("v3d.WebXRManager: Cannot change framebuffer scale while presenting.")},this.setReferenceSpaceType=function(e){a=e,!0===n.isPresenting&&console.warn("v3d.WebXRManager: Cannot change reference space type while presenting.")},this.getReferenceSpace=function(){return s||i},this.setReferenceSpace=function(e){s=e},this.getBaseLayer=function(){return null!==u?u:d},this.getBinding=function(){return c},this.getFrame=function(){return h},this.getSession=function(){return o},this.setSession=async function(l){if(o=l,null!==o){if(f=e.getRenderTarget(),o.addEventListener("select",D),o.addEventListener("selectstart",D),o.addEventListener("selectend",D),o.addEventListener("squeeze",D),o.addEventListener("squeezestart",D),o.addEventListener("squeezeend",D),o.addEventListener("end",O),o.addEventListener("inputsourceschange",F),!0!==p.xrCompatible&&await t.makeXRCompatible(),y=e.getPixelRatio(),e.getSize(x),void 0===o.renderState.layers||!1===e.capabilities.isWebGL2){const n={antialias:void 0!==o.renderState.layers||p.antialias,alpha:p.alpha,depth:p.depth,stencil:p.stencil,framebufferScaleFactor:r};d=new XRWebGLLayer(o,t,n),o.updateRenderState({baseLayer:d}),e.setPixelRatio(1),e.setSize(d.framebufferWidth,d.framebufferHeight,!1),m=new WebGLRenderTarget(d.framebufferWidth,d.framebufferHeight,{format:1023,type:1009,encoding:e.outputEncoding,stencilBuffer:p.stencil})}else{let n=null,i=null,a=null;p.depth&&(a=p.stencil?35056:33190,n=p.stencil?1027:1026,i=p.stencil?1020:1014);const s={colorFormat:32856,depthFormat:a,scaleFactor:r};c=new XRWebGLBinding(o,t),u=c.createProjectionLayer(s),o.updateRenderState({layers:[u]}),e.setPixelRatio(1),e.setSize(u.textureWidth,u.textureHeight,!1),m=new WebGLRenderTarget(u.textureWidth,u.textureHeight,{format:1023,type:1009,depthTexture:new DepthTexture(u.textureWidth,u.textureHeight,i,void 0,void 0,void 0,void 0,void 0,void 0,n),stencilBuffer:p.stencil,encoding:e.outputEncoding,samples:p.antialias?4:0});e.properties.get(m).__ignoreDepthValues=u.ignoreDepthValues}m.isXRRenderTarget=!0,this.setFoveation(1),s=null,i=await o.requestReferenceSpace(a),k.setContext(o),k.start(),n.isPresenting=!0,n.dispatchEvent({type:"sessionstart"})}};const V=new Vector3,U=new Vector3;function G(e,t){if(null===t)e.matrixWorld.copy(e.matrix),L.identity(),s=null;else{e.matrixWorld.copy(e.matrix),L.copy(t.matrixWorld).invert().decompose(B,N,P);var n=new XRRigidTransform({x:B.x,y:B.y,z:B.z},{x:N.x,y:N.y,z:N.z,w:N.w});s=i.getOffsetReferenceSpace(n)}e.matrixWorldInverse.copy(e.matrixWorld).invert()}this.updateCamera=function(e){if(null===o)return;E.near=C.near=b.near=e.near,E.far=C.far=b.far=e.far,M===E.near&&T===E.far||(o.updateRenderState({depthNear:E.near,depthFar:E.far}),M=E.near,T=E.far);const t=e.parent,n=E.cameras;G(E,t);for(let e=0;e<n.length;e++)G(n[e],t);E.matrixWorld.decompose(E.position,E.quaternion,E.scale),e.matrixWorld.copy(E.matrixWorld),null===t?e.matrix.copy(e.matrixWorld):(e.matrix.copy(t.matrixWorld).invert(),e.matrix.multiply(e.matrixWorld)),e.matrix.decompose(e.position,e.quaternion,e.scale);const r=e.children;for(let e=0,t=r.length;e<t;e++)r[e].updateWorldMatrix(!1,!0);2===n.length?function(e,t,n){V.setFromMatrixPosition(t.matrixWorld),U.setFromMatrixPosition(n.matrixWorld);const o=V.distanceTo(U),r=t.projectionMatrix.elements,i=n.projectionMatrix.elements,a=r[14]/(r[10]-1),s=r[14]/(r[10]+1),l=(r[9]+1)/r[5],c=(r[9]-1)/r[5],u=(r[8]-1)/r[0],d=(i[8]+1)/i[0],h=a*u,p=a*d,f=o/(-u+d),m=f*-u;t.matrixWorld.decompose(e.position,e.quaternion,e.scale),e.translateX(m),e.translateZ(f),e.matrixWorld.compose(e.position,e.quaternion,e.scale),e.matrixWorldInverse.copy(e.matrixWorld).invert();const g=a+f,_=s+f,A=h-m,v=p+(o-m),x=l*s/_*g,y=c*s/_*g;e.projectionMatrix.makePerspective(A,v,x,y,g,_)}(E,b,C):E.projectionMatrix.copy(b.projectionMatrix);const i=E.projectionMatrix.elements;E.fov=radToDeg(2*Math.atan(1/i[5])),E.aspect=i[5]/i[0],E.projectionMatrixInverse.copy(E.projectionMatrix).invert()},this.getCamera=function(){return E},this.getFoveation=function(){return null!==u?u.fixedFoveation:null!==d?d.fixedFoveation:void 0},this.setFoveation=function(e){null!==u&&(u.fixedFoveation=e),null!==d&&void 0!==d.fixedFoveation&&(d.fixedFoveation=e)},this.getPlanes=function(){return A};let z=null;const k=new WebGLAnimation;function W(e){if(w){const t=e.getHitTestResults(w);if(t.length){const e=t[0].getPose(n.getReferenceSpace()),o=(new Matrix4).fromArray(e.transform.matrix),r=new Vector3;r.setFromMatrixPosition(o);const i=new Vector3(0,1,0);i.applyNormalMatrix((new Matrix3).setFromMatrix4(o)),I(r,i)}else R()}}k.setAnimationLoop(function(t,o){if(l=o.getViewerPose(s||i),h=o,null!==l){const t=l.views;null!==d&&(e.setRenderTargetFramebuffer(m,d.framebuffer),e.setRenderTarget(m));let n=!1;t.length!==E.cameras.length&&(E.cameras.length=0,n=!0);for(let o=0;o<t.length;o++){const r=t[o];let i=null;if(null!==d)i=d.getViewport(r);else{const t=c.getViewSubImage(u,r);i=t.viewport,0===o&&(e.setRenderTargetTextures(m,t.colorTexture,u.ignoreDepthValues?void 0:t.depthStencilTexture),e.setRenderTarget(m))}let a=S[o];void 0===a&&(a=new PerspectiveCamera,a.layers.enable(o),a.viewport=new Vector4,S[o]=a),a.matrix.fromArray(r.transform.matrix),a.projectionMatrix.fromArray(r.projectionMatrix),a.viewport.set(i.x,i.y,i.width,i.height),0===o&&E.matrix.copy(a.matrix),!0===n&&E.cameras.push(a)}}for(let e=0;e<g.length;e++){const t=_[e],n=g[e];null!==t&&void 0!==n&&n.update(t,o,s||i),W(o)}if(z&&z(t,o),o.detectedPlanes){n.dispatchEvent({type:"planesdetected",data:o.detectedPlanes});let e=null;for(const t of A)o.detectedPlanes.has(t)||(null===e&&(e=[]),e.push(t));if(null!==e)for(const t of e)A.delete(t),v.delete(t),n.dispatchEvent({type:"planeremoved",data:t});for(const e of o.detectedPlanes)if(A.has(e)){const t=v.get(e);e.lastChangedTime>t&&(v.set(e,e.lastChangedTime),n.dispatchEvent({type:"planechanged",data:e}))}else A.add(e),v.set(e,o.lastChangedTime),n.dispatchEvent({type:"planeadded",data:e})}h=null}),this.setAnimationLoop=function(e){z=e},this.dispose=function(){},this.arHitTest=function(e,t,n,r){if(!o||!XRSession.prototype.requestHitTestSource)return;I=n||function(){},R=r||function(){},this.raycaster=this.raycaster||new Raycaster,this.raycaster.setFromCamera({x:e,y:t},S[0]);const i=this.raycaster.ray;new XRRay(i.origin,i.direction),o.requestReferenceSpace("viewer").then(function(e){const t={space:e};o.requestHitTestSource(t).then(function(e){w=e})})}}}const PRINT_VERGE3D_LINE=!0,ASYNC_COMPILE_THRESHOLD=16,PARALLEL_COMPILE_CHECK_INTERVAL=16;function createCanvasElement(){const e=createElementNS("canvas");return e.style.display="block",e}function WebGLRenderer(e={}){this.isWebGLRenderer=!0;const t=void 0!==e.canvas?e.canvas:createCanvasElement(),n=void 0!==e.context?e.context:null,o=void 0===e.depth||e.depth,r=void 0===e.stencil||e.stencil,i=void 0!==e.antialias&&e.antialias,a=void 0===e.premultipliedAlpha||e.premultipliedAlpha,s=void 0!==e.preserveDrawingBuffer&&e.preserveDrawingBuffer,l=void 0!==e.powerPreference?e.powerPreference:"default",c=void 0!==e.failIfMajorPerformanceCaveat&&e.failIfMajorPerformanceCaveat;let u;u=null!==n?n.getContextAttributes().alpha:void 0!==e.alpha&&e.alpha;const d=new Uint32Array(4),h=new Int32Array(4);let p=null,f=null;const m=[],g=[];this.domElement=t,this.debug={checkShaderErrors:!0,disableCompiledShaderCache:!1,random:Math.random()},this.autoClear=!0,this.autoClearColor=!0,this.autoClearDepth=!0,this.autoClearStencil=!0,this.sortObjects=!0,this.clippingPlanes=[],this.localClippingEnabled=!1,this.outputEncoding=3e3,this.unitsScaleFactor=1,this.toneMapping=0,this.toneMappingLook=0,this.toneMappingExposure=1,this.gtaoMap=null,this.gtaoMapEnabled=!1,this.compatSettings={gtaoDisableBkgFix:!1};const _=this;let A=!1,v=0,x=0,y=null,b=-1,C=null;const S=new Vector4,E=new Vector4;let M=null,T=t.width,w=t.height,I=1,R=null,L=null;const B=new Vector4(0,0,T,w),P=new Vector4(0,0,T,w);let N=!1;const D=new Frustum;let O=!1,F=!1;const V=new Matrix4,U=new Vector2,G=new Vector3,z=new Scene,k=new Matrix4,W=new Matrix4,Q=new Vector4,H=new Matrix4;new Box3;let X=!1;function Y(){return null===y?I:1}this.oitRenderer=new WebGLOITRenderer(new Vector2(T,w));let j,$,K,q,Z,J,ee,te,ne,oe,re,ie,ae,se,le,ce,ue,de,he,pe,fe,me,ge,_e,Ae=n;function ve(e,n){for(let o=0;o<e.length;o++){const r=e[o],i=t.getContext(r,n);if(null!==i)return i}return null}try{const e={alpha:!0,depth:o,stencil:r,antialias:i,premultipliedAlpha:a,preserveDrawingBuffer:s,powerPreference:l,xrCompatible:!Detector.checkSafari(),failIfMajorPerformanceCaveat:c};if("setAttribute"in t&&t.setAttribute("data-engine",`Verge3D ${REVISION}`),t.addEventListener("webglcontextlost",be,!1),t.addEventListener("webglcontextrestored",Ce,!1),t.addEventListener("webglcontextcreationerror",Se,!1),null===Ae){const t=["webgl2","webgl"];if(Ae=ve(t,e),null===Ae)throw ve(t)?new Error("Error creating WebGL context with your selected attributes."):new Error("Error creating WebGL context.");{const e="undefined"!=typeof WebGL2RenderingContext&&Ae instanceof WebGL2RenderingContext;console.log("Verge3D 4.12.0 pre1 "+getVerge3DVariantName()+" ("+(3483952072==hashString(V3DL)?"Trial":"License")+", "+(e?"WebGL 2.0":"WebGL 1.0")+")")}}}catch(e){throw console.error("v3d.WebGLRenderer: "+e.message),e}function xe(){j=new WebGLExtensions(Ae),$=new WebGLCapabilities(Ae,j,e),j.init($),me=new WebGLUtils(Ae,j,$),K=new WebGLState(Ae,j,$),q=new WebGLInfo,Z=new WebGLProperties,J=new WebGLTextures(Ae,j,K,Z,$,me,q),ee=new WebGLCubeMaps(_),te=new WebGLCubeUVMaps(_),ne=new WebGLAttributes(Ae,$),ge=new WebGLBindingStates(Ae,j,ne,$),oe=new WebGLGeometries(Ae,ne,q,ge),re=new WebGLObjects(Ae,oe,ne,q),he=new WebGLMorphtargets(Ae,$,J),ce=new WebGLClipping(Z),ie=new WebGLPrograms(_,ee,te,j,$,ge,ce),ae=new WebGLMaterials(_,Z),se=new WebGLRenderLists,le=new WebGLRenderStates(j,$),de=new WebGLBackground(_,ee,te,K,re,u,a),ue=new WebGLShadowMap(_,re,$),_e=new WebGLUniformsGroups(Ae,q,$,K),pe=new WebGLBufferRenderer(Ae,j,q,$),fe=new WebGLIndexedBufferRenderer(Ae,j,q,$),q.programs=ie.programs,_.capabilities=$,_.extensions=j,_.properties=Z,_.renderLists=se,_.shadowMap=ue,_.state=K,_.info=q}xe();const ye=new WebXRManager(_,Ae);function be(e){e.preventDefault(),console.log("v3d.WebGLRenderer: Context Lost."),A=!0}function Ce(){console.log("v3d.WebGLRenderer: Context Restored."),A=!1;const e=ue.enabled,t=ue.autoUpdate,n=ue.needsUpdate,o=ue.type;xe(),ue.enabled=e,ue.autoUpdate=t,ue.needsUpdate=n,ue.type=o}function Se(e){console.error("v3d.WebGLRenderer: A WebGL context could not be created. Reason:",e.statusMessage)}function Ee(e){const t=e.target;t.removeEventListener("dispose",Ee),function(e){(function(e){const t=Z.get(e).programs;void 0!==t&&t.forEach(function(e){ie.releaseProgram(e)})})(e),Z.remove(e)}(t)}this.xr=ye,this.getContext=function(){return Ae},this.getContextAttributes=function(){return Ae.getContextAttributes()},this.forceContextLoss=function(){const e=j.get("WEBGL_lose_context");e&&e.loseContext()},this.forceContextRestore=function(){const e=j.get("WEBGL_lose_context");e&&e.restoreContext()},this.getTextureUtils=function(){return J},this.getPixelRatio=function(){return I},this.setPixelRatio=function(e){void 0!==e&&(I=e,this.setSize(T,w,!1))},this.getSize=function(e){return e.set(T,w)},this.setSize=function(e,n,o){ye.isPresenting?console.warn("v3d.WebGLRenderer: Can't change size while VR device is presenting."):(T=e,w=n,t.width=Math.floor(e*I),t.height=Math.floor(n*I),!1!==o&&(t.style.width=e+"px",t.style.height=n+"px"),this.setViewport(0,0,e,n),this.oitRenderer&&(this.getDrawingBufferSize(U),this.oitRenderer.setSize(U.x,U.y)))},this.getDrawingBufferSize=function(e){return e.set(T*I,w*I).floor()},this.setDrawingBufferSize=function(e,n,o){T=e,w=n,I=o,t.width=Math.floor(e*o),t.height=Math.floor(n*o),this.setViewport(0,0,e,n)},this.getCurrentViewport=function(e){return e.copy(S)},this.getViewport=function(e){return e.copy(B)},this.setViewport=function(e,t,n,o){e.isVector4?B.set(e.x,e.y,e.z,e.w):B.set(e,t,n,o),K.viewport(S.copy(B).multiplyScalar(I).floor())},this.getScissor=function(e){return e.copy(P)},this.setScissor=function(e,t,n,o){e.isVector4?P.set(e.x,e.y,e.z,e.w):P.set(e,t,n,o),K.scissor(E.copy(P).multiplyScalar(I).floor())},this.getScissorTest=function(){return N},this.setScissorTest=function(e){K.setScissorTest(N=e)},this.setOpaqueSort=function(e){R=e},this.setTransparentSort=function(e){L=e},this.getClearColor=function(e){return e.copy(de.getClearColor())},this.setClearColor=function(){de.setClearColor.apply(de,arguments)},this.getClearAlpha=function(){return de.getClearAlpha()},this.setClearAlpha=function(){de.setClearAlpha.apply(de,arguments)},this.clear=function(e=!0,t=!0,n=!0){let o=0;if(e){let e=!1;if(null!==y){const t=y.texture.format;e=1033===t||1031===t||1029===t}if(e){const e=y.texture.type,t=1009===e||1014===e||1012===e||1020===e||1017===e||1018===e,n=de.getClearColor(),o=de.getClearAlpha(),r=n.r,i=n.g,a=n.b;t?(d[0]=r,d[1]=i,d[2]=a,d[3]=o,Ae.clearBufferuiv(6144,0,d)):(h[0]=r,h[1]=i,h[2]=a,h[3]=o,Ae.clearBufferiv(6144,0,h))}else o|=16384}t&&(o|=256),n&&(o|=1024),Ae.clear(o)},this.clearColor=function(){this.clear(!0,!1,!1)},this.clearDepth=function(){this.clear(!1,!0,!1)},this.clearStencil=function(){this.clear(!1,!1,!0)},this.dispose=function(){t.removeEventListener("webglcontextlost",be,!1),t.removeEventListener("webglcontextrestored",Ce,!1),t.removeEventListener("webglcontextcreationerror",Se,!1),this.disposeGTAO(),this.disposeOIT(),this.disposeInternalCaches(),ye.dispose(),ye.removeEventListener("sessionstart",Te),ye.removeEventListener("sessionend",we),Ie.stop()},this.canUseGTAO=function(){return this.gtaoMap&&this.gtaoMapEnabled},this.disposeGTAO=function(){this.gtaoMap?.dispose(),this.gtaoMap=null},this.disposeOIT=function(){this.oitRenderer&&this.oitRenderer.dispose(),this.useOIT=!1},this.disposeInternalCaches=function(){se.dispose(),le.dispose(),Z.dispose(),ee.dispose(),te.dispose(),re.dispose(),ge.dispose(),_e.dispose(),de.dispose(),ne.dispose()},this.renderBufferDirect=function(e,t,n,o,r,i){null===t&&(t=z);const a=r.isMesh&&r.matrixWorld.determinant()<0,s=function(e,t,n,o,r){!0!==t.isScene&&(t=z);J.resetTextureUnits();const i=t.fog,a=o.isMeshNodeMaterial||o.isMeshStandardMaterial?t.environment:null,s=null===y?_.outputEncoding:!0===y.isXRRenderTarget?y.texture.encoding:3e3;if(o.envMapAutoAssign&&(o.isMeshNodeMaterial||o.isMeshStandardMaterial)){const e=f.state.envMapProbeArray.find(e=>{if(null===e.influenceGroup)return e.intersectsMesh(r);return r.groupNames.includes(e.influenceGroup)^e.influenceGroupInv})||t.worldEnvMapProbe;if(e){o.envMap=e.renderTarget?.texture||null;const t=e.parallaxDistance;o.envMapParallaxMatrix.copy(e.matrixWorldInverse).premultiply(H.makeScale(1/t,1/t,1/t)),o.envMapParallaxMatrixInv.copy(e.matrixWorld).multiply(H.makeScale(t,t,t)),o.envMapParallaxType=e.parallaxType}}const l=(o.isMeshNodeMaterial||o.isMeshStandardMaterial?te:ee).get(o.envMap||a),c=!0===o.vertexColors&&!!n.attributes.color&&4===n.attributes.color.itemSize,u=!!o.normalMap&&!!n.attributes.tangent,d=!!n.morphAttributes.position,h=!!n.morphAttributes.normal,p=o.toneMapped?_.toneMapping:0,m=n.morphAttributes.position||n.morphAttributes.normal,g=void 0!==m?m.length:0,A=1===o.side,v=Z.get(o),x=f.state.lights;if(!0===O&&(!0===F||e!==C)){const t=e===C&&o.id===b;ce.setState(o,e,t)}const E=Fe(r,o,f),M=_.canUseGTAO()&&o.isMeshNodeMaterial&&o.canUseGTAO();let R=!1,L=!1;o.version===v.__version?v.needsLights&&v.lightsStateVersion!==x.state.version||v.outputEncoding!==s||r.isInstancedMesh&&!1===v.instancing?R=!0:r.isInstancedMesh||!0!==v.instancing?r.isSkinnedMesh&&!1===v.skinning?R=!0:r.isSkinnedMesh||!0!==v.skinning?v.envMap!==l?(R=!0,L=!0):!0===o.fog&&v.fog!==i?R=!0:void 0===v.numClippingPlanes||v.numClippingPlanes===ce.numPlanes&&v.numIntersection===ce.numIntersection?(v.vertexAlphas!==c||v.vertexTangents!==u||v.morphTargets!==d||v.morphNormals!==h||v.toneMapping!==p||!0===$.isWebGL2&&v.morphTargetsCount!==g||v.planeReflProbe!==E||o.isMeshNormalMaterial&&v.flipSided!==A||v.useGTAO!==M)&&(R=!0):R=!0:R=!0:R=!0:R=!0;let B=v.currentProgram;!0===R&&(B=Ne(o,t,r,f));let P=!1,N=!1,D=!1;const V=B.getUniforms(),X=v.uniforms;K.useProgram(B.program)&&(P=!0,N=!0,D=!0);o.id!==b&&(b=o.id,N=!0);L&&(N=!0);if(P||C!==e){if(V.setValue(Ae,"projectionMatrix",e.projectionMatrix),$.logarithmicDepthBuffer&&V.setValue(Ae,"logDepthBufFC",2/(Math.log(e.far+1)/Math.LN2)),C!==e&&(C=e,N=!0,D=!0),o.isMeshNodeMaterial||o.isShaderMaterial||o.isMeshStandardMaterial||o.envMap){const t=V.map.cameraPosition;void 0!==t&&t.setValue(Ae,G.setFromMatrixPosition(e.matrixWorld))}(o.isMeshNodeMaterial||o.isMeshLambertMaterial||o.isMeshBasicMaterial||o.isMeshStandardMaterial||o.isShaderMaterial)&&V.setValue(Ae,"isOrthographic",!0===e.isOrthographicCamera),(o.isMeshNodeMaterial||o.isMeshLambertMaterial||o.isMeshBasicMaterial||o.isMeshStandardMaterial||o.isShaderMaterial||o.isShadowMaterial||r.isSkinnedMesh)&&V.setValue(Ae,"viewMatrix",e.matrixWorldInverse),(o.isMeshNodeMaterial||o.isMeshLambertMaterial||o.isMeshStandardMaterial||o.isShadowMaterial)&&V.setValue(Ae,"invViewMatrix",e.matrixWorld)}if(r.isSkinnedMesh){V.setOptional(Ae,r,"bindMatrix"),V.setOptional(Ae,r,"bindMatrixInverse");const e=r.skeleton;e&&($.floatVertexTextures?(null===e.boneTexture&&e.computeBoneTexture(),V.setValue(Ae,"boneTexture",e.boneTexture,J),V.setValue(Ae,"boneTextureSize",e.boneTextureSize)):console.warn("v3d.WebGLRenderer: SkinnedMesh can only be used with WebGL 2. With WebGL 1 OES_texture_float and vertex textures support is required."))}const Y=n.morphAttributes;void 0===Y.position&&void 0===Y.normal||he.update(r,n,o,B);(N||v.receiveShadow!==r.receiveShadow)&&(v.receiveShadow=r.receiveShadow,V.setValue(Ae,"receiveShadow",r.receiveShadow));if(N){if(V.setValue(Ae,"toneMappingExposure",_.toneMappingExposure),6==_.toneMapping?(V.setValue(Ae,"toneMappingBrightness",_.toneMappingBrightness),V.setValue(Ae,"toneMappingContrast",_.toneMappingContrast),V.setValue(Ae,"toneMappingMidTones",_.toneMappingMidTones),V.setValue(Ae,"toneMappingPhysicalScale",_.toneMappingPhysicalScale),V.setValue(Ae,"toneMappingChromaticAdaptation",_.toneMappingChromaticAdaptation),V.setValue(Ae,"toneMappingWhiteColor",_.toneMappingWhiteColor),V.setValue(Ae,"toneMappingColorDifferentiation",_.toneMappingColorDifferentiation),V.setValue(Ae,"toneMappingExteriorDaylight",_.toneMappingExteriorDaylight)):7==_.toneMapping&&(V.setValue(Ae,"toneMappingResolution",U.set(T,w)),V.setValue(Ae,"toneMappingWhiteBalance",_.toneMappingWhiteBalance),V.setValue(Ae,"toneMappingHighlights",_.toneMappingHighlights),V.setValue(Ae,"toneMappingMidTones",_.toneMappingMidTones),V.setValue(Ae,"toneMappingShadows",_.toneMappingShadows),V.setValue(Ae,"toneMappingSaturation",_.toneMappingSaturation),V.setValue(Ae,"toneMappingPhysicalScale",_.toneMappingPhysicalScale),V.setValue(Ae,"toneMappingAperture",_.toneMappingAperture),V.setValue(Ae,"toneMappingShutter",_.toneMappingShutter),V.setValue(Ae,"toneMappingISO",_.toneMappingISO),V.setValue(Ae,"toneMappingVignetting",_.toneMappingVignetting)),v.needsLights&&(q=D,(j=X).ambientLightColor.needsUpdate=q,j.lightProbe.needsUpdate=q,j.directionalLights.needsUpdate=q,j.directionalLightShadowsCSM.needsUpdate=q,j.directionalLightShadowsCSMCascade.needsUpdate=q,j.pointLights.needsUpdate=q,j.pointLightShadows.needsUpdate=q,j.spotLights.needsUpdate=q,j.spotLightShadows.needsUpdate=q,j.rectAreaLights.needsUpdate=q,j.rectAreaLightShadows.needsUpdate=q),i&&!0===o.fog&&ae.refreshFogUniforms(X,i),v.useGTAO){const e=y?.width??T,t=y?.height??w;V.setValue(Ae,"currResolution",U.set(e,t)),ae.refreshGTAOUniforms(X,_.gtaoMap)}if(ae.refreshMaterialUniforms(X,o,I,w),E&&ae.refreshPlaneReflProbeUniforms(X,E),o.isMeshNodeMaterial)for(const e in o.nodeTextures)V.setValue(Ae,e,o.nodeTextures[e],J);o.isMeshLineMaterial&&V.setValue(Ae,"resolution",U.set(T,w)),WebGLUniforms.upload(Ae,De(v),X,J)}var j,q;o.isShaderMaterial&&!0===o.uniformsNeedUpdate&&(WebGLUniforms.upload(Ae,De(v),X,J),o.uniformsNeedUpdate=!1);o.isSpriteMaterial&&V.setValue(Ae,"center",r.center);if(o.isMeshNodeMaterial){o.needsBoundingBox&&(null===n.boundingBox&&n.computeBoundingBox(),V.setValue(Ae,"boundingBoxMin",n.boundingBox.min),V.setValue(Ae,"boundingBoxMax",n.boundingBox.max)),V.setValue(Ae,"viewWidthHeight",U.set(S.z-S.x,S.w-S.y));const e=V.map.invModelMatrix;(e||o.nodeTexCoordObject.includes(null))&&(k.copy(r.matrixWorld).invert(),e&&e.setValue(Ae,k)),o.nodeTexCoordObject.forEach(function(e,t){(null===e?k:W.copy(e.matrixWorld).invert()).toArray(v.nodeTexCoordObjectMatrices,16*t)}),V.setValue(Ae,"nodeTexCoordObjectMatrices",v.nodeTexCoordObjectMatrices),V.setValue(Ae,"objectIndex",r.objectIndex);const t=r.objectColor;V.setValue(Ae,"objectColor",Q.set(t.r,t.g,t.b,r.objectAlpha)),V.setValue(Ae,"objectRandom",hashString(r.uuid)/Math.pow(2,32))}if(V.setValue(Ae,"modelViewMatrix",r.modelViewMatrix),V.setValue(Ae,"normalMatrix",r.normalMatrix),V.setValue(Ae,"modelMatrix",r.matrixWorld),o.isShaderMaterial||o.isRawShaderMaterial){const e=o.uniformsGroups;for(let t=0,n=e.length;t<n;t++)if($.isWebGL2){const n=e[t];_e.update(n,B),_e.bind(n,B)}else console.warn("v3d.WebGLRenderer: Uniform Buffer Objects can only be used with WebGL 2.")}return B}(e,t,n,o,r);K.setMaterial(o,a);let l=n.index,c=1;!0===o.wireframe&&(l=oe.getWireframeAttribute(n),c=2);const u=n.drawRange,d=n.attributes.position;let h=u.start*c,p=(u.start+u.count)*c;null!==i&&(h=Math.max(h,i.start*c),p=Math.min(p,(i.start+i.count)*c)),null!==l?(h=Math.max(h,0),p=Math.min(p,l.count)):null!=d&&(h=Math.max(h,0),p=Math.min(p,d.count));const m=p-h;if(m<0||m===1/0)return;let g;ge.setup(r,o,s,n,l);let A=pe;if(null!==l&&(g=ne.get(l),A=fe,A.setIndex(g)),r.isMesh)!0===o.wireframe?(K.setLineWidth(o.wireframeLinewidth*Y()),A.setMode(1)):A.setMode(4);else if(r.isLine){let e=o.linewidth;void 0===e&&(e=1),K.setLineWidth(e*Y()),r.isLineSegments?A.setMode(1):r.isLineLoop?A.setMode(2):A.setMode(3)}else r.isPoints?A.setMode(0):r.isSprite&&A.setMode(4);if(s.beginTimerQuery(Ae,$.isWebGL2),o.depthPrepass&&o.transparent){const e=K.buffers.depth.getTest(),t=K.buffers.color.getMask();if(K.buffers.depth.setTest(!0),K.buffers.color.setMask(0),r.isInstancedMesh)A.renderInstances(h,m,r.count);else if(n.isInstancedBufferGeometry){const e=void 0!==n._maxInstanceCount?n._maxInstanceCount:1/0,t=Math.min(n.instanceCount,e);A.renderInstances(h,m,t)}else A.render(h,m);K.buffers.depth.setTest(e),K.buffers.color.setMask(t)}if(r.isInstancedMesh)A.renderInstances(h,m,r.count);else if(n.isInstancedBufferGeometry){const e=void 0!==n._maxInstanceCount?n._maxInstanceCount:1/0,t=Math.min(n.instanceCount,e);A.renderInstances(h,m,t)}else A.render(h,m);s.endTimerQuery(Ae,$.isWebGL2)},this._compilePrepareRenderState=function(e,t,n){F=this.localClippingEnabled,O=ce.init(this.clippingPlanes,F,t),n.init(),e.traverse(e=>{e.isLight?(n.pushLight(e),e.castShadow&&n.pushShadow(e)):e.isCubeReflectionProbe?n.pushEnvMapProbe(e):e.isPlaneReflectionProbe&&(n.pushPlaneReflProbe(e),e.calcLocalBounding())}),n.setupLights(),n.sortEnvMapProbes();let o=null;return e.worldEnvMapProbe&&null!==e.worldEnvMapProbe.renderTarget&&(o=e.worldEnvMapProbe.renderTarget.texture),e.traverse(e=>{if(e.material){(Array.isArray(e.material)?e.material:[e.material]).forEach(t=>{(t.isMeshNodeMaterial||t.isMeshStandardMaterial)&&(e.material.envMap=o,e.material.needsUpdate=!0)})}}),n},this.compile=function(e,t){this.gtaoMapEnabled=!0;const n=le.get(e,g.length);this._compilePrepareRenderState(e,t,n);const o={};e.traverse(function(t){const r=t.material;if(r)if(Array.isArray(r))for(let i=0;i<r.length;i++){const a=r[i];a.uuid in o==!1&&(Ne(a,e,t,n),o[a.uuid]=!0)}else r.uuid in o==!1&&(Ne(r,e,t,n),o[r.uuid]=!0)}),this.gtaoMapEnabled=!1},this.compileAsync=function(e,t,n){const o=new WebGLRenderState(j,$);this._compilePrepareRenderState(e,t,o);const r=[];if(e.traverse(function(t){if(t.material&&!t.hidpiCompositing){(Array.isArray(t.material)?t.material:[t.material]).forEach(function(n){r.push({scene:e,obj:t,mat:n})})}}),0===r.length)n(1);else{const e=j.get("KHR_parallel_shader_compile"),i=(null===e?1:2)*r.length;let a=0,s=0;const l={};if(arrayForEachPromise(r,function(r,c,u){_.gtaoMapEnabled=!0,!0===O&&ce.setState(r.mat,t,!1);const d=Ne(r.mat,r.scene,r.obj,o);if(_.gtaoMapEnabled=!1,e){const e=d.id;e in l||(l[e]={program:d,weight:0}),l[e].weight++}n&&(a++,n((a+s)/i))},16),e){const t=setInterval(function(){let o=0;for(let t in l){const n=l[t];(void 0===n.program.program||Ae.getProgramParameter(n.program.program,e.COMPLETION_STATUS_KHR))&&(o+=n.weight)}s=Math.max(s,o),n&&n((a+s)/i),s===r.length&&clearInterval(t)},16)}}};let Me=null;function Te(){Ie.stop()}function we(){Ie.start()}const Ie=new WebGLAnimation;function Re(e,t,n,o){e.isAnnotationControl&&e.update(t);let r=!1;if(e.visible&&(r=e.layers.test(t.layers),r))if(e.isGroup)n=e.renderOrder;else if(e.isLOD)!0===e.autoUpdate&&e.update(t);else if(e.isLight)f.pushLight(e),e.castShadow&&f.pushShadow(e);else if(e.isCubeReflectionProbe)f.pushEnvMapProbe(e);else if(e.isPlaneReflectionProbe)f.pushPlaneReflProbe(e);else if(e.isSprite){if(!e.frustumCulled||D.intersectsSprite(e)){o&&G.setFromMatrixPosition(e.matrixWorld).applyMatrix4(V);const t=re.update(e),r=e.material;p.push(e,t,r,n,G.z,null)}}else if((e.isMesh||e.isLine||e.isPoints)&&(e.isSkinnedMesh&&e.skeleton.frame!==q.render.frame&&(e.skeleton.update(),e.skeleton.frame=q.render.frame),!e.frustumCulled||D.intersectsObject(e))){o&&G.setFromMatrixPosition(e.matrixWorld).applyMatrix4(V);const t=re.update(e),r=e.material;if(Array.isArray(r)){const o=t.groups;for(let i=0,a=o.length;i<a;i++){const a=o[i],s=r[a.materialIndex];s&&s.visible&&p.push(e,t,s,n,G.z,a)}}else r.visible&&p.push(e,t,r,n,G.z,null)}if(e.disableChildRendering)return;const i=e.children;for(let e=0,a=i.length;e<a;e++){const a=i[e];!r&&a.isMesh&&a.isMaterialGeneratedMesh||Re(a,t,n,o)}}function Le(e,t,n,o){const r=e.opaque,i=e.transparent;f.setupLightsView(n),o&&K.viewport(S.copy(o)),r.length>0&&Be(r,t,n),i.length>0&&(X&&0!==_.oitRenderer.method?_.oitRenderer.render(_,Be,i,t,n):Be(i,t,n)),K.buffers.depth.setTest(!0),K.buffers.depth.setMask(!0),K.buffers.color.setMask(!0),K.setPolygonOffset(!1)}function Be(e,t,n){const o=!0===t.isScene?t.overrideMaterial:null;for(let r=0,i=e.length;r<i;r++){const i=e[r],a=i.object,s=i.geometry,l=null===o?i.material:o,c=i.group;a.layers.test(n.layers)&&Pe(a,t,n,s,l,c)}}function Pe(e,t,n,o,r,i){e.onBeforeRender(_,t,n,o,r,i),e.modelViewMatrix.multiplyMatrices(n.matrixWorldInverse,e.matrixWorld),e.normalMatrix.getNormalMatrix(e.modelViewMatrix),r.onBeforeRender(_,t,n,o,e,i),!0===r.transparent&&3===r.side?(r.side=1,r.needsUpdate=!0,_.renderBufferDirect(n,t,o,r,e,i),r.side=0,r.needsUpdate=!0,_.renderBufferDirect(n,t,o,r,e,i),r.side=3):_.renderBufferDirect(n,t,o,r,e,i),e.onAfterRender(_,t,n,o,r,i)}function Ne(e,t,n,o){!0!==t.isScene&&(t=z);const r=Z.get(e);r.__version=e.version;const i=o.state.lights,a=o.state.shadowsArray,s=function(e){return e.isMeshNodeMaterial||e.isMeshLambertMaterial||e.isMeshStandardMaterial||e.isShadowMaterial||e.isShaderMaterial&&!0===e.lights}(e),l=i.state.version,c=Fe(n,e,o);r.planeReflProbe=c;const u=ie.getParameters(e,s?i.state:null,a,t,n,c),d=ie.getProgramCacheKey(u);let h=r.programs;r.environment=e.isMeshNodeMaterial||e.isMeshStandardMaterial?t.environment:null,r.fog=t.fog,r.envMap=(e.isMeshNodeMaterial||e.isMeshStandardMaterial?te:ee).get(e.envMap||r.environment),r.useGTAO=_.canUseGTAO()&&e.isMeshNodeMaterial&&e.canUseGTAO(),void 0===h&&(e.addEventListener("dispose",Ee),h=new Map,r.programs=h);let p=h.get(d);if(void 0!==p){if(r.currentProgram===p&&r.lightsStateVersion===l)return Oe(e,u),p}else u.uniforms=ie.getUniforms(e),e.onBuild(n,u,_),e.onBeforeCompile(u,_),p=ie.acquireProgram(u,d),h.set(d,p),q.numShaderCompiles=ie.getNumShaderCompiles(),r.uniforms=u.uniforms;const f=r.uniforms;if((e.isShaderMaterial||e.isRawShaderMaterial)&&!0!==e.clipping||e.defines.WORLD_NODES||(f.clippingPlanes=ce.uniform),Oe(e,u),r.needsLights=s,r.lightsStateVersion=l,s&&(f.ambientLightColor.value=i.state.ambient,f.lightProbe.value=i.state.probe,f.directionalLights.value=i.state.directional,f.spotLights.value=i.state.spot,f.spotLightShadows.value=i.state.spotShadow,f.rectAreaLights.value=i.state.rectArea,f.ltc_1.value=i.state.rectAreaLTC1,f.ltc_2.value=i.state.rectAreaLTC2,f.pointLights.value=i.state.point,f.pointLightShadows.value=i.state.pointShadow,f.spotShadowMap.value=i.state.spotShadowMap,f.spotShadowMatrix.value=i.state.spotShadowMatrix,f.pointShadowMap.value=i.state.pointShadowMap,f.pointShadowMatrix.value=i.state.pointShadowMatrix,f.rectAreaLightShadows.value=i.state.rectAreaShadow,f.rectAreaShadowMap.value=i.state.rectAreaShadowMap,f.rectAreaShadowMatrix.value=i.state.rectAreaShadowMatrix,f.directionalLightShadowsCSM.value=i.state.directionalShadowCSM,f.directionalShadowCSMMap.value=i.state.directionalShadowCSMMap,f.directionalShadowCSMMatrix.value=i.state.directionalShadowCSMMatrix,f.directionalLightShadowsCSMCascade.value=i.state.directionalShadowCSMCascade),e.isMeshNodeMaterial){f.nodeRGB.value!==4*e.nodeRGB.length&&(f.nodeRGB.value=new Float32Array(4*e.nodeRGB.length)),f.nodeValue.value.length!==e.nodeValue.length&&(f.nodeValue.value=new Float32Array(e.nodeValue.length));for(const t in e.nodeInputs){const n=`nodeInputs${strTitle(t)}`;f[n].value.length!==e.nodeInputs[t]&&(f[n].value=e.nodeInputs[t])}r.nodeTexCoordObjectMatrices&&r.nodeTexCoordObjectMatrices.length===16*e.nodeTexCoordObject.length||(r.nodeTexCoordObjectMatrices=new Float32Array(16*e.nodeTexCoordObject.length))}else r.nodeTexCoordObjectMatrices=new Float32Array(0);return r.currentProgram=p,r.uniformsList=null,p}function De(e){if(null===e.uniformsList){const t=e.currentProgram.getUniforms();e.uniformsList=WebGLUniforms.seqWithValue(t.seq,e.uniforms)}return e.uniformsList}function Oe(e,t){const n=Z.get(e);n.outputEncoding=t.outputEncoding,n.instancing=t.instancing,n.skinning=t.skinning,n.morphTargets=t.morphTargets,n.morphNormals=t.morphNormals,n.morphTargetsCount=t.morphTargetsCount,n.numClippingPlanes=t.numClippingPlanes,n.numIntersection=t.numClipIntersection,n.vertexAlphas=t.vertexAlphas,n.vertexTangents=t.vertexTangents,n.toneMapping=t.toneMapping,n.flipSided=t.flipSided}function Fe(e,t,n){return(t.isMeshNodeMaterial||t.isMeshStandardMaterial)&&n.state.planeReflProbeArray.find(t=>t.intersectsMesh(e))||null}Ie.setAnimationLoop(function(e){Me&&Me(e)}),"undefined"!=typeof self&&Ie.setContext(self),this.setAnimationLoop=function(e){Me=e,ye.setAnimationLoop(e),null===e?Ie.stop():Ie.start()},ye.addEventListener("sessionstart",Te),ye.addEventListener("sessionend",we),this.render=function(e,t){if(void 0!==t&&!0!==t.isCamera)return void console.error("v3d.WebGLRenderer.render: camera is not an instance of v3d.Camera.");if(!0===A)return;!0===e.matrixWorldAutoUpdate&&e.updateMatrixWorld(),null===t.parent&&!0===t.matrixWorldAutoUpdate&&t.updateMatrixWorld(),!0===ye.enabled&&!0===ye.isPresenting&&(!0===ye.cameraAutoUpdate&&ye.updateCamera(t),t=ye.getCamera()),!0===e.isScene&&e.onBeforeRender(_,e,t,y),f=le.get(e,g.length),f.init(),g.push(f),V.multiplyMatrices(t.projectionMatrix,t.matrixWorldInverse),D.setFromProjectionMatrix(V),F=this.localClippingEnabled,O=ce.init(this.clippingPlanes,F,t),p=se.get(e,m.length),p.init(),m.push(p),Re(e,t,0,_.sortObjects),p.finish(),!0===_.sortObjects&&p.sort(R,L),!0===O&&ce.beginShadows();const n=f.state.shadowsArray;if(ue.render(n,e,t),!0===O&&ce.endShadows(),this.info.render.frame++,de.render(p,e),f.setupLights(),f.sortEnvMapProbes(),t.isArrayCamera){const n=t.cameras;for(let t=0,o=n.length;t<o;t++){const o=n[t];Le(p,e,o,o.viewport)}}else Le(p,e,t);null!==y&&(J.updateMultisampleRenderTarget(y),J.updateRenderTargetMipmap(y)),!0===e.isScene&&e.onAfterRender(_,e,t),ge.resetDefaultState(),b=-1,C=null,g.pop(),f=g.length>0?g[g.length-1]:null,m.pop(),p=m.length>0?m[m.length-1]:null},this.getActiveCubeFace=function(){return v},this.getActiveMipmapLevel=function(){return x},this.getRenderTarget=function(){return y},this.setRenderTargetTextures=function(e,t,n){Z.get(e.texture).__webglTexture=t,Z.get(e.depthTexture).__webglTexture=n;const o=Z.get(e);o.__hasExternalTextures=!0,o.__autoAllocateDepthBuffer=void 0===n,o.__autoAllocateDepthBuffer||!0===j.has("WEBGL_multisampled_render_to_texture")&&(console.warn("v3d.WebGLRenderer: Render-to-texture extension was disabled because an external texture was provided"),o.__useRenderToTexture=!1)},this.setRenderTargetFramebuffer=function(e,t){const n=Z.get(e);n.__webglFramebuffer=t,n.__useDefaultFramebuffer=void 0===t},this.setRenderTarget=function(e,t=0,n=0){y=e,v=t,x=n;let o=!0,r=null,i=!1,a=!1;if(e){const n=Z.get(e);void 0!==n.__useDefaultFramebuffer?(K.bindFramebuffer(36160,null),o=!1):void 0===n.__webglFramebuffer?J.setupRenderTarget(e):n.__hasExternalTextures&&J.rebindTextures(e,Z.get(e.texture).__webglTexture,Z.get(e.depthTexture).__webglTexture);const s=e.texture;(s.isData3DTexture||s.isDataArrayTexture||s.isCompressedArrayTexture)&&(a=!0);const l=Z.get(e).__webglFramebuffer;e.isWebGLCubeRenderTarget?(r=l[t],i=!0):r=$.isWebGL2&&e.samples>0&&!1===J.useMultisampledRTT(e)?Z.get(e).__webglMultisampledFramebuffer:l,S.copy(e.viewport),E.copy(e.scissor),M=e.scissorTest}else S.copy(B).multiplyScalar(I).floor(),E.copy(P).multiplyScalar(I).floor(),M=N;if(K.bindFramebuffer(36160,r)&&$.isWebGL2&&o&&K.drawBuffers(e,r),K.viewport(S),K.scissor(E),K.setScissorTest(M),i){const o=Z.get(e.texture);Ae.framebufferTexture2D(36160,36064,34069+t,o.__webglTexture,n)}else if(a){const o=Z.get(e.texture),r=t||0;Ae.framebufferTextureLayer(36160,36064,o.__webglTexture,n||0,r)}b=-1},this.readRenderTargetPixels=function(e,t,n,o,r,i,a){if(!e||!e.isWebGLRenderTarget)return void console.error("v3d.WebGLRenderer.readRenderTargetPixels: renderTarget is not v3d.WebGLRenderTarget.");let s=Z.get(e).__webglFramebuffer;if(e.isWebGLCubeRenderTarget&&void 0!==a&&(s=s[a]),s){K.bindFramebuffer(36160,s);try{const a=e.texture,s=a.format,l=a.type;if(1023!==s&&me.convert(s)!==Ae.getParameter(35739))return void console.error("v3d.WebGLRenderer.readRenderTargetPixels: renderTarget is not in RGBA or implementation defined format.");const c=1016===l&&(j.has("EXT_color_buffer_half_float")||$.isWebGL2&&j.has("EXT_color_buffer_float"));if(!(1009===l||me.convert(l)===Ae.getParameter(35738)||1015===l&&($.isWebGL2||j.has("OES_texture_float")||j.has("WEBGL_color_buffer_float"))||c))return void console.error("v3d.WebGLRenderer.readRenderTargetPixels: renderTarget is not in UnsignedByteType or implementation defined type.");t>=0&&t<=e.width-o&&n>=0&&n<=e.height-r&&Ae.readPixels(t,n,o,r,me.convert(s),me.convert(l),i)}finally{const e=null!==y?Z.get(y).__webglFramebuffer:null;K.bindFramebuffer(36160,e)}}},this.readRenderTargetPixelsAsync=async function(e,t,n,o,r,i,a){if(!e||!e.isWebGLRenderTarget)throw new Error("v3d.WebGLRenderer.readRenderTargetPixelsAsync: renderTarget is not v3d.WebGLRenderTarget.");let s=Z.get(e).__webglFramebuffer;if(e.isWebGLCubeRenderTarget&&void 0!==a&&(s=s[a]),s){if(t>=0&&t<=e.width-o&&n>=0&&n<=e.height-r){K.bindFramebuffer(36160,s);const a=e.texture,l=a.format,c=a.type;if(1023!==l&&me.convert(l)!==Ae.getParameter(35739))return void console.error("v3d.WebGLRenderer.readRenderTargetPixelsAsync: renderTarget is not in RGBA or implementation defined format.");const u=1016===c&&(j.has("EXT_color_buffer_half_float")||$.isWebGL2&&j.has("EXT_color_buffer_float"));if(!(1009===c||me.convert(c)===Ae.getParameter(35738)||1015===c&&($.isWebGL2||j.has("OES_texture_float")||j.has("WEBGL_color_buffer_float"))||u))return void console.error("v3d.WebGLRenderer.readRenderTargetPixelsAsync: renderTarget is not in UnsignedByteType or implementation defined type.");const d=Ae.createBuffer();Ae.bindBuffer(35051,d),Ae.bufferData(35051,i.byteLength,35041),Ae.readPixels(t,n,o,r,me.convert(l),me.convert(c),0);const h=null!==y?Z.get(y).__webglFramebuffer:null;K.bindFramebuffer(36160,h);const p=Ae.fenceSync(37143,0);return Ae.flush(),await probeAsync(Ae,p,4),Ae.bindBuffer(35051,d),Ae.getBufferSubData(35051,0,i),Ae.deleteBuffer(d),Ae.deleteSync(p),i}throw new Error("v3d.WebGLRenderer.readRenderTargetPixelsAsync: requested read bounds are out of range.")}},this.copyFramebufferToTexture=function(e,t,n=0){const o=Math.pow(2,-n),r=Math.floor(t.image.width*o),i=Math.floor(t.image.height*o);J.setTexture2D(t,0),Ae.copyTexSubImage2D(3553,n,0,0,e.x,e.y,r,i),K.unbindTexture()},this.copyTextureToTexture=function(e,t,n,o=0){const r=t.image.width,i=t.image.height,a=me.convert(n.format),s=me.convert(n.type);J.setTexture2D(n,0),Ae.pixelStorei(37440,n.flipY),Ae.pixelStorei(37441,n.premultiplyAlpha),Ae.pixelStorei(3317,n.unpackAlignment),t.isDataTexture?Ae.texSubImage2D(3553,o,e.x,e.y,r,i,a,s,t.image.data):t.isCompressedTexture?Ae.compressedTexSubImage2D(3553,o,e.x,e.y,t.mipmaps[0].width,t.mipmaps[0].height,a,t.mipmaps[0].data):Ae.texSubImage2D(3553,o,e.x,e.y,a,s,t.image),0===o&&n.generateMipmaps&&Ae.generateMipmap(3553),K.unbindTexture()},this.copyTextureToTexture3D=function(e,t,n,o,r=0){if(!$.isWebGL2)return void console.warn("v3d.WebGLRenderer.copyTextureToTexture3D: can only be used with WebGL2.");const i=e.max.x-e.min.x+1,a=e.max.y-e.min.y+1,s=e.max.z-e.min.z+1,l=me.convert(o.format),c=me.convert(o.type);let u;if(o.isData3DTexture)J.setTexture3D(o,0),u=32879;else{if(!o.isDataArrayTexture)return void console.warn("v3d.WebGLRenderer.copyTextureToTexture3D: only supports v3d.DataTexture3D and v3d.DataTexture2DArray.");J.setTexture2DArray(o,0),u=35866}Ae.pixelStorei(37440,o.flipY),Ae.pixelStorei(37441,o.premultiplyAlpha),Ae.pixelStorei(3317,o.unpackAlignment);const d=Ae.getParameter(3314),h=Ae.getParameter(32878),p=Ae.getParameter(3316),f=Ae.getParameter(3315),m=Ae.getParameter(32877),g=n.isCompressedTexture?n.mipmaps[0]:n.image;Ae.pixelStorei(3314,g.width),Ae.pixelStorei(32878,g.height),Ae.pixelStorei(3316,e.min.x),Ae.pixelStorei(3315,e.min.y),Ae.pixelStorei(32877,e.min.z),n.isDataTexture||n.isData3DTexture?Ae.texSubImage3D(u,r,t.x,t.y,t.z,i,a,s,l,c,g.data):n.isCompressedArrayTexture?(console.warn("v3d.WebGLRenderer.copyTextureToTexture3D: untested support for compressed srcTexture."),Ae.compressedTexSubImage3D(u,r,t.x,t.y,t.z,i,a,s,l,g.data)):Ae.texSubImage3D(u,r,t.x,t.y,t.z,i,a,s,l,c,g),Ae.pixelStorei(3314,d),Ae.pixelStorei(32878,h),Ae.pixelStorei(3316,p),Ae.pixelStorei(3315,f),Ae.pixelStorei(32877,m),0===r&&o.generateMipmaps&&Ae.generateMipmap(u),K.unbindTexture()},this.initTexture=function(e){e.isCubeTexture?J.setTextureCube(e,0):e.isData3DTexture?J.setTexture3D(e,0):e.isDataArrayTexture||e.isCompressedArrayTexture?J.setTexture2DArray(e,0):J.setTexture2D(e,0),K.unbindTexture()},this.resetState=function(){v=0,x=0,y=null,K.reset(),ge.reset()},sendDevTools("observe",this),this.updateGeometry=function(e){return re.update(e)},this.setOIT=function(e,t){this.oitRenderer.setSize(T,w),this.oitRenderer.texType=null!==me.convert(1016)?1016:1009;let n=t||(!0===i?4:0);this.oitRenderer.isMethodCompatible(e,$)?this.oitRenderer.setMethod(e,n):console.log("v3d.WebGLRenderer: the OIT method is not compatible.")},this.getOIT=function(){return this.oitRenderer.method},Object.defineProperty(this,"useOIT",{get:function(){return X},set:function(e){this.setTransparentSort(e?function(){}:null),X=e}})}class FogExp2{constructor(e,t=25e-5){this.isFogExp2=!0,this.name="",this.color=new Color(e),this.density=t}clone(){return new FogExp2(this.color,this.density)}}class Fog{constructor(e,t=1,n=1e3){this.isFog=!0,this.name="",this.color=new Color(e),this.near=t,this.far=n}clone(){return new Fog(this.color,this.near,this.far)}}class SpriteMaterial extends Material{constructor(e){super(),this.isSpriteMaterial=!0,this.type="SpriteMaterial",this.color=new Color(16777215),this.map=null,this.alphaMap=null,this.rotation=0,this.sizeAttenuation=!0,this.transparent=!0,this.fog=!0,this.setValues(e)}copy(e){return super.copy(e),this.color.copy(e.color),this.map=e.map,this.alphaMap=e.alphaMap,this.rotation=e.rotation,this.sizeAttenuation=e.sizeAttenuation,this.fog=e.fog,this}}let _geometry;const _intersectPoint=new Vector3,_worldScale$1=new Vector3,_mvPosition=new Vector3,_alignedPosition=new Vector2,_rotatedPosition=new Vector2,_viewWorldMatrix=new Matrix4,_vA$1=new Vector3,_vB$1=new Vector3,_vC$1=new Vector3,_uvA$1=new Vector2,_uvB$1=new Vector2,_uvC$1=new Vector2;class Sprite extends Object3D{constructor(e){if(super(),this.isSprite=!0,this.type="Sprite",void 0===_geometry){_geometry=new BufferGeometry;const e=new Float32Array([-.5,-.5,0,.5,-.5,0,.5,.5,0,-.5,.5,0]),t=new Float32Array([0,0,1,0,1,1,0,1]);_geometry.setIndex([0,1,2,0,2,3]),_geometry.setAttribute("position",new BufferAttribute(e,3)),_geometry.setAttribute("uv",new BufferAttribute(t,2))}this.geometry=_geometry,this.material=void 0!==e?e:new SpriteMaterial,this.center=new Vector2(.5,.5)}raycast(e,t){if(null===e.camera)return void console.error('v3d.Sprite: "Raycaster.camera" needs to be set in order to raycast against sprites.');_worldScale$1.setFromMatrixScale(this.matrixWorld),_viewWorldMatrix.copy(e.camera.matrixWorld),this.modelViewMatrix.multiplyMatrices(e.camera.matrixWorldInverse,this.matrixWorld),_mvPosition.setFromMatrixPosition(this.modelViewMatrix),e.camera.isPerspectiveCamera&&!1===this.material.sizeAttenuation&&_worldScale$1.multiplyScalar(-_mvPosition.z);const n=this.material.rotation;let o,r;0!==n&&(r=Math.cos(n),o=Math.sin(n));const i=this.center;transformVertex(_vA$1.set(-.5,-.5,0),_mvPosition,i,_worldScale$1,o,r),transformVertex(_vB$1.set(.5,-.5,0),_mvPosition,i,_worldScale$1,o,r),transformVertex(_vC$1.set(.5,.5,0),_mvPosition,i,_worldScale$1,o,r),_uvA$1.set(0,0),_uvB$1.set(1,0),_uvC$1.set(1,1);let a=e.ray.intersectTriangle(_vA$1,_vB$1,_vC$1,!1,_intersectPoint);if(null===a&&(transformVertex(_vB$1.set(-.5,.5,0),_mvPosition,i,_worldScale$1,o,r),_uvB$1.set(0,1),a=e.ray.intersectTriangle(_vA$1,_vC$1,_vB$1,!1,_intersectPoint),null===a))return;const s=e.ray.origin.distanceTo(_intersectPoint);s<e.near||s>e.far||t.push({distance:s,point:_intersectPoint.clone(),uv:Triangle.getInterpolation(_intersectPoint,_vA$1,_vB$1,_vC$1,_uvA$1,_uvB$1,_uvC$1,new Vector2),face:null,object:this})}copy(e,t){return super.copy(e,t),void 0!==e.center&&this.center.copy(e.center),this.material=e.material,this}}function transformVertex(e,t,n,o,r,i){_alignedPosition.subVectors(e,n).addScalar(.5).multiply(o),void 0!==r?(_rotatedPosition.x=i*_alignedPosition.x-r*_alignedPosition.y,_rotatedPosition.y=r*_alignedPosition.x+i*_alignedPosition.y):_rotatedPosition.copy(_alignedPosition),e.copy(t),e.x+=_rotatedPosition.x,e.y+=_rotatedPosition.y,e.applyMatrix4(_viewWorldMatrix)}const _v1$3=new Vector3,_v2$2=new Vector3;class LOD extends Object3D{constructor(){super(),this._currentLevel=0,this.type="LOD",Object.defineProperties(this,{levels:{enumerable:!0,value:[]},isLOD:{value:!0}}),this.autoUpdate=!0}copy(e){super.copy(e,!1);const t=e.levels;for(let e=0,n=t.length;e<n;e++){const n=t[e];this.addLevel(n.object.clone(),n.distance,n.hysteresis)}return this.autoUpdate=e.autoUpdate,this}addLevel(e,t=0,n=0){t=Math.abs(t);const o=this.levels;let r;for(r=0;r<o.length&&!(t<o[r].distance);r++);return o.splice(r,0,{distance:t,hysteresis:n,object:e}),this.add(e),this}getCurrentLevel(){return this._currentLevel}getObjectForDistance(e){const t=this.levels;if(t.length>0){let n,o;for(n=1,o=t.length;n<o;n++){let o=t[n].distance;if(t[n].object.visible&&(o-=o*t[n].hysteresis),e<o)break}return t[n-1].object}return null}raycast(e,t){if(this.levels.length>0){_v1$3.setFromMatrixPosition(this.matrixWorld);const n=e.ray.origin.distanceTo(_v1$3);this.getObjectForDistance(n).raycast(e,t)}}update(e){const t=this.levels;if(t.length>1){_v1$3.setFromMatrixPosition(e.matrixWorld),_v2$2.setFromMatrixPosition(this.matrixWorld);const n=_v1$3.distanceTo(_v2$2)/e.zoom;let o,r;for(t[0].object.visible=!0,o=1,r=t.length;o<r;o++){let e=t[o].distance;if(t[o].object.visible&&(e-=e*t[o].hysteresis),!(n>=e))break;t[o-1].object.visible=!1,t[o].object.visible=!0}for(this._currentLevel=o-1;o<r;o++)t[o].object.visible=!1}}}const _basePosition=new Vector3,_skinIndex=new Vector4,_skinWeight=new Vector4,_vector$4=new Vector3,_matrix$2=new Matrix4;class SkinnedMesh extends Mesh{constructor(e,t){super(e,t),this.isSkinnedMesh=!0,this.type="SkinnedMesh",this.bindMode="attached",this.bindMatrix=new Matrix4,this.bindMatrixInverse=new Matrix4,this.normalizeSkinWeights()}copy(e,t){return super.copy(e,t),this.bindMode=e.bindMode,this.bindMatrix.copy(e.bindMatrix),this.bindMatrixInverse.copy(e.bindMatrixInverse),this.skeleton=e.skeleton,this}bind(e,t){this.skeleton=e,void 0===t&&(this.updateMatrixWorld(!0),this.skeleton.calculateInverses(),t=this.matrixWorld),this.bindMatrix.copy(t),this.bindMatrixInverse.copy(t).invert()}pose(){this.skeleton.pose()}normalizeSkinWeights(){const e=new Vector4,t=this.geometry.attributes.skinWeight;for(let n=0,o=t.count;n<o;n++){e.fromBufferAttribute(t,n);const o=1/e.manhattanLength();o!==1/0?e.multiplyScalar(o):e.set(1,0,0,0),t.setXYZW(n,e.x,e.y,e.z,e.w)}}updateMatrixWorld(e){super.updateMatrixWorld(e),"attached"===this.bindMode?this.bindMatrixInverse.copy(this.matrixWorld).invert():"detached"===this.bindMode?this.bindMatrixInverse.copy(this.bindMatrix).invert():console.warn("v3d.SkinnedMesh: Unrecognized bindMode: "+this.bindMode)}boneTransform(e,t){const n=this.skeleton,o=this.geometry;_skinIndex.fromBufferAttribute(o.attributes.skinIndex,e),_skinWeight.fromBufferAttribute(o.attributes.skinWeight,e),_basePosition.copy(t).applyMatrix4(this.bindMatrix),t.set(0,0,0);for(let e=0;e<4;e++){const o=_skinWeight.getComponent(e);if(0!==o){const r=_skinIndex.getComponent(e);_matrix$2.multiplyMatrices(n.bones[r].matrixWorld,n.boneInverses[r]),t.addScaledVector(_vector$4.copy(_basePosition).applyMatrix4(_matrix$2),o)}}return t.applyMatrix4(this.bindMatrixInverse)}}class Bone extends Object3D{constructor(){super(),this.isBone=!0,this.type="Bone"}}class DataTexture extends Texture{constructor(e=null,t=1,n=1,o,r,i,a,s,l=1003,c=1003,u,d){super(null,i,a,s,l,c,o,r,u,d),this.isDataTexture=!0,this.image={data:e,width:t,height:n},this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1}}const _offsetMatrix=new Matrix4,_identityMatrix=new Matrix4;class Skeleton{constructor(e=[],t=[]){this.uuid=generateUUID(),this.bones=e.slice(0),this.boneInverses=t,this.boneMatrices=null,this.boneTexture=null,this.boneTextureSize=0,this.frame=-1,this.init()}init(){const e=this.bones,t=this.boneInverses;if(this.boneMatrices=new Float32Array(16*e.length),0===t.length)this.calculateInverses();else if(e.length!==t.length){console.warn("v3d.Skeleton: Number of inverse bone matrices does not match amount of bones."),this.boneInverses=[];for(let e=0,t=this.bones.length;e<t;e++)this.boneInverses.push(new Matrix4)}}calculateInverses(){this.boneInverses.length=0;for(let e=0,t=this.bones.length;e<t;e++){const t=new Matrix4;this.bones[e]&&t.copy(this.bones[e].matrixWorld).invert(),this.boneInverses.push(t)}}pose(){for(let e=0,t=this.bones.length;e<t;e++){const t=this.bones[e];t&&t.matrixWorld.copy(this.boneInverses[e]).invert()}for(let e=0,t=this.bones.length;e<t;e++){const t=this.bones[e];t&&(t.parent&&t.parent.isBone?(t.matrix.copy(t.parent.matrixWorld).invert(),t.matrix.multiply(t.matrixWorld)):t.matrix.copy(t.matrixWorld),t.matrix.decompose(t.position,t.quaternion,t.scale))}}update(){const e=this.bones,t=this.boneInverses,n=this.boneMatrices,o=this.boneTexture;for(let o=0,r=e.length;o<r;o++){const r=e[o]?e[o].matrixWorld:_identityMatrix;_offsetMatrix.multiplyMatrices(r,t[o]),_offsetMatrix.toArray(n,16*o)}null!==o&&(o.needsUpdate=!0)}clone(){return new Skeleton(this.bones,this.boneInverses)}computeBoneTexture(){let e=Math.sqrt(4*this.bones.length);e=ceilPowerOfTwo(e),e=Math.max(e,4);const t=new Float32Array(e*e*4);t.set(this.boneMatrices);const n=new DataTexture(t,e,e,1023,1015);return n.name="Skeleton.bone",n.needsUpdate=!0,this.boneMatrices=t,this.boneTexture=n,this.boneTextureSize=e,this}getBoneByName(e){for(let t=0,n=this.bones.length;t<n;t++){const n=this.bones[t];if(n.name===e)return n}}dispose(){null!==this.boneTexture&&(this.boneTexture.dispose(),this.boneTexture=null)}}let InstancedBufferAttribute$1=class extends BufferAttribute{constructor(e,t,n,o=1){super(e,t,n),this.isInstancedBufferAttribute=!0,this.meshPerAttribute=o}copy(e){return super.copy(e),this.meshPerAttribute=e.meshPerAttribute,this}};const _instanceLocalMatrix=new Matrix4,_instanceWorldMatrix=new Matrix4,_instanceIntersects=[],_identity=new Matrix4,_mesh$1=new Mesh;class InstancedMesh extends Mesh{constructor(e,t,n){super(e,t),this.isInstancedMesh=!0,this.instanceMatrix=new InstancedBufferAttribute$1(new Float32Array(16*n),16),this.instanceColor=null,this.count=n,this.frustumCulled=!1;for(let e=0;e<n;e++)this.setMatrixAt(e,_identity)}copy(e,t){return super.copy(e,t),this.instanceMatrix.copy(e.instanceMatrix),null!==e.instanceColor&&(this.instanceColor=e.instanceColor.clone()),this.count=e.count,this}getColorAt(e,t){t.fromArray(this.instanceColor.array,3*e)}getMatrixAt(e,t){t.fromArray(this.instanceMatrix.array,16*e)}raycast(e,t){const n=this.matrixWorld,o=this.count;if(_mesh$1.geometry=this.geometry,_mesh$1.material=this.material,void 0!==_mesh$1.material)for(let r=0;r<o;r++){this.getMatrixAt(r,_instanceLocalMatrix),_instanceWorldMatrix.multiplyMatrices(n,_instanceLocalMatrix),_mesh$1.matrixWorld=_instanceWorldMatrix,_mesh$1.raycast(e,_instanceIntersects);for(let e=0,n=_instanceIntersects.length;e<n;e++){const n=_instanceIntersects[e];n.instanceId=r,n.object=this,t.push(n)}_instanceIntersects.length=0}}setColorAt(e,t){null===this.instanceColor&&(this.instanceColor=new InstancedBufferAttribute$1(new Float32Array(3*this.instanceMatrix.count),3)),t.toArray(this.instanceColor.array,3*e)}setMatrixAt(e,t){t.toArray(this.instanceMatrix.array,16*e)}updateMorphTargets(){}dispose(){this.dispatchEvent({type:"dispose"})}}class LineBasicMaterial extends Material{constructor(e){super(),this.isLineBasicMaterial=!0,this.type="LineBasicMaterial",this.color=new Color(16777215),this.linewidth=1,this.linecap="round",this.linejoin="round",this.fog=!0,this.setValues(e)}copy(e){return super.copy(e),this.color.copy(e.color),this.linewidth=e.linewidth,this.linecap=e.linecap,this.linejoin=e.linejoin,this.fog=e.fog,this}}const _start$1=new Vector3,_end$1=new Vector3,_inverseMatrix$1=new Matrix4,_ray$1=new Ray,_sphere$2=new Sphere;class Line extends Object3D{constructor(e=new BufferGeometry,t=new LineBasicMaterial){super(),this.isLine=!0,this.type="Line",this.geometry=e,this.material=t,this.updateMorphTargets()}copy(e,t){return super.copy(e,t),this.material=e.material,this.geometry=e.geometry,this}computeLineDistances(){const e=this.geometry;if(null===e.index){const t=e.attributes.position,n=[0];for(let e=1,o=t.count;e<o;e++)_start$1.fromBufferAttribute(t,e-1),_end$1.fromBufferAttribute(t,e),n[e]=n[e-1],n[e]+=_start$1.distanceTo(_end$1);e.setAttribute("lineDistance",new Float32BufferAttribute(n,1))}else console.warn("v3d.Line.computeLineDistances(): Computation only possible with non-indexed BufferGeometry.");return this}raycast(e,t){const n=this.geometry,o=this.matrixWorld,r=e.params.Line.threshold,i=n.drawRange;if(null===n.boundingSphere&&n.computeBoundingSphere(),_sphere$2.copy(n.boundingSphere),_sphere$2.applyMatrix4(o),_sphere$2.radius+=r,!1===e.ray.intersectsSphere(_sphere$2))return;_inverseMatrix$1.copy(o).invert(),_ray$1.copy(e.ray).applyMatrix4(_inverseMatrix$1);const a=r/((this.scale.x+this.scale.y+this.scale.z)/3),s=a*a,l=new Vector3,c=new Vector3,u=new Vector3,d=new Vector3,h=this.isLineSegments?2:1,p=n.index,f=n.attributes.position;if(null!==p){for(let n=Math.max(0,i.start),o=Math.min(p.count,i.start+i.count)-1;n<o;n+=h){const o=p.getX(n),r=p.getX(n+1);l.fromBufferAttribute(f,o),c.fromBufferAttribute(f,r);if(_ray$1.distanceSqToSegment(l,c,d,u)>s)continue;d.applyMatrix4(this.matrixWorld);const i=e.ray.origin.distanceTo(d);i<e.near||i>e.far||t.push({distance:i,point:u.clone().applyMatrix4(this.matrixWorld),index:n,face:null,faceIndex:null,object:this})}}else{for(let n=Math.max(0,i.start),o=Math.min(f.count,i.start+i.count)-1;n<o;n+=h){l.fromBufferAttribute(f,n),c.fromBufferAttribute(f,n+1);if(_ray$1.distanceSqToSegment(l,c,d,u)>s)continue;d.applyMatrix4(this.matrixWorld);const o=e.ray.origin.distanceTo(d);o<e.near||o>e.far||t.push({distance:o,point:u.clone().applyMatrix4(this.matrixWorld),index:n,face:null,faceIndex:null,object:this})}}}updateMorphTargets(){const e=this.geometry.morphAttributes,t=Object.keys(e);if(t.length>0){const n=e[t[0]];if(void 0!==n){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let e=0,t=n.length;e<t;e++){const t=n[e].name||String(e);this.morphTargetInfluences.push(0),this.morphTargetDictionary[t]=e}}}}}const _start=new Vector3,_end=new Vector3;class LineSegments extends Line{constructor(e,t){super(e,t),this.isLineSegments=!0,this.type="LineSegments"}computeLineDistances(){const e=this.geometry;if(null===e.index){const t=e.attributes.position,n=[];for(let e=0,o=t.count;e<o;e+=2)_start.fromBufferAttribute(t,e),_end.fromBufferAttribute(t,e+1),n[e]=0===e?0:n[e-1],n[e+1]=n[e]+_start.distanceTo(_end);e.setAttribute("lineDistance",new Float32BufferAttribute(n,1))}else console.warn("v3d.LineSegments.computeLineDistances(): Computation only possible with non-indexed BufferGeometry.");return this}}class LineLoop extends Line{constructor(e,t){super(e,t),this.isLineLoop=!0,this.type="LineLoop"}}class PointsMaterial extends Material{constructor(e){super(),this.isPointsMaterial=!0,this.type="PointsMaterial",this.color=new Color(16777215),this.map=null,this.alphaMap=null,this.size=1,this.sizeAttenuation=!0,this.fog=!0,this.setValues(e)}copy(e){return super.copy(e),this.color.copy(e.color),this.map=e.map,this.alphaMap=e.alphaMap,this.size=e.size,this.sizeAttenuation=e.sizeAttenuation,this.fog=e.fog,this}}const _inverseMatrix=new Matrix4,_ray=new Ray,_sphere$1=new Sphere,_position$3=new Vector3;class Points extends Object3D{constructor(e=new BufferGeometry,t=new PointsMaterial){super(),this.isPoints=!0,this.type="Points",this.geometry=e,this.material=t,this.updateMorphTargets()}copy(e,t){return super.copy(e,t),this.material=e.material,this.geometry=e.geometry,this}raycast(e,t){const n=this.geometry,o=this.matrixWorld,r=e.params.Points.threshold,i=n.drawRange;if(null===n.boundingSphere&&n.computeBoundingSphere(),_sphere$1.copy(n.boundingSphere),_sphere$1.applyMatrix4(o),_sphere$1.radius+=r,!1===e.ray.intersectsSphere(_sphere$1))return;_inverseMatrix.copy(o).invert(),_ray.copy(e.ray).applyMatrix4(_inverseMatrix);const a=r/((this.scale.x+this.scale.y+this.scale.z)/3),s=a*a,l=n.index,c=n.attributes.position;if(null!==l){for(let n=Math.max(0,i.start),r=Math.min(l.count,i.start+i.count);n<r;n++){const r=l.getX(n);_position$3.fromBufferAttribute(c,r),testPoint(_position$3,r,s,o,e,t,this)}}else{for(let n=Math.max(0,i.start),r=Math.min(c.count,i.start+i.count);n<r;n++)_position$3.fromBufferAttribute(c,n),testPoint(_position$3,n,s,o,e,t,this)}}updateMorphTargets(){const e=this.geometry.morphAttributes,t=Object.keys(e);if(t.length>0){const n=e[t[0]];if(void 0!==n){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let e=0,t=n.length;e<t;e++){const t=n[e].name||String(e);this.morphTargetInfluences.push(0),this.morphTargetDictionary[t]=e}}}}}function testPoint(e,t,n,o,r,i,a){const s=_ray.distanceSqToPoint(e);if(s<n){const n=new Vector3;_ray.closestPointToPoint(e,n),n.applyMatrix4(o);const l=r.ray.origin.distanceTo(n);if(l<r.near||l>r.far)return;i.push({distance:l,distanceToRay:Math.sqrt(s),point:n,index:t,face:null,object:a})}}class VideoTexture extends Texture{constructor(e,t,n,o,r,i,a,s,l){super(e,t,n,o,r,i,a,s,l),this.isVideoTexture=!0,this.minFilter=void 0!==i?i:1006,this.magFilter=void 0!==r?r:1006,this.generateMipmaps=!1;const c=this;"requestVideoFrameCallback"in e&&e.requestVideoFrameCallback(function t(){c.needsUpdate=!0,e.requestVideoFrameCallback(t)})}clone(){return new this.constructor(this.image).copy(this)}update(){const e=this.image;!1==="requestVideoFrameCallback"in e&&e.readyState>=e.HAVE_CURRENT_DATA&&(this.needsUpdate=!0)}}class FramebufferTexture extends Texture{constructor(e,t,n){super({width:e,height:t}),this.isFramebufferTexture=!0,this.format=n,this.magFilter=1003,this.minFilter=1003,this.generateMipmaps=!1,this.needsUpdate=!0}}class CompressedTexture extends Texture{constructor(e,t,n,o,r,i,a,s,l,c,u,d){super(null,i,a,s,l,c,o,r,u,d),this.isCompressedTexture=!0,this.image={width:t,height:n},this.mipmaps=e,this.flipY=!1,this.generateMipmaps=!1}}class CompressedArrayTexture extends CompressedTexture{constructor(e,t,n,o,r,i){super(e,t,n,r,i),this.isCompressedArrayTexture=!0,this.image.depth=o,this.wrapR=1001}}class CanvasTexture extends Texture{constructor(e,t,n,o,r,i,a,s,l){super(e,t,n,o,r,i,a,s,l),this.isCanvasTexture=!0,this.needsUpdate=!0}}class Curve{constructor(){this.type="Curve",this.arcLengthDivisions=200}getPoint(){return console.warn("v3d.Curve: .getPoint() not implemented."),null}getPointAt(e,t){const n=this.getUtoTmapping(e);return this.getPoint(n,t)}getPoints(e=5){const t=[];for(let n=0;n<=e;n++)t.push(this.getPoint(n/e));return t}getSpacedPoints(e=5){const t=[];for(let n=0;n<=e;n++)t.push(this.getPointAt(n/e));return t}getLength(){const e=this.getLengths();return e[e.length-1]}getLengths(e=this.arcLengthDivisions){if(this.cacheArcLengths&&this.cacheArcLengths.length===e+1&&!this.needsUpdate)return this.cacheArcLengths;this.needsUpdate=!1;const t=[];let n,o=this.getPoint(0),r=0;t.push(0);for(let i=1;i<=e;i++)n=this.getPoint(i/e),r+=n.distanceTo(o),t.push(r),o=n;return this.cacheArcLengths=t,t}updateArcLengths(){this.needsUpdate=!0,this.getLengths()}getUtoTmapping(e,t){const n=this.getLengths();let o=0;const r=n.length;let i;i=t||e*n[r-1];let a,s=0,l=r-1;for(;s<=l;)if(o=Math.floor(s+(l-s)/2),a=n[o]-i,a<0)s=o+1;else{if(!(a>0)){l=o;break}l=o-1}if(o=l,n[o]===i)return o/(r-1);const c=n[o];return(o+(i-c)/(n[o+1]-c))/(r-1)}getTangent(e,t){const n=1e-4;let o=e-n,r=e+n;o<0&&(o=0),r>1&&(r=1);const i=this.getPoint(o),a=this.getPoint(r),s=t||(i.isVector2?new Vector2:new Vector3);return s.copy(a).sub(i).normalize(),s}getTangentAt(e,t){const n=this.getUtoTmapping(e);return this.getTangent(n,t)}computeFrenetFrames(e,t){const n=new Vector3,o=[],r=[],i=[],a=new Vector3,s=new Matrix4;for(let t=0;t<=e;t++){const n=t/e;o[t]=this.getTangentAt(n,new Vector3)}r[0]=new Vector3,i[0]=new Vector3;let l=Number.MAX_VALUE;const c=Math.abs(o[0].x),u=Math.abs(o[0].y),d=Math.abs(o[0].z);c<=l&&(l=c,n.set(1,0,0)),u<=l&&(l=u,n.set(0,1,0)),d<=l&&n.set(0,0,1),a.crossVectors(o[0],n).normalize(),r[0].crossVectors(o[0],a),i[0].crossVectors(o[0],r[0]);for(let t=1;t<=e;t++){if(r[t]=r[t-1].clone(),i[t]=i[t-1].clone(),a.crossVectors(o[t-1],o[t]),a.length()>Number.EPSILON){a.normalize();const e=Math.acos(clamp(o[t-1].dot(o[t]),-1,1));r[t].applyMatrix4(s.makeRotationAxis(a,e))}i[t].crossVectors(o[t],r[t])}if(!0===t){let t=Math.acos(clamp(r[0].dot(r[e]),-1,1));t/=e,o[0].dot(a.crossVectors(r[0],r[e]))>0&&(t=-t);for(let n=1;n<=e;n++)r[n].applyMatrix4(s.makeRotationAxis(o[n],t*n)),i[n].crossVectors(o[n],r[n])}return{tangents:o,normals:r,binormals:i}}clone(){return(new this.constructor).copy(this)}copy(e){return this.arcLengthDivisions=e.arcLengthDivisions,this}}class EllipseCurve extends Curve{constructor(e=0,t=0,n=1,o=1,r=0,i=2*Math.PI,a=!1,s=0){super(),this.isEllipseCurve=!0,this.type="EllipseCurve",this.aX=e,this.aY=t,this.xRadius=n,this.yRadius=o,this.aStartAngle=r,this.aEndAngle=i,this.aClockwise=a,this.aRotation=s}getPoint(e,t){const n=t||new Vector2,o=2*Math.PI;let r=this.aEndAngle-this.aStartAngle;const i=Math.abs(r)<Number.EPSILON;for(;r<0;)r+=o;for(;r>o;)r-=o;r<Number.EPSILON&&(r=i?0:o),!0!==this.aClockwise||i||(r===o?r=-o:r-=o);const a=this.aStartAngle+e*r;let s=this.aX+this.xRadius*Math.cos(a),l=this.aY+this.yRadius*Math.sin(a);if(0!==this.aRotation){const e=Math.cos(this.aRotation),t=Math.sin(this.aRotation),n=s-this.aX,o=l-this.aY;s=n*e-o*t+this.aX,l=n*t+o*e+this.aY}return n.set(s,l)}copy(e){return super.copy(e),this.aX=e.aX,this.aY=e.aY,this.xRadius=e.xRadius,this.yRadius=e.yRadius,this.aStartAngle=e.aStartAngle,this.aEndAngle=e.aEndAngle,this.aClockwise=e.aClockwise,this.aRotation=e.aRotation,this}}class ArcCurve extends EllipseCurve{constructor(e,t,n,o,r,i){super(e,t,n,n,o,r,i),this.isArcCurve=!0,this.type="ArcCurve"}}function CubicPoly(){let e=0,t=0,n=0,o=0;function r(r,i,a,s){e=r,t=a,n=-3*r+3*i-2*a-s,o=2*r-2*i+a+s}return{initCatmullRom:function(e,t,n,o,i){r(t,n,i*(n-e),i*(o-t))},initNonuniformCatmullRom:function(e,t,n,o,i,a,s){let l=(t-e)/i-(n-e)/(i+a)+(n-t)/a,c=(n-t)/a-(o-t)/(a+s)+(o-n)/s;l*=a,c*=a,r(t,n,l,c)},calc:function(r){const i=r*r;return e+t*r+n*i+o*(i*r)}}}const tmp$1=new Vector3,px=new CubicPoly,py=new CubicPoly,pz=new CubicPoly;class CatmullRomCurve3 extends Curve{constructor(e=[],t=!1,n="centripetal",o=.5){super(),this.isCatmullRomCurve3=!0,this.type="CatmullRomCurve3",this.points=e,this.closed=t,this.curveType=n,this.tension=o}getPoint(e,t=new Vector3){const n=t,o=this.points,r=o.length,i=(r-(this.closed?0:1))*e;let a,s,l=Math.floor(i),c=i-l;this.closed?l+=l>0?0:(Math.floor(Math.abs(l)/r)+1)*r:0===c&&l===r-1&&(l=r-2,c=1),this.closed||l>0?a=o[(l-1)%r]:(tmp$1.subVectors(o[0],o[1]).add(o[0]),a=tmp$1);const u=o[l%r],d=o[(l+1)%r];if(this.closed||l+2<r?s=o[(l+2)%r]:(tmp$1.subVectors(o[r-1],o[r-2]).add(o[r-1]),s=tmp$1),"centripetal"===this.curveType||"chordal"===this.curveType){const e="chordal"===this.curveType?.5:.25;let t=Math.pow(a.distanceToSquared(u),e),n=Math.pow(u.distanceToSquared(d),e),o=Math.pow(d.distanceToSquared(s),e);n<1e-4&&(n=1),t<1e-4&&(t=n),o<1e-4&&(o=n),px.initNonuniformCatmullRom(a.x,u.x,d.x,s.x,t,n,o),py.initNonuniformCatmullRom(a.y,u.y,d.y,s.y,t,n,o),pz.initNonuniformCatmullRom(a.z,u.z,d.z,s.z,t,n,o)}else"catmullrom"===this.curveType&&(px.initCatmullRom(a.x,u.x,d.x,s.x,this.tension),py.initCatmullRom(a.y,u.y,d.y,s.y,this.tension),pz.initCatmullRom(a.z,u.z,d.z,s.z,this.tension));return n.set(px.calc(c),py.calc(c),pz.calc(c)),n}copy(e){super.copy(e),this.points=[];for(let t=0,n=e.points.length;t<n;t++){const n=e.points[t];this.points.push(n.clone())}return this.closed=e.closed,this.curveType=e.curveType,this.tension=e.tension,this}}function CatmullRom(e,t,n,o,r){const i=.5*(o-t),a=.5*(r-n),s=e*e;return(2*n-2*o+i+a)*(e*s)+(-3*n+3*o-2*i-a)*s+i*e+n}function QuadraticBezierP0(e,t){const n=1-e;return n*n*t}function QuadraticBezierP1(e,t){return 2*(1-e)*e*t}function QuadraticBezierP2(e,t){return e*e*t}function QuadraticBezier(e,t,n,o){return QuadraticBezierP0(e,t)+QuadraticBezierP1(e,n)+QuadraticBezierP2(e,o)}function CubicBezierP0(e,t){const n=1-e;return n*n*n*t}function CubicBezierP1(e,t){const n=1-e;return 3*n*n*e*t}function CubicBezierP2(e,t){return 3*(1-e)*e*e*t}function CubicBezierP3(e,t){return e*e*e*t}function CubicBezier(e,t,n,o,r){return CubicBezierP0(e,t)+CubicBezierP1(e,n)+CubicBezierP2(e,o)+CubicBezierP3(e,r)}class CubicBezierCurve extends Curve{constructor(e=new Vector2,t=new Vector2,n=new Vector2,o=new Vector2){super(),this.isCubicBezierCurve=!0,this.type="CubicBezierCurve",this.v0=e,this.v1=t,this.v2=n,this.v3=o}getPoint(e,t=new Vector2){const n=t,o=this.v0,r=this.v1,i=this.v2,a=this.v3;return n.set(CubicBezier(e,o.x,r.x,i.x,a.x),CubicBezier(e,o.y,r.y,i.y,a.y)),n}copy(e){return super.copy(e),this.v0.copy(e.v0),this.v1.copy(e.v1),this.v2.copy(e.v2),this.v3.copy(e.v3),this}}class CubicBezierCurve3 extends Curve{constructor(e=new Vector3,t=new Vector3,n=new Vector3,o=new Vector3){super(),this.isCubicBezierCurve3=!0,this.type="CubicBezierCurve3",this.v0=e,this.v1=t,this.v2=n,this.v3=o}getPoint(e,t=new Vector3){const n=t,o=this.v0,r=this.v1,i=this.v2,a=this.v3;return n.set(CubicBezier(e,o.x,r.x,i.x,a.x),CubicBezier(e,o.y,r.y,i.y,a.y),CubicBezier(e,o.z,r.z,i.z,a.z)),n}copy(e){return super.copy(e),this.v0.copy(e.v0),this.v1.copy(e.v1),this.v2.copy(e.v2),this.v3.copy(e.v3),this}}class LineCurve extends Curve{constructor(e=new Vector2,t=new Vector2){super(),this.isLineCurve=!0,this.type="LineCurve",this.v1=e,this.v2=t}getPoint(e,t=new Vector2){const n=t;return 1===e?n.copy(this.v2):(n.copy(this.v2).sub(this.v1),n.multiplyScalar(e).add(this.v1)),n}getPointAt(e,t){return this.getPoint(e,t)}getTangent(e,t){const n=t||new Vector2;return n.copy(this.v2).sub(this.v1).normalize(),n}copy(e){return super.copy(e),this.v1.copy(e.v1),this.v2.copy(e.v2),this}}class LineCurve3 extends Curve{constructor(e=new Vector3,t=new Vector3){super(),this.isLineCurve3=!0,this.type="LineCurve3",this.v1=e,this.v2=t}getPoint(e,t=new Vector3){const n=t;return 1===e?n.copy(this.v2):(n.copy(this.v2).sub(this.v1),n.multiplyScalar(e).add(this.v1)),n}getPointAt(e,t){return this.getPoint(e,t)}copy(e){return super.copy(e),this.v1.copy(e.v1),this.v2.copy(e.v2),this}}class QuadraticBezierCurve extends Curve{constructor(e=new Vector2,t=new Vector2,n=new Vector2){super(),this.isQuadraticBezierCurve=!0,this.type="QuadraticBezierCurve",this.v0=e,this.v1=t,this.v2=n}getPoint(e,t=new Vector2){const n=t,o=this.v0,r=this.v1,i=this.v2;return n.set(QuadraticBezier(e,o.x,r.x,i.x),QuadraticBezier(e,o.y,r.y,i.y)),n}copy(e){return super.copy(e),this.v0.copy(e.v0),this.v1.copy(e.v1),this.v2.copy(e.v2),this}}class QuadraticBezierCurve3 extends Curve{constructor(e=new Vector3,t=new Vector3,n=new Vector3){super(),this.isQuadraticBezierCurve3=!0,this.type="QuadraticBezierCurve3",this.v0=e,this.v1=t,this.v2=n}getPoint(e,t=new Vector3){const n=t,o=this.v0,r=this.v1,i=this.v2;return n.set(QuadraticBezier(e,o.x,r.x,i.x),QuadraticBezier(e,o.y,r.y,i.y),QuadraticBezier(e,o.z,r.z,i.z)),n}copy(e){return super.copy(e),this.v0.copy(e.v0),this.v1.copy(e.v1),this.v2.copy(e.v2),this}}class SplineCurve extends Curve{constructor(e=[]){super(),this.isSplineCurve=!0,this.type="SplineCurve",this.points=e}getPoint(e,t=new Vector2){const n=t,o=this.points,r=(o.length-1)*e,i=Math.floor(r),a=r-i,s=o[0===i?i:i-1],l=o[i],c=o[i>o.length-2?o.length-1:i+1],u=o[i>o.length-3?o.length-1:i+2];return n.set(CatmullRom(a,s.x,l.x,c.x,u.x),CatmullRom(a,s.y,l.y,c.y,u.y)),n}copy(e){super.copy(e),this.points=[];for(let t=0,n=e.points.length;t<n;t++){const n=e.points[t];this.points.push(n.clone())}return this}}class CurvePath extends Curve{constructor(){super(),this.type="CurvePath",this.curves=[],this.autoClose=!1}add(e){this.curves.push(e)}closePath(){const e=this.curves[0].getPoint(0),t=this.curves[this.curves.length-1].getPoint(1);e.equals(t)||this.curves.push(new LineCurve(t,e))}getPoint(e,t){const n=e*this.getLength(),o=this.getCurveLengths();let r=0;for(;r<o.length;){if(o[r]>=n){const e=o[r]-n,i=this.curves[r],a=i.getLength(),s=0===a?0:1-e/a;return i.getPointAt(s,t)}r++}return null}getLength(){const e=this.getCurveLengths();return e[e.length-1]}updateArcLengths(){this.needsUpdate=!0,this.cacheLengths=null,this.getCurveLengths()}getCurveLengths(){if(this.cacheLengths&&this.cacheLengths.length===this.curves.length)return this.cacheLengths;const e=[];let t=0;for(let n=0,o=this.curves.length;n<o;n++)t+=this.curves[n].getLength(),e.push(t);return this.cacheLengths=e,e}getSpacedPoints(e=40){const t=[];for(let n=0;n<=e;n++)t.push(this.getPoint(n/e));return this.autoClose&&t.push(t[0]),t}getPoints(e=12){const t=[];let n;for(let o=0,r=this.curves;o<r.length;o++){const i=r[o],a=i.isEllipseCurve?2*e:i.isLineCurve||i.isLineCurve3?1:i.isSplineCurve?e*i.points.length:e,s=i.getPoints(a);for(let e=0;e<s.length;e++){const o=s[e];n&&n.equals(o)||(t.push(o),n=o)}}return this.autoClose&&t.length>1&&!t[t.length-1].equals(t[0])&&t.push(t[0]),t}copy(e){super.copy(e),this.curves=[];for(let t=0,n=e.curves.length;t<n;t++){const n=e.curves[t];this.curves.push(n.clone())}return this.autoClose=e.autoClose,this}}class Path extends CurvePath{constructor(e){super(),this.type="Path",this.currentPoint=new Vector2,e&&this.setFromPoints(e)}setFromPoints(e){this.moveTo(e[0].x,e[0].y);for(let t=1,n=e.length;t<n;t++)this.lineTo(e[t].x,e[t].y);return this}moveTo(e,t){return this.currentPoint.set(e,t),this}lineTo(e,t){const n=new LineCurve(this.currentPoint.clone(),new Vector2(e,t));return this.curves.push(n),this.currentPoint.set(e,t),this}quadraticCurveTo(e,t,n,o){const r=new QuadraticBezierCurve(this.currentPoint.clone(),new Vector2(e,t),new Vector2(n,o));return this.curves.push(r),this.currentPoint.set(n,o),this}bezierCurveTo(e,t,n,o,r,i){const a=new CubicBezierCurve(this.currentPoint.clone(),new Vector2(e,t),new Vector2(n,o),new Vector2(r,i));return this.curves.push(a),this.currentPoint.set(r,i),this}splineThru(e){const t=[this.currentPoint.clone()].concat(e),n=new SplineCurve(t);return this.curves.push(n),this.currentPoint.copy(e[e.length-1]),this}arc(e,t,n,o,r,i){const a=this.currentPoint.x,s=this.currentPoint.y;return this.absarc(e+a,t+s,n,o,r,i),this}absarc(e,t,n,o,r,i){return this.absellipse(e,t,n,n,o,r,i),this}ellipse(e,t,n,o,r,i,a,s){const l=this.currentPoint.x,c=this.currentPoint.y;return this.absellipse(e+l,t+c,n,o,r,i,a,s),this}absellipse(e,t,n,o,r,i,a,s){const l=new EllipseCurve(e,t,n,o,r,i,a,s);if(this.curves.length>0){const e=l.getPoint(0);e.equals(this.currentPoint)||this.lineTo(e.x,e.y)}this.curves.push(l);const c=l.getPoint(1);return this.currentPoint.copy(c),this}copy(e){return super.copy(e),this.currentPoint.copy(e.currentPoint),this}}class LatheGeometry extends BufferGeometry{constructor(e=[new Vector2(0,-.5),new Vector2(.5,0),new Vector2(0,.5)],t=12,n=0,o=2*Math.PI){super(),this.type="LatheGeometry",this.parameters={points:e,segments:t,phiStart:n,phiLength:o},t=Math.floor(t),o=clamp(o,0,2*Math.PI);const r=[],i=[],a=[],s=[],l=[],c=1/t,u=new Vector3,d=new Vector2,h=new Vector3,p=new Vector3,f=new Vector3;let m=0,g=0;for(let t=0;t<=e.length-1;t++)switch(t){case 0:m=e[t+1].x-e[t].x,g=e[t+1].y-e[t].y,h.x=1*g,h.y=-m,h.z=0*g,f.copy(h),h.normalize(),s.push(h.x,h.y,h.z);break;case e.length-1:s.push(f.x,f.y,f.z);break;default:m=e[t+1].x-e[t].x,g=e[t+1].y-e[t].y,h.x=1*g,h.y=-m,h.z=0*g,p.copy(h),h.x+=f.x,h.y+=f.y,h.z+=f.z,h.normalize(),s.push(h.x,h.y,h.z),f.copy(p)}for(let r=0;r<=t;r++){const h=n+r*c*o,p=Math.sin(h),f=Math.cos(h);for(let n=0;n<=e.length-1;n++){u.x=e[n].x*p,u.y=e[n].y,u.z=e[n].x*f,i.push(u.x,u.y,u.z),d.x=r/t,d.y=n/(e.length-1),a.push(d.x,d.y);const o=s[3*n+0]*p,c=s[3*n+1],h=s[3*n+0]*f;l.push(o,c,h)}}for(let n=0;n<t;n++)for(let t=0;t<e.length-1;t++){const o=t+n*e.length,i=o,a=o+e.length,s=o+e.length+1,l=o+1;r.push(i,a,l),r.push(s,l,a)}this.setIndex(r),this.setAttribute("position",new Float32BufferAttribute(i,3)),this.setAttribute("uv",new Float32BufferAttribute(a,2)),this.setAttribute("normal",new Float32BufferAttribute(l,3))}}class CapsuleGeometry extends LatheGeometry{constructor(e=1,t=1,n=4,o=8){const r=new Path;r.absarc(0,-t/2,e,1.5*Math.PI,0),r.absarc(0,t/2,e,0,.5*Math.PI),super(r.getPoints(n),o),this.type="CapsuleGeometry",this.parameters={radius:e,height:t,capSegments:n,radialSegments:o}}}class CircleGeometry extends BufferGeometry{constructor(e=1,t=32,n=0,o=2*Math.PI){super(),this.type="CircleGeometry",this.parameters={radius:e,segments:t,thetaStart:n,thetaLength:o},t=Math.max(3,t);const r=[],i=[],a=[],s=[],l=new Vector3,c=new Vector2;i.push(0,0,0),a.push(0,0,1),s.push(.5,.5);for(let r=0,u=3;r<=t;r++,u+=3){const d=n+r/t*o;l.x=e*Math.cos(d),l.y=e*Math.sin(d),i.push(l.x,l.y,l.z),a.push(0,0,1),c.x=(i[u]/e+1)/2,c.y=(i[u+1]/e+1)/2,s.push(c.x,c.y)}for(let e=1;e<=t;e++)r.push(e,e+1,0);this.setIndex(r),this.setAttribute("position",new Float32BufferAttribute(i,3)),this.setAttribute("normal",new Float32BufferAttribute(a,3)),this.setAttribute("uv",new Float32BufferAttribute(s,2))}}class CylinderGeometry extends BufferGeometry{constructor(e=1,t=1,n=1,o=32,r=1,i=!1,a=0,s=2*Math.PI){super(),this.type="CylinderGeometry",this.parameters={radiusTop:e,radiusBottom:t,height:n,radialSegments:o,heightSegments:r,openEnded:i,thetaStart:a,thetaLength:s};const l=this;o=Math.floor(o),r=Math.floor(r);const c=[],u=[],d=[],h=[];let p=0;const f=[],m=n/2;let g=0;function _(n){const r=p,i=new Vector2,f=new Vector3;let _=0;const A=!0===n?e:t,v=!0===n?1:-1;for(let e=1;e<=o;e++)u.push(0,m*v,0),d.push(0,v,0),h.push(.5,.5),p++;const x=p;for(let e=0;e<=o;e++){const t=e/o*s+a,n=Math.cos(t),r=Math.sin(t);f.x=A*r,f.y=m*v,f.z=A*n,u.push(f.x,f.y,f.z),d.push(0,v,0),i.x=.5*n+.5,i.y=.5*r*v+.5,h.push(i.x,i.y),p++}for(let e=0;e<o;e++){const t=r+e,o=x+e;!0===n?c.push(o,o+1,t):c.push(o+1,o,t),_+=3}l.addGroup(g,_,!0===n?1:2),g+=_}!function(){const i=new Vector3,_=new Vector3;let A=0;const v=(t-e)/n;for(let l=0;l<=r;l++){const c=[],g=l/r,A=g*(t-e)+e;for(let e=0;e<=o;e++){const t=e/o,r=t*s+a,l=Math.sin(r),f=Math.cos(r);_.x=A*l,_.y=-g*n+m,_.z=A*f,u.push(_.x,_.y,_.z),i.set(l,v,f).normalize(),d.push(i.x,i.y,i.z),h.push(t,1-g),c.push(p++)}f.push(c)}for(let e=0;e<o;e++)for(let t=0;t<r;t++){const n=f[t][e],o=f[t+1][e],r=f[t+1][e+1],i=f[t][e+1];c.push(n,o,i),c.push(o,r,i),A+=6}l.addGroup(g,A,0),g+=A}(),!1===i&&(e>0&&_(!0),t>0&&_(!1)),this.setIndex(c),this.setAttribute("position",new Float32BufferAttribute(u,3)),this.setAttribute("normal",new Float32BufferAttribute(d,3)),this.setAttribute("uv",new Float32BufferAttribute(h,2))}}class ConeGeometry extends CylinderGeometry{constructor(e=1,t=1,n=32,o=1,r=!1,i=0,a=2*Math.PI){super(0,e,t,n,o,r,i,a),this.type="ConeGeometry",this.parameters={radius:e,height:t,radialSegments:n,heightSegments:o,openEnded:r,thetaStart:i,thetaLength:a}}}const _v0=new Vector3,_v1$2=new Vector3,_normal=new Vector3,_triangle=new Triangle;class EdgesGeometry extends BufferGeometry{constructor(e=null,t=1){if(super(),this.type="EdgesGeometry",this.parameters={geometry:e,thresholdAngle:t},null!==e){const n=4,o=Math.pow(10,n),r=Math.cos(DEG2RAD*t),i=e.getIndex(),a=e.getAttribute("position"),s=i?i.count:a.count,l=[0,0,0],c=["a","b","c"],u=new Array(3),d={},h=[];for(let e=0;e<s;e+=3){i?(l[0]=i.getX(e),l[1]=i.getX(e+1),l[2]=i.getX(e+2)):(l[0]=e,l[1]=e+1,l[2]=e+2);const{a:t,b:n,c:s}=_triangle;if(t.fromBufferAttribute(a,l[0]),n.fromBufferAttribute(a,l[1]),s.fromBufferAttribute(a,l[2]),_triangle.getNormal(_normal),u[0]=`${Math.round(t.x*o)},${Math.round(t.y*o)},${Math.round(t.z*o)}`,u[1]=`${Math.round(n.x*o)},${Math.round(n.y*o)},${Math.round(n.z*o)}`,u[2]=`${Math.round(s.x*o)},${Math.round(s.y*o)},${Math.round(s.z*o)}`,u[0]!==u[1]&&u[1]!==u[2]&&u[2]!==u[0])for(let e=0;e<3;e++){const t=(e+1)%3,n=u[e],o=u[t],i=_triangle[c[e]],a=_triangle[c[t]],s=`${n}_${o}`,p=`${o}_${n}`;p in d&&d[p]?(_normal.dot(d[p].normal)<=r&&(h.push(i.x,i.y,i.z),h.push(a.x,a.y,a.z)),d[p]=null):s in d||(d[s]={index0:l[e],index1:l[t],normal:_normal.clone()})}}for(const e in d)if(d[e]){const{index0:t,index1:n}=d[e];_v0.fromBufferAttribute(a,t),_v1$2.fromBufferAttribute(a,n),h.push(_v0.x,_v0.y,_v0.z),h.push(_v1$2.x,_v1$2.y,_v1$2.z)}this.setAttribute("position",new Float32BufferAttribute(h,3))}}}class Shape extends Path{constructor(e){super(e),this.uuid=generateUUID(),this.type="Shape",this.holes=[]}getPointsHoles(e){const t=[];for(let n=0,o=this.holes.length;n<o;n++)t[n]=this.holes[n].getPoints(e);return t}extractPoints(e){return{shape:this.getPoints(e),holes:this.getPointsHoles(e)}}copy(e){super.copy(e),this.holes=[];for(let t=0,n=e.holes.length;t<n;t++){const n=e.holes[t];this.holes.push(n.clone())}return this}}const Earcut={triangulate:function(e,t,n=2){const o=t&&t.length,r=o?t[0]*n:e.length;let i=linkedList(e,0,r,n,!0);const a=[];if(!i||i.next===i.prev)return a;let s,l,c,u,d,h,p;if(o&&(i=eliminateHoles(e,t,i,n)),e.length>80*n){s=c=e[0],l=u=e[1];for(let t=n;t<r;t+=n)d=e[t],h=e[t+1],d<s&&(s=d),h<l&&(l=h),d>c&&(c=d),h>u&&(u=h);p=Math.max(c-s,u-l),p=0!==p?32767/p:0}return earcutLinked(i,a,n,s,l,p,0),a}};function linkedList(e,t,n,o,r){let i,a;if(r===signedArea(e,t,n,o)>0)for(i=t;i<n;i+=o)a=insertNode(i,e[i],e[i+1],a);else for(i=n-o;i>=t;i-=o)a=insertNode(i,e[i],e[i+1],a);return a&&equals(a,a.next)&&(removeNode(a),a=a.next),a}function filterPoints(e,t){if(!e)return e;t||(t=e);let n,o=e;do{if(n=!1,o.steiner||!equals(o,o.next)&&0!==area(o.prev,o,o.next))o=o.next;else{if(removeNode(o),o=t=o.prev,o===o.next)break;n=!0}}while(n||o!==t);return t}function earcutLinked(e,t,n,o,r,i,a){if(!e)return;!a&&i&&indexCurve(e,o,r,i);let s,l,c=e;for(;e.prev!==e.next;)if(s=e.prev,l=e.next,i?isEarHashed(e,o,r,i):isEar(e))t.push(s.i/n|0),t.push(e.i/n|0),t.push(l.i/n|0),removeNode(e),e=l.next,c=l.next;else if((e=l)===c){a?1===a?earcutLinked(e=cureLocalIntersections(filterPoints(e),t,n),t,n,o,r,i,2):2===a&&splitEarcut(e,t,n,o,r,i):earcutLinked(filterPoints(e),t,n,o,r,i,1);break}}function isEar(e){const t=e.prev,n=e,o=e.next;if(area(t,n,o)>=0)return!1;const r=t.x,i=n.x,a=o.x,s=t.y,l=n.y,c=o.y,u=r<i?r<a?r:a:i<a?i:a,d=s<l?s<c?s:c:l<c?l:c,h=r>i?r>a?r:a:i>a?i:a,p=s>l?s>c?s:c:l>c?l:c;let f=o.next;for(;f!==t;){if(f.x>=u&&f.x<=h&&f.y>=d&&f.y<=p&&pointInTriangle(r,s,i,l,a,c,f.x,f.y)&&area(f.prev,f,f.next)>=0)return!1;f=f.next}return!0}function isEarHashed(e,t,n,o){const r=e.prev,i=e,a=e.next;if(area(r,i,a)>=0)return!1;const s=r.x,l=i.x,c=a.x,u=r.y,d=i.y,h=a.y,p=s<l?s<c?s:c:l<c?l:c,f=u<d?u<h?u:h:d<h?d:h,m=s>l?s>c?s:c:l>c?l:c,g=u>d?u>h?u:h:d>h?d:h,_=zOrder(p,f,t,n,o),A=zOrder(m,g,t,n,o);let v=e.prevZ,x=e.nextZ;for(;v&&v.z>=_&&x&&x.z<=A;){if(v.x>=p&&v.x<=m&&v.y>=f&&v.y<=g&&v!==r&&v!==a&&pointInTriangle(s,u,l,d,c,h,v.x,v.y)&&area(v.prev,v,v.next)>=0)return!1;if(v=v.prevZ,x.x>=p&&x.x<=m&&x.y>=f&&x.y<=g&&x!==r&&x!==a&&pointInTriangle(s,u,l,d,c,h,x.x,x.y)&&area(x.prev,x,x.next)>=0)return!1;x=x.nextZ}for(;v&&v.z>=_;){if(v.x>=p&&v.x<=m&&v.y>=f&&v.y<=g&&v!==r&&v!==a&&pointInTriangle(s,u,l,d,c,h,v.x,v.y)&&area(v.prev,v,v.next)>=0)return!1;v=v.prevZ}for(;x&&x.z<=A;){if(x.x>=p&&x.x<=m&&x.y>=f&&x.y<=g&&x!==r&&x!==a&&pointInTriangle(s,u,l,d,c,h,x.x,x.y)&&area(x.prev,x,x.next)>=0)return!1;x=x.nextZ}return!0}function cureLocalIntersections(e,t,n){let o=e;do{const r=o.prev,i=o.next.next;!equals(r,i)&&intersects(r,o,o.next,i)&&locallyInside(r,i)&&locallyInside(i,r)&&(t.push(r.i/n|0),t.push(o.i/n|0),t.push(i.i/n|0),removeNode(o),removeNode(o.next),o=e=i),o=o.next}while(o!==e);return filterPoints(o)}function splitEarcut(e,t,n,o,r,i){let a=e;do{let e=a.next.next;for(;e!==a.prev;){if(a.i!==e.i&&isValidDiagonal(a,e)){let s=splitPolygon(a,e);return a=filterPoints(a,a.next),s=filterPoints(s,s.next),earcutLinked(a,t,n,o,r,i,0),void earcutLinked(s,t,n,o,r,i,0)}e=e.next}a=a.next}while(a!==e)}function eliminateHoles(e,t,n,o){const r=[];let i,a,s,l,c;for(i=0,a=t.length;i<a;i++)s=t[i]*o,l=i<a-1?t[i+1]*o:e.length,c=linkedList(e,s,l,o,!1),c===c.next&&(c.steiner=!0),r.push(getLeftmost(c));for(r.sort(compareX),i=0;i<r.length;i++)n=eliminateHole(r[i],n);return n}function compareX(e,t){return e.x-t.x}function eliminateHole(e,t){const n=findHoleBridge(e,t);if(!n)return t;const o=splitPolygon(n,e);return filterPoints(o,o.next),filterPoints(n,n.next)}function findHoleBridge(e,t){let n,o=t,r=-1/0;const i=e.x,a=e.y;do{if(a<=o.y&&a>=o.next.y&&o.next.y!==o.y){const e=o.x+(a-o.y)*(o.next.x-o.x)/(o.next.y-o.y);if(e<=i&&e>r&&(r=e,n=o.x<o.next.x?o:o.next,e===i))return n}o=o.next}while(o!==t);if(!n)return null;const s=n,l=n.x,c=n.y;let u,d=1/0;o=n;do{i>=o.x&&o.x>=l&&i!==o.x&&pointInTriangle(a<c?i:r,a,l,c,a<c?r:i,a,o.x,o.y)&&(u=Math.abs(a-o.y)/(i-o.x),locallyInside(o,e)&&(u<d||u===d&&(o.x>n.x||o.x===n.x&&sectorContainsSector(n,o)))&&(n=o,d=u)),o=o.next}while(o!==s);return n}function sectorContainsSector(e,t){return area(e.prev,e,t.prev)<0&&area(t.next,e,e.next)<0}function indexCurve(e,t,n,o){let r=e;do{0===r.z&&(r.z=zOrder(r.x,r.y,t,n,o)),r.prevZ=r.prev,r.nextZ=r.next,r=r.next}while(r!==e);r.prevZ.nextZ=null,r.prevZ=null,sortLinked(r)}function sortLinked(e){let t,n,o,r,i,a,s,l,c=1;do{for(n=e,e=null,i=null,a=0;n;){for(a++,o=n,s=0,t=0;t<c&&(s++,o=o.nextZ,o);t++);for(l=c;s>0||l>0&&o;)0!==s&&(0===l||!o||n.z<=o.z)?(r=n,n=n.nextZ,s--):(r=o,o=o.nextZ,l--),i?i.nextZ=r:e=r,r.prevZ=i,i=r;n=o}i.nextZ=null,c*=2}while(a>1);return e}function zOrder(e,t,n,o,r){return(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*r|0)|e<<8))|e<<4))|e<<2))|e<<1))|(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-o)*r|0)|t<<8))|t<<4))|t<<2))|t<<1))<<1}function getLeftmost(e){let t=e,n=e;do{(t.x<n.x||t.x===n.x&&t.y<n.y)&&(n=t),t=t.next}while(t!==e);return n}function pointInTriangle(e,t,n,o,r,i,a,s){return(r-a)*(t-s)>=(e-a)*(i-s)&&(e-a)*(o-s)>=(n-a)*(t-s)&&(n-a)*(i-s)>=(r-a)*(o-s)}function isValidDiagonal(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!intersectsPolygon(e,t)&&(locallyInside(e,t)&&locallyInside(t,e)&&middleInside(e,t)&&(area(e.prev,e,t.prev)||area(e,t.prev,t))||equals(e,t)&&area(e.prev,e,e.next)>0&&area(t.prev,t,t.next)>0)}function area(e,t,n){return(t.y-e.y)*(n.x-t.x)-(t.x-e.x)*(n.y-t.y)}function equals(e,t){return e.x===t.x&&e.y===t.y}function intersects(e,t,n,o){const r=sign(area(e,t,n)),i=sign(area(e,t,o)),a=sign(area(n,o,e)),s=sign(area(n,o,t));return r!==i&&a!==s||(!(0!==r||!onSegment(e,n,t))||(!(0!==i||!onSegment(e,o,t))||(!(0!==a||!onSegment(n,e,o))||!(0!==s||!onSegment(n,t,o)))))}function onSegment(e,t,n){return t.x<=Math.max(e.x,n.x)&&t.x>=Math.min(e.x,n.x)&&t.y<=Math.max(e.y,n.y)&&t.y>=Math.min(e.y,n.y)}function sign(e){return e>0?1:e<0?-1:0}function intersectsPolygon(e,t){let n=e;do{if(n.i!==e.i&&n.next.i!==e.i&&n.i!==t.i&&n.next.i!==t.i&&intersects(n,n.next,e,t))return!0;n=n.next}while(n!==e);return!1}function locallyInside(e,t){return area(e.prev,e,e.next)<0?area(e,t,e.next)>=0&&area(e,e.prev,t)>=0:area(e,t,e.prev)<0||area(e,e.next,t)<0}function middleInside(e,t){let n=e,o=!1;const r=(e.x+t.x)/2,i=(e.y+t.y)/2;do{n.y>i!=n.next.y>i&&n.next.y!==n.y&&r<(n.next.x-n.x)*(i-n.y)/(n.next.y-n.y)+n.x&&(o=!o),n=n.next}while(n!==e);return o}function splitPolygon(e,t){const n=new Node(e.i,e.x,e.y),o=new Node(t.i,t.x,t.y),r=e.next,i=t.prev;return e.next=t,t.prev=e,n.next=r,r.prev=n,o.next=n,n.prev=o,i.next=o,o.prev=i,o}function insertNode(e,t,n,o){const r=new Node(e,t,n);return o?(r.next=o.next,r.prev=o,o.next.prev=r,o.next=r):(r.prev=r,r.next=r),r}function removeNode(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ)}function Node(e,t,n){this.i=e,this.x=t,this.y=n,this.prev=null,this.next=null,this.z=0,this.prevZ=null,this.nextZ=null,this.steiner=!1}function signedArea(e,t,n,o){let r=0;for(let i=t,a=n-o;i<n;i+=o)r+=(e[a]-e[i])*(e[i+1]+e[a+1]),a=i;return r}class ShapeUtils{static area(e){const t=e.length;let n=0;for(let o=t-1,r=0;r<t;o=r++)n+=e[o].x*e[r].y-e[r].x*e[o].y;return.5*n}static isClockWise(e){return ShapeUtils.area(e)<0}static triangulateShape(e,t){const n=[],o=[],r=[];removeDupEndPts(e),addContour(n,e);let i=e.length;t.forEach(removeDupEndPts);for(let e=0;e<t.length;e++)o.push(i),i+=t[e].length,addContour(n,t[e]);const a=Earcut.triangulate(n,o);for(let e=0;e<a.length;e+=3)r.push(a.slice(e,e+3));return r}}function removeDupEndPts(e){const t=e.length;t>2&&e[t-1].equals(e[0])&&e.pop()}function addContour(e,t){for(let n=0;n<t.length;n++)e.push(t[n].x),e.push(t[n].y)}class ExtrudeGeometry extends BufferGeometry{constructor(e=new Shape([new Vector2(.5,.5),new Vector2(-.5,.5),new Vector2(-.5,-.5),new Vector2(.5,-.5)]),t={}){super(),this.type="ExtrudeGeometry",this.parameters={shapes:e,options:t},e=Array.isArray(e)?e:[e];const n=this,o=[],r=[];for(let t=0,n=e.length;t<n;t++){i(e[t])}function i(e){const i=[],a=void 0!==t.curveSegments?t.curveSegments:12,s=void 0!==t.steps?t.steps:1,l=void 0!==t.depth?t.depth:1;let c=void 0===t.bevelEnabled||t.bevelEnabled,u=void 0!==t.bevelThickness?t.bevelThickness:.2,d=void 0!==t.bevelSize?t.bevelSize:u-.1,h=void 0!==t.bevelOffset?t.bevelOffset:0,p=void 0!==t.bevelSegments?t.bevelSegments:3;const f=t.extrudePath,m=void 0!==t.UVGenerator?t.UVGenerator:WorldUVGenerator;let g,_,A,v,x,y=!1;f&&(g=f.getSpacedPoints(s),y=!0,c=!1,_=f.computeFrenetFrames(s,!1),A=new Vector3,v=new Vector3,x=new Vector3),c||(p=0,u=0,d=0,h=0);const b=e.extractPoints(a);let C=b.shape;const S=b.holes;if(!ShapeUtils.isClockWise(C)){C=C.reverse();for(let e=0,t=S.length;e<t;e++){const t=S[e];ShapeUtils.isClockWise(t)&&(S[e]=t.reverse())}}const E=ShapeUtils.triangulateShape(C,S),M=C;for(let e=0,t=S.length;e<t;e++){const t=S[e];C=C.concat(t)}function T(e,t,n){return t||console.error("v3d.ExtrudeGeometry: vec does not exist"),t.clone().multiplyScalar(n).add(e)}const w=C.length,I=E.length;function R(e,t,n){let o,r,i;const a=e.x-t.x,s=e.y-t.y,l=n.x-e.x,c=n.y-e.y,u=a*a+s*s,d=a*c-s*l;if(Math.abs(d)>Number.EPSILON){const d=Math.sqrt(u),h=Math.sqrt(l*l+c*c),p=t.x-s/d,f=t.y+a/d,m=((n.x-c/h-p)*c-(n.y+l/h-f)*l)/(a*c-s*l);o=p+a*m-e.x,r=f+s*m-e.y;const g=o*o+r*r;if(g<=2)return new Vector2(o,r);i=Math.sqrt(g/2)}else{let e=!1;a>Number.EPSILON?l>Number.EPSILON&&(e=!0):a<-Number.EPSILON?l<-Number.EPSILON&&(e=!0):Math.sign(s)===Math.sign(c)&&(e=!0),e?(o=-s,r=a,i=Math.sqrt(u)):(o=a,r=s,i=Math.sqrt(u/2))}return new Vector2(o/i,r/i)}const L=[];for(let e=0,t=M.length,n=t-1,o=e+1;e<t;e++,n++,o++)n===t&&(n=0),o===t&&(o=0),L[e]=R(M[e],M[n],M[o]);const B=[];let P,N=L.concat();for(let e=0,t=S.length;e<t;e++){const t=S[e];P=[];for(let e=0,n=t.length,o=n-1,r=e+1;e<n;e++,o++,r++)o===n&&(o=0),r===n&&(r=0),P[e]=R(t[e],t[o],t[r]);B.push(P),N=N.concat(P)}for(let e=0;e<p;e++){const t=e/p,n=u*Math.cos(t*Math.PI/2),o=d*Math.sin(t*Math.PI/2)+h;for(let e=0,t=M.length;e<t;e++){const t=T(M[e],L[e],o);F(t.x,t.y,-n)}for(let e=0,t=S.length;e<t;e++){const t=S[e];P=B[e];for(let e=0,r=t.length;e<r;e++){const r=T(t[e],P[e],o);F(r.x,r.y,-n)}}}const D=d+h;for(let e=0;e<w;e++){const t=c?T(C[e],N[e],D):C[e];y?(v.copy(_.normals[0]).multiplyScalar(t.x),A.copy(_.binormals[0]).multiplyScalar(t.y),x.copy(g[0]).add(v).add(A),F(x.x,x.y,x.z)):F(t.x,t.y,0)}for(let e=1;e<=s;e++)for(let t=0;t<w;t++){const n=c?T(C[t],N[t],D):C[t];y?(v.copy(_.normals[e]).multiplyScalar(n.x),A.copy(_.binormals[e]).multiplyScalar(n.y),x.copy(g[e]).add(v).add(A),F(x.x,x.y,x.z)):F(n.x,n.y,l/s*e)}for(let e=p-1;e>=0;e--){const t=e/p,n=u*Math.cos(t*Math.PI/2),o=d*Math.sin(t*Math.PI/2)+h;for(let e=0,t=M.length;e<t;e++){const t=T(M[e],L[e],o);F(t.x,t.y,l+n)}for(let e=0,t=S.length;e<t;e++){const t=S[e];P=B[e];for(let e=0,r=t.length;e<r;e++){const r=T(t[e],P[e],o);y?F(r.x,r.y+g[s-1].y,g[s-1].x+n):F(r.x,r.y,l+n)}}}function O(e,t){let n=e.length;for(;--n>=0;){const o=n;let r=n-1;r<0&&(r=e.length-1);for(let e=0,n=s+2*p;e<n;e++){const n=w*e,i=w*(e+1);U(t+o+n,t+r+n,t+r+i,t+o+i)}}}function F(e,t,n){i.push(e),i.push(t),i.push(n)}function V(e,t,r){G(e),G(t),G(r);const i=o.length/3,a=m.generateTopUV(n,o,i-3,i-2,i-1);z(a[0]),z(a[1]),z(a[2])}function U(e,t,r,i){G(e),G(t),G(i),G(t),G(r),G(i);const a=o.length/3,s=m.generateSideWallUV(n,o,a-6,a-3,a-2,a-1);z(s[0]),z(s[1]),z(s[3]),z(s[1]),z(s[2]),z(s[3])}function G(e){o.push(i[3*e+0]),o.push(i[3*e+1]),o.push(i[3*e+2])}function z(e){r.push(e.x),r.push(e.y)}!function(){const e=o.length/3;if(c){let e=0,t=w*e;for(let e=0;e<I;e++){const n=E[e];V(n[2]+t,n[1]+t,n[0]+t)}e=s+2*p,t=w*e;for(let e=0;e<I;e++){const n=E[e];V(n[0]+t,n[1]+t,n[2]+t)}}else{for(let e=0;e<I;e++){const t=E[e];V(t[2],t[1],t[0])}for(let e=0;e<I;e++){const t=E[e];V(t[0]+w*s,t[1]+w*s,t[2]+w*s)}}n.addGroup(e,o.length/3-e,0)}(),function(){const e=o.length/3;let t=0;O(M,t),t+=M.length;for(let e=0,n=S.length;e<n;e++){const n=S[e];O(n,t),t+=n.length}n.addGroup(e,o.length/3-e,1)}()}this.setAttribute("position",new Float32BufferAttribute(o,3)),this.setAttribute("uv",new Float32BufferAttribute(r,2)),this.computeVertexNormals()}}const WorldUVGenerator={generateTopUV:function(e,t,n,o,r){const i=t[3*n],a=t[3*n+1],s=t[3*o],l=t[3*o+1],c=t[3*r],u=t[3*r+1];return[new Vector2(i,a),new Vector2(s,l),new Vector2(c,u)]},generateSideWallUV:function(e,t,n,o,r,i){const a=t[3*n],s=t[3*n+1],l=t[3*n+2],c=t[3*o],u=t[3*o+1],d=t[3*o+2],h=t[3*r],p=t[3*r+1],f=t[3*r+2],m=t[3*i],g=t[3*i+1],_=t[3*i+2];return Math.abs(s-u)<Math.abs(a-c)?[new Vector2(a,1-l),new Vector2(c,1-d),new Vector2(h,1-f),new Vector2(m,1-_)]:[new Vector2(s,1-l),new Vector2(u,1-d),new Vector2(p,1-f),new Vector2(g,1-_)]}};class PolyhedronGeometry extends BufferGeometry{constructor(e=[],t=[],n=1,o=0){super(),this.type="PolyhedronGeometry",this.parameters={vertices:e,indices:t,radius:n,detail:o};const r=[],i=[];function a(e,t,n,o){const r=o+1,i=[];for(let o=0;o<=r;o++){i[o]=[];const a=e.clone().lerp(n,o/r),s=t.clone().lerp(n,o/r),l=r-o;for(let e=0;e<=l;e++)i[o][e]=0===e&&o===r?a:a.clone().lerp(s,e/l)}for(let e=0;e<r;e++)for(let t=0;t<2*(r-e)-1;t++){const n=Math.floor(t/2);t%2==0?(s(i[e][n+1]),s(i[e+1][n]),s(i[e][n])):(s(i[e][n+1]),s(i[e+1][n+1]),s(i[e+1][n]))}}function s(e){r.push(e.x,e.y,e.z)}function l(t,n){const o=3*t;n.x=e[o+0],n.y=e[o+1],n.z=e[o+2]}function c(e,t,n,o){o<0&&1===e.x&&(i[t]=e.x-1),0===n.x&&0===n.z&&(i[t]=o/2/Math.PI+.5)}function u(e){return Math.atan2(e.z,-e.x)}function d(e){return Math.atan2(-e.y,Math.sqrt(e.x*e.x+e.z*e.z))}!function(e){const n=new Vector3,o=new Vector3,r=new Vector3;for(let i=0;i<t.length;i+=3)l(t[i+0],n),l(t[i+1],o),l(t[i+2],r),a(n,o,r,e)}(o),function(e){const t=new Vector3;for(let n=0;n<r.length;n+=3)t.x=r[n+0],t.y=r[n+1],t.z=r[n+2],t.normalize().multiplyScalar(e),r[n+0]=t.x,r[n+1]=t.y,r[n+2]=t.z}(n),function(){const e=new Vector3;for(let t=0;t<r.length;t+=3){e.x=r[t+0],e.y=r[t+1],e.z=r[t+2];const n=u(e)/2/Math.PI+.5,o=d(e)/Math.PI+.5;i.push(n,1-o)}(function(){const e=new Vector3,t=new Vector3,n=new Vector3,o=new Vector3,a=new Vector2,s=new Vector2,l=new Vector2;for(let d=0,h=0;d<r.length;d+=9,h+=6){e.set(r[d+0],r[d+1],r[d+2]),t.set(r[d+3],r[d+4],r[d+5]),n.set(r[d+6],r[d+7],r[d+8]),a.set(i[h+0],i[h+1]),s.set(i[h+2],i[h+3]),l.set(i[h+4],i[h+5]),o.copy(e).add(t).add(n).divideScalar(3);const p=u(o);c(a,h+0,e,p),c(s,h+2,t,p),c(l,h+4,n,p)}})(),function(){for(let e=0;e<i.length;e+=6){const t=i[e+0],n=i[e+2],o=i[e+4],r=Math.max(t,n,o),a=Math.min(t,n,o);r>.9&&a<.1&&(t<.2&&(i[e+0]+=1),n<.2&&(i[e+2]+=1),o<.2&&(i[e+4]+=1))}}()}(),this.setAttribute("position",new Float32BufferAttribute(r,3)),this.setAttribute("normal",new Float32BufferAttribute(r.slice(),3)),this.setAttribute("uv",new Float32BufferAttribute(i,2)),0===o?this.computeVertexNormals():this.normalizeNormals()}}class IcosahedronGeometry extends PolyhedronGeometry{constructor(e=1,t=0){const n=(1+Math.sqrt(5))/2;super([-1,n,0,1,n,0,-1,-n,0,1,-n,0,0,-1,n,0,1,n,0,-1,-n,0,1,-n,n,0,-1,n,0,1,-n,0,-1,-n,0,1],[0,11,5,0,5,1,0,1,7,0,7,10,0,10,11,1,5,9,5,11,4,11,10,2,10,7,6,7,1,8,3,9,4,3,4,2,3,2,6,3,6,8,3,8,9,4,9,5,2,4,11,6,2,10,8,6,7,9,8,1],e,t),this.type="IcosahedronGeometry",this.parameters={radius:e,detail:t}}}class RingGeometry extends BufferGeometry{constructor(e=.5,t=1,n=32,o=1,r=0,i=2*Math.PI){super(),this.type="RingGeometry",this.parameters={innerRadius:e,outerRadius:t,thetaSegments:n,phiSegments:o,thetaStart:r,thetaLength:i},n=Math.max(3,n);const a=[],s=[],l=[],c=[];let u=e;const d=(t-e)/(o=Math.max(1,o)),h=new Vector3,p=new Vector2;for(let e=0;e<=o;e++){for(let e=0;e<=n;e++){const o=r+e/n*i;h.x=u*Math.cos(o),h.y=u*Math.sin(o),s.push(h.x,h.y,h.z),l.push(0,0,1),p.x=(h.x/t+1)/2,p.y=(h.y/t+1)/2,c.push(p.x,p.y)}u+=d}for(let e=0;e<o;e++){const t=e*(n+1);for(let e=0;e<n;e++){const o=e+t,r=o,i=o+n+1,s=o+n+2,l=o+1;a.push(r,i,l),a.push(i,s,l)}}this.setIndex(a),this.setAttribute("position",new Float32BufferAttribute(s,3)),this.setAttribute("normal",new Float32BufferAttribute(l,3)),this.setAttribute("uv",new Float32BufferAttribute(c,2))}}class ShapeGeometry extends BufferGeometry{constructor(e=new Shape([new Vector2(0,.5),new Vector2(-.5,-.5),new Vector2(.5,-.5)]),t=12){super(),this.type="ShapeGeometry",this.parameters={shapes:e,curveSegments:t};const n=[],o=[],r=[],i=[];let a=0,s=0;if(!1===Array.isArray(e))l(e);else for(let t=0;t<e.length;t++)l(e[t]),this.addGroup(a,s,t),a+=s,s=0;function l(e){const a=o.length/3,l=e.extractPoints(t);let c=l.shape;const u=l.holes;!1===ShapeUtils.isClockWise(c)&&(c=c.reverse());for(let e=0,t=u.length;e<t;e++){const t=u[e];!0===ShapeUtils.isClockWise(t)&&(u[e]=t.reverse())}const d=ShapeUtils.triangulateShape(c,u);for(let e=0,t=u.length;e<t;e++){const t=u[e];c=c.concat(t)}for(let e=0,t=c.length;e<t;e++){const t=c[e];o.push(t.x,t.y,0),r.push(0,0,1),i.push(t.x,t.y)}for(let e=0,t=d.length;e<t;e++){const t=d[e],o=t[0]+a,r=t[1]+a,i=t[2]+a;n.push(o,r,i),s+=3}}this.setIndex(n),this.setAttribute("position",new Float32BufferAttribute(o,3)),this.setAttribute("normal",new Float32BufferAttribute(r,3)),this.setAttribute("uv",new Float32BufferAttribute(i,2))}}class SphereGeometry extends BufferGeometry{constructor(e=1,t=32,n=16,o=0,r=2*Math.PI,i=0,a=Math.PI){super(),this.type="SphereGeometry",this.parameters={radius:e,widthSegments:t,heightSegments:n,phiStart:o,phiLength:r,thetaStart:i,thetaLength:a},t=Math.max(3,Math.floor(t)),n=Math.max(2,Math.floor(n));const s=Math.min(i+a,Math.PI);let l=0;const c=[],u=new Vector3,d=new Vector3,h=[],p=[],f=[],m=[];for(let h=0;h<=n;h++){const g=[],_=h/n;let A=0;0==h&&0==i?A=.5/t:h==n&&s==Math.PI&&(A=-.5/t);for(let n=0;n<=t;n++){const s=n/t;u.x=-e*Math.cos(o+s*r)*Math.sin(i+_*a),u.y=e*Math.cos(i+_*a),u.z=e*Math.sin(o+s*r)*Math.sin(i+_*a),p.push(u.x,u.y,u.z),d.copy(u).normalize(),f.push(d.x,d.y,d.z),m.push(s+A,1-_),g.push(l++)}c.push(g)}for(let e=0;e<n;e++)for(let o=0;o<t;o++){const t=c[e][o+1],r=c[e][o],a=c[e+1][o],l=c[e+1][o+1];(0!==e||i>0)&&h.push(t,r,l),(e!==n-1||s<Math.PI)&&h.push(r,a,l)}this.setIndex(h),this.setAttribute("position",new Float32BufferAttribute(p,3)),this.setAttribute("normal",new Float32BufferAttribute(f,3)),this.setAttribute("uv",new Float32BufferAttribute(m,2))}}class TeapotGeometry extends BufferGeometry{constructor(e=1,t=10,n=!0,o=!0,r=!0,i=!0,a=!0){const s=[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,3,16,17,18,7,19,20,21,11,22,23,24,15,25,26,27,18,28,29,30,21,31,32,33,24,34,35,36,27,37,38,39,30,40,41,0,33,42,43,4,36,44,45,8,39,46,47,12,12,13,14,15,48,49,50,51,52,53,54,55,56,57,58,59,15,25,26,27,51,60,61,62,55,63,64,65,59,66,67,68,27,37,38,39,62,69,70,71,65,72,73,74,68,75,76,77,39,46,47,12,71,78,79,48,74,80,81,52,77,82,83,56,56,57,58,59,84,85,86,87,88,89,90,91,92,93,94,95,59,66,67,68,87,96,97,98,91,99,100,101,95,102,103,104,68,75,76,77,98,105,106,107,101,108,109,110,104,111,112,113,77,82,83,56,107,114,115,84,110,116,117,88,113,118,119,92,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,123,136,137,120,127,138,139,124,131,140,141,128,135,142,143,132,132,133,134,135,144,145,146,147,148,149,150,151,68,152,153,154,135,142,143,132,147,155,156,144,151,157,158,148,154,159,160,68,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,164,177,178,161,168,179,180,165,172,181,182,169,176,183,184,173,173,174,175,176,185,186,187,188,189,190,191,192,193,194,195,196,176,183,184,173,188,197,198,185,192,199,200,189,196,201,202,193,203,203,203,203,204,205,206,207,208,208,208,208,209,210,211,212,203,203,203,203,207,213,214,215,208,208,208,208,212,216,217,218,203,203,203,203,215,219,220,221,208,208,208,208,218,222,223,224,203,203,203,203,221,225,226,204,208,208,208,208,224,227,228,209,209,210,211,212,229,230,231,232,233,234,235,236,237,238,239,240,212,216,217,218,232,241,242,243,236,244,245,246,240,247,248,249,218,222,223,224,243,250,251,252,246,253,254,255,249,256,257,258,224,227,228,209,252,259,260,229,255,261,262,233,258,263,264,237,265,265,265,265,266,267,268,269,270,271,272,273,92,119,118,113,265,265,265,265,269,274,275,276,273,277,278,279,113,112,111,104,265,265,265,265,276,280,281,282,279,283,284,285,104,103,102,95,265,265,265,265,282,286,287,266,285,288,289,270,95,94,93,92],l=[1.4,0,2.4,1.4,-.784,2.4,.784,-1.4,2.4,0,-1.4,2.4,1.3375,0,2.53125,1.3375,-.749,2.53125,.749,-1.3375,2.53125,0,-1.3375,2.53125,1.4375,0,2.53125,1.4375,-.805,2.53125,.805,-1.4375,2.53125,0,-1.4375,2.53125,1.5,0,2.4,1.5,-.84,2.4,.84,-1.5,2.4,0,-1.5,2.4,-.784,-1.4,2.4,-1.4,-.784,2.4,-1.4,0,2.4,-.749,-1.3375,2.53125,-1.3375,-.749,2.53125,-1.3375,0,2.53125,-.805,-1.4375,2.53125,-1.4375,-.805,2.53125,-1.4375,0,2.53125,-.84,-1.5,2.4,-1.5,-.84,2.4,-1.5,0,2.4,-1.4,.784,2.4,-.784,1.4,2.4,0,1.4,2.4,-1.3375,.749,2.53125,-.749,1.3375,2.53125,0,1.3375,2.53125,-1.4375,.805,2.53125,-.805,1.4375,2.53125,0,1.4375,2.53125,-1.5,.84,2.4,-.84,1.5,2.4,0,1.5,2.4,.784,1.4,2.4,1.4,.784,2.4,.749,1.3375,2.53125,1.3375,.749,2.53125,.805,1.4375,2.53125,1.4375,.805,2.53125,.84,1.5,2.4,1.5,.84,2.4,1.75,0,1.875,1.75,-.98,1.875,.98,-1.75,1.875,0,-1.75,1.875,2,0,1.35,2,-1.12,1.35,1.12,-2,1.35,0,-2,1.35,2,0,.9,2,-1.12,.9,1.12,-2,.9,0,-2,.9,-.98,-1.75,1.875,-1.75,-.98,1.875,-1.75,0,1.875,-1.12,-2,1.35,-2,-1.12,1.35,-2,0,1.35,-1.12,-2,.9,-2,-1.12,.9,-2,0,.9,-1.75,.98,1.875,-.98,1.75,1.875,0,1.75,1.875,-2,1.12,1.35,-1.12,2,1.35,0,2,1.35,-2,1.12,.9,-1.12,2,.9,0,2,.9,.98,1.75,1.875,1.75,.98,1.875,1.12,2,1.35,2,1.12,1.35,1.12,2,.9,2,1.12,.9,2,0,.45,2,-1.12,.45,1.12,-2,.45,0,-2,.45,1.5,0,.225,1.5,-.84,.225,.84,-1.5,.225,0,-1.5,.225,1.5,0,.15,1.5,-.84,.15,.84,-1.5,.15,0,-1.5,.15,-1.12,-2,.45,-2,-1.12,.45,-2,0,.45,-.84,-1.5,.225,-1.5,-.84,.225,-1.5,0,.225,-.84,-1.5,.15,-1.5,-.84,.15,-1.5,0,.15,-2,1.12,.45,-1.12,2,.45,0,2,.45,-1.5,.84,.225,-.84,1.5,.225,0,1.5,.225,-1.5,.84,.15,-.84,1.5,.15,0,1.5,.15,1.12,2,.45,2,1.12,.45,.84,1.5,.225,1.5,.84,.225,.84,1.5,.15,1.5,.84,.15,-1.6,0,2.025,-1.6,-.3,2.025,-1.5,-.3,2.25,-1.5,0,2.25,-2.3,0,2.025,-2.3,-.3,2.025,-2.5,-.3,2.25,-2.5,0,2.25,-2.7,0,2.025,-2.7,-.3,2.025,-3,-.3,2.25,-3,0,2.25,-2.7,0,1.8,-2.7,-.3,1.8,-3,-.3,1.8,-3,0,1.8,-1.5,.3,2.25,-1.6,.3,2.025,-2.5,.3,2.25,-2.3,.3,2.025,-3,.3,2.25,-2.7,.3,2.025,-3,.3,1.8,-2.7,.3,1.8,-2.7,0,1.575,-2.7,-.3,1.575,-3,-.3,1.35,-3,0,1.35,-2.5,0,1.125,-2.5,-.3,1.125,-2.65,-.3,.9375,-2.65,0,.9375,-2,-.3,.9,-1.9,-.3,.6,-1.9,0,.6,-3,.3,1.35,-2.7,.3,1.575,-2.65,.3,.9375,-2.5,.3,1.125,-1.9,.3,.6,-2,.3,.9,1.7,0,1.425,1.7,-.66,1.425,1.7,-.66,.6,1.7,0,.6,2.6,0,1.425,2.6,-.66,1.425,3.1,-.66,.825,3.1,0,.825,2.3,0,2.1,2.3,-.25,2.1,2.4,-.25,2.025,2.4,0,2.025,2.7,0,2.4,2.7,-.25,2.4,3.3,-.25,2.4,3.3,0,2.4,1.7,.66,.6,1.7,.66,1.425,3.1,.66,.825,2.6,.66,1.425,2.4,.25,2.025,2.3,.25,2.1,3.3,.25,2.4,2.7,.25,2.4,2.8,0,2.475,2.8,-.25,2.475,3.525,-.25,2.49375,3.525,0,2.49375,2.9,0,2.475,2.9,-.15,2.475,3.45,-.15,2.5125,3.45,0,2.5125,2.8,0,2.4,2.8,-.15,2.4,3.2,-.15,2.4,3.2,0,2.4,3.525,.25,2.49375,2.8,.25,2.475,3.45,.15,2.5125,2.9,.15,2.475,3.2,.15,2.4,2.8,.15,2.4,0,0,3.15,.8,0,3.15,.8,-.45,3.15,.45,-.8,3.15,0,-.8,3.15,0,0,2.85,.2,0,2.7,.2,-.112,2.7,.112,-.2,2.7,0,-.2,2.7,-.45,-.8,3.15,-.8,-.45,3.15,-.8,0,3.15,-.112,-.2,2.7,-.2,-.112,2.7,-.2,0,2.7,-.8,.45,3.15,-.45,.8,3.15,0,.8,3.15,-.2,.112,2.7,-.112,.2,2.7,0,.2,2.7,.45,.8,3.15,.8,.45,3.15,.112,.2,2.7,.2,.112,2.7,.4,0,2.55,.4,-.224,2.55,.224,-.4,2.55,0,-.4,2.55,1.3,0,2.55,1.3,-.728,2.55,.728,-1.3,2.55,0,-1.3,2.55,1.3,0,2.4,1.3,-.728,2.4,.728,-1.3,2.4,0,-1.3,2.4,-.224,-.4,2.55,-.4,-.224,2.55,-.4,0,2.55,-.728,-1.3,2.55,-1.3,-.728,2.55,-1.3,0,2.55,-.728,-1.3,2.4,-1.3,-.728,2.4,-1.3,0,2.4,-.4,.224,2.55,-.224,.4,2.55,0,.4,2.55,-1.3,.728,2.55,-.728,1.3,2.55,0,1.3,2.55,-1.3,.728,2.4,-.728,1.3,2.4,0,1.3,2.4,.224,.4,2.55,.4,.224,2.55,.728,1.3,2.55,1.3,.728,2.55,.728,1.3,2.4,1.3,.728,2.4,0,0,0,1.425,0,0,1.425,.798,0,.798,1.425,0,0,1.425,0,1.5,0,.075,1.5,.84,.075,.84,1.5,.075,0,1.5,.075,-.798,1.425,0,-1.425,.798,0,-1.425,0,0,-.84,1.5,.075,-1.5,.84,.075,-1.5,0,.075,-1.425,-.798,0,-.798,-1.425,0,0,-1.425,0,-1.5,-.84,.075,-.84,-1.5,.075,0,-1.5,.075,.798,-1.425,0,1.425,-.798,0,.84,-1.5,.075,1.5,-.84,.075];super(),t=Math.max(2,Math.floor(t));const c=3.15*(a?1:1.3)/2,u=e/c;let d=n?(8*t-4)*t:0;d+=o?(16*t-4)*t:0,d+=r?40*t*t:0;const h=new Uint32Array(3*d);let p=n?4:0;p+=o?8:0,p+=r?20:0,p*=(t+1)*(t+1);const f=new Float32Array(3*p),m=new Float32Array(3*p),g=new Float32Array(2*p),_=new Matrix4;_.set(-1,3,-3,1,3,-6,3,0,-3,3,0,0,1,0,0,0);const A=[],v=[],x=[],y=[],b=[],C=[],S=[],E=[],M=[],T=new Vector3;let w,I,R,L,B=0,P=0;const N=new Vector3,D=new Matrix4,O=new Matrix4,F=new Vector4,V=new Vector4,U=new Vector4,G=new Vector4,z=new Vector3,k=new Vector3,W=_.clone();W.transpose();const Q=(e,t,n)=>!(f[3*e]===f[3*t]&&f[3*e+1]===f[3*t+1]&&f[3*e+2]===f[3*t+2]||f[3*e]===f[3*n]&&f[3*e+1]===f[3*n+1]&&f[3*e+2]===f[3*n+2]||f[3*t]===f[3*n]&&f[3*t+1]===f[3*n+1]&&f[3*t+2]===f[3*n+2]);for(let e=0;e<3;e++)C[e]=new Matrix4;const H=n?32:28,X=t+1;let Y=0,j=0,$=0,K=0,q=0;for(let e=r?0:20;e<H;e++)if(o||e<20||e>=28){for(let t=0;t<3;t++){for(let n=0;n<4;n++)for(let o=0;o<4;o++)A[4*o+n]=l[3*s[16*e+4*n+o]+t],i&&e>=20&&e<28&&2!==t&&(A[4*o+n]*=1.077),a||2!==t||(A[4*o+n]*=1.3);D.set(A[0],A[1],A[2],A[3],A[4],A[5],A[6],A[7],A[8],A[9],A[10],A[11],A[12],A[13],A[14],A[15]),O.multiplyMatrices(D,_),C[t].multiplyMatrices(W,O)}for(let e=0;e<=t;e++){const n=e/t;for(let e=0;e<=t;e++){const o=e/t;for(L=4,I=R=1;L--;)v[L]=I,x[L]=R,I*=n,R*=o,3===L?(y[L]=b[L]=0,B=P=1):(y[L]=B*(3-L),b[L]=P*(3-L),B*=n,P*=o);F.fromArray(v),V.fromArray(x),U.fromArray(y),G.fromArray(b);for(let e=0;e<3;e++)w=F.clone(),w.applyMatrix4(C[e]),S[e]=w.dot(V),w=U.clone(),w.applyMatrix4(C[e]),E[e]=w.dot(V),w=F.clone(),w.applyMatrix4(C[e]),M[e]=w.dot(G);z.fromArray(E),k.fromArray(M),T.crossVectors(k,z),T.normalize(),0===S[0]&&0===S[1]?N.set(0,S[2]>c?1:-1,0):N.set(T.x,T.z,-T.y),f[j++]=u*S[0],f[j++]=u*(S[2]-c),f[j++]=-u*S[1],m[$++]=N.x,m[$++]=N.y,m[$++]=N.z,g[K++]=1-o,g[K++]=1-n}}for(let e=0;e<t;e++)for(let n=0;n<t;n++){const t=Y*X*X+e*X+n,o=t+1,r=o+X,i=t+X;Q(t,o,r)&&(h[q++]=t,h[q++]=o,h[q++]=r),Q(t,r,i)&&(h[q++]=t,h[q++]=r,h[q++]=i)}Y++}this.setIndex(new BufferAttribute(h,1)),this.setAttribute("position",new BufferAttribute(f,3)),this.setAttribute("normal",new BufferAttribute(m,3)),this.setAttribute("uv",new BufferAttribute(g,2)),this.computeBoundingSphere()}}class TextGeometry extends ExtrudeGeometry{constructor(e,t={}){const n=t.font;if(!n||!n.isFont)return console.error("v3d.TextGeometry: font parameter is not an instance of v3d.Font."),new BufferGeometry;void 0===t.alignX&&(t.alignX="left"),void 0===t.alignY&&(t.alignY="topBaseline"),void 0===t.lineHeight&&(t.lineHeight=-1),void 0===t.scaledEmSize&&(t.scaledEmSize=!1);const o=n.generateShapes(e,t.size,t.alignX,t.alignY,t.lineHeight,t.scaledEmSize);t.depth=void 0!==t.height?t.height:50,void 0===t.bevelThickness&&(t.bevelThickness=10),void 0===t.bevelSize&&(t.bevelSize=8),void 0===t.bevelEnabled&&(t.bevelEnabled=!1),super(o,t),this.type="TextGeometry",this.parameters={text:e,parameters:t}}cloneWithText(e){const t=this.parameters.parameters;return new TextGeometry(e,{font:t.font,size:t.size,height:t.height,curveSegments:t.curveSegments,bevelEnabled:t.bevelEnabled,bevelThickness:t.bevelThickness,bevelSize:t.bevelSize,alignX:t.alignX,alignY:t.alignY,lineHeight:t.lineHeight,scaledEmSize:t.scaledEmSize})}}class TorusGeometry extends BufferGeometry{constructor(e=1,t=.4,n=12,o=48,r=2*Math.PI){super(),this.type="TorusGeometry",this.parameters={radius:e,tube:t,radialSegments:n,tubularSegments:o,arc:r},n=Math.floor(n),o=Math.floor(o);const i=[],a=[],s=[],l=[],c=new Vector3,u=new Vector3,d=new Vector3;for(let i=0;i<=n;i++)for(let h=0;h<=o;h++){const p=h/o*r,f=i/n*Math.PI*2;u.x=(e+t*Math.cos(f))*Math.cos(p),u.y=(e+t*Math.cos(f))*Math.sin(p),u.z=t*Math.sin(f),a.push(u.x,u.y,u.z),c.x=e*Math.cos(p),c.y=e*Math.sin(p),d.subVectors(u,c).normalize(),s.push(d.x,d.y,d.z),l.push(h/o),l.push(i/n)}for(let e=1;e<=n;e++)for(let t=1;t<=o;t++){const n=(o+1)*e+t-1,r=(o+1)*(e-1)+t-1,a=(o+1)*(e-1)+t,s=(o+1)*e+t;i.push(n,r,s),i.push(r,a,s)}this.setIndex(i),this.setAttribute("position",new Float32BufferAttribute(a,3)),this.setAttribute("normal",new Float32BufferAttribute(s,3)),this.setAttribute("uv",new Float32BufferAttribute(l,2))}}class TubeGeometry extends BufferGeometry{constructor(e=new QuadraticBezierCurve3(new Vector3(-1,-1,0),new Vector3(-1,1,0),new Vector3(1,1,0)),t=64,n=1,o=8,r=!1){super(),this.type="TubeGeometry",this.parameters={path:e,tubularSegments:t,radius:n,radialSegments:o,closed:r};const i=e.computeFrenetFrames(t,r);this.tangents=i.tangents,this.normals=i.normals,this.binormals=i.binormals;const a=new Vector3,s=new Vector3,l=new Vector2;let c=new Vector3;const u=[],d=[],h=[],p=[];function f(r){c=e.getPointAt(r/t,c);const l=i.normals[r],h=i.binormals[r];for(let e=0;e<=o;e++){const t=e/o*Math.PI*2,r=Math.sin(t),i=-Math.cos(t);s.x=i*l.x+r*h.x,s.y=i*l.y+r*h.y,s.z=i*l.z+r*h.z,s.normalize(),d.push(s.x,s.y,s.z),a.x=c.x+n*s.x,a.y=c.y+n*s.y,a.z=c.z+n*s.z,u.push(a.x,a.y,a.z)}}!function(){for(let e=0;e<t;e++)f(e);f(!1===r?t:0),function(){for(let e=0;e<=t;e++)for(let n=0;n<=o;n++)l.x=e/t,l.y=n/o,h.push(l.x,l.y)}(),function(){for(let e=1;e<=t;e++)for(let t=1;t<=o;t++){const n=(o+1)*(e-1)+(t-1),r=(o+1)*e+(t-1),i=(o+1)*e+t,a=(o+1)*(e-1)+t;p.push(n,r,a),p.push(r,i,a)}}()}(),this.setIndex(p),this.setAttribute("position",new Float32BufferAttribute(u,3)),this.setAttribute("normal",new Float32BufferAttribute(d,3)),this.setAttribute("uv",new Float32BufferAttribute(h,2))}}class WireframeGeometry extends BufferGeometry{constructor(e=null){if(super(),this.type="WireframeGeometry",this.parameters={geometry:e},null!==e){const t=[],n=new Set,o=new Vector3,r=new Vector3;if(null!==e.index){const i=e.attributes.position,a=e.index;let s=e.groups;0===s.length&&(s=[{start:0,count:a.count,materialIndex:0}]);for(let e=0,l=s.length;e<l;++e){const l=s[e],c=l.start;for(let e=c,s=c+l.count;e<s;e+=3)for(let s=0;s<3;s++){const l=a.getX(e+s),c=a.getX(e+(s+1)%3);o.fromBufferAttribute(i,l),r.fromBufferAttribute(i,c),!0===isUniqueEdge(o,r,n)&&(t.push(o.x,o.y,o.z),t.push(r.x,r.y,r.z))}}}else{const i=e.attributes.position;for(let e=0,a=i.count/3;e<a;e++)for(let a=0;a<3;a++){const s=3*e+a,l=3*e+(a+1)%3;o.fromBufferAttribute(i,s),r.fromBufferAttribute(i,l),!0===isUniqueEdge(o,r,n)&&(t.push(o.x,o.y,o.z),t.push(r.x,r.y,r.z))}}this.setAttribute("position",new Float32BufferAttribute(t,3))}}}function isUniqueEdge(e,t,n){const o=`${e.x},${e.y},${e.z}-${t.x},${t.y},${t.z}`,r=`${t.x},${t.y},${t.z}-${e.x},${e.y},${e.z}`;return!0!==n.has(o)&&!0!==n.has(r)&&(n.add(o),n.add(r),!0)}class ShadowMaterial extends Material{constructor(e){super(),this.isShadowMaterial=!0,this.type="ShadowMaterial",this.color=new Color(0),this.transparent=!0,this.fog=!0,this.setValues(e)}copy(e){return super.copy(e),this.color.copy(e.color),this.fog=e.fog,this}}class MeshStandardMaterial extends Material{constructor(e){super(),this.isMeshStandardMaterial=!0,this.defines={STANDARD:""},this.type="MeshStandardMaterial",this.color=new Color(16777215),this.roughness=1,this.metalness=0,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Color(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.roughnessMap=null,this.metalnessMap=null,this.alphaMap=null,this.envMap=null,this.envMapIntensity=1,this.wireframe=!1,this.wireframeLinewidth=1,this.flatShading=!1,this.fog=!0,this.envMapParallaxType=0,this.envMapParallaxMatrix=new Matrix4,this.envMapParallaxMatrixInv=new Matrix4,this.setValues(e)}copy(e){return super.copy(e),this.defines={STANDARD:""},this.color.copy(e.color),this.roughness=e.roughness,this.metalness=e.metalness,this.map=e.map,this.lightMap=e.lightMap,this.lightMapIntensity=e.lightMapIntensity,this.aoMap=e.aoMap,this.aoMapIntensity=e.aoMapIntensity,this.emissive.copy(e.emissive),this.emissiveMap=e.emissiveMap,this.emissiveIntensity=e.emissiveIntensity,this.bumpMap=e.bumpMap,this.bumpScale=e.bumpScale,this.normalMap=e.normalMap,this.normalMapType=e.normalMapType,this.normalScale.copy(e.normalScale),this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.roughnessMap=e.roughnessMap,this.metalnessMap=e.metalnessMap,this.alphaMap=e.alphaMap,this.envMap=e.envMap,this.envMapIntensity=e.envMapIntensity,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.flatShading=e.flatShading,this.fog=e.fog,this.envMapParallaxType=e.envMapParallaxType,this.envMapParallaxMatrix.copy(e.envMapParallaxMatrix),this.envMapParallaxMatrixInv.copy(e.envMapParallaxMatrixInv),this}}class MeshNormalMaterial extends Material{constructor(e){super(),this.isMeshNormalMaterial=!0,this.type="MeshNormalMaterial",this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.flatShading=!1,this.setValues(e)}copy(e){return super.copy(e),this.bumpMap=e.bumpMap,this.bumpScale=e.bumpScale,this.normalMap=e.normalMap,this.normalMapType=e.normalMapType,this.normalScale.copy(e.normalScale),this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.flatShading=e.flatShading,this}}class MeshLambertMaterial extends Material{constructor(e){super(),this.isMeshLambertMaterial=!0,this.type="MeshLambertMaterial",this.color=new Color(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Color(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.alphaMap=null,this.envMap=null,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.flatShading=!1,this.fog=!0,this.setValues(e)}copy(e){return super.copy(e),this.color.copy(e.color),this.map=e.map,this.lightMap=e.lightMap,this.lightMapIntensity=e.lightMapIntensity,this.aoMap=e.aoMap,this.aoMapIntensity=e.aoMapIntensity,this.emissive.copy(e.emissive),this.emissiveMap=e.emissiveMap,this.emissiveIntensity=e.emissiveIntensity,this.bumpMap=e.bumpMap,this.bumpScale=e.bumpScale,this.normalMap=e.normalMap,this.normalMapType=e.normalMapType,this.normalScale.copy(e.normalScale),this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.alphaMap=e.alphaMap,this.envMap=e.envMap,this.combine=e.combine,this.reflectivity=e.reflectivity,this.refractionRatio=e.refractionRatio,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.flatShading=e.flatShading,this.fog=e.fog,this}}class LineDashedMaterial extends LineBasicMaterial{constructor(e){super(),this.isLineDashedMaterial=!0,this.type="LineDashedMaterial",this.scale=1,this.dashSize=3,this.gapSize=1,this.setValues(e)}copy(e){return super.copy(e),this.scale=e.scale,this.dashSize=e.dashSize,this.gapSize=e.gapSize,this}}class MeshLineMaterial extends RawShaderMaterial{constructor(e){super(),this.isMeshLineMaterial=!0,this.type="MeshLineMaterial",this.lineWidth=1,this.sizeAttenuation=1,this.color=new Color(16777215),this.opacity=1,this.useMap=0,this.map=null,this.useAlphaMap=0,this.alphaMap=null,this.visibility=1,this.alphaTest=0,this.repeat=new Vector2(1,1),this.uniforms={lineWidth:{value:1},sizeAttenuation:{value:1},color:{value:new Color(16777215)},opacity:{value:1},useMap:{value:0},map:{value:null},alphaMap:{value:null},useAlphaMap:{value:0},visibility:{value:1},alphaTest:{value:0},repeat:{value:new Vector2(1,1)}},this.vertexShader=ShaderChunk.raw_meshline_vert,this.fragmentShader=ShaderChunk.raw_meshline_frag,this.setValues(e)}copy(e){return super.copy(e),this.lineWidth=e.lineWidth,this.sizeAttenuation=e.sizeAttenuation,this.color.copy(e.color),this.opacity=e.opacity,this.useMap=e.useMap,this.map=e.map,this.useAlphaMap=e.useAlphaMap,this.alphaMap=e.alphaMap,this.visibility=e.visibility,this.alphaTest=e.alphaTest,this.repeat.copy(e.repeat),this}}class MeshMaskMaterial extends Material{constructor(e){super(),this.isMeshMaskMaterial=!0,this.type="MeshMaskMaterial",this.side=2,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.lights=!1,this.cameraNearFar=null,this.depthTexture=null,this.textureMatrix=null,this.setValues(e)}copy(e){return super.copy(e),this.depthPacking=e.depthPacking,this.map=e.map,this.alphaMap=e.alphaMap,this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,e.cameraNearFar&&(this.cameraNearFar=e.cameraNearFar.clone()),e.textureMatrix&&(this.textureMatrix=e.textureMatrix.clone()),e.depthTexture&&(this.depthTexture=e.depthTexture),this}}class Interpolant{constructor(e,t,n,o){this.parameterPositions=e,this._cachedIndex=0,this.resultBuffer=void 0!==o?o:new t.constructor(n),this.sampleValues=t,this.valueSize=n,this.settings=null,this.DefaultSettings_={}}evaluate(e){const t=this.parameterPositions;let n=this._cachedIndex,o=t[n],r=t[n-1];e:{t:{let i;n:{o:if(!(e<o)){for(let i=n+2;;){if(void 0===o){if(e<r)break o;return n=t.length,this._cachedIndex=n,this.copySampleValue_(n-1)}if(n===i)break;if(r=o,o=t[++n],e<o)break t}i=t.length;break n}if(!(e>=r)){const a=t[1];e<a&&(n=2,r=a);for(let i=n-2;;){if(void 0===r)return this._cachedIndex=0,this.copySampleValue_(0);if(n===i)break;if(o=r,r=t[--n-1],e>=r)break t}i=n,n=0;break n}break e}for(;n<i;){const o=n+i>>>1;e<t[o]?i=o:n=o+1}if(o=t[n],r=t[n-1],void 0===r)return this._cachedIndex=0,this.copySampleValue_(0);if(void 0===o)return n=t.length,this._cachedIndex=n,this.copySampleValue_(n-1)}this._cachedIndex=n,this.intervalChanged_(n,r,o)}return this.interpolate_(n,r,e,o)}getSettings_(){return this.settings||this.DefaultSettings_}copySampleValue_(e){const t=this.resultBuffer,n=this.sampleValues,o=this.valueSize,r=e*o;for(let e=0;e!==o;++e)t[e]=n[r+e];return t}interpolate_(){throw new Error("call to abstract method")}intervalChanged_(){}}class DiscreteInterpolant extends Interpolant{constructor(e,t,n,o){super(e,t,n,o)}interpolate_(e){return this.copySampleValue_(e-1)}}const StackNode=function(e){this.value=e,this.next=null},Stack=function(){this.N=0,this.first=null};Stack.prototype.push=function(e){this.first=this._push(this.first,e)},Stack.prototype._push=function(e,t){if(null==e)return this.N++,new StackNode(t);const n=e;return this.N++,(e=new StackNode(t)).next=n,e},Stack.prototype.pop=function(){if(null==this.first)return;const e=this.first,t=e.value;return this.first=e.next,this.N--,t},Stack.prototype.size=function(){return this.N},Stack.prototype.isEmpty=function(){return 0==this.N},Stack.prototype.peep=function(){if(null!=this.first)return this.first.value},Stack.prototype.toArray=function(){const e=[];let t=this.first;for(;null!=t;)e.push(t.value),t=t.next;return e};const LinkMapNode=function(e){this.value=e,this.prev=null,this.next=null},LinkMap=function(){this.first=null,this.last=null,this.map={}};LinkMap.prototype.push=function(e,t){this.map[t]=e,null===this.first?(this.first=e,this.last=e):(this.last.next=e,e.prev=this.last,this.last=e)},LinkMap.prototype.removeNodeByKey=function(e){const t=this.map[e],n=t.prev,o=t.next;null!==n&&null!==o?(n.next=o,o.prev=n):null===n&&null!==o?(this.first=o,o.prev=null):null!==n&&null===o?(this.last=n,n.next=null):(this.first=null,this.last=null),delete this.map[e]};const DiGraph=function(e=0){this.V=e,this.adjList=[],this.nodeInfo=[],this.edges={};for(let t=0;t<e;++t)this.adjList.push([]),this.nodeInfo.push({})};DiGraph.prototype.removeAll=function(){this.V=0,this.adjList=[],this.nodeInfo=[],this.edges={}},DiGraph.prototype.addNode=function(e){e=e||{},this.V++,this.adjList.push([]),this.nodeInfo.push(e)},DiGraph.prototype.addNewEdge=function(e,t){this.adjList[e].push(t);const n=e+"_"+t,o=new Edge(e,t,0);return this.edges[n]=o,o},DiGraph.prototype.addEdge=function(e){const t=e.v,n=e.w;this.adjList[t].push(n);const o=t+"_"+n;this.edges[o]=e},DiGraph.prototype.removeEdge=function(e,t){const n=this.adjList[e];for(let e=0;e<n.length;e++)n[e]==t&&(n.splice(e,1),e--);const o=e+"_"+t;o in this.edges&&delete this.edges[o]},DiGraph.prototype.edge=function(e,t){const n=e+"_"+t;return n in this.edges?this.edges[n]:null},DiGraph.prototype.adj=function(e){return this.adjList[e]},DiGraph.prototype.node=function(e){return this.nodeInfo[e]},DiGraph.prototype.nodeIndex=function(e){for(let t=0;t<this.V;++t)if(this.nodeInfo[t]==e)return t;return-1},DiGraph.prototype.reverse=function(){const e=new DiGraph(this.V);for(let t=0;t<this.V;++t){const n=this.adjList[t];for(let o=0;o<n.length;++o){const r=n[o];e.addNewEdge(r,t)}}return e},DiGraph.prototype.len=function(){return this.V},DiGraph.prototype.findInEdges=function(e){const t=[];for(let n=0;n<this.V;n++){const o=this.adjList[n];for(let r=0;r<o.length;r++)o[r]==e&&t.push(this.edge(n,e))}return t},DiGraph.prototype.findOutEdges=function(e){const t=[],n=this.adjList[e];for(let o=0;o<n.length;o++)t.push(this.edge(e,n[o]));return t},DiGraph.prototype.disconnect=function(e,t){this.adjList[e].splice(0);for(let t=0;t<this.V;t++){const n=this.adjList[t];for(let t=0;t<n.length;t++)n[t]==e&&(n.splice(t,1),t--);let o=t+"_"+e;o in this.edges&&delete this.edges[o],o=e+"_"+t,o in this.edges&&delete this.edges[o]}if(t){const t=new DiGraph(this.V-1);for(let n=0;n<this.V;n++){if(n==e)continue;const o=this.adjList[n];for(let r=0;r<o.length;r++){const i=o[r],a=n>e?n-1:n,s=i>e?i-1:i,l=this.edge(n,i).copy();l.v=a,l.w=s,t.addEdge(l)}}this.V--,this.adjList=t.adjList,this.nodeInfo.splice(e,1),this.edges=t.edges}},DiGraph.prototype.insert=function(e,t,n,o=e=>e,r=e=>e){const i=this.V,a=e.V;for(let t=0;t<a;t++){this.adjList.push([]),this.nodeInfo.push(o(e.nodeInfo[t]));const n=e.adjList[t];for(let o=0;o<n.length;o++){const a=n[o],s=e.edge(t,a).copy(r);s.v+=i,s.w+=i,this.addEdge(s)}}this.V+=a;for(let e=0;e<t.length;e++){const n=t[e].copy(r);n.w+=i,this.addEdge(n)}for(let e=0;e<n.length;e++){const t=n[e].copy(r);t.v+=i,this.addEdge(t)}},DiGraph.prototype.vis=function(e){e=e||function(e,t){return String(e)};let t="digraph G {";for(let n=0;n<this.V;n++){t+=n+' [label="'+e(n,this.nodeInfo[n])+'"];';const o=this.adjList[n];for(let e=0;e<o.length;e++){t+=n+" -> "+o[e]+";"}}t+="}",console.log(t)};const Edge=function(e,t,n=0){this.v=e,this.w=t,this.weight=n};Edge.prototype.either=function(){return this.v},Edge.prototype.other=function(e){return e==this.v?this.w:this.v},Edge.prototype.from=function(){return this.v},Edge.prototype.to=function(){return this.w},Edge.prototype.copy=function(e=e=>e){const t=new Edge(0,0,0);for(const n in this)this.hasOwnProperty(n)&&("object"==typeof this[n]?t[n]=e(this[n]):t[n]=this[n]);return t};const WeightedGraph=function(e){this.V=e,this.adjList=[],this.nodeInfo=[];for(let t=0;t<e;++t)this.adjList.push([]),this.nodeInfo.push({})};WeightedGraph.prototype.adj=function(e){return this.adjList[e]},WeightedGraph.prototype.edge=function(e,t){const n=this.adjList[e];for(let o=0;o<n.length;++o){if(n[o].other(e)==t)return n[o]}return null},WeightedGraph.prototype.node=function(e){return this.nodeInfo[e]},WeightedGraph.prototype.addNewEdge=function(e){const t=e.either(),n=e.other(t);this.adjList[t].push(e),this.adjList[n].push(e)};const WeightedDiGraph=function(e){WeightedGraph.call(this,e)};(WeightedDiGraph.prototype=Object.create(WeightedGraph.prototype)).addNewEdge=function(e){const t=e.from();this.adjList[t].push(e)},WeightedDiGraph.prototype.edge=function(e,t){const n=this.adjList[e];for(let o=0;o<n.length;++o){if(n[o].other(e)==t)return n[o]}return null},WeightedDiGraph.prototype.toDiGraph=function(){const e=new DiGraph(this.V);for(let t=0;t<this.V;++t){const n=this.adjList[t];for(let o=0;o<n.length;++o){const r=n[o].other(t);e.addNewEdge(t,r)}}return e};const DepthFirstSearch=function(e,t){this.s=t;const n=e.V;this.marked=[],this.edgeTo=[];for(let e=0;e<n;++e)this.marked.push(!1),this.edgeTo.push(-1);this.dfs(e,t)};DepthFirstSearch.prototype.dfs=function(e,t){this.marked[t]=!0;const n=e.adj(t);for(let o=0;o<n.length;++o){const r=n[o];this.marked[r]||(this.edgeTo[r]=t,this.dfs(e,r))}},DepthFirstSearch.prototype.hasPathTo=function(e){return this.marked[e]},DepthFirstSearch.prototype.pathTo=function(e){const t=new Stack;if(e==this.s)return[e];for(let n=e;n!=this.s;n=this.edgeTo[n])t.push(n);return t.push(this.s),t.toArray()};const TopologicalSort=function(e){this.postOrder=new Stack,this.marked=[];const t=e.V;for(let e=0;e<t;++e)this.marked.push(!1);for(let n=0;n<t;++n)this.marked[n]||this.dfs(e,n)};TopologicalSort.prototype.dfs=function(e,t){this.marked[t]=!0;const n=e.adj(t);for(let t=0;t<n.length;++t){const o=n[t];this.marked[o]||this.dfs(e,o)}this.postOrder.push(t)},TopologicalSort.prototype.order=function(){return this.postOrder.toArray()};var GraphUtils=Object.freeze({__proto__:null,DepthFirstSearch:DepthFirstSearch,DiGraph:DiGraph,Edge:Edge,LinkMap:LinkMap,LinkMapNode:LinkMapNode,TopologicalSort:TopologicalSort});class LinearInterpolant extends Interpolant{constructor(e,t,n,o){super(e,t,n,o)}interpolate_(e,t,n,o){const r=this.resultBuffer,i=this.sampleValues,a=this.valueSize,s=e*a,l=s-a,c=(n-t)/(o-t),u=1-c;for(let e=0;e!==a;++e)r[e]=i[l+e]*u+i[s+e]*c;return r}}class Spherical{constructor(e=1,t=0,n=0){return this.radius=e,this.phi=t,this.theta=n,this}set(e,t,n){return this.radius=e,this.phi=t,this.theta=n,this}copy(e){return this.radius=e.radius,this.phi=e.phi,this.theta=e.theta,this}makeSafe(){const e=1e-6;return this.phi=Math.max(e,Math.min(Math.PI-e,this.phi)),this}setFromVector3(e){return this.setFromCartesianCoords(e.x,e.y,e.z)}setFromCartesianCoords(e,t,n){return this.radius=Math.sqrt(e*e+t*t+n*n),0===this.radius?(this.theta=0,this.phi=0):(this.theta=Math.atan2(e,n),this.phi=Math.acos(clamp(t/this.radius,-1,1))),this}clone(){return(new this.constructor).copy(this)}}var datasetXYZ1=[-1.117001,-.1867262,-11.13505,12.59865,-.03937339,1.167571,.007100686,3.592678,.6083296,-1.152006,-.1926669,6.152049,-4.770802,-.08704701,.7483626,.03372718,4.464592,.4036546,-1.072371,-.2696632,.2816168,1.820571,-.3742666,2.080607,-.07675295,-2.835366,1.129329,-1.109935,-.1532764,1.198787,-.9015183,.005173015,.5749178,.1075633,4.387949,.2650413,-1.052297,-.2229452,1.952347,.5727205,-4.88507,1.984016,-.1106197,-.4898361,.8907873,-1.070108,-.1600465,1.593886,-4479251e-11,-3.306541,.9390193,.09513168,2.343583,.5335404,-1.113253,-.16996,-10.38822,11.37513,-.04040911,1.037455,.04991792,4.801919,.630271,-1.135747,-.1678594,4.970755,-4.43023,-.06657408,.3636161,.1558009,6.01337,.3959601,-1.095892,-.2732595,.7666496,1.350731,-.4401401,2.470135,-.1707929,-3.260793,1.170337,-1.073668,-.02603929,-.1944589,.4575207,.6878164,-.139077,.3690299,7.885781,.1877694,-1.070091,-.2798957,2.338478,-2.647221,-7.387808,2.32921,-.1644639,-2.00371,.9874527,-1.06712,-.1418866,1.25409,6.053048,-2.918892,.5322812,.1613053,3.018161,.527409,-1.129483,-.1890619,-9.065101,9.659923,-.03607819,.8314359,.08181661,4.768868,.6339777,-1.14642,-.1883579,3.309173,-3.127882,-.06938176,.3987113,.1400581,6.283042,.5267076,-1.128348,-.2641305,1.223176,.05514952,-.3490649,1.997784,-.04123709,-2.251251,.9483466,-1.02582,.0140469,-1.187406,2.7299,.5877588,-.276114,.4602633,8.305125,.3945001,-1.083957,-.2606679,2.207108,-7.202803,-5.968103,2.129455,-.07789512,-1.137688,.8871769,-1.062465,-.1512189,1.042881,14.27839,-4.242214,.40381,.199778,2.814449,.5803196,-1.175099,-.2410789,-11.08587,11.33404,-.018193,.6772942,.09605043,4.231166,.6239972,-1.224207,-.2883527,3.002206,-2.649612,-.04795418,.4984398,.03251434,4.851611,.6551019,-1.136955,-.2423048,1.058823,-.2489236,-.2462179,1.93314,.09106828,-.1905869,.8171065,-1.014535,-.0082625,-1.448017,2.295788,.3510334,-1.477418,.5432449,5.762796,.4908751,-1.070666,-.237978,1.844589,-5.442448,-4.012768,2.945275,.009854725,.08455959,.814503,-1.071525,-.1777132,.807659,9.925865,-3.324623,-.6367437,.2844581,2.248384,.6544022,-1.218818,-.2952382,-13.45975,13.47153,-.006814585,.5079068,.119723,3.776949,.5836961,-1.409868,-.511433,2.776539,-2.039001,-.02673769,.4145288,.0007829342,2.275883,.6629691,-1.069151,-.09434247,.7293972,-1.222473,-.1533461,2.160357,.04626837,3.852415,.859357,-1.021306,-.1149551,-1.108414,4.178343,.4013665,-2.222814,.6929462,1.392652,.4401662,-1.074251,-.2224002,1.372356,-8.858704,-3.92266,3.020018,-.01458724,1.511186,.8288064,-1.062048,-.1526582,.4921067,14.85522,-3.229936,-.8426604,.3916243,2.678994,.6689264,-1.257023,-.33647,-15.27795,15.04223,.002717715,.302991,.1636851,3.561663,.5283161,-1.635124,-.7329993,3.523939,-2.566337,-.01902543,.5505483,-.06242176,1.065992,.6654236,-.9295823,.04845834,-.299299,-.2001327,-.08019339,1.807806,.09020277,5.095372,.8639936,-1.09374,-.2148608,-.521624,2.119777,.09506454,-1.831439,.6961204,.1102084,.4384319,-1.044181,-.1849257,.9071246,-4.648901,-2.279385,2.356502,-.04169147,1.932557,.829655,-1.061451,-.1458745,.2952267,8.967214,-3.726228,-.5022316,.5684877,3.102347,.6658443,-1.332391,-.4127769,-9.328643,9.046194,.003457775,.3377425,.1530909,3.301209,.4997917,-1.932002,-.9947777,-2.042329,3.58694,-.05642182,.8130478,-.08195988,.1118294,.5617231,-.8707374,.1286999,1.820054,-4.674706,.003317471,.5919018,.1975278,6.686519,.9631727,-1.070378,-.3030579,-.9041938,6.200201,.1232207,-.3650628,.5029403,-2.903162,.3811408,-1.063035,-.1637545,.5853072,-7.889906,-1.200641,1.035018,.1192093,3.267054,.8416151,-1.053655,-.1562286,.2423683,11.28575,-4.363262,-.0731416,.5642088,2.514023,.6670457,-1.366112,-.4718287,-7.876222,7.7469,-.009182309,.4716076,.08320252,3.165603,.5392334,-2.468204,-1.33634,-5.386723,7.072672,-.08329266,.8636876,-.01978177,-.1326218,.2979222,-.9653522,-.02373416,1.81025,-6.467262,.1410706,-.4753717,.3003095,6.551163,1.151083,-.8943186,-.2487152,-.230896,8.512648,.1298402,1.034705,.2303509,-3.924095,.2982717,-1.146999,-.2318784,.08992419,-9.933614,-.886092,-.03071656,.2852012,3.046199,.8599001,-1.032399,-.1645145,.2683599,13.27701,-4.40767,.07709869,.4951727,1.957277,.6630943,-1.46907,-.6135092,-6.506263,6.661315,-.03835383,.7150413,.007784318,2.820577,.6756784,-2.501583,-1.247404,-15.23462,16.33191,-.01204803,.5896471,-.02002023,1.144647,.06177874,-2.438672,-1.127291,5.731172,-10.2135,.0616561,-.7752641,.4708254,4.176847,1.200881,-.1513427,.09792731,-1.612349,9.814289,.05188921,1.716403,-.07039255,-2.815115,.3291874,-1.318511,-.3650554,.4221268,-9.294529,-.0439752,-.8100625,.3742719,1.834166,.822345,-1.016009,-.1820264,.1278426,11.82696,-4.801528,.4947899,.4660378,1.601254,.6702359,-1.84131,-.9781779,-4.610903,4.824662,-.05100806,.6463776,-6377724e-12,2.216875,.861853,-2.376373,-1.108657,-14.89799,15.46458,.04091025,.0976178,-.01048958,2.165834,-.1609171,-4.710318,-2.261963,6.947327,-10.34828,-.1325542,.7508674,.2247553,2.873142,1.2971,.216375,-.1944345,-2.43786,10.11314,.44505,.3111492,.2751323,-1.627906,.2531213,-1.258794,-.3524641,.8425444,-10.85313,-1.154381,-.4638014,-.002781115,.4344498,.8507091,-1.018938,-.1804153,-.06354054,15.7315,-4.386999,.6211115,.5294648,1.580749,.6586655,-1.116416,-.1917524,-10.68233,12.22221,-.03668978,1.054022,.01592132,3.180583,.562737,-1.132341,-.1671286,5.976499,-4.227366,-.09542489,.8664938,.008351793,4.876068,.4492779,-1.087635,-.3173679,.4314407,1.100555,-.4410057,1.677253,-.03005925,-4.201249,1.070902,-1.083031,-.08847705,1.291773,.4546776,.3091894,.726176,.04203659,5.990615,.3704756,-1.057899,-.2246706,2.329563,-1.219656,-5.33526,.8545378,-.03906209,-.9025499,.7797348,-1.073305,-.1522553,1.767063,1.90428,-3.101673,.3995856,.02905192,2.563977,.5753067,-1.113674,-.1759694,-9.754125,10.87391,-.03841093,.9524272,.05680219,4.227034,.6029571,-1.126496,-.1680281,5.332352,-4.575579,-.06761755,.3295335,.1194896,5.570901,.4536185,-1.103074,-.2681801,.06571479,2.396522,-.455128,2.466331,-.1232022,-3.023201,1.086379,-1.053299,-.02697173,.8379121,-.9681458,.5890692,-.4872027,.2936929,7.510139,.3079122,-1.079553,-.2710448,2.462379,-.3713554,-8.534512,1.828242,-.1686398,-1.96134,.8941077,-1.069741,-.1396394,1.657868,3.236313,-2.706344,-.2948122,.1314816,2.868457,.5413403,-1.131649,-.1954455,-7.751595,8.685861,-.04910871,.8992952,.04710143,4.254818,.6821116,-1.156689,-.1884324,3.163519,-3.091522,-.06613927,-.02575883,.1640065,6.073643,.4453468,-1.079224,-.2621389,.9446437,1.448479,-.3969384,2.626638,-.08101186,-3.016355,1.076295,-1.080832,.01033057,-.3500156,-.03281419,.5655512,-1.156742,.453471,8.774122,.2772869,-1.051202,-.2679975,2.719109,-2.190316,-6.878798,2.250481,-.2030252,-2.026527,.9701096,-1.089849,-.1598589,1.564748,6.869187,-3.05367,-.6110435,.1644472,2.370452,.551177,-1.171419,-.2429746,-8.991334,9.571216,-.02772861,.6688262,.07683478,3.785611,.6347635,-1.228554,-.2917562,2.753986,-2.49178,-.04663434,.3118303,.07546506,4.463096,.5955071,-1.093124,-.2447767,.9097406,.5448296,-.2957824,2.024167,-.0005152333,-1.069081,.9369565,-1.056994,.01569507,-.8217491,1.870818,.706193,-1.483928,.5978206,6.864902,.3673332,-1.054871,-.2758129,2.712807,-5.95011,-6.554039,2.447523,-.1895171,-1.454292,.9131738,-1.100218,-.1746241,1.438505,11.15481,-3.266076,-.8837357,.19701,1.991595,.5907821,-1.207267,-.291361,-11.03767,11.40724,-.014168,.5564047,.08476262,3.371255,.6221335,-1.429698,-.5374218,2.837524,-2.221936,-.02422337,.09313758,.0719025,1.869022,.5609035,-1.002274,-.0697281,.4031308,-.3932997,-.1521923,2.390646,-.0689399,2.999661,1.017843,-1.081168,-.1178666,-.496808,3.919299,.6046866,-2.440615,.7891538,2.140835,.274047,-1.050727,-.2307688,2.276396,-9.454407,-5.505176,2.99262,-.2450942,.6078372,.9606765,-1.103752,-.1810202,1.375044,15.89095,-3.438954,-1.265669,.2475172,1.680768,.5978056,-1.244324,-.3378542,-11.11001,11.37784,-.007896794,.4808023,.09249904,3.025816,.5880239,-1.593165,-.7027621,2.220896,-1.437709,-.01534738,.06286958,.06644555,1.091727,.547008,-.9136506,.01344874,.7772636,-1.209396,-.1408978,2.433718,-.1041938,3.791244,1.037916,-1.134968,-.1803315,-.9267335,4.57667,.6851928,-2.805,.8687208,1.161483,.2571688,-1.017037,-.2053943,2.36164,-9.887818,-5.122889,3.287088,-.2594102,.8578927,.959234,-1.118723,-.1934942,1.226023,16.7414,-3.277335,-1.629809,.2765232,1.637713,.6113963,-1.314779,-.4119915,-12.4115,12.41578,.002344284,.2980837,.1414613,2.781731,.4998556,-1.926199,-1.020038,2.5692,-1.081159,-.02266833,.3588668,.008750078,-.2452171,.4796758,-.7780002,.1850647,.04445456,-2.409297,-.07816346,1.54679,-.02807227,5.998176,1.132396,-1.179326,-.357833,-.2392933,6.467883,.5904596,-1.869975,.8045839,-2.498121,.1610633,-1.009956,-.1311896,1.726577,-12.19356,-3.466239,2.343602,-.2252205,2.573681,1.027109,-1.11246,-.2063093,1.233051,20.58946,-4.578074,-1.145643,.3160192,1.420159,.5860212,-1.371689,-.4914196,-10.7661,11.07405,-.01485077,.5936218,.03685482,2.599968,.6002204,-2.436997,-1.377939,.02130141,1.079593,-.01796232,-.03933248,.1610711,-.6901181,.1206416,-.8743368,.0733137,.8734259,-3.743126,-.03151167,1.297596,-.07634926,6.532873,1.435737,-.9810197,-.3521634,-.2855205,7.134674,.6839748,-1.394841,.6952036,-4.633104,-.02173401,-1.122958,-.1691536,1.38236,-11.02913,-2.608171,1.865111,-.1345154,3.112342,1.094134,-1.075586,-.2077415,1.171477,17.9327,-4.656858,-1.036839,.3338295,1.042793,.5739374,-1.465871,-.6364486,-8.833718,9.34365,-.032236,.7552848,-3121341e-12,2.249164,.8094662,-2.448924,-1.270878,-4.823703,5.853058,-.02149127,.03581132,-.001230276,.4892553,-.1597657,-2.419809,-1.071337,1.575648,-4.98358,.009545185,.5032615,.4186266,4.634147,1.433517,-.1383278,-.02797095,-.1943067,6.679623,.411828,-.2744289,-.02118722,-4.337025,.1505072,-1.341872,-.2518572,1.027009,-6.527103,-1.081271,1.015465,.2845789,2.470371,.927812,-1.04064,-.2367454,1.100744,8.827253,-4.560794,-.7287017,.2842503,.6336593,.6327335,-1.877993,-1.025135,-4.311037,4.715016,-.04711631,.6335844,-7665398e-12,1.788017,.9001409,-2.28154,-1.137668,-10.36869,11.36254,.01961739,-.09836174,-.006734567,1.320918,-.2400807,-4.904054,-2.315781,5.735999,-8.626257,-.1255643,1.545446,.139686,2.972897,1.429934,.4077067,-.1833688,-2.450939,9.119433,.4505361,-1.340828,.397369,-1.78537,.09628711,-1.296052,-.3250526,1.813294,-10.31485,-1.38869,1.239733,-.08989196,-.3389637,.963956,-1.062181,-.2423444,.7577592,15.66938,-4.462264,-.574281,.3262259,.9461672,.6232887],datasetXYZ2=[-1.127942,-.1905548,-12.52356,13.75799,-.03624732,1.055453,.01385036,4.17697,.5928345,-1.15526,-.1778135,6.216056,-5.254116,-.08787445,.8434621,.04025734,6.195322,.3111856,-1.125624,-.3217593,.5043919,1.686284,-.3536071,1.476321,-.07899019,-4.522531,1.271691,-1.081801,-.1033234,.999555,.007482946,-.06776018,1.463141,.09492021,5.612723,.1298846,-1.07532,-.2402711,2.141284,-1.203359,-4.945188,1.437221,-.0809675,-1.028378,1.004164,-1.073337,-.1516517,1.639379,2.304669,-3.214244,1.286245,.05613957,2.480902,.4999363,-1.128399,-.1857793,-10.89863,11.72984,-.03768099,.9439285,.04869335,4.845114,.6119211,-1.114002,-.139928,4.9638,-4.6855,-.07780879,.4049736,.1586297,7.770264,.3449006,-1.185472,-.3403543,.6588322,1.133713,-.4118674,2.061191,-.1882768,-4.372586,1.22353,-1.002272,.02000703,.07073269,1.485075,.5005589,.4301494,.3626541,7.921098,.1574766,-1.121006,-.3007777,2.242051,-4.571561,-7.761071,2.053404,-.1524018,-1.886162,1.018208,-1.058864,-.1358673,1.389667,8.633409,-3.437249,.7295429,.15147,2.842513,.5014325,-1.144464,-.2043799,-10.20188,10.71247,-.03256693,.7860205,.06872719,4.824771,.6259836,-1.170104,-.2118626,4.391405,-4.1989,-.07111559,.3890442,.1024831,6.282535,.5365688,-1.129171,-.255288,.2238298,.7314295,-.356273,1.881931,-.03078716,-1.03912,.9096301,-1.042294,.004450203,-.5116033,2.627589,.6098996,-.1264638,.4325281,7.080503,.4583646,-1.082293,-.2723056,2.065076,-8.143133,-7.892212,2.142231,-.0710624,-1.122398,.8338505,-1.071715,-.1426568,1.095351,17.29783,-3.851931,.4360514,.211444,2.970832,.5944389,-1.195909,-.2590449,-11.91037,12.07947,-.01589842,.6297846,.09054772,4.285959,.5933752,-1.245763,-.3316637,4.29366,-3.694011,-.04699947,.4843684,.02130425,4.097549,.6530809,-1.148742,-.1902509,-.2393233,-.2441254,-.2610918,1.846988,.03532866,2.660106,.8358294,-1.01608,-.0744496,-.5053436,4.388855,.6054987,-1.2083,.5817215,2.54357,.4726568,-1.072027,-.210144,1.518378,-10.60119,-6.016546,2.649475,-.05166992,1.571269,.8344622,-1.072365,-.1511201,.747801,19.00732,-3.950387,-.3473907,.3797211,2.782949,.6296808,-1.239423,-.3136289,-13.511,13.49468,-.007070423,.5012315,.1106008,3.803619,.5577948,-1.452524,-.5676944,2.993153,-2.277288,-.02168954,.305672,.01152338,1.852697,.6427228,-1.061421,-.04590521,.6057022,-1.096835,-.1504952,2.344921,-.05491832,5.268322,.9082253,-1.042373,-.1769498,-1.075388,3.831712,.315414,-2.416458,.7909032,-.01492892,.3854049,-1.064159,-.1892684,1.438685,-8.166362,-3.616364,3.275206,-.1203825,2.039491,.8688057,-1.07012,-.1569508,.412476,13.99683,-3.547085,-1.046326,.4973825,2.791231,.6503286,-1.283579,-.3609518,-13.35397,13.15248,-.0004431938,.3769526,.1429824,3.573613,.4998696,-1.657952,-.7627948,1.958222,-.7949816,-.02882837,.5356149,-.05191946,.8869955,.626332,-.95276,.06494189,.5361303,-2.12959,-.0925863,1.604776,.0506777,6.376055,.9138052,-1.080827,-.252312,-.7154262,4.120085,.1878228,-1.492158,.6881655,-1.446611,.4040631,-1.054075,-.1665498,.9191052,-6.636943,-1.894826,2.10781,-.03680499,2.655452,.841384,-1.061127,-.1448849,.2667493,10.34103,-4.285769,-.3874504,.5998752,3.132426,.6652753,-1.347345,-.4287832,-9.305553,9.133813,-.003173527,.3977564,.115142,3.320564,.4998134,-1.927296,-.9901372,-2.593499,4.087421,-.05833993,.8158929,-.04681279,.2423716,.4938052,-.9470092,.07325237,2.064735,-5.16754,-.01313751,.4832169,.1126295,6.970522,1.035022,-1.022557,-.2762616,-.9375748,6.696739,.2200765,-.1133253,.5492505,-3.109391,.3321914,-1.087444,-.1836263,.6225024,-8.576765,-1.107637,.7859427,.09910909,3.112938,.8596261,-1.051544,-.1546262,.2371731,12.00502,-4.527291,.07268862,.5571478,2.532873,.6662,-1.375576,-.4840019,-8.12129,8.05814,-.01445661,.5123314,.05813321,3.203219,.5442318,-2.325221,-1.241463,-7.06343,8.741369,-.0782995,.8844273,-.03471106,.1740583,.2814079,-1.2287,-.2013412,2.949042,-7.371945,.1071753,-.249197,.2265223,6.391504,1.172389,-.7601786,-.1680631,-.7584444,8.541356,.08222291,.6729633,.3206615,-3.70094,.2710054,-1.191166,-.2672347,.2927498,-9.713613,-.4783721,.2352803,.2161949,2.691481,.8745447,-1.030135,-.1653301,.2263443,12.96157,-4.650644,.007055709,.5091975,2.00037,.6603839,-1.508018,-.6460933,-6.402745,6.545995,-.0375032,.6921803,.003309819,2.797527,.6978446,-2.333308,-1.167837,-17.46787,18.6863,-.008948229,.5621946,-.03402626,1.217943,.01149865,-2.665953,-1.226307,7.169725,-11.59434,.0358342,-.3074378,.3412248,4.422122,1.283791,-.09705116,.08312991,-2.160462,10.28235,.03543357,1.032049,.105831,-2.972898,.2418628,-1.329617,-.3699557,.5560117,-9.730113,.09938865,-.3071488,.2510691,1.777111,.8705142,-1.019387,-.1893247,.1194079,12.39436,-4.799224,.2940213,.4841268,1.529724,.6582615,-1.896737,-1.005442,-6.411032,6.54822,-.03227596,.5717262,-8115192e-12,2.296704,.9000749,-2.411116,-1.225587,-17.53629,18.29393,.01247555,.2364616,-.005114637,1.603778,-.2224156,-4.707121,-2.074977,7.9423,-11.32407,-.05415654,.5446811,.1032493,4.010235,1.369802,.1010482,-.4013305,-2.674579,9.779409,.1782506,.7053045,.4200002,-2.400671,.1953165,-1.243526,-.3391255,.8848882,-9.789025,-.3997324,-.9546227,-.1044017,.6010593,.8714462,-1.014633,-.1730009,-.07738934,13.90903,-4.847307,1.076059,.5685743,1.572992,.6561432,-1.122998,-.1881183,-10.30709,11.58932,-.04079495,.9603774,.03079436,4.009235,.5060745,-1.13479,-.1539688,5.478405,-4.21727,-.1043858,.7165008,.01524765,6.473623,.4207882,-1.134957,-.3513318,.7393837,1.354415,-.4764078,1.690441,-.0549264,-5.563523,1.145743,-1.058344,-.05758503,1.16823,.3269824,.1795193,.7849011,.07441853,6.904804,.281879,-1.075194,-.2355813,2.463685,-1.536505,-7.505771,.9619712,-.06465851,-1.355492,.8489847,-1.07903,-.1465328,1.773838,2.310131,-3.136065,.3507952,.04435014,2.819225,.5689008,-1.125833,-.1870849,-9.555833,10.59713,-.04225402,.9164663,.04338796,4.40098,.6056119,-1.12744,-.1551891,4.755621,-4.408806,-.07851763,.2268284,.146007,7.048003,.3525997,-1.143788,-.3170178,.5480669,2.04183,-.4532139,2.302233,-.1887419,-4.489221,1.250967,-1.032849,.007376031,.5666073,-.2312203,.4862894,-.1748294,.357287,8.380522,.1302333,-1.093728,-.2786977,2.641272,-1.507494,-8.731243,1.684055,-.2023377,-2.176398,1.013249,-1.076578,-.1456205,1.693935,2.945003,-2.822673,-.2520033,.1517034,2.649109,.5179094,-1.146417,-.2119353,-7.187525,8.058599,-.05256438,.8375733,.03887093,4.222111,.6695347,-1.173674,-.2067025,2.899359,-2.804918,-.08473899,.003944225,.1340641,6.160887,.4527141,-1.090098,-.2599633,.9180856,1.09271,-.4215019,2.42766,-.09277667,-2.123523,1.058159,-1.08446,.008056181,-.245351,.6619567,.4668118,-.9526719,.4648454,8.001572,.3054194,-1.053728,-.2765784,2.792388,-3.489517,-8.150535,2.195757,-.2017234,-2.128017,.9326589,-1.099348,-.1593939,1.568292,7.247853,-2.933,-.5890481,.172444,2.433484,.5736558,-1.185983,-.2581184,-7.761056,8.317053,-.03351773,.6676667,.05941733,3.820727,.6324032,-1.268591,-.3398067,2.348503,-2.023779,-.05368458,.1083282,.08402858,3.910254,.5577481,-1.071353,-.1992459,.7878387,.1974702,-.3033058,2.335298,-.08205259,.7954454,.9972312,-1.089513,-.03104364,-.5995746,2.330281,.6581939,-1.821467,.6679973,5.090195,.3125161,-1.040214,-.2570934,2.660489,-6.506045,-7.053586,2.763153,-.2433632,-.7648176,.9452937,-1.116052,-.1831993,1.457694,11.63608,-3.216426,-1.045594,.2285002,1.817407,.5810396,-1.230134,-.3136264,-8.909301,9.145006,-.01055387,.4467317,.1016826,3.342964,.563384,-1.442907,-.5593147,2.156447,-1.241657,-.0351213,.3050274,.01797175,1.742358,.5977153,-1.027627,-.06481539,.4351975,-1.051677,-.2030672,1.942684,-.03615993,4.050266,.9801624,-1.08211,-.1578209,-.3397511,4.163851,.6650368,-1.84173,.7062544,.6789881,.3172623,-1.047447,-.197756,2.183364,-8.805249,-5.483962,2.551309,-.177964,1.519501,.9212536,-1.111853,-.1935736,1.394408,13.92405,-3.46543,-1.068432,.2388671,1.455336,.6233425,-1.262238,-.3546341,-10.08703,10.20084,-.001852187,.353758,.1239199,3.056093,.5132052,-1.61381,-.7355585,2.760123,-1.685253,-.02517552,.2914258,.004743448,.8689596,.5674192,-.9462336,.02950767,-.2613816,-.7398653,-.1315558,1.901042,-.06447844,4.969341,1.027342,-1.111481,-.2194054,-.09004538,3.983442,.4871278,-1.965315,.7956121,-.2363225,.2718037,-1.036397,-.1827106,1.964747,-8.870759,-4.208011,2.461215,-.2158905,1.561676,.9436866,-1.113769,-.1947819,1.30072,15.16476,-4.088732,-1.069384,.2836434,1.671451,.6229612,-1.328069,-.4244047,-8.41704,8.552244,-.006813504,.4127422,.09619897,2.854227,.505988,-1.927552,-1.02529,.9529576,.425595,-.03738779,.2584586,.04911004,-.2640913,.4138626,-.8488094,.1435988,.6356807,-2.895732,-.08473961,1.701305,-.1323908,6.499338,1.210928,-1.128313,-.3397048,-.404314,6.265097,.5482395,-2.057614,.8884087,-2.943879,.09760301,-1.039764,-.1494772,1.781915,-11.53012,-3.379232,2.517231,-.2764393,2.588849,1.05212,-1.108447,-.2012251,1.19864,19.25331,-4.423892,-1.257122,.339569,1.48122,.5880175,-1.374185,-.4967434,-7.401318,7.724021,-.02345723,.5979653,.02436346,2.65897,.6014891,-2.310933,-1.29029,-1.301909,2.557806,-.03744449,.08982861,.1090613,-.4398363,.1184329,-1.12473,-.0992183,1.366902,-4.172489,-.05078016,1.393597,-.09323843,6.452721,1.435913,-.8468477,-.2744819,-.43472,6.713362,.6127133,-1.685634,.7360941,-4.535502,-.02920866,-1.165242,-.2008697,1.438778,-10.08936,-2.214771,2.102909,-.1763085,2.859075,1.09347,-1.074614,-.2066374,1.131891,16.30063,-4.801441,-1.11259,.3595785,1.122227,.579461,-1.521515,-.6835604,-5.571044,6.028774,-.04253715,.6875746,-5279456e-12,2.18015,.8487705,-2.240415,-1.171166,-7.182771,8.417068,-.01932866,.1101887,-.01098862,.6242195,-.2393875,-2.712354,-1.19883,3.1802,-6.76813,-.002563386,.7984607,.2764376,4.695358,1.557045,-.03655172,-.02142321,-.913812,7.932786,.3516542,-.7994343,.1786761,-4.208399,.01820576,-1.36861,-.2656212,1.249397,-8.317818,-.8962772,1.423249,.1478381,2.19166,1.007748,-1.041753,-.2453366,1.061102,11.30172,-4.739312,-.9223334,.2982776,.6162931,.6080302,-1.989159,-1.09516,-2.91555,3.275339,-.05735765,.5742174,-7683288e-12,1.7634,.9001342,-2.07002,-1.086338,-10.95898,12.0696,.03780123,-.01774699,-.0005881348,1.333819,-.2605423,-5.249653,-2.38304,6.160406,-9.097138,-.1955319,1.651785,.0006016463,3.021824,1.493574,.4685432,-.2358662,-2.666433,9.685763,.5804928,-1.521875,.5668989,-1.548136,.01688642,-1.296891,-.3449031,1.928548,-11.6756,-1.627615,1.355603,-.1929074,-.6568952,1.009774,-1.067288,-.2410392,.7147961,17.8384,-4.374399,-.6588777,.3329831,1.012066,.6118645],datasetXYZ3=[-1.310023,-.4407658,-36.4034,36.83292,-.008124762,.5297961,.01188633,3.13832,.5134778,-1.4241,-.5501606,-17.5351,18.22769,-.01539272,.6366826,.002661996,2.659915,.4071138,-1.103436,-.1884105,6.425322,-6.910579,-.02019861,.3553271,-.01589061,5.345985,.8790218,-1.1862,-.4307514,-3.957947,5.979352,-.05348869,1.736117,.03491346,-2.692261,.5610506,-1.006038,-.1305995,4.473513,-3.806719,.1419407,-.02148238,-.05081185,3.735362,.535828,-1.078507,-.1633754,-3.812368,4.3817,.02988122,1.754224,.1472376,3.722798,.4999157,-1.333582,-.4649908,-33.59528,34.04375,-.009384242,.5587511,.00572631,3.073145,.5425529,-1.562624,-.7107068,-14.7817,15.59839,-.01462375,.5050133,.02516017,1.604696,.2902403,-.8930158,.04068077,1.373481,-2.342752,-.02098058,.6248686,-.05258363,7.058214,1.150373,-1.262823,-.4818353,889261e-9,1.92312,-.04979718,1.040693,.1558103,-2.85248,.2420691,-.9968383,-.1200648,1.324342,-.9430889,.1931098,.4436916,-.07320456,4.215931,.7898019,-1.078185,-.1718192,-1.720191,2.358918,.02765637,1.260245,.2021941,3.395483,.5173628,-1.353023,-.4813523,-31.0492,31.40156,-.009510741,.554203,.008135471,3.136646,.5215989,-1.624704,-.7990201,-21.67125,22.46341,-.01163533,.5415746,.02618378,1.139214,.3444357,-.798361,.1417476,9.914841,-10.81503,-.01218845,.3411392,-.06137698,7.445848,1.18008,-1.266679,-.4288977,-5.818701,6.986437,-.08180711,1.397403,.2016916,-1.275731,.2592773,-1.009707,-.1537754,3.496378,-3.013726,.242115,-.2831925,.03003395,3.702862,.774632,-1.075646,-.1768747,-1.347762,1.989004,.01375836,1.76481,.1330018,3.230864,.662621,-1.375269,-.5103569,-34.42661,34.78703,-.008460009,.5408643,.004813323,3.016078,.5062069,-1.821679,-.9766461,-19.26488,19.97912,-.009822567,.3649556,.04316092,.893019,.4166527,-.6633542,.1997841,2.395592,-3.117175,-.01080884,.8983814,-.1375825,6.673463,1.115663,-1.30324,-.3612712,.08292959,.3381364,-.06078648,.3229247,.3680987,.7046755,.3144924,-.9952598,-.2039076,.4026851,.2686684,.1640712,.5186341,-.0120552,2.659613,.8030394,-1.098579,-.2151992,.6558198,-74369e-8,-.001421817,1.073701,.1886875,2.536857,.6673923,-1.457986,-.5906842,-38.12464,38.38539,-.006024357,.4741484,.01209223,2.818432,.5012433,-1.835728,-1.003405,-6.848129,7.601943,-.01277375,.4785598,.03366853,1.097701,.4636635,-.8491348,.009466365,-2.685226,2.00406,-.01168708,.6752316,-.1543371,5.674759,1.039534,-1.083379,-.150679,.7328236,-.5095568,-.08609153,.444882,.4174662,1.481556,.3942551,-1.117089,-.3337605,.2502281,.4036323,.2673899,.2829817,.0224245,2.043207,.7706902,-1.071648,-.21262,.6069466,-.00145629,-.551596,1.046755,.1985021,2.290245,.6876058,-1.483903,-.6309647,-43.80213,44.10537,-.005712161,.5195992,.002028428,2.687114,.5098321,-2.053976,-1.141473,.5109183,.08060391,-.01033983,.4066532,.04869627,1.161722,.4039525,-.6348185,.07651292,-10.31327,10.07598,-.02083688,.7359516,-.2029459,5.013257,1.077649,-1.22863,-.1650496,.04077157,-.7189167,-.0509222,.2959814,.5111496,2.540433,.361533,-1.041883,-.3278413,-.06691911,1.307364,.2166663,.3000595,-.003157136,1.389208,.7999026,-1.103556,-.2443602,.4705347,-.0009296482,-.530992,.9654511,.2142587,2.244723,.6839976,-1.555684,-.6962113,-46.47983,46.7427,-.005034895,.475509,-9.502561e-7,2.626569,.5056194,-1.998288,-1.12472,-1.629586,2.187993,-.008284384,.3845258,.0572624,1.185644,.4255812,-1.03257,-.251385,-3.721112,3.506967,-.02186561,.9436049,-.2451412,4.725724,1.039256,-.8597532,.09073332,-2.553741,1.993237,-.04390891,-.2046928,.5515623,1.909127,.3948212,-1.210482,-.4477622,-.2267805,1.219488,.1336186,.6866897,.02808997,1.600403,.7816409,-1.078168,-.2699261,.2537282,.3820684,-.4425103,.5298235,.2185217,1.728679,.6882743,-1.697968,-.8391488,-57.90105,58.1412,-.00340476,.426514,-1796301e-12,2.368442,.5324429,-2.141552,-1.17223,16.77872,-16.4147,-.005732425,.2002199,.06841834,1.485338,.3215763,-1.442946,-.7264245,-9.503706,9.650462,-.02120995,1.419263,-.2893098,3.860731,1.120857,-.5696752,.3411279,-.2931035,-.6512552,-.1068437,-1.085661,.6107549,1.459503,.3210336,-1.313839,-.5921371,-.2332222,1.648196,.2492787,1.381033,-.01993392,.981256,.8316329,-1.087464,-.3195534,.2902095,.3383709,-.8798482,.01494668,.2529703,1.452644,.669387,-2.068582,-1.118605,-50.81598,50.97486,-.003280669,.4067371,-2544951e-12,2.179497,.5778017,-1.744693,-.8537207,22.34361,-22.08318,-.005932616,.1035049,.05742772,1.97788,.2124846,-3.287515,-2.140268,-12.49566,12.40091,-.02409349,1.397821,-.2371627,2.771192,1.170496,.5502311,1.04663,2.193517,-2.2204,-.1064394,-1.017926,.4795457,1.030644,.3177516,-1.719734,-.9536198,-.6586821,1.386361,-.02513065,1.187011,.06542539,.5296055,.808266,-1.0057,-.3028096,.04470957,1.00776,-.8119016,.03153338,.2311321,1.182208,.6824758,-2.728867,-1.580388,-30.79627,30.92586,-.004197673,.3154759,-3897675e-12,1.920567,.6664791,-1.322495,-.7249275,14.7766,-14.68154,-.009044857,.05624314,.06498392,2.047389,.0636754,-6.102376,-3.473018,-9.926071,9.637797,-.01097909,1.103498,-.2424521,2.520748,1.24026,1.351796,1.018588,2.009081,-1.333394,-.1979125,-.3318292,.4476624,.9095235,.2955611,-1.774467,-1.07988,-.0808468,.2577697,-.1149295,.4975303,.002931611,-.3803171,.8002794,-.9898401,-.2542513,-.07530911,1.870355,-1.521918,.2405164,.2964615,1.3348,.6789053,-1.27973,-.4290674,-42.77972,43.43305,-.006541826,.4945086,.01425338,2.685244,.5011313,-1.449506,-.5766374,-16.88496,17.81118,-.01121649,.354502,.02287338,1.904281,.4936998,-1.02198,-.1897574,2.482462,-2.941725,-.01570448,.7532578,-.042568,5.23966,.4983116,-1.162608,-.3428049,3.974358,-1.527935,-.03919201,.8758593,.07291363,-3.455257,.8007426,-.9929985,-.08712006,-.7397313,1.348372,.09511685,.3233584,-.07549148,5.806452,.4990042,-1.084996,-.1739767,.1580475,.908818,.06871433,.5933079,.1188921,3.074079,.4999327,-1.317009,-.4661946,-42.55347,43.12782,-.005727235,.4285447,.02189854,2.60831,.51907,-1.469236,-.6282139,-12.41404,13.48765,-.0120477,.5070285,-.0007280216,1.491533,.3635064,-.9713808,-.08138038,.3709854,-1.041174,-.01814075,.506086,-.02053756,6.161431,1.093736,-1.159057,-.3698074,2.711209,-.6006479,-.04896926,.9273957,.1137712,-3.496828,.2867109,-1.011601,-.0820189,.2105725,.459752,.1478925,.213894,-.0566067,6.057755,.7859121,-1.07802,-.181158,.1646622,.8348426,.1149064,.4985738,.1376605,2.746607,.4999626,-1.325672,-.4769313,-41.11215,41.68293,-.006274997,.4649469,.01119411,2.631267,.5234546,-1.619391,-.8000253,-15.34098,16.32706,-.01012023,.4242255,.02931597,.8925807,.3314765,-.7356979,.1368406,2.972579,-3.535359,-.01318948,.460762,-.07182778,6.2541,1.236299,-1.316217,-.4194427,.03489902,1.289849,-.0475596,1.138222,.1975992,-.8991542,.2290572,-.9502188,-.1172703,1.405202,-.3061919,.1058772,-.3760592,-.01983179,3.562353,.7895959,-1.100117,-.1900567,.492503,.5250225,.1576804,1.042701,.07330743,2.796064,.6749783,-1.354183,-.5130625,-42.19268,42.71772,-.005365373,.4136743,.01235172,2.520122,.5187269,-1.741434,-.9589761,-8.230339,9.296799,-.009600162,.4994969,.02955452,.3667099,.3526999,-.6917347,.2154887,-.8760264,.2334121,-.01909621,.4748033,-.1138514,6.51536,1.225097,-1.293189,-.42187,1.620952,-.7858597,-.0376941,.6636786,.3364945,-.5341017,.2128347,-.9735521,-.1325495,1.007517,.2598258,.06762169,.001421018,-.06915987,3.185897,.8641956,-1.0948,-.1962062,.5755591,.2906259,.2625748,.7644049,.1347492,2.677126,.646546,-1.393063,-.5578338,-41.85249,42.33504,-.00543564,.4743765,.007422477,2.442801,.5211707,-1.939487,-1.128509,-8.974257,9.978383,-.007965597,.294883,.04436763,.2839868,.3440424,-.6011562,.2354877,-3.07982,2.585094,-.02002701,.7793909,-.1598414,5.834678,1.202856,-1.315676,-.3903446,1.7019,-1.304609,-.01045121,.2747707,.4143967,.3197102,.263758,-.9618628,-.1625841,1.187138,.1497802,-5590954e-12,.03178475,-.04153145,2.496096,.8195082,-1.111554,-.2365546,.7831875,.2018684,.2074369,.7395978,.122573,1.876478,.6821167,-1.427879,-.5994879,-35.31016,35.81581,-.006431497,.4554192,.0007348731,2.334619,.5233377,-1.998177,-1.206633,-21.4651,22.42237,-.005857596,.2755663,.06384795,.1358244,.3328437,-.644063,.2058571,2.155499,-2.587968,-.01840023,.8826555,-.2222452,5.847073,1.228387,-1.229071,-.3360441,-.3429599,.6179469,.00202961,.08899319,.5041624,.1882964,.225204,-1.022905,-.2101621,1.915689,-.6498794,-.03463651,.08954605,-.06797854,2.417705,.8568618,-1.082538,-.2007723,.4731009,.4077267,.1324289,.651488,.1702912,2.309383,.6600895,-1.472139,-.6499815,-34.28465,34.69659,-.005747023,.4174167,.001688597,2.323046,.5395191,-2.161176,-1.353089,-22.26827,23.29138,-.005583808,.2364793,.06096656,.001944666,.2861624,-.6593044,.1393558,4.698373,-5.193883,-.0199839,1.095635,-.2391254,5.598103,1.236193,-1.195717,-.2972715,.04648953,.3024588,.005003313,-.3754741,.5247265,-.1381312,.2493896,-1.020139,-.2253524,.3548437,.7030485,-.02107076,.4581395,-.03243757,2.453259,.8323623,-1.09877,-.243578,.8761614,.1941613,-.1990692,.3761139,.1657412,1.590503,.6741417,-1.648007,-.8205121,-44.35106,44.79801,-.004181353,.385483,-1842385e-12,2.000281,.5518363,-2.140986,-1.282239,-3.979213,4.672459,-.005008582,.242192,.06253602,.6612713,.2555851,-1.300502,-.5137898,.5179821,-.4032341,-.02066785,1.087929,-.2615309,4.225887,1.229237,-.696334,.0924106,.06936356,-.3588571,-.05461843,-.5616643,.5484166,-.04776267,.2414935,-1.233179,-.4325498,.6479813,.8368356,.2458875,.6464752,-.02897097,1.561773,.8518598,-1.051023,-.253369,1.004294,.3028083,-1.520108,.1607013,.1619975,1.131094,.6706655,-1.948249,-1.097383,-44.53697,44.94902,-.003579939,.3491605,-2500253e-12,1.740442,.6188022,-2.154253,-1.209559,4.144894,-3.562411,-.005638843,.1067169,.07594858,1.00528,.1072543,-2.513259,-1.507208,-1.602979,1.404154,-.00556075,1.24049,-.2852117,3.485252,1.349321,-.07832214,.3655626,.3856288,.6867894,-.1609523,-.6704306,.5357301,-.6457935,.1479503,-1.354784,-.5454375,.8797469,-1.466514,.713442,.5934903,-.02911178,.8643737,.9030724,-1.048324,-.2738736,.8783074,3.246188,-4.435369,.1251791,.1783486,1.064657,.6522878,-2.770408,-1.618911,-25.04031,25.31674,-.004239279,.3241013,-3764484e-12,1.586843,.7035906,-1.9135,-1.144014,-10.80587,11.53677,-.01003197,.1577515,.05217789,1.225278,.005172771,-5.293208,-2.876463,2.087053,-3.201552,.003892964,.532393,-.2034512,2.61776,1.273597,.906034,.3773409,-.6399945,3.213979,-.09112172,.6494055,.395328,.5047796,.2998695,-1.482179,-.677831,1.161775,-3.004872,.4774797,-.4969248,-.003512074,-1.30719,.7927378,-.9863181,-.1803364,.5810824,4.58057,-3.863454,.5328174,.2272821,1.771114,.6791814],datasetXYZRad1=[1.560219,1.417388,1.206927,10.91949,5.931416,7.304788,1.533049,1.560532,.3685059,13.5504,5.543711,7.792189,1.471043,1.746088,-.9299697,17.20362,5.473384,8.336416,1.355991,2.109348,-3.295855,22.64843,5.454607,9.304656,1.244963,2.547533,-5.841485,27.56879,5.576104,10.43287,1.175532,2.784634,-7.212225,29.75347,6.47298,10.92331,1.082973,3.118094,-8.934293,31.86879,8.473885,11.74019,.96925,3.349574,-10.0381,31.47654,13.38931,12.72547,.8547044,3.151538,-9.095567,25.54995,22.73219,14.10398,.758034,2.311153,-5.170814,12.29669,36.86529,15.98882,1.664273,1.574468,1.422078,9.768247,14.47338,16.44988,1.638295,1.719586,.5786675,12.39846,14.15419,17.28605,1.572623,1.921559,-.7714802,16.09246,14.20954,18.25908,1.468395,2.21197,-2.845869,20.75027,15.24822,19.37622,1.355047,2.556469,-4.96092,24.60237,16.4836,20.65648,1.291642,2.742036,-6.061967,26.02002,18.19144,21.16712,1.194565,2.97212,-7.295779,26.91805,21.2488,22.01819,1.083631,3.047021,-7.766096,24.96261,27.44264,22.91875,.9707994,2.736459,-6.308284,17.6086,37.76291,23.9215,.8574294,1.865155,-2.364707,4.337793,50.92831,25.23432],datasetXYZRad2=[1.632341,1.39523,1.375634,12.38193,5.921102,7.766508,1.597115,1.554617,.3932382,15.05284,5.725234,8.158155,1.522034,1.844545,-1.322862,19.18382,5.440769,8.837119,1.403048,2.290852,-4.013792,24.851,5.521888,9.845547,1.286364,2.774498,-6.648221,29.64151,5.923777,10.97075,1.213544,3.040195,-8.092676,31.86082,6.789782,11.58899,1.122622,3.347465,-9.649016,33.43824,9.347715,12.31374,1.007356,3.543858,-10.5352,32.39842,14.83962,13.31718,.8956642,3.2787,-9.254933,25.57923,24.89677,14.76166,.7985143,2.340404,-4.928274,11.41787,39.61501,16.82448,1.745162,1.639467,1.342721,11.66033,14.90124,17.74031,1.708439,1.819144,.2834399,14.48066,14.59214,18.58679,1.63172,2.094799,-1.378825,18.43198,14.63173,19.62881,1.516536,2.438729,-3.624121,22.98621,15.99782,20.70027,1.405863,2.785191,-5.705236,26.45121,17.6833,21.91903,1.344052,2.951807,-6.683851,27.44271,19.85706,22.29452,1.245827,3.182923,-7.82296,27.91395,23.27254,23.1591,1.132305,3.202593,-8.008429,25.21093,30.00014,24.05306,1.02033,2.820556,-6.238704,17.09276,40.77916,25.09949,.903157,1.863917,-1.955738,3.032665,54.3429,26.4178],datasetXYZRad3=[1.168084,2.156455,-3.980314,19.89302,13.28335,14.35621,1.135488,2.294701,-4.585886,20.90208,13.4784,14.67658,1.107408,2.382765,-5.112357,21.47823,14.93128,14.60882,1.054193,2.592891,-6.115,22.68967,16.35672,15.18999,1.006946,2.70542,-6.69893,22.9183,18.34324,15.70651,.9794044,2.74244,-6.805283,22.25271,20.50797,15.6313,.9413577,2.722009,-6.760707,20.98242,23.42588,16.05011,.8917923,2.59278,-6.152635,17.74141,28.58324,16.5791,.8288391,2.153434,-4.118327,10.78118,36.8171,17.38139,.7623528,1.418187,-.8845235,.7590129,46.29859,19.21657,1.352858,2.048862,-2.053393,14.05874,30.45344,30.4443,1.330497,2.126497,-2.466296,14.67559,30.90738,30.69707,1.286344,2.200436,-2.877228,14.92701,32.36288,30.77223,1.234428,2.289628,-3.404699,14.99436,34.6839,30.84842,1.17866,2.306071,-3.549159,14.11006,37.54188,30.7973,1.151366,2.333005,-3.728627,13.63374,39.05894,30.92599,1.101593,2.299422,-3.565787,11.96745,41.88472,31.02755,1.038322,2.083539,-2.649585,8.037389,47.00869,30.65948,.9596146,1.67147,-.8751538,1.679772,53.45784,30.5452,.8640731,.9858301,1.854956,-6.798097,59.36468,31.10255],HWCoeffsXYZ=[datasetXYZ1,datasetXYZ2,datasetXYZ3],HWCoeffsXYZRad=[datasetXYZRad1,datasetXYZRad2,datasetXYZRad3],HosekWilkieSkyTables={getTableValue:function(e,t,n,o,r){var i=540*t,a=54*(n-1),s=9*o;return HWCoeffsXYZ[e][i+a+s+r]},getTableValueRad:function(e,t,n,o){var r=60*t,i=6*(n-1);return HWCoeffsXYZRad[e][r+i+o]}},HW_MODEL_DIST_PARAMS_COUNT=9;function getDistParamValue(e,t,n,o,r){return getSolElevCoeffs(e).reduce(function(e,i,a){return e+i*HosekWilkieSkyTables.getTableValue(t,n,o,a,r)},0)}function getRadianceValue(e,t,n,o){return getSolElevCoeffs(e).reduce(function(e,r,i){return e+r*HosekWilkieSkyTables.getTableValueRad(t,n,o,i)},0)}function getSolElevCoeffs(e){var t=Math.pow(2*e/Math.PI,1/3);return[Math.pow(1-t,5),5*Math.pow(1-t,4)*t,10*Math.pow(1-t,3)*Math.pow(t,2),10*Math.pow(1-t,2)*Math.pow(t,3),5*(1-t)*Math.pow(t,4),Math.pow(t,5)]}function getDistParams$1(e,t,n,o){for(var r=new Array(HW_MODEL_DIST_PARAMS_COUNT),i=Math.trunc(e),a=e-i,s=0;s<HW_MODEL_DIST_PARAMS_COUNT;s++){var l=getDistParamValue(n,o,0,i,s),c=getDistParamValue(n,o,1,i,s);if(r[s]=(1-t)*(1-a)*l+t*(1-a)*c,10!=i){var u=getDistParamValue(n,o,0,i+1,s),d=getDistParamValue(n,o,1,i+1,s);r[s]+=(1-t)*a*u+t*a*d}}return r}function getRadiance(e,t,n,o){var r=Math.trunc(e),i=e-r,a=(1-t)*(1-i)*getRadianceValue(n,o,0,r)+t*(1-i)*getRadianceValue(n,o,1,r);10!=r&&(a+=(1-t)*i*getRadianceValue(n,o,0,r+1)+t*i*getRadianceValue(n,o,1,r+1));return a}var datasetDistLum=[.1787,-1.463,-.3554,.4275,-.0227,5.3251,.1206,-2.5771,-.067,.3703],datasetDistx=[-.0193,-.2592,-.0665,8e-4,-4e-4,.2125,-.0641,-.8989,-.0033,.0452],datasetDisty=[-.0167,-.2608,-.095,.0092,-.0079,.2102,-.0441,-1.6537,-.0109,.0529],datasetZenLum=[4.0453,-4.971,-.2155,2.4192],datasetZenx=[.00166,-.00375,.00209,0,-.02903,.06377,-.03202,.00394,.11693,-.21196,.06052,.25886],datasetZeny=[.00275,-.0061,.00317,0,-.04214,.0897,-.04153,.00516,.15346,-.26756,.0667,.26688],PreethamCoeffsDist=[datasetDistLum,datasetDistx,datasetDisty],PreethamCoeffsZenith=[datasetZenLum,datasetZenx,datasetZeny],PreethamSkyTables={getTableValue:function(e,t,n){return PreethamCoeffsDist[e][2*t+n]},getTableDataZenith:function(e){return PreethamCoeffsZenith[e]}},DIST_PARAMS_COUNT=5,LUM_COEFF=.06;function perez_model(e,t,n){return(1+e[0]*Math.exp(e[1]/Math.cos(t)))*(1+e[2]*Math.exp(e[3]*n)+e[4]*Math.pow(Math.cos(n),2))}function luminance(e){return.212671*e+.71516*e+.072169*e}function getDistParams(e,t){for(var n=new Array(DIST_PARAMS_COUNT),o=0;o<DIST_PARAMS_COUNT;o++)n[o]=PreethamSkyTables.getTableValue(t,o,0)*e+PreethamSkyTables.getTableValue(t,o,1);return n}function getZenithParams(e,t,n){switch(n){case 0:var o=PreethamSkyTables.getTableDataZenith(n),r=new Vector4(o[0],o[1],o[2],o[3]),i=Math.tan((4/9-e/120)*(Math.PI-2*t)),a=new Vector4(e*i,i,e,1);return r.dot(a)*LUM_COEFF/perez_model(getDistParams(e,n),0,t);case 1:case 2:o=PreethamSkyTables.getTableDataZenith(n);var s=Math.pow(t,2),l=Math.pow(t,3),c=o[0]*l+o[1]*s+o[2]*t+o[3],u=o[4]*l+o[5]*s+o[6]*t+o[7],d=o[8]*l+o[9]*s+o[10]*t+o[11];r=new Vector3(c,u,d);return new Vector3(Math.pow(e,2),e,1).dot(r)/perez_model(getDistParams(e,n),0,t)}}function getSunIlluminance(e,t){var n=[0,0,0];if(e[1]<0)return n;for(var o=[.605,.54,.445],r=[12.25,7.5,.3],i=.04608*t-.04586,a=1/(e[1]+.15*Math.pow(93.885-Math.acos(e[1])*(180/Math.PI),-1.253)),s=[1.05513096,.993359745,.903543472],l=0;l<3;l++){var c=Math.exp(.008735*-a*Math.pow(o[l],-4.08)),u=Math.exp(-a*i*Math.pow(o[l],-1.3)),d=Math.exp(.0035*-r[l]*a);n[l]=128e3*s[l]/luminance(s[l]),n[l]*=c*u*d}return n}const RAYLEIGH_SCALE=8e3,MIE_SCALE=1200,MIE_COEFF=2e-5,MIE_G=.76,SQR_G=.5776,EARTH_RADIUS=636e4,ATMOSPHERE_RADIUS=642e4,STEPS=32,NUM_WAVELENGTHS=21,MIN_WAVELENGTH=380,MAX_WAVELENGTH=780,STEP_LAMBDA=20,IRRADIANCE=[1.45756829855593,1.5659630555973838,1.6514844906767046,1.7149624273720931,1.7579798380502054,1.7825640788592454,1.7909510847583856,1.7854155013341066,1.7681555486430685,1.741220696472504,1.7064712716494368,1.6655608745273989,1.6199343724245185,1.5708359736889208,1.5193233505930548,1.466284949652144,1.4124585274017245,1.358449619703841,1.3047491384473928,1.2517496327261082,1.1997599875542062],RAYLEIGH_COEFF=[5424820087636473e-20,4418549866505454e-20,3635151910165377e-20,3017929012024763e-20,2526320226989157e-20,2130859310621843e-20,1809838025320633e-20,1547057129129042e-20,133028497733685e-19,1150184784075764e-20,999557429990163e-20,872799973630707e-20,765513700977967e-20,674217203751443e-20,596134125832052e-20,52903459806581e-19,471115687557433e-20,420910481110487e-20,377218381260133e-20,33905125547728e-19,305591531679811e-20],OZONE_COEFF=[3.25126849861e-9,5.85395365047e-9,1.977191155085e-8,7.309568762914e-8,2.0084561514287e-7,4.0383958096161e-7,6.3551335912363e-7,9.670704118097e-7,15479740042441e-19,209038647223331e-20,246128056164565e-20,273551299461512e-20,215125863128643e-20,159051840791988e-20,112356197979857e-20,7.3527551487574e-7,4.6450130357806e-7,3.3096079921048e-7,2.2512612292678e-7,1.487912926649e-7,1.6828623364192e-7],CMF_XYZ=[[.001368,39e-6,.006450001],[.01431,396e-6,.06785001],[.13438,.004,.6456],[.34828,.023,1.74706],[.2908,.06,1.6692],[.09564,.13902,.8129501],[.0049,.323,.272],[.06327,.71,.07824999],[.2904,.954,.0203],[.5945,.995,.0039],[.9163,.87,.001650001],[1.0622,.631,8e-4],[.8544499,.381,19e-5],[.4479,.175,2e-5],[.1649,.061,0],[.04677,.017,0],[.01135916,.004102,0],[.002899327,.001047,0],[.0006900786,2492e-7,0],[.0001661505,6e-5,0],[4150994e-11,1499e-8,0]],QUADRATURE_STEPS=8,QUADRATURE_NODES=[.006811185292,.03614807107,.09004346519,.1706680068,.2818362161,.4303406404,.6296271457,.9145252695],QUADRATURE_WEIGHTS=[.01750893642,.04135477391,.06678839063,.09507698807,.1283416365,.1707430204,.2327233347,.3562490486],_vec3Tmp$8=new Vector3,_vec3Tmp2$6=new Vector3,_density=new Vector3,_lightOpticalDepth=new Vector3,_rayEnd=new Vector3,_extinctionDensity=new Vector3,_scatteringDensity=new Vector3,_segmentROD=new Vector3,_segmentSS=new Vector3,_phaseFunction=new Vector3,_densityScale=new Vector3,_opticalDepth=new Vector3,_P=new Vector3;function geographicalToDirection(e,t,n){return n.set(Math.cos(e)*Math.cos(t),Math.cos(e)*Math.sin(t),Math.sin(e))}function specToXYZ(e,t){t.set(0,0,0);for(let n=0;n<21;n++)t.x+=CMF_XYZ[n][0]*e[n],t.y+=CMF_XYZ[n][1]*e[n],t.z+=CMF_XYZ[n][2]*e[n];return t.multiplyScalar(20)}function densityRayleigh(e){return Math.exp(-e/8e3)}function densityMie(e){return Math.exp(-e/1200)}function densityOzone(e){let t=0;return e>=1e4&&e<25e3?t=1/15e3*e-2/3:e>=25e3&&e<4e4&&(t=-(1/15e3*e-8/3)),t}function phaseRayleigh(e){return 3/(16*Math.PI)*(1+Math.pow(e,2))}function phaseMie(e){return 3*.4224*(1+Math.pow(e,2))/(8*Math.PI*2.5776*Math.pow(1.5776-1.52*e,1.5))}function surfaceIntersection(e,t){if(t.z>=0)return!1;const n=-2*t.dot(_vec3Tmp$8.copy(e).negate());return n*n-4*(e.lengthSq()-Math.pow(636e4,2))>=0}function atmosphereIntersection(e,t,n){const o=-2*t.dot(_vec3Tmp$8.copy(e).negate()),r=e.lengthSq()-Math.pow(642e4,2),i=(-o+Math.sqrt(o*o-4*r))/2;return n.set(e.x+t.x*i,e.y+t.y*i,e.z+t.z*i)}function rayOpticalDepth(e,t,n){atmosphereIntersection(e,t,_rayEnd);const o=e.distanceTo(_rayEnd),r=_segmentROD.copy(t).multiplyScalar(o);n.set(0,0,0);const i=_vec3Tmp$8,a=_vec3Tmp2$6;for(let t=0;t<8;t++){i.copy(e).addScaledVector(r,QUADRATURE_NODES[t]);const o=i.length()-636e4;a.set(densityRayleigh(o),densityMie(o),densityOzone(o)),n.addScaledVector(a,QUADRATURE_WEIGHTS[t])}return n.multiplyScalar(o)}function compSum(e){return e.x+e.y+e.z}function singleScattering(e,t,n,o,r,i,a){atmosphereIntersection(n,e,_rayEnd);const s=n.distanceTo(_rayEnd)/32,l=_segmentSS.copy(e).multiplyScalar(s);_opticalDepth.set(0,0,0);for(let e=0;e<21;e++)a[e]=0;const c=e.dot(t);_phaseFunction.set(phaseRayleigh(c),phaseMie(c),0),_densityScale.set(o,r,i),_P.copy(n).addScaledVector(l,.5);for(let e=0;e<32;e++){const e=_P.length()-636e4;if(_density.set(densityRayleigh(e),densityMie(e),densityOzone(e)),_density.multiply(_densityScale),_opticalDepth.addScaledVector(_density,s),!surfaceIntersection(_P,t)){rayOpticalDepth(_P,t,_lightOpticalDepth).multiply(_densityScale);const e=_lightOpticalDepth.add(_opticalDepth);for(let t=0;t<21;t++){_extinctionDensity.set(RAYLEIGH_COEFF[t],1.11*2e-5,OZONE_COEFF[t]).multiply(e);const n=Math.exp(-compSum(_extinctionDensity));_scatteringDensity.set(RAYLEIGH_COEFF[t],2e-5,0).multiply(_density),a[t]+=n*compSum(_scatteringDensity.multiply(_phaseFunction))*IRRADIANCE[t]*s}}_P.add(l)}}function precomputeTexture(e,t,n,o,r,i,a,s){const l=Array(21),c=t/2,u=new Vector3(0,0,636e4+r),d=new Vector3;geographicalToDirection(o,0,d);const h=Math.PI/2/n,p=2*Math.PI/t,f=h/2,m=new Vector3,g=new Vector3;for(let o=0;o<n;o++){const r=(Math.PI/2+f)*Math.pow(o/n,2),h=o*t*4;for(let n=0;n<c;n++){geographicalToDirection(r,p*n-Math.PI,m),singleScattering(m,d,u,i,a,s,l),specToXYZ(l,g);const o=4*n;e[h+o]=g.x,e[h+o+1]=g.y,e[h+o+2]=g.z;const c=4*(t-n-1);e[h+c]=g.x,e[h+c+1]=g.y,e[h+c+2]=g.z}}}const N_IN={BACKGROUND_BL:{color:0,strength:1},BSDF_DIFFUSE_BL:{color:0,roughness:1,normal:2},BSDF_GLOSSY_BL:{color:0,roughness:1,anisotropy:2,rotation:3,normal:4,tangent:5},BSDF_METALLIC_BL:{baseColor:0,edgeTint:1,ior:2,extinction:3,roughness:4,anisotropy:5,rotation:6,normal:7,tangent:8},BSDF_PRINCIPLED_BL:{baseColor:0,metallic:1,roughness:2,ior:3,alpha:4,normal:5,diffuseRoughness:6,subsurface:7,subsurfaceRadius:8,subsurfaceScale:9,subsurfaceIor:10,subsurfaceAnisotropy:11,specularIORLevel:12,specularTint:13,anisotropic:14,anisotropicRotation:15,tangent:16,transmission:17,clearcoat:18,clearcoatRoughness:19,clearcoatIor:20,clearcoatTint:21,clearcoatNormal:22,sheen:23,sheenRoughness:24,sheenTint:25,emission:26,emissionStrength:27,thinFilmThickness:28,thinFilmIOR:29},BSDF_PRINCIPLED_BF43_BL:{baseColor:0,metallic:1,roughness:2,ior:3,alpha:4,normal:5,subsurface:6,subsurfaceRadius:7,subsurfaceScale:8,subsurfaceIor:9,subsurfaceAnisotropy:10,specularIORLevel:11,specularTint:12,anisotropic:13,anisotropicRotation:14,tangent:15,transmission:16,clearcoat:17,clearcoatRoughness:18,clearcoatIor:19,clearcoatTint:20,clearcoatNormal:21,sheen:22,sheenRoughness:23,sheenTint:24,emission:25,emissionStrength:26},BSDF_TRANSLUCENT_BL:{color:0,normal:1},BSDF_TRANSPARENT_BL:{color:0},EEVEE_SPECULAR_BL:{baseColor:0,specular:1,roughness:2,emissiveColor:3,transparency:4,normal:5,clearcoat:6,clearcoatRoughness:7,clearcoatNormal:8,ambientOcclusion:9},EMISSION_BL:{color:0,strength:1},LIGHT_PATH_BL:{},MIX_BL:{fac:0,col1:1,col2:2},MIX_SHADER_BL:{fac:0,color1:1,color2:2},NEW_GEOMETRY_BL:{},NORMAL_MAP_BL:{strength:0,normalColor:1},OUTPUT_MATERIAL_BL:{surface:0,volume:1,displacement:2,thickness:3},OUTPUT_WORLD_BL:{surface:0,volume:1},RGB_BL:{},SEPARATE_COLOR_BL:{color:0},TEX_COORD_BL:{},TEX_ENVIRONMENT_BL:{vector:0},TEX_IMAGE_BL:{vector:0},UVMAP_BL:{uv:0},VALUE_BL:{},BITMAP_MX:{uOffset:0,vOffset:1,uTiling:2,vTiling:3,wAngle:4},BITMAP_ENV_MX:{uOffset:0,vOffset:1,uTiling:2,vTiling:3,wAngle:4,normal:5},FALLOFF_MX:{normal:2},MATERIAL_MX:{ambientColor:0,diffuseColor:1,specularColor:2,glossiness:3,specularLevel:4,selfIllum:5,opacity:6,filterColor:7,normal:8,reflection:9,refraction:10,displacement:11},NORMAL_BUMP_MX:{normalColor:0,additionalBump:1,normalMult:2,addBumpMult:3},OPENPBR_SURFACE_MX:{baseWeight:0,baseColor:1,baseMetalness:2,baseDiffuseRoughness:3,specularWeight:4,specularColor:5,specularRoughness:6,specularIOR:7,transmissionWeight:8,transmissionColor:9,transmissionDepth:10,fuzzWeight:11,fuzzColor:12,fuzzRoughness:13,coatWeight:14,coatColor:15,coatRoughness:16,emissionWeight:17,emissionColor:18,emissionLuminance:19,geometryOpacity:20,normal:21,clearcoatNormal:22},OUTPUT_MX:{color:0},PHYSICAL_MX:{base:0,baseColor:1,reflectivity:2,reflColor:3,roughness:4,metalness:5,diffRoughness:6,anisotropy:7,anisoangle:8,transparency:9,transColor:10,transRoughness:11,ior:12,scattering:13,sssColor:14,sssScale:15,emission:16,emitColor:17,clearcoat:18,clearcoatColor:19,clearcoatRoughness:20,normal:21,clearcoatNormal:22,displacement:23,opacity:24},REFLECT_REFRACT_MX:{normal:0},RGB_MX:{},SUB_TRANSFORM_MX:{scale:0,rotate:1,offset:2},VALUE_MX:{},BUMP_2D_MY:{bumpDepth:0,bumpValue:1},COLOR_CONSTANT_MY:{color:0,alpha:1},FILE_MY:{uvCoord:0},FLOAT_CONSTANT_MY:{value:0},LAMBERT_MY:{color:0,ambientColor:1,incandescence:2,matteOpacity:3,diffuse:4,normal:5,translucence:6,transparency:7},OPENPBR_SURFACE_MY:{baseWeight:0,baseColor:1,baseDiffuseRoughness:2,baseMetalness:3,specularWeight:4,specularColor:5,specularRoughness:6,specularIOR:7,transmissionWeight:8,transmissionColor:9,transmissionDepth:10,transmissionScatter:11,fuzzWeight:12,fuzzColor:13,fuzzRoughness:14,coatWeight:15,coatColor:16,coatRoughness:17,emissionLuminance:18,emissionColor:19,geometryOpacity:20,normal:21},PLACE_2D_TEXTURE_MY:{offset:0,repeatUv:1,rotateUv:2},RAMP_MY:{uvCoord:0},SAMPLER_INFO_MY:{viewNorm:0},SHADING_ENGINE_MY:{surface:0,volume:1,displacement:2},SUB_TRANSFORM_MY:{scale:0,rotate:1,offset:2},SURFACE_SHADER_MY:{color:0,glowColor:1,matteOpacity:2,transparency:3},IMAGE_AR:{multiply:0,offset:1,uvcoords:2,soffset:3,toffset:4,sscale:5,tscale:6,sflip:7,tflip:8,swapSt:9,duvdx:10,duvdy:11},LAMBERT_AR:{base:0,baseColor:1,normalCamera:2,opacity:3},MAP_TO_MTL_AR:{color:0},NORMAL_MAP_AR:{inputVal:0,normal:1,strength:2,tangent:3},STANDARD_SURFACE_AR:{base:0,baseColor:1,diffuseRoughness:2,metalness:3,specular:4,specularColor:5,specularRoughness:6,trans:7,transColor:8,transDepth:9,transScatter:10,transExtraRoughness:11,subsurface:12,subsurfaceColor:13,subsurfaceRadius:14,clearcoat:15,clearcoatColor:16,clearcoatRoughness:17,sheen:18,sheenColor:19,sheenRoughness:20,emission:21,emissionColor:22,opacity:23,normal:24,clearcoatNormal:25,specularIOR:26},TRIPLANAR_AR:{inputColor:0,inputColorY:1,inputColorZ:2,scale:3,rotate:4,offset:5,normal:6},TRIPLANAR_UV_AR:{vector:0,normal:1},UV_PROJECTION_AR:{projectionColor:0,uAngle:1,vAngle:2,matrix:3},NORMAL:{},RGB_ALPHA:{},VALUE:{}},N_OUT={BACKGROUND_BL:{color:0},BSDF_DIFFUSE_BL:{color:0},BSDF_GLOSSY_BL:{color:0},BSDF_METALLIC_BL:{color:0},BSDF_PRINCIPLED_BL:{color:0},BSDF_TRANSLUCENT_BL:{color:0},BSDF_TRANSPARENT_BL:{color:0},EEVEE_SPECULAR_BL:{color:0},EMISSION_BL:{color:0},LIGHT_PATH_BL:{isCameraRay:0,isShadowRay:1,isDiffuseRay:2,isGlossyRay:3,isSingularRay:4,isReflectionRay:5,isTransmissionRay:6,rayLength:7,rayDepth:8,diffuseDepth:9,glossyDepth:10,transparentDepth:11,transmissionDepth:12},MIX_BL:{col:0},MIX_SHADER_BL:{color:0},NEW_GEOMETRY_BL:{position:0,normal:1,tangent:2,trueNormal:3,incoming:4,parametric:5,backfacing:6,pointiness:7,randomPerIsland:8},NORMAL_MAP_BL:{normal:0},OUTPUT_MATERIAL_BL:{outgoingLight:0},OUTPUT_WORLD_BL:{outgoingLight:0},RGB_BL:{color:0},SEPARATE_COLOR_BL:{r:0,g:1,b:2},TEX_COORD_BL:{generated:0,normal:1,uv:2,object:3,camera:4,window:5,reflection:6},TEX_ENVIRONMENT_BL:{color:0},TEX_IMAGE_BL:{color:0,alpha:0},UVMAP_BL:{uv:0},VALUE_BL:{value:0},BITMAP_MX:{color:0,value:1},BITMAP_ENV_MX:{color:0,value:1},FALLOFF_MX:{color:0},MATERIAL_MX:{color:0},NORMAL_BUMP_MX:{normal:0},OPENPBR_SURFACE_MX:{color:0},OUTPUT_MX:{outgoingLight:0},PHYSICAL_MX:{color:0},RGB_MX:{color:0},REFLECT_REFRACT_MX:{color:0},SUB_TRANSFORM_MX:{vector:0,normal:1},VALUE_MX:{value:0},BUMP_2D_MY:{normal:0},COLOR_CONSTANT_MY:{color:0,alpha:1},FILE_MY:{alpha:0,color:1,size:2,transparency:3},FLOAT_CONSTANT_MY:{value:0},LAMBERT_MY:{color:0},OPENPBR_SURFACE_MY:{color:0},PLACE_2D_TEXTURE_MY:{uv:0},RAMP_MY:{alpha:0,color:1},SAMPLER_INFO_MY:{facingRatio:0,flippedNormal:1,matrixEyeToWorld:2,normalCamera:3,pixelCenter:4,pointCamera:5,pointObj:6,pointWorld:7,tangentUCamera:8,tangentVCamera:9,uvCoord:10},SHADING_ENGINE_MY:{outgoingLight:0},SUB_TRANSFORM_MY:{vector:0,normal:1},SURFACE_SHADER_MY:{color:0,glowColor:1,matteOpacity:2,transparency:3},IMAGE_AR:{color:0,alpha:1,transparency:2},LAMBERT_AR:{color:0,alpha:1,transparency:2},MAP_TO_MTL_AR:{color:0},NORMAL_MAP_AR:{value:0},STANDARD_SURFACE_AR:{color:0,transparency:1},TRIPLANAR_AR:{color:0},TRIPLANAR_UV_AR:{uv:0,duvdx:1,duvdy:2},UV_PROJECTION_AR:{uv:0},NORMAL:{normal:0},RGB_ALPHA:{color:0,alpha:1},VALUE:{value:0}};function createNode(e,t="",n={}){let o;switch(e){case"BACKGROUND_BL":o={inputs:[[0,0,0,1],1],outputs:[[0,0,0,0]]};break;case"BSDF_DIFFUSE_BL":o={inputs:[[.8,.8,.8,1],0,[0,0,0]],outputs:[[0,0,0,0]]};break;case"BSDF_PRINCIPLED_BL":o={inputs:[[.8,.8,.8,1],0,.5,1.5,1,[0,0,0],0,[1,.2,.1],.05,1.4,0,.5,[1,1,1,1],0,0,[0,0,0],0,0,.03,1.5,[1,1,1,1],[0,0,0],0,.5,[0,0,0,1],[1,1,1,1],0,0,0],outputs:[[0,0,0,0]]};break;case"BSDF_TRANSPARENT_BL":o={inputs:[[1,1,1,1]],outputs:[[0,0,0,0]]};break;case"LIGHT_PATH_BL":o={inputs:[],outputs:[0,0,0,0,0,0,0,0,0,0,0,0,0]};break;case"MIX_BL":o={dataType:"RGBA",clampFactor:!0,blendType:"MIX",clampResult:!1,factorMode:"UNIFORM",inputs:[.5,[.5,.5,.5,1],[.5,.5,.5,1]],outputs:[[0,0,0,0]]};break;case"MIX_SHADER_BL":o={inputs:[.5,[0,0,0,0],[0,0,0,0]],outputs:[[0,0,0,0]]};break;case"OUTPUT_MATERIAL_BL":o={inputs:[[0,0,0,0],[0,0,0,0],[0,0,0],0],outputs:[]};break;case"OUTPUT_WORLD_BL":o={inputs:[[0,0,0,1],[0,0,0,0]],outputs:[]};break;case"RGB_BL":o={inputs:[],outputs:[[.5,.5,.5,1]]};break;case"TEX_ENVIRONMENT_BL":o={projection:"EQUIRECTANGULAR",texture:-1,inputs:[[0,0,0]],outputs:[[0,0,0,0]]};break;case"TEX_IMAGE_BL":o={alphaMode:"STRAIGHT",clampToEdgeNoExtend:!1,projection:"FLAT",projectionBlend:0,texture:-1,inputs:[[0,0,0]],outputs:[[0,0,0,0],0]};break;case"UVMAP_BL":o={uvLayer:"",inputs:[],outputs:[[0,0,0]]};break;case"VALUE_BL":case"VALUE_MX":case"VALUE":o={inputs:[],outputs:[0]};break;case"BITMAP_MX":o={alphaAsMono:!1,alphaAsRGB:!1,alphaSource:"NONE",axis:"XY",clampToEdgeNoExtend:[!1,!1],mapping:"EXPLICIT_MAP_CHANNEL",texture:-1,uvIndex:0,inputs:[0,0,1,1,0],outputs:[[0,0,0,0]]};break;case"PHYSICAL_MX":o={brdfCurve:5,brdfHigh:1,brdfLow:.05,brdfMode:!0,emitLuminance:1500,roughnessInv:!1,thinWalled:!1,transRoughnessInv:!1,transRoughnessLock:!0,inputFactors:[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],inputs:[1,[1,1,1,1],1,[1,1,1,1],.5,0,0,0,0,0,[1,1,1,1],0,1.5,0,[0,0,0,0],0,0,[1,1,1,1],0,[1,1,1,1],0,[0,0,0],[0,0,0],0,1],outputs:[[0,0,0,0]]};break;case"OUTPUT_MX":o={inputs:[[0,0,0,0]],outputs:[]};break;case"RGB_MX":o={inputs:[],outputs:[[0,0,0,1]]};break;case"COLOR_CONSTANT_MY":o={inputs:[[0,0,0],1],outputs:[[0,0,0],0]};break;case"FILE_MY":o={fileHasAlpha:!1,texture:-1,inputs:[[0,0]],outputs:[1,[0,0,0],[2048,2048],[0,0,0]]};break;case"FLOAT_CONSTANT_MY":o={inputs:[0],outputs:[0]};break;case"LAMBERT_MY":o={inputs:[[.5,.5,.5],[0,0,0],[0,0,0],1,.8,[0,0,0],0,[0,0,0]],outputs:[[0,0,0,0]]};break;case"PLACE_2D_TEXTURE_MY":o={uvIndex:0,inputs:[[0,0],[1,1],0],outputs:[[0,0]]};break;case"SHADING_ENGINE_MY":o={inputs:[[0,0,0,0],[0,0,0,0],[0,0,0]],outputs:[]};break;case"LAMBERT_AR":o={inputs:[.7,[1,1,1],[0,0,0],[0,0,0]],outputs:[[0,0,0,0],0,[0,0,0]]};break;case"STANDARD_SURFACE_AR":o={thinWalled:!0,inputs:[1,[.8,.8,.8],0,0,1,[1,1,1],.2,0,[0,0,0],0,[0,0,0],0,0,[1,1,1],[1,1,1],0,[1,1,1],.1,0,[1,1,1],.3,0,[1,1,1],[1,1,1],[0,0,0],[0,0,0],1.5],outputs:[[0,0,0,0],[0,0,0]]};break;case"RGB_ALPHA":o={inputs:[],outputs:[[0,0,0],1]};break;default:console.error("v3d.NodeUtils.createNode: Invalid node:",e)}return o?(o.name=t,o.type=e,["OUTPUT_MATERIAL_BL","OUTPUT_WORLD_BL","OUTPUT_MX","SHADING_ENGINE_MY"].includes(e)?o.is_active_output=!0:o.is_active_output=!1,Object.assign(o,n),{originData:o}):void 0}function getNodeType(e){return e.originData.type}function getNodeTypeCompat(e){let t=getNodeType(e);const n=e.originData;if("BSDF_PRINCIPLED_BL"==t&&29===n.inputs.length)t="BSDF_PRINCIPLED_BF43_BL";if("BUMP_BL"==t&&4===n.inputs.length)t="BUMP_BF44_BL";return t}function nodeOfType(e,t){const n=getNodeType(e);return Array.isArray(t)?t.includes(n):t===n}function firstNodeType(e,t){for(let n=0;n<e.len();n++){if(getNodeType(e.node(n))==t)return n}return-1}function firstNodeName(e,t){for(let n=0;n<e.len();n++){if(e.node(n).originData.name==t)return n}return-1}function findConnectedNode(e,t,n,o=""){if(!Number.isFinite(n))return console.error("v3d.NodeUtils.findConnectedNode: Invalid input index"),null;"object"==typeof t&&(t=e.nodeIndex(t));for(let r in e.edges){const i=e.edges[r];if(i.to()==t){const t=e.node(i.from());for(let e=0;e<i.connections.length;e++){if(i.connections[e].to===n&&(""===o||nodeOfType(t,o)))return t}}}return null}function findAllConnectedNodes(e,t,n,o=""){if(!Number.isFinite(n))return console.error("v3d.NodeUtils.findAllConnectedNodes: Invalid input index"),null;"object"==typeof t&&(t=e.nodeIndex(t));const r=[];for(let i in e.edges){const a=e.edges[i];if(a.to()==t){const t=e.node(a.from());if(o&&!nodeOfType(t,o))continue;for(let e=0;e<a.connections.length;e++){const o=a.connections[e];o.to===n&&r.push({node:t,nodeIdx:a.from(),outputIdx:o.from,channelMatrix:o.channelMatrix})}}}return r}function isConnInput(e,t,n){if(!Number.isFinite(n))return console.error("v3d.NodeUtils.isConnInput: Invalid input index"),!1;const o=e.findInEdges(t);for(let e=0;e<o.length;e++){const t=o[e];for(let e=0;e<t.connections.length;e++){if(t.connections[e].to==n)return!0}}return!1}function isConnOutput(e,t,n){if(!Number.isFinite(n))return console.error("v3d.NodeUtils.isConnOutput: Invalid output index"),!1;for(let o in e.edges){const r=e.edges[o];if(r.from()==t)for(let e=0;e<r.connections.length;e++){if(r.connections[e].from==n)return!0}}return!1}function connectNodes(e,t,n,o,r,i){if(!Number.isFinite(n)||!Number.isFinite(r))return void console.error("v3d.NodeUtils.connectNodes: Invalid input/output index");e.edge(t,o)||e.addNewEdge(t,o);const a=e.edge(t,o);a.connections=a.connections||[];const s={from:n,to:r};i&&(s.channelMatrix=i),a.connections.push(s)}function nodeTypeStripSuffix(e){return e.endsWith("_AR")||e.endsWith("_BL")||e.endsWith("_MX")||e.endsWith("_MY")?e.slice(0,-3):e}function nodeTexUniName(e,t){return strToCamel("NODE_"+nodeTypeStripSuffix(e))+"Uni"+t}function nodeGraphClone(e){const t=new DiGraph(e.len());for(let n=0;n<t.len();n++)nodeClone(e.node(n),t.node(n));for(let n in e.edges){const o=e.edges[n];t.addNewEdge(o.from(),o.to()).connections=o.connections.slice()}return t}function nodeClone(e,t){t||(t={}),t.originData={};for(const n in e.originData)t.originData[n]="texture"==n?e.originData[n]:JSON.parse(JSON.stringify(e.originData[n]));return e.attributes&&(t.attributes=JSON.parse(JSON.stringify(e.attributes))),e.params&&(t.params=JSON.parse(JSON.stringify(e.params))),e.inputFactors&&(t.inputFactors=e.inputFactors.slice(0)),e.inputs&&(t.inputs=JSON.parse(JSON.stringify(e.inputs))),e.outputs&&(t.outputs=JSON.parse(JSON.stringify(e.outputs))),t}function cleanupGraph(e){let t=-1;for(let n=0;n<e.len();n++)if(e.node(n).originData.is_active_output){t=n;break}if(-1==t)e.removeAll();else{const n=new DepthFirstSearch(e.reverse(),t),o=[];for(let t=0;t<e.len();t++)n.hasPathTo(t)||o.push(e.node(t));o.forEach(function(t){e.disconnect(e.nodeIndex(t),!0)})}}function disconnectInputNode(e,t,n,o=""){if(!Number.isFinite(n))return console.error("v3d.NodeUtils.disconnectInputNode: Invalid input index"),null;"object"==typeof t&&(t=e.nodeIndex(t));for(let r in e.edges){const i=e.edges[r];if(i.to()==t){const r=e.node(i.from());if(o&&!nodeOfType(r,o))continue;for(let o=0;o<i.connections.length;o++){const a=i.connections[o];if(a.to===n)return e.removeEdge(i.from(),t),{node:r,outputIdx:a.from}}}}return null}function disconnectOutputNode(e,t,n,o=""){if(!Number.isFinite(n))return console.error("v3d.NodeUtils.disconnectOutputNode: Invalid output index"),null;"object"==typeof t&&(t=e.nodeIndex(t));for(let r in e.edges){const i=e.edges[r];if(i.from()==t){const r=e.node(i.to());if(o&&!nodeOfType(r,o))continue;for(let o=0;o<i.connections.length;o++){const a=i.connections[o];if(a.from==n)return e.removeEdge(t,i.to()),{node:r,inputIdx:a.to}}}}return null}const CURVE_TEX_SIZE=256,RAMP_TEX_SIZE=512,MAX_LIGHT_INT_MULT=1500/Math.PI,NISHITA_SKY_WIDTH=256,NISHITA_SKY_HEIGHT=64,DEFAULT_NORMAL_INPUT_NUM={LAMBERT_AR:2,STANDARD_SURFACE_AR:24,BEVEL_BL:1,BSDF_DIFFUSE_BL:2,BSDF_GLASS_BL:3,BSDF_GLOSSY_BL:4,BSDF_METALLIC_BL:7,BSDF_PRINCIPLED_BL:5,BSDF_PRINCIPLED_BF43_BL:5,BSDF_REFRACTION_BL:3,BSDF_SHEEN_BL:2,BSDF_TRANSLUCENT_BL:1,BUMP_BL:4,BUMP_BF44_BL:3,EEVEE_SPECULAR_BL:5,FRESNEL_BL:1,LAYER_WEIGHT_BL:1,BLINN_MY:5,LAMBERT_MY:5,OPENPBR_SURFACE_MY:21,PHONG_MY:5,PHONG_E_MY:5,SAMPLER_INFO_MY:0},STD_SHADER_NODES_BL=["BSDF_DIFFUSE_BL","BSDF_GLOSSY_BL","BSDF_METALLIC_BL","BSDF_PRINCIPLED_BL","EEVEE_SPECULAR_BL","EMISSION_BL"],STD_SHADER_NODES_MX=["PHYSICAL_MX","LAMBERT_AR","OPENPBR_SURFACE_MX","STANDARD_SURFACE_AR","MAP_TO_MTL_AR"],STD_SHADER_NODES_MY=["STANDARD_SURFACE_AR","LAMBERT_MY","LAMBERT_AR","OPENPBR_SURFACE_MY","SURFACE_SHADER_MY"],STD_PROP_DEFAULTS={color:new Color(16777215),map:null,opacity:1,alphaMap:null,metalness:.5,metalnessMap:null,roughness:.5,roughnessMap:null,normalMap:null,normalScale:new Vector2(1,1),aoMap:null,aoMapIntensity:1,emissive:new Color(0),emissiveMap:null,emissiveIntensity:0};class MeshNodeMaterial extends Material{constructor(e){super();const t=this;function n(e,t){const n=e.node(t);n.originData.type;for(let r=0;r<n.originData.inputs.length;r++)o(e,t,n.originData,r)}function o(e,t,n,o,r){if(isConnInput(e,t,o))return!1;const i=n.name+" "+(r||"Input "+o),a=n.inputs[o],s=R(a);let l,c,u=n.type.slice(-3);switch("_BL"!=u&&"_MX"!=u&&(u="float"==s?"":"_ALPHA"),s){case"float":l=createNode("VALUE"+u,i),c=N_OUT[getNodeType(l)].value,l.originData.outputs[c]=a;break;case"vec3":l=createNode("RGB"+u,i),c=N_OUT[getNodeType(l)].color,l.originData.outputs[c][0]=a[0],l.originData.outputs[c][1]=a[1],l.originData.outputs[c][2]=a[2];break;case"vec4":l=createNode("RGB"+u,i),c=N_OUT[getNodeType(l)].color,l.originData.outputs[c][0]=a[0],l.originData.outputs[c][1]=a[1],l.originData.outputs[c][2]=a[2],nodeOfType(l,"RGB_ALPHA")?l.originData.outputs[N_OUT[getNodeType(l)].alpha]=a[3]:l.originData.outputs[c][3]=a[3];break;default:throw new Error("Unsupported group input")}return e.addNode(l),connectNodes(e,e.len()-1,c,t,o),!0}function r(e,t,n){const o={inputs:[],outputs:[],removedNodes:[]};o.removedNodes.push(n);const r=firstNodeType(t,"GROUP_INPUT_BL");if(r>-1){o.removedNodes.push(r+e.len());const i=e.findInEdges(n),s=t.findOutEdges(r);for(let e=0;e<i.length;e++){const t=i[e];for(let e=0;e<s.length;e++){const n=s[e];for(let e=0;e<t.connections.length;e++){const r=t.connections[e];for(let e=0;e<n.connections.length;e++){const i=n.connections[e];if(r.to==i.from){let e=a(o.inputs,t.from(),n.to());e||(e=new Edge(t.from(),n.to()),e.connections=[],o.inputs.push(e));const s={from:r.from,to:i.to};e.connections.push(s)}}}}}}const i=firstNodeType(t,"GROUP_OUTPUT_BL");o.removedNodes.push(i+e.len());const s=e.findOutEdges(n),l=t.findInEdges(i);for(let e=0;e<s.length;e++){const t=s[e];for(let e=0;e<l.length;e++){const n=l[e];for(let e=0;e<t.connections.length;e++){const r=t.connections[e];for(let e=0;e<n.connections.length;e++){const i=n.connections[e];if(r.from==i.to){let e=a(o.outputs,n.from(),t.to());e||(e=new Edge(n.from(),t.to()),e.connections=[],o.outputs.push(e));const s={from:i.from,to:r.to};e.connections.push(s)}}}}}return o}function i(e,t){Array.isArray(t)||(t=[t]);let n=0;for(let o=0;o<e.len();o++){const r=e.node(o);for(let e=0;e<t.length;e++){const o=t[e];r.originData.type==o&&n++}}return n}function a(e,t,n){for(let o=0;o<e.length;o++){const r=e[o];if(r.from()==t&&r.to()==n)return r}return null}function s(e,t,n){const o=n.type;let r=e.findInEdges(t);for(let i=0;i<r.length;i++){const a=r[i];let s=e.node(a.from()).originData;for(let d=0;d<a.connections.length;d++){const h=a.connections[d];if("MATERIAL_MX"==o&&c(s.type)&&(h.to==N_IN[o].reflection?s.reflectMode="MAX_ENV_COORDS_REFLECT":h.to==N_IN[o].refraction&&(s.reflectMode="MAX_ENV_COORDS_REFRACT")),u(o,h.to)){if("BITMAP_MX"==s.type||"OUTPUT_MAP_MX"==s.type){e.removeEdge(a.from(),a.to()),"OUTPUT_MAP_MX"==s.type&&(s=findConnectedNode(e,a.from(),0).originData);const n={originData:{name:s.name+"Bump"+i,type:"BUMP_MX",texture:s.texture,uvIndex:s.uvIndex,inputs:JSON.parse(JSON.stringify(s.inputs)),outputs:[[0,0,0]]}};e.addNode(n),connectNodes(e,e.len()-1,0,t,h.to),i=-1,r=e.findInEdges(t);break}for(let t=0;t<e.len();t++){const o=e.node(t).originData;if(l(o.type)){const r=o.inputs.length-1;connectNodes(e,a.from(),h.from,t,r),o.inputFactors[r]=n.inputFactors[h.to]}}}}}}function l(e){return!(!c(e)&&"FALLOFF_MX"!=e)}function c(e){return"BITMAP_ENV_MX"==e||"REFLECT_REFRACT_MX"==e}function u(e,t){switch(e){case"BITMAP_ENV_MX":case"FALLOFF_MX":case"MATERIAL_MX":case"REFLECT_REFRACT_MX":return t==N_IN[e].normal;case"OPENPBR_SURFACE_MX":case"PHYSICAL_MX":return t==N_IN[e].normal||t==N_IN[e].clearcoatNormal;default:return!1}}function d(e,t,n){const o=n.blendMode.length,r=e.findInEdges(t),i=e.findOutEdges(t);for(let t=0;t<o;t++){const o={originData:{name:n.name+"Layer"+t,type:"COMPOSITE_LAYER_MX",blendMode:0!=t?n.blendMode[t]:0,opacity:n.opacity[t],inputs:[[0,0,0,0]].concat(n.inputs.slice(2*t,2*t+2)),outputs:[n.outputs[t]]}};e.addNode(o);for(let o=0;o<r.length;o++){const i=r[o];for(let o=0;o<i.connections.length;o++){const r=i.connections[o];r.to==2*t&&n.mapEnabled[t]?connectNodes(e,i.from(),r.from,e.len()-1,1):r.to==2*t+1&&n.maskEnabled[t]&&connectNodes(e,i.from(),r.from,e.len()-1,2)}}t>0&&connectNodes(e,e.len()-2,0,e.len()-1,0)}for(let t=0;t<i.length;t++){const n=i[t];for(let t=0;t<n.connections.length;t++){const o=n.connections[t];connectNodes(e,e.len()-1,0,n.to(),o.to)}}}function h(e,t,n){const o=n.output,r=e.findInEdges(t),i=e.findOutEdges(t),a={originData:{name:n.name+"Output",type:"OUTPUT_MAP_MX",invert:o.invert,clamp:o.clamp,alphaFromRGB:o.alphaFromRGB,inputs:[[0,0,0,0],o.rgbLevel,o.rgbOffset,o.outputAmount,o.bumpAmount],outputs:[[0,0,0,0]]}};isDef(o.colorMap)&&(a.originData.colorMap=o.colorMap),e.addNode(a);for(let t=0;t<i.length;t++){const n=i[t];for(let t=0;t<n.connections.length;t++){const o=n.connections[t];connectNodes(e,e.len()-1,0,n.to(),o.to)}}e.disconnect(t,!1);for(let t=0;t<r.length;t++)e.addEdge(r[t]);connectNodes(e,t,0,e.len()-1,0),delete n.output}function p(e,t,n){const o=n.inputs.length/4,r=e.findInEdges(t),i=e.findOutEdges(t);for(let t=0;t<o;t++){const o={originData:{name:n.name+"Layer"+t,type:"LAYERED_TEXTURE_LAYER_MY",inputs:[0,[0,0,0]].concat(n.inputs.slice(4*t,4*t+4)),outputs:[0,[0,0,0]]}};e.addNode(o);for(let n=0;n<r.length;n++){const o=r[n];for(let n=0;n<o.connections.length;n++){const r=o.connections[n];r.to==4*t?connectNodes(e,o.from(),r.from,e.len()-1,2,r.channelMatrix):r.to==4*t+1?connectNodes(e,o.from(),r.from,e.len()-1,3,r.channelMatrix):r.to==4*t+2?connectNodes(e,o.from(),r.from,e.len()-1,4,r.channelMatrix):r.to==4*t+3&&connectNodes(e,o.from(),r.from,e.len()-1,5,r.channelMatrix)}}t>0&&(connectNodes(e,e.len()-1,0,e.len()-2,0),connectNodes(e,e.len()-1,1,e.len()-2,1))}for(let t=0;t<i.length;t++){const n=i[t];for(let t=0;t<n.connections.length;t++){const r=n.connections[t];connectNodes(e,e.len()-o,r.from,n.to(),r.to,r.channelMatrix)}}}function f(e){return e.type.indexOf("uniform")>-1}function m(e){return e.type.indexOf("varying")>-1}function g(e){return t.nodeUVAliases[e]||"uv"}function _(e,n){return n=isDef(n)?n:"color",t.nodeVCAliases[e]||n}function A(e,t,n,o){const r=new DataTexture(e,t,1,n,o,Texture.DEFAULT_MAPPING,1001,1001,1006,1006);return r.name="Node.parametric",r.needsUpdate=!0,r}function v(e){return!0===e.isVideoTexture&&3001===e.encoding?"1":!e.isDataTexture||3001!==e.encoding||1015!=e.type&&1016!=e.type?"0":"1"}function x(e,t,n,o,r){let i;return t==n?i=e:"float"==t&&"vec3"==n?i="vec3("+[e,e,e].join(",")+")":"float"==t&&"vec4"==n?i="vec4("+[e,e,e,e].join(",")+")":"vec3"==t&&"float"==n||"vec4"==t&&"float"==n?i="("+[e+"[0]",e+"[1]",e+"[2]"].join("+")+")/3.0":"vec3"==t&&"vec4"==n?i="vec4("+e+", 1.0)":"vec4"==t&&"vec3"==n?i="vec3("+[e+"[0]",e+"[1]",e+"[2]"].join(",")+")":"float"==t&&"int"==n?i="int("+e+")":"int"==t&&"float"==n?i="float("+e+")":"int"==t&&"vec3"==n?i="vec3("+[e,e,e].join(",")+")":"int"==t&&"vec4"==n?i="vec4("+[e,e,e,e].join(",")+")":"bool"==t&&"float"==n?i="float("+e+")":console.error("MeshNodeMaterial: Missing type conversion: "+t+" -> "+n),(r<1||1!=r&&"normal"==o)&&(i="mix("+o+","+i+","+N(r)+")","normal"==o&&(i="normalize("+i+")")),i}function y(e,t,n,o,r){let i;const a=[],s=B(n),l=B(o);for(let n=0;n<l;n++){let o=1==l?r:r+"["+n+"]";for(let r=0;r<e.length;r++){const i=e[r],a=t[r];for(let e=0;e<s;e++)a[e][n]&&(o=1==s?i:i+"["+e+"]")}a.push(o)}return i=o+"("+a.join(",")+")",i}function b(e,t,n,o,r,i){for(let a in e.edges){const s=e.edges[a];if(s.to()==t){const t=e.node(s.from());for(let e=0;e<s.connections.length;e++){const a=s.connections[e];if(a.to==n){const e=t.originData.type;"BITMAP_MX"!=e&&"BITMAP_ENV_MX"!=e||"float"!=R(o)?r.push(t.outputs[a.from]):r.push(t.outputs[a.from+1]),a.channelMatrix&&i.push(a.channelMatrix)}}}}}function C(e){return{name:"",type:R(e),value:e}}function S(e,n){const o=nodeTexUniName(e,n);return{name:o,type:t.nodeTextures[o].isCubeTexture?"uniform samplerCube":"uniform sampler2D",value:""}}function E(e){return{name:"",type:"int",value:e}}function M(e){return T(e?"true":"false")}function T(e){return{name:e,type:"",value:""}}function w(e,t,n){return n=n||e,{name:"nodeVaryParam"+strTitle(e),type:"varying "+L(t),value:"",attrBindName:n}}function I(e){return e?1:0}function R(e){return"number"==typeof e?"float":"boolean"==typeof e?"bool":L(e.length)}function L(e){switch(e){case 1:return"float";case 2:return"vec2";case 3:return"vec3";case 4:return"vec4";case 9:return"mat3";case 16:return"mat4"}}function B(e){switch(e){case"float":case"int":case"bool":return 1;case"vec2":return 2;case"vec3":return 3;case"vec4":return 4;case"mat3":return 9;case"mat4":return 16}}function P(e,t){switch(e){case"float":return N(t);case"bool":case"int":return String(t);default:const n=[];for(let e=0;e<t.length;e++)n.push(N(t[e]));return e+"("+n.join(",")+")"}}function N(e){return e%1?String(e):String(e)+".0"}this.isMeshNodeMaterial=!0,this.type="MeshNodeMaterial",this.defines={LIGHT_PATH_IS_CAM_RAY:1,WORLD_NODES:0,NORMAL_OUTPUT:0},this.definesFragOnly=new Set(["LIGHT_PATH_IS_CAM_RAY","WORLD_NODES","NORMAL_OUTPUT"]),this.wireframe=!1,this.wireframeLinewidth=1,this.flatShading=!1,this.fog=!0,this.profile="blender",this.nodeTextures={},this.nodeValue=[],this.nodeValueMap={},this.nodeRGB=[],this.nodeRGBMap={},this.nodeTexCoordObject=[],this.nodeTexCoordObjectMap={},this.nodeInputs={},this.needsBoundingBox=!1,this.useFloatTex=!1,this.nodeGraph=null,this.additionalNodeGraphs={},this.nodeChunks={},this.nodeChunksHash=0,this.nodeVCAliases={},this.nodeUVAliases={},this.envMap=null,this.envMapIntensity=1,this.envMapParallaxType=0,this.envMapParallaxMatrix=new Matrix4,this.envMapParallaxMatrixInv=new Matrix4,this.materialIndex=0,this.ssrParams=null,isDef(e)&&this.setValues(e),this.nodeGraph||(this.nodeGraph=function(){const e=new DiGraph(1),n=t.color;return e.node(0).originData={name:"ShadelessOutput",type:"OUTPUT_MATERIAL_BL",inputs:[[n.r,n.g,n.b,1],[0,0,0,0],[0,0,0]],outputs:[],is_active_output:!0},e}()),this.updateNodeGraph=function(e=!1){const n=this.nodeValue,o=this.nodeRGB,r=this.nodeTexCoordObject;this.nodeTextures={},this.nodeRGB=[],this.nodeRGBMap={},this.nodeValue=[],this.nodeValueMap={},this.nodeTexCoordObject=[],this.nodeTexCoordObjectMap={},this.needsBoundingBox=!1,this.nodeChunks={};const a=this.nodeGraph;if(function(e){let n=0,o=0,r=0,a=0,s=0;for(let l=0;l<e.len();l++){const c=e.node(l),u=c.originData,d=u.type;let h,p,f,m,x,y,b,L,B,N,D;c.attributes=[],c.params=[],c.inputFactors=[],c.inputs=[],c.outputs=[],isDef(u.inputFactors)&&(c.inputFactors=u.inputFactors.slice(0));for(let e=0;e<u.outputs.length;e++){const t=u.outputs[e],n=u.outputTypes?u.outputTypes[e]:R(t);c.outputs.push({name:strToCamel(nodeTypeStripSuffix(d))+l+"Out"+e,type:n,clamp:!1,normalize:!1})}switch("OUTPUT_MATERIAL_BL"!=d&&"OUTPUT_WORLD_BL"!=d&&"OUTPUT_MX"!=d&&"SHADING_ENGINE_MY"!=d&&"SKYDOME_LIGHT_AR"!=d||c.outputs.push({name:"outgoingLight",type:"",clamp:!1,normalize:!1}),d){case"ATAN_AR":c.params.push(T(u.units));break;case"CLAMP_AR":case"COLOR_TO_FLOAT_AR":case"COLOR_TO_FLOAT_AR":case"FLOAT_TO_INT_AR":case"LENGTH_AR":case"MIX_SHADER_AR":case"RGB_TO_FLOAT_AR":case"RGB_TO_VECTOR_AR":case"RGBA_TO_FLOAT_AR":case"RGB_TO_VECTOR_AR":case"VECTOR_TO_RGB_AR":c.params.push(T(u.mode));break;case"COLOR_CONVERT_AR":c.params.push(T(u.from)),c.params.push(T(u.to));break;case"CHECKERBOARD_AR":case"PLACE_2D_TEXTURE_MY":h=u.uvIndex?"uv"+String(u.uvIndex+1):"uv",p=w(h,2),c.attributes.push({name:h,type:"attribute vec2"}),c.params.push(p);break;case"COMPOSITE_AR":c.params.push(T(u.operation)),c.params.push(T(u.alphaOperation));break;case"FACING_RATIO_AR":case"FACING_RATIO_AR":case"SHADOW_MATTE_AR":case"NORMAL":c.params.push(T("normal"));break;case"COMPARE_AR":c.params.push(T(u.test));break;case"IMAGE_AR":y=u.texture,t.nodeTextures[nodeTexUniName(d,n)]=y,c.params.push(S(d,n)),n++,c.params.push(T(v(y)));break;case"LAMBERT_AR":case"BSDF_GLASS_BL":case"BSDF_GLOSSY_BL":case"BLINN_MY":case"LAMBERT_MY":case"PHONG_MY":case"PHONG_E_MY":c.params.push(T("geometryNormal"));break;case"MAP_TO_MTL_AR":c.params.push(M(u.opaqueEnabled));break;case"MATRIX_TRANSFORM_AR":c.params.push(T(u.transformOrder)),c.params.push(T(u.rotationType)),c.params.push(T(u.rotationUnits)),c.params.push(T(u.rotationOrder));break;case"NORMAL_MAP_AR":h="tangent",p=w(h,4),c.attributes.push({name:h,type:"attribute vec4"}),c.params.push(p);break;case"SHUFFLE_AR":case"CHANNELS_MY":c.params.push(T(u.channelR)),c.params.push(T(u.channelG)),c.params.push(T(u.channelB)),c.params.push(T(u.channelA));break;case"STANDARD_SURFACE_AR":c.params.push(T("geometryNormal")),c.params.push(M(u.thinWalled)),(u.inputs[N_IN[d].clearcoat]>0||isConnInput(e,l,N_IN[d].clearcoat))&&(t.defines.USE_CLEARCOAT=""),(u.inputs[N_IN[d].sheen]>0||isConnInput(e,l,N_IN[d].sheen))&&(t.defines.USE_SHEEN=""),c.inputFactors.length=0;break;case"TRIGO_AR":c.params.push(T(u.function)),c.params.push(T(u.units));break;case"TRIPLANAR_AR":c.params.push(T(u.coordSpace)),c.params.push(M(u.inputPerAxis)),c.params.push(M(u.flipOnOppositeDirection)),c.params.push(C(u.blendFactor));break;case"TRIPLANAR_UV_AR":c.params.push(M(u.flipOnOppositeDirection)),void 0!==u.blendFactor&&c.params.push(C(u.blendFactor)),void 0!==u.projectionAxis&&c.params.push(T(u.projectionAxis));break;case"TWO_SIDED_AR":c.params.push(T("faceDirection"));break;case"USER_DATA_COLOR_AR":h=_(u.colorLayer,""),h?(p=w(h,4),c.attributes.push({name:h,type:"attribute vec4"}),c.params.push(p)):c.params.push(T(P("vec4",u.defaultColor)));break;case"UV_PROJECTION_AR":c.params.push(T(u.projectionType)),c.params.push(T(u.coordSpace));break;case"ATTRIBUTE_BL":case"VERTEX_COLOR_BL":h=_(u.colorLayer,""),h?(p=w(h,4),c.attributes.push({name:h,type:"attribute vec4"}),c.params.push(p)):c.params.push(T("vec4(0.0, 0.0, 0.0, 1.0)"));break;case"BSDF_METALLIC_BL":c.params.push(T("geometryNormal")),c.params.push(T("BSDF_METALLIC_"+u.distribution)),c.params.push(M("PHYSICAL_CONDUCTOR"===u.fresnelType));break;case"BSDF_PRINCIPLED_BL":c.params.push(T("geometryNormal"));const R=getNodeTypeCompat(c);(u.inputs[N_IN[R].clearcoat]>0||isConnInput(e,l,N_IN[R].clearcoat))&&(t.defines.USE_CLEARCOAT=""),(u.inputs[N_IN[R].sheen]>0||isConnInput(e,l,N_IN[R].sheen))&&(t.defines.USE_SHEEN_BLENDER="");break;case"BSDF_REFRACTION_BL":c.params.push(T("geometryNormal")),c.params.push(T("BSDF_REFRACTION_"+u.distribution));break;case"BUMP_BL":c.params.push(C(u.invert));break;case"CAMERA_BL":c.params.push(T("vViewPosition")),i(e,"OUTPUT_MATERIAL_BL")>0||i(e,"OUTPUT_WORLD_BL")>0?c.params.push(M(!0)):c.params.push(M(!1));break;case"CLAMP_BL":c.params.push(T("RANGE"==u.clampType));break;case"COMBINE_COLOR_BL":c.params.push(T("NODE_COMB_COL_"+u.mode));break;case"CURVE_FLOAT_BL":t.useFloatTex?(f=new Float32Array(1024),m=1):(f=new Uint8Array(1024),m=255);for(let e=0;e<256;e++){let t=m*(u.curveData[e]/2+.5);f[4*e]=clamp(t,0,m)}y=A(f,256,1023,t.useFloatTex?1015:1009),b=nodeTexUniName(d,o),t.nodeTextures[b]=y,c.params.push(S(d,o)),o++;break;case"CURVE_RGB_BL":case"CURVE_VEC_BL":t.useFloatTex?(f=new Float32Array(1024),m=1):(f=new Uint8Array(1024),m=255);for(let e=0;e<256;e++){let t,n,o,r;B=u.curveData.length/256,B>3?(t=m*u.curveData[B*e],n=m*u.curveData[B*e+1],o=m*u.curveData[B*e+2],r=m*u.curveData[B*e+3]):(t=m*(u.curveData[B*e]/2+.5),n=m*(u.curveData[B*e+1]/2+.5),o=m*(u.curveData[B*e+2]/2+.5),r=m),f[4*e]=clamp(t,0,m),f[4*e+1]=clamp(n,0,m),f[4*e+2]=clamp(o,0,m),f[4*e+3]=clamp(r,0,m)}y=A(f,256,1023,t.useFloatTex?1015:1009),b=nodeTexUniName(d,o),t.nodeTextures[b]=y,c.params.push(S(d,o)),o++;break;case"EEVEE_SPECULAR_BL":c.params.push(T("geometryNormal")),(u.inputs[N_IN[d].clearcoat]>0||isConnInput(e,l,N_IN[d].clearcoat))&&(t.defines.USE_CLEARCOAT="");break;case"FRESNEL_BL":case"LAYER_WEIGHT_BL":case"INCIDENT":case"POSITION":c.params.push(T("vViewPosition"));break;case"GRADIENT_MX":c.params.push(T(P("float",u.color2Pos))),c.params.push(T(P("int",u.gradientType))),h=u.uvIndex?"uv"+String(u.uvIndex+1):"uv",p=w(h,2),c.attributes.push({name:h,type:"attribute vec2"}),c.params.push(p),c.params.push(T("vViewPosition")),c.params.push(T("MAPPING_"+u.mapping)),c.params.push(T("AXIS_"+u.axis)),c.params.push(T(P("ivec2",[I(u.clampToEdgeNoExtend[0]),I(u.clampToEdgeNoExtend[1])])));break;case"GRADIENT_RAMP_MX":t.useFloatTex?(f=new Float32Array(2048),m=1):(f=new Uint8Array(2048),m=255);for(let e=0;e<512;e++){let t,n,o,r;t=m*u.gradientData[3*e],n=m*u.gradientData[3*e+1],o=m*u.gradientData[3*e+2],r=1,f[4*e]=clamp(t,0,m),f[4*e+1]=clamp(n,0,m),f[4*e+2]=clamp(o,0,m),f[4*e+3]=clamp(r,0,m)}y=A(f,512,1023,t.useFloatTex?1015:1009),b=nodeTexUniName(d,o),t.nodeTextures[b]=y,c.params.push(S(d,o)),o++,c.params.push(T(P("int",u.gradientType))),h=u.uvIndex?"uv"+String(u.uvIndex+1):"uv",p=w(h,2),c.attributes.push({name:h,type:"attribute vec2"}),c.params.push(p),c.params.push(T("geometryNormal")),c.params.push(T("vViewPosition")),["SPHERICAL_ENVIRONMENT","CYLINDRICAL_ENVIRONMENT","SHRINK_WRAP_ENVIRONMENT","SCREEN"].indexOf(u.mapping)>-1?c.params.push(T("MAPPING_EXPLICIT_MAP_CHANNEL")):c.params.push(T("MAPPING_"+u.mapping)),c.params.push(T("AXIS_"+u.axis)),c.params.push(T(P("ivec2",[I(u.clampToEdgeNoExtend[0]),I(u.clampToEdgeNoExtend[1])])));break;case"MAPPING_BL":c.params.push(T("NODE_MAPPING_"+u.vectorType));break;case"MAP_RANGE_BL":isDef(u.dataType)&&c.params.push(T("NODE_MAP_RANGE_TYPE_"+u.dataType)),c.params.push(T("NODE_MAP_RANGE_INTERP_"+u.interpolationType)),c.params.push(M(u.clamp));break;case"NEW_GEOMETRY_BL":c.params.push(T("faceDirection")),c.params.push(T("vViewPosition")),c.params.push(T("normal")),isConnOutput(e,l,N_OUT.NEW_GEOMETRY_BL.tangent)&&(t.needsBoundingBox=!0);break;case"NORMAL_MAP_BL":h="tangent",p=w(h,4),c.attributes.push({name:h,type:"attribute vec4"}),c.params.push(p),c.params.push(T("vNormal"));break;case"SEPARATE_COLOR_BL":c.params.push(T("NODE_SEP_COL_"+u.mode));break;case"TANGENT_BL":"RADIAL"===u.directionType?(c.params.push(T("TANGENT_AXIS_"+u.axis)),c.params.push(T("vViewPosition")),c.params.push(T("normal")),t.needsBoundingBox=!0):"UV_MAP"===u.directionType&&(h="tangent",p=w(h,4),c.attributes.push({name:h,type:"attribute vec4"}),c.params.push(p));break;case"TEX_BRICK_BL":c.params.push(T(P("float",u.offset))),c.params.push(T(P("int",u.offsetFrequency))),c.params.push(T(P("float",u.squash))),c.params.push(T(P("int",u.squashFrequency)));break;case"TEX_COORD_BL":c.params.push(T(`nodeTexCoordObjectMatrices[${a}]`)),c.params.push(T("vViewPosition")),c.params.push(T("normal")),h="uv",p=w(h,2),c.attributes.push({name:h,type:"attribute vec2"}),c.params.push(p),isConnOutput(e,l,N_OUT.TEX_COORD_BL.generated)&&(t.needsBoundingBox=!0),t.nodeTexCoordObject.push(null),t.nodeTexCoordObjectMap[u.name]=a,a++;break;case"TEX_ENVIRONMENT_BL":case"TEX_IMAGE_BL":if(y=u.texture,t.nodeTextures[nodeTexUniName(d,n)]=y,c.params.push(S(d,n)),n++,c.params.push(T(v(y))),"TEX_ENVIRONMENT_BL"==d){const e=u.projection;c.params.push(T("TEX_PROJ_"+e))}else if("TEX_IMAGE_BL"==d){let t;switch(u.alphaMode){case"STRAIGHT":t=isConnOutput(e,l,1)?"TEX_ALPHA_CLEAR":"TEX_ALPHA_PREMUL";break;case"PREMUL":t=isConnOutput(e,l,1)?"TEX_ALPHA_UNPREMUL":"TEX_ALPHA_CLEAR";break;case"CHANNEL_PACKED":t="TEX_ALPHA_CLEAR";break;case"NONE":t="TEX_ALPHA_ONE";break;default:console.error("MeshNodeMaterial: incorrect TEX_IMAGE_BL alpha mode"),t="TEX_ALPHA_ONE"}c.params.push(T(t)),c.params.push(T("normal"));const n=u.projection;c.params.push(T("TEX_PROJ_"+n)),c.params.push(C(u.projectionBlend)),c.params.push(M(u.clampToEdgeNoExtend))}break;case"TEX_GABOR_BL":c.params.push(T("TEX_GABOR_"+u.gaborType));break;case"TEX_GRADIENT_BL":c.params.push(T("TEX_GRAD_"+u.gradientType));break;case"TEX_MAGIC_BL":c.params.push(E(u.turbulenceDepth??2));break;case"TEX_NOISE_BL":isDef(u.noiseType)&&c.params.push(T("TEX_NOISE_"+u.noiseType)),c.params.push(T(P("float",u.falloffFactor))),c.params.push(T(P("float",u.dispersionFactor)));break;case"TEX_SKY_BL":if("PREETHAM"==u.skyType||"HOSEK_WILKIE"==u.skyType){let e,t,n,o,r,i;if(D=(new Vector3).fromArray(u.sunDirection).angleTo(new Vector3(0,0,1)),"PREETHAM"==u.skyType)e=getDistParams(u.turbidity,0).concat([0,0,0,0]),t=getDistParams(u.turbidity,1).concat([0,0,0,0]),n=getDistParams(u.turbidity,2).concat([0,0,0,0]),o=getZenithParams(u.turbidity,D,0),r=getZenithParams(u.turbidity,D,1),i=getZenithParams(u.turbidity,D,2);else{const a=Math.max(Math.PI/2-D,0);e=getDistParams$1(u.turbidity,u.groundAlbedo,a,0),t=getDistParams$1(u.turbidity,u.groundAlbedo,a,1),n=getDistParams$1(u.turbidity,u.groundAlbedo,a,2),o=getRadiance(u.turbidity,u.groundAlbedo,a,0),r=getRadiance(u.turbidity,u.groundAlbedo,a,1),i=getRadiance(u.turbidity,u.groundAlbedo,a,2)}c.params.push(T("TEX_SKY_"+u.skyType)),c.params.push(C([e[0],t[0],n[0]])),c.params.push(C([e[1],t[1],n[1]])),c.params.push(C([e[2],t[2],n[2]])),c.params.push(C([e[3],t[3],n[3]])),c.params.push(C([e[4],t[4],n[4]])),c.params.push(C([e[5],t[5],n[5]])),c.params.push(C([e[6],t[6],n[6]])),c.params.push(C([e[7],t[7],n[7]])),c.params.push(C([e[8],t[8],n[8]])),c.params.push(C([o,r,i])),c.params.push(C(u.sunDirection))}else{f=new Float32Array(65536),precomputeTexture(f,256,64,u.sunElevation,u.altitude,u.airDensity,u.aerosolDensity,u.ozoneDensity),y=new DataTexture(f,256,64,1023,1015,Texture.DEFAULT_MAPPING,1e3,1001,1006,1006),y.name="Node.nishita",y.needsUpdate=!0,b=nodeTexUniName(d,o),t.nodeTextures[b]=y,c.params.push(S(d,o)),o++;let e=angleToRange_0_2Pi(u.sunRotation);e=2*Math.PI-e,c.params.push(C(e))}break;case"TEX_VORONOI_BL":c.params.push(T("DISTANCE_"+u.distance)),c.params.push(T("FEATURE_"+u.feature));break;case"TEX_WAVE_BL":c.params.push(T("TEX_WAVE_TYPE_"+u.waveType)),c.params.push(T("TEX_WAVE_PROFILE_"+u.waveProfile)),c.params.push(T(`TEX_WAVE_BANDS_DIR_${u.bandsDirection}`)),c.params.push(T(`TEX_WAVE_RINGS_DIR_${u.ringsDirection}`));break;case"MATH_BL":c.outputs[0].clamp=u.useClamp;break;case"MIX_BL":switch(c.originData.blendType){case"HUE":case"SATURATION":case"VALUE":case"COLOR":t.defines.HSV_NODES=""}"RGBA"==u.dataType&&(c.outputs[0].clamp=u.clampResult);break;case"MIX_SHADER_BL":let O=-1;for(let t=1;t<3;t++){const n=findConnectedNode(e,l,t);n&&"BSDF_TRANSPARENT_BL"==n.originData.type&&(O=t-1)}c.params.push(T(String(O)));break;case"NORMAL_BL":c.params.push(C(u.outputs[0]));break;case"RGB_BL":case"RGB_MX":L=(new Vector4).fromArray(u.outputs[0]),t.nodeRGB.push(L),t.nodeRGBMap[u.name]=r,c.params.push(T("nodeRGB["+r+"]")),r++;break;case"SUB_TRANSFORM_MX":case"SUB_TRANSFORM_MY":c.params.push(T(u.coordSpace));break;case"UVMAP_BL":h=g(u.uvLayer),p=w(h,2),c.attributes.push({name:h,type:"attribute vec2"}),c.params.push(p);break;case"VALUE_BL":case"VALUE_MX":case"ANIM_CURVE_TA_MY":case"ANIM_CURVE_TU_MY":case"VALUE":L=u.outputs[0],t.nodeValue.push(L),t.nodeValueMap[u.name]=s,c.params.push(T("nodeValue["+s+"]")),s++;break;case"VALTORGB_BL":N=u.curve;const F=new("STEP"==N.interpolation?DiscreteInterpolant:LinearInterpolant)(new Float32Array(N.input),new Float32Array(N.output),4);t.useFloatTex?(f=new Float32Array(1024),m=1):(f=new Uint8Array(1024),m=255);for(let e=0;e<256;e++){const t=F.evaluate(e/255);f[4*e]=m*t[0],f[4*e+1]=m*t[1],f[4*e+2]=m*t[2],f[4*e+3]=m*t[3]}y=A(f,256,1023,t.useFloatTex?1015:1009),"STEP"==N.interpolation&&(y.minFilter=1003,y.magFilter=1003),b=nodeTexUniName(d,o),t.nodeTextures[b]=y,c.params.push(S(d,o)),o++;break;case"VECTOR_ROTATE_BL":c.params.push(T(P("float",u.invert?-1:1)));break;case"VECT_TRANSFORM_BL":const V=u.vectorType,U=u.convertFrom,G=u.convertTo;"NORMAL"==V&&(c.outputs[0].normalize=!0);let z="";U==G?z="VEC_TRANS_NONE":(z="VEC_TRANS_"+U[0]+"_"+G[0],"VECTOR"!=V&&"NORMAL"!=V||(z+="_DIR")),c.params.push(T(z)),i(e,"OUTPUT_MATERIAL_BL")>0||i(e,"OUTPUT_WORLD_BL")>0?c.params.push(M(!0)):c.params.push(M(!1));break;case"BITMAP_MX":case"BITMAP_ENV_MX":case"REFLECT_REFRACT_MX":if(y=u.texture,t.nodeTextures[nodeTexUniName(d,n)]=y,c.params.push(S(d,n)),n++,"BITMAP_MX"==d){h=u.uvIndex?"uv"+String(u.uvIndex+1):"uv",p=w(h,2),c.attributes.push({name:h,type:"attribute vec2"}),c.params.push(p),c.params.push(T("MAPPING_"+u.mapping)),c.params.push(T("AXIS_"+u.axis));const e=P("ivec2",[I(u.clampToEdgeNoExtend[0]),I(u.clampToEdgeNoExtend[1])]);c.params.push(T(e))}else c.params.push(T(u.reflectMode)),c.params.push(C(u.IOR));c.params.push(T(v(y))),"BITMAP_MX"!=d&&"BITMAP_ENV_MX"!=d||(c.params.push(M(u.alphaAsMono)),c.params.push(M(u.alphaAsRGB)),c.outputs.push({name:d.toLowerCase()+"_out1_n"+l,type:"float",clamp:!1,normalize:!1}));break;case"BLEND_MX":c.params.push(M(u.useCurve)),c.params.push(C(u.curveLower)),c.params.push(C(u.curveUpper));break;case"BUMP_MX":y=u.texture,t.nodeTextures[nodeTexUniName(d,n)]=y,c.params.push(S(d,n)),n++,c.params.push(T("-vViewPosition")),c.params.push(T("normal")),h=u.uvIndex?"uv"+String(u.uvIndex+1):"uv",p=w(h,2),c.attributes.push({name:h,type:"attribute vec2"}),c.params.push(p);break;case"COLOR_CORRECTION_MX":const k=P("ivec4",[u.rewireR,u.rewireG,u.rewireB,u.rewireA]);c.params.push(T(k)),u.gainPivotGammaLift&&(c.params.push(C(u.gainPivotGammaLift)),c.params.push(M(u.enableR)),c.params.push(M(u.enableG)),c.params.push(M(u.enableB)),c.params.push(E(u.exposureMode)),c.params.push(C(u.printerLights)));break;case"COMPOSITE_LAYER_MX":c.params.push(T(P("int",u.blendMode)));const W=isConnInput(e,l,1)?u.opacity:0;c.params.push(C(W));break;case"COLOR_MAP_MX":c.params.push(M(u.reverseGamma));break;case"FALLOFF_MX":if(c.params.push(T("-vViewPosition")),4!=u.falloffType)c.params.push(C(u.IOR)),c.params.push(E(u.falloffType));else{const e=void 0!==u.extrapolateOn&&u.extrapolateOn,t=void 0===u.nearDistance?0:u.nearDistance,n=void 0===u.farDistance?100:u.farDistance;c.params.push(M(e)),c.params.push(C(t)),c.params.push(C(n))}break;case"MASK_MX":c.params.push(M(u.maskInverted));break;case"MATERIAL_MX":c.params.push(C(u.inputFactors[N_IN[d].reflection])),c.params.push(C(u.inputFactors[N_IN[d].refraction])),u.inputFactors[N_IN[d].reflection]=1,u.inputFactors[N_IN[d].refraction]=1,c.params.push(M(u.selfIllumColorOn));break;case"MATTE_SHADOW_MX":c.params.push(T("normal")),c.params.push(M(u.receiveShadows)),c.params.push(C(u.shadowBrightness)),c.params.push(C(u.color));break;case"NOISE_MX":2==u.coordType?(h=u.uvIndex?"uv"+String(u.uvIndex+1):"uv",p=w(h,2),c.attributes.push({name:h,type:"attribute vec2"}),c.params.push(p)):c.params.push(T("vViewPosition")),c.params.push(E(u.noiseType)),c.params.push(E(u.coordType));break;case"NORMAL_BUMP_MX":h="tangent",p=w(h,4),c.attributes.push({name:h,type:"attribute vec4"}),c.params.push(p),c.params.push(T("normal"));const Q="ivec2("+I(u.flip[0])+","+I(u.flip[1])+")";c.params.push(T(Q));break;case"OPENPBR_SURFACE_MX":case"OPENPBR_SURFACE_MY":c.params.push(T("geometryNormal")),c.params.push(M(u.thinWalled)),(u.inputs[N_IN[d].coatWeight]>0||isConnInput(e,l,N_IN[d].coatWeight))&&(t.defines.USE_CLEARCOAT=""),(u.inputs[N_IN[d].fuzzWeight]>0||isConnInput(e,l,N_IN[d].fuzzWeight))&&(t.defines.USE_SHEEN="");break;case"OUTPUT_MAP_MX":if(c.params.push(M(u.invert)),c.params.push(M(u.clamp)),c.params.push(M(u.alphaFromRGB)),u.colorMap){t.useFloatTex?(x=u.colorMap,f=new Float32Array(1024),m=1):(x=clampArray(u.colorMap.slice(),0,1),f=new Uint8Array(1024),m=255),B=x.length/256;for(let e=0;e<256;e++)f[4*e]=m*x[B*e],3==B?(f[4*e+1]=m*x[B*e+1],f[4*e+2]=m*x[B*e+2]):(f[4*e+1]=f[4*e],f[4*e+2]=f[4*e]),f[4*e+3]=m;y=A(f,256,1023,t.useFloatTex?1015:1009),b=nodeTexUniName(d,o),t.nodeTextures[b]=y,c.params.push(S(d,o)),o++}break;case"PHYSICAL_MX":c.params.push(T("geometryNormal")),c.params.push(C(u.emitLuminance));const H=void 0===u.brdfMode||u.brdfMode,X=void 0===u.brdfLow?0:u.brdfLow,Y=void 0===u.brdfHigh?0:u.brdfHigh,j=void 0===u.brdfCurve?0:u.brdfCurve;c.params.push(M(!H)),c.params.push(T(P("float",X))),c.params.push(T(P("float",Y))),c.params.push(T(P("float",j))),c.params.push(M(isDef(u.roughnessInv)&&u.roughnessInv)),c.params.push(M(isDef(u.transRoughnessLock)&&u.transRoughnessLock)),c.params.push(M(isDef(u.transRoughnessInv)&&u.transRoughnessInv)),c.params.push(M(isDef(u.thinWalled)&&u.thinWalled)),(u.inputs[N_IN[d].clearcoat]>0||isConnInput(e,l,N_IN[d].clearcoat))&&(t.defines.USE_CLEARCOAT="");break;case"PHY_SUN_SKY_ENV_MX":const $=15*u.haze+2,K=new Spherical;D=Math.PI/2-u.sunPolarAngle;const q=Math.PI-u.sunAzimuthAngle;K.phi=D,K.theta=q;const Z=(new Vector3).setFromSpherical(K).toArray();let J,ee,te,ne,oe,re;J=getDistParams($,0),ee=getDistParams($,1),te=getDistParams($,2),ne=getZenithParams($,D,0),oe=getZenithParams($,D,1),re=getZenithParams($,D,2),ne/=.06,ne*=1e3,c.params.push(C([J[0],ee[0],te[0]])),c.params.push(C([J[1],ee[1],te[1]])),c.params.push(C([J[2],ee[2],te[2]])),c.params.push(C([J[3],ee[3],te[3]])),c.params.push(C([J[4],ee[4],te[4]])),c.params.push(C([ne,oe,re]));const ie=getSunIlluminance(Z,$),ae=[0,0,0];c.params.push(C(Z)),c.params.push(C(ie)),c.params.push(C(ae)),c.params.push(C(u.globalIntensity/MAX_LIGHT_INT_MULT)),c.params.push(C(u.groundColor));break;case"REFLECT_REFRACT_COLOR_MX":L=u.outputs[0],c.params.push(C(L));break;case"VERTEX_COLOR_MX":h="color",p=w(h,3),c.attributes.push({name:h,type:"attribute vec3"}),c.params.push(p);break;case"BUMP_2D_MY":c.params.push(T("vNormal")),u.bumpInterp>0&&(h="tangent",p=w(h,4),c.attributes.push({name:h,type:"attribute vec4"}),c.params.push(p));break;case"COLOR_COMPOSITE_MY":case"COLOR_LOGIC_MY":case"COLOR_MATH_MY":case"CONDITION_MY":case"FLOAT_COMPOSITE_MY":case"FLOAT_LOGIC_MY":case"FLOAT_MATH_MY":case"MULTIPLY_DIVIDE_MY":c.params.push(T(u.operation));break;case"COLOR_CORRECT_MY":c.params.push(M(u.colClamp)),c.params.push(C(u.colClampMin)),c.params.push(C(u.colClampMax)),c.params.push(M(u.alphaClamp)),c.params.push(C(u.alphaClampMin)),c.params.push(C(u.alphaClampMax)),c.params.push(M(u.unpremultiplyInput)),c.params.push(M(u.premultiplyResult));break;case"COLOR_MASK_MY":c.params.push(M(u.maskAlphaIsLuminance));break;case"COMPOSE_MATRIX_MY":c.params.push(M(u.useEulerRotation)),c.params.push(T(u.inputRotateOrder));break;case"FILE_MY":case"ENV_SPHERE_MY":if(y=u.texture,t.nodeTextures[nodeTexUniName(d,n)]=y,c.params.push(S(d,n)),n++,c.params.push(T(v(y))),"ENV_SPHERE_MY"==d)c.params.push(T("normal"));else{const t=!1===u.fileHasAlpha;c.params.push(M(t&&isConnOutput(e,l,N_OUT.FILE_MY.alpha)))}break;case"RAMP_MY":t.useFloatTex?(f=new Float32Array(2048),m=1):(f=new Uint8Array(2048),m=255);for(let e=0;e<512;e++){const t=m*u.rampData[3*e],n=m*u.rampData[3*e+1],o=m*u.rampData[3*e+2];f[4*e]=clamp(t,0,m),f[4*e+1]=clamp(n,0,m),f[4*e+2]=clamp(o,0,m),f[4*e+3]=m}y=A(f,512,1023,t.useFloatTex?1015:1009),b=nodeTexUniName(d,o),t.nodeTextures[b]=y,c.params.push(S(d,o)),o++,c.params.push(T(P("int",u.rampType))),c.params.push(T(P("int",u.wrapS))),c.params.push(T(P("int",u.wrapT))),t.defines.RAMP_TEX_SIZE=512,t.definesFragOnly.add("RAMP_TEX_SIZE");break;case"SAMPLER_INFO_MY":c.params.push(T("faceDirection")),h="tangent",p=w(h,4),c.attributes.push({name:h,type:"attribute vec4"}),c.params.push(p),h="uv",p=w(h,2),c.attributes.push({name:h,type:"attribute vec2"}),c.params.push(p);break;case"UNIT_CONVERSION_MY":c.params.push(C(u.conversionFactor));break;case"VECTOR_PRODUCT_MY":c.params.push(T(u.operation)),c.params.push(M(u.normalizeOutput));break;case"OSL_NODE":isDef(u.texture)&&(y=u.texture,t.nodeTextures[nodeTexUniName(d,n)]=y,c.params.push(S(d,n)),n++);const se=u.globalVariables||[];se.indexOf("P")>-1&&c.params.push(T("oslGetP(vViewPosition)")),se.indexOf("I")>-1&&c.params.push(T("oslGetI(vViewPosition)")),se.indexOf("N")>-1&&c.params.push(T("oslGetN(normal)")),(se.indexOf("u")>-1||se.indexOf("v")>-1)&&(h="uv",c.attributes.push({name:h,type:"attribute vec2"}),se.indexOf("u")>-1&&c.params.push(w(h+"_u",1,h+".x")),se.indexOf("v")>-1&&c.params.push(w(h+"_v",1,"1.0 - "+h+".y")));break;case"RGB_ALPHA":L=(new Vector4).fromArray(u.outputs[0].concat([u.outputs[1]])),t.nodeRGB.push(L),t.nodeRGBMap[u.name]=r,c.params.push(T("nodeRGB["+r+"]")),r++;break;case"U_FLOAT":h="uv",p=w(h,2),c.attributes.push({name:h,type:"attribute vec2"}),c.params.push(p)}}const l={},c={};for(let t=0;t<e.len();t++){const n=e.node(t),o=n.originData,r=o.type;for(let i=0;i<o.inputs.length;i++){const a=o.inputs[i],s=o.inputTypes?o.inputTypes[i]:R(a),d=[],h=[];b(e,t,i,a,d,h);const p=u(r,i);if(d.length){let e,t;if(e=n.inputFactors.length?n.inputFactors[i]:1,t=p?"normal":P(s,a),h.length){const e=d.map(function(e){return e.name});n.inputs.push({code:y(e,h,d[0].type,s,t)})}else 1==d.length||console.error(`MeshNodeMaterial: wrong ${r} node connections`),n.inputs.push({code:x(d[0].name,d[0].type,s,t,e)})}else if(p)n.inputs.push({code:"normal"});else if("string"==typeof a)n.inputs.push({code:a});else{l[s]=l[s]||[],Array.isArray(a)?l[s].push(...a):l[s].push(a),s in c||(c[s]=0);let e=c[s];n.inputs.push({code:`nodeInputs${strTitle(s)}[${e}]`}),c[s]++}}}t.nodeInputs={};for(const e in l)t.nodeInputs[e]="int"==e||"bool"==e?new Int32Array(l[e]):new Float32Array(l[e])}(a),function(e){const n=[],o=[],r=[],i=[],a=new TopologicalSort(e).order();t.defines.NODE_RGB_NUM=t.nodeRGB.length,t.defines.NODE_VALUE_NUM=t.nodeValue.length,t.defines.NODE_TEX_COORD_NUM=t.nodeTexCoordObject.length,t.definesFragOnly.add("NODE_RGB_NUM"),t.definesFragOnly.add("NODE_VALUE_NUM"),t.definesFragOnly.add("NODE_TEX_COORD_NUM");for(let o=0;o<a.length;o++){const i=e.node(a[o]),s=i.originData.type;let l,c;if(t.defines["NODE_"+s]="","REFLECT_REFRACT_MX"!=s&&"BITMAP_ENV_MX"!=s&&"BUMP_BL"!=s&&"PHY_SUN_SKY_ENV_MX"!=s&&"ENV_SPHERE_MY"!=s&&"UV_PROJECTION_AR"!=s&&"TRIPLANAR_AR"!=s&&"TRIPLANAR_UV_AR"!=s&&"SUB_TRANSFORM_MX"!=s&&"SUB_TRANSFORM_MY"!=s&&t.definesFragOnly.add("NODE_"+s),"OSL_NODE"==s&&(t.defines.USE_OSL=""),"OSL_NODE"!=s){const e="node_"+s.toLowerCase()+"_vert";l=ShaderChunk[e]}else l=i.originData.vertCode;if(l&&n.indexOf(l)<0&&n.push(l),"OSL_NODE"!=s){const e="node_"+s.toLowerCase()+"_frag";c=ShaderChunk[e]}else c=i.originData.fragCode;c&&r.indexOf(c)<0&&r.push(c);for(let e=0;e<i.attributes.length;e++){const t=i.attributes[e],o=t.type+" "+t.name+";";"uv"!=t.name&&n.indexOf(o)<0&&n.push(o)}for(let e=0;e<i.params.length;e++){const t=i.params[e];if(f(t)){const e=t.type+" "+t.name+";";r.indexOf(e)<0&&r.push(e)}else if(m(t)){const e=t.type+" "+t.name+";";n.indexOf(e)<0&&n.push(e);const o=t.type+" "+t.name+";";r.indexOf(o)<0&&r.push(o)}}}for(const e in t.nodeInputs){const n=t.nodeInputs[e].length/B(e);r.push(`uniform ${e} nodeInputs${strTitle(e)}[${n}];`)}isDef(t.defines.USE_OSL)&&r.unshift("#include <node_osl_frag>");for(let t=0;t<a.length;t++){const n=e.node(a[t]),r=n.originData.type;if("CHECKERBOARD_AR"==r||"IMAGE_AR"==r||"TWO_SIDED_AR"==r||"USER_DATA_COLOR_AR"==r||"ATTRIBUTE_BL"==r||"NEW_GEOMETRY_BL"==r||"NORMAL_MAP_BL"==r||"TANGENT_BL"==r||"TEX_COORD_BL"==r||"UVMAP_BL"==r||"VERTEX_COLOR_BL"==r||"BITMAP_MX"==r||"NOISE_MX"==r||"NORMAL_BUMP_MX"==r||"BUMP_MX"==r||"VERTEX_COLOR_MX"==r||"GRADIENT_MX"==r||"GRADIENT_RAMP_MX"==r||"BUMP_2D_MY"==r||"PLACE_2D_TEXTURE_MY"==r||"SAMPLER_INFO_MY"==r||"OSL_NODE"==r||"U_FLOAT"==r)for(let e=0;e<n.params.length;e++){const t=n.params[e];if(m(t)){const e=t.name+"="+t.attrBindName+";";o.includes(e)||(o.push(e),t.name.includes("Tangent")&&o.push(["#ifdef USE_SKINNING",`    ${t.name}.xyz = vec4(skinMatrix * vec4(${t.name}.xyz, 0.0)).xyz;`,"#endif"].join("\n")))}}for(let e=0;e<n.outputs.length;e++){const t=n.outputs[e];t.type&&i.push(t.type+" "+t.name+";")}const s=[];for(let e=0;e<n.params.length;e++){const t=n.params[e];!t.type||f(t)||m(t)?s.push(t.name):s.push(P(t.type,t.value))}for(let e=0;e<n.inputs.length;e++){const t=n.inputs[e];s.push(t.code)}for(let e=0;e<n.outputs.length;e++){const t=n.outputs[e];s.push(t.name)}let l;switch(l="OSL_NODE"!=r?"node_"+nodeTypeStripSuffix(r).toLowerCase():n.originData.shaderName,r){case"MATH_BL":case"VECT_MATH_BL":l+="_"+n.originData.operation.toLowerCase();break;case"VECTOR_ROTATE_BL":l+="_"+n.originData.rotationType.toLowerCase();break;case"MIX_BL":l+="_"+n.originData.dataType.toLowerCase(),"RGBA"==n.originData.dataType?l+="_"+n.originData.blendType.toLowerCase():"VECTOR"==n.originData.dataType&&(l+="_"+n.originData.factorMode.toLowerCase());break;case"TEX_WHITE_NOISE_BL":l+="_"+n.originData.noise_dimension.toLowerCase()}i.push(l+"("+s.join(",")+");");for(let e=0;e<n.outputs.length;e++){const t=n.outputs[e],o=t.name;if(t.clamp){const e=t.type;i.push(o+"=clamp("+o+","+e+"(0.0),"+e+"(1.0));")}t.normalize&&i.push(o+"=normalize("+o+");")}}t.nodeChunks.node_pars_vertex=n.join("\n"),t.nodeChunks.node_vertex=o.join("\n"),t.nodeChunks.node_pars_fragment=r.join("\n"),t.nodeChunks.node_fragment=i.join("\n"),t.nodeChunksHash=hashString(JSON.stringify(t.nodeChunks))}(a),e)if(this.nodeValue.length==n.length&&this.nodeRGB.length==o.length&&this.nodeTexCoordObject.length==r.length){for(let e=0;e<this.nodeValue.length;e++)this.nodeValue[e]=n[e];for(let e=0;e<this.nodeRGB.length;e++)this.nodeRGB[e]=o[e];for(let e=0;e<this.nodeTexCoordObject.length;e++)this.nodeTexCoordObject[e]=r[e]}else console.error("v3d.MeshNodeMaterial: Unable to preserve node variables");this.needsUpdate=!0},function(e){for(let o=0;o<e.len();o++){const i=e.node(o),a=i.originData.type;if("GROUP_BL"==a){const a=i.originData.nodeGraph,s=t.additionalNodeGraphs[a];if(n(e,o),s.len()<=2){const t=e.findInEdges(o),n=e.findOutEdges(o),r=Math.min(t.length,n.length);for(let o=0;o<r;o++){const r=t[o],i=n[o],a=new Edge(r.from(),i.to());a.connections=[];const s=Math.min(r.connections.length,i.connections.length);for(let e=0;e<s;e++){const t=r.connections[e],n=i.connections[e],o={from:t.from,to:n.to};a.connections.push(o)}e.addEdge(a)}e.disconnect(o,!0),o=-1;continue}const l=r(e,s,o);e.insert(s,l.inputs,l.outputs);const c=l.removedNodes.sort(function(e,t){return t-e});for(let t=0;t<c.length;t++)e.disconnect(c[t],!0);o=-1;continue}if("REROUTE_BL"==a){e.findInEdges(o).length<1&&n(e,o);const t=e.findInEdges(o),r=e.findOutEdges(o),i=t[0],a=i.connections[0];for(let t=0;t<r.length;t++){const n=r[t];let o=e.edge(i.from(),n.to());o||(o=new Edge(i.from(),n.to()),o.connections=[],e.addEdge(o));for(let e=0;e<n.connections.length;e++){const t=n.connections[e],r={from:a.from,to:t.to};o.connections.push(r)}}e.disconnect(o,!0),o=-1;continue}if("OSL_OUTPUT_SELECTOR_MX"==a){const t=e.findInEdges(o),n=e.findOutEdges(o),r=t[0],i=r.connections[0];for(let t=0;t<n.length;t++){const o=n[t],a=new Edge(r.from(),o.to());a.connections=[];for(let e=0;e<o.connections.length;e++){const t=o.connections[e],n={from:i.from,to:t.to};a.connections.push(n)}e.addEdge(a)}e.disconnect(o,!0),o=-1;continue}}}(t.nodeGraph),function(e){for(let t=0;t<e.len();t++){const n=e.node(t),o=n.originData,r=o.type;if("TEX_IMAGE_BL"==r&&!isConnInput(e,t,0)){const n={originData:{name:"UVMapGenerated",type:"UVMAP_BL",uvLayer:"",inputs:[],outputs:[[0,0,0]]}};e.addNode(n),connectNodes(e,e.len()-1,0,t,0)}if(("TEX_BRICK_BL"==r||"TEX_CHECKER_BL"==r||"TEX_GABOR_BL"==r||"TEX_GRADIENT_BL"==r||"TEX_MAGIC_BL"==r||"TEX_NOISE_BL"==r||"TEX_WAVE_BL"==r||"TEX_VORONOI_BL"==r||"TEX_SKY_BL"==r)&&!isConnInput(e,t,0)){const n={originData:{name:"TexCoordGenerated",type:"TEX_COORD_BL",inputs:[],outputs:[[0,0,0],[0,0,0],[0,0,0],[0,0,0],[0,0,0],[0,0,0],[0,0,0]]}};e.addNode(n),connectNodes(e,e.len()-1,0,t,0)}if("TEX_ENVIRONMENT_BL"==r&&!isConnInput(e,t,0)){const n={originData:{name:"TexCoordObject",type:"TEX_COORD_BL",inputs:[],outputs:[[0,0,0],[0,0,0],[0,0,0],[0,0,0],[0,0,0],[0,0,0],[0,0,0]]}};e.addNode(n),connectNodes(e,e.len()-1,3,t,0)}const i=getNodeTypeCompat(n);if(i in DEFAULT_NORMAL_INPUT_NUM&&!isConnInput(e,t,DEFAULT_NORMAL_INPUT_NUM[i])){const n={originData:{name:"Normal",type:"NORMAL",inputs:[],outputs:[[0,0,0]]}};e.addNode(n),connectNodes(e,e.len()-1,N_OUT.NORMAL.normal,t,DEFAULT_NORMAL_INPUT_NUM[i])}if(["BSDF_PRINCIPLED_BL","BSDF_PRINCIPLED_BF43_BL","EEVEE_SPECULAR_BL"].includes(i)&&!isConnInput(e,t,N_IN[i].clearcoatNormal)&&(o.inputs[N_IN[i].clearcoat]>0||isConnInput(e,t,N_IN[i].clearcoat))){const n={originData:{name:"CoatNormal",type:"NORMAL",inputs:[],outputs:[[0,0,0]]}};e.addNode(n),connectNodes(e,e.len()-1,N_OUT.NORMAL.normal,t,N_IN[i].clearcoatNormal)}if("EEVEE_SPECULAR_BL"!=i||isConnInput(e,t,N_IN.EEVEE_SPECULAR_BL.ambientOcclusion)||(o.inputs[N_IN.EEVEE_SPECULAR_BL.ambientOcclusion]=1),"OSL_NODE"==i){const n=o.initializers;for(let r=0;r<n.length;r++){const a=n[r];if(a&&!isConnInput(e,t,r)){const n={originData:{name:i+"init"+r,type:"OSL_NODE",shaderName:o.shaderName+"_init_"+r,inputs:[],outputs:[o.inputs[0]],fragCode:a[0],globalVariables:a[1],initializers:[]}};e.addNode(n),connectNodes(e,e.len()-1,0,t,r)}}}if(!("NORMAL_MAP_AR"!=i||isConnInput(e,t,N_IN.NORMAL_MAP_AR.normal)&&isConnInput(e,t,N_IN.NORMAL_MAP_AR.tangent))){const n={originData:{name:"SamplerInfo",type:"SAMPLER_INFO_MY",inputs:[[0,0,0]],outputs:[0,!1,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0],[0,0],[0,0,0],[0,0,0],[0,0,0],[0,0,0],[0,0,0],[0,0]]}};e.addNode(n),isConnInput(e,t,N_IN.NORMAL_MAP_AR.normal)||connectNodes(e,e.len()-1,N_OUT.SAMPLER_INFO_MY.normalCamera,t,N_IN.NORMAL_MAP_AR.normal),isConnInput(e,t,N_IN.NORMAL_MAP_AR.tangent)||connectNodes(e,e.len()-1,N_OUT.SAMPLER_INFO_MY.tangentUCamera,t,N_IN.NORMAL_MAP_AR.tangent)}if("IMAGE_AR"==i&&!isConnInput(e,t,N_IN.IMAGE_AR.uvcoords)){const n={originData:{name:"place2dTexture",type:"PLACE_2D_TEXTURE_MY",inputs:[[0,0],[1,1],0],outputs:[[0,0]],uvIndex:0}};e.addNode(n),connectNodes(e,e.len()-1,N_OUT.PLACE_2D_TEXTURE_MY.uv,t,N_IN.IMAGE_AR.uvcoords)}if("FILE_MY"==i&&!isConnInput(e,t,N_IN.FILE_MY.uvCoord)){const n={originData:{name:"place2dTexture",type:"PLACE_2D_TEXTURE_MY",inputs:[[0,0],[1,1],0],outputs:[[0,0]],uvIndex:0}};e.addNode(n),connectNodes(e,e.len()-1,N_OUT.PLACE_2D_TEXTURE_MY.uv,t,N_IN.FILE_MY.uvCoord)}if("RAMP_MY"==i&&!isConnInput(e,t,N_IN.RAMP_MY.uvCoord)){const n={originData:{name:"place2dTexture",type:"PLACE_2D_TEXTURE_MY",inputs:[[0,0],[1,1],0],outputs:[[0,0]],uvIndex:0}};e.addNode(n),connectNodes(e,e.len()-1,N_OUT.PLACE_2D_TEXTURE_MY.uv,t,N_IN.RAMP_MY.uvCoord)}if(isDef(o.output)&&h(e,t,o),l(r)){if(!isDef(o.inputFactors)){o.inputFactors=[];for(let e=0;e<o.inputs.length;e++)o.inputFactors.push(1)}o.inputs.push([0,0,0]),o.inputFactors.push(0)}if("STANDARD_SURFACE_AR"==i&&!isConnInput(e,t,N_IN[i].clearcoatNormal)&&(o.inputs[N_IN[i].clearcoat]>0||isConnInput(e,t,N_IN[i].clearcoat))){const n={originData:{name:"CoatNormal",type:"NORMAL",inputs:[],outputs:[[0,0,0]]}};e.addNode(n),connectNodes(e,e.len()-1,0,t,N_IN[i].clearcoatNormal)}if("MIX_BL"==i&&o.outputs.length>1){const n=[-1,-1,-1,-1,-1,-1,-1,-1],r=[-1,-1,-1];switch(o.dataType){case"RGBA":o.inputs=[o.inputs[0],o.inputs[6],o.inputs[7]],n[0]=0,n[6]=1,n[7]=2,o.outputs=[o.outputs[2]],r[2]=0;break;case"VECTOR":o.inputs=[o.inputs[0],o.inputs[1],o.inputs[4],o.inputs[5]],n[0]=0,n[1]=1,n[4]=2,n[5]=3,o.outputs=[o.outputs[1]],r[1]=0;break;case"FLOAT":o.inputs=[o.inputs[0],o.inputs[2],o.inputs[3]],n[0]=0,n[2]=1,n[3]=2,o.outputs=[o.outputs[0]],r[0]=0}const i=e.findInEdges(t);for(let e=0;e<i.length;e++){const t=i[e];for(let e=t.connections.length-1;e>=0;e--){const o=t.connections[e];n[o.to]>-1?o.to=n[o.to]:t.connections.splice(e,1)}}const a=e.findOutEdges(t);for(let e=0;e<a.length;e++){const t=a[e];for(let e=t.connections.length-1;e>=0;e--){const n=t.connections[e];r[n.from]>-1?n.from=r[n.from]:t.connections.splice(e,1)}}}if("BUMP_2D_MY"==r&&o.bumpInterp>0){o.inputs[N_IN.BUMP_2D_MY.bumpValue]=[0,0,0];const n=e.findInEdges(t);for(let t=0;t<n.length;t++){const o=n[t],r=e.node(o.from()).originData;for(let e=0;e<o.connections.length;e++){const t=o.connections[e];t.to==N_IN.BUMP_2D_MY.bumpValue&&"FILE_MY"==r.type?t.from=N_OUT.FILE_MY.color:t.to==N_IN.BUMP_2D_MY.bumpValue&&"IMAGE_AR"==r.type&&(t.from=N_OUT.IMAGE_AR.color)}}}if("COLOR_CONSTANT_MY"!=r||isConnInput(e,t,0)||isConnInput(e,t,1)||(o.type="RGB_ALPHA",o.inputs=[]),"FLOAT_CONSTANT_MY"!=r||isConnInput(e,t,0)||(o.type="VALUE",o.inputs=[]),"TRIPLANAR_AR"==r){const n=function(){const n=["scale","rotate","offset"],r=n.map(n=>findAllConnectedNodes(e,t,N_IN.TRIPLANAR_AR[n])),i="Y_UP_RIGHT"===o.coordSystem?"SUB_TRANSFORM_MY":"SUB_TRANSFORM_MX",a={originData:{name:"subTransform",type:i,inputs:n.map(e=>o.inputs[N_IN.TRIPLANAR_AR[e]]),outputs:[[0,0,0],[0,0,0]],coordSpace:o.coordSpace}};e.addNode(a);const s=e.len()-1;return r.forEach((t,o)=>{t.forEach(t=>{const r=t.nodeIdx,a=t.outputIdx,l=t.channelMatrix;connectNodes(e,r,a,s,N_IN[i][n[o]],l)})}),t=>{const n=e.node(t);"TRIPLANAR_AR"==n.originData.type?connectNodes(e,s,N_OUT[i].normal,t,N_IN.TRIPLANAR_AR.normal):"TRIPLANAR_UV_AR"==n.originData.type&&(connectNodes(e,s,N_OUT[i].vector,t,N_IN.TRIPLANAR_UV_AR.vector),connectNodes(e,s,N_OUT[i].normal,t,N_IN.TRIPLANAR_UV_AR.normal))}}();o.inputs.push([0,0,0]),n(t);const r=t=>{const r={originData:{name:"triplanarUV",type:"TRIPLANAR_UV_AR",inputs:[[0,0,0],[0,0,0]],outputs:4==t?[[0,0],[0,0],[0,0]]:[[0,0]],flipOnOppositeDirection:o.flipOnOppositeDirection}};4==t?r.originData.blendFactor=o.blendFactor:r.originData.projectionAxis=t,e.addNode(r);const i=e.len()-1;return n(i),i};if(o.inputPerAxis){const n=[N_IN.TRIPLANAR_AR.inputColor,N_IN.TRIPLANAR_AR.inputColorY,N_IN.TRIPLANAR_AR.inputColorZ];for(let o=0;o<3;o++){const i=n[o],a=findConnectedNode(e,t,i,"IMAGE_AR");if(!a){findConnectedNode(e,t,i)&&console.error("MeshNodeMaterial: TRIPLANAR_AR texture inputs accept only IMAGE_AR or color.");continue}const s=e.nodeIndex(a);disconnectInputNode(e,s,N_IN.IMAGE_AR.uvcoords);const l=r(o);connectNodes(e,l,N_OUT.TRIPLANAR_UV_AR.uv,s,N_IN.IMAGE_AR.uvcoords)}}else{const n=findConnectedNode(e,t,N_IN.TRIPLANAR_AR.inputColor,"IMAGE_AR");if(!n){findConnectedNode(e,t,N_IN.TRIPLANAR_AR.inputColor)&&console.error("MeshNodeMaterial: TRIPLANAR_AR texture inputs accept only IMAGE_AR or color.");continue}const i=e.nodeIndex(n);if(disconnectInputNode(e,i,N_IN.IMAGE_AR.uvcoords),disconnectInputNode(e,t,N_IN.TRIPLANAR_AR.inputColorY),disconnectInputNode(e,t,N_IN.TRIPLANAR_AR.inputColorZ),o.blendFactor<.001){const t=r(3);connectNodes(e,t,N_OUT.TRIPLANAR_UV_AR.uv,i,N_IN.IMAGE_AR.uvcoords)}else{const t=r(4);connectNodes(e,t,N_OUT.TRIPLANAR_UV_AR.uv,i,N_IN.IMAGE_AR.uvcoords),n.originData.inputs.push([0,0],[0,0]),connectNodes(e,t,N_OUT.TRIPLANAR_UV_AR.duvdx,i,N_IN.IMAGE_AR.duvdx),connectNodes(e,t,N_OUT.TRIPLANAR_UV_AR.duvdy,i,N_IN.IMAGE_AR.duvdy)}}}if("UV_PROJECTION_AR"==r){const n=disconnectOutputNode(e,t,N_OUT.UV_PROJECTION_AR.uv),o=disconnectInputNode(e,t,N_IN.UV_PROJECTION_AR.projectionColor,"IMAGE_AR");if(!o){console.error("MeshNodeMaterial: UV_PROJECTION_AR.projectionColor input accepts only IMAGE_AR.");continue}const r=o.node;if(n){const i=e.nodeIndex(r);connectNodes(e,i,o.outputIdx,e.nodeIndex(n.node),n.inputIdx),disconnectInputNode(e,i,N_IN.IMAGE_AR.uvcoords),connectNodes(e,t,N_OUT.UV_PROJECTION_AR.uv,i,N_IN.IMAGE_AR.uvcoords)}}}let n=0;for(let t=0;t<e.len();t++){const o=e.node(t).originData,r=o.type;"MATERIAL_MX"!=r&&"PHYSICAL_MX"!=r&&"OPENPBR_SURFACE_MX"!=r||(s(e,t,o),"MATERIAL_MX"==r&&(n=o.IOR))}for(let t=0;t<e.len();t++){const o=e.node(t).originData,r=o.type;c(r)&&(o.IOR=n),c(r)&&!isDef(o.reflectMode)&&(o.reflectMode="MAX_ENV_COORDS_REFLECT")}for(let t=0;t<e.len();t++){const n=e.node(t).originData;"COMPOSITE_MX"==n.type&&(d(e,t,n),e.disconnect(t,!0))}for(let t=0;t<e.len();t++){const n=e.node(t).originData;"LAYERED_TEXTURE_MY"==n.type&&(p(e,t,n),e.disconnect(t,!0))}if(t.hasNode("SKYDOME_LIGHT_AR"))for(let t=0;t<e.len();t++){const n=e.node(t).originData;if("FILE_MY"==n.type||"IMAGE_AR"==n.type){const o={originData:{name:"envSphere",type:"ENV_SPHERE_MY",inputs:[[-1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]],outputs:[0,[0,0,0]],texture:n.texture}};e.addNode(o);const r=e.findOutEdges(t);for(let t=0;t<r.length;t++){const n=r[t];for(let t=0;t<n.connections.length;t++){const o=n.connections[t];o.from<2&&connectNodes(e,e.len()-1,o.from,n.to(),o.to)}}e.disconnect(t,!0),t=-1}}for(let t=0;t<e.len();t++){const n=e.node(t).originData;if("ENV_SPHERE_MY"==n.type&&2==n.inputs.length){const o=e.findInEdges(t);for(let t=0;t<o.length;t++){const r=o[t],i=e.node(r.from()).originData;"FILE_MY"!=i.type&&"IMAGE_AR"!=i.type||(n.inputs.splice(0,1),n.texture=i.texture,e.removeEdge(r.from(),r.to()))}}}for(let t=0;t<e.len();t++){const n=e.node(t).originData;switch(n.type){case"BSDF_DIFFUSE_BL":case"BSDF_GLOSSY_BL":case"BSDF_TRANSLUCENT_BL":o(e,t,n,N_IN[n.type].color,"Color");break;case"BSDF_METALLIC_BL":o(e,t,n,N_IN[n.type].baseColor,"Base Color");break;case"BSDF_PRINCIPLED_BL":o(e,t,n,N_IN.BSDF_PRINCIPLED_BL.baseColor,"Color");break;case"MATERIAL_MX":o(e,t,n,N_IN.MATERIAL_MX.ambientColor,"Ambient Color")&&(n.inputFactors[0]=1),o(e,t,n,N_IN.MATERIAL_MX.diffuseColor,"Diffuse Color")&&(n.inputFactors[1]=1);break;case"PHYSICAL_MX":o(e,t,n,N_IN.PHYSICAL_MX.baseColor,"Base Color")&&(n.inputFactors[1]=1);break;case"OPENPBR_SURFACE_MX":o(e,t,n,N_IN.OPENPBR_SURFACE_MY.baseColor,"Base Color")&&(n.inputFactors[1]=1);break;case"OPENPBR_SURFACE_MY":o(e,t,n,N_IN.OPENPBR_SURFACE_MY.baseColor,"Base Color");break;case"STANDARD_SURFACE_AR":o(e,t,n,N_IN.STANDARD_SURFACE_AR.baseColor,"Base Color")}}}(t.nodeGraph),cleanupGraph(t.nodeGraph),this.updateNodeGraph()}static nodeGraphFromExtGraph(e){let t=e.nodes,n=e.edges;const o=t.slice().sort(function(e,t){return e.name.localeCompare(t.name)}),r=[];for(let e=0;e<n.length;e++){const i=n[e],a=Object.assign({},i);a.fromNode=o.indexOf(t[i.fromNode]),a.toNode=o.indexOf(t[i.toNode]),r.push(a)}t=o,n=r;const i=new DiGraph(t.length);for(let e=0;e<t.length;e++)t[e],nodeClone({originData:t[e]},i.node(e));for(let e=0;e<n.length;e++){const t=n[e];i.edge(t.fromNode,t.toNode)||i.addNewEdge(t.fromNode,t.toNode);const o=i.edge(t.fromNode,t.toNode);if(o.connections=o.connections||[],isDef(t.fromChannel)||isDef(t.toChannel)){let e=null;for(let n=0;n<o.connections.length;n++){const r=o.connections[n];if(r.from==t.fromOutput&&r.to==t.toInput&&r.channelMatrix){e=r.channelMatrix;break}}if(!e){e=[[0,0,0],[0,0,0],[0,0,0]];const n={from:t.fromOutput,to:t.toInput,channelMatrix:e};o.connections.push(n)}const n=t.fromChannel||0,r=t.toChannel||0;e[n][r]=1}else{const e={from:t.fromOutput,to:t.toInput};o.connections.push(e)}}return cleanupGraph(i),i}static nodeGraphTraverse(e,t){for(let n=0;n<e.len();n++){t(e.node(n))}}hasNode(e){for(let t=0;t<this.nodeGraph.len();t++){if(this.nodeGraph.node(t).originData.type==e)return!0}return!1}traverseNodes(e){for(let t=0;t<this.nodeGraph.len();t++){e(this.nodeGraph.node(t))}}findNodeByName(e){for(let t=0;t<this.nodeGraph.len();t++){const n=this.nodeGraph.node(t);if(n.originData.name===e)return n}return null}get color(){return this.getStandardProp("color")}set color(e){}get opacity(){return this.getStandardProp("opacity")}set opacity(e){}connectTexture(e,t,n){let o,r,i;switch(this.profile){case"blender":o="TEX_IMAGE_BL",r="UVMAP_BL",i="vector";break;case"max":o="BITMAP_MX";break;case"maya":o="FILE_MY",r="PLACE_2D_TEXTURE_MY",i="uvCoord";break;default:return void console.error("v3d.connectTexture: Invalid material profile:",this.profile)}const a=createNode(o,e.name||"Texture",{texture:e}),s=nodeTexUniName(o,Object.keys(this.nodeTextures).length);this.nodeTextures[s]=e;const l=this.nodeGraph;if(l){let e=firstNodeName(l,t);const s=N_IN[getNodeType(l.node(e))][n],c=findConnectedNode(l,e,s);c&&(l.disconnect(l.nodeIndex(c),!0),e=firstNodeName(l,t)),l.addNode(a),connectNodes(l,l.len()-1,N_OUT[o].color,e,s),r&&(l.addNode(createNode(r,a.name+"UV")),connectNodes(l,l.len()-1,N_OUT[r].uv,l.len()-2,N_IN[o][i]))}else console.error("v3d.connectTexture: Unable to connect texture to empty graph")}needsLightPathDir(){return!!(this.hasNode("LIGHT_PATH_BL")||this.hasNode("RAY_SWITCH_AR")||"USE_OSL"in this.defines)}canUseGTAO(){return(this.hasNode("BSDF_DIFFUSE_BL")||this.hasNode("SUBSURFACE_SCATTERING_BL")||this.hasNode("PHYSICAL_MX")||this.hasNode("OPENPBR_SURFACE_MX")||this.hasNode("OPENPBR_SURFACE_MY")||this.hasNode("STANDARD_SURFACE_AR")||this.hasNode("BSDF_GLASS_BL")||this.hasNode("BSDF_GLOSSY_BL")||this.hasNode("BSDF_METALLIC_BL")||this.hasNode("BSDF_PRINCIPLED_BL")||this.hasNode("EEVEE_SPECULAR_BL"))&&this.gtaoVisible}worldMaterialColor(){const e=this.nodeGraph;let t=firstNodeType(e,"OUTPUT_WORLD_BL");if(t>=0){const n=findConnectedNode(e,t,0);if(!n||"BACKGROUND_BL"!=n.originData.type)return null;if(0==e.findInEdges(e.nodeIndex(n)).length)return(new Color).fromArray(n.originData.inputs[0]).multiplyScalar(n.originData.inputs[1]);if(isConnInput(e,e.nodeIndex(n),1))return null;const o=findConnectedNode(e,e.nodeIndex(n),0);if(!o||"MIX_BL"!=o.originData.type||"RGBA"!=o.originData.dataType||"MIX"!=o.originData.blendType)return null;const r=findConnectedNode(e,e.nodeIndex(o),0);return r&&"LIGHT_PATH_BL"==r.originData.type?isConnInput(e,e.nodeIndex(o),2)?null:isConnOutput(e,e.nodeIndex(r),0)?(new Color).fromArray(o.originData.inputs[2]):null:null}if(t=firstNodeType(e,"OUTPUT_MX"),t>=0&&0==e.findInEdges(t).length)return(new Color).fromArray(e.node(t).originData.inputs[0]);if(t=firstNodeType(e,"SKYDOME_LIGHT_AR"),t>=0){if(0==e.findInEdges(t).length){const n=e.node(t);return(new Color).fromArray(n.originData.inputs[0]).multiplyScalar(n.originData.inputs[1])}const n=findConnectedNode(e,t,0);if(!n||"RAY_SWITCH_AR"!=n.originData.type)return null;if(0==e.findInEdges(e.nodeIndex(n)).length)return(new Color).fromArray(n.originData.inputs[0])}return null}useAddTransparency(){const e=this.nodeGraph,t=firstNodeType(e,"OUTPUT_MATERIAL_BL");if(t>=0){const n=findConnectedNode(e,t,0);if(n&&"ADD_SHADER_BL"==n.originData.type){const t=findConnectedNode(e,e.nodeIndex(n),0),o=findConnectedNode(e,e.nodeIndex(n),1);if(t&&o&&("BSDF_TRANSPARENT_BL"==t.originData.type||"BSDF_TRANSPARENT_BL"==o.originData.type))return!0}}return!1}getMainShaderNode(){const e=this.nodeGraph;if(!e)return null;let t=firstNodeType(e,"OUTPUT_MATERIAL_BL");if(t>=0){const n=findConnectedNode(e,t,N_IN.OUTPUT_MATERIAL_BL.surface);if(n)if(nodeOfType(n,"MIX_SHADER_BL")){let t=findConnectedNode(e,n,N_IN.MIX_SHADER_BL.fac,"SEPARATE_COLOR_BL"),o=findConnectedNode(e,n,N_IN.MIX_SHADER_BL.color1,"BSDF_DIFFUSE_BL"),r=findConnectedNode(e,n,N_IN.MIX_SHADER_BL.color2,STD_SHADER_NODES_BL);if(t&&o&&r)return r;if(t=findConnectedNode(e,n,N_IN.MIX_SHADER_BL.fac,"LIGHT_PATH_BL"),o=findConnectedNode(e,n,N_IN.MIX_SHADER_BL.color1,"BSDF_TRANSPARENT_BL"),r=findConnectedNode(e,n,N_IN.MIX_SHADER_BL.color2,"EMISSION_BL"),t&&o&&r)return r;if(t=findConnectedNode(e,n,N_IN.MIX_SHADER_BL.fac),o=findConnectedNode(e,n,N_IN.MIX_SHADER_BL.color1,"BSDF_TRANSPARENT_BL"),r=findConnectedNode(e,n,N_IN.MIX_SHADER_BL.color2,STD_SHADER_NODES_BL),!t&&o&&r)return r}else if(nodeOfType(n,STD_SHADER_NODES_BL))return n}if(t=firstNodeType(e,"OUTPUT_MX"),t>=0){const n=findConnectedNode(e,t,N_IN.OUTPUT_MX.color,STD_SHADER_NODES_MX);if(n)return n}if(t=firstNodeType(e,"SHADING_ENGINE_MY"),t>=0){const n=findConnectedNode(e,t,N_IN.SHADING_ENGINE_MY.surface,STD_SHADER_NODES_MY);if(n)return n}return null}getInputColor(e,t){const n=findConnectedNode(this.nodeGraph,e,t);if(!n)return(new Color).fromArray(e.originData.inputs[t]);if(nodeOfType(n,["RGB_BL","RGB_MX","RGB_ALPHA"])){const e=this.nodeRGB[this.nodeRGBMap[n.originData.name]];return(new Color).fromArray(e.toArray())}}getInputValue(e,t){const n=findConnectedNode(this.nodeGraph,e,t);if(n){if(nodeOfType(n,["VALUE_BL","VALUE_MX","VALUE"]))return this.nodeValue[this.nodeValueMap[n.originData.name]]}else{const n=e.originData.inputs[t];if("number"==typeof n)return n;console.error(`v3d.MeshNodeMaterial: Invalid ${getNodeType(e)} input value at index ${t}`)}}getInputTexture(e,t){const n=findConnectedNode(this.nodeGraph,e,t);if(n&&nodeOfType(n,["TEX_IMAGE_BL","BITMAP_MX","FILE_MY","IMAGE_AR"]))return n.originData.texture}getStandardProp(e){if(!(e in STD_PROP_DEFAULTS))return void console.error(`v3d.MeshNodeMaterial: Invalid standard property: "${e}"`);const t=this.getMainShaderNode();if(!t)return STD_PROP_DEFAULTS[e];const n=getNodeType(t),o=getNodeTypeCompat(t),r=this.nodeGraph;let i,a,s,l,c,u,d,h,p;switch(e){case"color":if(i=STD_SHADER_NODES_BL.includes(n)&&findConnectedNode(r,t,N_IN[o].baseColor??N_IN[o].color,"MIX_BL"),i&&"MULTIPLY"==i.originData.blendType){const e=findConnectedNode(r,i,N_IN.MIX_BL.fac),t=findConnectedNode(r,i,N_IN.MIX_BL.col1),n=findConnectedNode(r,i,N_IN.MIX_BL.col2);if(!e&&(t&&!n||!t&&n)){const e=this.getInputColor(i,t?N_IN.MIX_BL.col2:N_IN.MIX_BL.col1);if(e)return e}}else{let e,r;switch(n){case"BSDF_PRINCIPLED_BL":case"EEVEE_SPECULAR_BL":e=this.getInputColor(t,N_IN[o].baseColor);break;case"PHYSICAL_MX":case"STANDARD_SURFACE_AR":case"LAMBERT_AR":e=this.getInputColor(t,N_IN[o].baseColor),e||(e=STD_PROP_DEFAULTS.color.clone()),r=this.getInputValue(t,N_IN[o].base),isDef(r)&&e.multiplyScalar(r);break;case"OPENPBR_SURFACE_MX":case"OPENPBR_SURFACE_MY":e=this.getInputColor(t,N_IN[o].baseColor),e||(e=STD_PROP_DEFAULTS.color.clone()),r=this.getInputValue(t,N_IN[o].baseWeight),isDef(r)&&e.multiplyScalar(r);break;default:e=this.getInputColor(t,N_IN[o].color)}if(e)return e}break;case"map":if(i=STD_SHADER_NODES_BL.includes(n)&&findConnectedNode(r,t,N_IN[o].baseColor??N_IN[o].color,"MIX_BL"),i&&"MULTIPLY"==i.originData.blendType){const e=findConnectedNode(r,i,N_IN.MIX_BL.fac),t=findConnectedNode(r,i,N_IN.MIX_BL.col1),n=findConnectedNode(r,i,N_IN.MIX_BL.col2);if(!e&&(t&&!n||!t&&n)){const e=this.getInputTexture(i,t?N_IN.MIX_BL.col1:N_IN.MIX_BL.col2);if(e)return e}}else if(["BSDF_PRINCIPLED_BL","EEVEE_SPECULAR_BL","PHYSICAL_MX","OPENPBR_SURFACE_MX","OPENPBR_SURFACE_MY","STANDARD_SURFACE_AR","LAMBERT_AR"].includes(n)){const e=this.getInputTexture(t,N_IN[o].baseColor);if(e)return e}else{const e=this.getInputTexture(t,N_IN[o].color);if(e)return e}break;case"opacity":if(p=firstNodeType(r,"OUTPUT_MATERIAL_BL"),p>=0){const e=findConnectedNode(r,p,N_IN.OUTPUT_MATERIAL_BL.surface,"MIX_SHADER_BL");if(e){const t=findConnectedNode(r,e,N_IN.MIX_SHADER_BL.fac),n=findConnectedNode(r,e,N_IN.MIX_SHADER_BL.color1,"BSDF_TRANSPARENT_BL"),o=findConnectedNode(r,e,N_IN.MIX_SHADER_BL.color2,STD_SHADER_NODES_BL);if(!t&&n&&o){const t=this.getInputValue(e,N_IN.MIX_SHADER_BL.fac);if(isDef(t))return t}}}switch(n){case"BSDF_PRINCIPLED_BL":const e=this.getInputValue(t,N_IN[o].alpha);if(isDef(e))return e;break;case"EEVEE_SPECULAR_BL":case"PHYSICAL_MX":if(s=this.getInputValue(t,N_IN[o].transparency),isDef(s))return 1-s;break;case"OPENPBR_SURFACE_MX":case"OPENPBR_SURFACE_MY":if(l=this.getInputValue(t,N_IN[o].geometryOpacity),isDef(l))return l;break;case"LAMBERT_MY":case"SURFACE_SHADER_MY":if(s=this.getInputColor(t,N_IN[o].transparency),s)return 1-(s.r+s.g+s.b)/3;break;case"STANDARD_SURFACE_AR":case"LAMBERT_AR":if(l=this.getInputColor(t,N_IN[o].opacity),l)return(l.r+l.g+l.b)/3}break;case"metalness":if(this.getStandardProp("metalnessMap"))return 1;switch(n){case"BSDF_PRINCIPLED_BL":if(c=this.getInputValue(t,N_IN[o].metallic),isDef(c))return c;break;case"PHYSICAL_MX":case"STANDARD_SURFACE_AR":if(c=this.getInputValue(t,N_IN[o].metalness),isDef(c))return c;break;case"OPENPBR_SURFACE_MX":case"OPENPBR_SURFACE_MY":if(c=this.getInputValue(t,N_IN[o].baseMetalness),isDef(c))return c;break;case"BSDF_DIFFUSE_BL":case"LAMBERT_MY":case"LAMBERT_AR":case"EMISSION_BL":case"SURFACE_SHADER_MY":case"MAP_TO_MTL_AR":return 0;case"BSDF_GLOSSY_BL":case"BSDF_METALLIC_BL":return 1;case"EEVEE_SPECULAR_BL":return.5}break;case"metalnessMap":switch(n){case"BSDF_PRINCIPLED_BL":if(a=findConnectedNode(r,t,N_IN[o].metallic,"SEPARATE_COLOR_BL"),a&&(u=this.getInputTexture(a,N_IN.SEPARATE_COLOR_BL.color),u))return u;break;case"PHYSICAL_MX":case"STANDARD_SURFACE_AR":if(u=this.getInputTexture(t,N_IN[o].metalness),u)return u;break;case"OPENPBR_SURFACE_MX":case"OPENPBR_SURFACE_MY":if(u=this.getInputTexture(t,N_IN[o].baseMetalness),u)return u;break;case"BSDF_DIFFUSE_BL":case"BSDF_GLOSSY_BL":case"BSDF_METALLIC_BL":case"EEVEE_SPECULAR_BL":case"EMISSION_BL":case"LAMBERT_MY":case"LAMBERT_AR":case"SURFACE_SHADER_MY":case"MAP_TO_MTL_AR":return null}break;case"roughness":if(this.getStandardProp("roughnessMap"))return 1;switch(n){case"BSDF_PRINCIPLED_BL":case"BSDF_GLOSSY_BL":case"BSDF_METALLIC_BL":case"EEVEE_SPECULAR_BL":case"PHYSICAL_MX":if(d=this.getInputValue(t,N_IN[o].roughness),isDef(d))return d;break;case"OPENPBR_SURFACE_MX":case"OPENPBR_SURFACE_MY":case"STANDARD_SURFACE_AR":if(d=this.getInputValue(t,N_IN[o].specularRoughness),isDef(d))return d;break;case"BSDF_DIFFUSE_BL":case"LAMBERT_MY":case"LAMBERT_AR":return 1;case"EMISSION_BL":case"SURFACE_SHADER_MY":case"MAP_TO_MTL_AR":return.9}break;case"roughnessMap":switch(n){case"BSDF_PRINCIPLED_BL":case"BSDF_GLOSSY_BL":case"BSDF_METALLIC_BL":case"EEVEE_SPECULAR_BL":if(a=findConnectedNode(r,t,N_IN[o].roughness,"SEPARATE_COLOR_BL"),a&&(h=this.getInputTexture(a,N_IN.SEPARATE_COLOR_BL.color),h))return h;break;case"PHYSICAL_MX":if(h=this.getInputTexture(t,N_IN[o].roughness),h)return h;break;case"OPENPBR_SURFACE_MX":case"OPENPBR_SURFACE_MY":case"STANDARD_SURFACE_AR":if(h=this.getInputTexture(t,N_IN[o].specularRoughness),h)return h;break;case"BSDF_DIFFUSE_BL":case"EMISSION_BL":case"LAMBERT_MY":case"SURFACE_SHADER_MY":case"MAP_TO_MTL_AR":return null}break;case"aoMap":if(p=firstNodeType(r,"OUTPUT_MATERIAL_BL"),p>=0){const e=findConnectedNode(r,p,N_IN.OUTPUT_MATERIAL_BL.surface,"MIX_SHADER_BL");if(e){const t=findConnectedNode(r,e,N_IN.MIX_SHADER_BL.fac,"SEPARATE_COLOR_BL"),n=findConnectedNode(r,e,N_IN.MIX_SHADER_BL.color1,"BSDF_DIFFUSE_BL"),o=findConnectedNode(r,e,N_IN.MIX_SHADER_BL.color2,STD_SHADER_NODES_BL);if(t&&n&&o){const e=this.getInputTexture(t,N_IN.SEPARATE_COLOR_BL.color);if(e)return e}}}else{let e;switch(n){case"PHYSICAL_MX":case"STANDARD_SURFACE_AR":if(e=this.getInputTexture(t,N_IN[o].base),e)return e;break;case"OPENPBR_SURFACE_MX":case"OPENPBR_SURFACE_MY":if(e=this.getInputTexture(t,N_IN[o].baseWeight),e)return e}}break;case"aoMapIntensity":break;case"normalMap":if(STD_SHADER_NODES_BL.includes(n)){const e=N_IN[o].normal;if(isDef(e)){const n=findConnectedNode(r,t,e,"NORMAL_MAP_BL");if(n){const e=this.getInputTexture(n,N_IN.NORMAL_MAP_BL.normalColor);if(e)return e}}}else if(STD_SHADER_NODES_MY.includes(n)){const e=N_IN[o].normal;if(isDef(e)){const n=findConnectedNode(r,t,e,"BUMP_2D_MY");if(n){const e=this.getInputTexture(n,N_IN.BUMP_2D_MY.bumpValue);if(e)return e}}}else if("PHYSICAL_MX"==n||"OPENPBR_SURFACE_MX"==n){const e=findConnectedNode(r,t,N_IN[o].normal,"NORMAL_BUMP_MX");if(e){const t=this.getInputTexture(e,N_IN.NORMAL_BUMP_MX.normalColor);if(t)return t}}break;case"normalScale":if(STD_SHADER_NODES_BL.includes(n)){const e=N_IN[o].normal;if(isDef(e)){const n=findConnectedNode(r,t,e,"NORMAL_MAP_BL");if(n){const e=this.getInputValue(n,N_IN.NORMAL_MAP_BL.strength);if(isDef(e))return new Vector2(e,e)}}}else if(STD_SHADER_NODES_MY.includes(n)){const e=N_IN[o].normal;if(isDef(e)){const n=findConnectedNode(r,t,e,"BUMP_2D_MY");if(n){const e=this.getInputValue(n,N_IN.BUMP_2D_MY.bumpDepth);if(isDef(e))return new Vector2(e,e)}}}else if("PHYSICAL_MX"==n||"OPENPBR_SURFACE_MX"==n){const e=findConnectedNode(r,t,N_IN[o].normal,"NORMAL_BUMP_MX");if(e){const t=this.getInputValue(e,N_IN.NORMAL_BUMP_MX.normalMult);if(isDef(t))return new Vector2(t,t)}}break;case"emissive":if(this.getStandardProp("emissiveMap"))return new Color(1,1,1);let e;switch(n){case"BSDF_PRINCIPLED_BL":e=this.getInputColor(t,N_IN[o].emission);break;case"EEVEE_SPECULAR_BL":e=this.getInputColor(t,N_IN[o].emissiveColor);break;case"PHYSICAL_MX":e=this.getInputColor(t,N_IN[o].emitColor);break;case"OPENPBR_SURFACE_MX":case"OPENPBR_SURFACE_MY":case"STANDARD_SURFACE_AR":e=this.getInputColor(t,N_IN[o].emissionColor)}if(e)return e;break;case"emissiveMap":let f;switch(n){case"BSDF_PRINCIPLED_BL":f=this.getInputTexture(t,N_IN[o].emission);break;case"EEVEE_SPECULAR_BL":f=this.getInputTexture(t,N_IN[o].emissiveColor);break;case"PHYSICAL_MX":f=this.getInputTexture(t,N_IN[o].emitColor);break;case"OPENPBR_SURFACE_MX":case"OPENPBR_SURFACE_MY":case"STANDARD_SURFACE_AR":f=this.getInputTexture(t,N_IN[o].emissionColor)}if(f)return f;break;case"emissiveIntensity":let m;switch(n){case"BSDF_PRINCIPLED_BL":m=this.getInputValue(t,N_IN[o].emissionStrength);break;case"EEVEE_SPECULAR_BL":m=1;break;case"PHYSICAL_MX":case"STANDARD_SURFACE_AR":m=this.getInputValue(t,N_IN[o].emission);break;case"OPENPBR_SURFACE_MX":m=this.getInputValue(t,N_IN[o].emissionWeight);break;case"OPENPBR_SURFACE_MY":m=this.getInputValue(t,N_IN[o].emissionLuminance/1e3)}if(isDef(m))return m}return STD_PROP_DEFAULTS[e]}isUnlit(){const e=this.getMainShaderNode();return!(!e||!nodeOfType(e,["EMISSION_BL","SURFACE_SHADER_MY","MAP_TO_MTL_AR"]))}copy(e){super.copy(e),this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.flatShading=e.flatShading,this.fog=e.fog,this.envMap=e.envMap,this.envMapIntensity=e.envMapIntensity,this.envMapParallaxType=e.envMapParallaxType,this.envMapParallaxMatrix.copy(e.envMapParallaxMatrix),this.envMapParallaxMatrixInv.copy(e.envMapParallaxMatrixInv),this.materialIndex=e.materialIndex,this.profile=e.profile,this.nodeTextures=Object.assign({},e.nodeTextures),this.nodeRGB=[];for(let t=0;t<e.nodeRGB.length;t++)this.nodeRGB.push(e.nodeRGB[t].clone());this.nodeRGBMap=Object.assign({},e.nodeRGBMap),this.nodeTexCoordObject=e.nodeTexCoordObject.slice(),this.nodeTexCoordObjectMap=Object.assign({},e.nodeTexCoordObjectMap),this.nodeValue=e.nodeValue.slice(),this.nodeValueMap=Object.assign({},e.nodeValueMap),this.nodeInputs={};for(const t in e.nodeInputs)this.nodeInputs[t]=e.nodeInputs[t].slice();this.needsBoundingBox=e.needsBoundingBox,this.useFloatTex=e.useFloatTex,this.nodeGraph=nodeGraphClone(e.nodeGraph),this.additionalNodeGraphs={};for(const t in e.additionalNodeGraphs)this.additionalNodeGraphs[t]=nodeGraphClone(e.additionalNodeGraphs[t]);return this.nodeChunks=Object.assign({},e.nodeChunks),this.nodeChunksHash=e.nodeChunksHash,this.nodeVCAliases=Object.assign({},e.nodeVCAliases),this.nodeUVAliases=Object.assign({},e.nodeUVAliases),this}}const Cache={enabled:!1,files:{},add:function(e,t){!1!==this.enabled&&(this.files[e]=t)},get:function(e){if(!1!==this.enabled)return this.files[e]},remove:function(e){delete this.files[e]},clear:function(){this.files={}}};class LoadingManager{constructor(e,t,n){const o=this;let r,i=!1,a=0,s=0;const l=[];this.onStart=void 0,this.onLoad=e,this.onProgress=t,this.onError=n,this.itemStart=function(e){s++,!1===i&&void 0!==o.onStart&&o.onStart(e,a,s),i=!0},this.itemEnd=function(e){a++,void 0!==o.onProgress&&o.onProgress(e,a,s),a===s&&(i=!1,void 0!==o.onLoad&&o.onLoad())},this.itemError=function(e){void 0!==o.onError&&o.onError(e)},this.resolveURL=function(e){return r?r(e):e},this.setURLModifier=function(e){return r=e,this},this.addHandler=function(e,t){return l.push(e,t),this},this.removeHandler=function(e){const t=l.indexOf(e);return-1!==t&&l.splice(t,2),this},this.getHandler=function(e){for(let t=0,n=l.length;t<n;t+=2){const n=l[t],o=l[t+1];if(n.global&&(n.lastIndex=0),n.test(e))return o}return null}}}const DefaultLoadingManager=new LoadingManager;class Loader{constructor(e){this.manager=void 0!==e?e:DefaultLoadingManager,this.crossOrigin="anonymous",this.withCredentials=!1,this.path="",this.resourcePath="",this.requestHeader={}}load(){}loadAsync(e,t){const n=this;return new Promise(function(o,r){n.load(e,o,t,r)})}parse(){}setCrossOrigin(e){return this.crossOrigin=e,this}setWithCredentials(e){return this.withCredentials=e,this}setPath(e){return this.path=e,this}setResourcePath(e){return this.resourcePath=e,this}setRequestHeader(e){return this.requestHeader=e,this}}const loading={};class HttpError extends Error{constructor(e,t){super(e),this.response=t}}class FileLoader extends Loader{constructor(e){super(e)}load(e,t,n,o){void 0===e&&(e=""),void 0!==this.path&&(e=this.path+e),e=this.manager.resolveURL(e);const r=Cache.get(e);if(void 0!==r)return this.manager.itemStart(e),setTimeout(()=>{t&&t(r),this.manager.itemEnd(e)},0),r;if(void 0!==loading[e])return void loading[e].push({onLoad:t,onProgress:n,onError:o});loading[e]=[],loading[e].push({onLoad:t,onProgress:n,onError:o});const i=new Request(e,{headers:new Headers(this.requestHeader),credentials:this.withCredentials?"include":"same-origin"}),a=this.mimeType,s=this.responseType;fetch(i).then(t=>{if(200===t.status||0===t.status){if(0===t.status&&console.warn("v3d.FileLoader: HTTP Status 0 received."),"undefined"==typeof ReadableStream||void 0===t.body||void 0===t.body.getReader)return t;const n=loading[e],o=t.body.getReader(),r=t.headers.get("Content-Length")||t.headers.get("X-File-Size"),i=r?parseInt(r):0,a=0!==i;let s=0;const l=new ReadableStream({start(e){!function t(){o.read().then(({done:o,value:r})=>{if(o)e.close();else{s+=r.byteLength;const o=new ProgressEvent("progress",{lengthComputable:a,loaded:s,total:i});for(let e=0,t=n.length;e<t;e++){const t=n[e];t.onProgress&&t.onProgress(o)}e.enqueue(r),t()}})}()}});return new Response(l)}throw new HttpError(`fetch for "${t.url}" responded with ${t.status}: ${t.statusText}`,t)}).then(e=>{switch(s){case"arraybuffer":return e.arrayBuffer();case"blob":return e.blob();case"document":return e.text().then(e=>(new DOMParser).parseFromString(e,a));case"json":return e.json();default:if(void 0===a)return e.text();{const t=/charset="?([^;"\s]*)"?/i.exec(a),n=t&&t[1]?t[1].toLowerCase():void 0,o=new TextDecoder(n);return e.arrayBuffer().then(e=>o.decode(e))}}}).then(t=>{Cache.add(e,t);const n=loading[e];delete loading[e];for(let e=0,o=n.length;e<o;e++){const o=n[e];o.onLoad&&o.onLoad(t)}}).catch(t=>{const n=loading[e];if(void 0===n)throw this.manager.itemError(e),t;delete loading[e];for(let e=0,o=n.length;e<o;e++){const o=n[e];o.onError&&o.onError(t)}this.manager.itemError(e)}).finally(()=>{this.manager.itemEnd(e)}),this.manager.itemStart(e)}setResponseType(e){return this.responseType=e,this}setMimeType(e){return this.mimeType=e,this}}class CompressedTextureLoader extends Loader{constructor(e){super(e)}load(e,t,n,o){const r=this,i=[],a=new CompressedTexture,s=new FileLoader(this.manager);s.setPath(this.path),s.setResponseType("arraybuffer"),s.setRequestHeader(this.requestHeader),s.setWithCredentials(r.withCredentials);let l=0;function c(c){s.load(e[c],function(e){const n=r.parse(e,!0);i[c]={width:n.width,height:n.height,format:n.format,mipmaps:n.mipmaps},l+=1,6===l&&(1===n.mipmapCount&&(a.minFilter=1006),a.image=i,a.format=n.format,a.needsUpdate=!0,t&&t(a))},n,o)}if(Array.isArray(e))for(let t=0,n=e.length;t<n;++t)c(t);else s.load(e,function(e){const n=r.parse(e,!0);if(n.isCubemap){const e=n.mipmaps.length/n.mipmapCount;for(let t=0;t<e;t++){i[t]={mipmaps:[]};for(let e=0;e<n.mipmapCount;e++)i[t].mipmaps.push(n.mipmaps[t*n.mipmapCount+e]),i[t].format=n.format,i[t].width=n.width,i[t].height=n.height}a.image=i}else a.image.width=n.width,a.image.height=n.height,a.mipmaps=n.mipmaps;1===n.mipmapCount&&(a.minFilter=1006),a.format=n.format,a.needsUpdate=!0,t&&t(a)},n,o);return a}}class ImageLoader extends Loader{constructor(e){super(e)}load(e,t,n,o){void 0!==this.path&&(e=this.path+e),e=this.manager.resolveURL(e);const r=this,i=Cache.get(e);if(void 0!==i)return r.manager.itemStart(e),setTimeout(function(){t&&t(i),r.manager.itemEnd(e)},0),i;const a=createElementNS("img");function s(){c(),Cache.add(e,this),t&&t(this),r.manager.itemEnd(e)}function l(t){c(),o&&o(t),r.manager.itemError(e),r.manager.itemEnd(e)}function c(){a.removeEventListener("load",s,!1),a.removeEventListener("error",l,!1)}return a.addEventListener("load",s,!1),a.addEventListener("error",l,!1),"data:"!==e.slice(0,5)&&void 0!==this.crossOrigin&&(a.crossOrigin=this.crossOrigin),r.manager.itemStart(e),a.src=e,a}}class CubeTextureLoader extends Loader{constructor(e){super(e)}load(e,t,n,o){const r=new CubeTexture,i=new ImageLoader(this.manager);i.setCrossOrigin(this.crossOrigin),i.setPath(this.path);let a=0;function s(n){i.load(e[n],function(e){r.images[n]=e,a++,6===a&&(r.needsUpdate=!0,t&&t(r))},void 0,o)}for(let t=0;t<e.length;++t)s(t);return r}}class DataTextureLoader extends Loader{constructor(e){super(e)}load(e,t,n,o){const r=this,i=new DataTexture,a=new FileLoader(this.manager);return a.setResponseType("arraybuffer"),a.setRequestHeader(this.requestHeader),a.setPath(this.path),a.setWithCredentials(r.withCredentials),a.load(e,function(e){const n=r.parse(e);n&&(void 0!==n.image?i.image=n.image:void 0!==n.data&&(i.image.width=n.width,i.image.height=n.height,i.image.data=n.data),i.wrapS=void 0!==n.wrapS?n.wrapS:1001,i.wrapT=void 0!==n.wrapT?n.wrapT:1001,i.magFilter=void 0!==n.magFilter?n.magFilter:1006,i.minFilter=void 0!==n.minFilter?n.minFilter:1006,i.anisotropy=void 0!==n.anisotropy?n.anisotropy:1,void 0!==n.encoding&&(i.encoding=n.encoding),void 0!==n.flipY&&(i.flipY=n.flipY),void 0!==n.format&&(i.format=n.format),void 0!==n.type&&(i.type=n.type),void 0!==n.mipmaps&&(i.mipmaps=n.mipmaps,i.minFilter=1008),1===n.mipmapCount&&(i.minFilter=1006),void 0!==n.generateMipmaps&&(i.generateMipmaps=n.generateMipmaps),i.needsUpdate=!0,t&&t(i,n))},n,o),i}}class TextureLoader extends Loader{constructor(e){super(e)}load(e,t,n,o){const r=new Texture,i=new ImageLoader(this.manager);return i.setCrossOrigin(this.crossOrigin),i.setPath(this.path),i.load(e,function(e){r.image=e,r.needsUpdate=!0,void 0!==t&&t(r)},n,o),r}}class ImageBitmapLoader extends Loader{constructor(e){super(e),this.isImageBitmapLoader=!0,"undefined"==typeof createImageBitmap&&console.warn("v3d.ImageBitmapLoader: createImageBitmap() not supported."),"undefined"==typeof fetch&&console.warn("v3d.ImageBitmapLoader: fetch() not supported."),this.options={premultiplyAlpha:"none"}}setOptions(e){return this.options=e,this}load(e,t,n,o){void 0===e&&(e=""),void 0!==this.path&&(e=this.path+e),e=this.manager.resolveURL(e);const r=this,i=Cache.get(e);if(void 0!==i)return r.manager.itemStart(e),setTimeout(function(){t&&t(i),r.manager.itemEnd(e)},0),i;const a={};a.credentials="anonymous"===this.crossOrigin?"same-origin":"include",a.headers=this.requestHeader,fetch(e,a).then(function(e){return e.blob()}).then(function(e){return createImageBitmap(e,Object.assign(r.options,{colorSpaceConversion:"none"}))}).then(function(n){Cache.add(e,n),t&&t(n),r.manager.itemEnd(e)}).catch(function(t){o&&o(t),r.manager.itemError(e),r.manager.itemEnd(e)}),r.manager.itemStart(e)}}class LoaderUtils{static decodeText(e){if("undefined"!=typeof TextDecoder)return(new TextDecoder).decode(e);let t="";for(let n=0,o=e.length;n<o;n++)t+=String.fromCharCode(e[n]);try{return decodeURIComponent(escape(t))}catch(e){return t}}static extractUrlBase(e){const t=e.lastIndexOf("/");return-1===t?"./":e.slice(0,t+1)}static resolveURL(e,t){return"string"!=typeof e||""===e?"":(/^https?:\/\//i.test(t)&&/^\//.test(e)&&(t=t.replace(/(^https?:\/\/[^\/]+).*/i,"$1")),/^(https?:)?\/\//i.test(e)||/^data:.*,.*$/i.test(e)||/^blob:.*$/i.test(e)?e:t+e)}}let _context;class AudioContext{static getContext(){return void 0===_context&&(_context=new(window.AudioContext||window.webkitAudioContext)),_context}static setContext(e){_context=e}}class AudioLoader extends Loader{constructor(e){super(e)}load(e,t,n,o){const r=this,i=new FileLoader(this.manager);i.setResponseType("arraybuffer"),i.setPath(this.path),i.setRequestHeader(this.requestHeader),i.setWithCredentials(this.withCredentials),i.load(e,function(n){try{const e=n.slice(0);AudioContext.getContext().decodeAudioData(e,function(e){t(e)})}catch(t){o?o(t):console.error(t),r.manager.itemError(e)}},n,o)}}class Light extends Object3D{constructor(e,t=1){super(),this.isLight=!0,this.type="Light",this.color=new Color(e),this.intensity=t}dispose(){}copy(e,t){return super.copy(e,t),this.color.copy(e.color),this.intensity=e.intensity,this}getWorldDirection(e){this.updateWorldMatrix(!0,!1);const t=this.matrixWorld.elements;return e.set(-t[8],-t[9],-t[10]).normalize()}}const _dir$2=new Vector3;class SpotLight extends Light{constructor(e,t,n=0,o=Math.PI/3,r=0,i=2){super(e,t),this.isSpotLight=!0,this.type="SpotLight",this.position.copy(Object3D.DefaultUp),this.updateMatrix(),this.target=new Object3D,this.distance=n,this.angle=o,this.penumbra=r,this.decay=i,this.shadow=new SpotLightShadow,this.isFreeLight=!1}get power(){return 4*this.intensity*Math.PI}set power(e){this.intensity=e/(4*Math.PI)}dispose(){this.shadow.dispose()}copy(e,t){return super.copy(e,t),this.distance=e.distance,this.angle=e.angle,this.penumbra=e.penumbra,this.decay=e.decay,this.target=e.target.clone(),this.shadow=e.shadow.clone(),this.isFreeLight=e.isFreeLight,this}updateMatrixWorld(e){super.updateMatrixWorld(e),this.isFreeLight&&this.updateFreeLightTarget()}updateWorldMatrix(e,t){super.updateWorldMatrix(e,t),this.isFreeLight&&this.updateFreeLightTarget()}updateFreeLightTarget(){_dir$2.set(0,0,-1).applyQuaternion(this.quaternion).normalize(),this.target.position.addVectors(this.position,_dir$2),this.target.updateMatrixWorld()}}const _projScreenMatrix=new Matrix4,_lightPositionWorld=new Vector3,_lookTarget=new Vector3;class PointLightShadow extends LightShadow{constructor(){super(new PerspectiveCamera(90,1,.5,500)),this.isPointLightShadow=!0,this._frameExtents=new Vector2(4,2),this._viewportCount=6,this._viewports=[new Vector4(2,1,1,1),new Vector4(0,1,1,1),new Vector4(3,1,1,1),new Vector4(1,1,1,1),new Vector4(3,0,1,1),new Vector4(1,0,1,1)],this._cubeDirections=[new Vector3(1,0,0),new Vector3(-1,0,0),new Vector3(0,0,1),new Vector3(0,0,-1),new Vector3(0,1,0),new Vector3(0,-1,0)],this._cubeUps=[new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,0,1),new Vector3(0,0,-1)]}updateMatrices(e,t=0){const n=this.camera,o=this.matrix,r=e.distance||n.far;r!==n.far&&(n.far=r,n.updateProjectionMatrix()),_lightPositionWorld.setFromMatrixPosition(e.matrixWorld),n.position.copy(_lightPositionWorld),_lookTarget.copy(n.position),_lookTarget.add(this._cubeDirections[t]),n.up.copy(this._cubeUps[t]),n.lookAt(_lookTarget),n.updateMatrixWorld(),o.makeTranslation(-_lightPositionWorld.x,-_lightPositionWorld.y,-_lightPositionWorld.z),_projScreenMatrix.multiplyMatrices(n.projectionMatrix,n.matrixWorldInverse),this._frustum.setFromProjectionMatrix(_projScreenMatrix)}}class PointLight extends Light{constructor(e,t,n=0,o=2){super(e,t),this.isPointLight=!0,this.type="PointLight",this.distance=n,this.decay=o,this.shadow=new PointLightShadow}get power(){return 4*this.intensity*Math.PI}set power(e){this.intensity=e/(4*Math.PI)}dispose(){this.shadow.dispose()}copy(e,t){return super.copy(e,t),this.distance=e.distance,this.decay=e.decay,this.shadow=e.shadow.clone(),this}}class RectAreaLightShadow extends PointLightShadow{constructor(){super(),this.isRectAreaLightShadow=!0}}class RectAreaLight extends Light{constructor(e,t,n=10,o=10){super(e,t),this.isRectAreaLight=!0,this.type="RectAreaLight",this.width=n,this.height=o,this.shadow=new RectAreaLightShadow}get power(){return 2*this.intensity*Math.PI}set power(e){this.intensity=e/(2*Math.PI)}copy(e){return super.copy(e),this.width=e.width,this.height=e.height,this.shadow=e.shadow.clone(),this}}const inverseProjectionMatrix=new Matrix4;class CSMFrustum{constructor({maxFar:e=1e5,projectionMatrix:t=null}={}){this.vertices={near:[new Vector3,new Vector3,new Vector3,new Vector3],far:[new Vector3,new Vector3,new Vector3,new Vector3]},t&&this.setFromProjectionMatrix(t,e)}setFromProjectionMatrix(e,t){const n=0===e.elements[11];return inverseProjectionMatrix.copy(e).invert(),this.vertices.near[0].set(1,1,-1),this.vertices.near[1].set(1,-1,-1),this.vertices.near[2].set(-1,-1,-1),this.vertices.near[3].set(-1,1,-1),this.vertices.near.forEach(function(e){e.applyMatrix4(inverseProjectionMatrix)}),this.vertices.far[0].set(1,1,1),this.vertices.far[1].set(1,-1,1),this.vertices.far[2].set(-1,-1,1),this.vertices.far[3].set(-1,1,1),this.vertices.far.forEach(function(e){e.applyMatrix4(inverseProjectionMatrix);const o=Math.abs(e.z);n?e.z*=Math.min(t/o,1):e.multiplyScalar(Math.min(t/o,1))}),this.vertices}split(e,t,n){for(;e.length>t.length;)t.push(new CSMFrustum);t.length=e.length;for(let o=0;o<e.length;o++){const r=t[o];if(0===o||n)for(let e=0;e<4;e++)r.vertices.near[e].copy(this.vertices.near[e]);else for(let t=0;t<4;t++)r.vertices.near[t].lerpVectors(this.vertices.near[t],this.vertices.far[t],e[o-1]);if(o===e.length-1)for(let e=0;e<4;e++)r.vertices.far[e].copy(this.vertices.far[e]);else for(let t=0;t<4;t++)r.vertices.far[t].lerpVectors(this.vertices.near[t],this.vertices.far[t],e[o])}}toSpace(e,t){for(let n=0;n<4;n++)t.vertices.near[n].copy(this.vertices.near[n]).applyMatrix4(e),t.vertices.far[n].copy(this.vertices.far[n]).applyMatrix4(e)}}const _vec3Tmp$7=new Vector3,_vec3Tmp2$5=new Vector3,_vec3Tmp3$2=new Vector3,_mat4Tmp$2=new Matrix4;new Matrix4;const _bbox$1=new Box3,_lightSpaceFrustum=new CSMFrustum,_uniformArray=[],_logArray=[];class DirectionalLightShadowCascade extends LightShadow{constructor(){super(new OrthographicCamera(-5,5,5,-5,.5,500)),this.esmBlurRadius=0,this.pancakeDepth=!0,this.isDirectionalLightShadowCascade=!0}updateMatrices(e){const t=this.camera,n=this.matrix,o=_vec3Tmp$7.setFromMatrixPosition(t.matrixWorld),r=_vec3Tmp2$5.setFromMatrixPosition(e.matrixWorld);t.position.copy(r);const i=_vec3Tmp3$2.setFromMatrixPosition(e.target.matrixWorld);t.lookAt(i),t.position.copy(o),t.updateMatrixWorld();const a=_mat4Tmp$2.multiplyMatrices(t.projectionMatrix,t.matrixWorldInverse);this._frustum.setFromProjectionMatrix(a),this.pancakeDepth&&(this._frustum.planes[5].constant=1/0),n.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),n.multiply(a)}}class DirectionalLightShadowCSM extends LightShadow{constructor({numCascades:e=1,maxDistance:t=500,fade:n=0,lightMargin:o=1,noLastCascadeCutOff:r=!0,customSplitsCallback:i=null}={}){super(new OrthographicCamera(-5,5,5,-5,.5,500)),this.numCascades=e,this.exponent=.5,this.customSplitsCallback=i,this.maxDistance=t,this.fade=n,this.lightMargin=o,this.noLastCascadeCutOff=r,this.cascadesFitToScene=!1,this.mainFrustum=new CSMFrustum,this._frustums=[],this._breaks=[],this._cascades=[],this._sceneViewProjectionMatrix=new Matrix4,this._sceneViewCamera=null,this._needsCascadeFrustumsUpdate=!0,this.createCascades(),this.isDirectionalLightShadowCSM=!0}createCascades(){const e=this._cascades;for(;e.length>this.numCascades;)e.pop().dispose();for(let t=e.length;t<this.numCascades;t++){const t=new DirectionalLightShadowCascade;t.mapSize.copy(this.mapSize),t.copy(this),e.push(t)}for(let t=0;t<e.length;t++){const n=e[t];n.mapSize.copy(this.mapSize),n.copy(this)}this.updateMapSize()}initCascades(e){e.updateProjectionMatrix(),this.mainFrustum.setFromProjectionMatrix(e.projectionMatrix,this.maxDistance),this.mainFrustum.split(this._breaks,this._frustums,this.cascadesFitToScene)}updateShadowBounds(e){const t=this._frustums;for(let n=0;n<t.length;n++){const o=this._cascades[n],r=this._cascades[n].camera,i=t[n],a=i.vertices.near,s=i.vertices.far,l=s[0];let c;c=l.distanceTo(s[2])>l.distanceTo(a[2])?s[2]:a[2];let u=l.distanceTo(c);if(this.fade>0){const t=Math.min(e.far,this.maxDistance),n=e.near,o=i.vertices.far[0].z/(t-n);u+=this.fade*Math.pow(o,2)*(t-n)}r.left=-u/2,r.right=u/2,r.top=u/2,r.bottom=-u/2,r.near=0,r.far=u+this.lightMargin,r.updateProjectionMatrix(),o.bias=this.bias,o.normalBias=this.normalBias,o.esmBlurRadius=o.radius/((r.right-r.left)/2)}}getBreaks(e){const t=e.near,n=Math.min(e.far,this.maxDistance),o=this.numCascades,r=this.exponent,i=this._breaks;i.length=0,this.customSplitsCallback?this.customSplitsCallback(o,t,n,i,r):function(e,t,n,o,r){_uniformArray.length=0,_logArray.length=0,function(e,t,n,o){for(let r=1;r<e;r++)o.push(t*(n/t)**(r/e)/n);o.push(1)}(e,t,n,_logArray),function(e,t,n,o){for(let r=1;r<e;r++)o.push((t+(n-t)*r/e)/n);o.push(1)}(e,t,n,_uniformArray);for(let t=1;t<e;t++)r.push(lerp(_uniformArray[t-1],_logArray[t-1],o));r.push(1)}(o,t,n,r,i)}updateCascadePositions(e){const t=this._frustums;for(let n=0;n<t.length;n++){const o=this._cascades[n],r=this._cascades[n].camera,i=(r.right-r.left)/o.mapSize.x,a=(r.top-r.bottom)/o.mapSize.y;r.updateMatrixWorld(!0);const s=_mat4Tmp$2.multiplyMatrices(r.matrixWorldInverse,e.matrixWorld);t[n].toSpace(s,_lightSpaceFrustum);const l=_lightSpaceFrustum.vertices.near,c=_lightSpaceFrustum.vertices.far;_bbox$1.makeEmpty();for(let e=0;e<4;e++)_bbox$1.expandByPoint(l[e]),_bbox$1.expandByPoint(c[e]);const u=_bbox$1.getCenter(_vec3Tmp$7);u.z=_bbox$1.max.z+this.lightMargin,u.x=Math.floor(u.x/i)*i,u.y=Math.floor(u.y/a)*a,u.applyMatrix4(r.matrixWorld),r.position.copy(u),r.updateMatrixWorld()}}update(e,t){!this._needsCascadeFrustumsUpdate&&this._sceneViewCamera===e&&this._sceneViewProjectionMatrix.equals(e.projectionMatrix)||(this.updateFrustums(e),this.updateMatrices(t),this._sceneViewCamera=e,this._sceneViewProjectionMatrix.copy(e.projectionMatrix),this._needsCascadeFrustumsUpdate=!1),this.updateCascadePositions(e)}getCascadeRange(e,t){const n=this._breaks,o=n[t],r=n[t-1]||0;e.x=r,e.y=o,this.noLastCascadeCutOff&&t==n.length-1&&(e.y=1/0)}updateFrustums(e){this.getBreaks(e),this.initCascades(e),this.updateShadowBounds(e)}updateMatrices(e){for(let t=0;t<this._cascades.length;t++)this._cascades[t].updateMatrices(e)}updateMapSize(e){e&&this.mapSize.copy(e);const t=this.mapSize;for(let e=0;e<this._cascades.length;e++){this._cascades[e].mapSize.copy(t)}this.updateMaps()}updateMaps(){for(let e=0;e<this._cascades.length;e++){const t=this._cascades[e];t.dispose(),t.map=null,t._additionalMap2D=null,t._additionalMapCube=null}}dispose(){for(let e=0;e<this._cascades.length;e++)this._cascades[e].dispose();super.dispose()}copy(e){return super.copy(e),this.numCascades=e.numCascades,this.exponent=e.exponent,this.maxDistance=e.maxDistance,this.fade=e.fade,this.lightMargin=e.lightMargin,this.noLastCascadeCutOff=e.noLastCascadeCutOff,this.createCascades(),this}clone(){return(new this.constructor).copy(this)}setCascadesFitToScene(e){this.cascadesFitToScene=e,this._needsCascadeFrustumsUpdate=!0}setExponent(e){this.exponent=e,this._needsCascadeFrustumsUpdate=!0}setFade(e){this.fade=e,this._needsCascadeFrustumsUpdate=!0}setMaxDistance(e){this.maxDistance=e,this._needsCascadeFrustumsUpdate=!0}setNoLastCascadeCutOff(e){this.noLastCascadeCutOff=e,this._needsCascadeFrustumsUpdate=!0}setNumCascades(e){this.numCascades=e,this._needsCascadeFrustumsUpdate=!0,this.createCascades()}setLightMargin(e){this.lightMargin=e,this._needsCascadeFrustumsUpdate=!0}}const _dir$1=new Vector3;class DirectionalLight extends Light{constructor(e,t){super(e,t),this.isDirectionalLight=!0,this.type="DirectionalLight",this.position.copy(Object3D.DefaultUp),this.updateMatrix(),this.target=new Object3D,this.shadow=new DirectionalLightShadowCSM,this.isFreeLight=!1}dispose(){this.shadow.dispose()}copy(e){return super.copy(e),this.target=e.target.clone(),this.shadow=e.shadow.clone(),this.isFreeLight=e.isFreeLight,this}updateMatrixWorld(e){super.updateMatrixWorld(e),this.isFreeLight&&this.updateFreeLightTarget()}updateWorldMatrix(e,t){super.updateWorldMatrix(e,t),this.isFreeLight&&this.updateFreeLightTarget()}updateFreeLightTarget(){_dir$1.set(0,0,-1).applyQuaternion(this.quaternion).normalize(),this.target.position.addVectors(this.position,_dir$1),this.target.updateMatrixWorld()}}class AmbientLight extends Light{constructor(e,t){super(e,t),this.isAmbientLight=!0,this.type="AmbientLight"}}class SphericalHarmonics3{constructor(){this.isSphericalHarmonics3=!0,this.coefficients=[];for(let e=0;e<9;e++)this.coefficients.push(new Vector3)}set(e){for(let t=0;t<9;t++)this.coefficients[t].copy(e[t]);return this}zero(){for(let e=0;e<9;e++)this.coefficients[e].set(0,0,0);return this}getAt(e,t){const n=e.x,o=e.y,r=e.z,i=this.coefficients;return t.copy(i[0]).multiplyScalar(.282095),t.addScaledVector(i[1],.488603*o),t.addScaledVector(i[2],.488603*r),t.addScaledVector(i[3],.488603*n),t.addScaledVector(i[4],n*o*1.092548),t.addScaledVector(i[5],o*r*1.092548),t.addScaledVector(i[6],.315392*(3*r*r-1)),t.addScaledVector(i[7],n*r*1.092548),t.addScaledVector(i[8],.546274*(n*n-o*o)),t}getIrradianceAt(e,t){const n=e.x,o=e.y,r=e.z,i=this.coefficients;return t.copy(i[0]).multiplyScalar(.886227),t.addScaledVector(i[1],1.023328*o),t.addScaledVector(i[2],1.023328*r),t.addScaledVector(i[3],1.023328*n),t.addScaledVector(i[4],.858086*n*o),t.addScaledVector(i[5],.858086*o*r),t.addScaledVector(i[6],.743125*r*r-.247708),t.addScaledVector(i[7],.858086*n*r),t.addScaledVector(i[8],.429043*(n*n-o*o)),t}add(e){for(let t=0;t<9;t++)this.coefficients[t].add(e.coefficients[t]);return this}addScaledSH(e,t){for(let n=0;n<9;n++)this.coefficients[n].addScaledVector(e.coefficients[n],t);return this}scale(e){for(let t=0;t<9;t++)this.coefficients[t].multiplyScalar(e);return this}lerp(e,t){for(let n=0;n<9;n++)this.coefficients[n].lerp(e.coefficients[n],t);return this}equals(e){for(let t=0;t<9;t++)if(!this.coefficients[t].equals(e.coefficients[t]))return!1;return!0}copy(e){return this.set(e.coefficients)}clone(){return(new this.constructor).copy(this)}fromArray(e,t=0){const n=this.coefficients;for(let o=0;o<9;o++)n[o].fromArray(e,t+3*o);return this}toArray(e=[],t=0){const n=this.coefficients;for(let o=0;o<9;o++)n[o].toArray(e,t+3*o);return e}static getBasisAt(e,t){const n=e.x,o=e.y,r=e.z;t[0]=.282095,t[1]=.488603*o,t[2]=.488603*r,t[3]=.488603*n,t[4]=1.092548*n*o,t[5]=1.092548*o*r,t[6]=.315392*(3*r*r-1),t[7]=1.092548*n*r,t[8]=.546274*(n*n-o*o)}}class LightProbe extends Light{constructor(e=new SphericalHarmonics3,t=1){super(void 0,t),this.isLightProbe=!0,this.type="LightProbe",this.sh=e}copy(e){return super.copy(e),this.sh.copy(e.sh),this}}class Clock{constructor(e=!0){this.autoStart=e,this.startTime=0,this.oldTime=0,this.elapsedTime=0,this.running=!1}start(){this.startTime=performance.now(),this.oldTime=this.startTime,this.elapsedTime=0,this.running=!0}stop(){this.getElapsedTime(),this.running=!1,this.autoStart=!1}getElapsedTime(){return this.getDelta(),this.elapsedTime}getDelta(){let e=0;if(this.autoStart&&!this.running)return this.start(),0;if(this.running){const t=performance.now();e=(t-this.oldTime)/1e3,this.oldTime=t,this.elapsedTime+=e}return e}}const _position$2=new Vector3,_quaternion$2=new Quaternion,_scale$a=new Vector3,_orientation$1=new Vector3;class AudioListener extends Object3D{constructor(){super(),this.type="AudioListener",this.context=AudioContext.getContext(),this.gain=this.context.createGain(),this.gain.connect(this.context.destination),this.filter=null,this.timeDelta=0,this._clock=new Clock}getInput(){return this.gain}removeFilter(){return null!==this.filter&&(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination),this.gain.connect(this.context.destination),this.filter=null),this}getFilter(){return this.filter}setFilter(e){return null!==this.filter?(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination)):this.gain.disconnect(this.context.destination),this.filter=e,this.gain.connect(this.filter),this.filter.connect(this.context.destination),this}getMasterVolume(){return this.gain.gain.value}setMasterVolume(e){return this.gain.gain.setTargetAtTime(e,this.context.currentTime,.01),this}updateMatrixWorld(e){super.updateMatrixWorld(e);const t=this.context.listener,n=this.up;if(this.timeDelta=this._clock.getDelta(),this.matrixWorld.decompose(_position$2,_quaternion$2,_scale$a),_orientation$1.set(0,0,-1).applyQuaternion(_quaternion$2),t.positionX){const e=this.context.currentTime+this.timeDelta;t.positionX.linearRampToValueAtTime(_position$2.x,e),t.positionY.linearRampToValueAtTime(_position$2.y,e),t.positionZ.linearRampToValueAtTime(_position$2.z,e),t.forwardX.linearRampToValueAtTime(_orientation$1.x,e),t.forwardY.linearRampToValueAtTime(_orientation$1.y,e),t.forwardZ.linearRampToValueAtTime(_orientation$1.z,e),t.upX.linearRampToValueAtTime(n.x,e),t.upY.linearRampToValueAtTime(n.y,e),t.upZ.linearRampToValueAtTime(n.z,e)}else t.setPosition(_position$2.x,_position$2.y,_position$2.z),t.setOrientation(_orientation$1.x,_orientation$1.y,_orientation$1.z,n.x,n.y,n.z)}}class Audio extends Object3D{constructor(e){super(),this.type="Audio",this.listener=e,this.context=e.context,this.gain=this.context.createGain(),this.gain.connect(e.getInput()),this.autoplay=!1,this.buffer=null,this.detune=0,this.loop=!1,this.loopStart=0,this.loopEnd=0,this.offset=0,this.duration=void 0,this.playbackRate=1,this.isPlaying=!1,this.hasPlaybackControl=!0,this.source=null,this.sourceType="empty",this._startedAt=0,this._progress=0,this._connected=!1,this.filters=[]}getOutput(){return this.gain}setNodeSource(e){return this.hasPlaybackControl=!1,this.sourceType="audioNode",this.source=e,this.connect(),this}setMediaElementSource(e){return this.hasPlaybackControl=!1,this.sourceType="mediaNode",this.source=this.context.createMediaElementSource(e),this.connect(),this}setMediaStreamSource(e){return this.hasPlaybackControl=!1,this.sourceType="mediaStreamNode",this.source=this.context.createMediaStreamSource(e),this.connect(),this}setBuffer(e){return this.buffer=e,this.sourceType="buffer",this.autoplay&&this.play(),this}play(e=0){if(!0===this.isPlaying)return void console.warn("v3d.Audio: Audio is already playing.");if(!1===this.hasPlaybackControl)return void console.warn("v3d.Audio: this Audio has no playback control.");this._startedAt=this.context.currentTime+e;const t=this.context.createBufferSource();return t.buffer=this.buffer,t.loop=this.loop,t.loopStart=this.loopStart,t.loopEnd=this.loopEnd,t.onended=this.onEnded.bind(this),t.start(this._startedAt,this._progress+this.offset,this.duration),this.isPlaying=!0,this.source=t,this.setDetune(this.detune),this.setPlaybackRate(this.playbackRate),this.connect()}pause(){if(!1!==this.hasPlaybackControl)return!0===this.isPlaying&&(this._progress+=Math.max(this.context.currentTime-this._startedAt,0)*this.playbackRate,!0===this.loop&&(this._progress=this._progress%(this.duration||this.buffer.duration)),this.source.stop(),this.source.onended=null,this.isPlaying=!1),this;console.warn("v3d.Audio: this Audio has no playback control.")}stop(){if(!1!==this.hasPlaybackControl)return this._progress=0,this.source.stop(),this.source.onended=null,this.isPlaying=!1,this;console.warn("v3d.Audio: this Audio has no playback control.")}connect(){if(this.filters.length>0){this.source.connect(this.filters[0]);for(let e=1,t=this.filters.length;e<t;e++)this.filters[e-1].connect(this.filters[e]);this.filters[this.filters.length-1].connect(this.getOutput())}else this.source.connect(this.getOutput());return this._connected=!0,this}disconnect(){if(this.filters.length>0){this.source.disconnect(this.filters[0]);for(let e=1,t=this.filters.length;e<t;e++)this.filters[e-1].disconnect(this.filters[e]);this.filters[this.filters.length-1].disconnect(this.getOutput())}else this.source.disconnect(this.getOutput());return this._connected=!1,this}getFilters(){return this.filters}setFilters(e){return e||(e=[]),!0===this._connected?(this.disconnect(),this.filters=e.slice(),this.connect()):this.filters=e.slice(),this}setDetune(e){if(this.detune=e,void 0!==this.source.detune)return!0===this.isPlaying&&this.source.detune.setTargetAtTime(this.detune,this.context.currentTime,.01),this}getDetune(){return this.detune}getFilter(){return this.getFilters()[0]}setFilter(e){return this.setFilters(e?[e]:[])}setPlaybackRate(e){if(!1!==this.hasPlaybackControl)return this.playbackRate=e,!0===this.isPlaying&&this.source.playbackRate.setTargetAtTime(this.playbackRate,this.context.currentTime,.01),this;console.warn("v3d.Audio: this Audio has no playback control.")}getPlaybackRate(){return this.playbackRate}onEnded(){this.isPlaying=!1}getLoop(){return!1===this.hasPlaybackControl?(console.warn("v3d.Audio: this Audio has no playback control."),!1):this.loop}setLoop(e){if(!1!==this.hasPlaybackControl)return this.loop=e,!0===this.isPlaying&&(this.source.loop=this.loop),this;console.warn("v3d.Audio: this Audio has no playback control.")}setLoopStart(e){return this.loopStart=e,this}setLoopEnd(e){return this.loopEnd=e,this}getVolume(){return this.gain.gain.value}setVolume(e){return this.gain.gain.setTargetAtTime(e,this.context.currentTime,.01),this}}const _position$1=new Vector3,_quaternion$1=new Quaternion,_scale$9=new Vector3,_orientation=new Vector3;class PositionalAudio extends Audio{constructor(e){super(e),this.panner=this.context.createPanner(),this.panner.panningModel="HRTF",this.panner.connect(this.gain)}fromAudio(e){return this.panner.disconnect(this.gain),this.listener=e.listener,this.context=e.context,this.gain=e.gain,this.autoplay=e.autoplay,this.buffer=e.buffer,this.detune=e.detune,this.loop=e.loop,this.loopStart=e.loopStart,this.loopEnd=e.loopEnd,this.offset=e.offset,this.duration=e.duration,this.playbackRate=e.playbackRate,this.isPlaying=e.isPlaying,this.hasPlaybackControl=e.hasPlaybackControl,this.audio=e.audio,this.sourceType=e.sourceType,this._startedAt=e._startedAt,this._progress=e._progress,this._connected=e._connected,this.filters=e.filters.slice(0),this.panner.connect(this.gain),this}disconnect(){super.disconnect(),this.panner.disconnect(this.gain)}getOutput(){return this.panner}getRefDistance(){return this.panner.refDistance}setRefDistance(e){return this.panner.refDistance=e,this}getRolloffFactor(){return this.panner.rolloffFactor}setRolloffFactor(e){return this.panner.rolloffFactor=e,this}getDistanceModel(){return this.panner.distanceModel}setDistanceModel(e){return this.panner.distanceModel=e,this}getMaxDistance(){return this.panner.maxDistance}setMaxDistance(e){return this.panner.maxDistance=e,this}setDirectionalCone(e,t,n){return this.panner.coneInnerAngle=e,this.panner.coneOuterAngle=t,this.panner.coneOuterGain=n,this}updateMatrixWorld(e){if(super.updateMatrixWorld(e),!0===this.hasPlaybackControl&&!1===this.isPlaying)return;this.matrixWorld.decompose(_position$1,_quaternion$1,_scale$9),_orientation.set(0,0,1).applyQuaternion(_quaternion$1);const t=this.panner;if(t.positionX){const e=this.context.currentTime+this.listener.timeDelta;t.positionX.linearRampToValueAtTime(_position$1.x,e),t.positionY.linearRampToValueAtTime(_position$1.y,e),t.positionZ.linearRampToValueAtTime(_position$1.z,e),t.orientationX.linearRampToValueAtTime(_orientation.x,e),t.orientationY.linearRampToValueAtTime(_orientation.y,e),t.orientationZ.linearRampToValueAtTime(_orientation.z,e)}else t.setPosition(_position$1.x,_position$1.y,_position$1.z),t.setOrientation(_orientation.x,_orientation.y,_orientation.z)}}class AudioAnalyser{constructor(e,t=2048){this.analyser=e.context.createAnalyser(),this.analyser.fftSize=t,this.data=new Uint8Array(this.analyser.frequencyBinCount),e.getOutput().connect(this.analyser)}getFrequencyData(){return this.analyser.getByteFrequencyData(this.data),this.data}getAverageFrequency(){let e=0;const t=this.getFrequencyData();for(let n=0;n<t.length;n++)e+=t[n];return e/t.length}}class CubicInterpolant extends Interpolant{constructor(e,t,n,o){super(e,t,n,o),this._weightPrev=-0,this._offsetPrev=-0,this._weightNext=-0,this._offsetNext=-0,this.DefaultSettings_={endingStart:2400,endingEnd:2400}}intervalChanged_(e,t,n){const o=this.parameterPositions;let r=e-2,i=e+1,a=o[r],s=o[i];if(void 0===a)switch(this.getSettings_().endingStart){case 2401:r=e,a=2*t-n;break;case 2402:r=o.length-2,a=t+o[r]-o[r+1];break;default:r=e,a=n}if(void 0===s)switch(this.getSettings_().endingEnd){case 2401:i=e,s=2*n-t;break;case 2402:i=1,s=n+o[1]-o[0];break;default:i=e-1,s=t}const l=.5*(n-t),c=this.valueSize;this._weightPrev=l/(t-a),this._weightNext=l/(s-n),this._offsetPrev=r*c,this._offsetNext=i*c}interpolate_(e,t,n,o){const r=this.resultBuffer,i=this.sampleValues,a=this.valueSize,s=e*a,l=s-a,c=this._offsetPrev,u=this._offsetNext,d=this._weightPrev,h=this._weightNext,p=(n-t)/(o-t),f=p*p,m=f*p,g=-d*m+2*d*f-d*p,_=(1+d)*m+(-1.5-2*d)*f+(-.5+d)*p+1,A=(-1-h)*m+(1.5+h)*f+.5*p,v=h*m-h*f;for(let e=0;e!==a;++e)r[e]=g*i[c+e]+_*i[l+e]+A*i[s+e]+v*i[u+e];return r}}function arraySlice(e,t,n){return isTypedArray(e)?new e.constructor(e.subarray(t,void 0!==n?n:e.length)):e.slice(t,n)}function convertArray(e,t,n){return!e||!n&&e.constructor===t?e:"number"==typeof t.BYTES_PER_ELEMENT?new t(e):Array.prototype.slice.call(e)}function isTypedArray(e){return ArrayBuffer.isView(e)&&!(e instanceof DataView)}function getKeyframeOrder(e){const t=e.length,n=new Array(t);for(let e=0;e!==t;++e)n[e]=e;return n.sort(function(t,n){return e[t]-e[n]}),n}function sortedArray(e,t,n){const o=e.length,r=new e.constructor(o);for(let i=0,a=0;a!==o;++i){const o=n[i]*t;for(let n=0;n!==t;++n)r[a++]=e[o+n]}return r}function flattenJSON(e,t,n,o){let r=1,i=e[0];for(;void 0!==i&&void 0===i[o];)i=e[r++];if(void 0===i)return;let a=i[o];if(void 0!==a)if(Array.isArray(a))do{a=i[o],void 0!==a&&(t.push(i.time),n.push.apply(n,a)),i=e[r++]}while(void 0!==i);else if(void 0!==a.toArray)do{a=i[o],void 0!==